/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.ts;

import android.util.SparseArray;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.extractor.PositionHolder;
import com.google.android.exoplayer2.extractor.SeekMap;
import com.google.android.exoplayer2.extractor.ts.Ac3Reader;
import com.google.android.exoplayer2.extractor.ts.ElementaryStreamReader;
import com.google.android.exoplayer2.extractor.ts.H262Reader;
import com.google.android.exoplayer2.extractor.ts.MpegAudioReader;
import com.google.android.exoplayer2.extractor.ts.PsBinarySearchSeeker;
import com.google.android.exoplayer2.extractor.ts.PsDurationReader;
import com.google.android.exoplayer2.extractor.ts.TsPayloadReader;
import com.google.android.exoplayer2.extractor.ts._$$Lambda$PsExtractor$U8l9TedlJUwsYwV9EOSFo_ngcXY;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ParsableBitArray;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.TimestampAdjuster;
import java.io.IOException;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

public final class PsExtractor
implements Extractor {
    public static final int AUDIO_STREAM = 192;
    public static final int AUDIO_STREAM_MASK = 224;
    public static final ExtractorsFactory FACTORY = _$$Lambda$PsExtractor$U8l9TedlJUwsYwV9EOSFo_ngcXY.INSTANCE;
    private static final long MAX_SEARCH_LENGTH = 0x100000L;
    private static final long MAX_SEARCH_LENGTH_AFTER_AUDIO_AND_VIDEO_FOUND = 8192L;
    private static final int MAX_STREAM_ID_PLUS_ONE = 256;
    static final int MPEG_PROGRAM_END_CODE = 441;
    static final int PACKET_START_CODE_PREFIX = 1;
    static final int PACK_START_CODE = 442;
    public static final int PRIVATE_STREAM_1 = 189;
    static final int SYSTEM_HEADER_START_CODE = 443;
    public static final int VIDEO_STREAM = 224;
    public static final int VIDEO_STREAM_MASK = 240;
    private final PsDurationReader durationReader;
    private boolean foundAllTracks;
    private boolean foundAudioTrack;
    private boolean foundVideoTrack;
    private boolean hasOutputSeekMap;
    private long lastTrackPosition;
    private ExtractorOutput output;
    private PsBinarySearchSeeker psBinarySearchSeeker;
    private final ParsableByteArray psPacketBuffer;
    private final SparseArray<PesReader> psPayloadReaders;
    private final TimestampAdjuster timestampAdjuster;

    public PsExtractor() {
        this(new TimestampAdjuster(0L));
    }

    public PsExtractor(TimestampAdjuster timestampAdjuster) {
        this.timestampAdjuster = timestampAdjuster;
        this.psPacketBuffer = new ParsableByteArray(4096);
        this.psPayloadReaders = new SparseArray();
        this.durationReader = new PsDurationReader();
    }

    static /* synthetic */ Extractor[] lambda$static$0() {
        return new Extractor[]{new PsExtractor()};
    }

    @RequiresNonNull(value={"output"})
    private void maybeOutputSeekMap(long l2) {
        if (!this.hasOutputSeekMap) {
            this.hasOutputSeekMap = true;
            if (this.durationReader.getDurationUs() != -9223372036854775807L) {
                this.psBinarySearchSeeker = new PsBinarySearchSeeker(this.durationReader.getScrTimestampAdjuster(), this.durationReader.getDurationUs(), l2);
                this.output.seekMap(this.psBinarySearchSeeker.getSeekMap());
            } else {
                this.output.seekMap(new SeekMap.Unseekable(this.durationReader.getDurationUs()));
            }
        }
    }

    @Override
    public void init(ExtractorOutput extractorOutput) {
        this.output = extractorOutput;
    }

    @Override
    public int read(ExtractorInput extractorInput, PositionHolder object) throws IOException {
        Assertions.checkStateNotNull(this.output);
        long l2 = extractorInput.getLength();
        int n2 = l2 != -1L ? 1 : 0;
        if (n2 != 0 && !this.durationReader.isDurationReadFinished()) {
            return this.durationReader.readDuration(extractorInput, (PositionHolder)object);
        }
        this.maybeOutputSeekMap(l2);
        Object object2 = this.psBinarySearchSeeker;
        if (object2 != null && object2.isSeeking()) {
            return this.psBinarySearchSeeker.handlePendingSeek(extractorInput, (PositionHolder)object);
        }
        extractorInput.resetPeekPosition();
        l2 = l2 != -1L ? (l2 -= extractorInput.getPeekPosition()) : -1L;
        if (l2 != -1L && l2 < 4L) {
            return -1;
        }
        if (!extractorInput.peekFully(this.psPacketBuffer.getData(), 0, 4, true)) {
            return -1;
        }
        this.psPacketBuffer.setPosition(0);
        n2 = this.psPacketBuffer.readInt();
        if (n2 == 441) {
            return -1;
        }
        if (n2 == 442) {
            extractorInput.peekFully(this.psPacketBuffer.getData(), 0, 10);
            this.psPacketBuffer.setPosition(9);
            extractorInput.skipFully((this.psPacketBuffer.readUnsignedByte() & 7) + 14);
            return 0;
        }
        if (n2 == 443) {
            extractorInput.peekFully(this.psPacketBuffer.getData(), 0, 2);
            this.psPacketBuffer.setPosition(0);
            extractorInput.skipFully(this.psPacketBuffer.readUnsignedShort() + 6);
            return 0;
        }
        if ((n2 & 0xFFFFFF00) >> 8 != 1) {
            extractorInput.skipFully(1);
            return 0;
        }
        PesReader pesReader = (PesReader)this.psPayloadReaders.get(n2 &= 0xFF);
        object = pesReader;
        if (!this.foundAllTracks) {
            object2 = pesReader;
            if (pesReader == null) {
                object = null;
                if (n2 == 189) {
                    object = new Ac3Reader();
                    this.foundAudioTrack = true;
                    this.lastTrackPosition = extractorInput.getPosition();
                } else if ((n2 & 0xE0) == 192) {
                    object = new MpegAudioReader();
                    this.foundAudioTrack = true;
                    this.lastTrackPosition = extractorInput.getPosition();
                } else if ((n2 & 0xF0) == 224) {
                    object = new H262Reader();
                    this.foundVideoTrack = true;
                    this.lastTrackPosition = extractorInput.getPosition();
                }
                object2 = pesReader;
                if (object != null) {
                    object2 = new TsPayloadReader.TrackIdGenerator(n2, 256);
                    object.createTracks(this.output, (TsPayloadReader.TrackIdGenerator)object2);
                    object2 = new PesReader((ElementaryStreamReader)object, this.timestampAdjuster);
                    this.psPayloadReaders.put(n2, object2);
                }
            }
            l2 = this.foundAudioTrack && this.foundVideoTrack ? this.lastTrackPosition + 8192L : 0x100000L;
            object = object2;
            if (extractorInput.getPosition() > l2) {
                this.foundAllTracks = true;
                this.output.endTracks();
                object = object2;
            }
        }
        extractorInput.peekFully(this.psPacketBuffer.getData(), 0, 2);
        this.psPacketBuffer.setPosition(0);
        n2 = this.psPacketBuffer.readUnsignedShort() + 6;
        if (object == null) {
            extractorInput.skipFully(n2);
        } else {
            this.psPacketBuffer.reset(n2);
            extractorInput.readFully(this.psPacketBuffer.getData(), 0, n2);
            this.psPacketBuffer.setPosition(6);
            ((PesReader)object).consume(this.psPacketBuffer);
            extractorInput = this.psPacketBuffer;
            extractorInput.setLimit(extractorInput.capacity());
        }
        return 0;
    }

    @Override
    public void release() {
    }

    @Override
    public void seek(long l2, long l3) {
        l2 = this.timestampAdjuster.getTimestampOffsetUs();
        int n2 = 0;
        int n3 = l2 == -9223372036854775807L ? 1 : 0;
        if (n3 != 0 || this.timestampAdjuster.getFirstSampleTimestampUs() != 0L && this.timestampAdjuster.getFirstSampleTimestampUs() != l3) {
            this.timestampAdjuster.reset(l3);
        }
        PsBinarySearchSeeker psBinarySearchSeeker = this.psBinarySearchSeeker;
        n3 = n2;
        if (psBinarySearchSeeker != null) {
            psBinarySearchSeeker.setSeekTargetUs(l3);
            n3 = n2;
        }
        while (n3 < this.psPayloadReaders.size()) {
            ((PesReader)this.psPayloadReaders.valueAt(n3)).seek();
            ++n3;
        }
    }

    @Override
    public boolean sniff(ExtractorInput extractorInput) throws IOException {
        byte[] byArray = new byte[14];
        boolean bl = false;
        extractorInput.peekFully(byArray, 0, 14);
        if (442 != ((byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF)) {
            return false;
        }
        if ((byArray[4] & 0xC4) != 68) {
            return false;
        }
        if ((byArray[6] & 4) != 4) {
            return false;
        }
        if ((byArray[8] & 4) != 4) {
            return false;
        }
        if ((byArray[9] & 1) != 1) {
            return false;
        }
        if ((byArray[12] & 3) != 3) {
            return false;
        }
        extractorInput.advancePeekPosition(byArray[13] & 7);
        extractorInput.peekFully(byArray, 0, 3);
        if (1 == ((byArray[0] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[2] & 0xFF)) {
            bl = true;
        }
        return bl;
    }

    private static final class PesReader {
        private static final int PES_SCRATCH_SIZE = 64;
        private boolean dtsFlag;
        private int extendedHeaderLength;
        private final ElementaryStreamReader pesPayloadReader;
        private final ParsableBitArray pesScratch;
        private boolean ptsFlag;
        private boolean seenFirstDts;
        private long timeUs;
        private final TimestampAdjuster timestampAdjuster;

        public PesReader(ElementaryStreamReader elementaryStreamReader, TimestampAdjuster timestampAdjuster) {
            this.pesPayloadReader = elementaryStreamReader;
            this.timestampAdjuster = timestampAdjuster;
            this.pesScratch = new ParsableBitArray(new byte[64]);
        }

        private void parseHeader() {
            this.pesScratch.skipBits(8);
            this.ptsFlag = this.pesScratch.readBit();
            this.dtsFlag = this.pesScratch.readBit();
            this.pesScratch.skipBits(6);
            this.extendedHeaderLength = this.pesScratch.readBits(8);
        }

        private void parseHeaderExtension() {
            this.timeUs = 0L;
            if (this.ptsFlag) {
                this.pesScratch.skipBits(4);
                long l2 = this.pesScratch.readBits(3);
                this.pesScratch.skipBits(1);
                long l3 = this.pesScratch.readBits(15) << 15;
                this.pesScratch.skipBits(1);
                long l4 = this.pesScratch.readBits(15);
                this.pesScratch.skipBits(1);
                if (!this.seenFirstDts && this.dtsFlag) {
                    this.pesScratch.skipBits(4);
                    long l5 = this.pesScratch.readBits(3);
                    this.pesScratch.skipBits(1);
                    long l6 = this.pesScratch.readBits(15) << 15;
                    this.pesScratch.skipBits(1);
                    long l7 = this.pesScratch.readBits(15);
                    this.pesScratch.skipBits(1);
                    this.timestampAdjuster.adjustTsTimestamp(l5 << 30 | l6 | l7);
                    this.seenFirstDts = true;
                }
                this.timeUs = this.timestampAdjuster.adjustTsTimestamp(l2 << 30 | l3 | l4);
            }
        }

        public void consume(ParsableByteArray parsableByteArray) throws ParserException {
            parsableByteArray.readBytes(this.pesScratch.data, 0, 3);
            this.pesScratch.setPosition(0);
            this.parseHeader();
            parsableByteArray.readBytes(this.pesScratch.data, 0, this.extendedHeaderLength);
            this.pesScratch.setPosition(0);
            this.parseHeaderExtension();
            this.pesPayloadReader.packetStarted(this.timeUs, 4);
            this.pesPayloadReader.consume(parsableByteArray);
            this.pesPayloadReader.packetFinished();
        }

        public void seek() {
            this.seenFirstDts = false;
            this.pesPayloadReader.seek();
        }
    }
}

