/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.ts;

import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.ts.ElementaryStreamReader;
import com.google.android.exoplayer2.extractor.ts.TsPayloadReader;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.ParsableBitArray;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.TimestampAdjuster;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

public final class PesReader
implements TsPayloadReader {
    private static final int HEADER_SIZE = 9;
    private static final int MAX_HEADER_EXTENSION_SIZE = 10;
    private static final int PES_SCRATCH_SIZE = 10;
    private static final int STATE_FINDING_HEADER = 0;
    private static final int STATE_READING_BODY = 3;
    private static final int STATE_READING_HEADER = 1;
    private static final int STATE_READING_HEADER_EXTENSION = 2;
    private static final String TAG = "PesReader";
    private int bytesRead;
    private boolean dataAlignmentIndicator;
    private boolean dtsFlag;
    private int extendedHeaderLength;
    private int payloadSize;
    private final ParsableBitArray pesScratch;
    private boolean ptsFlag;
    private final ElementaryStreamReader reader;
    private boolean seenFirstDts;
    private int state;
    private long timeUs;
    private TimestampAdjuster timestampAdjuster;

    public PesReader(ElementaryStreamReader elementaryStreamReader) {
        this.reader = elementaryStreamReader;
        this.pesScratch = new ParsableBitArray(new byte[10]);
        this.state = 0;
    }

    private boolean continueRead(ParsableByteArray parsableByteArray, byte[] byArray, int n2) {
        int n3 = Math.min(parsableByteArray.bytesLeft(), n2 - this.bytesRead);
        boolean bl = true;
        if (n3 <= 0) {
            return true;
        }
        if (byArray == null) {
            parsableByteArray.skipBytes(n3);
        } else {
            parsableByteArray.readBytes(byArray, this.bytesRead, n3);
        }
        this.bytesRead += n3;
        if (this.bytesRead != n2) {
            bl = false;
        }
        return bl;
    }

    private boolean parseHeader() {
        this.pesScratch.setPosition(0);
        int n2 = this.pesScratch.readBits(24);
        if (n2 != 1) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Unexpected start code prefix: ");
            stringBuilder.append(n2);
            Log.w(TAG, stringBuilder.toString());
            this.payloadSize = -1;
            return false;
        }
        this.pesScratch.skipBits(8);
        n2 = this.pesScratch.readBits(16);
        this.pesScratch.skipBits(5);
        this.dataAlignmentIndicator = this.pesScratch.readBit();
        this.pesScratch.skipBits(2);
        this.ptsFlag = this.pesScratch.readBit();
        this.dtsFlag = this.pesScratch.readBit();
        this.pesScratch.skipBits(6);
        this.extendedHeaderLength = this.pesScratch.readBits(8);
        if (n2 == 0) {
            this.payloadSize = -1;
        } else {
            this.payloadSize = n2 + 6 - 9 - this.extendedHeaderLength;
            if (this.payloadSize < 0) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Found negative packet payload size: ");
                stringBuilder.append(this.payloadSize);
                Log.w(TAG, stringBuilder.toString());
                this.payloadSize = -1;
            }
        }
        return true;
    }

    @RequiresNonNull(value={"timestampAdjuster"})
    private void parseHeaderExtension() {
        this.pesScratch.setPosition(0);
        this.timeUs = -9223372036854775807L;
        if (this.ptsFlag) {
            this.pesScratch.skipBits(4);
            long l2 = this.pesScratch.readBits(3);
            this.pesScratch.skipBits(1);
            long l3 = this.pesScratch.readBits(15) << 15;
            this.pesScratch.skipBits(1);
            long l4 = this.pesScratch.readBits(15);
            this.pesScratch.skipBits(1);
            if (!this.seenFirstDts && this.dtsFlag) {
                this.pesScratch.skipBits(4);
                long l5 = this.pesScratch.readBits(3);
                this.pesScratch.skipBits(1);
                long l6 = this.pesScratch.readBits(15) << 15;
                this.pesScratch.skipBits(1);
                long l7 = this.pesScratch.readBits(15);
                this.pesScratch.skipBits(1);
                this.timestampAdjuster.adjustTsTimestamp(l5 << 30 | l6 | l7);
                this.seenFirstDts = true;
            }
            this.timeUs = this.timestampAdjuster.adjustTsTimestamp(l2 << 30 | l3 | l4);
        }
    }

    private void setState(int n2) {
        this.state = n2;
        this.bytesRead = 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void consume(ParsableByteArray parsableByteArray, int n2) throws ParserException {
        Assertions.checkStateNotNull(this.timestampAdjuster);
        int n3 = n2;
        if ((n2 & 1) != 0) {
            n3 = this.state;
            if (n3 != 0 && n3 != 1) {
                if (n3 != 2) {
                    if (n3 != 3) throw new IllegalStateException();
                    if (this.payloadSize != -1) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("Unexpected start indicator: expected ");
                        stringBuilder.append(this.payloadSize);
                        stringBuilder.append(" more bytes");
                        Log.w(TAG, stringBuilder.toString());
                    }
                    this.reader.packetFinished();
                } else {
                    Log.w(TAG, "Unexpected start indicator reading extended header");
                }
            }
            this.setState(1);
            n3 = n2;
        }
        while (parsableByteArray.bytesLeft() > 0) {
            int n4 = this.state;
            if (n4 != 0) {
                n2 = 0;
                int n5 = 0;
                int n6 = 0;
                if (n4 != 1) {
                    if (n4 != 2) {
                        if (n4 != 3) throw new IllegalStateException();
                        n5 = parsableByteArray.bytesLeft();
                        n2 = this.payloadSize;
                        if (n2 != -1) {
                            n6 = n5 - n2;
                        }
                        n2 = n5;
                        if (n6 > 0) {
                            n2 = n5 - n6;
                            parsableByteArray.setLimit(parsableByteArray.getPosition() + n2);
                        }
                        this.reader.consume(parsableByteArray);
                        n6 = this.payloadSize;
                        if (n6 == -1) continue;
                        this.payloadSize = n6 - n2;
                        if (this.payloadSize != 0) continue;
                        this.reader.packetFinished();
                        this.setState(1);
                        continue;
                    }
                    n6 = Math.min(10, this.extendedHeaderLength);
                    if (!this.continueRead(parsableByteArray, this.pesScratch.data, n6) || !this.continueRead(parsableByteArray, null, this.extendedHeaderLength)) continue;
                    this.parseHeaderExtension();
                    if (this.dataAlignmentIndicator) {
                        n2 = 4;
                    }
                    this.reader.packetStarted(this.timeUs, n3 |= n2);
                    this.setState(3);
                    continue;
                }
                if (!this.continueRead(parsableByteArray, this.pesScratch.data, 9)) continue;
                n2 = n5;
                if (this.parseHeader()) {
                    n2 = 2;
                }
                this.setState(n2);
                continue;
            }
            parsableByteArray.skipBytes(parsableByteArray.bytesLeft());
        }
    }

    @Override
    public void init(TimestampAdjuster timestampAdjuster, ExtractorOutput extractorOutput, TsPayloadReader.TrackIdGenerator trackIdGenerator) {
        this.timestampAdjuster = timestampAdjuster;
        this.reader.createTracks(extractorOutput, trackIdGenerator);
    }

    @Override
    public final void seek() {
        this.state = 0;
        this.bytesRead = 0;
        this.seenFirstDts = false;
        this.reader.seek();
    }
}

