/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.ts;

import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.extractor.ts.SectionPayloadReader;
import com.google.android.exoplayer2.extractor.ts.TsPayloadReader;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.TimestampAdjuster;
import com.google.android.exoplayer2.util.Util;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

public final class PassthroughSectionPayloadReader
implements SectionPayloadReader {
    private Format format;
    private TrackOutput output;
    private TimestampAdjuster timestampAdjuster;

    public PassthroughSectionPayloadReader(String string2) {
        this.format = new Format.Builder().setSampleMimeType(string2).build();
    }

    @EnsuresNonNull(value={"timestampAdjuster", "output"})
    private void assertInitialized() {
        Assertions.checkStateNotNull(this.timestampAdjuster);
        Util.castNonNull(this.output);
    }

    @Override
    public void consume(ParsableByteArray parsableByteArray) {
        this.assertInitialized();
        long l2 = this.timestampAdjuster.getTimestampOffsetUs();
        if (l2 == -9223372036854775807L) {
            return;
        }
        if (l2 != this.format.subsampleOffsetUs) {
            this.format = this.format.buildUpon().setSubsampleOffsetUs(l2).build();
            this.output.format(this.format);
        }
        int n2 = parsableByteArray.bytesLeft();
        this.output.sampleData(parsableByteArray, n2);
        this.output.sampleMetadata(this.timestampAdjuster.getLastAdjustedTimestampUs(), 1, n2, 0, null);
    }

    @Override
    public void init(TimestampAdjuster timestampAdjuster, ExtractorOutput extractorOutput, TsPayloadReader.TrackIdGenerator trackIdGenerator) {
        this.timestampAdjuster = timestampAdjuster;
        trackIdGenerator.generateNewId();
        this.output = extractorOutput.track(trackIdGenerator.getTrackId(), 5);
        this.output.format(this.format);
    }
}

