/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.ts;

import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.audio.MpegAudioUtil;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.extractor.ts.ElementaryStreamReader;
import com.google.android.exoplayer2.extractor.ts.TsPayloadReader;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ParsableByteArray;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

public final class MpegAudioReader
implements ElementaryStreamReader {
    private static final int HEADER_SIZE = 4;
    private static final int STATE_FINDING_HEADER = 0;
    private static final int STATE_READING_FRAME = 2;
    private static final int STATE_READING_HEADER = 1;
    private String formatId;
    private int frameBytesRead;
    private long frameDurationUs;
    private int frameSize;
    private boolean hasOutputFormat;
    private final MpegAudioUtil.Header header;
    private final ParsableByteArray headerScratch = new ParsableByteArray(4);
    private final String language;
    private boolean lastByteWasFF;
    private TrackOutput output;
    private int state = 0;
    private long timeUs;

    public MpegAudioReader() {
        this(null);
    }

    public MpegAudioReader(String string2) {
        this.headerScratch.getData()[0] = (byte)-1;
        this.header = new MpegAudioUtil.Header();
        this.language = string2;
    }

    private void findHeader(ParsableByteArray parsableByteArray) {
        byte[] byArray = parsableByteArray.getData();
        int n2 = parsableByteArray.limit();
        for (int i2 = parsableByteArray.getPosition(); i2 < n2; ++i2) {
            boolean bl = (byArray[i2] & 0xFF) == 255;
            boolean bl2 = this.lastByteWasFF && (byArray[i2] & 0xE0) == 224;
            this.lastByteWasFF = bl;
            if (!bl2) continue;
            parsableByteArray.setPosition(i2 + 1);
            this.lastByteWasFF = false;
            this.headerScratch.getData()[1] = byArray[i2];
            this.frameBytesRead = 2;
            this.state = 1;
            return;
        }
        parsableByteArray.setPosition(n2);
    }

    @RequiresNonNull(value={"output"})
    private void readFrameRemainder(ParsableByteArray parsableByteArray) {
        int n2 = Math.min(parsableByteArray.bytesLeft(), this.frameSize - this.frameBytesRead);
        this.output.sampleData(parsableByteArray, n2);
        this.frameBytesRead += n2;
        int n3 = this.frameBytesRead;
        n2 = this.frameSize;
        if (n3 < n2) {
            return;
        }
        this.output.sampleMetadata(this.timeUs, 1, n2, 0, null);
        this.timeUs += this.frameDurationUs;
        this.frameBytesRead = 0;
        this.state = 0;
    }

    @RequiresNonNull(value={"output"})
    private void readHeaderRemainder(ParsableByteArray parsableByteArray) {
        int n2 = Math.min(parsableByteArray.bytesLeft(), 4 - this.frameBytesRead);
        parsableByteArray.readBytes(this.headerScratch.getData(), this.frameBytesRead, n2);
        this.frameBytesRead += n2;
        if (this.frameBytesRead < 4) {
            return;
        }
        this.headerScratch.setPosition(0);
        if (!this.header.setForHeaderData(this.headerScratch.readInt())) {
            this.frameBytesRead = 0;
            this.state = 1;
            return;
        }
        this.frameSize = this.header.frameSize;
        if (!this.hasOutputFormat) {
            this.frameDurationUs = (long)this.header.samplesPerFrame * 1000000L / (long)this.header.sampleRate;
            parsableByteArray = new Format.Builder().setId(this.formatId).setSampleMimeType(this.header.mimeType).setMaxInputSize(4096).setChannelCount(this.header.channels).setSampleRate(this.header.sampleRate).setLanguage(this.language).build();
            this.output.format((Format)parsableByteArray);
            this.hasOutputFormat = true;
        }
        this.headerScratch.setPosition(0);
        this.output.sampleData(this.headerScratch, 4);
        this.state = 2;
    }

    @Override
    public void consume(ParsableByteArray parsableByteArray) {
        Assertions.checkStateNotNull(this.output);
        while (parsableByteArray.bytesLeft() > 0) {
            int n2 = this.state;
            if (n2 != 0) {
                if (n2 != 1) {
                    if (n2 == 2) {
                        this.readFrameRemainder(parsableByteArray);
                        continue;
                    }
                    throw new IllegalStateException();
                }
                this.readHeaderRemainder(parsableByteArray);
                continue;
            }
            this.findHeader(parsableByteArray);
        }
    }

    @Override
    public void createTracks(ExtractorOutput extractorOutput, TsPayloadReader.TrackIdGenerator trackIdGenerator) {
        trackIdGenerator.generateNewId();
        this.formatId = trackIdGenerator.getFormatId();
        this.output = extractorOutput.track(trackIdGenerator.getTrackId(), 1);
    }

    @Override
    public void packetFinished() {
    }

    @Override
    public void packetStarted(long l2, int n2) {
        this.timeUs = l2;
    }

    @Override
    public void seek() {
        this.state = 0;
        this.frameBytesRead = 0;
        this.lastByteWasFF = false;
    }
}

