/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.ts;

import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.audio.AacUtil;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.extractor.ts.ElementaryStreamReader;
import com.google.android.exoplayer2.extractor.ts.TsPayloadReader;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ParsableBitArray;
import com.google.android.exoplayer2.util.ParsableByteArray;
import java.util.Collections;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

public final class LatmReader
implements ElementaryStreamReader {
    private static final int INITIAL_BUFFER_SIZE = 1024;
    private static final int STATE_FINDING_SYNC_1 = 0;
    private static final int STATE_FINDING_SYNC_2 = 1;
    private static final int STATE_READING_HEADER = 2;
    private static final int STATE_READING_SAMPLE = 3;
    private static final int SYNC_BYTE_FIRST = 86;
    private static final int SYNC_BYTE_SECOND = 224;
    private int audioMuxVersionA;
    private int bytesRead;
    private int channelCount;
    private String codecs;
    private Format format;
    private String formatId;
    private int frameLengthType;
    private final String language;
    private int numSubframes;
    private long otherDataLenBits;
    private boolean otherDataPresent;
    private TrackOutput output;
    private final ParsableBitArray sampleBitArray;
    private final ParsableByteArray sampleDataBuffer;
    private long sampleDurationUs;
    private int sampleRateHz;
    private int sampleSize;
    private int secondHeaderByte;
    private int state;
    private boolean streamMuxRead;
    private long timeUs;

    public LatmReader(String string2) {
        this.language = string2;
        this.sampleDataBuffer = new ParsableByteArray(1024);
        this.sampleBitArray = new ParsableBitArray(this.sampleDataBuffer.getData());
    }

    private static long latmGetValue(ParsableBitArray parsableBitArray) {
        return parsableBitArray.readBits((parsableBitArray.readBits(2) + 1) * 8);
    }

    @RequiresNonNull(value={"output"})
    private void parseAudioMuxElement(ParsableBitArray parsableBitArray) throws ParserException {
        if (!parsableBitArray.readBit()) {
            this.streamMuxRead = true;
            this.parseStreamMuxConfig(parsableBitArray);
        } else if (!this.streamMuxRead) {
            return;
        }
        if (this.audioMuxVersionA == 0) {
            if (this.numSubframes == 0) {
                this.parsePayloadMux(parsableBitArray, this.parsePayloadLengthInfo(parsableBitArray));
                if (this.otherDataPresent) {
                    parsableBitArray.skipBits((int)this.otherDataLenBits);
                }
                return;
            }
            throw new ParserException();
        }
        throw new ParserException();
    }

    private int parseAudioSpecificConfig(ParsableBitArray parsableBitArray) throws ParserException {
        int n2 = parsableBitArray.bitsLeft();
        AacUtil.Config config = AacUtil.parseAudioSpecificConfig(parsableBitArray, true);
        this.codecs = config.codecs;
        this.sampleRateHz = config.sampleRateHz;
        this.channelCount = config.channelCount;
        return n2 - parsableBitArray.bitsLeft();
    }

    private void parseFrameLength(ParsableBitArray parsableBitArray) {
        this.frameLengthType = parsableBitArray.readBits(3);
        int n2 = this.frameLengthType;
        if (n2 != 0) {
            if (n2 != 1) {
                if (n2 != 3 && n2 != 4 && n2 != 5) {
                    if (n2 != 6 && n2 != 7) {
                        throw new IllegalStateException();
                    }
                    parsableBitArray.skipBits(1);
                } else {
                    parsableBitArray.skipBits(6);
                }
            } else {
                parsableBitArray.skipBits(9);
            }
        } else {
            parsableBitArray.skipBits(8);
        }
    }

    private int parsePayloadLengthInfo(ParsableBitArray object) throws ParserException {
        if (this.frameLengthType == 0) {
            int n2;
            int n3;
            int n4 = 0;
            do {
                n3 = object.readBits(8);
                n4 = n2 = n4 + n3;
            } while (n3 == 255);
            return n2;
        }
        object = new ParserException();
        throw object;
    }

    @RequiresNonNull(value={"output"})
    private void parsePayloadMux(ParsableBitArray parsableBitArray, int n2) {
        int n3 = parsableBitArray.getPosition();
        if ((n3 & 7) == 0) {
            this.sampleDataBuffer.setPosition(n3 >> 3);
        } else {
            parsableBitArray.readBits(this.sampleDataBuffer.getData(), 0, n2 * 8);
            this.sampleDataBuffer.setPosition(0);
        }
        this.output.sampleData(this.sampleDataBuffer, n2);
        this.output.sampleMetadata(this.timeUs, 1, n2, 0, null);
        this.timeUs += this.sampleDurationUs;
    }

    @RequiresNonNull(value={"output"})
    private void parseStreamMuxConfig(ParsableBitArray object) throws ParserException {
        int n2 = object.readBits(1);
        int n3 = n2 == 1 ? object.readBits(1) : 0;
        this.audioMuxVersionA = n3;
        if (this.audioMuxVersionA == 0) {
            if (n2 == 1) {
                LatmReader.latmGetValue(object);
            }
            if (object.readBit()) {
                this.numSubframes = object.readBits(6);
                int n4 = object.readBits(4);
                n3 = object.readBits(3);
                if (n4 == 0 && n3 == 0) {
                    if (n2 == 0) {
                        n4 = object.getPosition();
                        n3 = this.parseAudioSpecificConfig((ParsableBitArray)object);
                        object.setPosition(n4);
                        Object object2 = new byte[(n3 + 7) / 8];
                        object.readBits(object2, 0, n3);
                        object2 = new Format.Builder().setId(this.formatId).setSampleMimeType("audio/mp4a-latm").setCodecs(this.codecs).setChannelCount(this.channelCount).setSampleRate(this.sampleRateHz).setInitializationData(Collections.singletonList(object2)).setLanguage(this.language).build();
                        if (!object2.equals((Object)this.format)) {
                            this.format = (Format)object2;
                            this.sampleDurationUs = 1024000000L / (long)object2.sampleRate;
                            this.output.format((Format)object2);
                        }
                    } else {
                        object.skipBits((int)LatmReader.latmGetValue(object) - this.parseAudioSpecificConfig((ParsableBitArray)object));
                    }
                    this.parseFrameLength((ParsableBitArray)object);
                    this.otherDataPresent = object.readBit();
                    this.otherDataLenBits = 0L;
                    if (this.otherDataPresent) {
                        if (n2 == 1) {
                            this.otherDataLenBits = LatmReader.latmGetValue(object);
                        } else {
                            boolean bl;
                            do {
                                bl = object.readBit();
                                this.otherDataLenBits = (this.otherDataLenBits << 8) + (long)object.readBits(8);
                            } while (bl);
                        }
                    }
                    if (object.readBit()) {
                        object.skipBits(8);
                    }
                    return;
                }
                throw new ParserException();
            }
            throw new ParserException();
        }
        object = new ParserException();
        throw object;
    }

    private void resetBufferForSize(int n2) {
        this.sampleDataBuffer.reset(n2);
        this.sampleBitArray.reset(this.sampleDataBuffer.getData());
    }

    @Override
    public void consume(ParsableByteArray parsableByteArray) throws ParserException {
        Assertions.checkStateNotNull(this.output);
        while (parsableByteArray.bytesLeft() > 0) {
            int n2 = this.state;
            if (n2 != 0) {
                if (n2 != 1) {
                    if (n2 != 2) {
                        if (n2 == 3) {
                            n2 = Math.min(parsableByteArray.bytesLeft(), this.sampleSize - this.bytesRead);
                            parsableByteArray.readBytes(this.sampleBitArray.data, this.bytesRead, n2);
                            this.bytesRead += n2;
                            if (this.bytesRead != this.sampleSize) continue;
                            this.sampleBitArray.setPosition(0);
                            this.parseAudioMuxElement(this.sampleBitArray);
                            this.state = 0;
                            continue;
                        }
                        throw new IllegalStateException();
                    }
                    this.sampleSize = (this.secondHeaderByte & 0xFFFFFF1F) << 8 | parsableByteArray.readUnsignedByte();
                    if (this.sampleSize > this.sampleDataBuffer.getData().length) {
                        this.resetBufferForSize(this.sampleSize);
                    }
                    this.bytesRead = 0;
                    this.state = 3;
                    continue;
                }
                n2 = parsableByteArray.readUnsignedByte();
                if ((n2 & 0xE0) == 224) {
                    this.secondHeaderByte = n2;
                    this.state = 2;
                    continue;
                }
                if (n2 == 86) continue;
                this.state = 0;
                continue;
            }
            if (parsableByteArray.readUnsignedByte() != 86) continue;
            this.state = 1;
        }
    }

    @Override
    public void createTracks(ExtractorOutput extractorOutput, TsPayloadReader.TrackIdGenerator trackIdGenerator) {
        trackIdGenerator.generateNewId();
        this.output = extractorOutput.track(trackIdGenerator.getTrackId(), 1);
        this.formatId = trackIdGenerator.getFormatId();
    }

    @Override
    public void packetFinished() {
    }

    @Override
    public void packetStarted(long l2, int n2) {
        this.timeUs = l2;
    }

    @Override
    public void seek() {
        this.state = 0;
        this.streamMuxRead = false;
    }
}

