/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.ts;

import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.extractor.ts.ElementaryStreamReader;
import com.google.android.exoplayer2.extractor.ts.NalUnitTargetBuffer;
import com.google.android.exoplayer2.extractor.ts.SeiReader;
import com.google.android.exoplayer2.extractor.ts.TsPayloadReader;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.CodecSpecificDataUtil;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.NalUnitUtil;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.ParsableNalUnitBitArray;
import com.google.android.exoplayer2.util.Util;
import java.util.Collections;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

public final class H265Reader
implements ElementaryStreamReader {
    private static final int AUD_NUT = 35;
    private static final int BLA_W_LP = 16;
    private static final int CRA_NUT = 21;
    private static final int PPS_NUT = 34;
    private static final int PREFIX_SEI_NUT = 39;
    private static final int RASL_R = 9;
    private static final int SPS_NUT = 33;
    private static final int SUFFIX_SEI_NUT = 40;
    private static final String TAG = "H265Reader";
    private static final int VPS_NUT = 32;
    private String formatId;
    private boolean hasOutputFormat;
    private TrackOutput output;
    private long pesTimeUs;
    private final NalUnitTargetBuffer pps;
    private final boolean[] prefixFlags;
    private final NalUnitTargetBuffer prefixSei;
    private SampleReader sampleReader;
    private final SeiReader seiReader;
    private final ParsableByteArray seiWrapper;
    private final NalUnitTargetBuffer sps;
    private final NalUnitTargetBuffer suffixSei;
    private long totalBytesWritten;
    private final NalUnitTargetBuffer vps;

    public H265Reader(SeiReader seiReader) {
        this.seiReader = seiReader;
        this.prefixFlags = new boolean[3];
        this.vps = new NalUnitTargetBuffer(32, 128);
        this.sps = new NalUnitTargetBuffer(33, 128);
        this.pps = new NalUnitTargetBuffer(34, 128);
        this.prefixSei = new NalUnitTargetBuffer(39, 128);
        this.suffixSei = new NalUnitTargetBuffer(40, 128);
        this.seiWrapper = new ParsableByteArray();
    }

    @EnsuresNonNull(value={"output", "sampleReader"})
    private void assertTracksCreated() {
        Assertions.checkStateNotNull(this.output);
        Util.castNonNull(this.sampleReader);
    }

    @RequiresNonNull(value={"output", "sampleReader"})
    private void endNalUnit(long l2, int n2, int n3, long l3) {
        this.sampleReader.endNalUnit(l2, n2, this.hasOutputFormat);
        if (!this.hasOutputFormat) {
            this.vps.endNalUnit(n3);
            this.sps.endNalUnit(n3);
            this.pps.endNalUnit(n3);
            if (this.vps.isCompleted() && this.sps.isCompleted() && this.pps.isCompleted()) {
                this.output.format(H265Reader.parseMediaFormat(this.formatId, this.vps, this.sps, this.pps));
                this.hasOutputFormat = true;
            }
        }
        if (this.prefixSei.endNalUnit(n3)) {
            n2 = NalUnitUtil.unescapeStream((byte[])this.prefixSei.nalData, (int)this.prefixSei.nalLength);
            this.seiWrapper.reset(this.prefixSei.nalData, n2);
            this.seiWrapper.skipBytes(5);
            this.seiReader.consume(l3, this.seiWrapper);
        }
        if (this.suffixSei.endNalUnit(n3)) {
            n2 = NalUnitUtil.unescapeStream((byte[])this.suffixSei.nalData, (int)this.suffixSei.nalLength);
            this.seiWrapper.reset(this.suffixSei.nalData, n2);
            this.seiWrapper.skipBytes(5);
            this.seiReader.consume(l3, this.seiWrapper);
        }
    }

    @RequiresNonNull(value={"sampleReader"})
    private void nalUnitData(byte[] byArray, int n2, int n3) {
        this.sampleReader.readNalUnitData(byArray, n2, n3);
        if (!this.hasOutputFormat) {
            this.vps.appendToNalUnit(byArray, n2, n3);
            this.sps.appendToNalUnit(byArray, n2, n3);
            this.pps.appendToNalUnit(byArray, n2, n3);
        }
        this.prefixSei.appendToNalUnit(byArray, n2, n3);
        this.suffixSei.appendToNalUnit(byArray, n2, n3);
    }

    private static Format parseMediaFormat(String string2, NalUnitTargetBuffer object, NalUnitTargetBuffer nalUnitTargetBuffer, NalUnitTargetBuffer object2) {
        float f2;
        int n2;
        int n3;
        byte[] byArray = new byte[object.nalLength + nalUnitTargetBuffer.nalLength + ((NalUnitTargetBuffer)object2).nalLength];
        System.arraycopy(object.nalData, 0, byArray, 0, object.nalLength);
        System.arraycopy(nalUnitTargetBuffer.nalData, 0, byArray, object.nalLength, nalUnitTargetBuffer.nalLength);
        System.arraycopy(((NalUnitTargetBuffer)object2).nalData, 0, byArray, object.nalLength + nalUnitTargetBuffer.nalLength, ((NalUnitTargetBuffer)object2).nalLength);
        object = new ParsableNalUnitBitArray(nalUnitTargetBuffer.nalData, 0, nalUnitTargetBuffer.nalLength);
        object.skipBits(44);
        int n4 = object.readBits(3);
        object.skipBit();
        object.skipBits(88);
        object.skipBits(8);
        int n5 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = n5;
            if (object.readBit()) {
                n2 = n5 + 89;
            }
            n5 = n2;
            if (!object.readBit()) continue;
            n5 = n2 + 8;
        }
        object.skipBits(n5);
        if (n4 > 0) {
            object.skipBits((8 - n4) * 2);
        }
        object.readUnsignedExpGolombCodedInt();
        n2 = object.readUnsignedExpGolombCodedInt();
        if (n2 == 3) {
            object.skipBit();
        }
        int n6 = object.readUnsignedExpGolombCodedInt();
        int n7 = object.readUnsignedExpGolombCodedInt();
        n3 = n6;
        n5 = n7;
        if (object.readBit()) {
            n3 = object.readUnsignedExpGolombCodedInt();
            int n8 = object.readUnsignedExpGolombCodedInt();
            int n9 = object.readUnsignedExpGolombCodedInt();
            int n10 = object.readUnsignedExpGolombCodedInt();
            n5 = n2 != 1 && n2 != 2 ? 1 : 2;
            n2 = n2 == 1 ? 2 : 1;
            n3 = n6 - n5 * (n3 + n8);
            n5 = n7 - n2 * (n9 + n10);
        }
        object.readUnsignedExpGolombCodedInt();
        object.readUnsignedExpGolombCodedInt();
        n7 = object.readUnsignedExpGolombCodedInt();
        for (n2 = object.readBit() ? 0 : n4; n2 <= n4; ++n2) {
            object.readUnsignedExpGolombCodedInt();
            object.readUnsignedExpGolombCodedInt();
            object.readUnsignedExpGolombCodedInt();
        }
        object.readUnsignedExpGolombCodedInt();
        object.readUnsignedExpGolombCodedInt();
        object.readUnsignedExpGolombCodedInt();
        object.readUnsignedExpGolombCodedInt();
        object.readUnsignedExpGolombCodedInt();
        object.readUnsignedExpGolombCodedInt();
        if (object.readBit() && object.readBit()) {
            H265Reader.skipScalingList((ParsableNalUnitBitArray)object);
        }
        object.skipBits(2);
        if (object.readBit()) {
            object.skipBits(8);
            object.readUnsignedExpGolombCodedInt();
            object.readUnsignedExpGolombCodedInt();
            object.skipBit();
        }
        H265Reader.skipShortTermRefPicSets((ParsableNalUnitBitArray)object);
        if (object.readBit()) {
            for (n2 = 0; n2 < object.readUnsignedExpGolombCodedInt(); ++n2) {
                object.skipBits(n7 + 4 + 1);
            }
        }
        object.skipBits(2);
        float f3 = f2 = 1.0f;
        n2 = n5;
        if (object.readBit()) {
            float f4 = f2;
            if (object.readBit()) {
                n2 = object.readBits(8);
                if (n2 == 255) {
                    n2 = object.readBits(16);
                    n4 = object.readBits(16);
                    f4 = f2;
                    if (n2 != 0) {
                        f4 = f2;
                        if (n4 != 0) {
                            f4 = (float)n2 / (float)n4;
                        }
                    }
                } else if (n2 < NalUnitUtil.ASPECT_RATIO_IDC_VALUES.length) {
                    f4 = NalUnitUtil.ASPECT_RATIO_IDC_VALUES[n2];
                } else {
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("Unexpected aspect_ratio_idc value: ");
                    ((StringBuilder)object2).append(n2);
                    Log.w(TAG, ((StringBuilder)object2).toString());
                    f4 = f2;
                }
            }
            if (object.readBit()) {
                object.skipBit();
            }
            if (object.readBit()) {
                object.skipBits(4);
                if (object.readBit()) {
                    object.skipBits(24);
                }
            }
            if (object.readBit()) {
                object.readUnsignedExpGolombCodedInt();
                object.readUnsignedExpGolombCodedInt();
            }
            object.skipBit();
            f3 = f4;
            n2 = n5;
            if (object.readBit()) {
                n2 = n5 * 2;
                f3 = f4;
            }
        }
        object.reset(nalUnitTargetBuffer.nalData, 0, nalUnitTargetBuffer.nalLength);
        object.skipBits(24);
        object = CodecSpecificDataUtil.buildHevcCodecStringFromSps((ParsableNalUnitBitArray)object);
        return new Format.Builder().setId(string2).setSampleMimeType("video/hevc").setCodecs((String)object).setWidth(n3).setHeight(n2).setPixelWidthHeightRatio(f3).setInitializationData(Collections.singletonList(byArray)).build();
    }

    private static void skipScalingList(ParsableNalUnitBitArray parsableNalUnitBitArray) {
        for (int i2 = 0; i2 < 4; ++i2) {
            int n2;
            for (int i3 = 0; i3 < 6; i3 += n2) {
                if (!parsableNalUnitBitArray.readBit()) {
                    parsableNalUnitBitArray.readUnsignedExpGolombCodedInt();
                } else {
                    int n3 = Math.min(64, 1 << (i2 << 1) + 4);
                    if (i2 > 1) {
                        parsableNalUnitBitArray.readSignedExpGolombCodedInt();
                    }
                    for (n2 = 0; n2 < n3; ++n2) {
                        parsableNalUnitBitArray.readSignedExpGolombCodedInt();
                    }
                }
                n2 = 3;
                if (i2 == 3) continue;
                n2 = 1;
            }
        }
    }

    private static void skipShortTermRefPicSets(ParsableNalUnitBitArray parsableNalUnitBitArray) {
        int n2 = parsableNalUnitBitArray.readUnsignedExpGolombCodedInt();
        boolean bl = false;
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4;
            int n5;
            if (i2 != 0) {
                bl = parsableNalUnitBitArray.readBit();
            }
            if (bl) {
                parsableNalUnitBitArray.skipBit();
                parsableNalUnitBitArray.readUnsignedExpGolombCodedInt();
                n5 = 0;
                while (true) {
                    n4 = n3;
                    if (n5 <= n3) {
                        if (parsableNalUnitBitArray.readBit()) {
                            parsableNalUnitBitArray.skipBit();
                        }
                        ++n5;
                        continue;
                    }
                    break;
                }
            } else {
                n5 = parsableNalUnitBitArray.readUnsignedExpGolombCodedInt();
                n4 = parsableNalUnitBitArray.readUnsignedExpGolombCodedInt();
                for (n3 = 0; n3 < n5; ++n3) {
                    parsableNalUnitBitArray.readUnsignedExpGolombCodedInt();
                    parsableNalUnitBitArray.skipBit();
                }
                for (n3 = 0; n3 < n4; ++n3) {
                    parsableNalUnitBitArray.readUnsignedExpGolombCodedInt();
                    parsableNalUnitBitArray.skipBit();
                }
                n4 = n5 + n4;
            }
            n3 = n4;
        }
    }

    @RequiresNonNull(value={"sampleReader"})
    private void startNalUnit(long l2, int n2, int n3, long l3) {
        this.sampleReader.startNalUnit(l2, n2, n3, l3, this.hasOutputFormat);
        if (!this.hasOutputFormat) {
            this.vps.startNalUnit(n3);
            this.sps.startNalUnit(n3);
            this.pps.startNalUnit(n3);
        }
        this.prefixSei.startNalUnit(n3);
        this.suffixSei.startNalUnit(n3);
    }

    @Override
    public void consume(ParsableByteArray parsableByteArray) {
        this.assertTracksCreated();
        while (parsableByteArray.bytesLeft() > 0) {
            int n2 = parsableByteArray.getPosition();
            int n3 = parsableByteArray.limit();
            byte[] byArray = parsableByteArray.getData();
            this.totalBytesWritten += (long)parsableByteArray.bytesLeft();
            this.output.sampleData(parsableByteArray, parsableByteArray.bytesLeft());
            while (n2 < n3) {
                int n4 = NalUnitUtil.findNalUnit((byte[])byArray, (int)n2, (int)n3, (boolean[])this.prefixFlags);
                if (n4 == n3) {
                    this.nalUnitData(byArray, n2, n3);
                    return;
                }
                int n5 = NalUnitUtil.getH265NalUnitType((byte[])byArray, (int)n4);
                int n6 = n4 - n2;
                if (n6 > 0) {
                    this.nalUnitData(byArray, n2, n4);
                }
                int n7 = n3 - n4;
                long l2 = this.totalBytesWritten - (long)n7;
                n2 = n6 < 0 ? -n6 : 0;
                this.endNalUnit(l2, n7, n2, this.pesTimeUs);
                this.startNalUnit(l2, n7, n5, this.pesTimeUs);
                n2 = n4 + 3;
            }
        }
    }

    @Override
    public void createTracks(ExtractorOutput extractorOutput, TsPayloadReader.TrackIdGenerator trackIdGenerator) {
        trackIdGenerator.generateNewId();
        this.formatId = trackIdGenerator.getFormatId();
        this.output = extractorOutput.track(trackIdGenerator.getTrackId(), 2);
        this.sampleReader = new SampleReader(this.output);
        this.seiReader.createTracks(extractorOutput, trackIdGenerator);
    }

    @Override
    public void packetFinished() {
    }

    @Override
    public void packetStarted(long l2, int n2) {
        this.pesTimeUs = l2;
    }

    @Override
    public void seek() {
        this.totalBytesWritten = 0L;
        NalUnitUtil.clearPrefixFlags((boolean[])this.prefixFlags);
        this.vps.reset();
        this.sps.reset();
        this.pps.reset();
        this.prefixSei.reset();
        this.suffixSei.reset();
        SampleReader sampleReader = this.sampleReader;
        if (sampleReader != null) {
            sampleReader.reset();
        }
    }

    private static final class SampleReader {
        private static final int FIRST_SLICE_FLAG_OFFSET = 2;
        private boolean isFirstPrefixNalUnit;
        private boolean isFirstSlice;
        private boolean lookingForFirstSliceFlag;
        private int nalUnitBytesRead;
        private boolean nalUnitHasKeyframeData;
        private long nalUnitPosition;
        private long nalUnitTimeUs;
        private final TrackOutput output;
        private boolean readingPrefix;
        private boolean readingSample;
        private boolean sampleIsKeyframe;
        private long samplePosition;
        private long sampleTimeUs;

        public SampleReader(TrackOutput trackOutput) {
            this.output = trackOutput;
        }

        private static boolean isPrefixNalUnit(int n2) {
            boolean bl = 32 <= n2 && n2 <= 35 || n2 == 39;
            return bl;
        }

        private static boolean isVclBodyNalUnit(int n2) {
            boolean bl = n2 < 32 || n2 == 40;
            return bl;
        }

        private void outputSample(int n2) {
            int n3 = this.sampleIsKeyframe;
            int n4 = (int)(this.nalUnitPosition - this.samplePosition);
            this.output.sampleMetadata(this.sampleTimeUs, n3, n4, n2, null);
        }

        public void endNalUnit(long l2, int n2, boolean bl) {
            if (this.readingPrefix && this.isFirstSlice) {
                this.sampleIsKeyframe = this.nalUnitHasKeyframeData;
                this.readingPrefix = false;
            } else if (this.isFirstPrefixNalUnit || this.isFirstSlice) {
                if (bl && this.readingSample) {
                    this.outputSample(n2 + (int)(l2 - this.nalUnitPosition));
                }
                this.samplePosition = this.nalUnitPosition;
                this.sampleTimeUs = this.nalUnitTimeUs;
                this.sampleIsKeyframe = this.nalUnitHasKeyframeData;
                this.readingSample = true;
            }
        }

        public void readNalUnitData(byte[] byArray, int n2, int n3) {
            if (this.lookingForFirstSliceFlag) {
                int n4 = this.nalUnitBytesRead;
                int n5 = n2 + 2 - n4;
                if (n5 < n3) {
                    boolean bl = (byArray[n5] & 0x80) != 0;
                    this.isFirstSlice = bl;
                    this.lookingForFirstSliceFlag = false;
                } else {
                    this.nalUnitBytesRead = n4 + (n3 - n2);
                }
            }
        }

        public void reset() {
            this.lookingForFirstSliceFlag = false;
            this.isFirstSlice = false;
            this.isFirstPrefixNalUnit = false;
            this.readingSample = false;
            this.readingPrefix = false;
        }

        public void startNalUnit(long l2, int n2, int n3, long l3, boolean bl) {
            this.isFirstSlice = false;
            this.isFirstPrefixNalUnit = false;
            this.nalUnitTimeUs = l3;
            this.nalUnitBytesRead = 0;
            this.nalUnitPosition = l2;
            boolean bl2 = SampleReader.isVclBodyNalUnit(n3);
            boolean bl3 = true;
            if (!bl2) {
                if (this.readingSample && !this.readingPrefix) {
                    if (bl) {
                        this.outputSample(n2);
                    }
                    this.readingSample = false;
                }
                if (SampleReader.isPrefixNalUnit(n3)) {
                    this.isFirstPrefixNalUnit = this.readingPrefix ^ true;
                    this.readingPrefix = true;
                }
            }
            bl = n3 >= 16 && n3 <= 21;
            this.nalUnitHasKeyframeData = bl;
            bl = bl3;
            if (!this.nalUnitHasKeyframeData) {
                bl = n3 <= 9 ? bl3 : false;
            }
            this.lookingForFirstSliceFlag = bl;
        }
    }
}

