/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.ts;

import android.util.SparseArray;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.extractor.ts.ElementaryStreamReader;
import com.google.android.exoplayer2.extractor.ts.NalUnitTargetBuffer;
import com.google.android.exoplayer2.extractor.ts.SeiReader;
import com.google.android.exoplayer2.extractor.ts.TsPayloadReader;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.CodecSpecificDataUtil;
import com.google.android.exoplayer2.util.NalUnitUtil;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.ParsableNalUnitBitArray;
import com.google.android.exoplayer2.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

public final class H264Reader
implements ElementaryStreamReader {
    private static final int NAL_UNIT_TYPE_PPS = 8;
    private static final int NAL_UNIT_TYPE_SEI = 6;
    private static final int NAL_UNIT_TYPE_SPS = 7;
    private final boolean allowNonIdrKeyframes;
    private final boolean detectAccessUnits;
    private String formatId;
    private boolean hasOutputFormat;
    private TrackOutput output;
    private long pesTimeUs;
    private final NalUnitTargetBuffer pps;
    private final boolean[] prefixFlags;
    private boolean randomAccessIndicator;
    private SampleReader sampleReader;
    private final NalUnitTargetBuffer sei;
    private final SeiReader seiReader;
    private final ParsableByteArray seiWrapper;
    private final NalUnitTargetBuffer sps;
    private long totalBytesWritten;

    public H264Reader(SeiReader seiReader, boolean bl, boolean bl2) {
        this.seiReader = seiReader;
        this.allowNonIdrKeyframes = bl;
        this.detectAccessUnits = bl2;
        this.prefixFlags = new boolean[3];
        this.sps = new NalUnitTargetBuffer(7, 128);
        this.pps = new NalUnitTargetBuffer(8, 128);
        this.sei = new NalUnitTargetBuffer(6, 128);
        this.seiWrapper = new ParsableByteArray();
    }

    @EnsuresNonNull(value={"output", "sampleReader"})
    private void assertTracksCreated() {
        Assertions.checkStateNotNull(this.output);
        Util.castNonNull(this.sampleReader);
    }

    @RequiresNonNull(value={"output", "sampleReader"})
    private void endNalUnit(long l2, int n2, int n3, long l3) {
        if (!this.hasOutputFormat || this.sampleReader.needsSpsPps()) {
            this.sps.endNalUnit(n3);
            this.pps.endNalUnit(n3);
            if (!this.hasOutputFormat) {
                if (this.sps.isCompleted() && this.pps.isCompleted()) {
                    ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
                    arrayList.add(Arrays.copyOf(this.sps.nalData, this.sps.nalLength));
                    arrayList.add(Arrays.copyOf(this.pps.nalData, this.pps.nalLength));
                    NalUnitUtil.SpsData spsData = NalUnitUtil.parseSpsNalUnit((byte[])this.sps.nalData, (int)3, (int)this.sps.nalLength);
                    NalUnitUtil.PpsData ppsData = NalUnitUtil.parsePpsNalUnit((byte[])this.pps.nalData, (int)3, (int)this.pps.nalLength);
                    String string2 = CodecSpecificDataUtil.buildAvcCodecString((int)spsData.profileIdc, (int)spsData.constraintsFlagsAndReservedZero2Bits, (int)spsData.levelIdc);
                    this.output.format(new Format.Builder().setId(this.formatId).setSampleMimeType("video/avc").setCodecs(string2).setWidth(spsData.width).setHeight(spsData.height).setPixelWidthHeightRatio(spsData.pixelWidthAspectRatio).setInitializationData(arrayList).build());
                    this.hasOutputFormat = true;
                    this.sampleReader.putSps(spsData);
                    this.sampleReader.putPps(ppsData);
                    this.sps.reset();
                    this.pps.reset();
                }
            } else if (this.sps.isCompleted()) {
                NalUnitUtil.SpsData spsData = NalUnitUtil.parseSpsNalUnit((byte[])this.sps.nalData, (int)3, (int)this.sps.nalLength);
                this.sampleReader.putSps(spsData);
                this.sps.reset();
            } else if (this.pps.isCompleted()) {
                NalUnitUtil.PpsData ppsData = NalUnitUtil.parsePpsNalUnit((byte[])this.pps.nalData, (int)3, (int)this.pps.nalLength);
                this.sampleReader.putPps(ppsData);
                this.pps.reset();
            }
        }
        if (this.sei.endNalUnit(n3)) {
            n3 = NalUnitUtil.unescapeStream((byte[])this.sei.nalData, (int)this.sei.nalLength);
            this.seiWrapper.reset(this.sei.nalData, n3);
            this.seiWrapper.setPosition(4);
            this.seiReader.consume(l3, this.seiWrapper);
        }
        if (this.sampleReader.endNalUnit(l2, n2, this.hasOutputFormat, this.randomAccessIndicator)) {
            this.randomAccessIndicator = false;
        }
    }

    @RequiresNonNull(value={"sampleReader"})
    private void nalUnitData(byte[] byArray, int n2, int n3) {
        if (!this.hasOutputFormat || this.sampleReader.needsSpsPps()) {
            this.sps.appendToNalUnit(byArray, n2, n3);
            this.pps.appendToNalUnit(byArray, n2, n3);
        }
        this.sei.appendToNalUnit(byArray, n2, n3);
        this.sampleReader.appendToNalUnit(byArray, n2, n3);
    }

    @RequiresNonNull(value={"sampleReader"})
    private void startNalUnit(long l2, int n2, long l3) {
        if (!this.hasOutputFormat || this.sampleReader.needsSpsPps()) {
            this.sps.startNalUnit(n2);
            this.pps.startNalUnit(n2);
        }
        this.sei.startNalUnit(n2);
        this.sampleReader.startNalUnit(l2, n2, l3);
    }

    @Override
    public void consume(ParsableByteArray parsableByteArray) {
        this.assertTracksCreated();
        int n2 = parsableByteArray.getPosition();
        int n3 = parsableByteArray.limit();
        byte[] byArray = parsableByteArray.getData();
        this.totalBytesWritten += (long)parsableByteArray.bytesLeft();
        this.output.sampleData(parsableByteArray, parsableByteArray.bytesLeft());
        while (true) {
            int n4;
            if ((n4 = NalUnitUtil.findNalUnit((byte[])byArray, (int)n2, (int)n3, (boolean[])this.prefixFlags)) == n3) {
                this.nalUnitData(byArray, n2, n3);
                return;
            }
            int n5 = NalUnitUtil.getNalUnitType((byte[])byArray, (int)n4);
            int n6 = n4 - n2;
            if (n6 > 0) {
                this.nalUnitData(byArray, n2, n4);
            }
            int n7 = n3 - n4;
            long l2 = this.totalBytesWritten - (long)n7;
            n2 = n6 < 0 ? -n6 : 0;
            this.endNalUnit(l2, n7, n2, this.pesTimeUs);
            this.startNalUnit(l2, n5, this.pesTimeUs);
            n2 = n4 + 3;
        }
    }

    @Override
    public void createTracks(ExtractorOutput extractorOutput, TsPayloadReader.TrackIdGenerator trackIdGenerator) {
        trackIdGenerator.generateNewId();
        this.formatId = trackIdGenerator.getFormatId();
        this.output = extractorOutput.track(trackIdGenerator.getTrackId(), 2);
        this.sampleReader = new SampleReader(this.output, this.allowNonIdrKeyframes, this.detectAccessUnits);
        this.seiReader.createTracks(extractorOutput, trackIdGenerator);
    }

    @Override
    public void packetFinished() {
    }

    @Override
    public void packetStarted(long l2, int n2) {
        this.pesTimeUs = l2;
        int n3 = this.randomAccessIndicator;
        n2 = (n2 & 2) != 0 ? 1 : 0;
        this.randomAccessIndicator = n3 | n2;
    }

    @Override
    public void seek() {
        this.totalBytesWritten = 0L;
        this.randomAccessIndicator = false;
        NalUnitUtil.clearPrefixFlags((boolean[])this.prefixFlags);
        this.sps.reset();
        this.pps.reset();
        this.sei.reset();
        SampleReader sampleReader = this.sampleReader;
        if (sampleReader != null) {
            sampleReader.reset();
        }
    }

    private static final class SampleReader {
        private static final int DEFAULT_BUFFER_SIZE = 128;
        private static final int NAL_UNIT_TYPE_AUD = 9;
        private static final int NAL_UNIT_TYPE_IDR = 5;
        private static final int NAL_UNIT_TYPE_NON_IDR = 1;
        private static final int NAL_UNIT_TYPE_PARTITION_A = 2;
        private final boolean allowNonIdrKeyframes;
        private final ParsableNalUnitBitArray bitArray;
        private byte[] buffer;
        private int bufferLength;
        private final boolean detectAccessUnits;
        private boolean isFilling;
        private long nalUnitStartPosition;
        private long nalUnitTimeUs;
        private int nalUnitType;
        private final TrackOutput output;
        private final SparseArray<NalUnitUtil.PpsData> pps;
        private SliceHeaderData previousSliceHeader;
        private boolean readingSample;
        private boolean sampleIsKeyframe;
        private long samplePosition;
        private long sampleTimeUs;
        private SliceHeaderData sliceHeader;
        private final SparseArray<NalUnitUtil.SpsData> sps;

        public SampleReader(TrackOutput trackOutput, boolean bl, boolean bl2) {
            this.output = trackOutput;
            this.allowNonIdrKeyframes = bl;
            this.detectAccessUnits = bl2;
            this.sps = new SparseArray();
            this.pps = new SparseArray();
            this.previousSliceHeader = new SliceHeaderData();
            this.sliceHeader = new SliceHeaderData();
            this.buffer = new byte[128];
            this.bitArray = new ParsableNalUnitBitArray(this.buffer, 0, 0);
            this.reset();
        }

        private void outputSample(int n2) {
            int n3 = this.sampleIsKeyframe;
            int n4 = (int)(this.nalUnitStartPosition - this.samplePosition);
            this.output.sampleMetadata(this.sampleTimeUs, n3, n4, n2, null);
        }

        public void appendToNalUnit(byte[] object, int n2, int n3) {
            int n4;
            boolean bl;
            boolean bl2;
            boolean bl3;
            boolean bl4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            block28: {
                block29: {
                    block25: {
                        block24: {
                            block26: {
                                block27: {
                                    Object object2;
                                    block23: {
                                        block22: {
                                            block21: {
                                                block20: {
                                                    if (!this.isFilling) {
                                                        return;
                                                    }
                                                    object2 = this.buffer;
                                                    n10 = ((byte[])object2).length;
                                                    n3 = this.bufferLength;
                                                    n9 = n3 - n2;
                                                    if (n10 < n3 + n9) {
                                                        this.buffer = Arrays.copyOf(object2, (n3 + n9) * 2);
                                                    }
                                                    System.arraycopy(object, n2, this.buffer, this.bufferLength, n9);
                                                    this.bufferLength += n9;
                                                    this.bitArray.reset(this.buffer, 0, this.bufferLength);
                                                    if (!this.bitArray.canReadBits(8)) {
                                                        return;
                                                    }
                                                    this.bitArray.skipBit();
                                                    n8 = this.bitArray.readBits(2);
                                                    this.bitArray.skipBits(5);
                                                    if (!this.bitArray.canReadExpGolombCodedNum()) {
                                                        return;
                                                    }
                                                    this.bitArray.readUnsignedExpGolombCodedInt();
                                                    if (!this.bitArray.canReadExpGolombCodedNum()) {
                                                        return;
                                                    }
                                                    n7 = this.bitArray.readUnsignedExpGolombCodedInt();
                                                    if (!this.detectAccessUnits) {
                                                        this.isFilling = false;
                                                        this.sliceHeader.setSliceType(n7);
                                                        return;
                                                    }
                                                    if (!this.bitArray.canReadExpGolombCodedNum()) {
                                                        return;
                                                    }
                                                    n6 = this.bitArray.readUnsignedExpGolombCodedInt();
                                                    if (this.pps.indexOfKey(n6) < 0) {
                                                        this.isFilling = false;
                                                        return;
                                                    }
                                                    object2 = (NalUnitUtil.PpsData)this.pps.get(n6);
                                                    object = (NalUnitUtil.SpsData)this.sps.get(object2.seqParameterSetId);
                                                    if (object.separateColorPlaneFlag) {
                                                        if (!this.bitArray.canReadBits(2)) {
                                                            return;
                                                        }
                                                        this.bitArray.skipBits(2);
                                                    }
                                                    if (!this.bitArray.canReadBits(object.frameNumLength)) {
                                                        return;
                                                    }
                                                    n5 = this.bitArray.readBits(object.frameNumLength);
                                                    if (object.frameMbsOnlyFlag) break block20;
                                                    if (!this.bitArray.canReadBits(1)) {
                                                        return;
                                                    }
                                                    bl4 = this.bitArray.readBit();
                                                    if (!bl4) break block21;
                                                    if (!this.bitArray.canReadBits(1)) {
                                                        return;
                                                    }
                                                    bl3 = this.bitArray.readBit();
                                                    bl2 = true;
                                                    break block22;
                                                }
                                                bl4 = false;
                                            }
                                            bl2 = false;
                                            bl3 = false;
                                        }
                                        bl = this.nalUnitType == 5;
                                        if (bl) {
                                            if (!this.bitArray.canReadExpGolombCodedNum()) {
                                                return;
                                            }
                                            n10 = this.bitArray.readUnsignedExpGolombCodedInt();
                                        } else {
                                            n10 = 0;
                                        }
                                        if (object.picOrderCountType != 0) break block23;
                                        if (!this.bitArray.canReadBits(object.picOrderCntLsbLength)) {
                                            return;
                                        }
                                        n2 = this.bitArray.readBits(object.picOrderCntLsbLength);
                                        if (!object2.bottomFieldPicOrderInFramePresentFlag || bl4) break block24;
                                        if (!this.bitArray.canReadExpGolombCodedNum()) {
                                            return;
                                        }
                                        n3 = this.bitArray.readSignedExpGolombCodedInt();
                                        break block25;
                                    }
                                    if (object.picOrderCountType != 1 || object.deltaPicOrderAlwaysZeroFlag) break block26;
                                    if (!this.bitArray.canReadExpGolombCodedNum()) {
                                        return;
                                    }
                                    n9 = this.bitArray.readSignedExpGolombCodedInt();
                                    if (!object2.bottomFieldPicOrderInFramePresentFlag || bl4) break block27;
                                    if (!this.bitArray.canReadExpGolombCodedNum()) {
                                        return;
                                    }
                                    n4 = this.bitArray.readSignedExpGolombCodedInt();
                                    n2 = 0;
                                    n3 = 0;
                                    break block28;
                                }
                                n2 = 0;
                                n3 = 0;
                                break block29;
                            }
                            n2 = 0;
                        }
                        n3 = 0;
                    }
                    n9 = 0;
                }
                n4 = 0;
            }
            this.sliceHeader.setAll((NalUnitUtil.SpsData)object, n8, n7, n5, n6, bl4, bl2, bl3, bl, n10, n2, n3, n9, n4);
            this.isFilling = false;
        }

        public boolean endNalUnit(long l2, int n2, boolean bl, boolean bl2) {
            block7: {
                block6: {
                    int n3 = this.nalUnitType;
                    int n4 = 0;
                    if (n3 == 9 || this.detectAccessUnits && this.sliceHeader.isFirstVclNalUnitOfPicture(this.previousSliceHeader)) {
                        if (bl && this.readingSample) {
                            this.outputSample(n2 + (int)(l2 - this.nalUnitStartPosition));
                        }
                        this.samplePosition = this.nalUnitStartPosition;
                        this.sampleTimeUs = this.nalUnitTimeUs;
                        this.sampleIsKeyframe = false;
                        this.readingSample = true;
                    }
                    if (this.allowNonIdrKeyframes) {
                        bl2 = this.sliceHeader.isISlice();
                    }
                    bl = this.sampleIsKeyframe;
                    n3 = this.nalUnitType;
                    if (n3 == 5) break block6;
                    n2 = n4;
                    if (!bl2) break block7;
                    n2 = n4;
                    if (n3 != 1) break block7;
                }
                n2 = 1;
            }
            this.sampleIsKeyframe = bl | n2;
            return this.sampleIsKeyframe;
        }

        public boolean needsSpsPps() {
            return this.detectAccessUnits;
        }

        public void putPps(NalUnitUtil.PpsData ppsData) {
            this.pps.append(ppsData.picParameterSetId, (Object)ppsData);
        }

        public void putSps(NalUnitUtil.SpsData spsData) {
            this.sps.append(spsData.seqParameterSetId, (Object)spsData);
        }

        public void reset() {
            this.isFilling = false;
            this.readingSample = false;
            this.sliceHeader.clear();
        }

        public void startNalUnit(long l2, int n2, long l3) {
            this.nalUnitType = n2;
            this.nalUnitTimeUs = l3;
            this.nalUnitStartPosition = l2;
            if (this.allowNonIdrKeyframes && this.nalUnitType == 1 || this.detectAccessUnits && ((n2 = this.nalUnitType) == 5 || n2 == 1 || n2 == 2)) {
                SliceHeaderData sliceHeaderData = this.previousSliceHeader;
                this.previousSliceHeader = this.sliceHeader;
                this.sliceHeader = sliceHeaderData;
                this.sliceHeader.clear();
                this.bufferLength = 0;
                this.isFilling = true;
            }
        }

        private static final class SliceHeaderData {
            private static final int SLICE_TYPE_ALL_I = 7;
            private static final int SLICE_TYPE_I = 2;
            private boolean bottomFieldFlag;
            private boolean bottomFieldFlagPresent;
            private int deltaPicOrderCnt0;
            private int deltaPicOrderCnt1;
            private int deltaPicOrderCntBottom;
            private boolean fieldPicFlag;
            private int frameNum;
            private boolean hasSliceType;
            private boolean idrPicFlag;
            private int idrPicId;
            private boolean isComplete;
            private int nalRefIdc;
            private int picOrderCntLsb;
            private int picParameterSetId;
            private int sliceType;
            private NalUnitUtil.SpsData spsData;

            private SliceHeaderData() {
            }

            private boolean isFirstVclNalUnitOfPicture(SliceHeaderData sliceHeaderData) {
                boolean bl;
                block6: {
                    block5: {
                        boolean bl2;
                        int n2;
                        int n3;
                        bl = this.isComplete;
                        boolean bl3 = false;
                        if (!bl) {
                            return false;
                        }
                        if (!sliceHeaderData.isComplete) {
                            return true;
                        }
                        NalUnitUtil.SpsData spsData = Assertions.checkStateNotNull(this.spsData);
                        NalUnitUtil.SpsData spsData2 = Assertions.checkStateNotNull(sliceHeaderData.spsData);
                        if (this.frameNum != sliceHeaderData.frameNum || this.picParameterSetId != sliceHeaderData.picParameterSetId || this.fieldPicFlag != sliceHeaderData.fieldPicFlag || this.bottomFieldFlagPresent && sliceHeaderData.bottomFieldFlagPresent && this.bottomFieldFlag != sliceHeaderData.bottomFieldFlag || (n3 = this.nalRefIdc) != (n2 = sliceHeaderData.nalRefIdc) && (n3 == 0 || n2 == 0) || spsData.picOrderCountType == 0 && spsData2.picOrderCountType == 0 && (this.picOrderCntLsb != sliceHeaderData.picOrderCntLsb || this.deltaPicOrderCntBottom != sliceHeaderData.deltaPicOrderCntBottom) || spsData.picOrderCountType == 1 && spsData2.picOrderCountType == 1 && (this.deltaPicOrderCnt0 != sliceHeaderData.deltaPicOrderCnt0 || this.deltaPicOrderCnt1 != sliceHeaderData.deltaPicOrderCnt1) || (bl2 = this.idrPicFlag) != sliceHeaderData.idrPicFlag) break block5;
                        bl = bl3;
                        if (!bl2) break block6;
                        bl = bl3;
                        if (this.idrPicId == sliceHeaderData.idrPicId) break block6;
                    }
                    bl = true;
                }
                return bl;
            }

            public void clear() {
                this.hasSliceType = false;
                this.isComplete = false;
            }

            public boolean isISlice() {
                int n2;
                boolean bl = this.hasSliceType && ((n2 = this.sliceType) == 7 || n2 == 2);
                return bl;
            }

            public void setAll(NalUnitUtil.SpsData spsData, int n2, int n3, int n4, int n5, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n6, int n7, int n8, int n9, int n10) {
                this.spsData = spsData;
                this.nalRefIdc = n2;
                this.sliceType = n3;
                this.frameNum = n4;
                this.picParameterSetId = n5;
                this.fieldPicFlag = bl;
                this.bottomFieldFlagPresent = bl2;
                this.bottomFieldFlag = bl3;
                this.idrPicFlag = bl4;
                this.idrPicId = n6;
                this.picOrderCntLsb = n7;
                this.deltaPicOrderCntBottom = n8;
                this.deltaPicOrderCnt0 = n9;
                this.deltaPicOrderCnt1 = n10;
                this.isComplete = true;
                this.hasSliceType = true;
            }

            public void setSliceType(int n2) {
                this.sliceType = n2;
                this.hasSliceType = true;
            }
        }
    }
}

