/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.ts;

import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.audio.DtsUtil;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.extractor.ts.ElementaryStreamReader;
import com.google.android.exoplayer2.extractor.ts.TsPayloadReader;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ParsableByteArray;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

public final class DtsReader
implements ElementaryStreamReader {
    private static final int HEADER_SIZE = 18;
    private static final int STATE_FINDING_SYNC = 0;
    private static final int STATE_READING_HEADER = 1;
    private static final int STATE_READING_SAMPLE = 2;
    private int bytesRead;
    private Format format;
    private String formatId;
    private final ParsableByteArray headerScratchBytes = new ParsableByteArray(new byte[18]);
    private final String language;
    private TrackOutput output;
    private long sampleDurationUs;
    private int sampleSize;
    private int state = 0;
    private int syncBytes;
    private long timeUs;

    public DtsReader(String string2) {
        this.language = string2;
    }

    private boolean continueRead(ParsableByteArray parsableByteArray, byte[] byArray, int n2) {
        int n3 = Math.min(parsableByteArray.bytesLeft(), n2 - this.bytesRead);
        parsableByteArray.readBytes(byArray, this.bytesRead, n3);
        this.bytesRead += n3;
        boolean bl = this.bytesRead == n2;
        return bl;
    }

    @RequiresNonNull(value={"output"})
    private void parseHeader() {
        byte[] byArray = this.headerScratchBytes.getData();
        if (this.format == null) {
            this.format = DtsUtil.parseDtsFormat((byte[])byArray, (String)this.formatId, (String)this.language, null);
            this.output.format(this.format);
        }
        this.sampleSize = DtsUtil.getDtsFrameSize((byte[])byArray);
        this.sampleDurationUs = (int)((long)DtsUtil.parseDtsAudioSampleCount((byte[])byArray) * 1000000L / (long)this.format.sampleRate);
    }

    private boolean skipToNextSync(ParsableByteArray object) {
        while (object.bytesLeft() > 0) {
            this.syncBytes <<= 8;
            this.syncBytes |= object.readUnsignedByte();
            if (!DtsUtil.isSyncWord((int)this.syncBytes)) continue;
            object = this.headerScratchBytes.getData();
            int n2 = this.syncBytes;
            object[0] = (ParsableByteArray)((byte)((byte)(n2 >> 24 & 0xFF)));
            object[1] = (ParsableByteArray)((byte)((byte)(n2 >> 16 & 0xFF)));
            object[2] = (ParsableByteArray)((byte)((byte)(n2 >> 8 & 0xFF)));
            object[3] = (ParsableByteArray)((byte)((byte)(n2 & 0xFF)));
            this.bytesRead = 4;
            this.syncBytes = 0;
            return true;
        }
        return false;
    }

    @Override
    public void consume(ParsableByteArray parsableByteArray) {
        Assertions.checkStateNotNull(this.output);
        while (parsableByteArray.bytesLeft() > 0) {
            int n2 = this.state;
            if (n2 != 0) {
                if (n2 != 1) {
                    if (n2 == 2) {
                        n2 = Math.min(parsableByteArray.bytesLeft(), this.sampleSize - this.bytesRead);
                        this.output.sampleData(parsableByteArray, n2);
                        this.bytesRead += n2;
                        int n3 = this.bytesRead;
                        n2 = this.sampleSize;
                        if (n3 != n2) continue;
                        this.output.sampleMetadata(this.timeUs, 1, n2, 0, null);
                        this.timeUs += this.sampleDurationUs;
                        this.state = 0;
                        continue;
                    }
                    throw new IllegalStateException();
                }
                if (!this.continueRead(parsableByteArray, this.headerScratchBytes.getData(), 18)) continue;
                this.parseHeader();
                this.headerScratchBytes.setPosition(0);
                this.output.sampleData(this.headerScratchBytes, 18);
                this.state = 2;
                continue;
            }
            if (!this.skipToNextSync(parsableByteArray)) continue;
            this.state = 1;
        }
    }

    @Override
    public void createTracks(ExtractorOutput extractorOutput, TsPayloadReader.TrackIdGenerator trackIdGenerator) {
        trackIdGenerator.generateNewId();
        this.formatId = trackIdGenerator.getFormatId();
        this.output = extractorOutput.track(trackIdGenerator.getTrackId(), 1);
    }

    @Override
    public void packetFinished() {
    }

    @Override
    public void packetStarted(long l2, int n2) {
        this.timeUs = l2;
    }

    @Override
    public void seek() {
        this.state = 0;
        this.bytesRead = 0;
        this.syncBytes = 0;
    }
}

