/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.ts;

import android.util.SparseArray;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.extractor.ts.Ac3Reader;
import com.google.android.exoplayer2.extractor.ts.Ac4Reader;
import com.google.android.exoplayer2.extractor.ts.AdtsReader;
import com.google.android.exoplayer2.extractor.ts.DtsReader;
import com.google.android.exoplayer2.extractor.ts.DvbSubtitleReader;
import com.google.android.exoplayer2.extractor.ts.ElementaryStreamReader;
import com.google.android.exoplayer2.extractor.ts.H262Reader;
import com.google.android.exoplayer2.extractor.ts.H263Reader;
import com.google.android.exoplayer2.extractor.ts.H264Reader;
import com.google.android.exoplayer2.extractor.ts.H265Reader;
import com.google.android.exoplayer2.extractor.ts.Id3Reader;
import com.google.android.exoplayer2.extractor.ts.LatmReader;
import com.google.android.exoplayer2.extractor.ts.MpegAudioReader;
import com.google.android.exoplayer2.extractor.ts.PassthroughSectionPayloadReader;
import com.google.android.exoplayer2.extractor.ts.PesReader;
import com.google.android.exoplayer2.extractor.ts.SectionPayloadReader;
import com.google.android.exoplayer2.extractor.ts.SectionReader;
import com.google.android.exoplayer2.extractor.ts.SeiReader;
import com.google.android.exoplayer2.extractor.ts.TsPayloadReader;
import com.google.android.exoplayer2.extractor.ts.UserDataReader;
import com.google.android.exoplayer2.util.CodecSpecificDataUtil;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.common.collect.ImmutableList;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

public final class DefaultTsPayloadReaderFactory
implements TsPayloadReader.Factory {
    private static final int DESCRIPTOR_TAG_CAPTION_SERVICE = 134;
    public static final int FLAG_ALLOW_NON_IDR_KEYFRAMES = 1;
    public static final int FLAG_DETECT_ACCESS_UNITS = 8;
    public static final int FLAG_ENABLE_HDMV_DTS_AUDIO_STREAMS = 64;
    public static final int FLAG_IGNORE_AAC_STREAM = 2;
    public static final int FLAG_IGNORE_H264_STREAM = 4;
    public static final int FLAG_IGNORE_SPLICE_INFO_STREAM = 16;
    public static final int FLAG_OVERRIDE_CAPTION_DESCRIPTORS = 32;
    private final List<Format> closedCaptionFormats;
    private final int flags;

    public DefaultTsPayloadReaderFactory() {
        this(0);
    }

    public DefaultTsPayloadReaderFactory(int n2) {
        this(n2, ImmutableList.of());
    }

    public DefaultTsPayloadReaderFactory(int n2, List<Format> list) {
        this.flags = n2;
        this.closedCaptionFormats = list;
    }

    private SeiReader buildSeiReader(TsPayloadReader.EsInfo esInfo) {
        return new SeiReader(this.getClosedCaptionFormats(esInfo));
    }

    private UserDataReader buildUserDataReader(TsPayloadReader.EsInfo esInfo) {
        return new UserDataReader(this.getClosedCaptionFormats(esInfo));
    }

    private List<Format> getClosedCaptionFormats(TsPayloadReader.EsInfo object) {
        if (this.isSet(32)) {
            return this.closedCaptionFormats;
        }
        ParsableByteArray parsableByteArray = new ParsableByteArray(((TsPayloadReader.EsInfo)object).descriptorBytes);
        object = this.closedCaptionFormats;
        while (parsableByteArray.bytesLeft() > 0) {
            int n2 = parsableByteArray.readUnsignedByte();
            int n3 = parsableByteArray.readUnsignedByte();
            int n4 = parsableByteArray.getPosition();
            if (n2 == 134) {
                ArrayList<Format> arrayList = new ArrayList<Format>();
                int n5 = parsableByteArray.readUnsignedByte();
                n2 = 0;
                while (true) {
                    object = arrayList;
                    if (n2 >= (n5 & 0x1F)) break;
                    String string2 = parsableByteArray.readString(3);
                    int n6 = parsableByteArray.readUnsignedByte();
                    boolean bl = true;
                    boolean bl2 = (n6 & 0x80) != 0;
                    if (bl2) {
                        n6 &= 0x3F;
                        object = "application/cea-708";
                    } else {
                        object = "application/cea-608";
                        n6 = 1;
                    }
                    byte by2 = (byte)parsableByteArray.readUnsignedByte();
                    parsableByteArray.skipBytes(1);
                    List list = null;
                    if (bl2) {
                        if ((by2 & 0x40) == 0) {
                            bl = false;
                        }
                        list = CodecSpecificDataUtil.buildCea708InitializationData((boolean)bl);
                    }
                    arrayList.add(new Format.Builder().setSampleMimeType((String)object).setLanguage(string2).setAccessibilityChannel(n6).setInitializationData(list).build());
                    ++n2;
                }
            }
            parsableByteArray.setPosition(n4 + n3);
        }
        return object;
    }

    private boolean isSet(int n2) {
        boolean bl = (n2 & this.flags) != 0;
        return bl;
    }

    @Override
    public SparseArray<TsPayloadReader> createInitialPayloadReaders() {
        return new SparseArray();
    }

    @Override
    public TsPayloadReader createPayloadReader(int n2, TsPayloadReader.EsInfo object) {
        block7: {
            block8: {
                block9: {
                    Object var5_5;
                    block10: {
                        block11: {
                            block12: {
                                block13: {
                                    block14: {
                                        block15: {
                                            block16: {
                                                block17: {
                                                    Object var4_4;
                                                    block18: {
                                                        if (n2 == 2) break block7;
                                                        if (n2 == 3 || n2 == 4) break block8;
                                                        if (n2 == 21) break block9;
                                                        Object var3_3 = null;
                                                        var4_4 = null;
                                                        var5_5 = null;
                                                        Object var6_6 = null;
                                                        if (n2 == 27) break block10;
                                                        if (n2 == 36) break block11;
                                                        if (n2 == 89) break block12;
                                                        if (n2 == 138) break block13;
                                                        if (n2 == 172) break block14;
                                                        if (n2 == 257) break block15;
                                                        if (n2 == 129) break block16;
                                                        if (n2 == 130) break block17;
                                                        if (n2 == 134) break block18;
                                                        if (n2 != 135) {
                                                            switch (n2) {
                                                                default: {
                                                                    return null;
                                                                }
                                                                case 17: {
                                                                    object = this.isSet(2) ? var6_6 : new PesReader(new LatmReader(((TsPayloadReader.EsInfo)object).language));
                                                                    return object;
                                                                }
                                                                case 16: {
                                                                    return new PesReader((ElementaryStreamReader)new H263Reader(this.buildUserDataReader((TsPayloadReader.EsInfo)object)));
                                                                }
                                                                case 15: 
                                                            }
                                                            object = this.isSet(2) ? var3_3 : new PesReader(new AdtsReader(false, ((TsPayloadReader.EsInfo)object).language));
                                                            return object;
                                                        }
                                                        break block16;
                                                    }
                                                    object = this.isSet(16) ? var4_4 : new SectionReader((SectionPayloadReader)new PassthroughSectionPayloadReader("application/x-scte35"));
                                                    return object;
                                                }
                                                if (!this.isSet(64)) {
                                                    return null;
                                                }
                                                break block13;
                                            }
                                            return new PesReader(new Ac3Reader(((TsPayloadReader.EsInfo)object).language));
                                        }
                                        return new SectionReader((SectionPayloadReader)new PassthroughSectionPayloadReader("application/vnd.dvb.ait"));
                                    }
                                    return new PesReader(new Ac4Reader(((TsPayloadReader.EsInfo)object).language));
                                }
                                return new PesReader(new DtsReader(((TsPayloadReader.EsInfo)object).language));
                            }
                            return new PesReader((ElementaryStreamReader)new DvbSubtitleReader(((TsPayloadReader.EsInfo)object).dvbSubtitleInfos));
                        }
                        return new PesReader(new H265Reader(this.buildSeiReader((TsPayloadReader.EsInfo)object)));
                    }
                    object = this.isSet(4) ? var5_5 : new PesReader(new H264Reader(this.buildSeiReader((TsPayloadReader.EsInfo)object), this.isSet(1), this.isSet(8)));
                    return object;
                }
                return new PesReader((ElementaryStreamReader)new Id3Reader());
            }
            return new PesReader(new MpegAudioReader(((TsPayloadReader.EsInfo)object).language));
        }
        return new PesReader((ElementaryStreamReader)new H262Reader(this.buildUserDataReader((TsPayloadReader.EsInfo)object)));
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Flags {
    }
}

