/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.ts;

import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.audio.AacUtil;
import com.google.android.exoplayer2.extractor.DummyTrackOutput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.extractor.ts.ElementaryStreamReader;
import com.google.android.exoplayer2.extractor.ts.TsPayloadReader;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.ParsableBitArray;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import java.util.Arrays;
import java.util.Collections;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

public final class AdtsReader
implements ElementaryStreamReader {
    private static final int CRC_SIZE = 2;
    private static final int HEADER_SIZE = 5;
    private static final int ID3_HEADER_SIZE = 10;
    private static final byte[] ID3_IDENTIFIER = new byte[]{73, 68, 51};
    private static final int ID3_SIZE_OFFSET = 6;
    private static final int MATCH_STATE_FF = 512;
    private static final int MATCH_STATE_I = 768;
    private static final int MATCH_STATE_ID = 1024;
    private static final int MATCH_STATE_START = 256;
    private static final int MATCH_STATE_VALUE_SHIFT = 8;
    private static final int STATE_CHECKING_ADTS_HEADER = 1;
    private static final int STATE_FINDING_SAMPLE = 0;
    private static final int STATE_READING_ADTS_HEADER = 3;
    private static final int STATE_READING_ID3_HEADER = 2;
    private static final int STATE_READING_SAMPLE = 4;
    private static final String TAG = "AdtsReader";
    private static final int VERSION_UNSET = -1;
    private final ParsableBitArray adtsScratch = new ParsableBitArray(new byte[7]);
    private int bytesRead;
    private int currentFrameVersion;
    private TrackOutput currentOutput;
    private long currentSampleDuration;
    private final boolean exposeId3;
    private int firstFrameSampleRateIndex;
    private int firstFrameVersion;
    private String formatId;
    private boolean foundFirstFrame;
    private boolean hasCrc;
    private boolean hasOutputFormat;
    private final ParsableByteArray id3HeaderBuffer = new ParsableByteArray(Arrays.copyOf(ID3_IDENTIFIER, 10));
    private TrackOutput id3Output;
    private final String language;
    private int matchState;
    private TrackOutput output;
    private long sampleDurationUs;
    private int sampleSize;
    private int state;
    private long timeUs;

    public AdtsReader(boolean bl) {
        this(bl, null);
    }

    public AdtsReader(boolean bl, String string2) {
        this.setFindingSampleState();
        this.firstFrameVersion = -1;
        this.firstFrameSampleRateIndex = -1;
        this.sampleDurationUs = -9223372036854775807L;
        this.exposeId3 = bl;
        this.language = string2;
    }

    @EnsuresNonNull(value={"output", "currentOutput", "id3Output"})
    private void assertTracksCreated() {
        Assertions.checkNotNull(this.output);
        Util.castNonNull(this.currentOutput);
        Util.castNonNull(this.id3Output);
    }

    private void checkAdtsHeader(ParsableByteArray parsableByteArray) {
        if (parsableByteArray.bytesLeft() == 0) {
            return;
        }
        this.adtsScratch.data[0] = parsableByteArray.getData()[parsableByteArray.getPosition()];
        this.adtsScratch.setPosition(2);
        int n2 = this.adtsScratch.readBits(4);
        int n3 = this.firstFrameSampleRateIndex;
        if (n3 != -1 && n2 != n3) {
            this.resetSync();
            return;
        }
        if (!this.foundFirstFrame) {
            this.foundFirstFrame = true;
            this.firstFrameVersion = this.currentFrameVersion;
            this.firstFrameSampleRateIndex = n2;
        }
        this.setReadingAdtsHeaderState();
    }

    private boolean checkSyncPositionValid(ParsableByteArray parsableByteArray, int n2) {
        parsableByteArray.setPosition(n2 + 1);
        byte[] byArray = this.adtsScratch.data;
        boolean bl = true;
        boolean bl2 = true;
        if (!this.tryRead(parsableByteArray, byArray, 1)) {
            return false;
        }
        this.adtsScratch.setPosition(4);
        int n3 = this.adtsScratch.readBits(1);
        int n4 = this.firstFrameVersion;
        if (n4 != -1 && n3 != n4) {
            return false;
        }
        if (this.firstFrameSampleRateIndex != -1) {
            if (!this.tryRead(parsableByteArray, this.adtsScratch.data, 1)) {
                return true;
            }
            this.adtsScratch.setPosition(2);
            if (this.adtsScratch.readBits(4) != this.firstFrameSampleRateIndex) {
                return false;
            }
            parsableByteArray.setPosition(n2 + 2);
        }
        if (!this.tryRead(parsableByteArray, this.adtsScratch.data, 4)) {
            return true;
        }
        this.adtsScratch.setPosition(14);
        int n5 = this.adtsScratch.readBits(13);
        if (n5 < 7) {
            return false;
        }
        byArray = parsableByteArray.getData();
        n4 = parsableByteArray.limit();
        if ((n2 += n5) >= n4) {
            return true;
        }
        if (byArray[n2] == -1) {
            if (++n2 == n4) {
                return true;
            }
            if (!this.isAdtsSyncBytes((byte)-1, byArray[n2]) || (byArray[n2] & 8) >> 3 != n3) {
                bl2 = false;
            }
            return bl2;
        }
        if (byArray[n2] != 73) {
            return false;
        }
        n3 = n2 + 1;
        if (n3 == n4) {
            return true;
        }
        if (byArray[n3] != 68) {
            return false;
        }
        if ((n2 += 2) == n4) {
            return true;
        }
        bl2 = byArray[n2] == 51 ? bl : false;
        return bl2;
    }

    private boolean continueRead(ParsableByteArray parsableByteArray, byte[] byArray, int n2) {
        int n3 = Math.min(parsableByteArray.bytesLeft(), n2 - this.bytesRead);
        parsableByteArray.readBytes(byArray, this.bytesRead, n3);
        this.bytesRead += n3;
        boolean bl = this.bytesRead == n2;
        return bl;
    }

    private void findNextSample(ParsableByteArray parsableByteArray) {
        byte[] byArray = parsableByteArray.getData();
        int n2 = parsableByteArray.getPosition();
        int n3 = parsableByteArray.limit();
        while (n2 < n3) {
            int n4 = n2 + 1;
            n2 = byArray[n2] & 0xFF;
            if (this.matchState == 512 && this.isAdtsSyncBytes((byte)-1, (byte)n2) && (this.foundFirstFrame || this.checkSyncPositionValid(parsableByteArray, n4 - 2))) {
                this.currentFrameVersion = (n2 & 8) >> 3;
                boolean bl = true;
                if ((n2 & 1) != 0) {
                    bl = false;
                }
                this.hasCrc = bl;
                if (!this.foundFirstFrame) {
                    this.setCheckingAdtsHeaderState();
                } else {
                    this.setReadingAdtsHeaderState();
                }
                parsableByteArray.setPosition(n4);
                return;
            }
            int n5 = this.matchState;
            if ((n2 |= n5) != 329) {
                if (n2 != 511) {
                    if (n2 != 836) {
                        if (n2 != 1075) {
                            n2 = n4;
                            if (n5 == 256) continue;
                            this.matchState = 256;
                            n2 = n4 - 1;
                            continue;
                        }
                        this.setReadingId3HeaderState();
                        parsableByteArray.setPosition(n4);
                        return;
                    }
                    this.matchState = 1024;
                    n2 = n4;
                    continue;
                }
                this.matchState = 512;
                n2 = n4;
                continue;
            }
            this.matchState = 768;
            n2 = n4;
        }
        parsableByteArray.setPosition(n2);
    }

    private boolean isAdtsSyncBytes(byte by2, byte by3) {
        return AdtsReader.isAdtsSyncWord((by2 & 0xFF) << 8 | by3 & 0xFF);
    }

    public static boolean isAdtsSyncWord(int n2) {
        boolean bl = (n2 & 0xFFF6) == 65520;
        return bl;
    }

    @RequiresNonNull(value={"output"})
    private void parseAdtsHeader() throws ParserException {
        int n2;
        int n3;
        this.adtsScratch.setPosition(0);
        if (!this.hasOutputFormat) {
            Object object;
            n2 = n3 = this.adtsScratch.readBits(2) + 1;
            if (n3 != 2) {
                object = new StringBuilder();
                ((StringBuilder)object).append("Detected audio object type: ");
                ((StringBuilder)object).append(n3);
                ((StringBuilder)object).append(", but assuming AAC LC.");
                Log.w(TAG, ((StringBuilder)object).toString());
                n2 = 2;
            }
            this.adtsScratch.skipBits(5);
            n3 = this.adtsScratch.readBits(3);
            byte[] byArray = AacUtil.buildAudioSpecificConfig(n2, this.firstFrameSampleRateIndex, n3);
            object = AacUtil.parseAudioSpecificConfig(byArray);
            object = new Format.Builder().setId(this.formatId).setSampleMimeType("audio/mp4a-latm").setCodecs(((AacUtil.Config)object).codecs).setChannelCount(((AacUtil.Config)object).channelCount).setSampleRate(((AacUtil.Config)object).sampleRateHz).setInitializationData(Collections.singletonList(byArray)).setLanguage(this.language).build();
            this.sampleDurationUs = 1024000000L / (long)((Format)object).sampleRate;
            this.output.format((Format)object);
            this.hasOutputFormat = true;
        } else {
            this.adtsScratch.skipBits(10);
        }
        this.adtsScratch.skipBits(4);
        n2 = n3 = this.adtsScratch.readBits(13) - 2 - 5;
        if (this.hasCrc) {
            n2 = n3 - 2;
        }
        this.setReadingSampleState(this.output, this.sampleDurationUs, 0, n2);
    }

    @RequiresNonNull(value={"id3Output"})
    private void parseId3Header() {
        this.id3Output.sampleData(this.id3HeaderBuffer, 10);
        this.id3HeaderBuffer.setPosition(6);
        this.setReadingSampleState(this.id3Output, 0L, 10, this.id3HeaderBuffer.readSynchSafeInt() + 10);
    }

    @RequiresNonNull(value={"currentOutput"})
    private void readSample(ParsableByteArray parsableByteArray) {
        int n2 = Math.min(parsableByteArray.bytesLeft(), this.sampleSize - this.bytesRead);
        this.currentOutput.sampleData(parsableByteArray, n2);
        this.bytesRead += n2;
        n2 = this.bytesRead;
        int n3 = this.sampleSize;
        if (n2 == n3) {
            this.currentOutput.sampleMetadata(this.timeUs, 1, n3, 0, null);
            this.timeUs += this.currentSampleDuration;
            this.setFindingSampleState();
        }
    }

    private void resetSync() {
        this.foundFirstFrame = false;
        this.setFindingSampleState();
    }

    private void setCheckingAdtsHeaderState() {
        this.state = 1;
        this.bytesRead = 0;
    }

    private void setFindingSampleState() {
        this.state = 0;
        this.bytesRead = 0;
        this.matchState = 256;
    }

    private void setReadingAdtsHeaderState() {
        this.state = 3;
        this.bytesRead = 0;
    }

    private void setReadingId3HeaderState() {
        this.state = 2;
        this.bytesRead = ID3_IDENTIFIER.length;
        this.sampleSize = 0;
        this.id3HeaderBuffer.setPosition(0);
    }

    private void setReadingSampleState(TrackOutput trackOutput, long l2, int n2, int n3) {
        this.state = 4;
        this.bytesRead = n2;
        this.currentOutput = trackOutput;
        this.currentSampleDuration = l2;
        this.sampleSize = n3;
    }

    private boolean tryRead(ParsableByteArray parsableByteArray, byte[] byArray, int n2) {
        if (parsableByteArray.bytesLeft() < n2) {
            return false;
        }
        parsableByteArray.readBytes(byArray, 0, n2);
        return true;
    }

    @Override
    public void consume(ParsableByteArray parsableByteArray) throws ParserException {
        this.assertTracksCreated();
        while (parsableByteArray.bytesLeft() > 0) {
            int n2 = this.state;
            if (n2 != 0) {
                if (n2 != 1) {
                    if (n2 != 2) {
                        if (n2 != 3) {
                            if (n2 == 4) {
                                this.readSample(parsableByteArray);
                                continue;
                            }
                            throw new IllegalStateException();
                        }
                        n2 = this.hasCrc ? 7 : 5;
                        if (!this.continueRead(parsableByteArray, this.adtsScratch.data, n2)) continue;
                        this.parseAdtsHeader();
                        continue;
                    }
                    if (!this.continueRead(parsableByteArray, this.id3HeaderBuffer.getData(), 10)) continue;
                    this.parseId3Header();
                    continue;
                }
                this.checkAdtsHeader(parsableByteArray);
                continue;
            }
            this.findNextSample(parsableByteArray);
        }
    }

    @Override
    public void createTracks(ExtractorOutput extractorOutput, TsPayloadReader.TrackIdGenerator trackIdGenerator) {
        trackIdGenerator.generateNewId();
        this.formatId = trackIdGenerator.getFormatId();
        this.currentOutput = this.output = extractorOutput.track(trackIdGenerator.getTrackId(), 1);
        if (this.exposeId3) {
            trackIdGenerator.generateNewId();
            this.id3Output = extractorOutput.track(trackIdGenerator.getTrackId(), 5);
            this.id3Output.format(new Format.Builder().setId(trackIdGenerator.getFormatId()).setSampleMimeType("application/id3").build());
        } else {
            this.id3Output = new DummyTrackOutput();
        }
    }

    public long getSampleDurationUs() {
        return this.sampleDurationUs;
    }

    @Override
    public void packetFinished() {
    }

    @Override
    public void packetStarted(long l2, int n2) {
        this.timeUs = l2;
    }

    @Override
    public void seek() {
        this.resetSync();
    }
}

