/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.ts;

import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.audio.Ac4Util;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.extractor.ts.ElementaryStreamReader;
import com.google.android.exoplayer2.extractor.ts.TsPayloadReader;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ParsableBitArray;
import com.google.android.exoplayer2.util.ParsableByteArray;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

public final class Ac4Reader
implements ElementaryStreamReader {
    private static final int STATE_FINDING_SYNC = 0;
    private static final int STATE_READING_HEADER = 1;
    private static final int STATE_READING_SAMPLE = 2;
    private int bytesRead;
    private Format format;
    private String formatId;
    private boolean hasCRC;
    private final ParsableBitArray headerScratchBits = new ParsableBitArray(new byte[16]);
    private final ParsableByteArray headerScratchBytes;
    private final String language;
    private boolean lastByteWasAC;
    private TrackOutput output;
    private long sampleDurationUs;
    private int sampleSize;
    private int state;
    private long timeUs;

    public Ac4Reader() {
        this(null);
    }

    public Ac4Reader(String string2) {
        this.headerScratchBytes = new ParsableByteArray(this.headerScratchBits.data);
        this.state = 0;
        this.bytesRead = 0;
        this.lastByteWasAC = false;
        this.hasCRC = false;
        this.language = string2;
    }

    private boolean continueRead(ParsableByteArray parsableByteArray, byte[] byArray, int n2) {
        int n3 = Math.min(parsableByteArray.bytesLeft(), n2 - this.bytesRead);
        parsableByteArray.readBytes(byArray, this.bytesRead, n3);
        this.bytesRead += n3;
        boolean bl = this.bytesRead == n2;
        return bl;
    }

    @RequiresNonNull(value={"output"})
    private void parseHeader() {
        this.headerScratchBits.setPosition(0);
        Ac4Util.SyncFrameInfo syncFrameInfo = Ac4Util.parseAc4SyncframeInfo((ParsableBitArray)this.headerScratchBits);
        if (this.format == null || syncFrameInfo.channelCount != this.format.channelCount || syncFrameInfo.sampleRate != this.format.sampleRate || !"audio/ac4".equals(this.format.sampleMimeType)) {
            this.format = new Format.Builder().setId(this.formatId).setSampleMimeType("audio/ac4").setChannelCount(syncFrameInfo.channelCount).setSampleRate(syncFrameInfo.sampleRate).setLanguage(this.language).build();
            this.output.format(this.format);
        }
        this.sampleSize = syncFrameInfo.frameSize;
        this.sampleDurationUs = (long)syncFrameInfo.sampleCount * 1000000L / (long)this.format.sampleRate;
    }

    private boolean skipToNextSync(ParsableByteArray parsableByteArray) {
        block4: {
            boolean bl;
            boolean bl2;
            int n2;
            while (true) {
                n2 = parsableByteArray.bytesLeft();
                bl2 = false;
                bl = false;
                if (n2 <= 0) break block4;
                if (!this.lastByteWasAC) {
                    if (parsableByteArray.readUnsignedByte() == 172) {
                        bl = true;
                    }
                    this.lastByteWasAC = bl;
                    continue;
                }
                n2 = parsableByteArray.readUnsignedByte();
                bl = n2 == 172;
                this.lastByteWasAC = bl;
                if (n2 == 64 || n2 == 65) break;
            }
            bl = bl2;
            if (n2 == 65) {
                bl = true;
            }
            this.hasCRC = bl;
            return true;
        }
        return false;
    }

    @Override
    public void consume(ParsableByteArray parsableByteArray) {
        Assertions.checkStateNotNull(this.output);
        while (parsableByteArray.bytesLeft() > 0) {
            int n2 = this.state;
            if (n2 != 0) {
                if (n2 != 1) {
                    if (n2 != 2) continue;
                    n2 = Math.min(parsableByteArray.bytesLeft(), this.sampleSize - this.bytesRead);
                    this.output.sampleData(parsableByteArray, n2);
                    this.bytesRead += n2;
                    int n3 = this.bytesRead;
                    n2 = this.sampleSize;
                    if (n3 != n2) continue;
                    this.output.sampleMetadata(this.timeUs, 1, n2, 0, null);
                    this.timeUs += this.sampleDurationUs;
                    this.state = 0;
                    continue;
                }
                if (!this.continueRead(parsableByteArray, this.headerScratchBytes.getData(), 16)) continue;
                this.parseHeader();
                this.headerScratchBytes.setPosition(0);
                this.output.sampleData(this.headerScratchBytes, 16);
                this.state = 2;
                continue;
            }
            if (!this.skipToNextSync(parsableByteArray)) continue;
            this.state = 1;
            this.headerScratchBytes.getData()[0] = (byte)-84;
            byte[] byArray = this.headerScratchBytes.getData();
            n2 = this.hasCRC ? 65 : 64;
            byArray[1] = (byte)n2;
            this.bytesRead = 2;
        }
    }

    @Override
    public void createTracks(ExtractorOutput extractorOutput, TsPayloadReader.TrackIdGenerator trackIdGenerator) {
        trackIdGenerator.generateNewId();
        this.formatId = trackIdGenerator.getFormatId();
        this.output = extractorOutput.track(trackIdGenerator.getTrackId(), 1);
    }

    @Override
    public void packetFinished() {
    }

    @Override
    public void packetStarted(long l2, int n2) {
        this.timeUs = l2;
    }

    @Override
    public void seek() {
        this.state = 0;
        this.bytesRead = 0;
        this.lastByteWasAC = false;
        this.hasCRC = false;
    }
}

