/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.ts;

import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.audio.Ac3Util;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.extractor.ts.ElementaryStreamReader;
import com.google.android.exoplayer2.extractor.ts.TsPayloadReader;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ParsableBitArray;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

public final class Ac3Reader
implements ElementaryStreamReader {
    private static final int HEADER_SIZE = 128;
    private static final int STATE_FINDING_SYNC = 0;
    private static final int STATE_READING_HEADER = 1;
    private static final int STATE_READING_SAMPLE = 2;
    private int bytesRead;
    private Format format;
    private String formatId;
    private final ParsableBitArray headerScratchBits = new ParsableBitArray(new byte[128]);
    private final ParsableByteArray headerScratchBytes;
    private final String language;
    private boolean lastByteWas0B;
    private TrackOutput output;
    private long sampleDurationUs;
    private int sampleSize;
    private int state;
    private long timeUs;

    public Ac3Reader() {
        this(null);
    }

    public Ac3Reader(String string2) {
        this.headerScratchBytes = new ParsableByteArray(this.headerScratchBits.data);
        this.state = 0;
        this.language = string2;
    }

    private boolean continueRead(ParsableByteArray parsableByteArray, byte[] byArray, int n2) {
        int n3 = Math.min(parsableByteArray.bytesLeft(), n2 - this.bytesRead);
        parsableByteArray.readBytes(byArray, this.bytesRead, n3);
        this.bytesRead += n3;
        boolean bl = this.bytesRead == n2;
        return bl;
    }

    @RequiresNonNull(value={"output"})
    private void parseHeader() {
        this.headerScratchBits.setPosition(0);
        Ac3Util.SyncFrameInfo syncFrameInfo = Ac3Util.parseAc3SyncframeInfo(this.headerScratchBits);
        if (this.format == null || syncFrameInfo.channelCount != this.format.channelCount || syncFrameInfo.sampleRate != this.format.sampleRate || !Util.areEqual(syncFrameInfo.mimeType, this.format.sampleMimeType)) {
            this.format = new Format.Builder().setId(this.formatId).setSampleMimeType(syncFrameInfo.mimeType).setChannelCount(syncFrameInfo.channelCount).setSampleRate(syncFrameInfo.sampleRate).setLanguage(this.language).build();
            this.output.format(this.format);
        }
        this.sampleSize = syncFrameInfo.frameSize;
        this.sampleDurationUs = (long)syncFrameInfo.sampleCount * 1000000L / (long)this.format.sampleRate;
    }

    private boolean skipToNextSync(ParsableByteArray parsableByteArray) {
        while (true) {
            int n2 = parsableByteArray.bytesLeft();
            boolean bl = false;
            boolean bl2 = false;
            if (n2 <= 0) break;
            if (!this.lastByteWas0B) {
                if (parsableByteArray.readUnsignedByte() == 11) {
                    bl2 = true;
                }
                this.lastByteWas0B = bl2;
                continue;
            }
            n2 = parsableByteArray.readUnsignedByte();
            if (n2 == 119) {
                this.lastByteWas0B = false;
                return true;
            }
            bl2 = bl;
            if (n2 == 11) {
                bl2 = true;
            }
            this.lastByteWas0B = bl2;
        }
        return false;
    }

    @Override
    public void consume(ParsableByteArray parsableByteArray) {
        Assertions.checkStateNotNull(this.output);
        while (parsableByteArray.bytesLeft() > 0) {
            int n2 = this.state;
            if (n2 != 0) {
                if (n2 != 1) {
                    if (n2 != 2) continue;
                    n2 = Math.min(parsableByteArray.bytesLeft(), this.sampleSize - this.bytesRead);
                    this.output.sampleData(parsableByteArray, n2);
                    this.bytesRead += n2;
                    int n3 = this.bytesRead;
                    n2 = this.sampleSize;
                    if (n3 != n2) continue;
                    this.output.sampleMetadata(this.timeUs, 1, n2, 0, null);
                    this.timeUs += this.sampleDurationUs;
                    this.state = 0;
                    continue;
                }
                if (!this.continueRead(parsableByteArray, this.headerScratchBytes.getData(), 128)) continue;
                this.parseHeader();
                this.headerScratchBytes.setPosition(0);
                this.output.sampleData(this.headerScratchBytes, 128);
                this.state = 2;
                continue;
            }
            if (!this.skipToNextSync(parsableByteArray)) continue;
            this.state = 1;
            this.headerScratchBytes.getData()[0] = (byte)11;
            this.headerScratchBytes.getData()[1] = (byte)119;
            this.bytesRead = 2;
        }
    }

    @Override
    public void createTracks(ExtractorOutput extractorOutput, TsPayloadReader.TrackIdGenerator trackIdGenerator) {
        trackIdGenerator.generateNewId();
        this.formatId = trackIdGenerator.getFormatId();
        this.output = extractorOutput.track(trackIdGenerator.getTrackId(), 1);
    }

    @Override
    public void packetFinished() {
    }

    @Override
    public void packetStarted(long l2, int n2) {
        this.timeUs = l2;
    }

    @Override
    public void seek() {
        this.state = 0;
        this.bytesRead = 0;
        this.lastByteWas0B = false;
    }
}

