/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.rawcc;

import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.PositionHolder;
import com.google.android.exoplayer2.extractor.SeekMap;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ParsableByteArray;
import java.io.IOException;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

public final class RawCcExtractor
implements Extractor {
    private static final int HEADER_ID = 1380139777;
    private static final int HEADER_SIZE = 8;
    private static final int SCRATCH_SIZE = 9;
    private static final int STATE_READING_HEADER = 0;
    private static final int STATE_READING_SAMPLES = 2;
    private static final int STATE_READING_TIMESTAMP_AND_COUNT = 1;
    private static final int TIMESTAMP_SIZE_V0 = 4;
    private static final int TIMESTAMP_SIZE_V1 = 8;
    private final ParsableByteArray dataScratch;
    private final Format format;
    private int parserState;
    private int remainingSampleCount;
    private int sampleBytesWritten;
    private long timestampUs;
    private TrackOutput trackOutput;
    private int version;

    public RawCcExtractor(Format format) {
        this.format = format;
        this.dataScratch = new ParsableByteArray(9);
        this.parserState = 0;
    }

    private boolean parseHeader(ExtractorInput extractorInput) throws IOException {
        this.dataScratch.reset(8);
        if (extractorInput.readFully(this.dataScratch.getData(), 0, 8, true)) {
            if (this.dataScratch.readInt() == 1380139777) {
                this.version = this.dataScratch.readUnsignedByte();
                return true;
            }
            throw new IOException("Input not RawCC");
        }
        return false;
    }

    @RequiresNonNull(value={"trackOutput"})
    private void parseSamples(ExtractorInput extractorInput) throws IOException {
        while (this.remainingSampleCount > 0) {
            this.dataScratch.reset(3);
            extractorInput.readFully(this.dataScratch.getData(), 0, 3);
            this.trackOutput.sampleData(this.dataScratch, 3);
            this.sampleBytesWritten += 3;
            --this.remainingSampleCount;
        }
        int n2 = this.sampleBytesWritten;
        if (n2 > 0) {
            this.trackOutput.sampleMetadata(this.timestampUs, 1, n2, 0, null);
        }
    }

    private boolean parseTimestampAndSampleCount(ExtractorInput object) throws IOException {
        block7: {
            block6: {
                int n2;
                block5: {
                    n2 = this.version;
                    if (n2 != 0) break block5;
                    this.dataScratch.reset(5);
                    if (!object.readFully(this.dataScratch.getData(), 0, 5, true)) {
                        return false;
                    }
                    this.timestampUs = this.dataScratch.readUnsignedInt() * 1000L / 45L;
                    break block6;
                }
                if (n2 != 1) break block7;
                this.dataScratch.reset(9);
                if (!object.readFully(this.dataScratch.getData(), 0, 9, true)) {
                    return false;
                }
                this.timestampUs = this.dataScratch.readLong();
            }
            this.remainingSampleCount = this.dataScratch.readUnsignedByte();
            this.sampleBytesWritten = 0;
            return true;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Unsupported version number: ");
        ((StringBuilder)object).append(this.version);
        throw new ParserException(((StringBuilder)object).toString());
    }

    @Override
    public void init(ExtractorOutput extractorOutput) {
        extractorOutput.seekMap(new SeekMap.Unseekable(-9223372036854775807L));
        this.trackOutput = extractorOutput.track(0, 3);
        this.trackOutput.format(this.format);
        extractorOutput.endTracks();
    }

    @Override
    public int read(ExtractorInput extractorInput, PositionHolder positionHolder) throws IOException {
        Assertions.checkStateNotNull(this.trackOutput);
        while (true) {
            int n2;
            if ((n2 = this.parserState) != 0) {
                if (n2 != 1) {
                    if (n2 == 2) {
                        this.parseSamples(extractorInput);
                        this.parserState = 1;
                        return 0;
                    }
                    throw new IllegalStateException();
                }
                if (this.parseTimestampAndSampleCount(extractorInput)) {
                    this.parserState = 2;
                    continue;
                }
                this.parserState = 0;
                return -1;
            }
            if (!this.parseHeader(extractorInput)) break;
            this.parserState = 1;
        }
        return -1;
    }

    @Override
    public void release() {
    }

    @Override
    public void seek(long l2, long l3) {
        this.parserState = 0;
    }

    @Override
    public boolean sniff(ExtractorInput extractorInput) throws IOException {
        this.dataScratch.reset(8);
        byte[] byArray = this.dataScratch.getData();
        boolean bl = false;
        extractorInput.peekFully(byArray, 0, 8);
        if (this.dataScratch.readInt() == 1380139777) {
            bl = true;
        }
        return bl;
    }
}

