/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.ogg;

import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.extractor.VorbisUtil;
import com.google.android.exoplayer2.extractor.ogg.StreamReader;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ParsableByteArray;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;

final class VorbisReader
extends StreamReader {
    private VorbisUtil.CommentHeader commentHeader;
    private int previousPacketBlockSize;
    private boolean seenFirstAudioPacket;
    private VorbisUtil.VorbisIdHeader vorbisIdHeader;
    private VorbisSetup vorbisSetup;

    VorbisReader() {
    }

    static void appendNumberOfSamples(ParsableByteArray parsableByteArray, long l2) {
        if (parsableByteArray.capacity() < parsableByteArray.limit() + 4) {
            parsableByteArray.reset(Arrays.copyOf(parsableByteArray.getData(), parsableByteArray.limit() + 4));
        } else {
            parsableByteArray.setLimit(parsableByteArray.limit() + 4);
        }
        byte[] byArray = parsableByteArray.getData();
        byArray[parsableByteArray.limit() - 4] = (byte)(l2 & 0xFFL);
        byArray[parsableByteArray.limit() - 3] = (byte)(l2 >>> 8 & 0xFFL);
        byArray[parsableByteArray.limit() - 2] = (byte)(l2 >>> 16 & 0xFFL);
        byArray[parsableByteArray.limit() - 1] = (byte)(l2 >>> 24 & 0xFFL);
    }

    private static int decodeBlockSize(byte by2, VorbisSetup vorbisSetup) {
        int n2 = VorbisReader.readBits(by2, vorbisSetup.iLogModes, 1);
        n2 = !vorbisSetup.modes[n2].blockFlag ? vorbisSetup.idHeader.blockSize0 : vorbisSetup.idHeader.blockSize1;
        return n2;
    }

    static int readBits(byte by2, int n2, int n3) {
        return by2 >> n3 & 255 >>> 8 - n2;
    }

    public static boolean verifyBitstreamType(ParsableByteArray parsableByteArray) {
        try {
            boolean bl = VorbisUtil.verifyVorbisHeaderCapturePattern((int)1, (ParsableByteArray)parsableByteArray, (boolean)true);
            return bl;
        }
        catch (ParserException parserException) {
            return false;
        }
    }

    @Override
    protected void onSeekEnd(long l2) {
        super.onSeekEnd(l2);
        int n2 = 0;
        boolean bl = l2 != 0L;
        this.seenFirstAudioPacket = bl;
        VorbisUtil.VorbisIdHeader vorbisIdHeader = this.vorbisIdHeader;
        if (vorbisIdHeader != null) {
            n2 = vorbisIdHeader.blockSize0;
        }
        this.previousPacketBlockSize = n2;
    }

    @Override
    protected long preparePayload(ParsableByteArray parsableByteArray) {
        byte[] byArray = parsableByteArray.getData();
        int n2 = 0;
        if ((byArray[0] & 1) == 1) {
            return -1L;
        }
        int n3 = VorbisReader.decodeBlockSize(parsableByteArray.getData()[0], Assertions.checkStateNotNull(this.vorbisSetup));
        if (this.seenFirstAudioPacket) {
            n2 = (this.previousPacketBlockSize + n3) / 4;
        }
        long l2 = n2;
        VorbisReader.appendNumberOfSamples(parsableByteArray, l2);
        this.seenFirstAudioPacket = true;
        this.previousPacketBlockSize = n3;
        return l2;
    }

    @Override
    @EnsuresNonNullIf(expression={"#3.format"}, result=false)
    protected boolean readHeaders(ParsableByteArray object, long l2, StreamReader.SetupData setupData) throws IOException {
        if (this.vorbisSetup != null) {
            Assertions.checkNotNull(setupData.format);
            return false;
        }
        this.vorbisSetup = this.readSetupHeaders((ParsableByteArray)object);
        object = this.vorbisSetup;
        if (object == null) {
            return true;
        }
        VorbisUtil.VorbisIdHeader vorbisIdHeader = object.idHeader;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        arrayList.add(vorbisIdHeader.data);
        arrayList.add(object.setupHeaderData);
        setupData.format = new Format.Builder().setSampleMimeType("audio/vorbis").setAverageBitrate(vorbisIdHeader.bitrateNominal).setPeakBitrate(vorbisIdHeader.bitrateMaximum).setChannelCount(vorbisIdHeader.channels).setSampleRate(vorbisIdHeader.sampleRate).setInitializationData(arrayList).build();
        return true;
    }

    VorbisSetup readSetupHeaders(ParsableByteArray modeArray) throws IOException {
        VorbisUtil.VorbisIdHeader vorbisIdHeader = this.vorbisIdHeader;
        if (vorbisIdHeader == null) {
            this.vorbisIdHeader = VorbisUtil.readVorbisIdentificationHeader((ParsableByteArray)modeArray);
            return null;
        }
        VorbisUtil.CommentHeader commentHeader = this.commentHeader;
        if (commentHeader == null) {
            this.commentHeader = VorbisUtil.readVorbisCommentHeader((ParsableByteArray)modeArray);
            return null;
        }
        byte[] byArray = new byte[modeArray.limit()];
        System.arraycopy(modeArray.getData(), 0, byArray, 0, modeArray.limit());
        modeArray = VorbisUtil.readVorbisModes((ParsableByteArray)modeArray, (int)vorbisIdHeader.channels);
        return new VorbisSetup(vorbisIdHeader, commentHeader, byArray, modeArray, VorbisUtil.iLog((int)(modeArray.length - 1)));
    }

    @Override
    protected void reset(boolean bl) {
        super.reset(bl);
        if (bl) {
            this.vorbisSetup = null;
            this.vorbisIdHeader = null;
            this.commentHeader = null;
        }
        this.previousPacketBlockSize = 0;
        this.seenFirstAudioPacket = false;
    }

    static final class VorbisSetup {
        public final VorbisUtil.CommentHeader commentHeader;
        public final int iLogModes;
        public final VorbisUtil.VorbisIdHeader idHeader;
        public final VorbisUtil.Mode[] modes;
        public final byte[] setupHeaderData;

        public VorbisSetup(VorbisUtil.VorbisIdHeader vorbisIdHeader, VorbisUtil.CommentHeader commentHeader, byte[] byArray, VorbisUtil.Mode[] modeArray, int n2) {
            this.idHeader = vorbisIdHeader;
            this.commentHeader = commentHeader;
            this.setupHeaderData = byArray;
            this.modes = modeArray;
            this.iLogModes = n2;
        }
    }
}

