/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.ogg;

import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.PositionHolder;
import com.google.android.exoplayer2.extractor.SeekMap;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.extractor.ogg.DefaultOggSeeker;
import com.google.android.exoplayer2.extractor.ogg.OggPacket;
import com.google.android.exoplayer2.extractor.ogg.OggPageHeader;
import com.google.android.exoplayer2.extractor.ogg.OggSeeker;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

abstract class StreamReader {
    private static final int STATE_END_OF_INPUT = 3;
    private static final int STATE_READ_HEADERS = 0;
    private static final int STATE_READ_PAYLOAD = 2;
    private static final int STATE_SKIP_HEADERS = 1;
    private long currentGranule;
    private ExtractorOutput extractorOutput;
    private boolean formatSet;
    private long lengthOfReadPacket;
    private final OggPacket oggPacket = new OggPacket();
    private OggSeeker oggSeeker;
    private long payloadStartPosition;
    private int sampleRate;
    private boolean seekMapSet;
    private SetupData setupData = new SetupData();
    private int state;
    private long targetGranule;
    private TrackOutput trackOutput;

    @EnsuresNonNull(value={"trackOutput", "extractorOutput"})
    private void assertInitialized() {
        Assertions.checkStateNotNull(this.trackOutput);
        Util.castNonNull(this.extractorOutput);
    }

    @EnsuresNonNullIf(expression={"setupData.format"}, result=true)
    private boolean readHeaders(ExtractorInput extractorInput) throws IOException {
        while (true) {
            if (!this.oggPacket.populate(extractorInput)) {
                this.state = 3;
                return false;
            }
            this.lengthOfReadPacket = extractorInput.getPosition() - this.payloadStartPosition;
            if (!this.readHeaders(this.oggPacket.getPayload(), this.payloadStartPosition, this.setupData)) break;
            this.payloadStartPosition = extractorInput.getPosition();
        }
        return true;
    }

    @RequiresNonNull(value={"trackOutput"})
    private int readHeadersAndUpdateState(ExtractorInput extractorInput) throws IOException {
        if (!this.readHeaders(extractorInput)) {
            return -1;
        }
        this.sampleRate = this.setupData.format.sampleRate;
        if (!this.formatSet) {
            this.trackOutput.format(this.setupData.format);
            this.formatSet = true;
        }
        if (this.setupData.oggSeeker != null) {
            this.oggSeeker = this.setupData.oggSeeker;
        } else if (extractorInput.getLength() == -1L) {
            this.oggSeeker = new UnseekableOggSeeker();
        } else {
            OggPageHeader oggPageHeader = this.oggPacket.getPageHeader();
            boolean bl = (oggPageHeader.type & 4) != 0;
            this.oggSeeker = new DefaultOggSeeker(this, this.payloadStartPosition, extractorInput.getLength(), (long)(oggPageHeader.headerSize + oggPageHeader.bodySize), oggPageHeader.granulePosition, bl);
        }
        this.state = 2;
        this.oggPacket.trimPayload();
        return 0;
    }

    @RequiresNonNull(value={"trackOutput", "oggSeeker", "extractorOutput"})
    private int readPayload(ExtractorInput extractorInput, PositionHolder object) throws IOException {
        long l2;
        long l3 = this.oggSeeker.read(extractorInput);
        if (l3 >= 0L) {
            object.position = l3;
            return 1;
        }
        if (l3 < -1L) {
            this.onSeekEnd(-(l3 + 2L));
        }
        if (!this.seekMapSet) {
            object = Assertions.checkStateNotNull(this.oggSeeker.createSeekMap());
            this.extractorOutput.seekMap((SeekMap)object);
            this.seekMapSet = true;
        }
        if (this.lengthOfReadPacket <= 0L && !this.oggPacket.populate(extractorInput)) {
            this.state = 3;
            return -1;
        }
        this.lengthOfReadPacket = 0L;
        extractorInput = this.oggPacket.getPayload();
        l3 = this.preparePayload((ParsableByteArray)extractorInput);
        if (l3 >= 0L && (l2 = this.currentGranule) + l3 >= this.targetGranule) {
            l2 = this.convertGranuleToTime(l2);
            this.trackOutput.sampleData((ParsableByteArray)extractorInput, extractorInput.limit());
            this.trackOutput.sampleMetadata(l2, 1, extractorInput.limit(), 0, null);
            this.targetGranule = -1L;
        }
        this.currentGranule += l3;
        return 0;
    }

    protected long convertGranuleToTime(long l2) {
        return l2 * 1000000L / (long)this.sampleRate;
    }

    protected long convertTimeToGranule(long l2) {
        return (long)this.sampleRate * l2 / 1000000L;
    }

    void init(ExtractorOutput extractorOutput, TrackOutput trackOutput) {
        this.extractorOutput = extractorOutput;
        this.trackOutput = trackOutput;
        this.reset(true);
    }

    protected void onSeekEnd(long l2) {
        this.currentGranule = l2;
    }

    protected abstract long preparePayload(ParsableByteArray var1);

    final int read(ExtractorInput extractorInput, PositionHolder positionHolder) throws IOException {
        this.assertInitialized();
        int n2 = this.state;
        if (n2 != 0) {
            if (n2 != 1) {
                if (n2 != 2) {
                    if (n2 == 3) {
                        return -1;
                    }
                    throw new IllegalStateException();
                }
                Util.castNonNull(this.oggSeeker);
                return this.readPayload(extractorInput, positionHolder);
            }
            extractorInput.skipFully((int)this.payloadStartPosition);
            this.state = 2;
            return 0;
        }
        return this.readHeadersAndUpdateState(extractorInput);
    }

    @EnsuresNonNullIf(expression={"#3.format"}, result=false)
    protected abstract boolean readHeaders(ParsableByteArray var1, long var2, SetupData var4) throws IOException;

    protected void reset(boolean bl) {
        if (bl) {
            this.setupData = new SetupData();
            this.payloadStartPosition = 0L;
            this.state = 0;
        } else {
            this.state = 1;
        }
        this.targetGranule = -1L;
        this.currentGranule = 0L;
    }

    final void seek(long l2, long l3) {
        this.oggPacket.reset();
        if (l2 == 0L) {
            this.reset(this.seekMapSet ^ true);
        } else if (this.state != 0) {
            this.targetGranule = this.convertTimeToGranule(l3);
            Util.castNonNull(this.oggSeeker).startSeek(this.targetGranule);
            this.state = 2;
        }
    }

    static class SetupData {
        Format format;
        OggSeeker oggSeeker;

        SetupData() {
        }
    }

    private static final class UnseekableOggSeeker
    implements OggSeeker {
        private UnseekableOggSeeker() {
        }

        public SeekMap createSeekMap() {
            return new SeekMap.Unseekable(-9223372036854775807L);
        }

        public long read(ExtractorInput extractorInput) {
            return -1L;
        }

        public void startSeek(long l2) {
        }
    }
}

