/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.ogg;

import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.audio.OpusUtil;
import com.google.android.exoplayer2.extractor.ogg.StreamReader;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ParsableByteArray;
import java.util.Arrays;
import java.util.List;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;

final class OpusReader
extends StreamReader {
    private static final int OPUS_CODE = 1332770163;
    private static final byte[] OPUS_SIGNATURE = new byte[]{79, 112, 117, 115, 72, 101, 97, 100};
    private boolean headerRead;

    OpusReader() {
    }

    private long getPacketDurationUs(byte[] byArray) {
        int n2;
        int n3 = byArray[0] & 0xFF;
        int n4 = n3 & 3;
        int n5 = 2;
        if (n4 != 0) {
            n2 = n5;
            if (n4 != 1) {
                n2 = n5;
                if (n4 != 2) {
                    n2 = byArray[1] & 0x3F;
                }
            }
        } else {
            n2 = 1;
        }
        n5 = (n3 >>= 3) & 3;
        n5 = n3 >= 16 ? 2500 << n5 : (n3 >= 12 ? 10000 << (n5 & 1) : (n5 == 3 ? 60000 : 10000 << n5));
        return (long)n2 * (long)n5;
    }

    public static boolean verifyBitstreamType(ParsableByteArray parsableByteArray) {
        byte[] byArray;
        int n2 = parsableByteArray.bytesLeft();
        if (n2 < (byArray = OPUS_SIGNATURE).length) {
            return false;
        }
        byte[] byArray2 = new byte[byArray.length];
        parsableByteArray.readBytes(byArray2, 0, byArray.length);
        return Arrays.equals(byArray2, OPUS_SIGNATURE);
    }

    @Override
    protected long preparePayload(ParsableByteArray parsableByteArray) {
        return this.convertTimeToGranule(this.getPacketDurationUs(parsableByteArray.getData()));
    }

    @Override
    @EnsuresNonNullIf(expression={"#3.format"}, result=false)
    protected boolean readHeaders(ParsableByteArray object, long l2, StreamReader.SetupData setupData) {
        boolean bl = this.headerRead;
        boolean bl2 = true;
        if (!bl) {
            object = Arrays.copyOf(object.getData(), object.limit());
            int n2 = OpusUtil.getChannelCount((byte[])object);
            object = OpusUtil.buildInitializationData((byte[])object);
            setupData.format = new Format.Builder().setSampleMimeType("audio/opus").setChannelCount(n2).setSampleRate(48000).setInitializationData((List)object).build();
            this.headerRead = true;
            return true;
        }
        Assertions.checkNotNull(setupData.format);
        if (object.readInt() != 1332770163) {
            bl2 = false;
        }
        object.setPosition(0);
        return bl2;
    }

    @Override
    protected void reset(boolean bl) {
        super.reset(bl);
        if (bl) {
            this.headerRead = false;
        }
    }
}

