/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.ogg;

import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.extractor.PositionHolder;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.extractor.ogg.FlacReader;
import com.google.android.exoplayer2.extractor.ogg.OggPageHeader;
import com.google.android.exoplayer2.extractor.ogg.OpusReader;
import com.google.android.exoplayer2.extractor.ogg.StreamReader;
import com.google.android.exoplayer2.extractor.ogg.VorbisReader;
import com.google.android.exoplayer2.extractor.ogg._$$Lambda$OggExtractor$Ibu4KG2n586HVQ8R_UQJ8hUhsso;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ParsableByteArray;
import java.io.IOException;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;

public class OggExtractor
implements Extractor {
    public static final ExtractorsFactory FACTORY = _$$Lambda$OggExtractor$Ibu4KG2n586HVQ8R_UQJ8hUhsso.INSTANCE;
    private static final int MAX_VERIFICATION_BYTES = 8;
    private ExtractorOutput output;
    private StreamReader streamReader;
    private boolean streamReaderInitialized;

    static /* synthetic */ Extractor[] lambda$static$0() {
        return new Extractor[]{new OggExtractor()};
    }

    private static ParsableByteArray resetPosition(ParsableByteArray parsableByteArray) {
        parsableByteArray.setPosition(0);
        return parsableByteArray;
    }

    @EnsuresNonNullIf(expression={"streamReader"}, result=true)
    private boolean sniffInternal(ExtractorInput extractorInput) throws IOException {
        block2: {
            block4: {
                OggPageHeader oggPageHeader;
                block5: {
                    block3: {
                        oggPageHeader = new OggPageHeader();
                        if (!oggPageHeader.populate(extractorInput, true) || (oggPageHeader.type & 2) != 2) break block2;
                        int n2 = Math.min(oggPageHeader.bodySize, 8);
                        oggPageHeader = new ParsableByteArray(n2);
                        extractorInput.peekFully(oggPageHeader.getData(), 0, n2);
                        if (!FlacReader.verifyBitstreamType(OggExtractor.resetPosition((ParsableByteArray)oggPageHeader))) break block3;
                        this.streamReader = new FlacReader();
                        break block4;
                    }
                    if (!VorbisReader.verifyBitstreamType(OggExtractor.resetPosition((ParsableByteArray)oggPageHeader))) break block5;
                    this.streamReader = new VorbisReader();
                    break block4;
                }
                if (!OpusReader.verifyBitstreamType(OggExtractor.resetPosition((ParsableByteArray)oggPageHeader))) break block2;
                this.streamReader = new OpusReader();
            }
            return true;
        }
        return false;
    }

    @Override
    public void init(ExtractorOutput extractorOutput) {
        this.output = extractorOutput;
    }

    @Override
    public int read(ExtractorInput extractorInput, PositionHolder positionHolder) throws IOException {
        Assertions.checkStateNotNull(this.output);
        if (this.streamReader == null) {
            if (this.sniffInternal(extractorInput)) {
                extractorInput.resetPeekPosition();
            } else {
                throw new ParserException("Failed to determine bitstream type");
            }
        }
        if (!this.streamReaderInitialized) {
            TrackOutput trackOutput = this.output.track(0, 1);
            this.output.endTracks();
            this.streamReader.init(this.output, trackOutput);
            this.streamReaderInitialized = true;
        }
        return this.streamReader.read(extractorInput, positionHolder);
    }

    @Override
    public void release() {
    }

    @Override
    public void seek(long l2, long l3) {
        StreamReader streamReader = this.streamReader;
        if (streamReader != null) {
            streamReader.seek(l2, l3);
        }
    }

    @Override
    public boolean sniff(ExtractorInput extractorInput) throws IOException {
        try {
            boolean bl = this.sniffInternal(extractorInput);
            return bl;
        }
        catch (ParserException parserException) {
            return false;
        }
    }
}

