/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.ogg;

import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.FlacFrameReader;
import com.google.android.exoplayer2.extractor.FlacMetadataReader;
import com.google.android.exoplayer2.extractor.FlacSeekTableSeekMap;
import com.google.android.exoplayer2.extractor.FlacStreamMetadata;
import com.google.android.exoplayer2.extractor.SeekMap;
import com.google.android.exoplayer2.extractor.ogg.OggSeeker;
import com.google.android.exoplayer2.extractor.ogg.StreamReader;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;

final class FlacReader
extends StreamReader {
    private static final byte AUDIO_PACKET_TYPE = -1;
    private static final int FRAME_HEADER_SAMPLE_NUMBER_OFFSET = 4;
    private FlacOggSeeker flacOggSeeker;
    private FlacStreamMetadata streamMetadata;

    FlacReader() {
    }

    private int getFlacFrameBlockSize(ParsableByteArray parsableByteArray) {
        int n2 = (parsableByteArray.getData()[2] & 0xFF) >> 4;
        if (n2 == 6 || n2 == 7) {
            parsableByteArray.skipBytes(4);
            parsableByteArray.readUtf8EncodedLong();
        }
        n2 = FlacFrameReader.readFrameBlockSizeSamplesFromKey((ParsableByteArray)parsableByteArray, (int)n2);
        parsableByteArray.setPosition(0);
        return n2;
    }

    private static boolean isAudioPacket(byte[] byArray) {
        boolean bl = false;
        if (byArray[0] == -1) {
            bl = true;
        }
        return bl;
    }

    public static boolean verifyBitstreamType(ParsableByteArray parsableByteArray) {
        boolean bl = parsableByteArray.bytesLeft() >= 5 && parsableByteArray.readUnsignedByte() == 127 && parsableByteArray.readUnsignedInt() == 1179402563L;
        return bl;
    }

    @Override
    protected long preparePayload(ParsableByteArray parsableByteArray) {
        if (!FlacReader.isAudioPacket(parsableByteArray.getData())) {
            return -1L;
        }
        return this.getFlacFrameBlockSize(parsableByteArray);
    }

    @Override
    @EnsuresNonNullIf(expression={"#3.format"}, result=false)
    protected boolean readHeaders(ParsableByteArray object, long l2, StreamReader.SetupData setupData) {
        byte[] byArray = object.getData();
        FlacStreamMetadata flacStreamMetadata = this.streamMetadata;
        if (flacStreamMetadata == null) {
            this.streamMetadata = flacStreamMetadata = new FlacStreamMetadata(byArray, 17);
            setupData.format = flacStreamMetadata.getFormat(Arrays.copyOfRange(byArray, 9, object.limit()), null);
            return true;
        }
        if ((byArray[0] & 0x7F) == 3) {
            object = FlacMetadataReader.readSeekTableMetadataBlock((ParsableByteArray)object);
            setupData = flacStreamMetadata.copyWithSeekTable((FlacStreamMetadata.SeekTable)object);
            this.streamMetadata = setupData;
            this.flacOggSeeker = new FlacOggSeeker((FlacStreamMetadata)setupData, (FlacStreamMetadata.SeekTable)object);
            return true;
        }
        if (FlacReader.isAudioPacket(byArray)) {
            object = this.flacOggSeeker;
            if (object != null) {
                ((FlacOggSeeker)object).setFirstFrameOffset(l2);
                setupData.oggSeeker = this.flacOggSeeker;
            }
            Assertions.checkNotNull(setupData.format);
            return false;
        }
        return true;
    }

    @Override
    protected void reset(boolean bl) {
        super.reset(bl);
        if (bl) {
            this.streamMetadata = null;
            this.flacOggSeeker = null;
        }
    }

    private static final class FlacOggSeeker
    implements OggSeeker {
        private long firstFrameOffset;
        private long pendingSeekGranule;
        private FlacStreamMetadata.SeekTable seekTable;
        private FlacStreamMetadata streamMetadata;

        public FlacOggSeeker(FlacStreamMetadata flacStreamMetadata, FlacStreamMetadata.SeekTable seekTable) {
            this.streamMetadata = flacStreamMetadata;
            this.seekTable = seekTable;
            this.firstFrameOffset = -1L;
            this.pendingSeekGranule = -1L;
        }

        public SeekMap createSeekMap() {
            boolean bl = this.firstFrameOffset != -1L;
            Assertions.checkState(bl);
            return new FlacSeekTableSeekMap(this.streamMetadata, this.firstFrameOffset);
        }

        public long read(ExtractorInput extractorInput) {
            long l2 = this.pendingSeekGranule;
            if (l2 >= 0L) {
                l2 = -(l2 + 2L);
                this.pendingSeekGranule = -1L;
                return l2;
            }
            return -1L;
        }

        public void setFirstFrameOffset(long l2) {
            this.firstFrameOffset = l2;
        }

        public void startSeek(long l2) {
            long[] lArray = this.seekTable.pointSampleNumbers;
            this.pendingSeekGranule = lArray[Util.binarySearchFloor(lArray, l2, true, true)];
        }
    }
}

