/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.mp4;

import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.audio.Ac4Util;
import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.extractor.GaplessInfoHolder;
import com.google.android.exoplayer2.extractor.PositionHolder;
import com.google.android.exoplayer2.extractor.SeekMap;
import com.google.android.exoplayer2.extractor.SeekPoint;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.extractor.mp4.Atom;
import com.google.android.exoplayer2.extractor.mp4.AtomParsers;
import com.google.android.exoplayer2.extractor.mp4.MetadataUtil;
import com.google.android.exoplayer2.extractor.mp4.SefReader;
import com.google.android.exoplayer2.extractor.mp4.Sniffer;
import com.google.android.exoplayer2.extractor.mp4.Track;
import com.google.android.exoplayer2.extractor.mp4.TrackSampleTable;
import com.google.android.exoplayer2.extractor.mp4._$$Lambda$Mp4Extractor$jNmPwqo4_EkxjMq3riO8isp5v1k;
import com.google.android.exoplayer2.extractor.mp4._$$Lambda$Mp4Extractor$quy71uYOGsneho91FZy1d2UGE1Q;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.metadata.mp4.MotionPhotoMetadata;
import com.google.android.exoplayer2.upstream.DataReader;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.NalUnitUtil;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import com.google.common.base.Function;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

public final class Mp4Extractor
implements Extractor,
SeekMap {
    public static final ExtractorsFactory FACTORY = _$$Lambda$Mp4Extractor$quy71uYOGsneho91FZy1d2UGE1Q.INSTANCE;
    private static final int FILE_TYPE_HEIC = 2;
    private static final int FILE_TYPE_MP4 = 0;
    private static final int FILE_TYPE_QUICKTIME = 1;
    public static final int FLAG_READ_MOTION_PHOTO_METADATA = 2;
    public static final int FLAG_READ_SEF_DATA = 4;
    public static final int FLAG_WORKAROUND_IGNORE_EDIT_LISTS = 1;
    private static final long MAXIMUM_READ_AHEAD_BYTES_STREAM = 0xA00000L;
    private static final long RELOAD_MINIMUM_SEEK_DISTANCE = 262144L;
    private static final int STATE_READING_ATOM_HEADER = 0;
    private static final int STATE_READING_ATOM_PAYLOAD = 1;
    private static final int STATE_READING_SAMPLE = 2;
    private static final int STATE_READING_SEF = 3;
    private long[][] accumulatedSampleSizes;
    private ParsableByteArray atomData;
    private final ParsableByteArray atomHeader;
    private int atomHeaderBytesRead;
    private long atomSize;
    private int atomType;
    private final ArrayDeque<Atom.ContainerAtom> containerAtoms;
    private long durationUs;
    private ExtractorOutput extractorOutput;
    private int fileType;
    private int firstVideoTrackIndex;
    private final int flags;
    private MotionPhotoMetadata motionPhotoMetadata;
    private final ParsableByteArray nalLength;
    private final ParsableByteArray nalStartCode;
    private int parserState;
    private int sampleBytesRead;
    private int sampleBytesWritten;
    private int sampleCurrentNalBytesRemaining;
    private int sampleTrackIndex;
    private final ParsableByteArray scratch;
    private final SefReader sefReader;
    private final List<Metadata.Entry> slowMotionMetadataEntries;
    private Mp4Track[] tracks;

    public Mp4Extractor() {
        this(0);
    }

    public Mp4Extractor(int n2) {
        this.flags = n2;
        n2 = (n2 & 4) != 0 ? 3 : 0;
        this.parserState = n2;
        this.sefReader = new SefReader();
        this.slowMotionMetadataEntries = new ArrayList<Metadata.Entry>();
        this.atomHeader = new ParsableByteArray(16);
        this.containerAtoms = new ArrayDeque();
        this.nalStartCode = new ParsableByteArray(NalUnitUtil.NAL_START_CODE);
        this.nalLength = new ParsableByteArray(4);
        this.scratch = new ParsableByteArray();
        this.sampleTrackIndex = -1;
    }

    private static int brandToFileType(int n2) {
        if (n2 != 1751476579) {
            if (n2 != 1903435808) {
                return 0;
            }
            return 1;
        }
        return 2;
    }

    private static long[][] calculateAccumulatedSampleSizes(Mp4Track[] mp4TrackArray) {
        int n2;
        long[][] lArrayArray = new long[mp4TrackArray.length][];
        int[] nArray = new int[mp4TrackArray.length];
        long[] lArray = new long[mp4TrackArray.length];
        boolean[] blArray = new boolean[mp4TrackArray.length];
        for (n2 = 0; n2 < mp4TrackArray.length; ++n2) {
            lArrayArray[n2] = new long[mp4TrackArray[n2].sampleTable.sampleCount];
            lArray[n2] = mp4TrackArray[n2].sampleTable.timestampsUs[0];
        }
        long l2 = 0L;
        int n3 = 0;
        while (n3 < mp4TrackArray.length) {
            int n4 = -1;
            long l3 = Long.MAX_VALUE;
            for (n2 = 0; n2 < mp4TrackArray.length; ++n2) {
                int n5 = n4;
                long l4 = l3;
                if (!blArray[n2]) {
                    n5 = n4;
                    l4 = l3;
                    if (lArray[n2] <= l3) {
                        l4 = lArray[n2];
                        n5 = n2;
                    }
                }
                n4 = n5;
                l3 = l4;
            }
            n2 = nArray[n4];
            lArrayArray[n4][n2] = l2;
            l2 += (long)mp4TrackArray[n4].sampleTable.sizes[n2];
            nArray[n4] = ++n2;
            if (n2 < lArrayArray[n4].length) {
                lArray[n4] = mp4TrackArray[n4].sampleTable.timestampsUs[n2];
                continue;
            }
            blArray[n4] = true;
            ++n3;
        }
        return lArrayArray;
    }

    private void enterReadingAtomHeaderState() {
        this.parserState = 0;
        this.atomHeaderBytesRead = 0;
    }

    private static int getSynchronizationSampleIndex(TrackSampleTable trackSampleTable, long l2) {
        int n2;
        int n3 = n2 = trackSampleTable.getIndexOfEarlierOrEqualSynchronizationSample(l2);
        if (n2 == -1) {
            n3 = trackSampleTable.getIndexOfLaterOrEqualSynchronizationSample(l2);
        }
        return n3;
    }

    private int getTrackIndexOfNextReadSample(long l2) {
        long l3 = Long.MAX_VALUE;
        int n2 = 1;
        long l4 = Long.MAX_VALUE;
        int n3 = -1;
        int n4 = -1;
        int n5 = 1;
        long l5 = Long.MAX_VALUE;
        for (int i2 = 0; i2 < Util.castNonNull(this.tracks).length; ++i2) {
            long l6;
            block7: {
                int n6;
                int n7;
                long l7;
                long l8;
                long l9;
                int n8;
                block9: {
                    block8: {
                        Mp4Track mp4Track;
                        block6: {
                            mp4Track = this.tracks[i2];
                            n8 = mp4Track.sampleIndex;
                            if (n8 != mp4Track.sampleTable.sampleCount) break block6;
                            l6 = l3;
                            break block7;
                        }
                        l9 = mp4Track.sampleTable.offsets[n8];
                        l8 = Util.castNonNull(this.accumulatedSampleSizes)[i2][n8];
                        l6 = l9 - l2;
                        n8 = l6 >= 0L && l6 < 262144L ? 0 : 1;
                        if (n8 == 0 && n5 != 0) break block8;
                        l7 = l4;
                        n7 = n4;
                        n6 = n5;
                        l9 = l5;
                        if (n8 != n5) break block9;
                        l7 = l4;
                        n7 = n4;
                        n6 = n5;
                        l9 = l5;
                        if (l6 >= l5) break block9;
                    }
                    n6 = n8;
                    n7 = i2;
                    l9 = l6;
                    l7 = l8;
                }
                l6 = l3;
                l4 = l7;
                n4 = n7;
                n5 = n6;
                l5 = l9;
                if (l8 < l3) {
                    n3 = i2;
                    l5 = l9;
                    n5 = n6;
                    n4 = n7;
                    l4 = l7;
                    n2 = n8;
                    l6 = l8;
                }
            }
            l3 = l6;
        }
        if (l3 == Long.MAX_VALUE || n2 == 0 || l4 < l3 + 0xA00000L) {
            n3 = n4;
        }
        return n3;
    }

    static /* synthetic */ Track lambda$processMoovAtom$1(Track track) {
        return track;
    }

    static /* synthetic */ Extractor[] lambda$static$0() {
        return new Extractor[]{new Mp4Extractor()};
    }

    private static long maybeAdjustSeekOffset(TrackSampleTable trackSampleTable, long l2, long l3) {
        int n2 = Mp4Extractor.getSynchronizationSampleIndex(trackSampleTable, l2);
        if (n2 == -1) {
            return l3;
        }
        return Math.min(trackSampleTable.offsets[n2], l3);
    }

    private void maybeSkipRemainingMetaAtomHeaderBytes(ExtractorInput extractorInput) throws IOException {
        this.scratch.reset(8);
        extractorInput.peekFully(this.scratch.getData(), 0, 8);
        AtomParsers.maybeSkipRemainingMetaAtomHeaderBytes((ParsableByteArray)this.scratch);
        extractorInput.skipFully(this.scratch.getPosition());
        extractorInput.resetPeekPosition();
    }

    private void processAtomEnded(long l2) throws ParserException {
        while (!this.containerAtoms.isEmpty() && this.containerAtoms.peek().endPosition == l2) {
            Atom.ContainerAtom containerAtom = this.containerAtoms.pop();
            if (containerAtom.type == 1836019574) {
                this.processMoovAtom(containerAtom);
                this.containerAtoms.clear();
                this.parserState = 2;
                continue;
            }
            if (this.containerAtoms.isEmpty()) continue;
            this.containerAtoms.peek().add(containerAtom);
        }
        if (this.parserState != 2) {
            this.enterReadingAtomHeaderState();
        }
    }

    private void processEndOfStreamReadingAtomHeader() {
        if (this.fileType == 2 && (this.flags & 2) != 0) {
            ExtractorOutput extractorOutput = Assertions.checkNotNull(this.extractorOutput);
            TrackOutput trackOutput = extractorOutput.track(0, 4);
            Object object = this.motionPhotoMetadata;
            object = object == null ? null : new Metadata(new Metadata.Entry[]{object});
            trackOutput.format(new Format.Builder().setMetadata((Metadata)object).build());
            extractorOutput.endTracks();
            extractorOutput.seekMap(new SeekMap.Unseekable(-9223372036854775807L));
        }
    }

    private static int processFtypAtom(ParsableByteArray parsableByteArray) {
        parsableByteArray.setPosition(8);
        int n2 = Mp4Extractor.brandToFileType(parsableByteArray.readInt());
        if (n2 != 0) {
            return n2;
        }
        parsableByteArray.skipBytes(4);
        while (parsableByteArray.bytesLeft() > 0) {
            n2 = Mp4Extractor.brandToFileType(parsableByteArray.readInt());
            if (n2 == 0) continue;
            return n2;
        }
        return 0;
    }

    private void processMoovAtom(Atom.ContainerAtom object) throws ParserException {
        Metadata metadata;
        List list = new ArrayList();
        boolean bl = this.fileType == 1;
        GaplessInfoHolder gaplessInfoHolder = new GaplessInfoHolder();
        Atom.LeafAtom leafAtom = object.getLeafAtomOfType(1969517665);
        if (leafAtom != null) {
            leafAtom = AtomParsers.parseUdta((Atom.LeafAtom)leafAtom);
            metadata = (Metadata)leafAtom.first;
            leafAtom = (Metadata)leafAtom.second;
            if (metadata != null) {
                gaplessInfoHolder.setFromMetadata(metadata);
            }
        } else {
            metadata = null;
            leafAtom = null;
        }
        Object object2 = object.getContainerAtomOfType(1835365473);
        object2 = object2 != null ? AtomParsers.parseMdtaFromMeta((Atom.ContainerAtom)object2) : null;
        boolean bl2 = (this.flags & 1) != 0;
        List list2 = AtomParsers.parseTraks((Atom.ContainerAtom)object, (GaplessInfoHolder)gaplessInfoHolder, (long)-9223372036854775807L, null, (boolean)bl2, (boolean)bl, (Function)_$$Lambda$Mp4Extractor$jNmPwqo4_EkxjMq3riO8isp5v1k.INSTANCE);
        ExtractorOutput extractorOutput = Assertions.checkNotNull(this.extractorOutput);
        int n2 = list2.size();
        int n3 = -1;
        long l2 = -9223372036854775807L;
        object = list;
        list = list2;
        for (int i2 = 0; i2 < n2; ++i2) {
            list2 = (TrackSampleTable)list.get(i2);
            if (((TrackSampleTable)list2).sampleCount == 0) continue;
            Track track = ((TrackSampleTable)list2).track;
            Object object3 = object;
            long l3 = track.durationUs != -9223372036854775807L ? track.durationUs : ((TrackSampleTable)list2).durationUs;
            l2 = Math.max(l2, l3);
            Mp4Track mp4Track = new Mp4Track(track, (TrackSampleTable)list2, extractorOutput.track(i2, track.type));
            int n4 = ((TrackSampleTable)list2).maximumSize;
            Format.Builder builder = track.format.buildUpon();
            builder.setMaxInputSize(n4 + 30);
            if (track.type == 2 && l3 > 0L && ((TrackSampleTable)list2).sampleCount > 1) {
                builder.setFrameRate((float)((TrackSampleTable)list2).sampleCount / ((float)l3 / 1000000.0f));
            }
            MetadataUtil.setFormatGaplessInfo((int)track.type, (GaplessInfoHolder)gaplessInfoHolder, (Format.Builder)builder);
            n4 = track.type;
            list2 = this.slowMotionMetadataEntries.isEmpty() ? null : new Metadata(this.slowMotionMetadataEntries);
            MetadataUtil.setFormatMetadata((int)n4, (Metadata)metadata, (Metadata)object2, (Format.Builder)builder, (Metadata[])new Metadata[]{leafAtom, list2});
            mp4Track.trackOutput.format(builder.build());
            int n5 = track.type;
            n4 = n3;
            if (n5 == 2) {
                n3 = n4;
                if (n4 == -1) {
                    n3 = object3.size();
                }
            } else {
                n3 = n4;
            }
            object3.add(mp4Track);
        }
        this.firstVideoTrackIndex = n3;
        this.durationUs = l2;
        this.tracks = object.toArray(new Mp4Track[0]);
        this.accumulatedSampleSizes = Mp4Extractor.calculateAccumulatedSampleSizes(this.tracks);
        extractorOutput.endTracks();
        extractorOutput.seekMap(this);
    }

    private void processUnparsedAtom(long l2) {
        if (this.atomType == 1836086884) {
            int n2 = this.atomHeaderBytesRead;
            this.motionPhotoMetadata = new MotionPhotoMetadata(0L, l2, -9223372036854775807L, l2 + (long)n2, this.atomSize - (long)n2);
        }
    }

    private boolean readAtomHeader(ExtractorInput extractorInput) throws IOException {
        long l2;
        long l3;
        if (this.atomHeaderBytesRead == 0) {
            if (!extractorInput.readFully(this.atomHeader.getData(), 0, 8, true)) {
                this.processEndOfStreamReadingAtomHeader();
                return false;
            }
            this.atomHeaderBytesRead = 8;
            this.atomHeader.setPosition(0);
            this.atomSize = this.atomHeader.readUnsignedInt();
            this.atomType = this.atomHeader.readInt();
        }
        if ((l3 = this.atomSize) == 1L) {
            extractorInput.readFully(this.atomHeader.getData(), 8, 8);
            this.atomHeaderBytesRead += 8;
            this.atomSize = this.atomHeader.readUnsignedLongToLong();
        } else if (l3 == 0L) {
            l3 = l2 = extractorInput.getLength();
            if (l2 == -1L) {
                Atom.ContainerAtom containerAtom = this.containerAtoms.peek();
                l3 = l2;
                if (containerAtom != null) {
                    l3 = containerAtom.endPosition;
                }
            }
            if (l3 != -1L) {
                this.atomSize = l3 - extractorInput.getPosition() + (long)this.atomHeaderBytesRead;
            }
        }
        if (this.atomSize >= (long)this.atomHeaderBytesRead) {
            if (Mp4Extractor.shouldParseContainerAtom(this.atomType)) {
                l2 = extractorInput.getPosition();
                l3 = this.atomSize;
                int n2 = this.atomHeaderBytesRead;
                l2 = l2 + l3 - (long)n2;
                if (l3 != (long)n2 && this.atomType == 1835365473) {
                    this.maybeSkipRemainingMetaAtomHeaderBytes(extractorInput);
                }
                this.containerAtoms.push(new Atom.ContainerAtom(this.atomType, l2));
                if (this.atomSize == (long)this.atomHeaderBytesRead) {
                    this.processAtomEnded(l2);
                } else {
                    this.enterReadingAtomHeaderState();
                }
            } else if (Mp4Extractor.shouldParseLeafAtom(this.atomType)) {
                boolean bl = this.atomHeaderBytesRead == 8;
                Assertions.checkState(bl);
                bl = this.atomSize <= Integer.MAX_VALUE;
                Assertions.checkState(bl);
                extractorInput = new ParsableByteArray((int)this.atomSize);
                System.arraycopy(this.atomHeader.getData(), 0, extractorInput.getData(), 0, 8);
                this.atomData = extractorInput;
                this.parserState = 1;
            } else {
                this.processUnparsedAtom(extractorInput.getPosition() - (long)this.atomHeaderBytesRead);
                this.atomData = null;
                this.parserState = 1;
            }
            return true;
        }
        throw new ParserException("Atom size less than header length (unsupported).");
    }

    /*
     * Unable to fully structure code
     */
    private boolean readAtomPayload(ExtractorInput var1_1, PositionHolder var2_2) throws IOException {
        block6: {
            var3_3 = this.atomSize - (long)this.atomHeaderBytesRead;
            var5_4 = var1_1.getPosition();
            var7_5 = this.atomData;
            var8_6 = true;
            if (var7_5 == null) break block6;
            var1_1.readFully(var7_5.getData(), this.atomHeaderBytesRead, (int)var3_3);
            if (this.atomType == 1718909296) {
                this.fileType = Mp4Extractor.processFtypAtom(var7_5);
            } else if (!this.containerAtoms.isEmpty()) {
                this.containerAtoms.peek().add(new Atom.LeafAtom(this.atomType, var7_5));
            }
            ** GOTO lbl16
        }
        if (var3_3 < 262144L) {
            var1_1.skipFully((int)var3_3);
lbl16:
            // 3 sources

            var9_7 = false;
        } else {
            var2_2.position = var1_1.getPosition() + var3_3;
            var9_7 = true;
        }
        this.processAtomEnded(var5_4 + var3_3);
        if (!var9_7 || this.parserState == 2) {
            var8_6 = false;
        }
        return var8_6;
    }

    private int readSample(ExtractorInput extractorInput, PositionHolder object) throws IOException {
        long l2 = extractorInput.getPosition();
        if (this.sampleTrackIndex == -1) {
            this.sampleTrackIndex = this.getTrackIndexOfNextReadSample(l2);
            if (this.sampleTrackIndex == -1) {
                return -1;
            }
        }
        Mp4Track mp4Track = Util.castNonNull(this.tracks)[this.sampleTrackIndex];
        TrackOutput trackOutput = mp4Track.trackOutput;
        int n2 = mp4Track.sampleIndex;
        long l3 = mp4Track.sampleTable.offsets[n2];
        int n3 = mp4Track.sampleTable.sizes[n2];
        if ((l2 = l3 - l2 + (long)this.sampleBytesRead) >= 0L && l2 < 262144L) {
            int n4;
            l3 = l2;
            int n5 = n3;
            if (mp4Track.track.sampleTransformation == 1) {
                l3 = l2 + 8L;
                n5 = n3 - 8;
            }
            extractorInput.skipFully((int)l3);
            if (mp4Track.track.nalUnitLengthFieldLength != 0) {
                object = this.nalLength.getData();
                object[0] = (PositionHolder)((byte)0);
                object[1] = (PositionHolder)((byte)0);
                object[2] = (PositionHolder)((byte)0);
                int n6 = mp4Track.track.nalUnitLengthFieldLength;
                n3 = 4 - mp4Track.track.nalUnitLengthFieldLength;
                while (true) {
                    n4 = n5;
                    if (this.sampleBytesWritten < n5) {
                        n4 = this.sampleCurrentNalBytesRemaining;
                        if (n4 == 0) {
                            extractorInput.readFully((byte[])object, n3, n6);
                            this.sampleBytesRead += n6;
                            this.nalLength.setPosition(0);
                            n4 = this.nalLength.readInt();
                            if (n4 >= 0) {
                                this.sampleCurrentNalBytesRemaining = n4;
                                this.nalStartCode.setPosition(0);
                                trackOutput.sampleData(this.nalStartCode, 4);
                                this.sampleBytesWritten += 4;
                                n5 += n3;
                                continue;
                            }
                            throw new ParserException("Invalid NAL length");
                        }
                        n4 = trackOutput.sampleData((DataReader)extractorInput, n4, false);
                        this.sampleBytesRead += n4;
                        this.sampleBytesWritten += n4;
                        this.sampleCurrentNalBytesRemaining -= n4;
                        continue;
                    }
                    break;
                }
            } else {
                n3 = n5;
                if ("audio/ac4".equals(mp4Track.track.format.sampleMimeType)) {
                    if (this.sampleBytesWritten == 0) {
                        Ac4Util.getAc4SampleHeader((int)n5, (ParsableByteArray)this.scratch);
                        trackOutput.sampleData(this.scratch, 7);
                        this.sampleBytesWritten += 7;
                    }
                    n3 = n5 + 7;
                }
                while (true) {
                    n5 = this.sampleBytesWritten;
                    n4 = n3;
                    if (n5 >= n3) break;
                    n5 = trackOutput.sampleData((DataReader)extractorInput, n3 - n5, false);
                    this.sampleBytesRead += n5;
                    this.sampleBytesWritten += n5;
                    this.sampleCurrentNalBytesRemaining -= n5;
                }
            }
            trackOutput.sampleMetadata(mp4Track.sampleTable.timestampsUs[n2], mp4Track.sampleTable.flags[n2], n4, 0, null);
            ++mp4Track.sampleIndex;
            this.sampleTrackIndex = -1;
            this.sampleBytesRead = 0;
            this.sampleBytesWritten = 0;
            this.sampleCurrentNalBytesRemaining = 0;
            return 0;
        }
        object.position = l3;
        return 1;
    }

    private int readSefData(ExtractorInput extractorInput, PositionHolder positionHolder) throws IOException {
        int n2 = this.sefReader.read(extractorInput, positionHolder, this.slowMotionMetadataEntries);
        if (n2 == 1 && positionHolder.position == 0L) {
            this.enterReadingAtomHeaderState();
        }
        return n2;
    }

    private static boolean shouldParseContainerAtom(int n2) {
        boolean bl = n2 == 1836019574 || n2 == 1953653099 || n2 == 1835297121 || n2 == 1835626086 || n2 == 1937007212 || n2 == 1701082227 || n2 == 1835365473;
        return bl;
    }

    private static boolean shouldParseLeafAtom(int n2) {
        boolean bl = n2 == 1835296868 || n2 == 1836476516 || n2 == 1751411826 || n2 == 1937011556 || n2 == 0x73747473 || n2 == 0x73747373 || n2 == 1668576371 || n2 == 1701606260 || n2 == 1937011555 || n2 == 1937011578 || n2 == 1937013298 || n2 == 1937007471 || n2 == 1668232756 || n2 == 1953196132 || n2 == 1718909296 || n2 == 1969517665 || n2 == 1801812339 || n2 == 1768715124;
        return bl;
    }

    @RequiresNonNull(value={"tracks"})
    private void updateSampleIndices(long l2) {
        for (Mp4Track mp4Track : this.tracks) {
            int n2;
            TrackSampleTable trackSampleTable = mp4Track.sampleTable;
            int n3 = n2 = trackSampleTable.getIndexOfEarlierOrEqualSynchronizationSample(l2);
            if (n2 == -1) {
                n3 = trackSampleTable.getIndexOfLaterOrEqualSynchronizationSample(l2);
            }
            mp4Track.sampleIndex = n3;
        }
    }

    @Override
    public long getDurationUs() {
        return this.durationUs;
    }

    @Override
    public SeekMap.SeekPoints getSeekPoints(long l2) {
        long l3;
        long l4;
        long l5;
        long l6;
        SeekPoint seekPoint;
        if (Assertions.checkNotNull(this.tracks).length == 0) {
            return new SeekMap.SeekPoints(SeekPoint.START);
        }
        int n2 = this.firstVideoTrackIndex;
        if (n2 != -1) {
            int n3;
            seekPoint = this.tracks[n2].sampleTable;
            n2 = Mp4Extractor.getSynchronizationSampleIndex((TrackSampleTable)seekPoint, l2);
            if (n2 == -1) {
                return new SeekMap.SeekPoints(SeekPoint.START);
            }
            l6 = seekPoint.timestampsUs[n2];
            l5 = seekPoint.offsets[n2];
            if (l6 < l2 && n2 < seekPoint.sampleCount - 1 && (n3 = seekPoint.getIndexOfLaterOrEqualSynchronizationSample(l2)) != -1 && n3 != n2) {
                l2 = seekPoint.timestampsUs[n3];
                l4 = seekPoint.offsets[n3];
            } else {
                l4 = -1L;
                l2 = -9223372036854775807L;
            }
            l3 = l2;
            l2 = l4;
            l4 = l5;
        } else {
            l4 = Long.MAX_VALUE;
            l5 = -1L;
            l3 = -9223372036854775807L;
            l6 = l2;
            l2 = l5;
        }
        for (n2 = 0; n2 < ((Mp4Track[])(seekPoint = this.tracks)).length; ++n2) {
            long l7 = l2;
            l5 = l4;
            if (n2 != this.firstVideoTrackIndex) {
                seekPoint = seekPoint[n2].sampleTable;
                l5 = Mp4Extractor.maybeAdjustSeekOffset((TrackSampleTable)seekPoint, l6, l4);
                l4 = l2;
                if (l3 != -9223372036854775807L) {
                    l4 = Mp4Extractor.maybeAdjustSeekOffset((TrackSampleTable)seekPoint, l3, l2);
                }
                l7 = l4;
            }
            l2 = l7;
            l4 = l5;
        }
        seekPoint = new SeekPoint(l6, l4);
        if (l3 == -9223372036854775807L) {
            return new SeekMap.SeekPoints(seekPoint);
        }
        return new SeekMap.SeekPoints(seekPoint, new SeekPoint(l3, l2));
    }

    @Override
    public void init(ExtractorOutput extractorOutput) {
        this.extractorOutput = extractorOutput;
    }

    @Override
    public boolean isSeekable() {
        return true;
    }

    @Override
    public int read(ExtractorInput extractorInput, PositionHolder positionHolder) throws IOException {
        while (true) {
            int n2;
            if ((n2 = this.parserState) != 0) {
                if (n2 != 1) {
                    if (n2 != 2) {
                        if (n2 == 3) {
                            return this.readSefData(extractorInput, positionHolder);
                        }
                        throw new IllegalStateException();
                    }
                    return this.readSample(extractorInput, positionHolder);
                }
                if (!this.readAtomPayload(extractorInput, positionHolder)) continue;
                return 1;
            }
            if (!this.readAtomHeader(extractorInput)) break;
        }
        return -1;
    }

    @Override
    public void release() {
    }

    @Override
    public void seek(long l2, long l3) {
        this.containerAtoms.clear();
        this.atomHeaderBytesRead = 0;
        this.sampleTrackIndex = -1;
        this.sampleBytesRead = 0;
        this.sampleBytesWritten = 0;
        this.sampleCurrentNalBytesRemaining = 0;
        if (l2 == 0L) {
            if (this.parserState != 3) {
                this.enterReadingAtomHeaderState();
            } else {
                this.sefReader.reset();
                this.slowMotionMetadataEntries.clear();
            }
        } else if (this.tracks != null) {
            this.updateSampleIndices(l3);
        }
    }

    @Override
    public boolean sniff(ExtractorInput extractorInput) throws IOException {
        boolean bl = (this.flags & 2) != 0;
        return Sniffer.sniffUnfragmented((ExtractorInput)extractorInput, (boolean)bl);
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Flags {
    }

    private static final class Mp4Track {
        public int sampleIndex;
        public final TrackSampleTable sampleTable;
        public final Track track;
        public final TrackOutput trackOutput;

        public Mp4Track(Track track, TrackSampleTable trackSampleTable, TrackOutput trackOutput) {
            this.track = track;
            this.sampleTable = trackSampleTable;
            this.trackOutput = trackOutput;
        }
    }
}

