/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.mp4;

import android.util.Pair;
import android.util.SparseArray;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.audio.Ac4Util;
import com.google.android.exoplayer2.drm.DrmInitData;
import com.google.android.exoplayer2.extractor.CeaUtil;
import com.google.android.exoplayer2.extractor.ChunkIndex;
import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.extractor.GaplessInfoHolder;
import com.google.android.exoplayer2.extractor.PositionHolder;
import com.google.android.exoplayer2.extractor.SeekMap;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.extractor.mp4.Atom;
import com.google.android.exoplayer2.extractor.mp4.AtomParsers;
import com.google.android.exoplayer2.extractor.mp4.DefaultSampleValues;
import com.google.android.exoplayer2.extractor.mp4.PsshAtomUtil;
import com.google.android.exoplayer2.extractor.mp4.Sniffer;
import com.google.android.exoplayer2.extractor.mp4.Track;
import com.google.android.exoplayer2.extractor.mp4.TrackEncryptionBox;
import com.google.android.exoplayer2.extractor.mp4.TrackFragment;
import com.google.android.exoplayer2.extractor.mp4.TrackSampleTable;
import com.google.android.exoplayer2.extractor.mp4._$;
import com.google.android.exoplayer2.extractor.mp4._$$Lambda$fN3_4mToiYIj1aT5w0vidExaojw;
import com.google.android.exoplayer2.metadata.emsg.EventMessage;
import com.google.android.exoplayer2.metadata.emsg.EventMessageEncoder;
import com.google.android.exoplayer2.upstream.DataReader;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.NalUnitUtil;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.TimestampAdjuster;
import com.google.android.exoplayer2.util.Util;
import com.google.common.base.Function;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public class FragmentedMp4Extractor
implements Extractor {
    private static final Format EMSG_FORMAT;
    private static final int EXTRA_TRACKS_BASE_ID = 100;
    public static final ExtractorsFactory FACTORY;
    public static final int FLAG_ENABLE_EMSG_TRACK = 4;
    public static final int FLAG_WORKAROUND_EVERY_VIDEO_FRAME_IS_SYNC_FRAME = 1;
    public static final int FLAG_WORKAROUND_IGNORE_EDIT_LISTS = 16;
    public static final int FLAG_WORKAROUND_IGNORE_TFDT_BOX = 2;
    private static final byte[] PIFF_SAMPLE_ENCRYPTION_BOX_EXTENDED_TYPE;
    private static final int SAMPLE_GROUP_TYPE_seig = 1936025959;
    private static final int STATE_READING_ATOM_HEADER = 0;
    private static final int STATE_READING_ATOM_PAYLOAD = 1;
    private static final int STATE_READING_ENCRYPTION_DATA = 2;
    private static final int STATE_READING_SAMPLE_CONTINUE = 4;
    private static final int STATE_READING_SAMPLE_START = 3;
    private static final String TAG = "FragmentedMp4Extractor";
    private final TrackOutput additionalEmsgTrackOutput;
    private ParsableByteArray atomData;
    private final ParsableByteArray atomHeader;
    private int atomHeaderBytesRead;
    private long atomSize;
    private int atomType;
    private TrackOutput[] ceaTrackOutputs;
    private final List<Format> closedCaptionFormats;
    private final ArrayDeque<Atom.ContainerAtom> containerAtoms;
    private TrackBundle currentTrackBundle;
    private long durationUs;
    private TrackOutput[] emsgTrackOutputs;
    private long endOfMdatPosition;
    private final EventMessageEncoder eventMessageEncoder;
    private ExtractorOutput extractorOutput;
    private final int flags;
    private boolean haveOutputSeekMap;
    private final ParsableByteArray nalBuffer;
    private final ParsableByteArray nalPrefix;
    private final ParsableByteArray nalStartCode;
    private int parserState;
    private int pendingMetadataSampleBytes;
    private final ArrayDeque<MetadataSampleInfo> pendingMetadataSampleInfos;
    private long pendingSeekTimeUs;
    private boolean processSeiNalUnitPayload;
    private int sampleBytesWritten;
    private int sampleCurrentNalBytesRemaining;
    private int sampleSize;
    private final ParsableByteArray scratch;
    private final byte[] scratchBytes;
    private long segmentIndexEarliestPresentationTimeUs;
    private final Track sideloadedTrack;
    private final TimestampAdjuster timestampAdjuster;
    private final SparseArray<TrackBundle> trackBundles;

    static {
        FACTORY = _$.Lambda.FragmentedMp4Extractor.i0zfpH_PcF0vytkdatCL0xeWFhQ.INSTANCE;
        PIFF_SAMPLE_ENCRYPTION_BOX_EXTENDED_TYPE = new byte[]{-94, 57, 79, 82, 90, -101, 79, 20, -94, 68, 108, 66, 124, 100, -115, -12};
        EMSG_FORMAT = new Format.Builder().setSampleMimeType("application/x-emsg").build();
    }

    public FragmentedMp4Extractor() {
        this(0);
    }

    public FragmentedMp4Extractor(int n2) {
        this(n2, null);
    }

    public FragmentedMp4Extractor(int n2, TimestampAdjuster timestampAdjuster) {
        this(n2, timestampAdjuster, null, Collections.emptyList());
    }

    public FragmentedMp4Extractor(int n2, TimestampAdjuster timestampAdjuster, Track track) {
        this(n2, timestampAdjuster, track, Collections.emptyList());
    }

    public FragmentedMp4Extractor(int n2, TimestampAdjuster timestampAdjuster, Track track, List<Format> list) {
        this(n2, timestampAdjuster, track, list, null);
    }

    public FragmentedMp4Extractor(int n2, TimestampAdjuster timestampAdjuster, Track track, List<Format> list, TrackOutput trackOutput) {
        this.flags = n2;
        this.timestampAdjuster = timestampAdjuster;
        this.sideloadedTrack = track;
        this.closedCaptionFormats = Collections.unmodifiableList(list);
        this.additionalEmsgTrackOutput = trackOutput;
        this.eventMessageEncoder = new EventMessageEncoder();
        this.atomHeader = new ParsableByteArray(16);
        this.nalStartCode = new ParsableByteArray(NalUnitUtil.NAL_START_CODE);
        this.nalPrefix = new ParsableByteArray(5);
        this.nalBuffer = new ParsableByteArray();
        this.scratchBytes = new byte[16];
        this.scratch = new ParsableByteArray(this.scratchBytes);
        this.containerAtoms = new ArrayDeque();
        this.pendingMetadataSampleInfos = new ArrayDeque();
        this.trackBundles = new SparseArray();
        this.durationUs = -9223372036854775807L;
        this.pendingSeekTimeUs = -9223372036854775807L;
        this.segmentIndexEarliestPresentationTimeUs = -9223372036854775807L;
        this.extractorOutput = ExtractorOutput.PLACEHOLDER;
        this.emsgTrackOutputs = new TrackOutput[0];
        this.ceaTrackOutputs = new TrackOutput[0];
    }

    private static int checkNonNegative(int n2) throws ParserException {
        if (n2 >= 0) {
            return n2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Unexpected negative value: ");
        stringBuilder.append(n2);
        throw new ParserException(stringBuilder.toString());
    }

    private void enterReadingAtomHeaderState() {
        this.parserState = 0;
        this.atomHeaderBytesRead = 0;
    }

    private DefaultSampleValues getDefaultSampleValues(SparseArray<DefaultSampleValues> sparseArray, int n2) {
        if (sparseArray.size() == 1) {
            return (DefaultSampleValues)sparseArray.valueAt(0);
        }
        return Assertions.checkNotNull((DefaultSampleValues)sparseArray.get(n2));
    }

    private static DrmInitData getDrmInitDataFromAtoms(List<Atom.LeafAtom> object) {
        int n2 = object.size();
        Object var2_2 = null;
        Object object2 = null;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object3 = object.get(i2);
            ArrayList<DrmInitData.SchemeData> arrayList = object2;
            if (object3.type == 1886614376) {
                arrayList = object2;
                if (object2 == null) {
                    arrayList = new ArrayList<DrmInitData.SchemeData>();
                }
                if ((object3 = PsshAtomUtil.parseUuid((byte[])(object2 = (Object)object3.data.getData()))) == null) {
                    Log.w(TAG, "Skipped pssh atom (failed to extract uuid)");
                } else {
                    arrayList.add(new DrmInitData.SchemeData((UUID)object3, "video/mp4", (byte[])object2));
                }
            }
            object2 = arrayList;
        }
        object = object2 == null ? var2_2 : new DrmInitData(object2);
        return object;
    }

    private static TrackBundle getNextTrackBundle(SparseArray<TrackBundle> sparseArray) {
        int n2 = sparseArray.size();
        TrackBundle trackBundle = null;
        long l2 = Long.MAX_VALUE;
        for (int i2 = 0; i2 < n2; ++i2) {
            long l3;
            TrackBundle trackBundle2;
            block8: {
                TrackBundle trackBundle3;
                block7: {
                    trackBundle3 = (TrackBundle)sparseArray.valueAt(i2);
                    if (trackBundle3.currentlyInFragment) break block7;
                    trackBundle2 = trackBundle;
                    l3 = l2;
                    if (trackBundle3.currentSampleIndex == trackBundle3.moovSampleTable.sampleCount) break block8;
                }
                if (trackBundle3.currentlyInFragment && trackBundle3.currentTrackRunIndex == trackBundle3.fragment.trunCount) {
                    trackBundle2 = trackBundle;
                    l3 = l2;
                } else {
                    long l4 = trackBundle3.getCurrentSampleOffset();
                    trackBundle2 = trackBundle;
                    l3 = l2;
                    if (l4 < l2) {
                        trackBundle2 = trackBundle3;
                        l3 = l4;
                    }
                }
            }
            trackBundle = trackBundle2;
            l2 = l3;
        }
        return trackBundle;
    }

    private static TrackBundle getTrackBundle(SparseArray<TrackBundle> sparseArray, int n2) {
        if (sparseArray.size() == 1) {
            return (TrackBundle)sparseArray.valueAt(0);
        }
        return (TrackBundle)sparseArray.get(n2);
    }

    private void initExtraTracks() {
        int n2;
        this.emsgTrackOutputs = new TrackOutput[2];
        Object object = this.additionalEmsgTrackOutput;
        int n3 = 0;
        if (object != null) {
            this.emsgTrackOutputs[0] = object;
            n2 = 1;
        } else {
            n2 = 0;
        }
        int n4 = this.flags;
        int n5 = 100;
        int n6 = n2;
        if ((n4 & 4) != 0) {
            this.emsgTrackOutputs[n2] = this.extractorOutput.track(100, 5);
            n6 = n2 + 1;
            n5 = 101;
        }
        this.emsgTrackOutputs = Util.nullSafeArrayCopy(this.emsgTrackOutputs, n6);
        object = this.emsgTrackOutputs;
        n6 = ((TrackOutput[])object).length;
        for (n2 = 0; n2 < n6; ++n2) {
            object[n2].format(EMSG_FORMAT);
        }
        this.ceaTrackOutputs = new TrackOutput[this.closedCaptionFormats.size()];
        n2 = n3;
        while (n2 < this.ceaTrackOutputs.length) {
            object = this.extractorOutput.track(n5, 3);
            object.format(this.closedCaptionFormats.get(n2));
            this.ceaTrackOutputs[n2] = object;
            ++n2;
            ++n5;
        }
    }

    static /* synthetic */ Extractor[] lambda$static$0() {
        return new Extractor[]{new FragmentedMp4Extractor()};
    }

    private void onContainerAtomRead(Atom.ContainerAtom containerAtom) throws ParserException {
        if (containerAtom.type == 1836019574) {
            this.onMoovContainerAtomRead(containerAtom);
        } else if (containerAtom.type == 0x6D6F6F66) {
            this.onMoofContainerAtomRead(containerAtom);
        } else if (!this.containerAtoms.isEmpty()) {
            this.containerAtoms.peek().add(containerAtom);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void onEmsgLeafAtomRead(ParsableByteArray object) {
        void var9_8;
        long l2;
        String string2;
        long l3;
        long l4;
        long l5;
        if (this.emsgTrackOutputs.length == 0) {
            return;
        }
        object.setPosition(8);
        int n2 = Atom.parseFullAtomVersion((int)object.readInt());
        if (n2 != 0) {
            if (n2 != 1) {
                object = new StringBuilder();
                ((StringBuilder)object).append("Skipping unsupported emsg version: ");
                ((StringBuilder)object).append(n2);
                Log.w(TAG, ((StringBuilder)object).toString());
                return;
            }
            l5 = object.readUnsignedInt();
            l4 = Util.scaleLargeTimestamp(object.readUnsignedLongToLong(), 1000000L, l5);
            l5 = Util.scaleLargeTimestamp(object.readUnsignedInt(), 1000L, l5);
            l3 = object.readUnsignedInt();
            String object22 = Assertions.checkNotNull(object.readNullTerminatedString());
            string2 = Assertions.checkNotNull(object.readNullTerminatedString());
            l2 = -9223372036854775807L;
        } else {
            String string3 = Assertions.checkNotNull(object.readNullTerminatedString());
            string2 = Assertions.checkNotNull(object.readNullTerminatedString());
            l5 = object.readUnsignedInt();
            l2 = Util.scaleLargeTimestamp(object.readUnsignedInt(), 1000000L, l5);
            l4 = this.segmentIndexEarliestPresentationTimeUs;
            l4 = l4 != -9223372036854775807L ? (l4 += l2) : -9223372036854775807L;
            l5 = Util.scaleLargeTimestamp(object.readUnsignedInt(), 1000L, l5);
            l3 = object.readUnsignedInt();
        }
        byte[] byArray = new byte[object.bytesLeft()];
        n2 = object.bytesLeft();
        int n3 = 0;
        object.readBytes(byArray, 0, n2);
        object = new EventMessage((String)var9_8, string2, l5, l3, byArray);
        string2 = new ParsableByteArray(this.eventMessageEncoder.encode((EventMessage)object));
        int n4 = string2.bytesLeft();
        for (TrackOutput trackOutput : this.emsgTrackOutputs) {
            string2.setPosition(0);
            trackOutput.sampleData((ParsableByteArray)string2, n4);
        }
        if (l4 == -9223372036854775807L) {
            this.pendingMetadataSampleInfos.addLast(new MetadataSampleInfo(l2, n4));
            this.pendingMetadataSampleBytes += n4;
        } else {
            object = this.timestampAdjuster;
            l5 = l4;
            if (object != null) {
                l5 = object.adjustSampleTimestamp(l4);
            }
            object = this.emsgTrackOutputs;
            int n5 = ((Object)object).length;
            for (n2 = n3; n2 < n5; ++n2) {
                object[n2].sampleMetadata(l5, 1, n4, 0, null);
            }
        }
    }

    private void onLeafAtomRead(Atom.LeafAtom pair, long l2) throws ParserException {
        if (!this.containerAtoms.isEmpty()) {
            this.containerAtoms.peek().add((Atom.LeafAtom)pair);
        } else if (pair.type == 1936286840) {
            pair = FragmentedMp4Extractor.parseSidx(pair.data, l2);
            this.segmentIndexEarliestPresentationTimeUs = (Long)pair.first;
            this.extractorOutput.seekMap((SeekMap)pair.second);
            this.haveOutputSeekMap = true;
        } else if (pair.type == 1701671783) {
            this.onEmsgLeafAtomRead(pair.data);
        }
    }

    private void onMoofContainerAtomRead(Atom.ContainerAtom containerAtom) throws ParserException {
        int n2;
        int n3;
        FragmentedMp4Extractor.parseMoof(containerAtom, this.trackBundles, this.flags, this.scratchBytes);
        containerAtom = FragmentedMp4Extractor.getDrmInitDataFromAtoms(containerAtom.leafChildren);
        int n4 = 0;
        if (containerAtom != null) {
            n3 = this.trackBundles.size();
            for (n2 = 0; n2 < n3; ++n2) {
                ((TrackBundle)this.trackBundles.valueAt(n2)).updateDrmInitData((DrmInitData)containerAtom);
            }
        }
        if (this.pendingSeekTimeUs != -9223372036854775807L) {
            n3 = this.trackBundles.size();
            for (n2 = n4; n2 < n3; ++n2) {
                ((TrackBundle)this.trackBundles.valueAt(n2)).seek(this.pendingSeekTimeUs);
            }
            this.pendingSeekTimeUs = -9223372036854775807L;
        }
    }

    private void onMoovContainerAtomRead(Atom.ContainerAtom object) throws ParserException {
        int n2;
        Track track = this.sideloadedTrack;
        boolean bl = true;
        int n3 = 0;
        int n4 = 0;
        boolean bl2 = track == null;
        Assertions.checkState(bl2, "Unexpected moov box.");
        Object object2 = FragmentedMp4Extractor.getDrmInitDataFromAtoms(((Atom.ContainerAtom)object).leafChildren);
        Object object3 = Assertions.checkNotNull(object.getContainerAtomOfType(1836475768));
        track = new SparseArray();
        int n5 = object3.leafChildren.size();
        long l2 = -9223372036854775807L;
        for (n2 = 0; n2 < n5; ++n2) {
            Pair<Integer, DefaultSampleValues> pair = (Pair<Integer, DefaultSampleValues>)object3.leafChildren.get(n2);
            if (pair.type == 1953654136) {
                pair = FragmentedMp4Extractor.parseTrex(pair.data);
                track.put((Integer)pair.first, (DefaultSampleValues)pair.second);
                continue;
            }
            if (pair.type != 1835362404) continue;
            l2 = FragmentedMp4Extractor.parseMehd(pair.data);
        }
        object3 = new GaplessInfoHolder();
        bl2 = (this.flags & 0x10) != 0;
        object = AtomParsers.parseTraks((Atom.ContainerAtom)object, (GaplessInfoHolder)object3, (long)l2, (DrmInitData)object2, (boolean)bl2, (boolean)false, (Function)new _$$Lambda$fN3_4mToiYIj1aT5w0vidExaojw(this));
        n5 = object.size();
        if (this.trackBundles.size() == 0) {
            for (n2 = n4; n2 < n5; ++n2) {
                object3 = (TrackSampleTable)object.get(n2);
                object2 = object3.track;
                object3 = new TrackBundle(this.extractorOutput.track(n2, object2.type), (TrackSampleTable)object3, this.getDefaultSampleValues((SparseArray<DefaultSampleValues>)track, object2.id));
                this.trackBundles.put(object2.id, object3);
                this.durationUs = Math.max(this.durationUs, object2.durationUs);
            }
            this.extractorOutput.endTracks();
        } else {
            bl2 = this.trackBundles.size() == n5 ? bl : false;
            Assertions.checkState(bl2);
            for (n2 = n3; n2 < n5; ++n2) {
                object3 = (TrackSampleTable)object.get(n2);
                object2 = object3.track;
                ((TrackBundle)this.trackBundles.get(object2.id)).reset((TrackSampleTable)object3, this.getDefaultSampleValues((SparseArray<DefaultSampleValues>)track, object2.id));
            }
        }
    }

    private void outputPendingMetadataSamples(long l2) {
        while (!this.pendingMetadataSampleInfos.isEmpty()) {
            MetadataSampleInfo metadataSampleInfo = this.pendingMetadataSampleInfos.removeFirst();
            this.pendingMetadataSampleBytes -= metadataSampleInfo.size;
            long l3 = metadataSampleInfo.presentationTimeDeltaUs + l2;
            TrackOutput[] trackOutputArray = this.timestampAdjuster;
            long l4 = l3;
            if (trackOutputArray != null) {
                l4 = trackOutputArray.adjustSampleTimestamp(l3);
            }
            trackOutputArray = this.emsgTrackOutputs;
            int n2 = trackOutputArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                trackOutputArray[i2].sampleMetadata(l4, 1, metadataSampleInfo.size, this.pendingMetadataSampleBytes, null);
            }
        }
    }

    private static long parseMehd(ParsableByteArray parsableByteArray) {
        parsableByteArray.setPosition(8);
        long l2 = Atom.parseFullAtomVersion((int)parsableByteArray.readInt()) == 0 ? parsableByteArray.readUnsignedInt() : parsableByteArray.readUnsignedLongToLong();
        return l2;
    }

    private static void parseMoof(Atom.ContainerAtom containerAtom, SparseArray<TrackBundle> sparseArray, int n2, byte[] byArray) throws ParserException {
        int n3 = containerAtom.containerChildren.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            Atom.ContainerAtom containerAtom2 = (Atom.ContainerAtom)containerAtom.containerChildren.get(i2);
            if (containerAtom2.type != 1953653094) continue;
            FragmentedMp4Extractor.parseTraf(containerAtom2, sparseArray, n2, byArray);
        }
    }

    private static void parseSaio(ParsableByteArray object, TrackFragment trackFragment) throws ParserException {
        int n2;
        object.setPosition(8);
        int n3 = object.readInt();
        if ((Atom.parseFullAtomFlags((int)n3) & 1) == 1) {
            object.skipBytes(8);
        }
        if ((n2 = object.readUnsignedIntToInt()) == 1) {
            n2 = Atom.parseFullAtomVersion((int)n3);
            long l2 = trackFragment.auxiliaryDataPosition;
            long l3 = n2 == 0 ? object.readUnsignedInt() : object.readUnsignedLongToLong();
            trackFragment.auxiliaryDataPosition = l2 + l3;
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Unexpected saio entry count: ");
        ((StringBuilder)object).append(n2);
        throw new ParserException(((StringBuilder)object).toString());
    }

    private static void parseSaiz(TrackEncryptionBox object, ParsableByteArray parsableByteArray, TrackFragment trackFragment) throws ParserException {
        int n2 = ((TrackEncryptionBox)object).perSampleIvSize;
        parsableByteArray.setPosition(8);
        int n3 = Atom.parseFullAtomFlags((int)parsableByteArray.readInt());
        boolean bl = true;
        if ((n3 & 1) == 1) {
            parsableByteArray.skipBytes(8);
        }
        n3 = parsableByteArray.readUnsignedByte();
        int n4 = parsableByteArray.readUnsignedIntToInt();
        if (n4 <= trackFragment.sampleCount) {
            int n5;
            if (n3 == 0) {
                object = trackFragment.sampleHasSubsampleEncryptionTable;
                int n6 = 0;
                n3 = 0;
                while (true) {
                    n5 = n3;
                    if (n6 < n4) {
                        n5 = parsableByteArray.readUnsignedByte();
                        n3 += n5;
                        bl = n5 > n2;
                        object[n6] = bl;
                        ++n6;
                        continue;
                    }
                    break;
                }
            } else {
                if (n3 <= n2) {
                    bl = false;
                }
                n5 = n3 * n4 + 0;
                Arrays.fill(trackFragment.sampleHasSubsampleEncryptionTable, 0, n4, bl);
            }
            Arrays.fill(trackFragment.sampleHasSubsampleEncryptionTable, n4, trackFragment.sampleCount, false);
            if (n5 > 0) {
                trackFragment.initEncryptionData(n5);
            }
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Saiz sample count ");
        ((StringBuilder)object).append(n4);
        ((StringBuilder)object).append(" is greater than fragment sample count");
        ((StringBuilder)object).append(trackFragment.sampleCount);
        object = new ParserException(((StringBuilder)object).toString());
        throw object;
    }

    private static void parseSampleGroups(Atom.ContainerAtom object, String string2, TrackFragment trackFragment) throws ParserException {
        int n2;
        Object object2;
        Object var3_3 = null;
        ParsableByteArray parsableByteArray = object2 = null;
        for (n2 = 0; n2 < object.leafChildren.size(); ++n2) {
            ParsableByteArray parsableByteArray2;
            ParsableByteArray parsableByteArray3;
            Atom.LeafAtom leafAtom = (Atom.LeafAtom)object.leafChildren.get(n2);
            ParsableByteArray parsableByteArray4 = leafAtom.data;
            if (leafAtom.type == 1935828848) {
                parsableByteArray4.setPosition(12);
                parsableByteArray3 = object2;
                parsableByteArray2 = parsableByteArray;
                if (parsableByteArray4.readInt() == 1936025959) {
                    parsableByteArray3 = parsableByteArray4;
                    parsableByteArray2 = parsableByteArray;
                }
            } else {
                parsableByteArray3 = object2;
                parsableByteArray2 = parsableByteArray;
                if (leafAtom.type == 1936158820) {
                    parsableByteArray4.setPosition(12);
                    parsableByteArray3 = object2;
                    parsableByteArray2 = parsableByteArray;
                    if (parsableByteArray4.readInt() == 1936025959) {
                        parsableByteArray2 = parsableByteArray4;
                        parsableByteArray3 = object2;
                    }
                }
            }
            object2 = parsableByteArray3;
            parsableByteArray = parsableByteArray2;
        }
        if (object2 != null && parsableByteArray != null) {
            object2.setPosition(8);
            n2 = Atom.parseFullAtomVersion((int)object2.readInt());
            object2.skipBytes(4);
            if (n2 == 1) {
                object2.skipBytes(4);
            }
            if (object2.readInt() == 1) {
                parsableByteArray.setPosition(8);
                n2 = Atom.parseFullAtomVersion((int)parsableByteArray.readInt());
                parsableByteArray.skipBytes(4);
                if (n2 == 1) {
                    if (parsableByteArray.readUnsignedInt() == 0L) {
                        throw new ParserException("Variable length description in sgpd found (unsupported)");
                    }
                } else if (n2 >= 2) {
                    parsableByteArray.skipBytes(4);
                }
                if (parsableByteArray.readUnsignedInt() == 1L) {
                    parsableByteArray.skipBytes(1);
                    int n3 = parsableByteArray.readUnsignedByte();
                    boolean bl = parsableByteArray.readUnsignedByte() == 1;
                    if (!bl) {
                        return;
                    }
                    int n4 = parsableByteArray.readUnsignedByte();
                    object2 = new byte[16];
                    parsableByteArray.readBytes((byte[])object2, 0, ((ParsableByteArray)object2).length);
                    object = var3_3;
                    if (n4 == 0) {
                        n2 = parsableByteArray.readUnsignedByte();
                        object = new byte[n2];
                        parsableByteArray.readBytes((byte[])object, 0, n2);
                    }
                    trackFragment.definesEncryptionData = true;
                    trackFragment.trackEncryptionBox = new TrackEncryptionBox(bl, string2, n4, (byte[])object2, (n3 & 0xF0) >> 4, n3 & 0xF, (byte[])object);
                    return;
                }
                throw new ParserException("Entry count in sgpd != 1 (unsupported).");
            }
            throw new ParserException("Entry count in sbgp != 1 (unsupported).");
        }
    }

    private static void parseSenc(ParsableByteArray object, int n2, TrackFragment trackFragment) throws ParserException {
        object.setPosition(n2 + 8);
        n2 = Atom.parseFullAtomFlags((int)object.readInt());
        if ((n2 & 1) == 0) {
            boolean bl = (n2 & 2) != 0;
            n2 = object.readUnsignedIntToInt();
            if (n2 == 0) {
                Arrays.fill(trackFragment.sampleHasSubsampleEncryptionTable, 0, trackFragment.sampleCount, false);
                return;
            }
            if (n2 == trackFragment.sampleCount) {
                Arrays.fill(trackFragment.sampleHasSubsampleEncryptionTable, 0, n2, bl);
                trackFragment.initEncryptionData(object.bytesLeft());
                trackFragment.fillEncryptionData((ParsableByteArray)object);
                return;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Senc sample count ");
            ((StringBuilder)object).append(n2);
            ((StringBuilder)object).append(" is different from fragment sample count");
            ((StringBuilder)object).append(trackFragment.sampleCount);
            throw new ParserException(((StringBuilder)object).toString());
        }
        throw new ParserException("Overriding TrackEncryptionBox parameters is unsupported.");
    }

    private static void parseSenc(ParsableByteArray parsableByteArray, TrackFragment trackFragment) throws ParserException {
        FragmentedMp4Extractor.parseSenc(parsableByteArray, 0, trackFragment);
    }

    private static Pair<Long, ChunkIndex> parseSidx(ParsableByteArray parsableByteArray, long l2) throws ParserException {
        long l3;
        long l4;
        parsableByteArray.setPosition(8);
        int n2 = Atom.parseFullAtomVersion((int)parsableByteArray.readInt());
        parsableByteArray.skipBytes(4);
        long l5 = parsableByteArray.readUnsignedInt();
        if (n2 == 0) {
            l4 = parsableByteArray.readUnsignedInt();
            l3 = parsableByteArray.readUnsignedInt();
        } else {
            l4 = parsableByteArray.readUnsignedLongToLong();
            l3 = parsableByteArray.readUnsignedLongToLong();
        }
        l2 += l3;
        long l6 = Util.scaleLargeTimestamp(l4, 1000000L, l5);
        parsableByteArray.skipBytes(2);
        n2 = parsableByteArray.readUnsignedShort();
        int[] nArray = new int[n2];
        long[] lArray = new long[n2];
        long[] lArray2 = new long[n2];
        long[] lArray3 = new long[n2];
        l3 = l4;
        l4 = l6;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = parsableByteArray.readInt();
            if ((n3 & Integer.MIN_VALUE) == 0) {
                long l7 = parsableByteArray.readUnsignedInt();
                nArray[i2] = n3 & Integer.MAX_VALUE;
                lArray[i2] = l2;
                lArray3[i2] = l4;
                l4 = Util.scaleLargeTimestamp(l3 += l7, 1000000L, l5);
                lArray2[i2] = l4 - lArray3[i2];
                parsableByteArray.skipBytes(4);
                l2 += (long)nArray[i2];
                continue;
            }
            throw new ParserException("Unhandled indirect reference");
        }
        return Pair.create((Object)l6, (Object)new ChunkIndex(nArray, lArray, lArray2, lArray3));
    }

    private static long parseTfdt(ParsableByteArray parsableByteArray) {
        parsableByteArray.setPosition(8);
        long l2 = Atom.parseFullAtomVersion((int)parsableByteArray.readInt()) == 1 ? parsableByteArray.readUnsignedLongToLong() : parsableByteArray.readUnsignedInt();
        return l2;
    }

    private static TrackBundle parseTfhd(ParsableByteArray parsableByteArray, SparseArray<TrackBundle> defaultSampleValues) {
        parsableByteArray.setPosition(8);
        int n2 = Atom.parseFullAtomFlags((int)parsableByteArray.readInt());
        TrackBundle trackBundle = FragmentedMp4Extractor.getTrackBundle(defaultSampleValues, parsableByteArray.readInt());
        if (trackBundle == null) {
            return null;
        }
        if ((n2 & 1) != 0) {
            long l2;
            trackBundle.fragment.dataPosition = l2 = parsableByteArray.readUnsignedLongToLong();
            trackBundle.fragment.auxiliaryDataPosition = l2;
        }
        defaultSampleValues = trackBundle.defaultSampleValues;
        int n3 = (n2 & 2) != 0 ? parsableByteArray.readInt() - 1 : defaultSampleValues.sampleDescriptionIndex;
        int n4 = (n2 & 8) != 0 ? parsableByteArray.readInt() : defaultSampleValues.duration;
        int n5 = (n2 & 0x10) != 0 ? parsableByteArray.readInt() : defaultSampleValues.size;
        n2 = (n2 & 0x20) != 0 ? parsableByteArray.readInt() : defaultSampleValues.flags;
        trackBundle.fragment.header = new DefaultSampleValues(n3, n4, n5, n2);
        return trackBundle;
    }

    private static void parseTraf(Atom.ContainerAtom containerAtom, SparseArray<TrackBundle> object, int n2, byte[] byArray) throws ParserException {
        if ((object = FragmentedMp4Extractor.parseTfhd(Assertions.checkNotNull(containerAtom.getLeafAtomOfType((int)1952868452)).data, object)) == null) {
            return;
        }
        TrackFragment trackFragment = ((TrackBundle)object).fragment;
        long l2 = trackFragment.nextFragmentDecodeTime;
        boolean bl = trackFragment.nextFragmentDecodeTimeIncludesMoov;
        ((TrackBundle)object).resetFragmentInfo();
        TrackBundle.access$002((TrackBundle)object, true);
        Atom.LeafAtom leafAtom = containerAtom.getLeafAtomOfType(0x74666474);
        if (leafAtom != null && (n2 & 2) == 0) {
            trackFragment.nextFragmentDecodeTime = FragmentedMp4Extractor.parseTfdt(leafAtom.data);
            trackFragment.nextFragmentDecodeTimeIncludesMoov = true;
        } else {
            trackFragment.nextFragmentDecodeTime = l2;
            trackFragment.nextFragmentDecodeTimeIncludesMoov = bl;
        }
        FragmentedMp4Extractor.parseTruns(containerAtom, (TrackBundle)object, n2);
        object = ((TrackBundle)object).moovSampleTable.track.getSampleDescriptionEncryptionBox(Assertions.checkNotNull(trackFragment.header).sampleDescriptionIndex);
        leafAtom = containerAtom.getLeafAtomOfType(1935763834);
        if (leafAtom != null) {
            FragmentedMp4Extractor.parseSaiz((TrackEncryptionBox)Assertions.checkNotNull(object), leafAtom.data, trackFragment);
        }
        if ((leafAtom = containerAtom.getLeafAtomOfType(1935763823)) != null) {
            FragmentedMp4Extractor.parseSaio(leafAtom.data, trackFragment);
        }
        if ((leafAtom = containerAtom.getLeafAtomOfType(1936027235)) != null) {
            FragmentedMp4Extractor.parseSenc(leafAtom.data, trackFragment);
        }
        object = object != null ? ((TrackEncryptionBox)object).schemeType : null;
        FragmentedMp4Extractor.parseSampleGroups(containerAtom, (String)object, trackFragment);
        int n3 = containerAtom.leafChildren.size();
        for (n2 = 0; n2 < n3; ++n2) {
            object = (Atom.LeafAtom)containerAtom.leafChildren.get(n2);
            if (((Atom.LeafAtom)object).type != 1970628964) continue;
            FragmentedMp4Extractor.parseUuid(((Atom.LeafAtom)object).data, trackFragment, byArray);
        }
    }

    private static Pair<Integer, DefaultSampleValues> parseTrex(ParsableByteArray parsableByteArray) {
        parsableByteArray.setPosition(12);
        return Pair.create((Object)parsableByteArray.readInt(), (Object)new DefaultSampleValues(parsableByteArray.readInt() - 1, parsableByteArray.readInt(), parsableByteArray.readInt(), parsableByteArray.readInt()));
    }

    private static int parseTrun(TrackBundle trackBundle, int n2, int n3, ParsableByteArray parsableByteArray, int n4) throws ParserException {
        long l2;
        long[] lArray;
        TrackBundle trackBundle2 = trackBundle;
        parsableByteArray.setPosition(8);
        int n5 = Atom.parseFullAtomFlags((int)parsableByteArray.readInt());
        Track track = trackBundle2.moovSampleTable.track;
        TrackFragment trackFragment = trackBundle2.fragment;
        trackBundle2 = Util.castNonNull(trackFragment.header);
        trackFragment.trunLength[n2] = parsableByteArray.readUnsignedIntToInt();
        trackFragment.trunDataPosition[n2] = trackFragment.dataPosition;
        if ((n5 & 1) != 0) {
            lArray = trackFragment.trunDataPosition;
            lArray[n2] = lArray[n2] + (long)parsableByteArray.readInt();
        }
        boolean bl = (n5 & 4) != 0;
        int n6 = ((DefaultSampleValues)trackBundle2).flags;
        if (bl) {
            n6 = parsableByteArray.readInt();
        }
        boolean bl2 = (n5 & 0x100) != 0;
        boolean bl3 = (n5 & 0x200) != 0;
        boolean bl4 = (n5 & 0x400) != 0;
        n5 = (n5 & 0x800) != 0 ? 1 : 0;
        lArray = track.editListDurations;
        long l3 = l2 = 0L;
        if (lArray != null) {
            l3 = l2;
            if (track.editListDurations.length == 1) {
                l3 = l2;
                if (track.editListDurations[0] == 0L) {
                    l3 = Util.scaleLargeTimestamp(Util.castNonNull(track.editListMediaTimes)[0], 1000000L, track.timescale);
                }
            }
        }
        int[] nArray = trackFragment.sampleSizeTable;
        int[] nArray2 = trackFragment.sampleCompositionTimeOffsetUsTable;
        lArray = trackFragment.sampleDecodingTimeUsTable;
        boolean[] blArray = trackFragment.sampleIsSyncFrameTable;
        n3 = track.type == 2 && (n3 & 1) != 0 ? 1 : 0;
        int n7 = n4 + trackFragment.trunLength[n2];
        long l4 = track.timescale;
        l2 = trackFragment.nextFragmentDecodeTime;
        while (n4 < n7) {
            n2 = bl2 ? parsableByteArray.readInt() : ((DefaultSampleValues)trackBundle2).duration;
            int n8 = FragmentedMp4Extractor.checkNonNegative(n2);
            n2 = bl3 ? parsableByteArray.readInt() : ((DefaultSampleValues)trackBundle2).size;
            int n9 = FragmentedMp4Extractor.checkNonNegative(n2);
            n2 = bl4 ? parsableByteArray.readInt() : (n4 == 0 && bl ? n6 : ((DefaultSampleValues)trackBundle2).flags);
            nArray2[n4] = n5 != 0 ? (int)((long)parsableByteArray.readInt() * 1000000L / l4) : 0;
            lArray[n4] = Util.scaleLargeTimestamp(l2, 1000000L, l4) - l3;
            if (!trackFragment.nextFragmentDecodeTimeIncludesMoov) {
                lArray[n4] = lArray[n4] + trackBundle.moovSampleTable.durationUs;
            }
            nArray[n4] = n9;
            boolean bl5 = (n2 >> 16 & 1) == 0 && (n3 == 0 || n4 == 0);
            blArray[n4] = bl5;
            l2 += (long)n8;
            ++n4;
        }
        trackFragment.nextFragmentDecodeTime = l2;
        return n7;
    }

    private static void parseTruns(Atom.ContainerAtom object, TrackBundle trackBundle, int n2) throws ParserException {
        int n3;
        int n4;
        Atom.LeafAtom leafAtom;
        int n5;
        object = ((Atom.ContainerAtom)object).leafChildren;
        int n6 = object.size();
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        for (n5 = 0; n5 < n6; ++n5) {
            leafAtom = (Atom.LeafAtom)object.get(n5);
            n4 = n8;
            n3 = n9;
            if (leafAtom.type == 1953658222) {
                leafAtom = leafAtom.data;
                leafAtom.setPosition(12);
                int n10 = leafAtom.readUnsignedIntToInt();
                n4 = n8;
                n3 = n9;
                if (n10 > 0) {
                    n3 = n9 + n10;
                    n4 = n8 + 1;
                }
            }
            n8 = n4;
            n9 = n3;
        }
        trackBundle.currentTrackRunIndex = 0;
        trackBundle.currentSampleInTrackRun = 0;
        trackBundle.currentSampleIndex = 0;
        trackBundle.fragment.initTables(n8, n9);
        n3 = 0;
        n5 = 0;
        for (n9 = n7; n9 < n6; ++n9) {
            leafAtom = (Atom.LeafAtom)object.get(n9);
            n4 = n3;
            n8 = n5;
            if (leafAtom.type == 1953658222) {
                n8 = FragmentedMp4Extractor.parseTrun(trackBundle, n3, n2, leafAtom.data, n5);
                n4 = n3 + 1;
            }
            n3 = n4;
            n5 = n8;
        }
    }

    private static void parseUuid(ParsableByteArray parsableByteArray, TrackFragment trackFragment, byte[] byArray) throws ParserException {
        parsableByteArray.setPosition(8);
        parsableByteArray.readBytes(byArray, 0, 16);
        if (!Arrays.equals(byArray, PIFF_SAMPLE_ENCRYPTION_BOX_EXTENDED_TYPE)) {
            return;
        }
        FragmentedMp4Extractor.parseSenc(parsableByteArray, 16, trackFragment);
    }

    private void processAtomEnded(long l2) throws ParserException {
        while (!this.containerAtoms.isEmpty() && this.containerAtoms.peek().endPosition == l2) {
            this.onContainerAtomRead(this.containerAtoms.pop());
        }
        this.enterReadingAtomHeaderState();
    }

    private boolean readAtomHeader(ExtractorInput extractorInput) throws IOException {
        block17: {
            block23: {
                block19: {
                    block20: {
                        block21: {
                            block22: {
                                long l2;
                                block18: {
                                    if (this.atomHeaderBytesRead == 0) {
                                        if (!extractorInput.readFully(this.atomHeader.getData(), 0, 8, true)) {
                                            return false;
                                        }
                                        this.atomHeaderBytesRead = 8;
                                        this.atomHeader.setPosition(0);
                                        this.atomSize = this.atomHeader.readUnsignedInt();
                                        this.atomType = this.atomHeader.readInt();
                                    }
                                    if ((l2 = this.atomSize) == 1L) {
                                        extractorInput.readFully(this.atomHeader.getData(), 8, 8);
                                        this.atomHeaderBytesRead += 8;
                                        this.atomSize = this.atomHeader.readUnsignedLongToLong();
                                    } else if (l2 == 0L) {
                                        long l3;
                                        l2 = l3 = extractorInput.getLength();
                                        if (l3 == -1L) {
                                            l2 = l3;
                                            if (!this.containerAtoms.isEmpty()) {
                                                l2 = this.containerAtoms.peek().endPosition;
                                            }
                                        }
                                        if (l2 != -1L) {
                                            this.atomSize = l2 - extractorInput.getPosition() + (long)this.atomHeaderBytesRead;
                                        }
                                    }
                                    if (this.atomSize < (long)this.atomHeaderBytesRead) break block17;
                                    l2 = extractorInput.getPosition() - (long)this.atomHeaderBytesRead;
                                    int n2 = this.atomType;
                                    if (!(n2 != 0x6D6F6F66 && n2 != 1835295092 || this.haveOutputSeekMap)) {
                                        this.extractorOutput.seekMap(new SeekMap.Unseekable(this.durationUs, l2));
                                        this.haveOutputSeekMap = true;
                                    }
                                    if (this.atomType == 0x6D6F6F66) {
                                        int n3 = this.trackBundles.size();
                                        for (n2 = 0; n2 < n3; ++n2) {
                                            TrackFragment trackFragment = ((TrackBundle)this.trackBundles.valueAt((int)n2)).fragment;
                                            trackFragment.atomPosition = l2;
                                            trackFragment.auxiliaryDataPosition = l2;
                                            trackFragment.dataPosition = l2;
                                        }
                                    }
                                    if ((n2 = this.atomType) == 1835295092) {
                                        this.currentTrackBundle = null;
                                        this.endOfMdatPosition = l2 + this.atomSize;
                                        this.parserState = 2;
                                        return true;
                                    }
                                    if (!FragmentedMp4Extractor.shouldParseContainerAtom(n2)) break block18;
                                    l2 = extractorInput.getPosition() + this.atomSize - 8L;
                                    this.containerAtoms.push(new Atom.ContainerAtom(this.atomType, l2));
                                    if (this.atomSize == (long)this.atomHeaderBytesRead) {
                                        this.processAtomEnded(l2);
                                    } else {
                                        this.enterReadingAtomHeaderState();
                                    }
                                    break block19;
                                }
                                if (!FragmentedMp4Extractor.shouldParseLeafAtom(this.atomType)) break block20;
                                if (this.atomHeaderBytesRead != 8) break block21;
                                l2 = this.atomSize;
                                if (l2 > Integer.MAX_VALUE) break block22;
                                extractorInput = new ParsableByteArray((int)l2);
                                System.arraycopy(this.atomHeader.getData(), 0, extractorInput.getData(), 0, 8);
                                this.atomData = extractorInput;
                                this.parserState = 1;
                                break block19;
                            }
                            throw new ParserException("Leaf atom with length > 2147483647 (unsupported).");
                        }
                        throw new ParserException("Leaf atom defines extended atom size (unsupported).");
                    }
                    if (this.atomSize > Integer.MAX_VALUE) break block23;
                    this.atomData = null;
                    this.parserState = 1;
                }
                return true;
            }
            throw new ParserException("Skipping atom with length > 2147483647 (unsupported).");
        }
        extractorInput = new ParserException("Atom size less than header length (unsupported).");
        throw extractorInput;
    }

    private void readAtomPayload(ExtractorInput extractorInput) throws IOException {
        int n2 = (int)this.atomSize - this.atomHeaderBytesRead;
        ParsableByteArray parsableByteArray = this.atomData;
        if (parsableByteArray != null) {
            extractorInput.readFully(parsableByteArray.getData(), 8, n2);
            this.onLeafAtomRead(new Atom.LeafAtom(this.atomType, parsableByteArray), extractorInput.getPosition());
        } else {
            extractorInput.skipFully(n2);
        }
        this.processAtomEnded(extractorInput.getPosition());
    }

    private void readEncryptionData(ExtractorInput extractorInput) throws IOException {
        int n2;
        int n3 = this.trackBundles.size();
        TrackBundle trackBundle = null;
        long l2 = Long.MAX_VALUE;
        for (n2 = 0; n2 < n3; ++n2) {
            TrackFragment trackFragment = ((TrackBundle)this.trackBundles.valueAt((int)n2)).fragment;
            TrackBundle trackBundle2 = trackBundle;
            long l3 = l2;
            if (trackFragment.sampleEncryptionDataNeedsFill) {
                trackBundle2 = trackBundle;
                l3 = l2;
                if (trackFragment.auxiliaryDataPosition < l2) {
                    l3 = trackFragment.auxiliaryDataPosition;
                    trackBundle2 = (TrackBundle)this.trackBundles.valueAt(n2);
                }
            }
            trackBundle = trackBundle2;
            l2 = l3;
        }
        if (trackBundle == null) {
            this.parserState = 3;
            return;
        }
        n2 = (int)(l2 - extractorInput.getPosition());
        if (n2 >= 0) {
            extractorInput.skipFully(n2);
            trackBundle.fragment.fillEncryptionData(extractorInput);
            return;
        }
        extractorInput = new ParserException("Offset to encryption data was negative.");
        throw extractorInput;
    }

    private boolean readSample(ExtractorInput object) throws IOException {
        int n2;
        int n3;
        Object object2 = this.currentTrackBundle;
        TrackBundle trackBundle = object2;
        if (object2 == null) {
            trackBundle = FragmentedMp4Extractor.getNextTrackBundle(this.trackBundles);
            if (trackBundle == null) {
                int n4 = (int)(this.endOfMdatPosition - object.getPosition());
                if (n4 >= 0) {
                    object.skipFully(n4);
                    this.enterReadingAtomHeaderState();
                    return false;
                }
                throw new ParserException("Offset to end of mdat was negative.");
            }
            n2 = n3 = (int)(trackBundle.getCurrentSampleOffset() - object.getPosition());
            if (n3 < 0) {
                Log.w(TAG, "Ignoring negative offset to sample data.");
                n2 = 0;
            }
            object.skipFully(n2);
            this.currentTrackBundle = trackBundle;
        }
        if (this.parserState == 3) {
            this.sampleSize = trackBundle.getCurrentSampleSize();
            if (trackBundle.currentSampleIndex < trackBundle.firstSampleToOutputIndex) {
                object.skipFully(this.sampleSize);
                trackBundle.skipSampleEncryptionData();
                if (!trackBundle.next()) {
                    this.currentTrackBundle = null;
                }
                this.parserState = 3;
                return true;
            }
            if (trackBundle.moovSampleTable.track.sampleTransformation == 1) {
                this.sampleSize -= 8;
                object.skipFully(8);
            }
            if ("audio/ac4".equals(trackBundle.moovSampleTable.track.format.sampleMimeType)) {
                this.sampleBytesWritten = trackBundle.outputSampleEncryptionData(this.sampleSize, 7);
                Ac4Util.getAc4SampleHeader((int)this.sampleSize, (ParsableByteArray)this.scratch);
                trackBundle.output.sampleData(this.scratch, 7);
                this.sampleBytesWritten += 7;
            } else {
                this.sampleBytesWritten = trackBundle.outputSampleEncryptionData(this.sampleSize, 0);
            }
            this.sampleSize += this.sampleBytesWritten;
            this.parserState = 4;
            this.sampleCurrentNalBytesRemaining = 0;
        }
        Track track = trackBundle.moovSampleTable.track;
        object2 = trackBundle.output;
        long l2 = trackBundle.getCurrentSamplePresentationTimeUs();
        Object object3 = this.timestampAdjuster;
        long l3 = l2;
        if (object3 != null) {
            l3 = object3.adjustSampleTimestamp(l2);
        }
        if (track.nalUnitLengthFieldLength != 0) {
            object3 = this.nalPrefix.getData();
            object3[0] = (TimestampAdjuster)((byte)0);
            object3[1] = (TimestampAdjuster)((byte)0);
            object3[2] = (TimestampAdjuster)((byte)0);
            n3 = track.nalUnitLengthFieldLength;
            int n5 = 4 - track.nalUnitLengthFieldLength;
            while (this.sampleBytesWritten < this.sampleSize) {
                n2 = this.sampleCurrentNalBytesRemaining;
                if (n2 == 0) {
                    object.readFully((byte[])object3, n5, n3 + 1);
                    this.nalPrefix.setPosition(0);
                    n2 = this.nalPrefix.readInt();
                    if (n2 >= 1) {
                        this.sampleCurrentNalBytesRemaining = n2 - 1;
                        this.nalStartCode.setPosition(0);
                        object2.sampleData(this.nalStartCode, 4);
                        object2.sampleData(this.nalPrefix, 1);
                        boolean bl = this.ceaTrackOutputs.length > 0 && NalUnitUtil.isNalUnitSei((String)track.format.sampleMimeType, (byte)object3[4]);
                        this.processSeiNalUnitPayload = bl;
                        this.sampleBytesWritten += 5;
                        this.sampleSize += n5;
                        continue;
                    }
                    throw new ParserException("Invalid NAL length");
                }
                if (this.processSeiNalUnitPayload) {
                    this.nalBuffer.reset(n2);
                    object.readFully(this.nalBuffer.getData(), 0, this.sampleCurrentNalBytesRemaining);
                    object2.sampleData(this.nalBuffer, this.sampleCurrentNalBytesRemaining);
                    n2 = this.sampleCurrentNalBytesRemaining;
                    int n6 = NalUnitUtil.unescapeStream((byte[])this.nalBuffer.getData(), (int)this.nalBuffer.limit());
                    this.nalBuffer.setPosition("video/hevc".equals(track.format.sampleMimeType) ? 1 : 0);
                    this.nalBuffer.setLimit(n6);
                    CeaUtil.consume((long)l3, (ParsableByteArray)this.nalBuffer, (TrackOutput[])this.ceaTrackOutputs);
                } else {
                    n2 = object2.sampleData((DataReader)object, n2, false);
                }
                this.sampleBytesWritten += n2;
                this.sampleCurrentNalBytesRemaining -= n2;
            }
        } else {
            while ((n3 = this.sampleBytesWritten) < (n2 = this.sampleSize)) {
                n2 = object2.sampleData((DataReader)object, n2 - n3, false);
                this.sampleBytesWritten += n2;
            }
        }
        n2 = trackBundle.getCurrentSampleFlags();
        object = trackBundle.getEncryptionBoxIfEncrypted();
        object = object != null ? object.cryptoData : null;
        object2.sampleMetadata(l3, n2, this.sampleSize, 0, (TrackOutput.CryptoData)object);
        this.outputPendingMetadataSamples(l3);
        if (!trackBundle.next()) {
            this.currentTrackBundle = null;
        }
        this.parserState = 3;
        return true;
    }

    private static boolean shouldParseContainerAtom(int n2) {
        boolean bl = n2 == 1836019574 || n2 == 1953653099 || n2 == 1835297121 || n2 == 1835626086 || n2 == 1937007212 || n2 == 0x6D6F6F66 || n2 == 1953653094 || n2 == 1836475768 || n2 == 1701082227;
        return bl;
    }

    private static boolean shouldParseLeafAtom(int n2) {
        boolean bl = n2 == 1751411826 || n2 == 1835296868 || n2 == 1836476516 || n2 == 1936286840 || n2 == 1937011556 || n2 == 0x73747473 || n2 == 1668576371 || n2 == 1937011555 || n2 == 1937011578 || n2 == 1937013298 || n2 == 1937007471 || n2 == 1668232756 || n2 == 0x73747373 || n2 == 0x74666474 || n2 == 1952868452 || n2 == 1953196132 || n2 == 1953654136 || n2 == 1953658222 || n2 == 1886614376 || n2 == 1935763834 || n2 == 1935763823 || n2 == 1936027235 || n2 == 1970628964 || n2 == 1935828848 || n2 == 1936158820 || n2 == 1701606260 || n2 == 1835362404 || n2 == 1701671783;
        return bl;
    }

    @Override
    public void init(ExtractorOutput object) {
        this.extractorOutput = object;
        this.enterReadingAtomHeaderState();
        this.initExtraTracks();
        Track track = this.sideloadedTrack;
        if (track != null) {
            object = new TrackBundle(object.track(0, track.type), new TrackSampleTable(this.sideloadedTrack, new long[0], new int[0], 0, new long[0], new int[0], 0L), new DefaultSampleValues(0, 0, 0, 0));
            this.trackBundles.put(0, object);
            this.extractorOutput.endTracks();
        }
    }

    protected Track modifyTrack(Track track) {
        return track;
    }

    @Override
    public int read(ExtractorInput extractorInput, PositionHolder positionHolder) throws IOException {
        while (true) {
            int n2;
            if ((n2 = this.parserState) != 0) {
                if (n2 != 1) {
                    if (n2 != 2) {
                        if (!this.readSample(extractorInput)) continue;
                        return 0;
                    }
                    this.readEncryptionData(extractorInput);
                    continue;
                }
                this.readAtomPayload(extractorInput);
                continue;
            }
            if (!this.readAtomHeader(extractorInput)) break;
        }
        return -1;
    }

    @Override
    public void release() {
    }

    @Override
    public void seek(long l2, long l3) {
        int n2 = this.trackBundles.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ((TrackBundle)this.trackBundles.valueAt(i2)).resetFragmentInfo();
        }
        this.pendingMetadataSampleInfos.clear();
        this.pendingMetadataSampleBytes = 0;
        this.pendingSeekTimeUs = l3;
        this.containerAtoms.clear();
        this.enterReadingAtomHeaderState();
    }

    @Override
    public boolean sniff(ExtractorInput extractorInput) throws IOException {
        return Sniffer.sniffFragmented((ExtractorInput)extractorInput);
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Flags {
    }

    private static final class MetadataSampleInfo {
        public final long presentationTimeDeltaUs;
        public final int size;

        public MetadataSampleInfo(long l2, int n2) {
            this.presentationTimeDeltaUs = l2;
            this.size = n2;
        }
    }

    private static final class TrackBundle {
        private static final int SINGLE_SUBSAMPLE_ENCRYPTION_DATA_LENGTH = 8;
        public int currentSampleInTrackRun;
        public int currentSampleIndex;
        public int currentTrackRunIndex;
        private boolean currentlyInFragment;
        private final ParsableByteArray defaultInitializationVector;
        public DefaultSampleValues defaultSampleValues;
        private final ParsableByteArray encryptionSignalByte;
        public int firstSampleToOutputIndex;
        public final TrackFragment fragment;
        public TrackSampleTable moovSampleTable;
        public final TrackOutput output;
        public final ParsableByteArray scratch;

        public TrackBundle(TrackOutput trackOutput, TrackSampleTable trackSampleTable, DefaultSampleValues defaultSampleValues) {
            this.output = trackOutput;
            this.moovSampleTable = trackSampleTable;
            this.defaultSampleValues = defaultSampleValues;
            this.fragment = new TrackFragment();
            this.scratch = new ParsableByteArray();
            this.encryptionSignalByte = new ParsableByteArray(1);
            this.defaultInitializationVector = new ParsableByteArray();
            this.reset(trackSampleTable, defaultSampleValues);
        }

        static /* synthetic */ boolean access$002(TrackBundle trackBundle, boolean bl) {
            trackBundle.currentlyInFragment = bl;
            return bl;
        }

        public int getCurrentSampleFlags() {
            int n2 = !this.currentlyInFragment ? this.moovSampleTable.flags[this.currentSampleIndex] : (this.fragment.sampleIsSyncFrameTable[this.currentSampleIndex] ? 1 : 0);
            int n3 = n2;
            if (this.getEncryptionBoxIfEncrypted() != null) {
                n3 = n2 | 0x40000000;
            }
            return n3;
        }

        public long getCurrentSampleOffset() {
            long l2 = !this.currentlyInFragment ? this.moovSampleTable.offsets[this.currentSampleIndex] : this.fragment.trunDataPosition[this.currentTrackRunIndex];
            return l2;
        }

        public long getCurrentSamplePresentationTimeUs() {
            long l2 = !this.currentlyInFragment ? this.moovSampleTable.timestampsUs[this.currentSampleIndex] : this.fragment.getSamplePresentationTimeUs(this.currentSampleIndex);
            return l2;
        }

        public int getCurrentSampleSize() {
            int n2 = !this.currentlyInFragment ? this.moovSampleTable.sizes[this.currentSampleIndex] : this.fragment.sampleSizeTable[this.currentSampleIndex];
            return n2;
        }

        public TrackEncryptionBox getEncryptionBoxIfEncrypted() {
            if (!this.currentlyInFragment) {
                return null;
            }
            int n2 = Util.castNonNull(this.fragment.header).sampleDescriptionIndex;
            TrackEncryptionBox trackEncryptionBox = this.fragment.trackEncryptionBox != null ? this.fragment.trackEncryptionBox : this.moovSampleTable.track.getSampleDescriptionEncryptionBox(n2);
            if (trackEncryptionBox == null || !trackEncryptionBox.isEncrypted) {
                trackEncryptionBox = null;
            }
            return trackEncryptionBox;
        }

        public boolean next() {
            ++this.currentSampleIndex;
            if (!this.currentlyInFragment) {
                return false;
            }
            ++this.currentSampleInTrackRun;
            int n2 = this.currentSampleInTrackRun;
            int[] nArray = this.fragment.trunLength;
            int n3 = this.currentTrackRunIndex;
            if (n2 == nArray[n3]) {
                this.currentTrackRunIndex = n3 + 1;
                this.currentSampleInTrackRun = 0;
                return false;
            }
            return true;
        }

        public int outputSampleEncryptionData(int n2, int n3) {
            int n4;
            Object object;
            Object object2 = this.getEncryptionBoxIfEncrypted();
            if (object2 == null) {
                return 0;
            }
            if (object2.perSampleIvSize != 0) {
                object = this.fragment.sampleEncryptionData;
                n4 = object2.perSampleIvSize;
            } else {
                object2 = Util.castNonNull(object2.defaultInitializationVector);
                this.defaultInitializationVector.reset((byte[])object2, ((TrackEncryptionBox)object2).length);
                object = this.defaultInitializationVector;
                n4 = ((TrackEncryptionBox)object2).length;
            }
            boolean bl = this.fragment.sampleHasSubsampleEncryptionTable(this.currentSampleIndex);
            boolean bl2 = bl || n3 != 0;
            object2 = this.encryptionSignalByte.getData();
            int n5 = bl2 ? 128 : 0;
            object2[0] = (TrackEncryptionBox)((byte)((byte)(n5 | n4)));
            this.encryptionSignalByte.setPosition(0);
            this.output.sampleData(this.encryptionSignalByte, 1, 1);
            this.output.sampleData((ParsableByteArray)object, n4, 1);
            if (!bl2) {
                return n4 + 1;
            }
            if (!bl) {
                this.scratch.reset(8);
                object = this.scratch.getData();
                object[0] = (ParsableByteArray)((byte)0);
                object[1] = (ParsableByteArray)((byte)1);
                object[2] = (ParsableByteArray)((byte)((byte)(n3 >> 8 & 0xFF)));
                object[3] = (ParsableByteArray)((byte)((byte)(n3 & 0xFF)));
                object[4] = (ParsableByteArray)((byte)((byte)(n2 >> 24 & 0xFF)));
                object[5] = (ParsableByteArray)((byte)((byte)(n2 >> 16 & 0xFF)));
                object[6] = (ParsableByteArray)((byte)((byte)(n2 >> 8 & 0xFF)));
                object[7] = (ParsableByteArray)((byte)((byte)(n2 & 0xFF)));
                this.output.sampleData(this.scratch, 8, 1);
                return n4 + 1 + 8;
            }
            object2 = this.fragment.sampleEncryptionData;
            n2 = object2.readUnsignedShort();
            object2.skipBytes(-2);
            n2 = n2 * 6 + 2;
            object = object2;
            if (n3 != 0) {
                this.scratch.reset(n2);
                object = this.scratch.getData();
                object2.readBytes((byte[])object, 0, n2);
                n3 = ((object[2] & 0xFF) << 8 | object[3] & 0xFF) + n3;
                object[2] = (ParsableByteArray)((byte)((byte)(n3 >> 8 & 0xFF)));
                object[3] = (ParsableByteArray)((byte)((byte)(n3 & 0xFF)));
                object = this.scratch;
            }
            this.output.sampleData((ParsableByteArray)object, n2, 1);
            return n4 + 1 + n2;
        }

        public void reset(TrackSampleTable trackSampleTable, DefaultSampleValues defaultSampleValues) {
            this.moovSampleTable = trackSampleTable;
            this.defaultSampleValues = defaultSampleValues;
            this.output.format(trackSampleTable.track.format);
            this.resetFragmentInfo();
        }

        public void resetFragmentInfo() {
            this.fragment.reset();
            this.currentSampleIndex = 0;
            this.currentTrackRunIndex = 0;
            this.currentSampleInTrackRun = 0;
            this.firstSampleToOutputIndex = 0;
            this.currentlyInFragment = false;
        }

        public void seek(long l2) {
            for (int i2 = this.currentSampleIndex; i2 < this.fragment.sampleCount && this.fragment.getSamplePresentationTimeUs(i2) < l2; ++i2) {
                if (!this.fragment.sampleIsSyncFrameTable[i2]) continue;
                this.firstSampleToOutputIndex = i2;
            }
        }

        public void skipSampleEncryptionData() {
            TrackEncryptionBox trackEncryptionBox = this.getEncryptionBoxIfEncrypted();
            if (trackEncryptionBox == null) {
                return;
            }
            ParsableByteArray parsableByteArray = this.fragment.sampleEncryptionData;
            if (trackEncryptionBox.perSampleIvSize != 0) {
                parsableByteArray.skipBytes(trackEncryptionBox.perSampleIvSize);
            }
            if (this.fragment.sampleHasSubsampleEncryptionTable(this.currentSampleIndex)) {
                parsableByteArray.skipBytes(parsableByteArray.readUnsignedShort() * 6);
            }
        }

        public void updateDrmInitData(DrmInitData drmInitData) {
            Object object = this.moovSampleTable.track.getSampleDescriptionEncryptionBox(Util.castNonNull(this.fragment.header).sampleDescriptionIndex);
            object = object != null ? object.schemeType : null;
            drmInitData = drmInitData.copyWithSchemeType((String)object);
            drmInitData = this.moovSampleTable.track.format.buildUpon().setDrmInitData(drmInitData).build();
            this.output.format((Format)drmInitData);
        }
    }
}

