/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.mp3;

import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.audio.MpegAudioUtil;
import com.google.android.exoplayer2.extractor.DummyTrackOutput;
import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.extractor.GaplessInfoHolder;
import com.google.android.exoplayer2.extractor.Id3Peeker;
import com.google.android.exoplayer2.extractor.PositionHolder;
import com.google.android.exoplayer2.extractor.SeekMap;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.extractor.mp3.ConstantBitrateSeeker;
import com.google.android.exoplayer2.extractor.mp3.IndexSeeker;
import com.google.android.exoplayer2.extractor.mp3.MlltSeeker;
import com.google.android.exoplayer2.extractor.mp3.Seeker;
import com.google.android.exoplayer2.extractor.mp3.VbriSeeker;
import com.google.android.exoplayer2.extractor.mp3.XingSeeker;
import com.google.android.exoplayer2.extractor.mp3._$$Lambda$Mp3Extractor$6eyGfoogMVGFHZKg1gVp93FAKZA;
import com.google.android.exoplayer2.extractor.mp3._$$Lambda$Mp3Extractor$bb754AZIAMUosKBF4SefP1vYq88;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.metadata.id3.Id3Decoder;
import com.google.android.exoplayer2.metadata.id3.MlltFrame;
import com.google.android.exoplayer2.metadata.id3.TextInformationFrame;
import com.google.android.exoplayer2.upstream.DataReader;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import java.io.EOFException;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

public final class Mp3Extractor
implements Extractor {
    public static final ExtractorsFactory FACTORY = _$$Lambda$Mp3Extractor$6eyGfoogMVGFHZKg1gVp93FAKZA.INSTANCE;
    public static final int FLAG_DISABLE_ID3_METADATA = 4;
    public static final int FLAG_ENABLE_CONSTANT_BITRATE_SEEKING = 1;
    public static final int FLAG_ENABLE_INDEX_SEEKING = 2;
    private static final int MAX_SNIFF_BYTES = 32768;
    private static final int MAX_SYNC_BYTES = 131072;
    private static final int MPEG_AUDIO_HEADER_MASK = -128000;
    private static final Id3Decoder.FramePredicate REQUIRED_ID3_FRAME_PREDICATE = _$$Lambda$Mp3Extractor$bb754AZIAMUosKBF4SefP1vYq88.INSTANCE;
    private static final int SCRATCH_LENGTH = 10;
    private static final int SEEK_HEADER_INFO = 1231971951;
    private static final int SEEK_HEADER_UNSET = 0;
    private static final int SEEK_HEADER_VBRI = 1447187017;
    private static final int SEEK_HEADER_XING = 1483304551;
    private long basisTimeUs;
    private TrackOutput currentTrackOutput;
    private boolean disableSeeking;
    private ExtractorOutput extractorOutput;
    private long firstSamplePosition;
    private final int flags;
    private final long forcedFirstSampleTimestampUs;
    private final GaplessInfoHolder gaplessInfoHolder;
    private final Id3Peeker id3Peeker;
    private boolean isSeekInProgress;
    private Metadata metadata;
    private TrackOutput realTrackOutput;
    private int sampleBytesRemaining;
    private long samplesRead;
    private final ParsableByteArray scratch;
    private long seekTimeUs;
    private Seeker seeker;
    private final TrackOutput skippingTrackOutput;
    private final MpegAudioUtil.Header synchronizedHeader;
    private int synchronizedHeaderData;

    public Mp3Extractor() {
        this(0);
    }

    public Mp3Extractor(int n2) {
        this(n2, -9223372036854775807L);
    }

    public Mp3Extractor(int n2, long l2) {
        this.flags = n2;
        this.forcedFirstSampleTimestampUs = l2;
        this.scratch = new ParsableByteArray(10);
        this.synchronizedHeader = new MpegAudioUtil.Header();
        this.gaplessInfoHolder = new GaplessInfoHolder();
        this.basisTimeUs = -9223372036854775807L;
        this.id3Peeker = new Id3Peeker();
        this.currentTrackOutput = this.skippingTrackOutput = new DummyTrackOutput();
    }

    @EnsuresNonNull(value={"extractorOutput", "realTrackOutput"})
    private void assertInitialized() {
        Assertions.checkStateNotNull(this.realTrackOutput);
        Util.castNonNull(this.extractorOutput);
    }

    private Seeker computeSeeker(ExtractorInput extractorInput) throws IOException {
        MlltSeeker mlltSeeker;
        block14: {
            block13: {
                Seeker seeker = this.maybeReadSeekFrame(extractorInput);
                mlltSeeker = Mp3Extractor.maybeHandleSeekMetadata(this.metadata, extractorInput.getPosition());
                if (this.disableSeeking) {
                    return new Seeker.UnseekableSeeker();
                }
                if ((this.flags & 2) != 0) {
                    long l2;
                    long l3;
                    if (mlltSeeker != null) {
                        l3 = mlltSeeker.getDurationUs();
                        l2 = mlltSeeker.getDataEndPosition();
                    } else if (seeker != null) {
                        l3 = seeker.getDurationUs();
                        l2 = seeker.getDataEndPosition();
                    } else {
                        l3 = Mp3Extractor.getId3TlenUs(this.metadata);
                        l2 = -1L;
                    }
                    seeker = new IndexSeeker(l3, extractorInput.getPosition(), l2);
                } else if (mlltSeeker != null) {
                    seeker = mlltSeeker;
                } else if (seeker == null) {
                    seeker = null;
                }
                if (seeker == null) break block13;
                mlltSeeker = seeker;
                if (seeker.isSeekable()) break block14;
                mlltSeeker = seeker;
                if ((this.flags & 1) == 0) break block14;
            }
            mlltSeeker = this.getConstantBitrateSeeker(extractorInput);
        }
        return mlltSeeker;
    }

    private long computeTimeUs(long l2) {
        return this.basisTimeUs + l2 * 1000000L / (long)this.synchronizedHeader.sampleRate;
    }

    private Seeker getConstantBitrateSeeker(ExtractorInput extractorInput) throws IOException {
        extractorInput.peekFully(this.scratch.getData(), 0, 4);
        this.scratch.setPosition(0);
        this.synchronizedHeader.setForHeaderData(this.scratch.readInt());
        return new ConstantBitrateSeeker(extractorInput.getLength(), extractorInput.getPosition(), this.synchronizedHeader);
    }

    private static long getId3TlenUs(Metadata metadata) {
        if (metadata != null) {
            int n2 = metadata.length();
            for (int i2 = 0; i2 < n2; ++i2) {
                Metadata.Entry entry = metadata.get(i2);
                if (!(entry instanceof TextInformationFrame)) continue;
                entry = (TextInformationFrame)entry;
                if (!entry.id.equals("TLEN")) continue;
                return C.msToUs(Long.parseLong(entry.value));
            }
        }
        return -9223372036854775807L;
    }

    private static int getSeekFrameHeader(ParsableByteArray parsableByteArray, int n2) {
        if (parsableByteArray.limit() >= n2 + 4) {
            parsableByteArray.setPosition(n2);
            n2 = parsableByteArray.readInt();
            if (n2 == 1483304551 || n2 == 1231971951) {
                return n2;
            }
        }
        if (parsableByteArray.limit() >= 40) {
            parsableByteArray.setPosition(36);
            if (parsableByteArray.readInt() == 1447187017) {
                return 1447187017;
            }
        }
        return 0;
    }

    private static boolean headersMatch(int n2, long l2) {
        boolean bl = (long)(n2 & 0xFFFE0C00) == (l2 & 0xFFFFFFFFFFFE0C00L);
        return bl;
    }

    static /* synthetic */ Extractor[] lambda$static$0() {
        return new Extractor[]{new Mp3Extractor()};
    }

    static /* synthetic */ boolean lambda$static$1(int n2, int n3, int n4, int n5, int n6) {
        boolean bl = n3 == 67 && n4 == 79 && n5 == 77 && (n6 == 77 || n2 == 2) || n3 == 77 && n4 == 76 && n5 == 76 && (n6 == 84 || n2 == 2);
        return bl;
    }

    private static MlltSeeker maybeHandleSeekMetadata(Metadata metadata, long l2) {
        if (metadata != null) {
            int n2 = metadata.length();
            for (int i2 = 0; i2 < n2; ++i2) {
                Metadata.Entry entry = metadata.get(i2);
                if (!(entry instanceof MlltFrame)) continue;
                return MlltSeeker.create((long)l2, (MlltFrame)((MlltFrame)entry), (long)Mp3Extractor.getId3TlenUs(metadata));
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private Seeker maybeReadSeekFrame(ExtractorInput var1_1) throws IOException {
        block11: {
            block10: {
                var2_2 = new ParsableByteArray(this.synchronizedHeader.frameSize);
                var1_1.peekFully(var2_2.getData(), 0, this.synchronizedHeader.frameSize);
                if ((this.synchronizedHeader.version & 1) == 0) break block10;
                if (this.synchronizedHeader.channels == 1) ** GOTO lbl-1000
                var3_3 = 36;
                break block11;
            }
            if (this.synchronizedHeader.channels != 1) lbl-1000:
            // 2 sources

            {
                var3_3 = 21;
            } else {
                var3_3 = 13;
            }
        }
        var4_4 = Mp3Extractor.getSeekFrameHeader(var2_2, var3_3);
        if (var4_4 != 1483304551 && var4_4 != 1231971951) {
            if (var4_4 == 1447187017) {
                var2_2 = VbriSeeker.create((long)var1_1.getLength(), (long)var1_1.getPosition(), (MpegAudioUtil.Header)this.synchronizedHeader, (ParsableByteArray)var2_2);
                var1_1.skipFully(this.synchronizedHeader.frameSize);
            } else {
                var2_2 = null;
                var1_1.resetPeekPosition();
            }
        } else {
            var5_5 = XingSeeker.create((long)var1_1.getLength(), (long)var1_1.getPosition(), (MpegAudioUtil.Header)this.synchronizedHeader, (ParsableByteArray)var2_2);
            if (var5_5 != null && !this.gaplessInfoHolder.hasGaplessInfo()) {
                var1_1.resetPeekPosition();
                var1_1.advancePeekPosition(var3_3 + 141);
                var1_1.peekFully(this.scratch.getData(), 0, 3);
                this.scratch.setPosition(0);
                this.gaplessInfoHolder.setFromXingHeaderValue(this.scratch.readUnsignedInt24());
            }
            var1_1.skipFully(this.synchronizedHeader.frameSize);
            var2_2 = var5_5;
            if (var5_5 != null) {
                var2_2 = var5_5;
                if (!var5_5.isSeekable()) {
                    var2_2 = var5_5;
                    if (var4_4 == 1231971951) {
                        return this.getConstantBitrateSeeker(var1_1);
                    }
                }
            }
        }
        return var2_2;
    }

    private boolean peekEndOfStreamOrHeader(ExtractorInput extractorInput) throws IOException {
        long l2;
        Seeker seeker = this.seeker;
        if (seeker != null && (l2 = seeker.getDataEndPosition()) != -1L && extractorInput.getPeekPosition() > l2 - 4L) {
            return true;
        }
        try {
            boolean bl = extractorInput.peekFully(this.scratch.getData(), 0, 4, true);
            return bl ^ true;
        }
        catch (EOFException eOFException) {
            return true;
        }
    }

    @RequiresNonNull(value={"extractorOutput", "realTrackOutput"})
    private int readInternal(ExtractorInput extractorInput) throws IOException {
        long l2;
        long l3;
        if (this.synchronizedHeaderData == 0) {
            try {
                this.synchronize(extractorInput, false);
            }
            catch (EOFException eOFException) {
                return -1;
            }
        }
        if (this.seeker == null) {
            this.seeker = this.computeSeeker(extractorInput);
            this.extractorOutput.seekMap((SeekMap)this.seeker);
            TrackOutput trackOutput = this.currentTrackOutput;
            Format.Builder builder = new Format.Builder().setSampleMimeType(this.synchronizedHeader.mimeType).setMaxInputSize(4096).setChannelCount(this.synchronizedHeader.channels).setSampleRate(this.synchronizedHeader.sampleRate).setEncoderDelay(this.gaplessInfoHolder.encoderDelay).setEncoderPadding(this.gaplessInfoHolder.encoderPadding);
            Metadata metadata = (this.flags & 4) != 0 ? null : this.metadata;
            trackOutput.format(builder.setMetadata(metadata).build());
            this.firstSamplePosition = extractorInput.getPosition();
        } else if (this.firstSamplePosition != 0L && (l3 = extractorInput.getPosition()) < (l2 = this.firstSamplePosition)) {
            extractorInput.skipFully((int)(l2 - l3));
        }
        return this.readSample(extractorInput);
    }

    @RequiresNonNull(value={"realTrackOutput", "seeker"})
    private int readSample(ExtractorInput extractorInput) throws IOException {
        int n2;
        if (this.sampleBytesRemaining == 0) {
            extractorInput.resetPeekPosition();
            if (this.peekEndOfStreamOrHeader(extractorInput)) {
                return -1;
            }
            this.scratch.setPosition(0);
            n2 = this.scratch.readInt();
            if (Mp3Extractor.headersMatch(n2, this.synchronizedHeaderData) && MpegAudioUtil.getFrameSize((int)n2) != -1) {
                this.synchronizedHeader.setForHeaderData(n2);
                if (this.basisTimeUs == -9223372036854775807L) {
                    this.basisTimeUs = this.seeker.getTimeUs(extractorInput.getPosition());
                    if (this.forcedFirstSampleTimestampUs != -9223372036854775807L) {
                        long l2 = this.seeker.getTimeUs(0L);
                        this.basisTimeUs += this.forcedFirstSampleTimestampUs - l2;
                    }
                }
                this.sampleBytesRemaining = this.synchronizedHeader.frameSize;
                Seeker seeker = this.seeker;
                if (seeker instanceof IndexSeeker) {
                    seeker = (IndexSeeker)seeker;
                    seeker.maybeAddSeekPoint(this.computeTimeUs(this.samplesRead + (long)this.synchronizedHeader.samplesPerFrame), extractorInput.getPosition() + (long)this.synchronizedHeader.frameSize);
                    if (this.isSeekInProgress && seeker.isTimeUsInIndex(this.seekTimeUs)) {
                        this.isSeekInProgress = false;
                        this.currentTrackOutput = this.realTrackOutput;
                    }
                }
            } else {
                extractorInput.skipFully(1);
                this.synchronizedHeaderData = 0;
                return 0;
            }
        }
        if ((n2 = this.currentTrackOutput.sampleData((DataReader)extractorInput, this.sampleBytesRemaining, true)) == -1) {
            return -1;
        }
        this.sampleBytesRemaining -= n2;
        if (this.sampleBytesRemaining > 0) {
            return 0;
        }
        this.currentTrackOutput.sampleMetadata(this.computeTimeUs(this.samplesRead), 1, this.synchronizedHeader.frameSize, 0, null);
        this.samplesRead += (long)this.synchronizedHeader.samplesPerFrame;
        this.sampleBytesRemaining = 0;
        return 0;
    }

    private boolean synchronize(ExtractorInput extractorInput, boolean bl) throws IOException {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = bl ? 32768 : 131072;
        extractorInput.resetPeekPosition();
        if (extractorInput.getPosition() == 0L) {
            n5 = (this.flags & 4) == 0 ? 1 : 0;
            Id3Decoder.FramePredicate framePredicate = n5 != 0 ? null : REQUIRED_ID3_FRAME_PREDICATE;
            this.metadata = this.id3Peeker.peekId3Data(extractorInput, framePredicate);
            framePredicate = this.metadata;
            if (framePredicate != null) {
                this.gaplessInfoHolder.setFromMetadata((Metadata)framePredicate);
            }
            n4 = (int)extractorInput.getPeekPosition();
            if (!bl) {
                extractorInput.skipFully(n4);
            }
            n5 = 0;
            n3 = 0;
            n2 = 0;
        } else {
            n5 = 0;
            n3 = 0;
            n2 = 0;
            n4 = 0;
        }
        while (true) {
            int n7;
            int n8;
            block20: {
                block18: {
                    block19: {
                        block17: {
                            if (!this.peekEndOfStreamOrHeader(extractorInput)) break block17;
                            if (n3 <= 0) {
                                throw new EOFException();
                            }
                            break block18;
                        }
                        this.scratch.setPosition(0);
                        int n9 = this.scratch.readInt();
                        if (n5 != 0 && !Mp3Extractor.headersMatch(n9, n5) || (n8 = MpegAudioUtil.getFrameSize((int)n9)) == -1) {
                            n5 = n2 + 1;
                            if (n2 == n6) {
                                if (bl) {
                                    return false;
                                }
                                throw new ParserException("Searched too many bytes.");
                            }
                            if (bl) {
                                extractorInput.resetPeekPosition();
                                extractorInput.advancePeekPosition(n4 + n5);
                            } else {
                                extractorInput.skipFully(1);
                            }
                            n2 = n5;
                            n5 = 0;
                            n3 = 0;
                            continue;
                        }
                        n7 = n3 + 1;
                        if (n7 != 1) break block19;
                        this.synchronizedHeader.setForHeaderData(n9);
                        n3 = n9;
                        break block20;
                    }
                    n3 = n5;
                    if (n7 != 4) break block20;
                }
                if (bl) {
                    extractorInput.skipFully(n4 + n2);
                } else {
                    extractorInput.resetPeekPosition();
                }
                this.synchronizedHeaderData = n5;
                return true;
            }
            extractorInput.advancePeekPosition(n8 - 4);
            n5 = n3;
            n3 = n7;
        }
    }

    public void disableSeeking() {
        this.disableSeeking = true;
    }

    @Override
    public void init(ExtractorOutput extractorOutput) {
        this.extractorOutput = extractorOutput;
        this.currentTrackOutput = this.realTrackOutput = this.extractorOutput.track(0, 1);
        this.extractorOutput.endTracks();
    }

    @Override
    public int read(ExtractorInput extractorInput, PositionHolder positionHolder) throws IOException {
        this.assertInitialized();
        int n2 = this.readInternal(extractorInput);
        if (n2 == -1 && this.seeker instanceof IndexSeeker) {
            long l2 = this.computeTimeUs(this.samplesRead);
            if (this.seeker.getDurationUs() != l2) {
                ((IndexSeeker)this.seeker).setDurationUs(l2);
                this.extractorOutput.seekMap((SeekMap)this.seeker);
            }
        }
        return n2;
    }

    @Override
    public void release() {
    }

    @Override
    public void seek(long l2, long l3) {
        this.synchronizedHeaderData = 0;
        this.basisTimeUs = -9223372036854775807L;
        this.samplesRead = 0L;
        this.sampleBytesRemaining = 0;
        this.seekTimeUs = l3;
        Seeker seeker = this.seeker;
        if (seeker instanceof IndexSeeker && !((IndexSeeker)seeker).isTimeUsInIndex(l3)) {
            this.isSeekInProgress = true;
            this.currentTrackOutput = this.skippingTrackOutput;
        }
    }

    @Override
    public boolean sniff(ExtractorInput extractorInput) throws IOException {
        return this.synchronize(extractorInput, true);
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Flags {
    }
}

