/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.mkv;

import android.util.Pair;
import android.util.SparseArray;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.audio.AacUtil;
import com.google.android.exoplayer2.audio.Ac3Util;
import com.google.android.exoplayer2.drm.DrmInitData;
import com.google.android.exoplayer2.extractor.ChunkIndex;
import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.extractor.PositionHolder;
import com.google.android.exoplayer2.extractor.SeekMap;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.extractor.mkv.DefaultEbmlReader;
import com.google.android.exoplayer2.extractor.mkv.EbmlProcessor;
import com.google.android.exoplayer2.extractor.mkv.EbmlReader;
import com.google.android.exoplayer2.extractor.mkv.Sniffer;
import com.google.android.exoplayer2.extractor.mkv.VarintReader;
import com.google.android.exoplayer2.extractor.mkv._$$Lambda$MatroskaExtractor$jNXW0tyYIOPE6N2jicocV6rRvBs;
import com.google.android.exoplayer2.upstream.DataReader;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.LongArray;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.NalUnitUtil;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import com.google.android.exoplayer2.video.AvcConfig;
import com.google.android.exoplayer2.video.ColorInfo;
import com.google.android.exoplayer2.video.DolbyVisionConfig;
import com.google.android.exoplayer2.video.HevcConfig;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

public class MatroskaExtractor
implements Extractor {
    private static final int BLOCK_ADDITIONAL_ID_VP9_ITU_T_35 = 4;
    private static final int BLOCK_ADD_ID_TYPE_DVCC = 1685480259;
    private static final int BLOCK_ADD_ID_TYPE_DVVC = 1685485123;
    private static final int BLOCK_STATE_DATA = 2;
    private static final int BLOCK_STATE_HEADER = 1;
    private static final int BLOCK_STATE_START = 0;
    private static final String CODEC_ID_AAC = "A_AAC";
    private static final String CODEC_ID_AC3 = "A_AC3";
    private static final String CODEC_ID_ACM = "A_MS/ACM";
    private static final String CODEC_ID_ASS = "S_TEXT/ASS";
    private static final String CODEC_ID_AV1 = "V_AV1";
    private static final String CODEC_ID_DTS = "A_DTS";
    private static final String CODEC_ID_DTS_EXPRESS = "A_DTS/EXPRESS";
    private static final String CODEC_ID_DTS_LOSSLESS = "A_DTS/LOSSLESS";
    private static final String CODEC_ID_DVBSUB = "S_DVBSUB";
    private static final String CODEC_ID_E_AC3 = "A_EAC3";
    private static final String CODEC_ID_FLAC = "A_FLAC";
    private static final String CODEC_ID_FOURCC = "V_MS/VFW/FOURCC";
    private static final String CODEC_ID_H264 = "V_MPEG4/ISO/AVC";
    private static final String CODEC_ID_H265 = "V_MPEGH/ISO/HEVC";
    private static final String CODEC_ID_MP2 = "A_MPEG/L2";
    private static final String CODEC_ID_MP3 = "A_MPEG/L3";
    private static final String CODEC_ID_MPEG2 = "V_MPEG2";
    private static final String CODEC_ID_MPEG4_AP = "V_MPEG4/ISO/AP";
    private static final String CODEC_ID_MPEG4_ASP = "V_MPEG4/ISO/ASP";
    private static final String CODEC_ID_MPEG4_SP = "V_MPEG4/ISO/SP";
    private static final String CODEC_ID_OPUS = "A_OPUS";
    private static final String CODEC_ID_PCM_FLOAT = "A_PCM/FLOAT/IEEE";
    private static final String CODEC_ID_PCM_INT_BIG = "A_PCM/INT/BIG";
    private static final String CODEC_ID_PCM_INT_LIT = "A_PCM/INT/LIT";
    private static final String CODEC_ID_PGS = "S_HDMV/PGS";
    private static final String CODEC_ID_SUBRIP = "S_TEXT/UTF8";
    private static final String CODEC_ID_THEORA = "V_THEORA";
    private static final String CODEC_ID_TRUEHD = "A_TRUEHD";
    private static final String CODEC_ID_VOBSUB = "S_VOBSUB";
    private static final String CODEC_ID_VORBIS = "A_VORBIS";
    private static final String CODEC_ID_VP8 = "V_VP8";
    private static final String CODEC_ID_VP9 = "V_VP9";
    private static final String DOC_TYPE_MATROSKA = "matroska";
    private static final String DOC_TYPE_WEBM = "webm";
    private static final int ENCRYPTION_IV_SIZE = 8;
    public static final ExtractorsFactory FACTORY = _$$Lambda$MatroskaExtractor$jNXW0tyYIOPE6N2jicocV6rRvBs.INSTANCE;
    public static final int FLAG_DISABLE_SEEK_FOR_CUES = 1;
    private static final int FOURCC_COMPRESSION_DIVX = 1482049860;
    private static final int FOURCC_COMPRESSION_H263 = 859189832;
    private static final int FOURCC_COMPRESSION_VC1 = 826496599;
    private static final int ID_AUDIO = 225;
    private static final int ID_AUDIO_BIT_DEPTH = 25188;
    private static final int ID_BLOCK = 161;
    private static final int ID_BLOCK_ADDITIONAL = 165;
    private static final int ID_BLOCK_ADDITIONS = 30113;
    private static final int ID_BLOCK_ADDITION_MAPPING = 16868;
    private static final int ID_BLOCK_ADD_ID = 238;
    private static final int ID_BLOCK_ADD_ID_EXTRA_DATA = 16877;
    private static final int ID_BLOCK_ADD_ID_TYPE = 16871;
    private static final int ID_BLOCK_DURATION = 155;
    private static final int ID_BLOCK_GROUP = 160;
    private static final int ID_BLOCK_MORE = 166;
    private static final int ID_CHANNELS = 159;
    private static final int ID_CLUSTER = 524531317;
    private static final int ID_CODEC_DELAY = 22186;
    private static final int ID_CODEC_ID = 134;
    private static final int ID_CODEC_PRIVATE = 25506;
    private static final int ID_COLOUR = 21936;
    private static final int ID_COLOUR_PRIMARIES = 21947;
    private static final int ID_COLOUR_RANGE = 21945;
    private static final int ID_COLOUR_TRANSFER = 21946;
    private static final int ID_CONTENT_COMPRESSION = 20532;
    private static final int ID_CONTENT_COMPRESSION_ALGORITHM = 16980;
    private static final int ID_CONTENT_COMPRESSION_SETTINGS = 16981;
    private static final int ID_CONTENT_ENCODING = 25152;
    private static final int ID_CONTENT_ENCODINGS = 28032;
    private static final int ID_CONTENT_ENCODING_ORDER = 20529;
    private static final int ID_CONTENT_ENCODING_SCOPE = 20530;
    private static final int ID_CONTENT_ENCRYPTION = 20533;
    private static final int ID_CONTENT_ENCRYPTION_AES_SETTINGS = 18407;
    private static final int ID_CONTENT_ENCRYPTION_AES_SETTINGS_CIPHER_MODE = 18408;
    private static final int ID_CONTENT_ENCRYPTION_ALGORITHM = 18401;
    private static final int ID_CONTENT_ENCRYPTION_KEY_ID = 18402;
    private static final int ID_CUES = 475249515;
    private static final int ID_CUE_CLUSTER_POSITION = 241;
    private static final int ID_CUE_POINT = 187;
    private static final int ID_CUE_TIME = 179;
    private static final int ID_CUE_TRACK_POSITIONS = 183;
    private static final int ID_DEFAULT_DURATION = 2352003;
    private static final int ID_DISPLAY_HEIGHT = 21690;
    private static final int ID_DISPLAY_UNIT = 21682;
    private static final int ID_DISPLAY_WIDTH = 21680;
    private static final int ID_DOC_TYPE = 17026;
    private static final int ID_DOC_TYPE_READ_VERSION = 17029;
    private static final int ID_DURATION = 17545;
    private static final int ID_EBML = 440786851;
    private static final int ID_EBML_READ_VERSION = 17143;
    private static final int ID_FLAG_DEFAULT = 136;
    private static final int ID_FLAG_FORCED = 21930;
    private static final int ID_INFO = 357149030;
    private static final int ID_LANGUAGE = 2274716;
    private static final int ID_LUMNINANCE_MAX = 21977;
    private static final int ID_LUMNINANCE_MIN = 21978;
    private static final int ID_MASTERING_METADATA = 21968;
    private static final int ID_MAX_BLOCK_ADDITION_ID = 21998;
    private static final int ID_MAX_CLL = 21948;
    private static final int ID_MAX_FALL = 21949;
    private static final int ID_NAME = 21358;
    private static final int ID_PIXEL_HEIGHT = 186;
    private static final int ID_PIXEL_WIDTH = 176;
    private static final int ID_PRIMARY_B_CHROMATICITY_X = 21973;
    private static final int ID_PRIMARY_B_CHROMATICITY_Y = 21974;
    private static final int ID_PRIMARY_G_CHROMATICITY_X = 21971;
    private static final int ID_PRIMARY_G_CHROMATICITY_Y = 21972;
    private static final int ID_PRIMARY_R_CHROMATICITY_X = 21969;
    private static final int ID_PRIMARY_R_CHROMATICITY_Y = 21970;
    private static final int ID_PROJECTION = 30320;
    private static final int ID_PROJECTION_POSE_PITCH = 30324;
    private static final int ID_PROJECTION_POSE_ROLL = 30325;
    private static final int ID_PROJECTION_POSE_YAW = 30323;
    private static final int ID_PROJECTION_PRIVATE = 30322;
    private static final int ID_PROJECTION_TYPE = 30321;
    private static final int ID_REFERENCE_BLOCK = 251;
    private static final int ID_SAMPLING_FREQUENCY = 181;
    private static final int ID_SEEK = 19899;
    private static final int ID_SEEK_HEAD = 290298740;
    private static final int ID_SEEK_ID = 21419;
    private static final int ID_SEEK_POSITION = 21420;
    private static final int ID_SEEK_PRE_ROLL = 22203;
    private static final int ID_SEGMENT = 408125543;
    private static final int ID_SEGMENT_INFO = 357149030;
    private static final int ID_SIMPLE_BLOCK = 163;
    private static final int ID_STEREO_MODE = 21432;
    private static final int ID_TIMECODE_SCALE = 2807729;
    private static final int ID_TIME_CODE = 231;
    private static final int ID_TRACKS = 374648427;
    private static final int ID_TRACK_ENTRY = 174;
    private static final int ID_TRACK_NUMBER = 215;
    private static final int ID_TRACK_TYPE = 131;
    private static final int ID_VIDEO = 224;
    private static final int ID_WHITE_POINT_CHROMATICITY_X = 21975;
    private static final int ID_WHITE_POINT_CHROMATICITY_Y = 21976;
    private static final int LACING_EBML = 3;
    private static final int LACING_FIXED_SIZE = 2;
    private static final int LACING_NONE = 0;
    private static final int LACING_XIPH = 1;
    private static final int OPUS_MAX_INPUT_SIZE = 5760;
    private static final byte[] SSA_DIALOGUE_FORMAT;
    private static final byte[] SSA_PREFIX;
    private static final int SSA_PREFIX_END_TIMECODE_OFFSET = 21;
    private static final String SSA_TIMECODE_FORMAT = "%01d:%02d:%02d:%02d";
    private static final long SSA_TIMECODE_LAST_VALUE_SCALING_FACTOR = 10000L;
    private static final byte[] SUBRIP_PREFIX;
    private static final int SUBRIP_PREFIX_END_TIMECODE_OFFSET = 19;
    private static final String SUBRIP_TIMECODE_FORMAT = "%02d:%02d:%02d,%03d";
    private static final long SUBRIP_TIMECODE_LAST_VALUE_SCALING_FACTOR = 1000L;
    private static final String TAG = "MatroskaExtractor";
    private static final Map<String, Integer> TRACK_NAME_TO_ROTATION_DEGREES;
    private static final int TRACK_TYPE_AUDIO = 2;
    private static final int UNSET_ENTRY_ID = -1;
    private static final int VORBIS_MAX_INPUT_SIZE = 8192;
    private static final int WAVE_FORMAT_EXTENSIBLE = 65534;
    private static final int WAVE_FORMAT_PCM = 1;
    private static final int WAVE_FORMAT_SIZE = 18;
    private static final UUID WAVE_SUBFORMAT_PCM;
    private final ParsableByteArray blockAdditionalData;
    private int blockAdditionalId;
    private long blockDurationUs;
    private int blockFlags;
    private boolean blockHasReferenceBlock;
    private int blockSampleCount;
    private int blockSampleIndex;
    private int[] blockSampleSizes;
    private int blockState;
    private long blockTimeUs;
    private int blockTrackNumber;
    private int blockTrackNumberLength;
    private long clusterTimecodeUs = -9223372036854775807L;
    private LongArray cueClusterPositions;
    private LongArray cueTimesUs;
    private long cuesContentPosition = -1L;
    private Track currentTrack;
    private long durationTimecode = -9223372036854775807L;
    private long durationUs = -9223372036854775807L;
    private final ParsableByteArray encryptionInitializationVector;
    private final ParsableByteArray encryptionSubsampleData;
    private ByteBuffer encryptionSubsampleDataBuffer;
    private ExtractorOutput extractorOutput;
    private boolean haveOutputSample;
    private final ParsableByteArray nalLength;
    private final ParsableByteArray nalStartCode;
    private final EbmlReader reader;
    private int sampleBytesRead;
    private int sampleBytesWritten;
    private int sampleCurrentNalBytesRemaining;
    private boolean sampleEncodingHandled;
    private boolean sampleInitializationVectorRead;
    private int samplePartitionCount;
    private boolean samplePartitionCountRead;
    private byte sampleSignalByte;
    private boolean sampleSignalByteRead;
    private final ParsableByteArray sampleStrippedBytes;
    private final ParsableByteArray scratch;
    private int seekEntryId;
    private final ParsableByteArray seekEntryIdBytes;
    private long seekEntryPosition;
    private boolean seekForCues;
    private final boolean seekForCuesEnabled;
    private long seekPositionAfterBuildingCues = -1L;
    private boolean seenClusterPositionForCurrentCuePoint;
    private long segmentContentPosition = -1L;
    private long segmentContentSize;
    private boolean sentSeekMap;
    private final ParsableByteArray subtitleSample;
    private long timecodeScale = -9223372036854775807L;
    private final SparseArray<Track> tracks;
    private final VarintReader varintReader;
    private final ParsableByteArray vorbisNumPageSamples;

    static {
        SUBRIP_PREFIX = new byte[]{49, 10, 48, 48, 58, 48, 48, 58, 48, 48, 44, 48, 48, 48, 32, 45, 45, 62, 32, 48, 48, 58, 48, 48, 58, 48, 48, 44, 48, 48, 48, 10};
        SSA_DIALOGUE_FORMAT = Util.getUtf8Bytes("Format: Start, End, ReadOrder, Layer, Style, Name, MarginL, MarginR, MarginV, Effect, Text");
        SSA_PREFIX = new byte[]{68, 105, 97, 108, 111, 103, 117, 101, 58, 32, 48, 58, 48, 48, 58, 48, 48, 58, 48, 48, 44, 48, 58, 48, 48, 58, 48, 48, 58, 48, 48, 44};
        WAVE_SUBFORMAT_PCM = new UUID(0x100000000001000L, -9223371306706625679L);
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("htc_video_rotA-000", 0);
        hashMap.put("htc_video_rotA-090", 90);
        hashMap.put("htc_video_rotA-180", 180);
        hashMap.put("htc_video_rotA-270", 270);
        TRACK_NAME_TO_ROTATION_DEGREES = Collections.unmodifiableMap(hashMap);
    }

    public MatroskaExtractor() {
        this(0);
    }

    public MatroskaExtractor(int n2) {
        this(new DefaultEbmlReader(), n2);
    }

    MatroskaExtractor(EbmlReader ebmlReader, int n2) {
        this.reader = ebmlReader;
        this.reader.init(new InnerEbmlProcessor());
        boolean bl = (n2 & 1) == 0;
        this.seekForCuesEnabled = bl;
        this.varintReader = new VarintReader();
        this.tracks = new SparseArray();
        this.scratch = new ParsableByteArray(4);
        this.vorbisNumPageSamples = new ParsableByteArray(ByteBuffer.allocate(4).putInt(-1).array());
        this.seekEntryIdBytes = new ParsableByteArray(4);
        this.nalStartCode = new ParsableByteArray(NalUnitUtil.NAL_START_CODE);
        this.nalLength = new ParsableByteArray(4);
        this.sampleStrippedBytes = new ParsableByteArray();
        this.subtitleSample = new ParsableByteArray();
        this.encryptionInitializationVector = new ParsableByteArray(8);
        this.encryptionSubsampleData = new ParsableByteArray();
        this.blockAdditionalData = new ParsableByteArray();
        this.blockSampleSizes = new int[1];
    }

    static /* synthetic */ byte[] access$500() {
        return SSA_DIALOGUE_FORMAT;
    }

    static /* synthetic */ Map access$600() {
        return TRACK_NAME_TO_ROTATION_DEGREES;
    }

    @EnsuresNonNull(value={"cueTimesUs", "cueClusterPositions"})
    private void assertInCues(int n2) throws ParserException {
        if (this.cueTimesUs != null && this.cueClusterPositions != null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Element ");
        stringBuilder.append(n2);
        stringBuilder.append(" must be in a Cues");
        throw new ParserException(stringBuilder.toString());
    }

    @EnsuresNonNull(value={"currentTrack"})
    private void assertInTrackEntry(int n2) throws ParserException {
        if (this.currentTrack != null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Element ");
        stringBuilder.append(n2);
        stringBuilder.append(" must be in a TrackEntry");
        throw new ParserException(stringBuilder.toString());
    }

    @EnsuresNonNull(value={"extractorOutput"})
    private void assertInitialized() {
        Assertions.checkStateNotNull(this.extractorOutput);
    }

    private SeekMap buildSeekMap(LongArray object, LongArray object2) {
        if (this.segmentContentPosition != -1L && this.durationUs != -9223372036854775807L && object != null && object.size() != 0 && object2 != null && object2.size() == object.size()) {
            int n2;
            int n3 = object.size();
            int[] nArray = new int[n3];
            long[] lArray = new long[n3];
            long[] lArray2 = new long[n3];
            long[] lArray3 = new long[n3];
            int n4 = 0;
            int n5 = 0;
            while (true) {
                n2 = n4;
                if (n5 >= n3) break;
                lArray3[n5] = object.get(n5);
                lArray[n5] = this.segmentContentPosition + object2.get(n5);
                ++n5;
            }
            while (n2 < (n5 = n3 - 1)) {
                n5 = n2 + 1;
                nArray[n2] = (int)(lArray[n5] - lArray[n2]);
                lArray2[n2] = lArray3[n5] - lArray3[n2];
                n2 = n5;
            }
            nArray[n5] = (int)(this.segmentContentPosition + this.segmentContentSize - lArray[n5]);
            lArray2[n5] = this.durationUs - lArray3[n5];
            long l2 = lArray2[n5];
            int[] nArray2 = nArray;
            long[] lArray4 = lArray;
            object2 = lArray2;
            object = lArray3;
            if (l2 <= 0L) {
                object = new StringBuilder();
                object.append("Discarding last cue point with unexpected duration: ");
                object.append(l2);
                Log.w(TAG, object.toString());
                nArray2 = Arrays.copyOf(nArray, nArray.length - 1);
                lArray4 = Arrays.copyOf(lArray, lArray.length - 1);
                object2 = Arrays.copyOf(lArray2, lArray2.length - 1);
                object = Arrays.copyOf(lArray3, lArray3.length - 1);
            }
            return new ChunkIndex(nArray2, lArray4, (long[])object2, (long[])object);
        }
        return new SeekMap.Unseekable(this.durationUs);
    }

    @RequiresNonNull(value={"#1.output"})
    private void commitSampleToOutput(Track track, long l2, int n2, int n3, int n4) {
        block12: {
            int n5;
            block14: {
                block13: {
                    block11: {
                        if (track.trueHdSampleRechunker == null) break block11;
                        track.trueHdSampleRechunker.sampleMetadata(track, l2, n2, n3, n4);
                        break block12;
                    }
                    if (CODEC_ID_SUBRIP.equals(track.codecId)) break block13;
                    n5 = n3;
                    if (!CODEC_ID_ASS.equals(track.codecId)) break block14;
                }
                if (this.blockSampleCount > 1) {
                    Log.w(TAG, "Skipping subtitle sample in laced block.");
                    n5 = n3;
                } else if (this.blockDurationUs == -9223372036854775807L) {
                    Log.w(TAG, "Skipping subtitle sample with no duration.");
                    n5 = n3;
                } else {
                    MatroskaExtractor.setSubtitleEndTime(track.codecId, this.blockDurationUs, this.subtitleSample.getData());
                    for (n5 = this.subtitleSample.getPosition(); n5 < this.subtitleSample.limit(); ++n5) {
                        if (this.subtitleSample.getData()[n5] != 0) continue;
                        this.subtitleSample.setLimit(n5);
                        break;
                    }
                    TrackOutput trackOutput = track.output;
                    ParsableByteArray parsableByteArray = this.subtitleSample;
                    trackOutput.sampleData(parsableByteArray, parsableByteArray.limit());
                    n5 = n3 + this.subtitleSample.limit();
                }
            }
            n3 = n2;
            int n6 = n5;
            if ((0x10000000 & n2) != 0) {
                if (this.blockSampleCount > 1) {
                    n3 = n2 & 0xEFFFFFFF;
                    n6 = n5;
                } else {
                    n3 = this.blockAdditionalData.limit();
                    track.output.sampleData(this.blockAdditionalData, n3, 2);
                    n6 = n5 + n3;
                    n3 = n2;
                }
            }
            track.output.sampleMetadata(l2, n3, n6, n4, track.cryptoData);
        }
        this.haveOutputSample = true;
    }

    private static int[] ensureArrayCapacity(int[] nArray, int n2) {
        if (nArray == null) {
            return new int[n2];
        }
        if (nArray.length >= n2) {
            return nArray;
        }
        return new int[Math.max(nArray.length * 2, n2)];
    }

    private int finishWriteSampleData() {
        int n2 = this.sampleBytesWritten;
        this.resetWriteSampleData();
        return n2;
    }

    private static byte[] formatSubtitleTimecode(long l2, String string2, long l3) {
        boolean bl = l2 != -9223372036854775807L;
        Assertions.checkArgument(bl);
        int n2 = (int)(l2 / 3600000000L);
        int n3 = (int)((l2 -= (long)(n2 * 3600) * 1000000L) / 60000000L);
        int n4 = (int)((l2 -= (long)(n3 * 60) * 1000000L) / 1000000L);
        int n5 = (int)((l2 - (long)n4 * 1000000L) / l3);
        return Util.getUtf8Bytes(String.format(Locale.US, string2, n2, n3, n4, n5));
    }

    private Track getCurrentTrack(int n2) throws ParserException {
        this.assertInTrackEntry(n2);
        return this.currentTrack;
    }

    private static boolean isCodecSupported(String string2) {
        int n2;
        block37: {
            switch (string2.hashCode()) {
                default: {
                    break;
                }
                case 1951062397: {
                    if (!string2.equals(CODEC_ID_OPUS)) break;
                    n2 = 11;
                    break block37;
                }
                case 1950789798: {
                    if (!string2.equals(CODEC_ID_FLAC)) break;
                    n2 = 22;
                    break block37;
                }
                case 1950749482: {
                    if (!string2.equals(CODEC_ID_E_AC3)) break;
                    n2 = 17;
                    break block37;
                }
                case 1809237540: {
                    if (!string2.equals(CODEC_ID_MPEG2)) break;
                    n2 = 3;
                    break block37;
                }
                case 1422270023: {
                    if (!string2.equals(CODEC_ID_SUBRIP)) break;
                    n2 = 27;
                    break block37;
                }
                case 855502857: {
                    if (!string2.equals(CODEC_ID_H265)) break;
                    n2 = 8;
                    break block37;
                }
                case 738597099: {
                    if (!string2.equals(CODEC_ID_ASS)) break;
                    n2 = 28;
                    break block37;
                }
                case 725957860: {
                    if (!string2.equals(CODEC_ID_PCM_INT_LIT)) break;
                    n2 = 24;
                    break block37;
                }
                case 725948237: {
                    if (!string2.equals(CODEC_ID_PCM_INT_BIG)) break;
                    n2 = 25;
                    break block37;
                }
                case 635596514: {
                    if (!string2.equals(CODEC_ID_PCM_FLOAT)) break;
                    n2 = 26;
                    break block37;
                }
                case 542569478: {
                    if (!string2.equals(CODEC_ID_DTS_EXPRESS)) break;
                    n2 = 20;
                    break block37;
                }
                case 444813526: {
                    if (!string2.equals(CODEC_ID_THEORA)) break;
                    n2 = 10;
                    break block37;
                }
                case 99146302: {
                    if (!string2.equals(CODEC_ID_PGS)) break;
                    n2 = 30;
                    break block37;
                }
                case 82338134: {
                    if (!string2.equals(CODEC_ID_VP9)) break;
                    n2 = 1;
                    break block37;
                }
                case 82338133: {
                    if (!string2.equals(CODEC_ID_VP8)) break;
                    n2 = 0;
                    break block37;
                }
                case 82318131: {
                    if (!string2.equals(CODEC_ID_AV1)) break;
                    n2 = 2;
                    break block37;
                }
                case 62927045: {
                    if (!string2.equals(CODEC_ID_DTS)) break;
                    n2 = 19;
                    break block37;
                }
                case 62923603: {
                    if (!string2.equals(CODEC_ID_AC3)) break;
                    n2 = 16;
                    break block37;
                }
                case 62923557: {
                    if (!string2.equals(CODEC_ID_AAC)) break;
                    n2 = 13;
                    break block37;
                }
                case -356037306: {
                    if (!string2.equals(CODEC_ID_DTS_LOSSLESS)) break;
                    n2 = 21;
                    break block37;
                }
                case -425012669: {
                    if (!string2.equals(CODEC_ID_VOBSUB)) break;
                    n2 = 29;
                    break block37;
                }
                case -538363109: {
                    if (!string2.equals(CODEC_ID_H264)) break;
                    n2 = 7;
                    break block37;
                }
                case -538363189: {
                    if (!string2.equals(CODEC_ID_MPEG4_ASP)) break;
                    n2 = 5;
                    break block37;
                }
                case -933872740: {
                    if (!string2.equals(CODEC_ID_DVBSUB)) break;
                    n2 = 31;
                    break block37;
                }
                case -1373388978: {
                    if (!string2.equals(CODEC_ID_FOURCC)) break;
                    n2 = 9;
                    break block37;
                }
                case -1482641357: {
                    if (!string2.equals(CODEC_ID_MP3)) break;
                    n2 = 15;
                    break block37;
                }
                case -1482641358: {
                    if (!string2.equals(CODEC_ID_MP2)) break;
                    n2 = 14;
                    break block37;
                }
                case -1730367663: {
                    if (!string2.equals(CODEC_ID_VORBIS)) break;
                    n2 = 12;
                    break block37;
                }
                case -1784763192: {
                    if (!string2.equals(CODEC_ID_TRUEHD)) break;
                    n2 = 18;
                    break block37;
                }
                case -1985379776: {
                    if (!string2.equals(CODEC_ID_ACM)) break;
                    n2 = 23;
                    break block37;
                }
                case -2095575984: {
                    if (!string2.equals(CODEC_ID_MPEG4_SP)) break;
                    n2 = 4;
                    break block37;
                }
                case -2095576542: {
                    if (!string2.equals(CODEC_ID_MPEG4_AP)) break;
                    n2 = 6;
                    break block37;
                }
            }
            n2 = -1;
        }
        switch (n2) {
            default: {
                return false;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
        }
        return true;
    }

    static /* synthetic */ Extractor[] lambda$static$0() {
        return new Extractor[]{new MatroskaExtractor()};
    }

    private boolean maybeSeekForCues(PositionHolder positionHolder, long l2) {
        if (this.seekForCues) {
            this.seekPositionAfterBuildingCues = l2;
            positionHolder.position = this.cuesContentPosition;
            this.seekForCues = false;
            return true;
        }
        if (this.sentSeekMap && (l2 = this.seekPositionAfterBuildingCues) != -1L) {
            positionHolder.position = l2;
            this.seekPositionAfterBuildingCues = -1L;
            return true;
        }
        return false;
    }

    private void readScratch(ExtractorInput extractorInput, int n2) throws IOException {
        if (this.scratch.limit() >= n2) {
            return;
        }
        if (this.scratch.capacity() < n2) {
            ParsableByteArray parsableByteArray = this.scratch;
            parsableByteArray.ensureCapacity(Math.max(parsableByteArray.capacity() * 2, n2));
        }
        extractorInput.readFully(this.scratch.getData(), this.scratch.limit(), n2 - this.scratch.limit());
        this.scratch.setLimit(n2);
    }

    private void resetWriteSampleData() {
        this.sampleBytesRead = 0;
        this.sampleBytesWritten = 0;
        this.sampleCurrentNalBytesRemaining = 0;
        this.sampleEncodingHandled = false;
        this.sampleSignalByteRead = false;
        this.samplePartitionCountRead = false;
        this.samplePartitionCount = 0;
        this.sampleSignalByte = (byte)0;
        this.sampleInitializationVectorRead = false;
        this.sampleStrippedBytes.reset(0);
    }

    private long scaleTimecodeToUs(long l2) throws ParserException {
        long l3 = this.timecodeScale;
        if (l3 != -9223372036854775807L) {
            return Util.scaleLargeTimestamp(l2, l3, 1000L);
        }
        throw new ParserException("Can't scale timecode prior to timecodeScale being set.");
    }

    /*
     * Unable to fully structure code
     */
    private static void setSubtitleEndTime(String var0, long var1_1, byte[] var3_2) {
        block5: {
            block4: {
                var4_3 = var0.hashCode();
                if (var4_3 == 738597099) break block4;
                if (var4_3 != 1422270023 || !var0.equals("S_TEXT/UTF8")) ** GOTO lbl-1000
                var4_3 = 0;
                break block5;
            }
            if (var0.equals("S_TEXT/ASS")) {
                var4_3 = 1;
            } else lbl-1000:
            // 2 sources

            {
                var4_3 = -1;
            }
        }
        if (var4_3 == 0) ** GOTO lbl18
        if (var4_3 == 1) {
            var0 = MatroskaExtractor.formatSubtitleTimecode(var1_1, "%01d:%02d:%02d:%02d", 10000L);
            var4_3 = 21;
        } else {
            throw new IllegalArgumentException();
lbl18:
            // 1 sources

            var0 = MatroskaExtractor.formatSubtitleTimecode(var1_1, "%02d:%02d:%02d,%03d", 1000L);
            var4_3 = 19;
        }
        System.arraycopy(var0, 0, var3_2, var4_3, ((Object)var0).length);
    }

    @RequiresNonNull(value={"#2.output"})
    private int writeSampleData(ExtractorInput extractorInput, Track track, int n2) throws IOException {
        int n3;
        Object object;
        int n4;
        int n5;
        if (CODEC_ID_SUBRIP.equals(track.codecId)) {
            this.writeSubtitleSampleData(extractorInput, SUBRIP_PREFIX, n2);
            return this.finishWriteSampleData();
        }
        if (CODEC_ID_ASS.equals(track.codecId)) {
            this.writeSubtitleSampleData(extractorInput, SSA_PREFIX, n2);
            return this.finishWriteSampleData();
        }
        TrackOutput trackOutput = track.output;
        boolean bl = this.sampleEncodingHandled;
        boolean bl2 = true;
        if (!bl) {
            if (track.hasContentEncryption) {
                this.blockFlags &= 0xBFFFFFFF;
                bl = this.sampleSignalByteRead;
                n5 = 128;
                if (!bl) {
                    extractorInput.readFully(this.scratch.getData(), 0, 1);
                    ++this.sampleBytesRead;
                    if ((this.scratch.getData()[0] & 0x80) != 128) {
                        this.sampleSignalByte = this.scratch.getData()[0];
                        this.sampleSignalByteRead = true;
                    } else {
                        throw new ParserException("Extension bit is set in signal byte");
                    }
                }
                if ((n4 = (this.sampleSignalByte & 1) == 1 ? 1 : 0) != 0) {
                    n4 = (this.sampleSignalByte & 2) == 2 ? 1 : 0;
                    this.blockFlags |= 0x40000000;
                    if (!this.sampleInitializationVectorRead) {
                        extractorInput.readFully(this.encryptionInitializationVector.getData(), 0, 8);
                        this.sampleBytesRead += 8;
                        this.sampleInitializationVectorRead = true;
                        object = this.scratch.getData();
                        if (n4 == 0) {
                            n5 = 0;
                        }
                        object[0] = (byte)(n5 | 8);
                        this.scratch.setPosition(0);
                        trackOutput.sampleData(this.scratch, 1, 1);
                        ++this.sampleBytesWritten;
                        this.encryptionInitializationVector.setPosition(0);
                        trackOutput.sampleData(this.encryptionInitializationVector, 8, 1);
                        this.sampleBytesWritten += 8;
                    }
                    if (n4 != 0) {
                        if (!this.samplePartitionCountRead) {
                            extractorInput.readFully(this.scratch.getData(), 0, 1);
                            ++this.sampleBytesRead;
                            this.scratch.setPosition(0);
                            this.samplePartitionCount = this.scratch.readUnsignedByte();
                            this.samplePartitionCountRead = true;
                        }
                        n4 = this.samplePartitionCount * 4;
                        this.scratch.reset(n4);
                        extractorInput.readFully(this.scratch.getData(), 0, n4);
                        this.sampleBytesRead += n4;
                        short s2 = (short)(this.samplePartitionCount / 2 + 1);
                        int n6 = s2 * 6 + 2;
                        object = this.encryptionSubsampleDataBuffer;
                        if (object == null || ((Buffer)object).capacity() < n6) {
                            this.encryptionSubsampleDataBuffer = ByteBuffer.allocate(n6);
                        }
                        this.encryptionSubsampleDataBuffer.position(0);
                        this.encryptionSubsampleDataBuffer.putShort(s2);
                        n5 = 0;
                        for (n4 = 0; n4 < (n3 = this.samplePartitionCount); ++n4) {
                            n3 = this.scratch.readUnsignedIntToInt();
                            if (n4 % 2 == 0) {
                                this.encryptionSubsampleDataBuffer.putShort((short)(n3 - n5));
                            } else {
                                this.encryptionSubsampleDataBuffer.putInt(n3 - n5);
                            }
                            n5 = n3;
                        }
                        n4 = n2 - this.sampleBytesRead - n5;
                        if (n3 % 2 == 1) {
                            this.encryptionSubsampleDataBuffer.putInt(n4);
                        } else {
                            this.encryptionSubsampleDataBuffer.putShort((short)n4);
                            this.encryptionSubsampleDataBuffer.putInt(0);
                        }
                        this.encryptionSubsampleData.reset(this.encryptionSubsampleDataBuffer.array(), n6);
                        trackOutput.sampleData(this.encryptionSubsampleData, n6, 1);
                        this.sampleBytesWritten += n6;
                    }
                }
            } else if (track.sampleStrippedBytes != null) {
                this.sampleStrippedBytes.reset(track.sampleStrippedBytes, track.sampleStrippedBytes.length);
            }
            if (track.maxBlockAdditionId > 0) {
                this.blockFlags |= 0x10000000;
                this.blockAdditionalData.reset(0);
                this.scratch.reset(4);
                this.scratch.getData()[0] = (byte)(n2 >> 24 & 0xFF);
                this.scratch.getData()[1] = (byte)(n2 >> 16 & 0xFF);
                this.scratch.getData()[2] = (byte)(n2 >> 8 & 0xFF);
                this.scratch.getData()[3] = (byte)(n2 & 0xFF);
                trackOutput.sampleData(this.scratch, 4, 2);
                this.sampleBytesWritten += 4;
            }
            this.sampleEncodingHandled = true;
        }
        n2 += this.sampleStrippedBytes.limit();
        if (!CODEC_ID_H264.equals(track.codecId) && !CODEC_ID_H265.equals(track.codecId)) {
            if (track.trueHdSampleRechunker != null) {
                if (this.sampleStrippedBytes.limit() != 0) {
                    bl2 = false;
                }
                Assertions.checkState(bl2);
                track.trueHdSampleRechunker.startSample(extractorInput);
            }
            while ((n4 = this.sampleBytesRead) < n2) {
                n4 = this.writeToOutput(extractorInput, trackOutput, n2 - n4);
                this.sampleBytesRead += n4;
                this.sampleBytesWritten += n4;
            }
        } else {
            object = this.nalLength.getData();
            object[0] = (byte)0;
            object[1] = (byte)0;
            object[2] = (byte)0;
            n4 = track.nalUnitLengthFieldLength;
            n5 = track.nalUnitLengthFieldLength;
            while (this.sampleBytesRead < n2) {
                n3 = this.sampleCurrentNalBytesRemaining;
                if (n3 == 0) {
                    this.writeToTarget(extractorInput, (byte[])object, 4 - n5, n4);
                    this.sampleBytesRead += n4;
                    this.nalLength.setPosition(0);
                    this.sampleCurrentNalBytesRemaining = this.nalLength.readUnsignedIntToInt();
                    this.nalStartCode.setPosition(0);
                    trackOutput.sampleData(this.nalStartCode, 4);
                    this.sampleBytesWritten += 4;
                    continue;
                }
                n3 = this.writeToOutput(extractorInput, trackOutput, n3);
                this.sampleBytesRead += n3;
                this.sampleBytesWritten += n3;
                this.sampleCurrentNalBytesRemaining -= n3;
            }
        }
        if (CODEC_ID_VORBIS.equals(track.codecId)) {
            this.vorbisNumPageSamples.setPosition(0);
            trackOutput.sampleData(this.vorbisNumPageSamples, 4);
            this.sampleBytesWritten += 4;
        }
        return this.finishWriteSampleData();
    }

    private void writeSubtitleSampleData(ExtractorInput extractorInput, byte[] byArray, int n2) throws IOException {
        int n3 = byArray.length + n2;
        if (this.subtitleSample.capacity() < n3) {
            this.subtitleSample.reset(Arrays.copyOf(byArray, n3 + n2));
        } else {
            System.arraycopy(byArray, 0, this.subtitleSample.getData(), 0, byArray.length);
        }
        extractorInput.readFully(this.subtitleSample.getData(), byArray.length, n2);
        this.subtitleSample.setPosition(0);
        this.subtitleSample.setLimit(n3);
    }

    private int writeToOutput(ExtractorInput extractorInput, TrackOutput trackOutput, int n2) throws IOException {
        int n3 = this.sampleStrippedBytes.bytesLeft();
        if (n3 > 0) {
            n2 = Math.min(n2, n3);
            trackOutput.sampleData(this.sampleStrippedBytes, n2);
        } else {
            n2 = trackOutput.sampleData((DataReader)extractorInput, n2, false);
        }
        return n2;
    }

    private void writeToTarget(ExtractorInput extractorInput, byte[] byArray, int n2, int n3) throws IOException {
        int n4 = Math.min(n3, this.sampleStrippedBytes.bytesLeft());
        extractorInput.readFully(byArray, n2 + n4, n3 - n4);
        if (n4 > 0) {
            this.sampleStrippedBytes.readBytes(byArray, n2, n4);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected void binaryElement(int var1_1, int var2_2, ExtractorInput var3_3) throws IOException {
        block33: {
            block27: {
                block28: {
                    block29: {
                        block30: {
                            block31: {
                                block32: {
                                    var4_4 = 4;
                                    if (var1_1 == 161 || var1_1 == 163) break block27;
                                    if (var1_1 == 165) break block28;
                                    if (var1_1 == 16877) break block29;
                                    if (var1_1 == 16981) break block30;
                                    if (var1_1 == 18402) break block31;
                                    if (var1_1 == 21419) break block32;
                                    if (var1_1 == 25506) ** GOTO lbl21
                                    if (var1_1 == 30322) {
                                        this.assertInTrackEntry(var1_1);
                                        var5_5 = this.currentTrack;
                                        var5_5.projectionData = new byte[var2_2];
                                        var3_3.readFully(var5_5.projectionData, 0, var2_2);
                                    } else {
                                        var3_3 = new StringBuilder();
                                        var3_3.append("Unexpected id: ");
                                        var3_3.append(var1_1);
                                        throw new ParserException(var3_3.toString());
lbl21:
                                        // 1 sources

                                        this.assertInTrackEntry(var1_1);
                                        var5_6 = this.currentTrack;
                                        var5_6.codecPrivate = new byte[var2_2];
                                        var3_3.readFully(var5_6.codecPrivate, 0, var2_2);
                                    }
                                    break block33;
                                }
                                Arrays.fill(this.seekEntryIdBytes.getData(), (byte)0);
                                var3_3.readFully(this.seekEntryIdBytes.getData(), 4 - var2_2, var2_2);
                                this.seekEntryIdBytes.setPosition(0);
                                this.seekEntryId = (int)this.seekEntryIdBytes.readUnsignedInt();
                                break block33;
                            }
                            var5_7 = new byte[var2_2];
                            var3_3.readFully(var5_7, 0, var2_2);
                            this.getCurrentTrack((int)var1_1).cryptoData = new TrackOutput.CryptoData(1, var5_7, 0, 0);
                            break block33;
                        }
                        this.assertInTrackEntry(var1_1);
                        var5_8 = this.currentTrack;
                        var5_8.sampleStrippedBytes = new byte[var2_2];
                        var3_3.readFully(var5_8.sampleStrippedBytes, 0, var2_2);
                        break block33;
                    }
                    this.handleBlockAddIDExtraData(this.getCurrentTrack(var1_1), (ExtractorInput)var3_3, var2_2);
                    break block33;
                }
                if (this.blockState != 2) {
                    return;
                }
                this.handleBlockAdditionalData((Track)this.tracks.get(this.blockTrackNumber), this.blockAdditionalId, (ExtractorInput)var3_3, var2_2);
                break block33;
            }
            if (this.blockState == 0) {
                this.blockTrackNumber = (int)this.varintReader.readUnsignedVarint((ExtractorInput)var3_3, false, true, 8);
                this.blockTrackNumberLength = this.varintReader.getLastLength();
                this.blockDurationUs = -9223372036854775807L;
                this.blockState = 1;
                this.scratch.reset(0);
            }
            if ((var5_9 = (Track)this.tracks.get(this.blockTrackNumber)) == null) {
                var3_3.skipFully(var2_2 - this.blockTrackNumberLength);
                this.blockState = 0;
                return;
            }
            Track.access$100(var5_9);
            if (this.blockState == 1) {
                this.readScratch((ExtractorInput)var3_3, 3);
                var6_10 = (this.scratch.getData()[2] & 6) >> 1;
                if (var6_10 == 0) {
                    this.blockSampleCount = 1;
                    this.blockSampleSizes = MatroskaExtractor.ensureArrayCapacity(this.blockSampleSizes, 1);
                    this.blockSampleSizes[0] = var2_2 - this.blockTrackNumberLength - 3;
                } else {
                    this.readScratch((ExtractorInput)var3_3, 4);
                    this.blockSampleCount = (this.scratch.getData()[3] & 255) + 1;
                    this.blockSampleSizes = MatroskaExtractor.ensureArrayCapacity(this.blockSampleSizes, this.blockSampleCount);
                    if (var6_10 == 2) {
                        var6_10 = this.blockTrackNumberLength;
                        var4_4 = this.blockSampleCount;
                        var2_2 = (var2_2 - var6_10 - 4) / var4_4;
                        Arrays.fill(this.blockSampleSizes, 0, var4_4, var2_2);
                    } else if (var6_10 == 1) {
                        var6_10 = 0;
                        for (var7_11 = 0; var7_11 < (var8_12 = this.blockSampleCount) - 1; ++var7_11) {
                            this.blockSampleSizes[var7_11] = 0;
                            var8_12 = var4_4;
                            do {
                                var4_4 = var8_12 + 1;
                                this.readScratch((ExtractorInput)var3_3, var4_4);
                                var9_13 = this.scratch.getData()[var4_4 - 1] & 255;
                                var10_14 /* !! */  = this.blockSampleSizes;
                                var10_14 /* !! */ [var7_11] = var10_14 /* !! */ [var7_11] + var9_13;
                                var8_12 = var4_4;
                            } while (var9_13 == 255);
                            var6_10 += var10_14 /* !! */ [var7_11];
                        }
                        this.blockSampleSizes[var8_12 - 1] = var2_2 - this.blockTrackNumberLength - var4_4 - var6_10;
                    } else {
                        if (var6_10 != 3) {
                            var3_3 = new StringBuilder();
                            var3_3.append("Unexpected lacing value: ");
                            var3_3.append(var6_10);
                            throw new ParserException(var3_3.toString());
                        }
                        var6_10 = 0;
                        for (var7_11 = 0; var7_11 < (var8_12 = this.blockSampleCount) - 1; ++var7_11) {
                            this.blockSampleSizes[var7_11] = 0;
                            var9_13 = var4_4 + 1;
                            this.readScratch((ExtractorInput)var3_3, var9_13);
                            var10_14 /* !! */  = this.scratch.getData();
                            var11_15 = var9_13 - 1;
                            if (var10_14 /* !! */ [var11_15] != 0) {
                                var12_16 = 0L;
                                var8_12 = 0;
                                while (true) {
                                    var4_4 = var9_13;
                                    var14_17 = var12_16;
                                    if (var8_12 >= 8) break;
                                    var4_4 = 1 << 7 - var8_12;
                                    if ((this.scratch.getData()[var11_15] & var4_4) != 0) {
                                        this.readScratch((ExtractorInput)var3_3, var9_13 += var8_12);
                                        var12_16 = this.scratch.getData()[var11_15] & 255 & ~var4_4;
                                        for (var4_4 = var11_15 + 1; var4_4 < var9_13; ++var4_4) {
                                            var14_17 = this.scratch.getData()[var4_4] & 255;
                                            var12_16 = var14_17 | var12_16 << 8;
                                        }
                                        var4_4 = var9_13;
                                        var14_17 = var12_16;
                                        if (var7_11 <= 0) break;
                                        var14_17 = var12_16 - ((1L << var8_12 * 7 + 6) - 1L);
                                        var4_4 = var9_13;
                                        break;
                                    }
                                    ++var8_12;
                                }
                                if (var14_17 >= -2147483648L && var14_17 <= 0x7FFFFFFFL) {
                                    var8_12 = (int)var14_17;
                                    var10_14 /* !! */  = this.blockSampleSizes;
                                    if (var7_11 != 0) {
                                        var8_12 += var10_14 /* !! */ [var7_11 - 1];
                                    }
                                    var10_14 /* !! */ [var7_11] = var8_12;
                                    var6_10 += this.blockSampleSizes[var7_11];
                                    continue;
                                }
                                throw new ParserException("EBML lacing sample size out of range.");
                            }
                            throw new ParserException("No valid varint length mask found");
                        }
                        this.blockSampleSizes[var8_12 - 1] = var2_2 - this.blockTrackNumberLength - var4_4 - var6_10;
                    }
                }
                var2_2 = this.scratch.getData()[0];
                var4_4 = this.scratch.getData()[1];
                this.blockTimeUs = this.clusterTimecodeUs + this.scaleTimecodeToUs(var2_2 << 8 | var4_4 & 255);
                var2_2 = var5_9.type != 2 && (var1_1 != 163 || (this.scratch.getData()[2] & 128) != 128) ? 0 : 1;
                this.blockFlags = var2_2;
                this.blockState = 2;
                this.blockSampleIndex = 0;
            }
            if (var1_1 == 163) {
                while ((var1_1 = this.blockSampleIndex) < this.blockSampleCount) {
                    var1_1 = this.writeSampleData((ExtractorInput)var3_3, var5_9, this.blockSampleSizes[var1_1]);
                    var14_17 = this.blockTimeUs;
                    this.commitSampleToOutput(var5_9, (long)(this.blockSampleIndex * var5_9.defaultSampleDurationNs / 1000) + var14_17, this.blockFlags, var1_1, 0);
                    ++this.blockSampleIndex;
                }
                this.blockState = 0;
            } else {
                while ((var1_1 = this.blockSampleIndex++) < this.blockSampleCount) {
                    var10_14 /* !! */  = this.blockSampleSizes;
                    var10_14 /* !! */ [var1_1] = this.writeSampleData((ExtractorInput)var3_3, var5_9, var10_14 /* !! */ [var1_1]);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void endMasterElement(int n2) throws ParserException {
        int n3;
        this.assertInitialized();
        if (n2 != 160) {
            if (n2 != 174) {
                long l2;
                if (n2 == 19899) {
                    n2 = this.seekEntryId;
                    if (n2 == -1) throw new ParserException("Mandatory element SeekID or SeekPosition not found");
                    long l3 = this.seekEntryPosition;
                    if (l3 == -1L) throw new ParserException("Mandatory element SeekID or SeekPosition not found");
                    if (n2 != 475249515) return;
                    this.cuesContentPosition = l3;
                    return;
                }
                if (n2 == 25152) {
                    this.assertInTrackEntry(n2);
                    if (!this.currentTrack.hasContentEncryption) return;
                    if (this.currentTrack.cryptoData == null) throw new ParserException("Encrypted Track found but ContentEncKeyID was not found");
                    this.currentTrack.drmInitData = new DrmInitData(new DrmInitData.SchemeData[]{new DrmInitData.SchemeData(C.UUID_NIL, "video/webm", this.currentTrack.cryptoData.encryptionKey)});
                    return;
                }
                if (n2 == 28032) {
                    this.assertInTrackEntry(n2);
                    if (!this.currentTrack.hasContentEncryption) return;
                    if (this.currentTrack.sampleStrippedBytes != null) throw new ParserException("Combining encryption and compression is not supported");
                    return;
                }
                if (n2 != 357149030) {
                    if (n2 == 374648427) {
                        if (this.tracks.size() == 0) throw new ParserException("No valid tracks were found");
                        this.extractorOutput.endTracks();
                        return;
                    }
                    if (n2 != 475249515) {
                        return;
                    }
                    if (!this.sentSeekMap) {
                        this.extractorOutput.seekMap(this.buildSeekMap(this.cueTimesUs, this.cueClusterPositions));
                        this.sentSeekMap = true;
                    }
                    this.cueTimesUs = null;
                    this.cueClusterPositions = null;
                    return;
                }
                if (this.timecodeScale == -9223372036854775807L) {
                    this.timecodeScale = 1000000L;
                }
                if ((l2 = this.durationTimecode) == -9223372036854775807L) return;
                this.durationUs = this.scaleTimecodeToUs(l2);
                return;
            }
            Track track = Assertions.checkStateNotNull(this.currentTrack);
            if (track.codecId == null) throw new ParserException("CodecId is missing in TrackEntry element");
            if (MatroskaExtractor.isCodecSupported(track.codecId)) {
                track.initializeOutput(this.extractorOutput, track.number);
                this.tracks.put(track.number, (Object)track);
            }
            this.currentTrack = null;
            return;
        }
        if (this.blockState != 2) {
            return;
        }
        n2 = 0;
        for (n3 = 0; n3 < this.blockSampleCount; n2 += this.blockSampleSizes[n3], ++n3) {
        }
        Track track = (Track)this.tracks.get(this.blockTrackNumber);
        track.assertOutputInitialized();
        int n4 = 0;
        n3 = n2;
        n2 = n4;
        while (true) {
            int n5;
            if (n2 >= this.blockSampleCount) {
                this.blockState = 0;
                return;
            }
            long l4 = this.blockTimeUs;
            long l5 = track.defaultSampleDurationNs * n2 / 1000;
            n4 = n5 = this.blockFlags;
            if (n2 == 0) {
                n4 = n5;
                if (!this.blockHasReferenceBlock) {
                    n4 = n5 | 1;
                }
            }
            n5 = this.blockSampleSizes[n2];
            this.commitSampleToOutput(track, l5 + l4, n4, n5, n3 -= n5);
            ++n2;
        }
    }

    protected void floatElement(int n2, double d2) throws ParserException {
        if (n2 != 181) {
            if (n2 != 17545) {
                block0 : switch (n2) {
                    default: {
                        switch (n2) {
                            default: {
                                break block0;
                            }
                            case 30325: {
                                this.getCurrentTrack((int)n2).projectionPoseRoll = (float)d2;
                                break block0;
                            }
                            case 30324: {
                                this.getCurrentTrack((int)n2).projectionPosePitch = (float)d2;
                                break block0;
                            }
                            case 30323: 
                        }
                        this.getCurrentTrack((int)n2).projectionPoseYaw = (float)d2;
                        break;
                    }
                    case 21978: {
                        this.getCurrentTrack((int)n2).minMasteringLuminance = (float)d2;
                        break;
                    }
                    case 21977: {
                        this.getCurrentTrack((int)n2).maxMasteringLuminance = (float)d2;
                        break;
                    }
                    case 21976: {
                        this.getCurrentTrack((int)n2).whitePointChromaticityY = (float)d2;
                        break;
                    }
                    case 21975: {
                        this.getCurrentTrack((int)n2).whitePointChromaticityX = (float)d2;
                        break;
                    }
                    case 21974: {
                        this.getCurrentTrack((int)n2).primaryBChromaticityY = (float)d2;
                        break;
                    }
                    case 21973: {
                        this.getCurrentTrack((int)n2).primaryBChromaticityX = (float)d2;
                        break;
                    }
                    case 21972: {
                        this.getCurrentTrack((int)n2).primaryGChromaticityY = (float)d2;
                        break;
                    }
                    case 21971: {
                        this.getCurrentTrack((int)n2).primaryGChromaticityX = (float)d2;
                        break;
                    }
                    case 21970: {
                        this.getCurrentTrack((int)n2).primaryRChromaticityY = (float)d2;
                        break;
                    }
                    case 21969: {
                        this.getCurrentTrack((int)n2).primaryRChromaticityX = (float)d2;
                        break;
                    }
                }
            } else {
                this.durationTimecode = (long)d2;
            }
        } else {
            this.getCurrentTrack((int)n2).sampleRate = (int)d2;
        }
    }

    protected int getElementType(int n2) {
        switch (n2) {
            default: {
                return 0;
            }
            case 181: 
            case 17545: 
            case 21969: 
            case 21970: 
            case 21971: 
            case 21972: 
            case 21973: 
            case 21974: 
            case 21975: 
            case 21976: 
            case 21977: 
            case 21978: 
            case 30323: 
            case 30324: 
            case 30325: {
                return 5;
            }
            case 161: 
            case 163: 
            case 165: 
            case 16877: 
            case 16981: 
            case 18402: 
            case 21419: 
            case 25506: 
            case 30322: {
                return 4;
            }
            case 160: 
            case 166: 
            case 174: 
            case 183: 
            case 187: 
            case 224: 
            case 225: 
            case 16868: 
            case 18407: 
            case 19899: 
            case 20532: 
            case 20533: 
            case 21936: 
            case 21968: 
            case 25152: 
            case 28032: 
            case 30113: 
            case 30320: 
            case 290298740: 
            case 357149030: 
            case 374648427: 
            case 408125543: 
            case 440786851: 
            case 475249515: 
            case 524531317: {
                return 1;
            }
            case 134: 
            case 17026: 
            case 21358: 
            case 2274716: {
                return 3;
            }
            case 131: 
            case 136: 
            case 155: 
            case 159: 
            case 176: 
            case 179: 
            case 186: 
            case 215: 
            case 231: 
            case 238: 
            case 241: 
            case 251: 
            case 16871: 
            case 16980: 
            case 17029: 
            case 17143: 
            case 18401: 
            case 18408: 
            case 20529: 
            case 20530: 
            case 21420: 
            case 21432: 
            case 21680: 
            case 21682: 
            case 21690: 
            case 21930: 
            case 21945: 
            case 21946: 
            case 21947: 
            case 21948: 
            case 21949: 
            case 21998: 
            case 22186: 
            case 22203: 
            case 25188: 
            case 30321: 
            case 2352003: 
            case 2807729: 
        }
        return 2;
    }

    protected void handleBlockAddIDExtraData(Track track, ExtractorInput extractorInput, int n2) throws IOException {
        if (track.blockAddIdType != 1685485123 && track.blockAddIdType != 1685480259) {
            extractorInput.skipFully(n2);
        } else {
            track.dolbyVisionConfigBytes = new byte[n2];
            extractorInput.readFully(track.dolbyVisionConfigBytes, 0, n2);
        }
    }

    protected void handleBlockAdditionalData(Track track, int n2, ExtractorInput extractorInput, int n3) throws IOException {
        if (n2 == 4 && CODEC_ID_VP9.equals(track.codecId)) {
            this.blockAdditionalData.reset(n3);
            extractorInput.readFully(this.blockAdditionalData.getData(), 0, n3);
        } else {
            extractorInput.skipFully(n3);
        }
    }

    @Override
    public final void init(ExtractorOutput extractorOutput) {
        this.extractorOutput = extractorOutput;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void integerElement(int n2, long l2) throws ParserException {
        if (n2 != 20529) {
            if (n2 != 20530) {
                boolean bl = false;
                boolean bl2 = false;
                switch (n2) {
                    default: {
                        switch (n2) {
                            default: {
                                return;
                            }
                            case 21949: {
                                this.getCurrentTrack((int)n2).maxFrameAverageLuminance = (int)l2;
                                return;
                            }
                            case 21948: {
                                this.getCurrentTrack((int)n2).maxContentLuminance = (int)l2;
                                return;
                            }
                            case 21947: {
                                this.assertInTrackEntry(n2);
                                Track track = this.currentTrack;
                                track.hasColorInfo = true;
                                n2 = (int)l2;
                                if (n2 == 1) {
                                    track.colorSpace = 1;
                                    return;
                                }
                                if (n2 == 9) {
                                    track.colorSpace = 6;
                                    return;
                                }
                                if (n2 != 4 && n2 != 5 && n2 != 6 && n2 != 7) {
                                    return;
                                }
                                this.currentTrack.colorSpace = 2;
                                return;
                            }
                            case 21946: {
                                this.assertInTrackEntry(n2);
                                n2 = (int)l2;
                                if (n2 != 1) {
                                    if (n2 == 16) {
                                        this.currentTrack.colorTransfer = 6;
                                        return;
                                    }
                                    if (n2 == 18) {
                                        this.currentTrack.colorTransfer = 7;
                                        return;
                                    }
                                    if (n2 != 6 && n2 != 7) {
                                        return;
                                    }
                                }
                                this.currentTrack.colorTransfer = 3;
                                return;
                            }
                            case 21945: 
                        }
                        this.assertInTrackEntry(n2);
                        n2 = (int)l2;
                        if (n2 == 1) {
                            this.currentTrack.colorRange = 2;
                            return;
                        }
                        if (n2 != 2) {
                            return;
                        }
                        this.currentTrack.colorRange = 1;
                        return;
                    }
                    case 2807729: {
                        this.timecodeScale = l2;
                        return;
                    }
                    case 2352003: {
                        this.getCurrentTrack((int)n2).defaultSampleDurationNs = (int)l2;
                        return;
                    }
                    case 30321: {
                        this.assertInTrackEntry(n2);
                        n2 = (int)l2;
                        if (n2 == 0) {
                            this.currentTrack.projectionType = 0;
                            return;
                        }
                        if (n2 == 1) {
                            this.currentTrack.projectionType = 1;
                            return;
                        }
                        if (n2 == 2) {
                            this.currentTrack.projectionType = 2;
                            return;
                        }
                        if (n2 != 3) {
                            return;
                        }
                        this.currentTrack.projectionType = 3;
                        return;
                    }
                    case 25188: {
                        this.getCurrentTrack((int)n2).audioBitDepth = (int)l2;
                        return;
                    }
                    case 22203: {
                        this.getCurrentTrack((int)n2).seekPreRollNs = l2;
                        return;
                    }
                    case 22186: {
                        this.getCurrentTrack((int)n2).codecDelayNs = l2;
                        return;
                    }
                    case 21998: {
                        this.getCurrentTrack((int)n2).maxBlockAdditionId = (int)l2;
                        return;
                    }
                    case 21930: {
                        Track track = this.getCurrentTrack(n2);
                        if (l2 == 1L) {
                            bl2 = true;
                        }
                        track.flagForced = bl2;
                        return;
                    }
                    case 21690: {
                        this.getCurrentTrack((int)n2).displayHeight = (int)l2;
                        return;
                    }
                    case 21682: {
                        this.getCurrentTrack((int)n2).displayUnit = (int)l2;
                        return;
                    }
                    case 21680: {
                        this.getCurrentTrack((int)n2).displayWidth = (int)l2;
                        return;
                    }
                    case 21432: {
                        int n3 = (int)l2;
                        this.assertInTrackEntry(n2);
                        if (n3 == 0) {
                            this.currentTrack.stereoMode = 0;
                            return;
                        }
                        if (n3 == 1) {
                            this.currentTrack.stereoMode = 2;
                            return;
                        }
                        if (n3 == 3) {
                            this.currentTrack.stereoMode = 1;
                            return;
                        }
                        if (n3 != 15) {
                            return;
                        }
                        this.currentTrack.stereoMode = 3;
                        return;
                    }
                    case 21420: {
                        this.seekEntryPosition = l2 + this.segmentContentPosition;
                        return;
                    }
                    case 18408: {
                        if (l2 == 1L) {
                            return;
                        }
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("AESSettingsCipherMode ");
                        stringBuilder.append(l2);
                        stringBuilder.append(" not supported");
                        throw new ParserException(stringBuilder.toString());
                    }
                    case 18401: {
                        if (l2 == 5L) {
                            return;
                        }
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("ContentEncAlgo ");
                        stringBuilder.append(l2);
                        stringBuilder.append(" not supported");
                        throw new ParserException(stringBuilder.toString());
                    }
                    case 17143: {
                        if (l2 == 1L) {
                            return;
                        }
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("EBMLReadVersion ");
                        stringBuilder.append(l2);
                        stringBuilder.append(" not supported");
                        throw new ParserException(stringBuilder.toString());
                    }
                    case 17029: {
                        if (l2 >= 1L && l2 <= 2L) {
                            return;
                        }
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("DocTypeReadVersion ");
                        stringBuilder.append(l2);
                        stringBuilder.append(" not supported");
                        throw new ParserException(stringBuilder.toString());
                    }
                    case 16980: {
                        if (l2 == 3L) {
                            return;
                        }
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("ContentCompAlgo ");
                        stringBuilder.append(l2);
                        stringBuilder.append(" not supported");
                        throw new ParserException(stringBuilder.toString());
                    }
                    case 16871: {
                        Track.access$302(this.getCurrentTrack(n2), (int)l2);
                        return;
                    }
                    case 251: {
                        this.blockHasReferenceBlock = true;
                        return;
                    }
                    case 241: {
                        if (this.seenClusterPositionForCurrentCuePoint) return;
                        this.assertInCues(n2);
                        this.cueClusterPositions.add(l2);
                        this.seenClusterPositionForCurrentCuePoint = true;
                        return;
                    }
                    case 238: {
                        this.blockAdditionalId = (int)l2;
                        return;
                    }
                    case 231: {
                        this.clusterTimecodeUs = this.scaleTimecodeToUs(l2);
                        return;
                    }
                    case 215: {
                        this.getCurrentTrack((int)n2).number = (int)l2;
                        return;
                    }
                    case 186: {
                        this.getCurrentTrack((int)n2).height = (int)l2;
                        return;
                    }
                    case 179: {
                        this.assertInCues(n2);
                        this.cueTimesUs.add(this.scaleTimecodeToUs(l2));
                        return;
                    }
                    case 176: {
                        this.getCurrentTrack((int)n2).width = (int)l2;
                        return;
                    }
                    case 159: {
                        this.getCurrentTrack((int)n2).channelCount = (int)l2;
                        return;
                    }
                    case 155: {
                        this.blockDurationUs = this.scaleTimecodeToUs(l2);
                        return;
                    }
                    case 136: {
                        Track track = this.getCurrentTrack(n2);
                        bl2 = bl;
                        if (l2 == 1L) {
                            bl2 = true;
                        }
                        track.flagDefault = bl2;
                        return;
                    }
                    case 131: 
                }
                this.getCurrentTrack((int)n2).type = (int)l2;
                return;
            }
            if (l2 == 1L) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("ContentEncodingScope ");
            stringBuilder.append(l2);
            stringBuilder.append(" not supported");
            throw new ParserException(stringBuilder.toString());
        }
        if (l2 == 0L) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ContentEncodingOrder ");
        stringBuilder.append(l2);
        stringBuilder.append(" not supported");
        throw new ParserException(stringBuilder.toString());
    }

    protected boolean isLevel1Element(int n2) {
        boolean bl = n2 == 357149030 || n2 == 524531317 || n2 == 475249515 || n2 == 374648427;
        return bl;
    }

    @Override
    public final int read(ExtractorInput object, PositionHolder positionHolder) throws IOException {
        int n2 = 0;
        this.haveOutputSample = false;
        boolean bl = true;
        while (bl && !this.haveOutputSample) {
            boolean bl2;
            bl = bl2 = this.reader.read((ExtractorInput)object);
            if (!bl2) continue;
            bl = bl2;
            if (!this.maybeSeekForCues(positionHolder, object.getPosition())) continue;
            return 1;
        }
        if (!bl) {
            while (n2 < this.tracks.size()) {
                object = (Track)this.tracks.valueAt(n2);
                ((Track)object).assertOutputInitialized();
                ((Track)object).outputPendingSampleMetadata();
                ++n2;
            }
            return -1;
        }
        return 0;
    }

    @Override
    public final void release() {
    }

    @Override
    public void seek(long l2, long l3) {
        this.clusterTimecodeUs = -9223372036854775807L;
        this.blockState = 0;
        this.reader.reset();
        this.varintReader.reset();
        this.resetWriteSampleData();
        for (int i2 = 0; i2 < this.tracks.size(); ++i2) {
            ((Track)this.tracks.valueAt(i2)).reset();
        }
    }

    @Override
    public final boolean sniff(ExtractorInput extractorInput) throws IOException {
        return new Sniffer().sniff(extractorInput);
    }

    protected void startMasterElement(int n2, long l2, long l3) throws ParserException {
        this.assertInitialized();
        if (n2 != 160) {
            if (n2 != 174) {
                if (n2 != 187) {
                    if (n2 != 19899) {
                        if (n2 != 20533) {
                            if (n2 != 21968) {
                                if (n2 != 25152) {
                                    if (n2 != 408125543) {
                                        if (n2 != 475249515) {
                                            if (n2 == 524531317 && !this.sentSeekMap) {
                                                if (this.seekForCuesEnabled && this.cuesContentPosition != -1L) {
                                                    this.seekForCues = true;
                                                } else {
                                                    this.extractorOutput.seekMap(new SeekMap.Unseekable(this.durationUs));
                                                    this.sentSeekMap = true;
                                                }
                                            }
                                        } else {
                                            this.cueTimesUs = new LongArray();
                                            this.cueClusterPositions = new LongArray();
                                        }
                                    } else {
                                        long l4 = this.segmentContentPosition;
                                        if (l4 != -1L && l4 != l2) {
                                            throw new ParserException("Multiple Segment elements not supported");
                                        }
                                        this.segmentContentPosition = l2;
                                        this.segmentContentSize = l3;
                                    }
                                }
                            } else {
                                this.getCurrentTrack((int)n2).hasColorInfo = true;
                            }
                        } else {
                            this.getCurrentTrack((int)n2).hasContentEncryption = true;
                        }
                    } else {
                        this.seekEntryId = -1;
                        this.seekEntryPosition = -1L;
                    }
                } else {
                    this.seenClusterPositionForCurrentCuePoint = false;
                }
            } else {
                this.currentTrack = new Track();
            }
        } else {
            this.blockHasReferenceBlock = false;
        }
    }

    protected void stringElement(int n2, String string2) throws ParserException {
        if (n2 != 134) {
            if (n2 != 17026) {
                if (n2 != 21358) {
                    if (n2 == 2274716) {
                        Track.access$402(this.getCurrentTrack(n2), string2);
                    }
                } else {
                    this.getCurrentTrack((int)n2).name = string2;
                }
            } else if (!DOC_TYPE_WEBM.equals(string2) && !DOC_TYPE_MATROSKA.equals(string2)) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("DocType ");
                stringBuilder.append(string2);
                stringBuilder.append(" not supported");
                throw new ParserException(stringBuilder.toString());
            }
        } else {
            this.getCurrentTrack((int)n2).codecId = string2;
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Flags {
    }

    private final class InnerEbmlProcessor
    implements EbmlProcessor {
        private InnerEbmlProcessor() {
        }

        @Override
        public void binaryElement(int n2, int n3, ExtractorInput extractorInput) throws IOException {
            MatroskaExtractor.this.binaryElement(n2, n3, extractorInput);
        }

        @Override
        public void endMasterElement(int n2) throws ParserException {
            MatroskaExtractor.this.endMasterElement(n2);
        }

        @Override
        public void floatElement(int n2, double d2) throws ParserException {
            MatroskaExtractor.this.floatElement(n2, d2);
        }

        @Override
        public int getElementType(int n2) {
            return MatroskaExtractor.this.getElementType(n2);
        }

        @Override
        public void integerElement(int n2, long l2) throws ParserException {
            MatroskaExtractor.this.integerElement(n2, l2);
        }

        @Override
        public boolean isLevel1Element(int n2) {
            return MatroskaExtractor.this.isLevel1Element(n2);
        }

        @Override
        public void startMasterElement(int n2, long l2, long l3) throws ParserException {
            MatroskaExtractor.this.startMasterElement(n2, l2, l3);
        }

        @Override
        public void stringElement(int n2, String string2) throws ParserException {
            MatroskaExtractor.this.stringElement(n2, string2);
        }
    }

    private static final class Track {
        private static final int DEFAULT_MAX_CLL = 1000;
        private static final int DEFAULT_MAX_FALL = 200;
        private static final int DISPLAY_UNIT_PIXELS = 0;
        private static final int MAX_CHROMATICITY = 50000;
        public int audioBitDepth = -1;
        private int blockAddIdType;
        public int channelCount = 1;
        public long codecDelayNs = 0L;
        public String codecId;
        public byte[] codecPrivate;
        public int colorRange = -1;
        public int colorSpace = -1;
        public int colorTransfer = -1;
        public TrackOutput.CryptoData cryptoData;
        public int defaultSampleDurationNs;
        public int displayHeight = -1;
        public int displayUnit = 0;
        public int displayWidth = -1;
        public byte[] dolbyVisionConfigBytes;
        public DrmInitData drmInitData;
        public boolean flagDefault = true;
        public boolean flagForced;
        public boolean hasColorInfo = false;
        public boolean hasContentEncryption;
        public int height = -1;
        private String language = "eng";
        public int maxBlockAdditionId;
        public int maxContentLuminance = 1000;
        public int maxFrameAverageLuminance = 200;
        public float maxMasteringLuminance = -1.0f;
        public float minMasteringLuminance = -1.0f;
        public int nalUnitLengthFieldLength;
        public String name;
        public int number;
        public TrackOutput output;
        public float primaryBChromaticityX = -1.0f;
        public float primaryBChromaticityY = -1.0f;
        public float primaryGChromaticityX = -1.0f;
        public float primaryGChromaticityY = -1.0f;
        public float primaryRChromaticityX = -1.0f;
        public float primaryRChromaticityY = -1.0f;
        public byte[] projectionData = null;
        public float projectionPosePitch = 0.0f;
        public float projectionPoseRoll = 0.0f;
        public float projectionPoseYaw = 0.0f;
        public int projectionType = -1;
        public int sampleRate = 8000;
        public byte[] sampleStrippedBytes;
        public long seekPreRollNs = 0L;
        public int stereoMode = -1;
        public TrueHdSampleRechunker trueHdSampleRechunker;
        public int type;
        public float whitePointChromaticityX = -1.0f;
        public float whitePointChromaticityY = -1.0f;
        public int width = -1;

        private Track() {
        }

        static /* synthetic */ int access$302(Track track, int n2) {
            track.blockAddIdType = n2;
            return n2;
        }

        static /* synthetic */ String access$402(Track track, String string2) {
            track.language = string2;
            return string2;
        }

        @EnsuresNonNull(value={"output"})
        private void assertOutputInitialized() {
            Assertions.checkNotNull(this.output);
        }

        @EnsuresNonNull(value={"codecPrivate"})
        private byte[] getCodecPrivate(String string2) throws ParserException {
            Object object = this.codecPrivate;
            if (object != null) {
                return object;
            }
            object = new StringBuilder();
            object.append("Missing CodecPrivate for codec ");
            object.append(string2);
            throw new ParserException(object.toString());
        }

        private byte[] getHdrStaticInfo() {
            if (this.primaryRChromaticityX != -1.0f && this.primaryRChromaticityY != -1.0f && this.primaryGChromaticityX != -1.0f && this.primaryGChromaticityY != -1.0f && this.primaryBChromaticityX != -1.0f && this.primaryBChromaticityY != -1.0f && this.whitePointChromaticityX != -1.0f && this.whitePointChromaticityY != -1.0f && this.maxMasteringLuminance != -1.0f && this.minMasteringLuminance != -1.0f) {
                byte[] byArray = new byte[25];
                ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN);
                byteBuffer.put((byte)0);
                byteBuffer.putShort((short)(this.primaryRChromaticityX * 50000.0f + 0.5f));
                byteBuffer.putShort((short)(this.primaryRChromaticityY * 50000.0f + 0.5f));
                byteBuffer.putShort((short)(this.primaryGChromaticityX * 50000.0f + 0.5f));
                byteBuffer.putShort((short)(this.primaryGChromaticityY * 50000.0f + 0.5f));
                byteBuffer.putShort((short)(this.primaryBChromaticityX * 50000.0f + 0.5f));
                byteBuffer.putShort((short)(this.primaryBChromaticityY * 50000.0f + 0.5f));
                byteBuffer.putShort((short)(this.whitePointChromaticityX * 50000.0f + 0.5f));
                byteBuffer.putShort((short)(this.whitePointChromaticityY * 50000.0f + 0.5f));
                byteBuffer.putShort((short)(this.maxMasteringLuminance + 0.5f));
                byteBuffer.putShort((short)(this.minMasteringLuminance + 0.5f));
                byteBuffer.putShort((short)this.maxContentLuminance);
                byteBuffer.putShort((short)this.maxFrameAverageLuminance);
                return byArray;
            }
            return null;
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        private static Pair<String, List<byte[]>> parseFourCcPrivate(ParsableByteArray var0) throws ParserException {
            block11: {
                var0 /* !! */ .skipBytes(16);
                var1_3 = var0 /* !! */ .readLittleEndianUnsignedInt();
                if (var1_3 != 1482049860L) break block11;
                try {
                    return new Pair((Object)"video/divx", null);
                }
                catch (ArrayIndexOutOfBoundsException var0_1) {
                    var0_2 = new ParserException("Error parsing FourCC private data");
                    throw var0_2;
                }
            }
            if (var1_3 == 859189832L) {
                return new Pair((Object)"video/3gpp", null);
            }
            if (var1_3 == 826496599L) {
                var3_4 = var0 /* !! */ .getPosition() + 20;
                var0 /* !! */  = (ParsableByteArray)var0 /* !! */ .getData();
                ** while (var3_4 < ((ParsableByteArray)var0 /* !! */ ).length - 4)
lbl-1000:
                // 1 sources

                {
                    if (var0 /* !! */ [var3_4] == false && var0 /* !! */ [var3_4 + 1] == false && var0 /* !! */ [var3_4 + 2] == true && var0 /* !! */ [var3_4 + 3] == 15) {
                        return new Pair((Object)"video/wvc1", Collections.singletonList(Arrays.copyOfRange((byte[])var0 /* !! */ , var3_4, ((ParsableByteArray)var0 /* !! */ ).length)));
                    }
                    ++var3_4;
                    continue;
                }
lbl22:
                // 2 sources

                var0 /* !! */  = new ParserException("Failed to find FourCC VC1 initialization data");
                throw var0 /* !! */ ;
            }
            Log.w("MatroskaExtractor", "Unknown FourCC. Setting mimeType to video/x-unknown");
            return new Pair((Object)"video/x-unknown", null);
        }

        private static boolean parseMsAcmCodecPrivate(ParsableByteArray parsableByteArray) throws ParserException {
            block5: {
                long l2;
                long l3;
                boolean bl;
                try {
                    int n2 = parsableByteArray.readLittleEndianUnsignedShort();
                    bl = true;
                    if (n2 == 1) {
                        return true;
                    }
                    if (n2 != 65534) break block5;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new ParserException("Error parsing MS/ACM codec private");
                }
                parsableByteArray.setPosition(24);
                if (parsableByteArray.readLong() != WAVE_SUBFORMAT_PCM.getMostSignificantBits() || (l3 = parsableByteArray.readLong()) != (l2 = WAVE_SUBFORMAT_PCM.getLeastSignificantBits())) {
                    bl = false;
                }
                return bl;
            }
            return false;
        }

        /*
         * Unable to fully structure code
         */
        private static List<byte[]> parseVorbisCodecPrivate(byte[] var0) throws ParserException {
            if (var0[0] != 2) ** GOTO lbl48
            var1_3 = 1;
            var2_4 = 0;
            while ((var0[var1_3] & 255) == 255) {
                var2_4 += 255;
                ++var1_3;
            }
            var3_5 = var1_3 + 1;
            var4_6 = var2_4 + (var0[var1_3] & 255);
            var1_3 = 0;
            var2_4 = var3_5;
            while ((var0[var2_4] & 255) == 255) {
                var1_3 += 255;
                ++var2_4;
            }
            var3_5 = var2_4 + 1;
            var2_4 = var0[var2_4];
            if (var0[var3_5] != 1) ** GOTO lbl45
            try {
                var5_7 = new byte[var4_6];
                System.arraycopy(var0, var3_5, var5_7, 0, var4_6);
            }
            catch (ArrayIndexOutOfBoundsException var0_1) {
                var0_2 = new ParserException("Error parsing vorbis codec private");
                throw var0_2;
            }
            if (var0[var3_5 += var4_6] != 3) ** GOTO lbl42
            if (var0[var1_3 = var3_5 + (var1_3 + (var2_4 & 255))] == 5) {
                var6_8 = new byte[((byte[])var0).length - var1_3];
                System.arraycopy(var0, var1_3, var6_8, 0, ((byte[])var0).length - var1_3);
                var0 = new ArrayList;
                var0(2);
                var0.add(var5_7);
                var0.add(var6_8);
                return var0;
            }
            var0 = new ParserException;
            var0("Error parsing vorbis codec private");
            throw var0;
lbl42:
            // 1 sources

            var0 = new ParserException;
            var0("Error parsing vorbis codec private");
            throw var0;
lbl45:
            // 1 sources

            var0 = new ParserException;
            var0("Error parsing vorbis codec private");
            throw var0;
lbl48:
            // 1 sources

            var0 = new ParserException;
            var0("Error parsing vorbis codec private");
            throw var0;
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @EnsuresNonNull(value={"this.output"})
        @RequiresNonNull(value={"codecId"})
        public void initializeOutput(ExtractorOutput var1_1, int var2_2) throws ParserException {
            block95: {
                block91: {
                    block92: {
                        block94: {
                            block93: {
                                var3_3 /* !! */  = this.codecId;
                                var4_4 = var3_3 /* !! */ .hashCode();
                                var5_5 = 2;
                                var6_6 = 4;
                                var7_7 = 0;
                                switch (var4_4) {
                                    default: {
                                        break;
                                    }
                                    case 1951062397: {
                                        if (!var3_3 /* !! */ .equals("A_OPUS")) break;
                                        var4_4 = 12;
                                        break block93;
                                    }
                                    case 1950789798: {
                                        if (!var3_3 /* !! */ .equals("A_FLAC")) break;
                                        var4_4 = 22;
                                        break block93;
                                    }
                                    case 1950749482: {
                                        if (!var3_3 /* !! */ .equals("A_EAC3")) break;
                                        var4_4 = 17;
                                        break block93;
                                    }
                                    case 1809237540: {
                                        if (!var3_3 /* !! */ .equals("V_MPEG2")) break;
                                        var4_4 = 3;
                                        break block93;
                                    }
                                    case 1422270023: {
                                        if (!var3_3 /* !! */ .equals("S_TEXT/UTF8")) break;
                                        var4_4 = 27;
                                        break block93;
                                    }
                                    case 855502857: {
                                        if (!var3_3 /* !! */ .equals("V_MPEGH/ISO/HEVC")) break;
                                        var4_4 = 8;
                                        break block93;
                                    }
                                    case 738597099: {
                                        if (!var3_3 /* !! */ .equals("S_TEXT/ASS")) break;
                                        var4_4 = 28;
                                        break block93;
                                    }
                                    case 725957860: {
                                        if (!var3_3 /* !! */ .equals("A_PCM/INT/LIT")) break;
                                        var4_4 = 24;
                                        break block93;
                                    }
                                    case 725948237: {
                                        if (!var3_3 /* !! */ .equals("A_PCM/INT/BIG")) break;
                                        var4_4 = 25;
                                        break block93;
                                    }
                                    case 635596514: {
                                        if (!var3_3 /* !! */ .equals("A_PCM/FLOAT/IEEE")) break;
                                        var4_4 = 26;
                                        break block93;
                                    }
                                    case 542569478: {
                                        if (!var3_3 /* !! */ .equals("A_DTS/EXPRESS")) break;
                                        var4_4 = 20;
                                        break block93;
                                    }
                                    case 444813526: {
                                        if (!var3_3 /* !! */ .equals("V_THEORA")) break;
                                        var4_4 = 10;
                                        break block93;
                                    }
                                    case 99146302: {
                                        if (!var3_3 /* !! */ .equals("S_HDMV/PGS")) break;
                                        var4_4 = 30;
                                        break block93;
                                    }
                                    case 82338134: {
                                        if (!var3_3 /* !! */ .equals("V_VP9")) break;
                                        var4_4 = 1;
                                        break block93;
                                    }
                                    case 82338133: {
                                        if (!var3_3 /* !! */ .equals("V_VP8")) break;
                                        var4_4 = 0;
                                        break block93;
                                    }
                                    case 82318131: {
                                        if (!var3_3 /* !! */ .equals("V_AV1")) break;
                                        var4_4 = 2;
                                        break block93;
                                    }
                                    case 62927045: {
                                        if (!var3_3 /* !! */ .equals("A_DTS")) break;
                                        var4_4 = 19;
                                        break block93;
                                    }
                                    case 62923603: {
                                        if (!var3_3 /* !! */ .equals("A_AC3")) break;
                                        var4_4 = 16;
                                        break block93;
                                    }
                                    case 62923557: {
                                        if (!var3_3 /* !! */ .equals("A_AAC")) break;
                                        var4_4 = 13;
                                        break block93;
                                    }
                                    case -356037306: {
                                        if (!var3_3 /* !! */ .equals("A_DTS/LOSSLESS")) break;
                                        var4_4 = 21;
                                        break block93;
                                    }
                                    case -425012669: {
                                        if (!var3_3 /* !! */ .equals("S_VOBSUB")) break;
                                        var4_4 = 29;
                                        break block93;
                                    }
                                    case -538363109: {
                                        if (!var3_3 /* !! */ .equals("V_MPEG4/ISO/AVC")) break;
                                        var4_4 = 7;
                                        break block93;
                                    }
                                    case -538363189: {
                                        if (!var3_3 /* !! */ .equals("V_MPEG4/ISO/ASP")) break;
                                        var4_4 = 5;
                                        break block93;
                                    }
                                    case -933872740: {
                                        if (!var3_3 /* !! */ .equals("S_DVBSUB")) break;
                                        var4_4 = 31;
                                        break block93;
                                    }
                                    case -1373388978: {
                                        if (!var3_3 /* !! */ .equals("V_MS/VFW/FOURCC")) break;
                                        var4_4 = 9;
                                        break block93;
                                    }
                                    case -1482641357: {
                                        if (!var3_3 /* !! */ .equals("A_MPEG/L3")) break;
                                        var4_4 = 15;
                                        break block93;
                                    }
                                    case -1482641358: {
                                        if (!var3_3 /* !! */ .equals("A_MPEG/L2")) break;
                                        var4_4 = 14;
                                        break block93;
                                    }
                                    case -1730367663: {
                                        if (!var3_3 /* !! */ .equals("A_VORBIS")) break;
                                        var4_4 = 11;
                                        break block93;
                                    }
                                    case -1784763192: {
                                        if (!var3_3 /* !! */ .equals("A_TRUEHD")) break;
                                        var4_4 = 18;
                                        break block93;
                                    }
                                    case -1985379776: {
                                        if (!var3_3 /* !! */ .equals("A_MS/ACM")) break;
                                        var4_4 = 23;
                                        break block93;
                                    }
                                    case -2095575984: {
                                        if (!var3_3 /* !! */ .equals("V_MPEG4/ISO/SP")) break;
                                        var4_4 = 4;
                                        break block93;
                                    }
                                    case -2095576542: {
                                        if (!var3_3 /* !! */ .equals("V_MPEG4/ISO/AP")) break;
                                        var4_4 = 6;
                                        break block93;
                                    }
                                }
                                var4_4 = -1;
                            }
                            var8_8 = 4096;
                            var9_9 = null;
                            switch (var4_4) {
                                default: {
                                    throw new ParserException("Unrecognized codec identifier.");
                                }
                                case 31: {
                                    var3_3 /* !! */  = (HevcConfig)new byte[4];
                                    System.arraycopy(this.getCodecPrivate(this.codecId), 0, var3_3 /* !! */ , 0, 4);
                                    var3_3 /* !! */  = ImmutableList.of(var3_3 /* !! */ );
                                    var10_10 = "application/dvbsubs";
                                    ** GOTO lbl306
                                }
                                case 30: {
                                    var3_3 /* !! */  = "application/pgs";
                                    break block94;
                                }
                                case 29: {
                                    var3_3 /* !! */  = ImmutableList.of(this.getCodecPrivate(this.codecId));
                                    var10_10 = "application/vobsub";
                                    ** GOTO lbl306
                                }
                                case 28: {
                                    var11_11 /* !! */  = ImmutableList.of(MatroskaExtractor.access$500(), this.getCodecPrivate(this.codecId));
                                    var3_3 /* !! */  = "text/x-ssa";
                                    break block92;
                                }
                                case 27: {
                                    var3_3 /* !! */  = "application/x-subrip";
                                    break block94;
                                }
                                case 26: {
                                    if (this.audioBitDepth != 32) ** GOTO lbl168
                                    var4_4 = var6_6;
                                    ** GOTO lbl214
lbl168:
                                    // 1 sources

                                    var3_3 /* !! */  = new StringBuilder();
                                    var3_3 /* !! */ .append("Unsupported floating point PCM bit depth: ");
                                    var3_3 /* !! */ .append(this.audioBitDepth);
                                    var3_3 /* !! */ .append(". Setting mimeType to ");
                                    var3_3 /* !! */ .append("audio/x-unknown");
                                    Log.w("MatroskaExtractor", var3_3 /* !! */ .toString());
                                    ** GOTO lbl239
                                }
                                case 25: {
                                    var4_4 = this.audioBitDepth;
                                    if (var4_4 != 8) ** GOTO lbl186
                                    var3_3 /* !! */  = "audio/raw";
                                    var11_11 /* !! */  = null;
                                    var4_4 = 3;
                                    break block91;
lbl186:
                                    // 1 sources

                                    if (var4_4 != 16) ** GOTO lbl189
                                    var4_4 = 0x10000000;
                                    ** GOTO lbl214
lbl189:
                                    // 1 sources

                                    var3_3 /* !! */  = new StringBuilder();
                                    var3_3 /* !! */ .append("Unsupported big endian PCM bit depth: ");
                                    var3_3 /* !! */ .append(this.audioBitDepth);
                                    var3_3 /* !! */ .append(". Setting mimeType to ");
                                    var3_3 /* !! */ .append("audio/x-unknown");
                                    Log.w("MatroskaExtractor", var3_3 /* !! */ .toString());
                                    ** GOTO lbl239
                                }
                                case 24: {
                                    var4_4 = var6_6 = Util.getPcmEncoding(this.audioBitDepth);
                                    if (var6_6 != 0) ** GOTO lbl214
                                    var3_3 /* !! */  = new StringBuilder();
                                    var3_3 /* !! */ .append("Unsupported little endian PCM bit depth: ");
                                    var3_3 /* !! */ .append(this.audioBitDepth);
                                    var3_3 /* !! */ .append(". Setting mimeType to ");
                                    var3_3 /* !! */ .append("audio/x-unknown");
                                    Log.w("MatroskaExtractor", var3_3 /* !! */ .toString());
                                    ** GOTO lbl239
lbl214:
                                    // 4 sources

                                    while (true) {
                                        var3_3 /* !! */  = "audio/raw";
                                        var11_11 /* !! */  = null;
                                        break block91;
                                        break;
                                    }
                                }
                                case 23: {
                                    if (Track.parseMsAcmCodecPrivate(new ParsableByteArray(this.getCodecPrivate(this.codecId)))) {
                                        var4_4 = var6_6 = Util.getPcmEncoding(this.audioBitDepth);
                                        if (var6_6 != 0) ** continue;
                                        var3_3 /* !! */  = new StringBuilder();
                                        var3_3 /* !! */ .append("Unsupported PCM bit depth: ");
                                        var3_3 /* !! */ .append(this.audioBitDepth);
                                        var3_3 /* !! */ .append(". Setting mimeType to ");
                                        var3_3 /* !! */ .append("audio/x-unknown");
                                        Log.w("MatroskaExtractor", var3_3 /* !! */ .toString());
                                    } else {
                                        var3_3 /* !! */  = new StringBuilder();
                                        var3_3 /* !! */ .append("Non-PCM MS/ACM is unsupported. Setting mimeType to ");
                                        var3_3 /* !! */ .append("audio/x-unknown");
                                        Log.w("MatroskaExtractor", var3_3 /* !! */ .toString());
                                    }
lbl239:
                                    // 5 sources

                                    var11_11 /* !! */  = null;
                                    var3_3 /* !! */  = "audio/x-unknown";
                                    break block92;
                                }
                                case 22: {
                                    var3_3 /* !! */  = Collections.singletonList(this.getCodecPrivate(this.codecId));
                                    var10_10 = "audio/flac";
                                    ** GOTO lbl306
                                }
                                case 21: {
                                    var3_3 /* !! */  = "audio/vnd.dts.hd";
                                    break block94;
                                }
                                case 19: 
                                case 20: {
                                    var3_3 /* !! */  = "audio/vnd.dts";
                                    break block94;
                                }
                                case 18: {
                                    this.trueHdSampleRechunker = new TrueHdSampleRechunker();
                                    var3_3 /* !! */  = "audio/true-hd";
                                    break block94;
                                }
                                case 17: {
                                    var3_3 /* !! */  = "audio/eac3";
                                    break block94;
                                }
                                case 16: {
                                    var3_3 /* !! */  = "audio/ac3";
                                    break block94;
                                }
                                case 15: {
                                    var3_3 /* !! */  = "audio/mpeg";
                                    ** GOTO lbl267
                                }
                                case 14: {
                                    var3_3 /* !! */  = "audio/mpeg-L2";
lbl267:
                                    // 2 sources

                                    var11_11 /* !! */  = null;
                                    var10_10 = var11_11 /* !! */ ;
                                    var6_6 = var8_8;
                                    ** GOTO lbl328
                                }
                                case 13: {
                                    var11_11 /* !! */  = Collections.singletonList(this.getCodecPrivate(this.codecId));
                                    var3_3 /* !! */  = AacUtil.parseAudioSpecificConfig(this.codecPrivate);
                                    this.sampleRate = var3_3 /* !! */ .sampleRateHz;
                                    this.channelCount = var3_3 /* !! */ .channelCount;
                                    var10_10 = var3_3 /* !! */ .codecs;
                                    var4_4 = -1;
                                    var6_6 = -1;
                                    var3_3 /* !! */  = "audio/mp4a-latm";
                                    break block95;
                                }
                                case 12: {
                                    var10_10 = new ArrayList<byte[]>(3);
                                    var10_10.add(this.getCodecPrivate(this.codecId));
                                    var10_10.add(ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(this.codecDelayNs).array());
                                    var10_10.add(ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(this.seekPreRollNs).array());
                                    var3_3 /* !! */  = "audio/opus";
                                    var11_11 /* !! */  = null;
                                    var4_4 = 5760;
                                    ** GOTO lbl324
                                }
                                case 11: {
                                    var10_10 = Track.parseVorbisCodecPrivate(this.getCodecPrivate(this.codecId));
                                    var3_3 /* !! */  = "audio/vorbis";
                                    var11_11 /* !! */  = null;
                                    var4_4 = 8192;
                                    ** GOTO lbl324
                                }
                                case 10: {
                                    var3_3 /* !! */  = "video/x-unknown";
                                    break block94;
                                }
                                case 9: {
                                    var3_3 /* !! */  = Track.parseFourCcPrivate(new ParsableByteArray(this.getCodecPrivate(this.codecId)));
                                    var10_10 = (String)var3_3 /* !! */ .first;
                                    var3_3 /* !! */  = (List)var3_3 /* !! */ .second;
lbl306:
                                    // 5 sources

                                    while (true) {
                                        var11_11 /* !! */  = var3_3 /* !! */ ;
                                        var3_3 /* !! */  = var10_10;
                                        break block92;
                                        break;
                                    }
                                }
                                case 8: {
                                    var3_3 /* !! */  = HevcConfig.parse((ParsableByteArray)new ParsableByteArray(this.getCodecPrivate(this.codecId)));
                                    var10_10 = var3_3 /* !! */ .initializationData;
                                    this.nalUnitLengthFieldLength = var3_3 /* !! */ .nalUnitLengthFieldLength;
                                    var11_11 /* !! */  = var3_3 /* !! */ .codecs;
                                    var3_3 /* !! */  = "video/hevc";
                                    ** GOTO lbl323
                                }
                                case 7: {
                                    var3_3 /* !! */  = AvcConfig.parse((ParsableByteArray)new ParsableByteArray(this.getCodecPrivate(this.codecId)));
                                    var10_10 = var3_3 /* !! */ .initializationData;
                                    this.nalUnitLengthFieldLength = var3_3 /* !! */ .nalUnitLengthFieldLength;
                                    var11_11 /* !! */  = var3_3 /* !! */ .codecs;
                                    var3_3 /* !! */  = "video/avc";
lbl323:
                                    // 2 sources

                                    var4_4 = -1;
lbl324:
                                    // 3 sources

                                    var12_12 = var10_10;
                                    var10_10 = var11_11 /* !! */ ;
                                    var6_6 = var4_4;
                                    var11_11 /* !! */  = var12_12;
lbl328:
                                    // 2 sources

                                    var4_4 = -1;
                                    break block95;
                                }
                                case 4: 
                                case 5: 
                                case 6: {
                                    var3_3 /* !! */  = (HevcConfig)this.codecPrivate;
                                    var3_3 /* !! */  = var3_3 /* !! */  == null ? null : Collections.singletonList(var3_3 /* !! */ );
                                    var10_10 = "video/mp4v-es";
                                    ** continue;
                                }
                                case 3: {
                                    var3_3 /* !! */  = "video/mpeg2";
                                    break block94;
                                }
                                case 2: {
                                    var3_3 /* !! */  = "video/av01";
                                    break block94;
                                }
                                case 1: {
                                    var3_3 /* !! */  = "video/x-vnd.on2.vp9";
                                    break block94;
                                }
                                case 0: 
                            }
                            var3_3 /* !! */  = "video/x-vnd.on2.vp8";
                        }
                        var11_11 /* !! */  = null;
                    }
                    var4_4 = -1;
                }
                var10_10 = null;
                var6_6 = -1;
            }
            var13_13 /* !! */  = this.dolbyVisionConfigBytes;
            var14_14 = var3_3 /* !! */ ;
            var12_12 = var10_10;
            if (var13_13 /* !! */  != null) {
                var13_13 /* !! */  = (byte[])DolbyVisionConfig.parse((ParsableByteArray)new ParsableByteArray(var13_13 /* !! */ ));
                var14_14 = var3_3 /* !! */ ;
                var12_12 = var10_10;
                if (var13_13 /* !! */  != null) {
                    var12_12 = var13_13 /* !! */ .codecs;
                    var14_14 = "video/dolby-vision";
                }
            }
            var15_15 = this.flagDefault;
            var8_8 = this.flagForced != false ? 2 : 0;
            var10_10 = new Format.Builder();
            if (MimeTypes.isAudio((String)var14_14)) {
                var5_5 = 1;
                var10_10.setChannelCount(this.channelCount).setSampleRate(this.sampleRate).setPcmEncoding(var4_4);
                var4_4 = var5_5;
            } else if (MimeTypes.isVideo((String)var14_14)) {
                if (this.displayUnit == 0) {
                    var4_4 = var16_16 = this.displayWidth;
                    if (var16_16 == -1) {
                        var4_4 = this.width;
                    }
                    this.displayWidth = var4_4;
                    var4_4 = var16_16 = this.displayHeight;
                    if (var16_16 == -1) {
                        var4_4 = this.height;
                    }
                    this.displayHeight = var4_4;
                }
                var17_17 = -1.0f;
                var4_4 = this.displayWidth;
                var18_18 = var17_17;
                if (var4_4 != -1) {
                    var16_16 = this.displayHeight;
                    var18_18 = var17_17;
                    if (var16_16 != -1) {
                        var18_18 = (float)(this.height * var4_4) / (float)(this.width * var16_16);
                    }
                }
                var3_3 /* !! */  = var9_9;
                if (this.hasColorInfo) {
                    var3_3 /* !! */  = (HevcConfig)this.getHdrStaticInfo();
                    var3_3 /* !! */  = new ColorInfo(this.colorSpace, this.colorRange, this.colorTransfer, (byte[])var3_3 /* !! */ );
                }
                var4_4 = this.name != null && MatroskaExtractor.access$600().containsKey(this.name) != false ? (Integer)MatroskaExtractor.access$600().get(this.name) : -1;
                if (this.projectionType == 0 && Float.compare(this.projectionPoseYaw, 0.0f) == 0 && Float.compare(this.projectionPosePitch, 0.0f) == 0) {
                    if (Float.compare(this.projectionPoseRoll, 0.0f) == 0) {
                        var4_4 = var7_7;
                    } else if (Float.compare(this.projectionPosePitch, 90.0f) == 0) {
                        var4_4 = 90;
                    } else if (Float.compare(this.projectionPosePitch, -180.0f) != 0 && Float.compare(this.projectionPosePitch, 180.0f) != 0) {
                        if (Float.compare(this.projectionPosePitch, -90.0f) == 0) {
                            var4_4 = 270;
                        }
                    } else {
                        var4_4 = 180;
                    }
                }
                var10_10.setWidth(this.width).setHeight(this.height).setPixelWidthHeightRatio(var18_18).setRotationDegrees(var4_4).setProjectionData(this.projectionData).setStereoMode(this.stereoMode).setColorInfo((ColorInfo)var3_3 /* !! */ );
                var4_4 = var5_5;
            } else {
                if (!("application/x-subrip".equals(var14_14) || "text/x-ssa".equals(var14_14) || "application/vobsub".equals(var14_14) || "application/pgs".equals(var14_14) || "application/dvbsubs".equals(var14_14))) {
                    throw new ParserException("Unexpected MIME type.");
                }
                var4_4 = 3;
            }
            if (this.name != null && !MatroskaExtractor.access$600().containsKey(this.name)) {
                var10_10.setLabel(this.name);
            }
            var3_3 /* !! */  = var10_10.setId(var2_2).setSampleMimeType((String)var14_14).setMaxInputSize(var6_6).setLanguage(this.language).setSelectionFlags(var15_15 | 0 | var8_8).setInitializationData((List)var11_11 /* !! */ ).setCodecs((String)var12_12).setDrmInitData(this.drmInitData).build();
            this.output = var1_1.track(this.number, var4_4);
            this.output.format((Format)var3_3 /* !! */ );
        }

        @RequiresNonNull(value={"output"})
        public void outputPendingSampleMetadata() {
            TrueHdSampleRechunker trueHdSampleRechunker = this.trueHdSampleRechunker;
            if (trueHdSampleRechunker != null) {
                trueHdSampleRechunker.outputPendingSampleMetadata(this);
            }
        }

        public void reset() {
            TrueHdSampleRechunker trueHdSampleRechunker = this.trueHdSampleRechunker;
            if (trueHdSampleRechunker != null) {
                trueHdSampleRechunker.reset();
            }
        }
    }

    private static final class TrueHdSampleRechunker {
        private int chunkFlags;
        private int chunkOffset;
        private int chunkSampleCount;
        private int chunkSize;
        private long chunkTimeUs;
        private boolean foundSyncframe;
        private final byte[] syncframePrefix = new byte[10];

        @RequiresNonNull(value={"#1.output"})
        public void outputPendingSampleMetadata(Track track) {
            if (this.chunkSampleCount > 0) {
                track.output.sampleMetadata(this.chunkTimeUs, this.chunkFlags, this.chunkSize, this.chunkOffset, track.cryptoData);
                this.chunkSampleCount = 0;
            }
        }

        public void reset() {
            this.foundSyncframe = false;
            this.chunkSampleCount = 0;
        }

        @RequiresNonNull(value={"#1.output"})
        public void sampleMetadata(Track track, long l2, int n2, int n3, int n4) {
            if (!this.foundSyncframe) {
                return;
            }
            int n5 = this.chunkSampleCount;
            this.chunkSampleCount = n5 + 1;
            if (n5 == 0) {
                this.chunkTimeUs = l2;
                this.chunkFlags = n2;
                this.chunkSize = 0;
            }
            this.chunkSize += n3;
            this.chunkOffset = n4;
            if (this.chunkSampleCount >= 16) {
                this.outputPendingSampleMetadata(track);
            }
        }

        public void startSample(ExtractorInput extractorInput) throws IOException {
            if (this.foundSyncframe) {
                return;
            }
            extractorInput.peekFully(this.syncframePrefix, 0, 10);
            extractorInput.resetPeekPosition();
            if (Ac3Util.parseTrueHdSyncframeAudioSampleCount(this.syncframePrefix) == 0) {
                return;
            }
            this.foundSyncframe = true;
        }
    }
}

