/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.flv;

import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.extractor.IndexSeekMap;
import com.google.android.exoplayer2.extractor.PositionHolder;
import com.google.android.exoplayer2.extractor.SeekMap;
import com.google.android.exoplayer2.extractor.flv.AudioTagPayloadReader;
import com.google.android.exoplayer2.extractor.flv.ScriptTagPayloadReader;
import com.google.android.exoplayer2.extractor.flv.VideoTagPayloadReader;
import com.google.android.exoplayer2.extractor.flv._$$Lambda$FlvExtractor$bd1zICO7f_FQot_hbozdu7LjVyE;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ParsableByteArray;
import java.io.IOException;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

public final class FlvExtractor
implements Extractor {
    public static final ExtractorsFactory FACTORY = _$$Lambda$FlvExtractor$bd1zICO7f_FQot_hbozdu7LjVyE.INSTANCE;
    private static final int FLV_HEADER_SIZE = 9;
    private static final int FLV_TAG = 4607062;
    private static final int FLV_TAG_HEADER_SIZE = 11;
    private static final int STATE_READING_FLV_HEADER = 1;
    private static final int STATE_READING_TAG_DATA = 4;
    private static final int STATE_READING_TAG_HEADER = 3;
    private static final int STATE_SKIPPING_TO_TAG_HEADER = 2;
    private static final int TAG_TYPE_AUDIO = 8;
    private static final int TAG_TYPE_SCRIPT_DATA = 18;
    private static final int TAG_TYPE_VIDEO = 9;
    private AudioTagPayloadReader audioReader;
    private int bytesToNextTagHeader;
    private ExtractorOutput extractorOutput;
    private final ParsableByteArray headerBuffer;
    private long mediaTagTimestampOffsetUs;
    private final ScriptTagPayloadReader metadataReader;
    private boolean outputFirstSample;
    private boolean outputSeekMap;
    private final ParsableByteArray scratch = new ParsableByteArray(4);
    private int state = 1;
    private final ParsableByteArray tagData;
    private int tagDataSize;
    private final ParsableByteArray tagHeaderBuffer;
    private long tagTimestampUs;
    private int tagType;
    private VideoTagPayloadReader videoReader;

    public FlvExtractor() {
        this.headerBuffer = new ParsableByteArray(9);
        this.tagHeaderBuffer = new ParsableByteArray(11);
        this.tagData = new ParsableByteArray();
        this.metadataReader = new ScriptTagPayloadReader();
    }

    @RequiresNonNull(value={"extractorOutput"})
    private void ensureReadyForMediaOutput() {
        if (!this.outputSeekMap) {
            this.extractorOutput.seekMap(new SeekMap.Unseekable(-9223372036854775807L));
            this.outputSeekMap = true;
        }
    }

    private long getCurrentTimestampUs() {
        long l2 = this.outputFirstSample ? this.mediaTagTimestampOffsetUs + this.tagTimestampUs : (this.metadataReader.getDurationUs() == -9223372036854775807L ? 0L : this.tagTimestampUs);
        return l2;
    }

    static /* synthetic */ Extractor[] lambda$static$0() {
        return new Extractor[]{new FlvExtractor()};
    }

    private ParsableByteArray prepareTagData(ExtractorInput extractorInput) throws IOException {
        if (this.tagDataSize > this.tagData.capacity()) {
            ParsableByteArray parsableByteArray = this.tagData;
            parsableByteArray.reset(new byte[Math.max(parsableByteArray.capacity() * 2, this.tagDataSize)], 0);
        } else {
            this.tagData.setPosition(0);
        }
        this.tagData.setLimit(this.tagDataSize);
        extractorInput.readFully(this.tagData.getData(), 0, this.tagDataSize);
        return this.tagData;
    }

    @RequiresNonNull(value={"extractorOutput"})
    private boolean readFlvHeader(ExtractorInput extractorInput) throws IOException {
        byte[] byArray = this.headerBuffer.getData();
        boolean bl = false;
        if (!extractorInput.readFully(byArray, 0, 9, true)) {
            return false;
        }
        this.headerBuffer.setPosition(0);
        this.headerBuffer.skipBytes(4);
        int n2 = this.headerBuffer.readUnsignedByte();
        boolean bl2 = (n2 & 4) != 0;
        if ((n2 & 1) != 0) {
            bl = true;
        }
        if (bl2 && this.audioReader == null) {
            this.audioReader = new AudioTagPayloadReader(this.extractorOutput.track(8, 1));
        }
        if (bl && this.videoReader == null) {
            this.videoReader = new VideoTagPayloadReader(this.extractorOutput.track(9, 2));
        }
        this.extractorOutput.endTracks();
        this.bytesToNextTagHeader = this.headerBuffer.readInt() - 9 + 4;
        this.state = 2;
        return true;
    }

    /*
     * Unable to fully structure code
     */
    @RequiresNonNull(value={"extractorOutput"})
    private boolean readTagData(ExtractorInput var1_1) throws IOException {
        block3: {
            block5: {
                block4: {
                    var2_2 = this.getCurrentTimestampUs();
                    var4_3 = this.tagType;
                    var5_4 = false;
                    if (var4_3 == 8 && this.audioReader != null) {
                        this.ensureReadyForMediaOutput();
                        var5_4 = this.audioReader.consume(this.prepareTagData(var1_1), var2_2);
lbl7:
                        // 4 sources

                        while (true) {
                            var6_5 = true;
                            break block3;
                            break;
                        }
                    }
                    if (this.tagType != 9 || this.videoReader == null) break block4;
                    this.ensureReadyForMediaOutput();
                    var5_4 = this.videoReader.consume(this.prepareTagData(var1_1), var2_2);
                    ** GOTO lbl7
                }
                if (this.tagType != 18 || this.outputSeekMap) break block5;
                var6_5 = this.metadataReader.consume(this.prepareTagData(var1_1), var2_2);
                var2_2 = this.metadataReader.getDurationUs();
                var5_4 = var6_5;
                if (var2_2 == -9223372036854775807L) ** GOTO lbl7
                this.extractorOutput.seekMap((SeekMap)new IndexSeekMap(this.metadataReader.getKeyFrameTagPositions(), this.metadataReader.getKeyFrameTimesUs(), var2_2));
                this.outputSeekMap = true;
                var5_4 = var6_5;
                ** while (true)
            }
            var1_1.skipFully(this.tagDataSize);
            var6_5 = false;
        }
        if (!this.outputFirstSample && var5_4) {
            this.outputFirstSample = true;
            var2_2 = this.metadataReader.getDurationUs() == -9223372036854775807L ? -this.tagTimestampUs : 0L;
            this.mediaTagTimestampOffsetUs = var2_2;
        }
        this.bytesToNextTagHeader = 4;
        this.state = 2;
        return var6_5;
    }

    private boolean readTagHeader(ExtractorInput extractorInput) throws IOException {
        if (!extractorInput.readFully(this.tagHeaderBuffer.getData(), 0, 11, true)) {
            return false;
        }
        this.tagHeaderBuffer.setPosition(0);
        this.tagType = this.tagHeaderBuffer.readUnsignedByte();
        this.tagDataSize = this.tagHeaderBuffer.readUnsignedInt24();
        this.tagTimestampUs = this.tagHeaderBuffer.readUnsignedInt24();
        this.tagTimestampUs = ((long)(this.tagHeaderBuffer.readUnsignedByte() << 24) | this.tagTimestampUs) * 1000L;
        this.tagHeaderBuffer.skipBytes(3);
        this.state = 4;
        return true;
    }

    private void skipToTagHeader(ExtractorInput extractorInput) throws IOException {
        extractorInput.skipFully(this.bytesToNextTagHeader);
        this.bytesToNextTagHeader = 0;
        this.state = 3;
    }

    @Override
    public void init(ExtractorOutput extractorOutput) {
        this.extractorOutput = extractorOutput;
    }

    @Override
    public int read(ExtractorInput extractorInput, PositionHolder positionHolder) throws IOException {
        Assertions.checkStateNotNull(this.extractorOutput);
        while (true) {
            int n2;
            if ((n2 = this.state) != 1) {
                if (n2 != 2) {
                    if (n2 != 3) {
                        if (n2 == 4) {
                            if (!this.readTagData(extractorInput)) continue;
                            return 0;
                        }
                        throw new IllegalStateException();
                    }
                    if (this.readTagHeader(extractorInput)) continue;
                    return -1;
                }
                this.skipToTagHeader(extractorInput);
                continue;
            }
            if (!this.readFlvHeader(extractorInput)) break;
        }
        return -1;
    }

    @Override
    public void release() {
    }

    @Override
    public void seek(long l2, long l3) {
        if (l2 == 0L) {
            this.state = 1;
            this.outputFirstSample = false;
        } else {
            this.state = 3;
        }
        this.bytesToNextTagHeader = 0;
    }

    @Override
    public boolean sniff(ExtractorInput extractorInput) throws IOException {
        byte[] byArray = this.scratch.getData();
        boolean bl = false;
        extractorInput.peekFully(byArray, 0, 3);
        this.scratch.setPosition(0);
        if (this.scratch.readUnsignedInt24() != 4607062) {
            return false;
        }
        extractorInput.peekFully(this.scratch.getData(), 0, 2);
        this.scratch.setPosition(0);
        if ((this.scratch.readUnsignedShort() & 0xFA) != 0) {
            return false;
        }
        extractorInput.peekFully(this.scratch.getData(), 0, 4);
        this.scratch.setPosition(0);
        int n2 = this.scratch.readInt();
        extractorInput.resetPeekPosition();
        extractorInput.advancePeekPosition(n2);
        extractorInput.peekFully(this.scratch.getData(), 0, 4);
        this.scratch.setPosition(0);
        if (this.scratch.readInt() == 0) {
            bl = true;
        }
        return bl;
    }
}

