/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.flac;

import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.extractor.FlacFrameReader;
import com.google.android.exoplayer2.extractor.FlacMetadataReader;
import com.google.android.exoplayer2.extractor.FlacSeekTableSeekMap;
import com.google.android.exoplayer2.extractor.FlacStreamMetadata;
import com.google.android.exoplayer2.extractor.PositionHolder;
import com.google.android.exoplayer2.extractor.SeekMap;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.extractor.flac.FlacBinarySearchSeeker;
import com.google.android.exoplayer2.extractor.flac._$$Lambda$FlacExtractor$s_dEgsGVCd_BzIvx_5aQStDOj3c;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class FlacExtractor
implements Extractor {
    private static final int BUFFER_LENGTH = 32768;
    public static final ExtractorsFactory FACTORY = _$$Lambda$FlacExtractor$s_dEgsGVCd_BzIvx_5aQStDOj3c.INSTANCE;
    public static final int FLAG_DISABLE_ID3_METADATA = 1;
    private static final int SAMPLE_NUMBER_UNKNOWN = -1;
    private static final int STATE_GET_FRAME_START_MARKER = 4;
    private static final int STATE_GET_STREAM_MARKER_AND_INFO_BLOCK_BYTES = 1;
    private static final int STATE_READ_FRAMES = 5;
    private static final int STATE_READ_ID3_METADATA = 0;
    private static final int STATE_READ_METADATA_BLOCKS = 3;
    private static final int STATE_READ_STREAM_MARKER = 2;
    private FlacBinarySearchSeeker binarySearchSeeker;
    private final ParsableByteArray buffer;
    private int currentFrameBytesWritten;
    private long currentFrameFirstSampleNumber;
    private ExtractorOutput extractorOutput;
    private FlacStreamMetadata flacStreamMetadata;
    private int frameStartMarker;
    private Metadata id3Metadata;
    private final boolean id3MetadataDisabled;
    private int minFrameSize;
    private final FlacFrameReader.SampleNumberHolder sampleNumberHolder;
    private int state;
    private final byte[] streamMarkerAndInfoBlock = new byte[42];
    private TrackOutput trackOutput;

    public FlacExtractor() {
        this(0);
    }

    public FlacExtractor(int n2) {
        this.buffer = new ParsableByteArray(new byte[32768], 0);
        boolean bl = true;
        if ((n2 & 1) == 0) {
            bl = false;
        }
        this.id3MetadataDisabled = bl;
        this.sampleNumberHolder = new FlacFrameReader.SampleNumberHolder();
        this.state = 0;
    }

    private long findFrame(ParsableByteArray parsableByteArray, boolean bl) {
        int n2;
        Assertions.checkNotNull(this.flacStreamMetadata);
        for (n2 = parsableByteArray.getPosition(); n2 <= parsableByteArray.limit() - 16; ++n2) {
            parsableByteArray.setPosition(n2);
            if (!FlacFrameReader.checkAndReadFrameHeader((ParsableByteArray)parsableByteArray, (FlacStreamMetadata)this.flacStreamMetadata, (int)this.frameStartMarker, (FlacFrameReader.SampleNumberHolder)this.sampleNumberHolder)) continue;
            parsableByteArray.setPosition(n2);
            return this.sampleNumberHolder.sampleNumber;
        }
        if (bl) {
            while (n2 <= parsableByteArray.limit() - this.minFrameSize) {
                parsableByteArray.setPosition(n2);
                boolean bl2 = false;
                try {
                    bl = FlacFrameReader.checkAndReadFrameHeader((ParsableByteArray)parsableByteArray, (FlacStreamMetadata)this.flacStreamMetadata, (int)this.frameStartMarker, (FlacFrameReader.SampleNumberHolder)this.sampleNumberHolder);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    bl = false;
                }
                if (parsableByteArray.getPosition() > parsableByteArray.limit()) {
                    bl = bl2;
                }
                if (bl) {
                    parsableByteArray.setPosition(n2);
                    return this.sampleNumberHolder.sampleNumber;
                }
                ++n2;
            }
            parsableByteArray.setPosition(parsableByteArray.limit());
        } else {
            parsableByteArray.setPosition(n2);
        }
        return -1L;
    }

    private void getFrameStartMarker(ExtractorInput extractorInput) throws IOException {
        this.frameStartMarker = FlacMetadataReader.getFrameStartMarker((ExtractorInput)extractorInput);
        Util.castNonNull(this.extractorOutput).seekMap(this.getSeekMap(extractorInput.getPosition(), extractorInput.getLength()));
        this.state = 5;
    }

    private SeekMap getSeekMap(long l2, long l3) {
        Assertions.checkNotNull(this.flacStreamMetadata);
        if (this.flacStreamMetadata.seekTable != null) {
            return new FlacSeekTableSeekMap(this.flacStreamMetadata, l2);
        }
        if (l3 != -1L && this.flacStreamMetadata.totalSamples > 0L) {
            this.binarySearchSeeker = new FlacBinarySearchSeeker(this.flacStreamMetadata, this.frameStartMarker, l2, l3);
            return this.binarySearchSeeker.getSeekMap();
        }
        return new SeekMap.Unseekable(this.flacStreamMetadata.getDurationUs());
    }

    private void getStreamMarkerAndInfoBlockBytes(ExtractorInput extractorInput) throws IOException {
        byte[] byArray = this.streamMarkerAndInfoBlock;
        extractorInput.peekFully(byArray, 0, byArray.length);
        extractorInput.resetPeekPosition();
        this.state = 2;
    }

    static /* synthetic */ Extractor[] lambda$static$0() {
        return new Extractor[]{new FlacExtractor()};
    }

    private void outputSampleMetadata() {
        long l2 = this.currentFrameFirstSampleNumber * 1000000L / (long)Util.castNonNull(this.flacStreamMetadata).sampleRate;
        Util.castNonNull(this.trackOutput).sampleMetadata(l2, 1, this.currentFrameBytesWritten, 0, null);
    }

    private int readFrames(ExtractorInput extractorInput, PositionHolder positionHolder) throws IOException {
        boolean bl;
        int n2;
        Assertions.checkNotNull(this.trackOutput);
        Assertions.checkNotNull(this.flacStreamMetadata);
        FlacBinarySearchSeeker flacBinarySearchSeeker = this.binarySearchSeeker;
        if (flacBinarySearchSeeker != null && flacBinarySearchSeeker.isSeeking()) {
            return this.binarySearchSeeker.handlePendingSeek(extractorInput, positionHolder);
        }
        if (this.currentFrameFirstSampleNumber == -1L) {
            this.currentFrameFirstSampleNumber = FlacFrameReader.getFirstSampleNumber((ExtractorInput)extractorInput, (FlacStreamMetadata)this.flacStreamMetadata);
            return 0;
        }
        int n3 = this.buffer.limit();
        if (n3 < 32768) {
            n2 = extractorInput.read(this.buffer.getData(), n3, 32768 - n3);
            bl = n2 == -1;
            if (!bl) {
                this.buffer.setLimit(n3 + n2);
            } else if (this.buffer.bytesLeft() == 0) {
                this.outputSampleMetadata();
                return -1;
            }
        } else {
            bl = false;
        }
        n2 = this.buffer.getPosition();
        int n4 = this.currentFrameBytesWritten;
        n3 = this.minFrameSize;
        if (n4 < n3) {
            extractorInput = this.buffer;
            extractorInput.skipBytes(Math.min(n3 - n4, extractorInput.bytesLeft()));
        }
        long l2 = this.findFrame(this.buffer, bl);
        n3 = this.buffer.getPosition() - n2;
        this.buffer.setPosition(n2);
        this.trackOutput.sampleData(this.buffer, n3);
        this.currentFrameBytesWritten += n3;
        if (l2 != -1L) {
            this.outputSampleMetadata();
            this.currentFrameBytesWritten = 0;
            this.currentFrameFirstSampleNumber = l2;
        }
        if (this.buffer.bytesLeft() < 16) {
            n2 = this.buffer.bytesLeft();
            System.arraycopy(this.buffer.getData(), this.buffer.getPosition(), this.buffer.getData(), 0, n2);
            this.buffer.setPosition(0);
            this.buffer.setLimit(n2);
        }
        return 0;
    }

    private void readId3Metadata(ExtractorInput extractorInput) throws IOException {
        this.id3Metadata = FlacMetadataReader.readId3Metadata((ExtractorInput)extractorInput, (boolean)(this.id3MetadataDisabled ^ true));
        this.state = 1;
    }

    private void readMetadataBlocks(ExtractorInput extractorInput) throws IOException {
        FlacMetadataReader.FlacStreamMetadataHolder flacStreamMetadataHolder = new FlacMetadataReader.FlacStreamMetadataHolder(this.flacStreamMetadata);
        boolean bl = false;
        while (!bl) {
            bl = FlacMetadataReader.readMetadataBlock((ExtractorInput)extractorInput, (FlacMetadataReader.FlacStreamMetadataHolder)flacStreamMetadataHolder);
            this.flacStreamMetadata = Util.castNonNull(flacStreamMetadataHolder.flacStreamMetadata);
        }
        Assertions.checkNotNull(this.flacStreamMetadata);
        this.minFrameSize = Math.max(this.flacStreamMetadata.minFrameSize, 6);
        Util.castNonNull(this.trackOutput).format(this.flacStreamMetadata.getFormat(this.streamMarkerAndInfoBlock, this.id3Metadata));
        this.state = 4;
    }

    private void readStreamMarker(ExtractorInput extractorInput) throws IOException {
        FlacMetadataReader.readStreamMarker((ExtractorInput)extractorInput);
        this.state = 3;
    }

    @Override
    public void init(ExtractorOutput extractorOutput) {
        this.extractorOutput = extractorOutput;
        this.trackOutput = extractorOutput.track(0, 1);
        extractorOutput.endTracks();
    }

    @Override
    public int read(ExtractorInput extractorInput, PositionHolder positionHolder) throws IOException {
        int n2 = this.state;
        if (n2 != 0) {
            if (n2 != 1) {
                if (n2 != 2) {
                    if (n2 != 3) {
                        if (n2 != 4) {
                            if (n2 == 5) {
                                return this.readFrames(extractorInput, positionHolder);
                            }
                            throw new IllegalStateException();
                        }
                        this.getFrameStartMarker(extractorInput);
                        return 0;
                    }
                    this.readMetadataBlocks(extractorInput);
                    return 0;
                }
                this.readStreamMarker(extractorInput);
                return 0;
            }
            this.getStreamMarkerAndInfoBlockBytes(extractorInput);
            return 0;
        }
        this.readId3Metadata(extractorInput);
        return 0;
    }

    @Override
    public void release() {
    }

    @Override
    public void seek(long l2, long l3) {
        long l4 = 0L;
        if (l2 == 0L) {
            this.state = 0;
        } else {
            FlacBinarySearchSeeker flacBinarySearchSeeker = this.binarySearchSeeker;
            if (flacBinarySearchSeeker != null) {
                flacBinarySearchSeeker.setSeekTargetUs(l3);
            }
        }
        l2 = l3 == 0L ? l4 : -1L;
        this.currentFrameFirstSampleNumber = l2;
        this.currentFrameBytesWritten = 0;
        this.buffer.reset(0);
    }

    @Override
    public boolean sniff(ExtractorInput extractorInput) throws IOException {
        FlacMetadataReader.peekId3Metadata((ExtractorInput)extractorInput, (boolean)false);
        return FlacMetadataReader.checkAndPeekStreamMarker((ExtractorInput)extractorInput);
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Flags {
    }
}

