/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.flac;

import com.google.android.exoplayer2.extractor.BinarySearchSeeker;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.FlacFrameReader;
import com.google.android.exoplayer2.extractor.FlacStreamMetadata;
import com.google.android.exoplayer2.extractor.flac._$$Lambda$RZnT0uiLg1lxLrLWgcUlQQYkZkE;
import java.io.IOException;
import java.util.Objects;

final class FlacBinarySearchSeeker
extends BinarySearchSeeker {
    public FlacBinarySearchSeeker(FlacStreamMetadata flacStreamMetadata, int n2, long l2, long l3) {
        Objects.requireNonNull(flacStreamMetadata);
        super((BinarySearchSeeker.SeekTimestampConverter)new _$$Lambda$RZnT0uiLg1lxLrLWgcUlQQYkZkE(flacStreamMetadata), (BinarySearchSeeker.TimestampSeeker)new FlacTimestampSeeker(flacStreamMetadata, n2), flacStreamMetadata.getDurationUs(), 0L, flacStreamMetadata.totalSamples, l2, l3, flacStreamMetadata.getApproxBytesPerFrame(), Math.max(6, flacStreamMetadata.minFrameSize));
    }

    private static final class FlacTimestampSeeker
    implements BinarySearchSeeker.TimestampSeeker {
        private final FlacStreamMetadata flacStreamMetadata;
        private final int frameStartMarker;
        private final FlacFrameReader.SampleNumberHolder sampleNumberHolder;

        private FlacTimestampSeeker(FlacStreamMetadata flacStreamMetadata, int n2) {
            this.flacStreamMetadata = flacStreamMetadata;
            this.frameStartMarker = n2;
            this.sampleNumberHolder = new FlacFrameReader.SampleNumberHolder();
        }

        private long findNextFrame(ExtractorInput extractorInput) throws IOException {
            while (extractorInput.getPeekPosition() < extractorInput.getLength() - 6L && !FlacFrameReader.checkFrameHeaderFromPeek((ExtractorInput)extractorInput, (FlacStreamMetadata)this.flacStreamMetadata, (int)this.frameStartMarker, (FlacFrameReader.SampleNumberHolder)this.sampleNumberHolder)) {
                extractorInput.advancePeekPosition(1);
            }
            if (extractorInput.getPeekPosition() >= extractorInput.getLength() - 6L) {
                extractorInput.advancePeekPosition((int)(extractorInput.getLength() - extractorInput.getPeekPosition()));
                return this.flacStreamMetadata.totalSamples;
            }
            return this.sampleNumberHolder.sampleNumber;
        }

        public /* synthetic */ void onSeekFinished() {
            BinarySearchSeeker.TimestampSeeker._CC.$default$onSeekFinished((BinarySearchSeeker.TimestampSeeker)this);
        }

        public BinarySearchSeeker.TimestampSearchResult searchForTimestamp(ExtractorInput extractorInput, long l2) throws IOException {
            long l3 = extractorInput.getPosition();
            long l4 = this.findNextFrame(extractorInput);
            long l5 = extractorInput.getPeekPosition();
            extractorInput.advancePeekPosition(Math.max(6, this.flacStreamMetadata.minFrameSize));
            long l6 = this.findNextFrame(extractorInput);
            long l7 = extractorInput.getPeekPosition();
            if (l4 <= l2 && l6 > l2) {
                return BinarySearchSeeker.TimestampSearchResult.targetFoundResult((long)l5);
            }
            if (l6 <= l2) {
                return BinarySearchSeeker.TimestampSearchResult.underestimatedResult((long)l6, (long)l7);
            }
            return BinarySearchSeeker.TimestampSearchResult.overestimatedResult((long)l4, (long)l3);
        }
    }
}

