/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.amr;

import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.extractor.ConstantBitrateSeekMap;
import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.extractor.PositionHolder;
import com.google.android.exoplayer2.extractor.SeekMap;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.extractor.amr._$$Lambda$AmrExtractor$lVuGuaAcylUV__XE4_hSR1hBylI;
import com.google.android.exoplayer2.upstream.DataReader;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.io.EOFException;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

public final class AmrExtractor
implements Extractor {
    public static final ExtractorsFactory FACTORY = _$$Lambda$AmrExtractor$lVuGuaAcylUV__XE4_hSR1hBylI.INSTANCE;
    public static final int FLAG_ENABLE_CONSTANT_BITRATE_SEEKING = 1;
    private static final int MAX_FRAME_SIZE_BYTES;
    private static final int NUM_SAME_SIZE_CONSTANT_BIT_RATE_THRESHOLD = 20;
    private static final int SAMPLE_RATE_NB = 8000;
    private static final int SAMPLE_RATE_WB = 16000;
    private static final int SAMPLE_TIME_PER_FRAME_US = 20000;
    private static final byte[] amrSignatureNb;
    private static final byte[] amrSignatureWb;
    private static final int[] frameSizeBytesByTypeNb;
    private static final int[] frameSizeBytesByTypeWb;
    private int currentSampleBytesRemaining;
    private int currentSampleSize;
    private long currentSampleTimeUs;
    private ExtractorOutput extractorOutput;
    private long firstSamplePosition;
    private int firstSampleSize;
    private final int flags;
    private boolean hasOutputFormat;
    private boolean hasOutputSeekMap;
    private boolean isWideBand;
    private int numSamplesWithSameSize;
    private final byte[] scratch;
    private SeekMap seekMap;
    private long timeOffsetUs;
    private TrackOutput trackOutput;

    static {
        frameSizeBytesByTypeNb = new int[]{13, 14, 16, 18, 20, 21, 27, 32, 6, 7, 6, 6, 1, 1, 1, 1};
        frameSizeBytesByTypeWb = new int[]{18, 24, 33, 37, 41, 47, 51, 59, 61, 6, 1, 1, 1, 1, 1, 1};
        amrSignatureNb = Util.getUtf8Bytes("#!AMR\n");
        amrSignatureWb = Util.getUtf8Bytes("#!AMR-WB\n");
        MAX_FRAME_SIZE_BYTES = frameSizeBytesByTypeWb[8];
    }

    public AmrExtractor() {
        this(0);
    }

    public AmrExtractor(int n2) {
        this.flags = n2;
        this.scratch = new byte[1];
        this.firstSampleSize = -1;
    }

    static byte[] amrSignatureNb() {
        byte[] byArray = amrSignatureNb;
        return Arrays.copyOf(byArray, byArray.length);
    }

    static byte[] amrSignatureWb() {
        byte[] byArray = amrSignatureWb;
        return Arrays.copyOf(byArray, byArray.length);
    }

    @EnsuresNonNull(value={"extractorOutput", "trackOutput"})
    private void assertInitialized() {
        Assertions.checkStateNotNull(this.trackOutput);
        Util.castNonNull(this.extractorOutput);
    }

    static int frameSizeBytesByTypeNb(int n2) {
        return frameSizeBytesByTypeNb[n2];
    }

    static int frameSizeBytesByTypeWb(int n2) {
        return frameSizeBytesByTypeWb[n2];
    }

    private static int getBitrateFromFrameSize(int n2, long l2) {
        return (int)((long)(n2 * 8) * 1000000L / l2);
    }

    private SeekMap getConstantBitrateSeekMap(long l2) {
        int n2 = AmrExtractor.getBitrateFromFrameSize(this.firstSampleSize, 20000L);
        return new ConstantBitrateSeekMap(l2, this.firstSamplePosition, n2, this.firstSampleSize);
    }

    private int getFrameSizeInBytes(int n2) throws ParserException {
        if (!this.isValidFrameType(n2)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Illegal AMR ");
            String string2 = this.isWideBand ? "WB" : "NB";
            stringBuilder.append(string2);
            stringBuilder.append(" frame type ");
            stringBuilder.append(n2);
            throw new ParserException(stringBuilder.toString());
        }
        n2 = this.isWideBand ? frameSizeBytesByTypeWb[n2] : frameSizeBytesByTypeNb[n2];
        return n2;
    }

    private boolean isNarrowBandValidFrameType(int n2) {
        boolean bl = !this.isWideBand && (n2 < 12 || n2 > 14);
        return bl;
    }

    private boolean isValidFrameType(int n2) {
        boolean bl = n2 >= 0 && n2 <= 15 && (this.isWideBandValidFrameType(n2) || this.isNarrowBandValidFrameType(n2));
        return bl;
    }

    private boolean isWideBandValidFrameType(int n2) {
        boolean bl = this.isWideBand && (n2 < 10 || n2 > 13);
        return bl;
    }

    static /* synthetic */ Extractor[] lambda$static$0() {
        return new Extractor[]{new AmrExtractor()};
    }

    @RequiresNonNull(value={"trackOutput"})
    private void maybeOutputFormat() {
        if (!this.hasOutputFormat) {
            this.hasOutputFormat = true;
            String string2 = this.isWideBand ? "audio/amr-wb" : "audio/3gpp";
            int n2 = this.isWideBand ? 16000 : 8000;
            this.trackOutput.format(new Format.Builder().setSampleMimeType(string2).setMaxInputSize(MAX_FRAME_SIZE_BYTES).setChannelCount(1).setSampleRate(n2).build());
        }
    }

    @RequiresNonNull(value={"extractorOutput"})
    private void maybeOutputSeekMap(long l2, int n2) {
        int n3;
        if (this.hasOutputSeekMap) {
            return;
        }
        if ((this.flags & 1) != 0 && l2 != -1L && ((n3 = this.firstSampleSize) == -1 || n3 == this.currentSampleSize)) {
            if (this.numSamplesWithSameSize >= 20 || n2 == -1) {
                this.seekMap = this.getConstantBitrateSeekMap(l2);
                this.extractorOutput.seekMap(this.seekMap);
                this.hasOutputSeekMap = true;
            }
        } else {
            this.seekMap = new SeekMap.Unseekable(-9223372036854775807L);
            this.extractorOutput.seekMap(this.seekMap);
            this.hasOutputSeekMap = true;
        }
    }

    private static boolean peekAmrSignature(ExtractorInput extractorInput, byte[] byArray) throws IOException {
        extractorInput.resetPeekPosition();
        byte[] byArray2 = new byte[byArray.length];
        extractorInput.peekFully(byArray2, 0, byArray.length);
        return Arrays.equals(byArray2, byArray);
    }

    private int peekNextSampleSize(ExtractorInput object) throws IOException {
        object.resetPeekPosition();
        object.peekFully(this.scratch, 0, 1);
        byte by2 = this.scratch[0];
        if ((by2 & 0x83) <= 0) {
            return this.getFrameSizeInBytes(by2 >> 3 & 0xF);
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Invalid padding bits for frame header ");
        ((StringBuilder)object).append(by2);
        throw new ParserException(((StringBuilder)object).toString());
    }

    private boolean readAmrHeader(ExtractorInput extractorInput) throws IOException {
        if (AmrExtractor.peekAmrSignature(extractorInput, amrSignatureNb)) {
            this.isWideBand = false;
            extractorInput.skipFully(amrSignatureNb.length);
            return true;
        }
        if (AmrExtractor.peekAmrSignature(extractorInput, amrSignatureWb)) {
            this.isWideBand = true;
            extractorInput.skipFully(amrSignatureWb.length);
            return true;
        }
        return false;
    }

    @RequiresNonNull(value={"trackOutput"})
    private int readSample(ExtractorInput extractorInput) throws IOException {
        int n2;
        if (this.currentSampleBytesRemaining == 0) {
            block6: {
                try {
                    this.currentSampleBytesRemaining = this.currentSampleSize = this.peekNextSampleSize(extractorInput);
                    if (this.firstSampleSize != -1) break block6;
                }
                catch (EOFException eOFException) {
                    return -1;
                }
                this.firstSamplePosition = extractorInput.getPosition();
                this.firstSampleSize = this.currentSampleSize;
            }
            if (this.firstSampleSize == this.currentSampleSize) {
                ++this.numSamplesWithSameSize;
            }
        }
        if ((n2 = this.trackOutput.sampleData((DataReader)extractorInput, this.currentSampleBytesRemaining, true)) == -1) {
            return -1;
        }
        this.currentSampleBytesRemaining -= n2;
        if (this.currentSampleBytesRemaining > 0) {
            return 0;
        }
        this.trackOutput.sampleMetadata(this.timeOffsetUs + this.currentSampleTimeUs, 1, this.currentSampleSize, 0, null);
        this.currentSampleTimeUs += 20000L;
        return 0;
    }

    @Override
    public void init(ExtractorOutput extractorOutput) {
        this.extractorOutput = extractorOutput;
        this.trackOutput = extractorOutput.track(0, 1);
        extractorOutput.endTracks();
    }

    @Override
    public int read(ExtractorInput extractorInput, PositionHolder positionHolder) throws IOException {
        this.assertInitialized();
        if (extractorInput.getPosition() == 0L && !this.readAmrHeader(extractorInput)) {
            throw new ParserException("Could not find AMR header.");
        }
        this.maybeOutputFormat();
        int n2 = this.readSample(extractorInput);
        this.maybeOutputSeekMap(extractorInput.getLength(), n2);
        return n2;
    }

    @Override
    public void release() {
    }

    @Override
    public void seek(long l2, long l3) {
        SeekMap seekMap;
        this.currentSampleTimeUs = 0L;
        this.currentSampleSize = 0;
        this.currentSampleBytesRemaining = 0;
        this.timeOffsetUs = l2 != 0L && (seekMap = this.seekMap) instanceof ConstantBitrateSeekMap ? ((ConstantBitrateSeekMap)seekMap).getTimeUsAtPosition(l2) : 0L;
    }

    @Override
    public boolean sniff(ExtractorInput extractorInput) throws IOException {
        return this.readAmrHeader(extractorInput);
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Flags {
    }
}

