/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor;

import com.google.android.exoplayer2.extractor.SeekPoint;
import com.google.android.exoplayer2.util.Assertions;

public interface SeekMap {
    public long getDurationUs();

    public SeekPoints getSeekPoints(long var1);

    public boolean isSeekable();

    public static final class SeekPoints {
        public final SeekPoint first;
        public final SeekPoint second;

        public SeekPoints(SeekPoint seekPoint) {
            this(seekPoint, seekPoint);
        }

        public SeekPoints(SeekPoint seekPoint, SeekPoint seekPoint2) {
            this.first = Assertions.checkNotNull(seekPoint);
            this.second = Assertions.checkNotNull(seekPoint2);
        }

        public boolean equals(Object object) {
            boolean bl = true;
            if (this == object) {
                return true;
            }
            if (object != null && this.getClass() == object.getClass()) {
                object = (SeekPoints)object;
                if (!this.first.equals((Object)((SeekPoints)object).first) || !this.second.equals((Object)((SeekPoints)object).second)) {
                    bl = false;
                }
                return bl;
            }
            return false;
        }

        public int hashCode() {
            return this.first.hashCode() * 31 + this.second.hashCode();
        }

        public String toString() {
            CharSequence charSequence;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[");
            stringBuilder.append(this.first);
            if (this.first.equals((Object)this.second)) {
                charSequence = "";
            } else {
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append(", ");
                ((StringBuilder)charSequence).append(this.second);
                charSequence = ((StringBuilder)charSequence).toString();
            }
            stringBuilder.append((String)charSequence);
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
    }

    public static class Unseekable
    implements SeekMap {
        private final long durationUs;
        private final SeekPoints startSeekPoints;

        public Unseekable(long l2) {
            this(l2, 0L);
        }

        public Unseekable(long l2, long l3) {
            this.durationUs = l2;
            SeekPoint seekPoint = l3 == 0L ? SeekPoint.START : new SeekPoint(0L, l3);
            this.startSeekPoints = new SeekPoints(seekPoint);
        }

        @Override
        public long getDurationUs() {
            return this.durationUs;
        }

        @Override
        public SeekPoints getSeekPoints(long l2) {
            return this.startSeekPoints;
        }

        @Override
        public boolean isSeekable() {
            return false;
        }
    }
}

