/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor;

import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.metadata.id3.CommentFrame;
import com.google.android.exoplayer2.metadata.id3.InternalFrame;
import com.google.android.exoplayer2.util.Util;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class GaplessInfoHolder {
    private static final Pattern GAPLESS_COMMENT_PATTERN = Pattern.compile("^ [0-9a-fA-F]{8} ([0-9a-fA-F]{8}) ([0-9a-fA-F]{8})");
    private static final String GAPLESS_DESCRIPTION = "iTunSMPB";
    private static final String GAPLESS_DOMAIN = "com.apple.iTunes";
    public int encoderDelay = -1;
    public int encoderPadding = -1;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean setFromComment(String object) {
        if (!((Matcher)(object = GAPLESS_COMMENT_PATTERN.matcher((CharSequence)object))).find()) return false;
        try {
            int n2 = Integer.parseInt(Util.castNonNull(((Matcher)object).group(1)), 16);
            int n3 = Integer.parseInt(Util.castNonNull(((Matcher)object).group(2)), 16);
            if (n2 <= 0) {
                if (n3 <= 0) return false;
            }
            this.encoderDelay = n2;
            this.encoderPadding = n3;
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public boolean hasGaplessInfo() {
        boolean bl = this.encoderDelay != -1 && this.encoderPadding != -1;
        return bl;
    }

    public boolean setFromMetadata(Metadata metadata) {
        for (int i2 = 0; i2 < metadata.length(); ++i2) {
            Object object = metadata.get(i2);
            if (object instanceof CommentFrame) {
                object = (CommentFrame)object;
                if (!GAPLESS_DESCRIPTION.equals(object.description) || !this.setFromComment(object.text)) continue;
                return true;
            }
            if (!(object instanceof InternalFrame)) continue;
            object = (InternalFrame)((Object)object);
            if (!GAPLESS_DOMAIN.equals(object.domain) || !GAPLESS_DESCRIPTION.equals(object.description) || !this.setFromComment(object.text)) continue;
            return true;
        }
        return false;
    }

    public boolean setFromXingHeaderValue(int n2) {
        int n3 = n2 >> 12;
        if (n3 <= 0 && (n2 &= 0xFFF) <= 0) {
            return false;
        }
        this.encoderDelay = n3;
        this.encoderPadding = n2;
        return true;
    }
}

