/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.drm;

import android.media.DeniedByServerException;
import android.media.MediaCryptoException;
import android.media.MediaDrmException;
import android.media.NotProvisionedException;
import android.os.PersistableBundle;
import com.google.android.exoplayer2.drm.DrmInitData;
import com.google.android.exoplayer2.drm.ExoMediaCrypto;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public interface ExoMediaDrm {
    public static final int EVENT_KEY_EXPIRED = 3;
    public static final int EVENT_KEY_REQUIRED = 2;
    public static final int EVENT_PROVISION_REQUIRED = 1;
    public static final int KEY_TYPE_OFFLINE = 2;
    public static final int KEY_TYPE_RELEASE = 3;
    public static final int KEY_TYPE_STREAMING = 1;

    public void acquire();

    public void closeSession(byte[] var1);

    public ExoMediaCrypto createMediaCrypto(byte[] var1) throws MediaCryptoException;

    public Class<? extends ExoMediaCrypto> getExoMediaCryptoType();

    public KeyRequest getKeyRequest(byte[] var1, List<DrmInitData.SchemeData> var2, int var3, HashMap<String, String> var4) throws NotProvisionedException;

    public PersistableBundle getMetrics();

    public byte[] getPropertyByteArray(String var1);

    public String getPropertyString(String var1);

    public ProvisionRequest getProvisionRequest();

    public byte[] openSession() throws MediaDrmException;

    public byte[] provideKeyResponse(byte[] var1, byte[] var2) throws NotProvisionedException, DeniedByServerException;

    public void provideProvisionResponse(byte[] var1) throws DeniedByServerException;

    public Map<String, String> queryKeyStatus(byte[] var1);

    public void release();

    public void restoreKeys(byte[] var1, byte[] var2);

    public void setOnEventListener(OnEventListener var1);

    public void setOnExpirationUpdateListener(OnExpirationUpdateListener var1);

    public void setOnKeyStatusChangeListener(OnKeyStatusChangeListener var1);

    public void setPropertyByteArray(String var1, byte[] var2);

    public void setPropertyString(String var1, String var2);

    public static final class AppManagedProvider
    implements Provider {
        private final ExoMediaDrm exoMediaDrm;

        public AppManagedProvider(ExoMediaDrm exoMediaDrm) {
            this.exoMediaDrm = exoMediaDrm;
        }

        @Override
        public ExoMediaDrm acquireExoMediaDrm(UUID uUID) {
            this.exoMediaDrm.acquire();
            return this.exoMediaDrm;
        }
    }

    public static final class KeyRequest {
        public static final int REQUEST_TYPE_INITIAL = 0;
        public static final int REQUEST_TYPE_NONE = 3;
        public static final int REQUEST_TYPE_RELEASE = 2;
        public static final int REQUEST_TYPE_RENEWAL = 1;
        public static final int REQUEST_TYPE_UNKNOWN = Integer.MIN_VALUE;
        public static final int REQUEST_TYPE_UPDATE = 4;
        private final byte[] data;
        private final String licenseServerUrl;
        private final int requestType;

        public KeyRequest(byte[] byArray, String string2) {
            this(byArray, string2, Integer.MIN_VALUE);
        }

        public KeyRequest(byte[] byArray, String string2, int n2) {
            this.data = byArray;
            this.licenseServerUrl = string2;
            this.requestType = n2;
        }

        public byte[] getData() {
            return this.data;
        }

        public String getLicenseServerUrl() {
            return this.licenseServerUrl;
        }

        public int getRequestType() {
            return this.requestType;
        }

        @Documented
        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface RequestType {
        }
    }

    public static final class KeyStatus {
        private final byte[] keyId;
        private final int statusCode;

        public KeyStatus(int n2, byte[] byArray) {
            this.statusCode = n2;
            this.keyId = byArray;
        }

        public byte[] getKeyId() {
            return this.keyId;
        }

        public int getStatusCode() {
            return this.statusCode;
        }
    }

    public static interface OnEventListener {
        public void onEvent(ExoMediaDrm var1, byte[] var2, int var3, int var4, byte[] var5);
    }

    public static interface OnExpirationUpdateListener {
        public void onExpirationUpdate(ExoMediaDrm var1, byte[] var2, long var3);
    }

    public static interface OnKeyStatusChangeListener {
        public void onKeyStatusChange(ExoMediaDrm var1, byte[] var2, List<KeyStatus> var3, boolean var4);
    }

    public static interface Provider {
        public ExoMediaDrm acquireExoMediaDrm(UUID var1);
    }

    public static final class ProvisionRequest {
        private final byte[] data;
        private final String defaultUrl;

        public ProvisionRequest(byte[] byArray, String string2) {
            this.data = byArray;
            this.defaultUrl = string2;
        }

        public byte[] getData() {
            return this.data;
        }

        public String getDefaultUrl() {
            return this.defaultUrl;
        }
    }
}

