/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.drm;

import android.media.NotProvisionedException;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.util.Pair;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.drm.DrmInitData;
import com.google.android.exoplayer2.drm.DrmSession;
import com.google.android.exoplayer2.drm.DrmSessionEventListener;
import com.google.android.exoplayer2.drm.ExoMediaCrypto;
import com.google.android.exoplayer2.drm.ExoMediaDrm;
import com.google.android.exoplayer2.drm.KeysExpiredException;
import com.google.android.exoplayer2.drm.MediaDrmCallback;
import com.google.android.exoplayer2.drm.MediaDrmCallbackException;
import com.google.android.exoplayer2.drm.WidevineUtil;
import com.google.android.exoplayer2.drm._$$Lambda$BrYRYnbSvqr_udlxRiVssV28H70;
import com.google.android.exoplayer2.drm._$$Lambda$DefaultDrmSession$a0w0vlnYC2_92VXgkqmcQvmjGHk;
import com.google.android.exoplayer2.drm._$$Lambda$HbN0kSVsD6YcIJxw09z6YQauRzY;
import com.google.android.exoplayer2.drm._$$Lambda$Wr1d8d1H59F4_d4ngPgBVhn5KqQ;
import com.google.android.exoplayer2.drm._$$Lambda$pre3sEqF1vViKhCFp1NAV3_mgZk;
import com.google.android.exoplayer2.drm._$$Lambda$tjQ5CTnFVsia_qkXSS552nN0Tmg;
import com.google.android.exoplayer2.source.LoadEventInfo;
import com.google.android.exoplayer2.source.MediaLoadData;
import com.google.android.exoplayer2.upstream.LoadErrorHandlingPolicy;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Consumer;
import com.google.android.exoplayer2.util.CopyOnWriteMultiset;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

class DefaultDrmSession
implements DrmSession {
    private static final int MAX_LICENSE_DURATION_TO_RENEW_SECONDS = 60;
    private static final int MSG_KEYS = 1;
    private static final int MSG_PROVISION = 0;
    private static final String TAG = "DefaultDrmSession";
    final MediaDrmCallback callback;
    private ExoMediaDrm.KeyRequest currentKeyRequest;
    private ExoMediaDrm.ProvisionRequest currentProvisionRequest;
    private final CopyOnWriteMultiset<DrmSessionEventListener.EventDispatcher> eventDispatchers;
    private final boolean isPlaceholderSession;
    private final HashMap<String, String> keyRequestParameters;
    private DrmSession.DrmSessionException lastException;
    private final LoadErrorHandlingPolicy loadErrorHandlingPolicy;
    private ExoMediaCrypto mediaCrypto;
    private final ExoMediaDrm mediaDrm;
    private final int mode;
    private byte[] offlineLicenseKeySetId;
    private final boolean playClearSamplesWithoutKeys;
    private final ProvisioningManager provisioningManager;
    private int referenceCount;
    private final ReferenceCountListener referenceCountListener;
    private RequestHandler requestHandler;
    private HandlerThread requestHandlerThread;
    final ResponseHandler responseHandler;
    public final List<DrmInitData.SchemeData> schemeDatas;
    private byte[] sessionId;
    private int state;
    final UUID uuid;

    public DefaultDrmSession(UUID uUID, ExoMediaDrm exoMediaDrm, ProvisioningManager provisioningManager, ReferenceCountListener referenceCountListener, List<DrmInitData.SchemeData> list, int n2, boolean bl, boolean bl2, byte[] byArray, HashMap<String, String> hashMap, MediaDrmCallback mediaDrmCallback, Looper looper, LoadErrorHandlingPolicy loadErrorHandlingPolicy) {
        if (n2 == 1 || n2 == 3) {
            Assertions.checkNotNull(byArray);
        }
        this.uuid = uUID;
        this.provisioningManager = provisioningManager;
        this.referenceCountListener = referenceCountListener;
        this.mediaDrm = exoMediaDrm;
        this.mode = n2;
        this.playClearSamplesWithoutKeys = bl;
        this.isPlaceholderSession = bl2;
        if (byArray != null) {
            this.offlineLicenseKeySetId = byArray;
            this.schemeDatas = null;
        } else {
            this.schemeDatas = Collections.unmodifiableList(Assertions.checkNotNull(list));
        }
        this.keyRequestParameters = hashMap;
        this.callback = mediaDrmCallback;
        this.eventDispatchers = new CopyOnWriteMultiset();
        this.loadErrorHandlingPolicy = loadErrorHandlingPolicy;
        this.state = 2;
        this.responseHandler = new ResponseHandler(looper);
    }

    private void dispatchEvent(Consumer<DrmSessionEventListener.EventDispatcher> consumer) {
        Iterator iterator2 = this.eventDispatchers.elementSet().iterator();
        while (iterator2.hasNext()) {
            consumer.accept((Object)((DrmSessionEventListener.EventDispatcher)iterator2.next()));
        }
    }

    @RequiresNonNull(value={"sessionId"})
    private void doLicense(boolean bl) {
        if (this.isPlaceholderSession) {
            return;
        }
        byte[] byArray = Util.castNonNull(this.sessionId);
        int n2 = this.mode;
        if (n2 != 0 && n2 != 1) {
            if (n2 != 2) {
                if (n2 == 3) {
                    Assertions.checkNotNull(this.offlineLicenseKeySetId);
                    Assertions.checkNotNull(this.sessionId);
                    if (this.restoreKeys()) {
                        this.postKeyRequest(this.offlineLicenseKeySetId, 3, bl);
                    }
                }
            } else if (this.offlineLicenseKeySetId == null || this.restoreKeys()) {
                this.postKeyRequest(byArray, 2, bl);
            }
        } else if (this.offlineLicenseKeySetId == null) {
            this.postKeyRequest(byArray, 1, bl);
        } else if (this.state == 4 || this.restoreKeys()) {
            long l2 = this.getLicenseDurationRemainingSec();
            if (this.mode == 0 && l2 <= 60L) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Offline license has expired or will expire soon. Remaining seconds: ");
                stringBuilder.append(l2);
                Log.d(TAG, stringBuilder.toString());
                this.postKeyRequest(byArray, 2, bl);
            } else if (l2 <= 0L) {
                this.onError(new KeysExpiredException());
            } else {
                this.state = 4;
                this.dispatchEvent((Consumer<DrmSessionEventListener.EventDispatcher>)_$$Lambda$HbN0kSVsD6YcIJxw09z6YQauRzY.INSTANCE);
            }
        }
    }

    private long getLicenseDurationRemainingSec() {
        if (!C.WIDEVINE_UUID.equals(this.uuid)) {
            return Long.MAX_VALUE;
        }
        Pair pair = Assertions.checkNotNull(WidevineUtil.getLicenseDurationRemainingSec((DrmSession)this));
        return Math.min((Long)pair.first, (Long)pair.second);
    }

    @EnsuresNonNullIf(expression={"sessionId"}, result=true)
    private boolean isOpen() {
        int n2 = this.state;
        boolean bl = n2 == 3 || n2 == 4;
        return bl;
    }

    static /* synthetic */ void lambda$onError$0(Exception exception, DrmSessionEventListener.EventDispatcher eventDispatcher) {
        eventDispatcher.drmSessionManagerError(exception);
    }

    private void onError(Exception exception) {
        this.lastException = new DrmSession.DrmSessionException(exception);
        this.dispatchEvent(new _$$Lambda$DefaultDrmSession$a0w0vlnYC2_92VXgkqmcQvmjGHk(exception));
        if (this.state != 4) {
            this.state = 1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onKeyResponse(Object object, Object object2) {
        if (object != this.currentKeyRequest) return;
        if (!this.isOpen()) {
            return;
        }
        this.currentKeyRequest = null;
        if (object2 instanceof Exception) {
            this.onKeysError((Exception)object2);
            return;
        }
        try {
            object = (byte[])object2;
            if (this.mode == 3) {
                this.mediaDrm.provideKeyResponse(Util.castNonNull(this.offlineLicenseKeySetId), (byte[])object);
                this.dispatchEvent((Consumer<DrmSessionEventListener.EventDispatcher>)_$$Lambda$pre3sEqF1vViKhCFp1NAV3_mgZk.INSTANCE);
                return;
            }
            object = this.mediaDrm.provideKeyResponse(this.sessionId, (byte[])object);
            if ((this.mode == 2 || this.mode == 0 && this.offlineLicenseKeySetId != null) && object != null && ((Object)object).length != 0) {
                this.offlineLicenseKeySetId = (byte[])object;
            }
            this.state = 4;
            this.dispatchEvent((Consumer<DrmSessionEventListener.EventDispatcher>)_$$Lambda$BrYRYnbSvqr_udlxRiVssV28H70.INSTANCE);
            return;
        }
        catch (Exception exception) {
            this.onKeysError(exception);
        }
    }

    private void onKeysError(Exception exception) {
        if (exception instanceof NotProvisionedException) {
            this.provisioningManager.provisionRequired(this);
        } else {
            this.onError(exception);
        }
    }

    private void onKeysRequired() {
        if (this.mode == 0 && this.state == 4) {
            Util.castNonNull(this.sessionId);
            this.doLicense(false);
        }
    }

    private void onProvisionResponse(Object object, Object object2) {
        if (object == this.currentProvisionRequest && (this.state == 2 || this.isOpen())) {
            this.currentProvisionRequest = null;
            if (object2 instanceof Exception) {
                this.provisioningManager.onProvisionError((Exception)object2);
                return;
            }
            try {
                this.mediaDrm.provideProvisionResponse((byte[])object2);
                this.provisioningManager.onProvisionCompleted();
                return;
            }
            catch (Exception exception) {
                this.provisioningManager.onProvisionError(exception);
            }
        }
    }

    @EnsuresNonNullIf(expression={"sessionId"}, result=true)
    private boolean openInternal(boolean bl) {
        if (this.isOpen()) {
            return true;
        }
        try {
            this.sessionId = this.mediaDrm.openSession();
            this.mediaCrypto = this.mediaDrm.createMediaCrypto(this.sessionId);
            this.dispatchEvent((Consumer<DrmSessionEventListener.EventDispatcher>)_$$Lambda$Wr1d8d1H59F4_d4ngPgBVhn5KqQ.INSTANCE);
            this.state = 3;
            Assertions.checkNotNull(this.sessionId);
            return true;
        }
        catch (Exception exception) {
            this.onError(exception);
        }
        catch (NotProvisionedException notProvisionedException) {
            if (bl) {
                this.provisioningManager.provisionRequired(this);
            }
            this.onError((Exception)((Object)notProvisionedException));
        }
        return false;
    }

    private void postKeyRequest(byte[] byArray, int n2, boolean bl) {
        try {
            this.currentKeyRequest = this.mediaDrm.getKeyRequest(byArray, this.schemeDatas, n2, this.keyRequestParameters);
            Util.castNonNull(this.requestHandler).post(1, Assertions.checkNotNull(this.currentKeyRequest), bl);
        }
        catch (Exception exception) {
            this.onKeysError(exception);
        }
    }

    @RequiresNonNull(value={"sessionId", "offlineLicenseKeySetId"})
    private boolean restoreKeys() {
        try {
            this.mediaDrm.restoreKeys(this.sessionId, this.offlineLicenseKeySetId);
            return true;
        }
        catch (Exception exception) {
            Log.e(TAG, "Error trying to restore keys.", exception);
            this.onError(exception);
            return false;
        }
    }

    @Override
    public void acquire(DrmSessionEventListener.EventDispatcher eventDispatcher) {
        int n2 = this.referenceCount;
        boolean bl = false;
        boolean bl2 = n2 >= 0;
        Assertions.checkState(bl2);
        if (eventDispatcher != null) {
            this.eventDispatchers.add((Object)eventDispatcher);
        }
        this.referenceCount = n2 = this.referenceCount + 1;
        if (n2 == 1) {
            bl2 = bl;
            if (this.state == 2) {
                bl2 = true;
            }
            Assertions.checkState(bl2);
            this.requestHandlerThread = new HandlerThread("ExoPlayer:DrmRequestHandler");
            this.requestHandlerThread.start();
            this.requestHandler = new RequestHandler(this.requestHandlerThread.getLooper());
            if (this.openInternal(true)) {
                this.doLicense(true);
            }
        } else if (eventDispatcher != null && this.isOpen()) {
            eventDispatcher.drmSessionAcquired();
        }
        this.referenceCountListener.onReferenceCountIncremented(this, this.referenceCount);
    }

    @Override
    public final DrmSession.DrmSessionException getError() {
        DrmSession.DrmSessionException drmSessionException = this.state == 1 ? this.lastException : null;
        return drmSessionException;
    }

    @Override
    public final ExoMediaCrypto getMediaCrypto() {
        return this.mediaCrypto;
    }

    @Override
    public byte[] getOfflineLicenseKeySetId() {
        return this.offlineLicenseKeySetId;
    }

    @Override
    public final UUID getSchemeUuid() {
        return this.uuid;
    }

    @Override
    public final int getState() {
        return this.state;
    }

    public boolean hasSessionId(byte[] byArray) {
        return Arrays.equals(this.sessionId, byArray);
    }

    public void onMediaDrmEvent(int n2) {
        if (n2 == 2) {
            this.onKeysRequired();
        }
    }

    public void onProvisionCompleted() {
        if (this.openInternal(false)) {
            this.doLicense(true);
        }
    }

    public void onProvisionError(Exception exception) {
        this.onError(exception);
    }

    @Override
    public boolean playClearSamplesWithoutKeys() {
        return this.playClearSamplesWithoutKeys;
    }

    public void provision() {
        this.currentProvisionRequest = this.mediaDrm.getProvisionRequest();
        Util.castNonNull(this.requestHandler).post(0, Assertions.checkNotNull(this.currentProvisionRequest), true);
    }

    @Override
    public Map<String, String> queryKeyStatus() {
        Object object = this.sessionId;
        object = object == null ? null : (Object)this.mediaDrm.queryKeyStatus((byte[])object);
        return object;
    }

    @Override
    public void release(DrmSessionEventListener.EventDispatcher eventDispatcher) {
        int n2;
        boolean bl = this.referenceCount > 0;
        Assertions.checkState(bl);
        this.referenceCount = n2 = this.referenceCount - 1;
        if (n2 == 0) {
            this.state = 0;
            Util.castNonNull(this.responseHandler).removeCallbacksAndMessages(null);
            Util.castNonNull(this.requestHandler).release();
            this.requestHandler = null;
            Util.castNonNull(this.requestHandlerThread).quit();
            this.requestHandlerThread = null;
            this.mediaCrypto = null;
            this.lastException = null;
            this.currentKeyRequest = null;
            this.currentProvisionRequest = null;
            byte[] byArray = this.sessionId;
            if (byArray != null) {
                this.mediaDrm.closeSession(byArray);
                this.sessionId = null;
            }
            this.dispatchEvent((Consumer<DrmSessionEventListener.EventDispatcher>)_$$Lambda$tjQ5CTnFVsia_qkXSS552nN0Tmg.INSTANCE);
        }
        if (eventDispatcher != null) {
            if (this.isOpen()) {
                eventDispatcher.drmSessionReleased();
            }
            this.eventDispatchers.remove((Object)eventDispatcher);
        }
        this.referenceCountListener.onReferenceCountDecremented(this, this.referenceCount);
    }

    public static interface ProvisioningManager {
        public void onProvisionCompleted();

        public void onProvisionError(Exception var1);

        public void provisionRequired(DefaultDrmSession var1);
    }

    public static interface ReferenceCountListener {
        public void onReferenceCountDecremented(DefaultDrmSession var1, int var2);

        public void onReferenceCountIncremented(DefaultDrmSession var1, int var2);
    }

    private class RequestHandler
    extends Handler {
        private boolean isReleased;

        public RequestHandler(Looper looper) {
            super(looper);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean maybeRetryRequest(Message message, MediaDrmCallbackException object) {
            RequestTask requestTask = (RequestTask)message.obj;
            if (!requestTask.allowRetry) {
                return false;
            }
            ++requestTask.errorCount;
            if (requestTask.errorCount > DefaultDrmSession.this.loadErrorHandlingPolicy.getMinimumLoadableRetryCount(3)) {
                return false;
            }
            LoadEventInfo loadEventInfo = new LoadEventInfo(requestTask.taskId, object.dataSpec, object.uriAfterRedirects, object.responseHeaders, SystemClock.elapsedRealtime(), SystemClock.elapsedRealtime() - requestTask.startTimeMs, object.bytesLoaded);
            MediaLoadData mediaLoadData = new MediaLoadData(3);
            object = object.getCause() instanceof IOException ? (IOException)object.getCause() : new UnexpectedDrmSessionException(object.getCause());
            long l2 = DefaultDrmSession.this.loadErrorHandlingPolicy.getRetryDelayMsFor(new LoadErrorHandlingPolicy.LoadErrorInfo(loadEventInfo, mediaLoadData, (IOException)object, requestTask.errorCount));
            if (l2 == -9223372036854775807L) {
                return false;
            }
            synchronized (this) {
                if (!this.isReleased) {
                    this.sendMessageDelayed(Message.obtain((Message)message), l2);
                    return true;
                }
                return false;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void handleMessage(Message message) {
            Object object;
            RequestTask requestTask;
            block9: {
                requestTask = (RequestTask)message.obj;
                try {
                    int n2 = message.what;
                    if (n2 != 0) {
                        if (n2 != 1) {
                            RuntimeException runtimeException = new RuntimeException();
                            throw runtimeException;
                        }
                        object = DefaultDrmSession.this.callback.executeKeyRequest(DefaultDrmSession.this.uuid, (ExoMediaDrm.KeyRequest)requestTask.request);
                    } else {
                        object = DefaultDrmSession.this.callback.executeProvisionRequest(DefaultDrmSession.this.uuid, (ExoMediaDrm.ProvisionRequest)requestTask.request);
                    }
                }
                catch (Exception exception) {
                    Log.w(DefaultDrmSession.TAG, "Key/provisioning request produced an unexpected exception. Not retrying.", exception);
                }
                catch (MediaDrmCallbackException mediaDrmCallbackException) {
                    object = mediaDrmCallbackException;
                    if (!this.maybeRetryRequest(message, mediaDrmCallbackException)) break block9;
                    return;
                }
            }
            DefaultDrmSession.this.loadErrorHandlingPolicy.onLoadTaskConcluded(requestTask.taskId);
            synchronized (this) {
                if (!this.isReleased) {
                    DefaultDrmSession.this.responseHandler.obtainMessage(message.what, Pair.create((Object)requestTask.request, (Object)object)).sendToTarget();
                }
                return;
            }
        }

        void post(int n2, Object object, boolean bl) {
            this.obtainMessage(n2, new RequestTask(LoadEventInfo.getNewId(), bl, SystemClock.elapsedRealtime(), object)).sendToTarget();
        }

        public void release() {
            synchronized (this) {
                this.removeCallbacksAndMessages(null);
                this.isReleased = true;
                return;
            }
        }
    }

    private static final class RequestTask {
        public final boolean allowRetry;
        public int errorCount;
        public final Object request;
        public final long startTimeMs;
        public final long taskId;

        public RequestTask(long l2, boolean bl, long l3, Object object) {
            this.taskId = l2;
            this.allowRetry = bl;
            this.startTimeMs = l3;
            this.request = object;
        }
    }

    private class ResponseHandler
    extends Handler {
        public ResponseHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message message) {
            Object object = (Pair)message.obj;
            Object object2 = object.first;
            object = object.second;
            int n2 = message.what;
            if (n2 != 0) {
                if (n2 == 1) {
                    DefaultDrmSession.this.onKeyResponse(object2, object);
                }
            } else {
                DefaultDrmSession.this.onProvisionResponse(object2, object);
            }
        }
    }

    public static final class UnexpectedDrmSessionException
    extends IOException {
        public UnexpectedDrmSessionException(Throwable throwable) {
            super(throwable);
        }
    }
}

