/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.decoder;

import com.google.android.exoplayer2.decoder.Buffer;
import com.google.android.exoplayer2.decoder.CryptoInfo;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

public class DecoderInputBuffer
extends Buffer {
    public static final int BUFFER_REPLACEMENT_MODE_DIRECT = 2;
    public static final int BUFFER_REPLACEMENT_MODE_DISABLED = 0;
    public static final int BUFFER_REPLACEMENT_MODE_NORMAL = 1;
    private final int bufferReplacementMode;
    public final CryptoInfo cryptoInfo = new CryptoInfo();
    public ByteBuffer data;
    private final int paddingSize;
    public ByteBuffer supplementalData;
    public long timeUs;
    public boolean waitingForKeys;

    public DecoderInputBuffer(int n2) {
        this(n2, 0);
    }

    public DecoderInputBuffer(int n2, int n3) {
        this.bufferReplacementMode = n2;
        this.paddingSize = n3;
    }

    private ByteBuffer createReplacementByteBuffer(int n2) {
        int n3 = this.bufferReplacementMode;
        if (n3 == 1) {
            return ByteBuffer.allocate(n2);
        }
        if (n3 == 2) {
            return ByteBuffer.allocateDirect(n2);
        }
        ByteBuffer byteBuffer = this.data;
        n3 = byteBuffer == null ? 0 : byteBuffer.capacity();
        throw new InsufficientCapacityException(n3, n2);
    }

    public static DecoderInputBuffer newFlagsOnlyInstance() {
        return new DecoderInputBuffer(0);
    }

    @Override
    public void clear() {
        super.clear();
        ByteBuffer byteBuffer = this.data;
        if (byteBuffer != null) {
            byteBuffer.clear();
        }
        if ((byteBuffer = this.supplementalData) != null) {
            byteBuffer.clear();
        }
        this.waitingForKeys = false;
    }

    @EnsuresNonNull(value={"data"})
    public void ensureSpaceForWrite(int n2) {
        int n3;
        int n4 = n2 + this.paddingSize;
        ByteBuffer byteBuffer = this.data;
        if (byteBuffer == null) {
            this.data = this.createReplacementByteBuffer(n4);
            return;
        }
        n2 = byteBuffer.capacity();
        if (n2 >= (n4 += (n3 = byteBuffer.position()))) {
            this.data = byteBuffer;
            return;
        }
        ByteBuffer byteBuffer2 = this.createReplacementByteBuffer(n4);
        byteBuffer2.order(byteBuffer.order());
        if (n3 > 0) {
            byteBuffer.flip();
            byteBuffer2.put(byteBuffer);
        }
        this.data = byteBuffer2;
    }

    public final void flip() {
        ByteBuffer byteBuffer = this.data;
        if (byteBuffer != null) {
            byteBuffer.flip();
        }
        if ((byteBuffer = this.supplementalData) != null) {
            byteBuffer.flip();
        }
    }

    public final boolean isEncrypted() {
        return this.getFlag(0x40000000);
    }

    public final boolean isFlagsOnly() {
        boolean bl = this.data == null && this.bufferReplacementMode == 0;
        return bl;
    }

    @EnsuresNonNull(value={"supplementalData"})
    public void resetSupplementalData(int n2) {
        ByteBuffer byteBuffer = this.supplementalData;
        if (byteBuffer != null && byteBuffer.capacity() >= n2) {
            this.supplementalData.clear();
        } else {
            this.supplementalData = ByteBuffer.allocate(n2);
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BufferReplacementMode {
    }

    public static final class InsufficientCapacityException
    extends IllegalStateException {
        public final int currentCapacity;
        public final int requiredCapacity;

        public InsufficientCapacityException(int n2, int n3) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Buffer too small (");
            stringBuilder.append(n2);
            stringBuilder.append(" < ");
            stringBuilder.append(n3);
            stringBuilder.append(")");
            super(stringBuilder.toString());
            this.currentCapacity = n2;
            this.requiredCapacity = n3;
        }
    }
}

