/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.audio;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;

public class OpusUtil {
    private static final int DEFAULT_SEEK_PRE_ROLL_SAMPLES = 3840;
    private static final int FULL_CODEC_INITIALIZATION_DATA_BUFFER_COUNT = 3;
    public static final int SAMPLE_RATE = 48000;

    private OpusUtil() {
    }

    public static List<byte[]> buildInitializationData(byte[] byArray) {
        long l2 = OpusUtil.sampleCountToNanoseconds(OpusUtil.getPreSkipSamples(byArray));
        long l3 = OpusUtil.sampleCountToNanoseconds(3840L);
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(3);
        arrayList.add(byArray);
        arrayList.add(OpusUtil.buildNativeOrderByteArray(l2));
        arrayList.add(OpusUtil.buildNativeOrderByteArray(l3));
        return arrayList;
    }

    private static byte[] buildNativeOrderByteArray(long l2) {
        return ByteBuffer.allocate(8).order(ByteOrder.nativeOrder()).putLong(l2).array();
    }

    public static int getChannelCount(byte[] byArray) {
        return byArray[9] & 0xFF;
    }

    public static int getPreSkipSamples(List<byte[]> list) {
        if (list.size() == 3) {
            return (int)OpusUtil.nanosecondsToSampleCount(ByteBuffer.wrap(list.get(1)).order(ByteOrder.nativeOrder()).getLong());
        }
        return OpusUtil.getPreSkipSamples(list.get(0));
    }

    private static int getPreSkipSamples(byte[] byArray) {
        byte by2 = byArray[11];
        return byArray[10] & 0xFF | (by2 & 0xFF) << 8;
    }

    public static int getSeekPreRollSamples(List<byte[]> list) {
        if (list.size() == 3) {
            return (int)OpusUtil.nanosecondsToSampleCount(ByteBuffer.wrap(list.get(2)).order(ByteOrder.nativeOrder()).getLong());
        }
        return 3840;
    }

    private static long nanosecondsToSampleCount(long l2) {
        return l2 * 48000L / 1000000000L;
    }

    private static long sampleCountToNanoseconds(long l2) {
        return l2 * 1000000000L / 48000L;
    }
}

