/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.audio;

import android.media.AudioAttributes;
import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.AudioTrack;
import android.media.PlaybackParams;
import android.os.ConditionVariable;
import android.os.Handler;
import android.os.SystemClock;
import android.util.Pair;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.audio.Ac3Util;
import com.google.android.exoplayer2.audio.Ac4Util;
import com.google.android.exoplayer2.audio.AudioAttributes;
import com.google.android.exoplayer2.audio.AudioCapabilities;
import com.google.android.exoplayer2.audio.AudioProcessor;
import com.google.android.exoplayer2.audio.AudioSink;
import com.google.android.exoplayer2.audio.AudioTrackPositionTracker;
import com.google.android.exoplayer2.audio.AuxEffectInfo;
import com.google.android.exoplayer2.audio.BaseAudioProcessor;
import com.google.android.exoplayer2.audio.ChannelMappingAudioProcessor;
import com.google.android.exoplayer2.audio.DtsUtil;
import com.google.android.exoplayer2.audio.FloatResamplingAudioProcessor;
import com.google.android.exoplayer2.audio.MpegAudioUtil;
import com.google.android.exoplayer2.audio.ResamplingAudioProcessor;
import com.google.android.exoplayer2.audio.SilenceSkippingAudioProcessor;
import com.google.android.exoplayer2.audio.SonicAudioProcessor;
import com.google.android.exoplayer2.audio.TrimmingAudioProcessor;
import com.google.android.exoplayer2.audio._$$Lambda$LfzJt661qZfn2w_6SYHFbD3aMy0;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.Util;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.Executor;

public final class DefaultAudioSink
implements AudioSink {
    private static final int AC3_BUFFER_MULTIPLICATION_FACTOR = 2;
    private static final int AUDIO_TRACK_RETRY_DURATION_MS = 100;
    private static final int BUFFER_MULTIPLICATION_FACTOR = 4;
    public static final float DEFAULT_PLAYBACK_SPEED = 1.0f;
    private static final boolean DEFAULT_SKIP_SILENCE = false;
    private static final int ERROR_NATIVE_DEAD_OBJECT = -32;
    private static final long MAX_BUFFER_DURATION_US = 750000L;
    public static final float MAX_PITCH = 8.0f;
    public static final float MAX_PLAYBACK_SPEED = 8.0f;
    private static final long MIN_BUFFER_DURATION_US = 250000L;
    public static final float MIN_PITCH = 0.1f;
    public static final float MIN_PLAYBACK_SPEED = 0.1f;
    private static final long OFFLOAD_BUFFER_DURATION_US = 50000000L;
    private static final int OUTPUT_MODE_OFFLOAD = 1;
    private static final int OUTPUT_MODE_PASSTHROUGH = 2;
    private static final int OUTPUT_MODE_PCM = 0;
    private static final long PASSTHROUGH_BUFFER_DURATION_US = 250000L;
    private static final String TAG = "DefaultAudioSink";
    public static boolean failOnSpuriousAudioTimestamp;
    private AudioProcessor[] activeAudioProcessors;
    private MediaPositionParameters afterDrainParameters;
    private AudioAttributes audioAttributes;
    private final AudioCapabilities audioCapabilities;
    private final AudioProcessorChain audioProcessorChain;
    private int audioSessionId;
    private AudioTrack audioTrack;
    private PlaybackParameters audioTrackPlaybackParameters;
    private final AudioTrackPositionTracker audioTrackPositionTracker;
    private AuxEffectInfo auxEffectInfo;
    private ByteBuffer avSyncHeader;
    private int bytesUntilNextAvSync;
    private final ChannelMappingAudioProcessor channelMappingAudioProcessor;
    private Configuration configuration;
    private int drainingAudioProcessorIndex;
    private final boolean enableAudioTrackPlaybackParams;
    private final boolean enableFloatOutput;
    private final boolean enableOffload;
    private boolean externalAudioSessionIdProvided;
    private int framesPerEncodedSample;
    private boolean handledEndOfStream;
    private final PendingExceptionHolder<AudioSink.InitializationException> initializationExceptionPendingExceptionHolder;
    private ByteBuffer inputBuffer;
    private int inputBufferAccessUnitCount;
    private boolean isWaitingForOffloadEndOfStreamHandled;
    private long lastFeedElapsedRealtimeMs;
    private AudioSink.Listener listener;
    private MediaPositionParameters mediaPositionParameters;
    private final ArrayDeque<MediaPositionParameters> mediaPositionParametersCheckpoints;
    private boolean offloadDisabledUntilNextConfiguration;
    private StreamEventCallbackV29 offloadStreamEventCallbackV29;
    private ByteBuffer outputBuffer;
    private ByteBuffer[] outputBuffers;
    private Configuration pendingConfiguration;
    private boolean playing;
    private byte[] preV21OutputBuffer;
    private int preV21OutputBufferOffset;
    private final ConditionVariable releasingConditionVariable;
    private long startMediaTimeUs;
    private boolean startMediaTimeUsNeedsInit;
    private boolean startMediaTimeUsNeedsSync;
    private boolean stoppedAudioTrack;
    private long submittedEncodedFrames;
    private long submittedPcmBytes;
    private final AudioProcessor[] toFloatPcmAvailableAudioProcessors;
    private final AudioProcessor[] toIntPcmAvailableAudioProcessors;
    private final TrimmingAudioProcessor trimmingAudioProcessor;
    private boolean tunneling;
    private float volume;
    private final PendingExceptionHolder<AudioSink.WriteException> writeExceptionPendingExceptionHolder;
    private long writtenEncodedFrames;
    private long writtenPcmBytes;

    public DefaultAudioSink(AudioCapabilities object, AudioProcessorChain audioProcessorChain, boolean bl, boolean bl2, boolean bl3) {
        this.audioCapabilities = object;
        this.audioProcessorChain = Assertions.checkNotNull(audioProcessorChain);
        bl = Util.SDK_INT >= 21 && bl;
        this.enableFloatOutput = bl;
        bl = Util.SDK_INT >= 23 && bl2;
        this.enableAudioTrackPlaybackParams = bl;
        bl = Util.SDK_INT >= 29 && bl3;
        this.enableOffload = bl;
        this.releasingConditionVariable = new ConditionVariable(true);
        this.audioTrackPositionTracker = new AudioTrackPositionTracker((AudioTrackPositionTracker.Listener)new PositionTrackerListener());
        this.channelMappingAudioProcessor = new ChannelMappingAudioProcessor();
        this.trimmingAudioProcessor = new TrimmingAudioProcessor();
        object = new ArrayList();
        Collections.addAll(object, new BaseAudioProcessor[]{new ResamplingAudioProcessor(), this.channelMappingAudioProcessor, this.trimmingAudioProcessor});
        Collections.addAll(object, audioProcessorChain.getAudioProcessors());
        this.toIntPcmAvailableAudioProcessors = ((ArrayList)object).toArray(new AudioProcessor[0]);
        this.toFloatPcmAvailableAudioProcessors = new AudioProcessor[]{new FloatResamplingAudioProcessor()};
        this.volume = 1.0f;
        this.audioAttributes = AudioAttributes.DEFAULT;
        this.audioSessionId = 0;
        this.auxEffectInfo = new AuxEffectInfo(0, 0.0f);
        this.mediaPositionParameters = new MediaPositionParameters(PlaybackParameters.DEFAULT, false, 0L, 0L);
        this.audioTrackPlaybackParameters = PlaybackParameters.DEFAULT;
        this.drainingAudioProcessorIndex = -1;
        this.activeAudioProcessors = new AudioProcessor[0];
        this.outputBuffers = new ByteBuffer[0];
        this.mediaPositionParametersCheckpoints = new ArrayDeque();
        this.initializationExceptionPendingExceptionHolder = new PendingExceptionHolder(100L);
        this.writeExceptionPendingExceptionHolder = new PendingExceptionHolder(100L);
    }

    public DefaultAudioSink(AudioCapabilities audioCapabilities, AudioProcessor[] audioProcessorArray) {
        this(audioCapabilities, audioProcessorArray, false);
    }

    public DefaultAudioSink(AudioCapabilities audioCapabilities, AudioProcessor[] audioProcessorArray, boolean bl) {
        this(audioCapabilities, new DefaultAudioProcessorChain(audioProcessorArray), bl, false, false);
    }

    private void applyAudioProcessorPlaybackParametersAndSkipSilence(long l2) {
        Object object = this.shouldApplyAudioProcessorPlaybackParameters() ? this.audioProcessorChain.applyPlaybackParameters(this.getAudioProcessorPlaybackParameters()) : PlaybackParameters.DEFAULT;
        boolean bl = this.shouldApplyAudioProcessorPlaybackParameters() ? this.audioProcessorChain.applySkipSilenceEnabled(this.getSkipSilenceEnabled()) : false;
        this.mediaPositionParametersCheckpoints.add(new MediaPositionParameters((PlaybackParameters)object, bl, Math.max(0L, l2), this.configuration.framesToDurationUs(this.getWrittenFrames())));
        this.setupAudioProcessors();
        object = this.listener;
        if (object != null) {
            object.onSkipSilenceEnabledChanged(bl);
        }
    }

    private long applyMediaPositionParameters(long l2) {
        while (!this.mediaPositionParametersCheckpoints.isEmpty() && l2 >= this.mediaPositionParametersCheckpoints.getFirst().audioTrackPositionUs) {
            this.mediaPositionParameters = this.mediaPositionParametersCheckpoints.remove();
        }
        long l3 = l2 - this.mediaPositionParameters.audioTrackPositionUs;
        if (this.mediaPositionParameters.playbackParameters.equals((Object)PlaybackParameters.DEFAULT)) {
            return this.mediaPositionParameters.mediaTimeUs + l3;
        }
        if (this.mediaPositionParametersCheckpoints.isEmpty()) {
            l2 = this.audioProcessorChain.getMediaDuration(l3);
            return this.mediaPositionParameters.mediaTimeUs + l2;
        }
        MediaPositionParameters mediaPositionParameters = this.mediaPositionParametersCheckpoints.getFirst();
        l2 = Util.getMediaDurationForPlayoutDuration(mediaPositionParameters.audioTrackPositionUs - l2, this.mediaPositionParameters.playbackParameters.speed);
        return mediaPositionParameters.mediaTimeUs - l2;
    }

    private long applySkipping(long l2) {
        return l2 + this.configuration.framesToDurationUs(this.audioProcessorChain.getSkippedOutputFrameCount());
    }

    private AudioTrack buildAudioTrack() throws AudioSink.InitializationException {
        try {
            AudioTrack audioTrack = Assertions.checkNotNull(this.configuration).buildAudioTrack(this.tunneling, this.audioAttributes, this.audioSessionId);
            return audioTrack;
        }
        catch (AudioSink.InitializationException initializationException) {
            this.maybeDisableOffload();
            AudioSink.Listener listener2 = this.listener;
            if (listener2 != null) {
                listener2.onAudioSinkError(initializationException);
            }
            throw initializationException;
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean drainToEndOfStream() throws AudioSink.WriteException {
        if (this.drainingAudioProcessorIndex == -1) {
            this.drainingAudioProcessorIndex = 0;
lbl3:
            // 2 sources

            while (true) {
                var1_1 = true;
                break;
            }
        } else {
            var1_1 = false;
        }
        var2_2 = ++this.drainingAudioProcessorIndex;
        var3_3 = this.activeAudioProcessors;
        if (var2_2 < ((AudioProcessor[])var3_3).length) {
            var3_3 = var3_3[var2_2];
            if (var1_1) {
                var3_3.queueEndOfStream();
            }
            this.processBuffers(-9223372036854775807L);
            if (!var3_3.isEnded()) {
                return false;
            }
            ** continue;
        }
        var3_3 = this.outputBuffer;
        if (var3_3 != null) {
            this.writeBuffer((ByteBuffer)var3_3, -9223372036854775807L);
            if (this.outputBuffer != null) {
                return false;
            }
        }
        this.drainingAudioProcessorIndex = -1;
        return true;
    }

    private void flushAudioProcessors() {
        Object object;
        for (int i2 = 0; i2 < ((AudioProcessor[])(object = this.activeAudioProcessors)).length; ++i2) {
            object = object[i2];
            object.flush();
            this.outputBuffers[i2] = object.getOutput();
        }
    }

    private static AudioFormat getAudioFormat(int n2, int n3, int n4) {
        return new AudioFormat.Builder().setSampleRate(n2).setChannelMask(n3).setEncoding(n4).build();
    }

    private PlaybackParameters getAudioProcessorPlaybackParameters() {
        return this.getMediaPositionParameters().playbackParameters;
    }

    private static int getChannelConfigForPassthrough(int n2) {
        int n3;
        block6: {
            block8: {
                block7: {
                    n3 = n2;
                    if (Util.SDK_INT > 28) break block6;
                    if (n2 != 7) break block7;
                    n3 = 8;
                    break block6;
                }
                if (n2 == 3 || n2 == 4) break block8;
                n3 = n2;
                if (n2 != 5) break block6;
            }
            n3 = 6;
        }
        n2 = n3;
        if (Util.SDK_INT <= 26) {
            n2 = n3;
            if ("fugu".equals(Util.DEVICE)) {
                n2 = n3;
                if (n3 == 1) {
                    n2 = 2;
                }
            }
        }
        return Util.getAudioTrackChannelConfig(n2);
    }

    private static Pair<Integer, Integer> getEncodingAndChannelConfigForPassthrough(Format format, AudioCapabilities audioCapabilities) {
        if (audioCapabilities == null) {
            return null;
        }
        int n2 = MimeTypes.getEncoding((String)Assertions.checkNotNull(format.sampleMimeType), (String)format.codecs);
        int n3 = 6;
        int n4 = n2 != 5 && n2 != 6 && n2 != 18 && n2 != 17 && n2 != 7 && n2 != 8 && n2 != 14 ? 0 : 1;
        if (n4 == 0) {
            return null;
        }
        if (n2 == 18 && !audioCapabilities.supportsEncoding(18)) {
            n4 = 6;
        } else {
            n4 = n2;
            if (n2 == 8) {
                n4 = n2;
                if (!audioCapabilities.supportsEncoding(8)) {
                    n4 = 7;
                }
            }
        }
        if (!audioCapabilities.supportsEncoding(n4)) {
            return null;
        }
        if (n4 == 18) {
            if (Util.SDK_INT >= 29) {
                n3 = n2 = DefaultAudioSink.getMaxSupportedChannelCountForPassthroughV29(18, format.sampleRate);
                if (n2 == 0) {
                    Log.w(TAG, "E-AC3 JOC encoding supported but no channel count supported");
                    return null;
                }
            }
        } else {
            n3 = n2 = format.channelCount;
            if (n2 > audioCapabilities.getMaxChannelCount()) {
                return null;
            }
        }
        if ((n3 = DefaultAudioSink.getChannelConfigForPassthrough(n3)) == 0) {
            return null;
        }
        return Pair.create((Object)n4, (Object)n3);
    }

    private static int getFramesPerEncodedSample(int n2, ByteBuffer comparable) {
        switch (n2) {
            default: {
                comparable = new StringBuilder();
                ((StringBuilder)comparable).append("Unexpected audio encoding: ");
                ((StringBuilder)comparable).append(n2);
                throw new IllegalStateException(((StringBuilder)comparable).toString());
            }
            case 17: {
                return Ac4Util.parseAc4SyncframeAudioSampleCount((ByteBuffer)comparable);
            }
            case 16: {
                return 1024;
            }
            case 15: {
                return 512;
            }
            case 14: {
                n2 = Ac3Util.findTrueHdSyncframeOffset((ByteBuffer)comparable);
                n2 = n2 == -1 ? 0 : Ac3Util.parseTrueHdSyncframeAudioSampleCount(comparable, n2) * 16;
                return n2;
            }
            case 11: 
            case 12: {
                return 2048;
            }
            case 10: {
                return 1024;
            }
            case 9: {
                n2 = MpegAudioUtil.parseMpegAudioFrameSampleCount((int)Util.getBigEndianInt((ByteBuffer)comparable, ((Buffer)((Object)comparable)).position()));
                if (n2 != -1) {
                    return n2;
                }
                throw new IllegalArgumentException();
            }
            case 7: 
            case 8: {
                return DtsUtil.parseDtsAudioSampleCount((ByteBuffer)comparable);
            }
            case 5: 
            case 6: 
            case 18: 
        }
        return Ac3Util.parseAc3SyncframeAudioSampleCount((ByteBuffer)comparable);
    }

    private static int getMaxSupportedChannelCountForPassthroughV29(int n2, int n3) {
        android.media.AudioAttributes audioAttributes = new AudioAttributes.Builder().setUsage(1).setContentType(3).build();
        for (int i2 = 8; i2 > 0; --i2) {
            if (!AudioTrack.isDirectPlaybackSupported((AudioFormat)new AudioFormat.Builder().setEncoding(n2).setSampleRate(n3).setChannelMask(Util.getAudioTrackChannelConfig(i2)).build(), (android.media.AudioAttributes)audioAttributes)) continue;
            return i2;
        }
        return 0;
    }

    private static int getMaximumEncodedRateBytesPerSecond(int n2) {
        switch (n2) {
            default: {
                throw new IllegalArgumentException();
            }
            case 17: {
                return 336000;
            }
            case 16: {
                return 256000;
            }
            case 15: {
                return 8000;
            }
            case 14: {
                return 3062500;
            }
            case 12: {
                return 7000;
            }
            case 11: {
                return 16000;
            }
            case 10: {
                return 100000;
            }
            case 9: {
                return 40000;
            }
            case 8: {
                return 2250000;
            }
            case 7: {
                return 192000;
            }
            case 6: 
            case 18: {
                return 768000;
            }
            case 5: 
        }
        return 80000;
    }

    private MediaPositionParameters getMediaPositionParameters() {
        MediaPositionParameters mediaPositionParameters = this.afterDrainParameters;
        if (mediaPositionParameters == null) {
            mediaPositionParameters = !this.mediaPositionParametersCheckpoints.isEmpty() ? this.mediaPositionParametersCheckpoints.getLast() : this.mediaPositionParameters;
        }
        return mediaPositionParameters;
    }

    private long getSubmittedFrames() {
        long l2 = this.configuration.outputMode == 0 ? this.submittedPcmBytes / (long)this.configuration.inputPcmFrameSize : this.submittedEncodedFrames;
        return l2;
    }

    private long getWrittenFrames() {
        long l2 = this.configuration.outputMode == 0 ? this.writtenPcmBytes / (long)this.configuration.outputPcmFrameSize : this.writtenEncodedFrames;
        return l2;
    }

    private void initializeAudioTrack() throws AudioSink.InitializationException {
        this.releasingConditionVariable.block();
        this.audioTrack = this.buildAudioTrack();
        if (DefaultAudioSink.isOffloadedPlayback(this.audioTrack)) {
            this.registerStreamEventCallbackV29(this.audioTrack);
            this.audioTrack.setOffloadDelayPadding(this.configuration.inputFormat.encoderDelay, this.configuration.inputFormat.encoderPadding);
        }
        this.audioSessionId = this.audioTrack.getAudioSessionId();
        AudioTrackPositionTracker audioTrackPositionTracker = this.audioTrackPositionTracker;
        AudioTrack audioTrack = this.audioTrack;
        boolean bl = this.configuration.outputMode == 2;
        audioTrackPositionTracker.setAudioTrack(audioTrack, bl, this.configuration.outputEncoding, this.configuration.outputPcmFrameSize, this.configuration.bufferSize);
        this.setVolumeInternal();
        if (this.auxEffectInfo.effectId != 0) {
            this.audioTrack.attachAuxEffect(this.auxEffectInfo.effectId);
            this.audioTrack.setAuxEffectSendLevel(this.auxEffectInfo.sendLevel);
        }
        this.startMediaTimeUsNeedsInit = true;
    }

    private static boolean isAudioTrackDeadObject(int n2) {
        boolean bl = Util.SDK_INT >= 24 && n2 == -6 || n2 == -32;
        return bl;
    }

    private boolean isAudioTrackInitialized() {
        boolean bl = this.audioTrack != null;
        return bl;
    }

    private static boolean isOffloadedGaplessPlaybackSupported() {
        boolean bl = Util.SDK_INT >= 30 && Util.MODEL.startsWith("Pixel");
        return bl;
    }

    private static boolean isOffloadedPlayback(AudioTrack audioTrack) {
        boolean bl = Util.SDK_INT >= 29 && audioTrack.isOffloadedPlayback();
        return bl;
    }

    private static boolean isOffloadedPlaybackSupported(Format format, AudioAttributes audioAttributes) {
        if (Util.SDK_INT < 29) {
            return false;
        }
        int n2 = MimeTypes.getEncoding((String)Assertions.checkNotNull(format.sampleMimeType), (String)format.codecs);
        if (n2 == 0) {
            return false;
        }
        int n3 = Util.getAudioTrackChannelConfig(format.channelCount);
        if (n3 == 0) {
            return false;
        }
        if (!AudioManager.isOffloadedPlaybackSupported((AudioFormat)DefaultAudioSink.getAudioFormat(format.sampleRate, n3, n2), (android.media.AudioAttributes)audioAttributes.getAudioAttributesV21())) {
            return false;
        }
        n2 = format.encoderDelay;
        boolean bl = true;
        n2 = n2 == 0 && format.encoderPadding == 0 ? 1 : 0;
        boolean bl2 = bl;
        if (n2 == 0) {
            bl2 = DefaultAudioSink.isOffloadedGaplessPlaybackSupported() ? bl : false;
        }
        return bl2;
    }

    private static boolean isPassthroughPlaybackSupported(Format format, AudioCapabilities audioCapabilities) {
        boolean bl = DefaultAudioSink.getEncodingAndChannelConfigForPassthrough(format, audioCapabilities) != null;
        return bl;
    }

    private void maybeDisableOffload() {
        if (!this.configuration.outputModeIsOffload()) {
            return;
        }
        this.offloadDisabledUntilNextConfiguration = true;
    }

    private void playPendingData() {
        if (!this.stoppedAudioTrack) {
            this.stoppedAudioTrack = true;
            this.audioTrackPositionTracker.handleEndOfStream(this.getWrittenFrames());
            this.audioTrack.stop();
            this.bytesUntilNextAvSync = 0;
        }
    }

    private void processBuffers(long l2) throws AudioSink.WriteException {
        int n2;
        int n3 = n2 = this.activeAudioProcessors.length;
        while (n3 >= 0) {
            ByteBuffer byteBuffer;
            if (n3 > 0) {
                byteBuffer = this.outputBuffers[n3 - 1];
            } else {
                byteBuffer = this.inputBuffer;
                if (byteBuffer == null) {
                    byteBuffer = AudioProcessor.EMPTY_BUFFER;
                }
            }
            if (n3 == n2) {
                this.writeBuffer(byteBuffer, l2);
            } else {
                Object object = this.activeAudioProcessors[n3];
                if (n3 > this.drainingAudioProcessorIndex) {
                    object.queueInput(byteBuffer);
                }
                this.outputBuffers[n3] = object = object.getOutput();
                if (((Buffer)object).hasRemaining()) {
                    ++n3;
                    continue;
                }
            }
            if (byteBuffer.hasRemaining()) {
                return;
            }
            --n3;
        }
    }

    private void registerStreamEventCallbackV29(AudioTrack audioTrack) {
        if (this.offloadStreamEventCallbackV29 == null) {
            this.offloadStreamEventCallbackV29 = new StreamEventCallbackV29();
        }
        this.offloadStreamEventCallbackV29.register(audioTrack);
    }

    private void resetSinkStateForFlush() {
        this.submittedPcmBytes = 0L;
        this.submittedEncodedFrames = 0L;
        this.writtenPcmBytes = 0L;
        this.writtenEncodedFrames = 0L;
        this.isWaitingForOffloadEndOfStreamHandled = false;
        this.framesPerEncodedSample = 0;
        this.mediaPositionParameters = new MediaPositionParameters(this.getAudioProcessorPlaybackParameters(), this.getSkipSilenceEnabled(), 0L, 0L);
        this.startMediaTimeUs = 0L;
        this.afterDrainParameters = null;
        this.mediaPositionParametersCheckpoints.clear();
        this.inputBuffer = null;
        this.inputBufferAccessUnitCount = 0;
        this.outputBuffer = null;
        this.stoppedAudioTrack = false;
        this.handledEndOfStream = false;
        this.drainingAudioProcessorIndex = -1;
        this.avSyncHeader = null;
        this.bytesUntilNextAvSync = 0;
        this.trimmingAudioProcessor.resetTrimmedFrameCount();
        this.flushAudioProcessors();
    }

    private void setAudioProcessorPlaybackParametersAndSkipSilence(PlaybackParameters object, boolean bl) {
        MediaPositionParameters mediaPositionParameters = this.getMediaPositionParameters();
        if (!object.equals((Object)mediaPositionParameters.playbackParameters) || bl != mediaPositionParameters.skipSilence) {
            object = new MediaPositionParameters((PlaybackParameters)object, bl, -9223372036854775807L, -9223372036854775807L);
            if (this.isAudioTrackInitialized()) {
                this.afterDrainParameters = object;
            } else {
                this.mediaPositionParameters = object;
            }
        }
    }

    private void setAudioTrackPlaybackParametersV23(PlaybackParameters playbackParameters) {
        PlaybackParameters playbackParameters2 = playbackParameters;
        if (this.isAudioTrackInitialized()) {
            playbackParameters = new PlaybackParams().allowDefaults().setSpeed(playbackParameters.speed).setPitch(playbackParameters.pitch).setAudioFallbackMode(2);
            try {
                this.audioTrack.setPlaybackParams((PlaybackParams)playbackParameters);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.w(TAG, "Failed to set playback params", illegalArgumentException);
            }
            playbackParameters2 = new PlaybackParameters(this.audioTrack.getPlaybackParams().getSpeed(), this.audioTrack.getPlaybackParams().getPitch());
            this.audioTrackPositionTracker.setAudioTrackPlaybackSpeed(playbackParameters2.speed);
        }
        this.audioTrackPlaybackParameters = playbackParameters2;
    }

    private void setVolumeInternal() {
        if (this.isAudioTrackInitialized()) {
            if (Util.SDK_INT >= 21) {
                DefaultAudioSink.setVolumeInternalV21(this.audioTrack, this.volume);
            } else {
                DefaultAudioSink.setVolumeInternalV3(this.audioTrack, this.volume);
            }
        }
    }

    private static void setVolumeInternalV21(AudioTrack audioTrack, float f2) {
        audioTrack.setVolume(f2);
    }

    private static void setVolumeInternalV3(AudioTrack audioTrack, float f2) {
        audioTrack.setStereoVolume(f2, f2);
    }

    private void setupAudioProcessors() {
        AudioProcessor[] audioProcessorArray = this.configuration.availableAudioProcessors;
        ArrayList<AudioProcessor> arrayList = new ArrayList<AudioProcessor>();
        for (AudioProcessor audioProcessor : audioProcessorArray) {
            if (audioProcessor.isActive()) {
                arrayList.add(audioProcessor);
                continue;
            }
            audioProcessor.flush();
        }
        int n2 = arrayList.size();
        this.activeAudioProcessors = arrayList.toArray(new AudioProcessor[n2]);
        this.outputBuffers = new ByteBuffer[n2];
        this.flushAudioProcessors();
    }

    private boolean shouldApplyAudioProcessorPlaybackParameters() {
        boolean bl = !this.tunneling && "audio/raw".equals(this.configuration.inputFormat.sampleMimeType) && !this.shouldUseFloatOutput(this.configuration.inputFormat.pcmEncoding);
        return bl;
    }

    private boolean shouldUseFloatOutput(int n2) {
        boolean bl = this.enableFloatOutput && Util.isEncodingHighResolutionPcm(n2);
        return bl;
    }

    private void writeBuffer(ByteBuffer object, long l2) throws AudioSink.WriteException {
        int n2;
        int n3;
        boolean bl;
        if (!((Buffer)object).hasRemaining()) {
            return;
        }
        Object object2 = this.outputBuffer;
        boolean bl2 = true;
        if (object2 != null) {
            bl = object2 == object;
            Assertions.checkArgument(bl);
        } else {
            this.outputBuffer = object;
            if (Util.SDK_INT < 21) {
                n3 = ((Buffer)object).remaining();
                object2 = this.preV21OutputBuffer;
                if (object2 == null || ((Object)object2).length < n3) {
                    this.preV21OutputBuffer = new byte[n3];
                }
                n2 = ((Buffer)object).position();
                ((ByteBuffer)object).get(this.preV21OutputBuffer, 0, n3);
                ((ByteBuffer)object).position(n2);
                this.preV21OutputBufferOffset = 0;
            }
        }
        int n4 = ((Buffer)object).remaining();
        if (Util.SDK_INT < 21) {
            n3 = this.audioTrackPositionTracker.getAvailableBufferSize(this.writtenPcmBytes);
            if (n3 > 0) {
                n3 = Math.min(n4, n3);
                n3 = n2 = this.audioTrack.write(this.preV21OutputBuffer, this.preV21OutputBufferOffset, n3);
                if (n2 > 0) {
                    this.preV21OutputBufferOffset += n2;
                    ((ByteBuffer)object).position(((Buffer)object).position() + n2);
                    n3 = n2;
                }
            } else {
                n3 = 0;
            }
        } else if (this.tunneling) {
            bl = l2 != -9223372036854775807L;
            Assertions.checkState(bl);
            n3 = this.writeNonBlockingWithAvSyncV21(this.audioTrack, (ByteBuffer)object, n4, l2);
        } else {
            n3 = DefaultAudioSink.writeNonBlockingV21(this.audioTrack, (ByteBuffer)object, n4);
        }
        this.lastFeedElapsedRealtimeMs = SystemClock.elapsedRealtime();
        if (n3 < 0) {
            bl = DefaultAudioSink.isAudioTrackDeadObject(n3);
            if (bl) {
                this.maybeDisableOffload();
            }
            object2 = new AudioSink.WriteException(n3, this.configuration.inputFormat, bl);
            object = this.listener;
            if (object != null) {
                object.onAudioSinkError((Exception)object2);
            }
            if (!((AudioSink.WriteException)object2).isRecoverable) {
                this.writeExceptionPendingExceptionHolder.throwExceptionIfDeadlineIsReached((AudioSink.WriteException)object2);
                return;
            }
            throw object2;
        }
        this.writeExceptionPendingExceptionHolder.clear();
        if (DefaultAudioSink.isOffloadedPlayback(this.audioTrack)) {
            if (this.writtenEncodedFrames > 0L) {
                this.isWaitingForOffloadEndOfStreamHandled = false;
            }
            if (this.playing && this.listener != null && n3 < n4 && !this.isWaitingForOffloadEndOfStreamHandled) {
                l2 = this.audioTrackPositionTracker.getPendingBufferDurationMs(this.writtenEncodedFrames);
                this.listener.onOffloadBufferFull(l2);
            }
        }
        if (this.configuration.outputMode == 0) {
            this.writtenPcmBytes += (long)n3;
        }
        if (n3 == n4) {
            if (this.configuration.outputMode != 0) {
                bl = object == this.inputBuffer ? bl2 : false;
                Assertions.checkState(bl);
                this.writtenEncodedFrames += (long)(this.framesPerEncodedSample * this.inputBufferAccessUnitCount);
            }
            this.outputBuffer = null;
        }
    }

    private static int writeNonBlockingV21(AudioTrack audioTrack, ByteBuffer byteBuffer, int n2) {
        return audioTrack.write(byteBuffer, n2, 1);
    }

    private int writeNonBlockingWithAvSyncV21(AudioTrack audioTrack, ByteBuffer byteBuffer, int n2, long l2) {
        int n3;
        if (Util.SDK_INT >= 26) {
            return audioTrack.write(byteBuffer, n2, 1, l2 * 1000L);
        }
        if (this.avSyncHeader == null) {
            this.avSyncHeader = ByteBuffer.allocate(16);
            this.avSyncHeader.order(ByteOrder.BIG_ENDIAN);
            this.avSyncHeader.putInt(0x55550001);
        }
        if (this.bytesUntilNextAvSync == 0) {
            this.avSyncHeader.putInt(4, n2);
            this.avSyncHeader.putLong(8, l2 * 1000L);
            this.avSyncHeader.position(0);
            this.bytesUntilNextAvSync = n2;
        }
        if ((n3 = this.avSyncHeader.remaining()) > 0) {
            int n4 = audioTrack.write(this.avSyncHeader, n3, 1);
            if (n4 < 0) {
                this.bytesUntilNextAvSync = 0;
                return n4;
            }
            if (n4 < n3) {
                return 0;
            }
        }
        if ((n2 = DefaultAudioSink.writeNonBlockingV21(audioTrack, byteBuffer, n2)) < 0) {
            this.bytesUntilNextAvSync = 0;
            return n2;
        }
        this.bytesUntilNextAvSync -= n2;
        return n2;
    }

    @Override
    public void configure(Format object, int n2, int[] object2) throws AudioSink.ConfigurationException {
        block15: {
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            block13: {
                block14: {
                    block12: {
                        Object object3;
                        if (!"audio/raw".equals(object.sampleMimeType)) break block12;
                        Assertions.checkArgument(Util.isEncodingLinearPcm(object.pcmEncoding));
                        n8 = Util.getPcmFrameSize(object.pcmEncoding, object.channelCount);
                        AudioProcessor[] audioProcessorArray = this.shouldUseFloatOutput(object.pcmEncoding) ? this.toFloatPcmAvailableAudioProcessors : this.toIntPcmAvailableAudioProcessors;
                        this.trimmingAudioProcessor.setTrimFrameCount(object.encoderDelay, object.encoderPadding);
                        if (Util.SDK_INT < 21 && object.channelCount == 8 && object2 == null) {
                            object3 = new int[6];
                            n7 = 0;
                            while (true) {
                                object2 = object3;
                                if (n7 >= ((int[])object3).length) break;
                                object3[n7] = n7;
                                ++n7;
                            }
                        }
                        this.channelMappingAudioProcessor.setChannelMap(object2);
                        object2 = new AudioProcessor.AudioFormat(object.sampleRate, object.channelCount, object.pcmEncoding);
                        for (AudioProcessor audioProcessor : audioProcessorArray) {
                            try {
                                object3 = audioProcessor.configure((AudioProcessor.AudioFormat)object2);
                                boolean bl = audioProcessor.isActive();
                                if (!bl) continue;
                            }
                            catch (AudioProcessor.UnhandledAudioFormatException unhandledAudioFormatException) {
                                throw new AudioSink.ConfigurationException(unhandledAudioFormatException, (Format)object);
                            }
                            object2 = object3;
                        }
                        n6 = object2.encoding;
                        n5 = object2.sampleRate;
                        n4 = Util.getAudioTrackChannelConfig(object2.channelCount);
                        n3 = Util.getPcmFrameSize(n6, object2.channelCount);
                        object2 = audioProcessorArray;
                        int n9 = 0;
                        n7 = n8;
                        n8 = n9;
                        break block13;
                    }
                    object2 = new AudioProcessor[0];
                    n7 = object.sampleRate;
                    if (!this.enableOffload || !DefaultAudioSink.isOffloadedPlaybackSupported(object, this.audioAttributes)) break block14;
                    n6 = MimeTypes.getEncoding((String)Assertions.checkNotNull(object.sampleMimeType), (String)object.codecs);
                    n4 = Util.getAudioTrackChannelConfig(object.channelCount);
                    int n10 = -1;
                    n3 = -1;
                    n5 = n7;
                    n8 = 1;
                    n7 = n10;
                    break block13;
                }
                Pair<Integer, Integer> pair = DefaultAudioSink.getEncodingAndChannelConfigForPassthrough(object, this.audioCapabilities);
                if (pair == null) break block15;
                n6 = (Integer)pair.first;
                n4 = (Integer)pair.second;
                int n11 = -1;
                n3 = -1;
                n8 = 2;
                n5 = n7;
                n7 = n11;
            }
            if (n6 != 0) {
                if (n4 != 0) {
                    this.offloadDisabledUntilNextConfiguration = false;
                    object = new Configuration((Format)object, n7, n8, n3, n5, n4, n6, n2, this.enableAudioTrackPlaybackParams, (AudioProcessor[])object2);
                    if (this.isAudioTrackInitialized()) {
                        this.pendingConfiguration = object;
                    } else {
                        this.configuration = object;
                    }
                    return;
                }
                object2 = new StringBuilder();
                object2.append("Invalid output channel config (mode=");
                object2.append(n8);
                object2.append(") for: ");
                object2.append(object);
                throw new AudioSink.ConfigurationException(object2.toString(), (Format)object);
            }
            object2 = new StringBuilder();
            object2.append("Invalid output encoding (mode=");
            object2.append(n8);
            object2.append(") for: ");
            object2.append(object);
            throw new AudioSink.ConfigurationException(object2.toString(), (Format)object);
        }
        object2 = new StringBuilder();
        object2.append("Unable to configure passthrough for: ");
        object2.append(object);
        object = new AudioSink.ConfigurationException(object2.toString(), (Format)object);
        throw object;
    }

    @Override
    public void disableTunneling() {
        if (this.tunneling) {
            this.tunneling = false;
            this.flush();
        }
    }

    @Override
    public void enableTunnelingV21() {
        boolean bl = Util.SDK_INT >= 21;
        Assertions.checkState(bl);
        Assertions.checkState(this.externalAudioSessionIdProvided);
        if (!this.tunneling) {
            this.tunneling = true;
            this.flush();
        }
    }

    @Override
    public void experimentalFlushWithoutAudioTrackRelease() {
        if (Util.SDK_INT < 25) {
            this.flush();
            return;
        }
        this.writeExceptionPendingExceptionHolder.clear();
        this.initializationExceptionPendingExceptionHolder.clear();
        if (!this.isAudioTrackInitialized()) {
            return;
        }
        this.resetSinkStateForFlush();
        if (this.audioTrackPositionTracker.isPlaying()) {
            this.audioTrack.pause();
        }
        this.audioTrack.flush();
        this.audioTrackPositionTracker.reset();
        AudioTrackPositionTracker audioTrackPositionTracker = this.audioTrackPositionTracker;
        AudioTrack audioTrack = this.audioTrack;
        boolean bl = this.configuration.outputMode == 2;
        audioTrackPositionTracker.setAudioTrack(audioTrack, bl, this.configuration.outputEncoding, this.configuration.outputPcmFrameSize, this.configuration.bufferSize);
        this.startMediaTimeUsNeedsInit = true;
    }

    @Override
    public void flush() {
        if (this.isAudioTrackInitialized()) {
            Configuration configuration;
            this.resetSinkStateForFlush();
            if (this.audioTrackPositionTracker.isPlaying()) {
                this.audioTrack.pause();
            }
            if (DefaultAudioSink.isOffloadedPlayback(this.audioTrack)) {
                Assertions.checkNotNull(this.offloadStreamEventCallbackV29).unregister(this.audioTrack);
            }
            final AudioTrack audioTrack = this.audioTrack;
            this.audioTrack = null;
            if (Util.SDK_INT < 21 && !this.externalAudioSessionIdProvided) {
                this.audioSessionId = 0;
            }
            if ((configuration = this.pendingConfiguration) != null) {
                this.configuration = configuration;
                this.pendingConfiguration = null;
            }
            this.audioTrackPositionTracker.reset();
            this.releasingConditionVariable.close();
            new Thread("ExoPlayer:AudioTrackReleaseThread"){

                @Override
                public void run() {
                    try {
                        audioTrack.flush();
                        audioTrack.release();
                        return;
                    }
                    finally {
                        DefaultAudioSink.this.releasingConditionVariable.open();
                    }
                }
            }.start();
        }
        this.writeExceptionPendingExceptionHolder.clear();
        this.initializationExceptionPendingExceptionHolder.clear();
    }

    @Override
    public long getCurrentPositionUs(boolean bl) {
        if (this.isAudioTrackInitialized() && !this.startMediaTimeUsNeedsInit) {
            return this.applySkipping(this.applyMediaPositionParameters(Math.min(this.audioTrackPositionTracker.getCurrentPositionUs(bl), this.configuration.framesToDurationUs(this.getWrittenFrames()))));
        }
        return Long.MIN_VALUE;
    }

    @Override
    public int getFormatSupport(Format format) {
        if ("audio/raw".equals(format.sampleMimeType)) {
            if (!Util.isEncodingLinearPcm(format.pcmEncoding)) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Invalid PCM encoding: ");
                stringBuilder.append(format.pcmEncoding);
                Log.w(TAG, stringBuilder.toString());
                return 0;
            }
            if (!(format.pcmEncoding == 2 || this.enableFloatOutput && format.pcmEncoding == 4)) {
                return 1;
            }
            return 2;
        }
        if (this.enableOffload && !this.offloadDisabledUntilNextConfiguration && DefaultAudioSink.isOffloadedPlaybackSupported(format, this.audioAttributes)) {
            return 2;
        }
        if (DefaultAudioSink.isPassthroughPlaybackSupported(format, this.audioCapabilities)) {
            return 2;
        }
        return 0;
    }

    @Override
    public PlaybackParameters getPlaybackParameters() {
        PlaybackParameters playbackParameters = this.enableAudioTrackPlaybackParams ? this.audioTrackPlaybackParameters : this.getAudioProcessorPlaybackParameters();
        return playbackParameters;
    }

    @Override
    public boolean getSkipSilenceEnabled() {
        return this.getMediaPositionParameters().skipSilence;
    }

    @Override
    public boolean handleBuffer(ByteBuffer byteBuffer, long l2, int n2) throws AudioSink.InitializationException, AudioSink.WriteException {
        Object object = this.inputBuffer;
        boolean bl = object == null || byteBuffer == object;
        Assertions.checkArgument(bl);
        if (this.pendingConfiguration != null) {
            if (!this.drainToEndOfStream()) {
                return false;
            }
            if (!this.pendingConfiguration.canReuseAudioTrack(this.configuration)) {
                this.playPendingData();
                if (this.hasPendingData()) {
                    return false;
                }
                this.flush();
            } else {
                this.configuration = this.pendingConfiguration;
                this.pendingConfiguration = null;
                if (DefaultAudioSink.isOffloadedPlayback(this.audioTrack)) {
                    this.audioTrack.setOffloadEndOfStream();
                    this.audioTrack.setOffloadDelayPadding(this.configuration.inputFormat.encoderDelay, this.configuration.inputFormat.encoderPadding);
                    this.isWaitingForOffloadEndOfStreamHandled = true;
                }
            }
            this.applyAudioProcessorPlaybackParametersAndSkipSilence(l2);
        }
        if (!this.isAudioTrackInitialized()) {
            try {
                this.initializeAudioTrack();
            }
            catch (AudioSink.InitializationException initializationException) {
                if (!initializationException.isRecoverable) {
                    this.initializationExceptionPendingExceptionHolder.throwExceptionIfDeadlineIsReached(initializationException);
                    return false;
                }
                throw initializationException;
            }
        }
        this.initializationExceptionPendingExceptionHolder.clear();
        if (this.startMediaTimeUsNeedsInit) {
            this.startMediaTimeUs = Math.max(0L, l2);
            this.startMediaTimeUsNeedsSync = false;
            this.startMediaTimeUsNeedsInit = false;
            if (this.enableAudioTrackPlaybackParams && Util.SDK_INT >= 23) {
                this.setAudioTrackPlaybackParametersV23(this.audioTrackPlaybackParameters);
            }
            this.applyAudioProcessorPlaybackParametersAndSkipSilence(l2);
            if (this.playing) {
                this.play();
            }
        }
        if (!this.audioTrackPositionTracker.mayHandleBuffer(this.getWrittenFrames())) {
            return false;
        }
        if (this.inputBuffer == null) {
            bl = byteBuffer.order() == ByteOrder.LITTLE_ENDIAN;
            Assertions.checkArgument(bl);
            if (!byteBuffer.hasRemaining()) {
                return true;
            }
            if (this.configuration.outputMode != 0 && this.framesPerEncodedSample == 0) {
                this.framesPerEncodedSample = DefaultAudioSink.getFramesPerEncodedSample(this.configuration.outputEncoding, byteBuffer);
                if (this.framesPerEncodedSample == 0) {
                    return true;
                }
            }
            if (this.afterDrainParameters != null) {
                if (!this.drainToEndOfStream()) {
                    return false;
                }
                this.applyAudioProcessorPlaybackParametersAndSkipSilence(l2);
                this.afterDrainParameters = null;
            }
            long l3 = this.startMediaTimeUs + this.configuration.inputFramesToDurationUs(this.getSubmittedFrames() - this.trimmingAudioProcessor.getTrimmedFrameCount());
            if (!this.startMediaTimeUsNeedsSync && Math.abs(l3 - l2) > 200000L) {
                object = new StringBuilder();
                ((StringBuilder)object).append("Discontinuity detected [expected ");
                ((StringBuilder)object).append(l3);
                ((StringBuilder)object).append(", got ");
                ((StringBuilder)object).append(l2);
                ((StringBuilder)object).append("]");
                Log.e(TAG, ((StringBuilder)object).toString());
                this.startMediaTimeUsNeedsSync = true;
            }
            if (this.startMediaTimeUsNeedsSync) {
                if (!this.drainToEndOfStream()) {
                    return false;
                }
                l3 = l2 - l3;
                this.startMediaTimeUs += l3;
                this.startMediaTimeUsNeedsSync = false;
                this.applyAudioProcessorPlaybackParametersAndSkipSilence(l2);
                object = this.listener;
                if (object != null && l3 != 0L) {
                    object.onPositionDiscontinuity();
                }
            }
            if (this.configuration.outputMode == 0) {
                this.submittedPcmBytes += (long)byteBuffer.remaining();
            } else {
                this.submittedEncodedFrames += (long)(this.framesPerEncodedSample * n2);
            }
            this.inputBuffer = byteBuffer;
            this.inputBufferAccessUnitCount = n2;
        }
        this.processBuffers(l2);
        if (!this.inputBuffer.hasRemaining()) {
            this.inputBuffer = null;
            this.inputBufferAccessUnitCount = 0;
            return true;
        }
        if (this.audioTrackPositionTracker.isStalled(this.getWrittenFrames())) {
            Log.w(TAG, "Resetting stalled audio track");
            this.flush();
            return true;
        }
        return false;
    }

    @Override
    public void handleDiscontinuity() {
        this.startMediaTimeUsNeedsSync = true;
    }

    @Override
    public boolean hasPendingData() {
        boolean bl = this.isAudioTrackInitialized() && this.audioTrackPositionTracker.hasPendingData(this.getWrittenFrames());
        return bl;
    }

    @Override
    public boolean isEnded() {
        boolean bl = !this.isAudioTrackInitialized() || this.handledEndOfStream && !this.hasPendingData();
        return bl;
    }

    @Override
    public void pause() {
        this.playing = false;
        if (this.isAudioTrackInitialized() && this.audioTrackPositionTracker.pause()) {
            this.audioTrack.pause();
        }
    }

    @Override
    public void play() {
        this.playing = true;
        if (this.isAudioTrackInitialized()) {
            this.audioTrackPositionTracker.start();
            this.audioTrack.play();
        }
    }

    @Override
    public void playToEndOfStream() throws AudioSink.WriteException {
        if (!this.handledEndOfStream && this.isAudioTrackInitialized() && this.drainToEndOfStream()) {
            this.playPendingData();
            this.handledEndOfStream = true;
        }
    }

    @Override
    public void reset() {
        int n2;
        this.flush();
        AudioProcessor[] audioProcessorArray = this.toIntPcmAvailableAudioProcessors;
        int n3 = audioProcessorArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            audioProcessorArray[n2].reset();
        }
        audioProcessorArray = this.toFloatPcmAvailableAudioProcessors;
        n3 = audioProcessorArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            audioProcessorArray[n2].reset();
        }
        this.playing = false;
        this.offloadDisabledUntilNextConfiguration = false;
    }

    @Override
    public void setAudioAttributes(AudioAttributes audioAttributes) {
        if (this.audioAttributes.equals(audioAttributes)) {
            return;
        }
        this.audioAttributes = audioAttributes;
        if (this.tunneling) {
            return;
        }
        this.flush();
    }

    @Override
    public void setAudioSessionId(int n2) {
        if (this.audioSessionId != n2) {
            this.audioSessionId = n2;
            boolean bl = n2 != 0;
            this.externalAudioSessionIdProvided = bl;
            this.flush();
        }
    }

    @Override
    public void setAuxEffectInfo(AuxEffectInfo auxEffectInfo) {
        if (this.auxEffectInfo.equals((Object)auxEffectInfo)) {
            return;
        }
        int n2 = auxEffectInfo.effectId;
        float f2 = auxEffectInfo.sendLevel;
        if (this.audioTrack != null) {
            if (this.auxEffectInfo.effectId != n2) {
                this.audioTrack.attachAuxEffect(n2);
            }
            if (n2 != 0) {
                this.audioTrack.setAuxEffectSendLevel(f2);
            }
        }
        this.auxEffectInfo = auxEffectInfo;
    }

    @Override
    public void setListener(AudioSink.Listener listener2) {
        this.listener = listener2;
    }

    @Override
    public void setPlaybackParameters(PlaybackParameters playbackParameters) {
        playbackParameters = new PlaybackParameters(Util.constrainValue(playbackParameters.speed, 0.1f, 8.0f), Util.constrainValue(playbackParameters.pitch, 0.1f, 8.0f));
        if (this.enableAudioTrackPlaybackParams && Util.SDK_INT >= 23) {
            this.setAudioTrackPlaybackParametersV23(playbackParameters);
        } else {
            this.setAudioProcessorPlaybackParametersAndSkipSilence(playbackParameters, this.getSkipSilenceEnabled());
        }
    }

    @Override
    public void setSkipSilenceEnabled(boolean bl) {
        this.setAudioProcessorPlaybackParametersAndSkipSilence(this.getAudioProcessorPlaybackParameters(), bl);
    }

    @Override
    public void setVolume(float f2) {
        if (this.volume != f2) {
            this.volume = f2;
            this.setVolumeInternal();
        }
    }

    @Override
    public boolean supportsFormat(Format format) {
        boolean bl = this.getFormatSupport(format) != 0;
        return bl;
    }

    public static interface AudioProcessorChain {
        public PlaybackParameters applyPlaybackParameters(PlaybackParameters var1);

        public boolean applySkipSilenceEnabled(boolean var1);

        public AudioProcessor[] getAudioProcessors();

        public long getMediaDuration(long var1);

        public long getSkippedOutputFrameCount();
    }

    private static final class Configuration {
        public final AudioProcessor[] availableAudioProcessors;
        public final int bufferSize;
        public final Format inputFormat;
        public final int inputPcmFrameSize;
        public final int outputChannelConfig;
        public final int outputEncoding;
        public final int outputMode;
        public final int outputPcmFrameSize;
        public final int outputSampleRate;

        public Configuration(Format format, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, AudioProcessor[] audioProcessorArray) {
            this.inputFormat = format;
            this.inputPcmFrameSize = n2;
            this.outputMode = n3;
            this.outputPcmFrameSize = n4;
            this.outputSampleRate = n5;
            this.outputChannelConfig = n6;
            this.outputEncoding = n7;
            this.availableAudioProcessors = audioProcessorArray;
            this.bufferSize = this.computeBufferSize(n8, bl);
        }

        private int computeBufferSize(int n2, boolean bl) {
            if (n2 != 0) {
                return n2;
            }
            n2 = this.outputMode;
            if (n2 != 0) {
                if (n2 != 1) {
                    if (n2 == 2) {
                        return this.getEncodedDefaultBufferSize(250000L);
                    }
                    throw new IllegalStateException();
                }
                return this.getEncodedDefaultBufferSize(50000000L);
            }
            float f2 = bl ? 8.0f : 1.0f;
            return this.getPcmDefaultBufferSize(f2);
        }

        private AudioTrack createAudioTrack(boolean bl, AudioAttributes audioAttributes, int n2) {
            if (Util.SDK_INT >= 29) {
                return this.createAudioTrackV29(bl, audioAttributes, n2);
            }
            if (Util.SDK_INT >= 21) {
                return this.createAudioTrackV21(bl, audioAttributes, n2);
            }
            return this.createAudioTrackV9(audioAttributes, n2);
        }

        private AudioTrack createAudioTrackV21(boolean bl, AudioAttributes audioAttributes, int n2) {
            return new AudioTrack(Configuration.getAudioTrackAttributesV21(audioAttributes, bl), DefaultAudioSink.getAudioFormat(this.outputSampleRate, this.outputChannelConfig, this.outputEncoding), this.bufferSize, 1, n2);
        }

        private AudioTrack createAudioTrackV29(boolean bl, AudioAttributes audioAttributes, int n2) {
            AudioFormat audioFormat = DefaultAudioSink.getAudioFormat(this.outputSampleRate, this.outputChannelConfig, this.outputEncoding);
            audioAttributes = Configuration.getAudioTrackAttributesV21(audioAttributes, bl);
            audioAttributes = new AudioTrack.Builder().setAudioAttributes((android.media.AudioAttributes)audioAttributes).setAudioFormat(audioFormat);
            bl = true;
            audioAttributes = audioAttributes.setTransferMode(1).setBufferSizeInBytes(this.bufferSize).setSessionId(n2);
            if (this.outputMode != 1) {
                bl = false;
            }
            return audioAttributes.setOffloadedPlayback(bl).build();
        }

        private AudioTrack createAudioTrackV9(AudioAttributes audioAttributes, int n2) {
            int n3 = Util.getStreamTypeForAudioUsage(audioAttributes.usage);
            if (n2 == 0) {
                return new AudioTrack(n3, this.outputSampleRate, this.outputChannelConfig, this.outputEncoding, this.bufferSize, 1);
            }
            return new AudioTrack(n3, this.outputSampleRate, this.outputChannelConfig, this.outputEncoding, this.bufferSize, 1, n2);
        }

        private static android.media.AudioAttributes getAudioTrackAttributesV21(AudioAttributes audioAttributes, boolean bl) {
            if (bl) {
                return Configuration.getAudioTrackTunnelingAttributesV21();
            }
            return audioAttributes.getAudioAttributesV21();
        }

        private static android.media.AudioAttributes getAudioTrackTunnelingAttributesV21() {
            return new AudioAttributes.Builder().setContentType(3).setFlags(16).setUsage(1).build();
        }

        private int getEncodedDefaultBufferSize(long l2) {
            int n2;
            int n3 = n2 = DefaultAudioSink.getMaximumEncodedRateBytesPerSecond(this.outputEncoding);
            if (this.outputEncoding == 5) {
                n3 = n2 * 2;
            }
            return (int)(l2 * (long)n3 / 1000000L);
        }

        private int getPcmDefaultBufferSize(float f2) {
            int n2;
            int n3 = AudioTrack.getMinBufferSize((int)this.outputSampleRate, (int)this.outputChannelConfig, (int)this.outputEncoding);
            boolean bl = n3 != -2;
            Assertions.checkState(bl);
            n3 = n2 = Util.constrainValue(n3 * 4, (int)this.durationUsToFrames(250000L) * this.outputPcmFrameSize, Math.max(n3, (int)this.durationUsToFrames(750000L) * this.outputPcmFrameSize));
            if (f2 != 1.0f) {
                n3 = Math.round((float)n2 * f2);
            }
            return n3;
        }

        /*
         * Loose catch block
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public AudioTrack buildAudioTrack(boolean bl, AudioAttributes audioAttributes, int n2) throws AudioSink.InitializationException {
            void var2_5;
            audioAttributes = this.createAudioTrack(bl, audioAttributes, n2);
            n2 = audioAttributes.getState();
            if (n2 == 1) {
                return audioAttributes;
            }
            try {
                audioAttributes.release();
            }
            catch (Exception exception) {
                throw new AudioSink.InitializationException(n2, this.outputSampleRate, this.outputChannelConfig, this.bufferSize, this.inputFormat, this.outputModeIsOffload(), null);
            }
            throw new AudioSink.InitializationException(n2, this.outputSampleRate, this.outputChannelConfig, this.bufferSize, this.inputFormat, this.outputModeIsOffload(), null);
            catch (IllegalArgumentException illegalArgumentException) {
                throw new AudioSink.InitializationException(0, this.outputSampleRate, this.outputChannelConfig, this.bufferSize, this.inputFormat, this.outputModeIsOffload(), (Exception)var2_5);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            throw new AudioSink.InitializationException(0, this.outputSampleRate, this.outputChannelConfig, this.bufferSize, this.inputFormat, this.outputModeIsOffload(), (Exception)var2_5);
        }

        public boolean canReuseAudioTrack(Configuration configuration) {
            boolean bl = configuration.outputMode == this.outputMode && configuration.outputEncoding == this.outputEncoding && configuration.outputSampleRate == this.outputSampleRate && configuration.outputChannelConfig == this.outputChannelConfig && configuration.outputPcmFrameSize == this.outputPcmFrameSize;
            return bl;
        }

        public long durationUsToFrames(long l2) {
            return l2 * (long)this.outputSampleRate / 1000000L;
        }

        public long framesToDurationUs(long l2) {
            return l2 * 1000000L / (long)this.outputSampleRate;
        }

        public long inputFramesToDurationUs(long l2) {
            return l2 * 1000000L / (long)this.inputFormat.sampleRate;
        }

        public boolean outputModeIsOffload() {
            int n2 = this.outputMode;
            boolean bl = true;
            if (n2 != 1) {
                bl = false;
            }
            return bl;
        }
    }

    public static class DefaultAudioProcessorChain
    implements AudioProcessorChain {
        private final AudioProcessor[] audioProcessors;
        private final SilenceSkippingAudioProcessor silenceSkippingAudioProcessor;
        private final SonicAudioProcessor sonicAudioProcessor;

        public DefaultAudioProcessorChain(AudioProcessor ... audioProcessorArray) {
            this(audioProcessorArray, new SilenceSkippingAudioProcessor(), new SonicAudioProcessor());
        }

        public DefaultAudioProcessorChain(AudioProcessor[] audioProcessorArray, SilenceSkippingAudioProcessor silenceSkippingAudioProcessor, SonicAudioProcessor sonicAudioProcessor) {
            this.audioProcessors = new AudioProcessor[audioProcessorArray.length + 2];
            System.arraycopy(audioProcessorArray, 0, this.audioProcessors, 0, audioProcessorArray.length);
            this.silenceSkippingAudioProcessor = silenceSkippingAudioProcessor;
            this.sonicAudioProcessor = sonicAudioProcessor;
            AudioProcessor[] audioProcessorArray2 = this.audioProcessors;
            audioProcessorArray2[audioProcessorArray.length] = silenceSkippingAudioProcessor;
            audioProcessorArray2[audioProcessorArray.length + 1] = sonicAudioProcessor;
        }

        @Override
        public PlaybackParameters applyPlaybackParameters(PlaybackParameters playbackParameters) {
            this.sonicAudioProcessor.setSpeed(playbackParameters.speed);
            this.sonicAudioProcessor.setPitch(playbackParameters.pitch);
            return playbackParameters;
        }

        @Override
        public boolean applySkipSilenceEnabled(boolean bl) {
            this.silenceSkippingAudioProcessor.setEnabled(bl);
            return bl;
        }

        @Override
        public AudioProcessor[] getAudioProcessors() {
            return this.audioProcessors;
        }

        @Override
        public long getMediaDuration(long l2) {
            return this.sonicAudioProcessor.getMediaDuration(l2);
        }

        @Override
        public long getSkippedOutputFrameCount() {
            return this.silenceSkippingAudioProcessor.getSkippedFrames();
        }
    }

    public static final class InvalidAudioTrackTimestampException
    extends RuntimeException {
        private InvalidAudioTrackTimestampException(String string2) {
            super(string2);
        }
    }

    private static final class MediaPositionParameters {
        public final long audioTrackPositionUs;
        public final long mediaTimeUs;
        public final PlaybackParameters playbackParameters;
        public final boolean skipSilence;

        private MediaPositionParameters(PlaybackParameters playbackParameters, boolean bl, long l2, long l3) {
            this.playbackParameters = playbackParameters;
            this.skipSilence = bl;
            this.mediaTimeUs = l2;
            this.audioTrackPositionUs = l3;
        }
    }

    private static final class PendingExceptionHolder<T extends Exception> {
        private T pendingException;
        private long throwDeadlineMs;
        private final long throwDelayMs;

        public PendingExceptionHolder(long l2) {
            this.throwDelayMs = l2;
        }

        public void clear() {
            this.pendingException = null;
        }

        public void throwExceptionIfDeadlineIsReached(T t2) throws T {
            long l2 = SystemClock.elapsedRealtime();
            if (this.pendingException == null) {
                this.pendingException = t2;
                this.throwDeadlineMs = this.throwDelayMs + l2;
            }
            if (l2 >= this.throwDeadlineMs) {
                T t3 = this.pendingException;
                if (t3 != t2) {
                    ((Throwable)t3).addSuppressed((Throwable)t2);
                }
                t2 = this.pendingException;
                this.clear();
                throw t2;
            }
        }
    }

    private final class PositionTrackerListener
    implements AudioTrackPositionTracker.Listener {
        private PositionTrackerListener() {
        }

        public void onInvalidLatency(long l2) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Ignoring impossibly large audio latency: ");
            stringBuilder.append(l2);
            Log.w(DefaultAudioSink.TAG, stringBuilder.toString());
        }

        public void onPositionAdvancing(long l2) {
            if (DefaultAudioSink.this.listener != null) {
                DefaultAudioSink.this.listener.onPositionAdvancing(l2);
            }
        }

        public void onPositionFramesMismatch(long l2, long l3, long l4, long l5) {
            CharSequence charSequence = new StringBuilder();
            charSequence.append("Spurious audio timestamp (frame position mismatch): ");
            charSequence.append(l2);
            charSequence.append(", ");
            charSequence.append(l3);
            charSequence.append(", ");
            charSequence.append(l4);
            charSequence.append(", ");
            charSequence.append(l5);
            charSequence.append(", ");
            charSequence.append(DefaultAudioSink.this.getSubmittedFrames());
            charSequence.append(", ");
            charSequence.append(DefaultAudioSink.this.getWrittenFrames());
            charSequence = charSequence.toString();
            if (!failOnSpuriousAudioTimestamp) {
                Log.w(DefaultAudioSink.TAG, (String)charSequence);
                return;
            }
            throw new InvalidAudioTrackTimestampException((String)charSequence);
        }

        public void onSystemTimeUsMismatch(long l2, long l3, long l4, long l5) {
            CharSequence charSequence = new StringBuilder();
            charSequence.append("Spurious audio timestamp (system clock mismatch): ");
            charSequence.append(l2);
            charSequence.append(", ");
            charSequence.append(l3);
            charSequence.append(", ");
            charSequence.append(l4);
            charSequence.append(", ");
            charSequence.append(l5);
            charSequence.append(", ");
            charSequence.append(DefaultAudioSink.this.getSubmittedFrames());
            charSequence.append(", ");
            charSequence.append(DefaultAudioSink.this.getWrittenFrames());
            charSequence = charSequence.toString();
            if (!failOnSpuriousAudioTimestamp) {
                Log.w(DefaultAudioSink.TAG, (String)charSequence);
                return;
            }
            throw new InvalidAudioTrackTimestampException((String)charSequence);
        }

        public void onUnderrun(int n2, long l2) {
            if (DefaultAudioSink.this.listener != null) {
                long l3 = SystemClock.elapsedRealtime();
                long l4 = DefaultAudioSink.this.lastFeedElapsedRealtimeMs;
                DefaultAudioSink.this.listener.onUnderrun(n2, l2, l3 - l4);
            }
        }
    }

    private final class StreamEventCallbackV29 {
        private final AudioTrack.StreamEventCallback callback;
        private final Handler handler = new Handler();

        public StreamEventCallbackV29() {
            this.callback = new AudioTrack.StreamEventCallback(){

                public void onDataRequest(AudioTrack audioTrack, int n2) {
                    boolean bl = audioTrack == DefaultAudioSink.this.audioTrack;
                    Assertions.checkState(bl);
                    if (DefaultAudioSink.this.listener != null && DefaultAudioSink.this.playing) {
                        DefaultAudioSink.this.listener.onOffloadBufferEmptying();
                    }
                }

                public void onTearDown(AudioTrack audioTrack) {
                    boolean bl = audioTrack == DefaultAudioSink.this.audioTrack;
                    Assertions.checkState(bl);
                    if (DefaultAudioSink.this.listener != null && DefaultAudioSink.this.playing) {
                        DefaultAudioSink.this.listener.onOffloadBufferEmptying();
                    }
                }
            };
        }

        public void register(AudioTrack audioTrack) {
            Handler handler = this.handler;
            Objects.requireNonNull(handler);
            audioTrack.registerStreamEventCallback((Executor)new _$$Lambda$LfzJt661qZfn2w_6SYHFbD3aMy0(handler), this.callback);
        }

        public void unregister(AudioTrack audioTrack) {
            audioTrack.unregisterStreamEventCallback(this.callback);
            this.handler.removeCallbacksAndMessages(null);
        }
    }
}

