/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.audio;

import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.audio.AudioAttributes;
import com.google.android.exoplayer2.audio.AuxEffectInfo;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;

public interface AudioSink {
    public static final long CURRENT_POSITION_NOT_SET = Long.MIN_VALUE;
    public static final int SINK_FORMAT_SUPPORTED_DIRECTLY = 2;
    public static final int SINK_FORMAT_SUPPORTED_WITH_TRANSCODING = 1;
    public static final int SINK_FORMAT_UNSUPPORTED = 0;

    public void configure(Format var1, int var2, int[] var3) throws ConfigurationException;

    public void disableTunneling();

    public void enableTunnelingV21();

    public void experimentalFlushWithoutAudioTrackRelease();

    public void flush();

    public long getCurrentPositionUs(boolean var1);

    public int getFormatSupport(Format var1);

    public PlaybackParameters getPlaybackParameters();

    public boolean getSkipSilenceEnabled();

    public boolean handleBuffer(ByteBuffer var1, long var2, int var4) throws InitializationException, WriteException;

    public void handleDiscontinuity();

    public boolean hasPendingData();

    public boolean isEnded();

    public void pause();

    public void play();

    public void playToEndOfStream() throws WriteException;

    public void reset();

    public void setAudioAttributes(AudioAttributes var1);

    public void setAudioSessionId(int var1);

    public void setAuxEffectInfo(AuxEffectInfo var1);

    public void setListener(Listener var1);

    public void setPlaybackParameters(PlaybackParameters var1);

    public void setSkipSilenceEnabled(boolean var1);

    public void setVolume(float var1);

    public boolean supportsFormat(Format var1);

    public static final class ConfigurationException
    extends Exception {
        public final Format format;

        public ConfigurationException(String string2, Format format) {
            super(string2);
            this.format = format;
        }

        public ConfigurationException(Throwable throwable, Format format) {
            super(throwable);
            this.format = format;
        }
    }

    public static final class InitializationException
    extends Exception {
        public final int audioTrackState;
        public final Format format;
        public final boolean isRecoverable;

        public InitializationException(int n2, int n3, int n4, int n5, Format format, boolean bl, Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("AudioTrack init failed ");
            stringBuilder.append(n2);
            stringBuilder.append(" ");
            stringBuilder.append("Config(");
            stringBuilder.append(n3);
            stringBuilder.append(", ");
            stringBuilder.append(n4);
            stringBuilder.append(", ");
            stringBuilder.append(n5);
            stringBuilder.append(")");
            String string2 = bl ? " (recoverable)" : "";
            stringBuilder.append(string2);
            super(stringBuilder.toString(), exception);
            this.audioTrackState = n2;
            this.isRecoverable = bl;
            this.format = format;
        }
    }

    public static interface Listener {
        public void onAudioSinkError(Exception var1);

        public void onOffloadBufferEmptying();

        public void onOffloadBufferFull(long var1);

        public void onPositionAdvancing(long var1);

        public void onPositionDiscontinuity();

        public void onSkipSilenceEnabledChanged(boolean var1);

        public void onUnderrun(int var1, long var2, long var4);
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SinkFormatSupport {
    }

    public static final class WriteException
    extends Exception {
        public final int errorCode;
        public final Format format;
        public final boolean isRecoverable;

        public WriteException(int n2, Format format, boolean bl) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("AudioTrack write failed: ");
            stringBuilder.append(n2);
            super(stringBuilder.toString());
            this.isRecoverable = bl;
            this.errorCode = n2;
            this.format = format;
        }
    }
}

