/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.audio;

import com.google.android.exoplayer2.util.Util;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public interface AudioProcessor {
    public static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocateDirect(0).order(ByteOrder.nativeOrder());

    public AudioFormat configure(AudioFormat var1) throws UnhandledAudioFormatException;

    public void flush();

    public ByteBuffer getOutput();

    public boolean isActive();

    public boolean isEnded();

    public void queueEndOfStream();

    public void queueInput(ByteBuffer var1);

    public void reset();

    public static final class AudioFormat {
        public static final AudioFormat NOT_SET = new AudioFormat(-1, -1, -1);
        public final int bytesPerFrame;
        public final int channelCount;
        public final int encoding;
        public final int sampleRate;

        public AudioFormat(int n2, int n3, int n4) {
            this.sampleRate = n2;
            this.channelCount = n3;
            this.encoding = n4;
            n2 = Util.isEncodingLinearPcm(n4) ? Util.getPcmFrameSize(n4, n3) : -1;
            this.bytesPerFrame = n2;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("AudioFormat[sampleRate=");
            stringBuilder.append(this.sampleRate);
            stringBuilder.append(", channelCount=");
            stringBuilder.append(this.channelCount);
            stringBuilder.append(", encoding=");
            stringBuilder.append(this.encoding);
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
    }

    public static final class UnhandledAudioFormatException
    extends Exception {
        public UnhandledAudioFormatException(AudioFormat audioFormat) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Unhandled format: ");
            stringBuilder.append(audioFormat);
            super(stringBuilder.toString());
        }
    }
}

