/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.audio;

import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Handler;
import com.google.android.exoplayer2.audio.AudioCapabilities;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;

public final class AudioCapabilitiesReceiver {
    AudioCapabilities audioCapabilities;
    private final Context context;
    private final ExternalSurroundSoundSettingObserver externalSurroundSoundSettingObserver;
    private final Handler handler;
    private final Listener listener;
    private final BroadcastReceiver receiver;
    private boolean registered;

    public AudioCapabilitiesReceiver(Context object, Listener listener2) {
        Context context;
        this.context = context = object.getApplicationContext();
        this.listener = Assertions.checkNotNull(listener2);
        this.handler = Util.createHandlerForCurrentOrMainLooper();
        int n2 = Util.SDK_INT;
        listener2 = null;
        object = n2 >= 21 ? new HdmiAudioPlugBroadcastReceiver() : null;
        this.receiver = object;
        Uri uri = AudioCapabilities.getExternalSurroundSoundGlobalSettingUri();
        object = listener2;
        if (uri != null) {
            object = new ExternalSurroundSoundSettingObserver(this.handler, context.getContentResolver(), uri);
        }
        this.externalSurroundSoundSettingObserver = object;
    }

    private void onNewAudioCapabilities(AudioCapabilities audioCapabilities) {
        if (this.registered && !audioCapabilities.equals((Object)this.audioCapabilities)) {
            this.audioCapabilities = audioCapabilities;
            this.listener.onAudioCapabilitiesChanged(audioCapabilities);
        }
    }

    public AudioCapabilities register() {
        if (this.registered) {
            return Assertions.checkNotNull(this.audioCapabilities);
        }
        this.registered = true;
        ExternalSurroundSoundSettingObserver externalSurroundSoundSettingObserver = this.externalSurroundSoundSettingObserver;
        if (externalSurroundSoundSettingObserver != null) {
            externalSurroundSoundSettingObserver.register();
        }
        BroadcastReceiver broadcastReceiver = this.receiver;
        externalSurroundSoundSettingObserver = null;
        if (broadcastReceiver != null) {
            externalSurroundSoundSettingObserver = new IntentFilter("android.media.action.HDMI_AUDIO_PLUG");
            externalSurroundSoundSettingObserver = this.context.registerReceiver(this.receiver, (IntentFilter)externalSurroundSoundSettingObserver, null, this.handler);
        }
        this.audioCapabilities = AudioCapabilities.getCapabilities((Context)this.context, (Intent)externalSurroundSoundSettingObserver);
        return this.audioCapabilities;
    }

    public void unregister() {
        if (!this.registered) {
            return;
        }
        this.audioCapabilities = null;
        Object object = this.receiver;
        if (object != null) {
            this.context.unregisterReceiver((BroadcastReceiver)object);
        }
        if ((object = this.externalSurroundSoundSettingObserver) != null) {
            ((ExternalSurroundSoundSettingObserver)((Object)object)).unregister();
        }
        this.registered = false;
    }

    private final class ExternalSurroundSoundSettingObserver
    extends ContentObserver {
        private final ContentResolver resolver;
        private final Uri settingUri;

        public ExternalSurroundSoundSettingObserver(Handler handler, ContentResolver contentResolver, Uri uri) {
            super(handler);
            this.resolver = contentResolver;
            this.settingUri = uri;
        }

        public void onChange(boolean bl) {
            AudioCapabilitiesReceiver audioCapabilitiesReceiver = AudioCapabilitiesReceiver.this;
            audioCapabilitiesReceiver.onNewAudioCapabilities(AudioCapabilities.getCapabilities((Context)audioCapabilitiesReceiver.context));
        }

        public void register() {
            this.resolver.registerContentObserver(this.settingUri, false, (ContentObserver)this);
        }

        public void unregister() {
            this.resolver.unregisterContentObserver((ContentObserver)this);
        }
    }

    private final class HdmiAudioPlugBroadcastReceiver
    extends BroadcastReceiver {
        private HdmiAudioPlugBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (!this.isInitialStickyBroadcast()) {
                AudioCapabilitiesReceiver.this.onNewAudioCapabilities(AudioCapabilities.getCapabilities((Context)context, (Intent)intent));
            }
        }
    }

    public static interface Listener {
        public void onAudioCapabilitiesChanged(AudioCapabilities var1);
    }
}

