/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.audio;

import android.media.AudioAttributes;
import com.google.android.exoplayer2.util.Util;

public final class AudioAttributes {
    public static final AudioAttributes DEFAULT = new Builder().build();
    public final int allowedCapturePolicy;
    private android.media.AudioAttributes audioAttributesV21;
    public final int contentType;
    public final int flags;
    public final int usage;

    private AudioAttributes(int n2, int n3, int n4, int n5) {
        this.contentType = n2;
        this.flags = n3;
        this.usage = n4;
        this.allowedCapturePolicy = n5;
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (this == object) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            object = (AudioAttributes)object;
            if (this.contentType != ((AudioAttributes)object).contentType || this.flags != ((AudioAttributes)object).flags || this.usage != ((AudioAttributes)object).usage || this.allowedCapturePolicy != ((AudioAttributes)object).allowedCapturePolicy) {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    public android.media.AudioAttributes getAudioAttributesV21() {
        if (this.audioAttributesV21 == null) {
            AudioAttributes.Builder builder = new AudioAttributes.Builder().setContentType(this.contentType).setFlags(this.flags).setUsage(this.usage);
            if (Util.SDK_INT >= 29) {
                builder.setAllowedCapturePolicy(this.allowedCapturePolicy);
            }
            this.audioAttributesV21 = builder.build();
        }
        return this.audioAttributesV21;
    }

    public int hashCode() {
        return (((527 + this.contentType) * 31 + this.flags) * 31 + this.usage) * 31 + this.allowedCapturePolicy;
    }

    public static final class Builder {
        private int allowedCapturePolicy = 1;
        private int contentType = 0;
        private int flags = 0;
        private int usage = 1;

        public AudioAttributes build() {
            return new AudioAttributes(this.contentType, this.flags, this.usage, this.allowedCapturePolicy);
        }

        public Builder setAllowedCapturePolicy(int n2) {
            this.allowedCapturePolicy = n2;
            return this;
        }

        public Builder setContentType(int n2) {
            this.contentType = n2;
            return this;
        }

        public Builder setFlags(int n2) {
            this.flags = n2;
            return this;
        }

        public Builder setUsage(int n2) {
            this.usage = n2;
            return this;
        }
    }
}

