/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.audio;

import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.drm.DrmInitData;
import com.google.android.exoplayer2.util.ParsableBitArray;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;

public final class Ac3Util {
    public static final int AC3_MAX_RATE_BYTES_PER_SECOND = 80000;
    private static final int AC3_SYNCFRAME_AUDIO_SAMPLE_COUNT = 1536;
    private static final int AUDIO_SAMPLES_PER_AUDIO_BLOCK = 256;
    private static final int[] BITRATE_BY_HALF_FRMSIZECOD;
    private static final int[] BLOCKS_PER_SYNCFRAME_BY_NUMBLKSCOD;
    private static final int[] CHANNEL_COUNT_BY_ACMOD;
    public static final int E_AC3_MAX_RATE_BYTES_PER_SECOND = 768000;
    private static final int[] SAMPLE_RATE_BY_FSCOD;
    private static final int[] SAMPLE_RATE_BY_FSCOD2;
    private static final int[] SYNCFRAME_SIZE_WORDS_BY_HALF_FRMSIZECOD_44_1;
    public static final int TRUEHD_MAX_RATE_BYTES_PER_SECOND = 3062500;
    public static final int TRUEHD_RECHUNK_SAMPLE_COUNT = 16;
    public static final int TRUEHD_SYNCFRAME_PREFIX_LENGTH = 10;

    static {
        BLOCKS_PER_SYNCFRAME_BY_NUMBLKSCOD = new int[]{1, 2, 3, 6};
        SAMPLE_RATE_BY_FSCOD = new int[]{48000, 44100, 32000};
        SAMPLE_RATE_BY_FSCOD2 = new int[]{24000, 22050, 16000};
        CHANNEL_COUNT_BY_ACMOD = new int[]{2, 1, 2, 3, 3, 4, 4, 5};
        BITRATE_BY_HALF_FRMSIZECOD = new int[]{32, 40, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320, 384, 448, 512, 576, 640};
        SYNCFRAME_SIZE_WORDS_BY_HALF_FRMSIZECOD_44_1 = new int[]{69, 87, 104, 121, 139, 174, 208, 243, 278, 348, 417, 487, 557, 696, 835, 975, 1114, 1253, 1393};
    }

    private Ac3Util() {
    }

    public static int findTrueHdSyncframeOffset(ByteBuffer byteBuffer) {
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.limit();
        for (int i2 = n2; i2 <= n3 - 10; ++i2) {
            if ((Util.getBigEndianInt(byteBuffer, i2 + 4) & 0xFFFFFFFE) != -126718022) continue;
            return i2 - n2;
        }
        return -1;
    }

    private static int getAc3SyncframeSize(int n2, int n3) {
        int[] nArray;
        int[] nArray2;
        int n4 = n3 / 2;
        if (n2 >= 0 && n2 < (nArray2 = SAMPLE_RATE_BY_FSCOD).length && n3 >= 0 && n4 < (nArray = SYNCFRAME_SIZE_WORDS_BY_HALF_FRMSIZECOD_44_1).length) {
            if ((n2 = nArray2[n2]) == 44100) {
                return (nArray[n4] + n3 % 2) * 2;
            }
            n3 = BITRATE_BY_HALF_FRMSIZECOD[n4];
            if (n2 == 32000) {
                return n3 * 6;
            }
            return n3 * 4;
        }
        return -1;
    }

    public static Format parseAc3AnnexFFormat(ParsableByteArray parsableByteArray, String string2, String string3, DrmInitData drmInitData) {
        int n2;
        int n3 = parsableByteArray.readUnsignedByte();
        int n4 = SAMPLE_RATE_BY_FSCOD[(n3 & 0xC0) >> 6];
        int n5 = parsableByteArray.readUnsignedByte();
        n3 = n2 = CHANNEL_COUNT_BY_ACMOD[(n5 & 0x38) >> 3];
        if ((n5 & 4) != 0) {
            n3 = n2 + 1;
        }
        return new Format.Builder().setId(string2).setSampleMimeType("audio/ac3").setChannelCount(n3).setSampleRate(n4).setDrmInitData(drmInitData).setLanguage(string3).build();
    }

    public static int parseAc3SyncframeAudioSampleCount(ByteBuffer byteBuffer) {
        int n2 = byteBuffer.get(byteBuffer.position() + 5);
        int n3 = 3;
        if ((n2 = (n2 & 0xF8) >> 3 > 10 ? 1 : 0) != 0) {
            n2 = (byteBuffer.get(byteBuffer.position() + 4) & 0xC0) >> 6 == 3 ? n3 : (byteBuffer.get(byteBuffer.position() + 4) & 0x30) >> 4;
            return BLOCKS_PER_SYNCFRAME_BY_NUMBLKSCOD[n2] * 256;
        }
        return 1536;
    }

    public static SyncFrameInfo parseAc3SyncframeInfo(ParsableBitArray object) {
        int n2;
        int n3;
        int n4;
        int n5 = object.getPosition();
        object.skipBits(40);
        int n6 = object.readBits(5) > 10 ? 1 : 0;
        object.setPosition(n5);
        n5 = -1;
        if (n6 != 0) {
            object.skipBits(16);
            n6 = object.readBits(2);
            n6 = n6 != 0 ? (n6 != 1 ? (n6 != 2 ? n5 : 2) : 1) : 0;
            object.skipBits(3);
            int n7 = object.readBits(11);
            int n8 = object.readBits(2);
            if (n8 == 3) {
                n5 = SAMPLE_RATE_BY_FSCOD2[object.readBits(2)];
                n4 = 3;
                n3 = 6;
            } else {
                n4 = object.readBits(2);
                n3 = BLOCKS_PER_SYNCFRAME_BY_NUMBLKSCOD[n4];
                n5 = SAMPLE_RATE_BY_FSCOD[n8];
            }
            int n9 = object.readBits(3);
            int n10 = object.readBit();
            int n11 = CHANNEL_COUNT_BY_ACMOD[n9];
            object.skipBits(10);
            if (object.readBit()) {
                object.skipBits(8);
            }
            if (n9 == 0) {
                object.skipBits(5);
                if (object.readBit()) {
                    object.skipBits(8);
                }
            }
            if (n6 == 1 && object.readBit()) {
                object.skipBits(16);
            }
            if (object.readBit()) {
                if (n9 > 2) {
                    object.skipBits(2);
                }
                if ((n9 & 1) != 0 && n9 > 2) {
                    object.skipBits(6);
                }
                if ((n9 & 4) != 0) {
                    object.skipBits(6);
                }
                if (n10 != 0 && object.readBit()) {
                    object.skipBits(5);
                }
                if (n6 == 0) {
                    if (object.readBit()) {
                        object.skipBits(6);
                    }
                    if (n9 == 0 && object.readBit()) {
                        object.skipBits(6);
                    }
                    if (object.readBit()) {
                        object.skipBits(6);
                    }
                    if ((n2 = object.readBits(2)) == 1) {
                        object.skipBits(5);
                    } else if (n2 == 2) {
                        object.skipBits(12);
                    } else if (n2 == 3) {
                        n2 = object.readBits(5);
                        if (object.readBit()) {
                            object.skipBits(5);
                            if (object.readBit()) {
                                object.skipBits(4);
                            }
                            if (object.readBit()) {
                                object.skipBits(4);
                            }
                            if (object.readBit()) {
                                object.skipBits(4);
                            }
                            if (object.readBit()) {
                                object.skipBits(4);
                            }
                            if (object.readBit()) {
                                object.skipBits(4);
                            }
                            if (object.readBit()) {
                                object.skipBits(4);
                            }
                            if (object.readBit()) {
                                object.skipBits(4);
                            }
                            if (object.readBit()) {
                                if (object.readBit()) {
                                    object.skipBits(4);
                                }
                                if (object.readBit()) {
                                    object.skipBits(4);
                                }
                            }
                        }
                        if (object.readBit()) {
                            object.skipBits(5);
                            if (object.readBit()) {
                                object.skipBits(7);
                                if (object.readBit()) {
                                    object.skipBits(8);
                                }
                            }
                        }
                        object.skipBits((n2 + 2) * 8);
                        object.byteAlign();
                    }
                    if (n9 < 2) {
                        if (object.readBit()) {
                            object.skipBits(14);
                        }
                        if (n9 == 0 && object.readBit()) {
                            object.skipBits(14);
                        }
                    }
                    if (object.readBit()) {
                        if (n4 == 0) {
                            object.skipBits(5);
                        } else {
                            for (n2 = 0; n2 < n3; ++n2) {
                                if (!object.readBit()) continue;
                                object.skipBits(5);
                            }
                        }
                    }
                }
            }
            if (object.readBit()) {
                object.skipBits(5);
                if (n9 == 2) {
                    object.skipBits(4);
                }
                if (n9 >= 6) {
                    object.skipBits(2);
                }
                if (object.readBit()) {
                    object.skipBits(8);
                }
                if (n9 == 0 && object.readBit()) {
                    object.skipBits(8);
                }
                if (n8 < 3) {
                    object.skipBit();
                }
            }
            if (n6 == 0 && n4 != 3) {
                object.skipBit();
            }
            if (n6 == 2 && (n4 == 3 || object.readBit())) {
                object.skipBits(6);
            }
            object = object.readBit() && object.readBits(6) == 1 && object.readBits(8) == 1 ? "audio/eac3-joc" : "audio/eac3";
            n4 = n3 * 256;
            n7 = (n7 + 1) * 2;
            n3 = n5;
            n2 = n11 + n10;
            n5 = n6;
            n6 = n7;
        } else {
            int[] nArray;
            object.skipBits(32);
            n6 = object.readBits(2);
            String string2 = n6 == 3 ? null : "audio/ac3";
            n3 = Ac3Util.getAc3SyncframeSize(n6, object.readBits(6));
            object.skipBits(8);
            n5 = object.readBits(3);
            if ((n5 & 1) != 0 && n5 != 1) {
                object.skipBits(2);
            }
            if ((n5 & 4) != 0) {
                object.skipBits(2);
            }
            if (n5 == 2) {
                object.skipBits(2);
            }
            n6 = n6 < (nArray = SAMPLE_RATE_BY_FSCOD).length ? nArray[n6] : -1;
            n4 = object.readBit() ? 1 : 0;
            n2 = CHANNEL_COUNT_BY_ACMOD[n5];
            n5 = n6;
            n2 += n4;
            int n12 = -1;
            n4 = 1536;
            n6 = n3;
            n3 = n5;
            n5 = n12;
            object = string2;
        }
        return new SyncFrameInfo((String)object, n5, n2, n3, n6, n4);
    }

    public static int parseAc3SyncframeSize(byte[] byArray) {
        if (byArray.length < 6) {
            return -1;
        }
        byte by2 = (byArray[5] & 0xF8) >> 3 > 10 ? (byte)1 : 0;
        if (by2 != 0) {
            by2 = byArray[2];
            return ((byArray[3] & 0xFF | (by2 & 7) << 8) + 1) * 2;
        }
        return Ac3Util.getAc3SyncframeSize((byArray[4] & 0xC0) >> 6, byArray[4] & 0x3F);
    }

    public static Format parseEAc3AnnexFFormat(ParsableByteArray object, String string2, String string3, DrmInitData drmInitData) {
        int n2;
        object.skipBytes(2);
        int n3 = object.readUnsignedByte();
        int n4 = SAMPLE_RATE_BY_FSCOD[(n3 & 0xC0) >> 6];
        int n5 = object.readUnsignedByte();
        n3 = n2 = CHANNEL_COUNT_BY_ACMOD[(n5 & 0xE) >> 1];
        if ((n5 & 1) != 0) {
            n3 = n2 + 1;
        }
        n2 = n3;
        if ((object.readUnsignedByte() & 0x1E) >> 1 > 0) {
            n2 = n3;
            if ((2 & object.readUnsignedByte()) != 0) {
                n2 = n3 + 2;
            }
        }
        object = object.bytesLeft() > 0 && (object.readUnsignedByte() & 1) != 0 ? "audio/eac3-joc" : "audio/eac3";
        return new Format.Builder().setId(string2).setSampleMimeType((String)object).setChannelCount(n2).setSampleRate(n4).setDrmInitData(drmInitData).setLanguage(string3).build();
    }

    public static int parseTrueHdSyncframeAudioSampleCount(ByteBuffer byteBuffer, int n2) {
        int n3 = (byteBuffer.get(byteBuffer.position() + n2 + 7) & 0xFF) == 187 ? 1 : 0;
        int n4 = byteBuffer.position();
        n3 = n3 != 0 ? 9 : 8;
        return 40 << (byteBuffer.get(n4 + n2 + n3) >> 4 & 7);
    }

    public static int parseTrueHdSyncframeAudioSampleCount(byte[] byArray) {
        byte by2 = byArray[4];
        int n2 = 0;
        if (by2 == -8 && byArray[5] == 114 && byArray[6] == 111 && (byArray[7] & 0xFE) == 186) {
            if ((byArray[7] & 0xFF) == 187) {
                n2 = 1;
            }
            n2 = n2 != 0 ? 9 : 8;
            return 40 << (byArray[n2] >> 4 & 7);
        }
        return 0;
    }

    public static final class SyncFrameInfo {
        public static final int STREAM_TYPE_TYPE0 = 0;
        public static final int STREAM_TYPE_TYPE1 = 1;
        public static final int STREAM_TYPE_TYPE2 = 2;
        public static final int STREAM_TYPE_UNDEFINED = -1;
        public final int channelCount;
        public final int frameSize;
        public final String mimeType;
        public final int sampleCount;
        public final int sampleRate;
        public final int streamType;

        private SyncFrameInfo(String string2, int n2, int n3, int n4, int n5, int n6) {
            this.mimeType = string2;
            this.streamType = n2;
            this.channelCount = n3;
            this.sampleRate = n4;
            this.frameSize = n5;
            this.sampleCount = n6;
        }

        @Documented
        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface StreamType {
        }
    }
}

