/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.audio;

import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.ParsableBitArray;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class AacUtil {
    public static final int AAC_ELD_MAX_RATE_BYTES_PER_SECOND = 8000;
    public static final int AAC_HE_AUDIO_SAMPLE_COUNT = 2048;
    public static final int AAC_HE_V1_MAX_RATE_BYTES_PER_SECOND = 16000;
    public static final int AAC_HE_V2_MAX_RATE_BYTES_PER_SECOND = 7000;
    public static final int AAC_LC_AUDIO_SAMPLE_COUNT = 1024;
    public static final int AAC_LC_MAX_RATE_BYTES_PER_SECOND = 100000;
    public static final int AAC_LD_AUDIO_SAMPLE_COUNT = 512;
    public static final int AAC_XHE_AUDIO_SAMPLE_COUNT = 1024;
    public static final int AAC_XHE_MAX_RATE_BYTES_PER_SECOND = 256000;
    public static final int AUDIO_OBJECT_TYPE_AAC_ELD = 23;
    public static final int AUDIO_OBJECT_TYPE_AAC_ER_BSAC = 22;
    public static final int AUDIO_OBJECT_TYPE_AAC_LC = 2;
    public static final int AUDIO_OBJECT_TYPE_AAC_PS = 29;
    public static final int AUDIO_OBJECT_TYPE_AAC_SBR = 5;
    public static final int AUDIO_OBJECT_TYPE_AAC_XHE = 42;
    private static final int AUDIO_OBJECT_TYPE_ESCAPE = 31;
    private static final int AUDIO_SPECIFIC_CONFIG_CHANNEL_CONFIGURATION_INVALID = -1;
    private static final int[] AUDIO_SPECIFIC_CONFIG_CHANNEL_COUNT_TABLE;
    private static final int AUDIO_SPECIFIC_CONFIG_FREQUENCY_INDEX_ARBITRARY = 15;
    private static final int[] AUDIO_SPECIFIC_CONFIG_SAMPLING_RATE_TABLE;
    private static final String CODECS_STRING_PREFIX = "mp4a.40.";
    private static final String TAG = "AacUtil";

    static {
        AUDIO_SPECIFIC_CONFIG_SAMPLING_RATE_TABLE = new int[]{96000, 88200, 64000, 48000, 44100, 32000, 24000, 22050, 16000, 12000, 11025, 8000, 7350};
        AUDIO_SPECIFIC_CONFIG_CHANNEL_COUNT_TABLE = new int[]{0, 1, 2, 3, 4, 5, 6, 8, -1, -1, -1, 7, 8, -1, 8, -1};
    }

    private AacUtil() {
    }

    public static byte[] buildAacLcAudioSpecificConfig(int n2, int n3) {
        Object object;
        int n4;
        int n5 = 0;
        int n6 = -1;
        for (n4 = 0; n4 < ((int[])(object = AUDIO_SPECIFIC_CONFIG_SAMPLING_RATE_TABLE)).length; ++n4) {
            if (n2 != object[n4]) continue;
            n6 = n4;
        }
        int n7 = -1;
        for (n4 = n5; n4 < ((int[])(object = AUDIO_SPECIFIC_CONFIG_CHANNEL_COUNT_TABLE)).length; ++n4) {
            if (n3 != object[n4]) continue;
            n7 = n4;
        }
        if (n2 != -1 && n7 != -1) {
            return AacUtil.buildAudioSpecificConfig(2, n6, n7);
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Invalid sample rate or number of channels: ");
        ((StringBuilder)object).append(n2);
        ((StringBuilder)object).append(", ");
        ((StringBuilder)object).append(n3);
        object = new IllegalArgumentException(((StringBuilder)object).toString());
        throw object;
    }

    public static byte[] buildAudioSpecificConfig(int n2, int n3, int n4) {
        return new byte[]{(byte)(n2 << 3 & 0xF8 | n3 >> 1 & 7), (byte)(n3 << 7 & 0x80 | n4 << 3 & 0x78)};
    }

    private static int getAudioObjectType(ParsableBitArray parsableBitArray) {
        int n2;
        int n3 = n2 = parsableBitArray.readBits(5);
        if (n2 == 31) {
            n3 = parsableBitArray.readBits(6) + 32;
        }
        return n3;
    }

    public static int getEncodingForAudioObjectType(int n2) {
        if (n2 != 2) {
            if (n2 != 5) {
                if (n2 != 29) {
                    if (n2 != 42) {
                        if (n2 != 22) {
                            if (n2 != 23) {
                                return 0;
                            }
                            return 15;
                        }
                        return 0x40000000;
                    }
                    return 16;
                }
                return 12;
            }
            return 11;
        }
        return 10;
    }

    private static int getSamplingFrequency(ParsableBitArray parsableBitArray) throws ParserException {
        block4: {
            int n2;
            block3: {
                block2: {
                    n2 = parsableBitArray.readBits(4);
                    if (n2 != 15) break block2;
                    n2 = parsableBitArray.readBits(24);
                    break block3;
                }
                if (n2 >= 13) break block4;
                n2 = AUDIO_SPECIFIC_CONFIG_SAMPLING_RATE_TABLE[n2];
            }
            return n2;
        }
        throw new ParserException();
    }

    public static Config parseAudioSpecificConfig(ParsableBitArray object, boolean bl) throws ParserException {
        int n2;
        int n3;
        CharSequence charSequence;
        int n4;
        block14: {
            int n5;
            int n6;
            block13: {
                n6 = AacUtil.getAudioObjectType((ParsableBitArray)object);
                n4 = AacUtil.getSamplingFrequency((ParsableBitArray)object);
                n5 = object.readBits(4);
                charSequence = new StringBuilder();
                charSequence.append(CODECS_STRING_PREFIX);
                charSequence.append(n6);
                charSequence = charSequence.toString();
                if (n6 == 5) break block13;
                n3 = n6;
                n2 = n5;
                if (n6 != 29) break block14;
            }
            int n7 = AacUtil.getSamplingFrequency((ParsableBitArray)object);
            n3 = n6 = AacUtil.getAudioObjectType((ParsableBitArray)object);
            n4 = n7;
            n2 = n5;
            if (n6 == 22) {
                n2 = object.readBits(4);
                n4 = n7;
                n3 = n6;
            }
        }
        if (bl) {
            if (n3 != 1 && n3 != 2 && n3 != 3 && n3 != 4 && n3 != 6 && n3 != 7 && n3 != 17) {
                switch (n3) {
                    default: {
                        object = new StringBuilder();
                        ((StringBuilder)object).append("Unsupported audio object type: ");
                        ((StringBuilder)object).append(n3);
                        throw new ParserException(((StringBuilder)object).toString());
                    }
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                }
            }
            AacUtil.parseGaSpecificConfig((ParsableBitArray)object, n3, n2);
            switch (n3) {
                default: {
                    break;
                }
                case 17: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    n3 = object.readBits(2);
                    if (n3 != 2 && n3 != 3) break;
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Unsupported epConfig: ");
                    ((StringBuilder)object).append(n3);
                    throw new ParserException(((StringBuilder)object).toString());
                }
            }
        }
        if ((n2 = AUDIO_SPECIFIC_CONFIG_CHANNEL_COUNT_TABLE[n2]) != -1) {
            return new Config(n4, n2, (String)charSequence);
        }
        throw new ParserException();
    }

    public static Config parseAudioSpecificConfig(byte[] byArray) throws ParserException {
        return AacUtil.parseAudioSpecificConfig(new ParsableBitArray(byArray), false);
    }

    private static void parseGaSpecificConfig(ParsableBitArray parsableBitArray, int n2, int n3) {
        if (parsableBitArray.readBit()) {
            Log.w(TAG, "Unexpected frameLengthFlag = 1");
        }
        if (parsableBitArray.readBit()) {
            parsableBitArray.skipBits(14);
        }
        boolean bl = parsableBitArray.readBit();
        if (n3 != 0) {
            if (n2 == 6 || n2 == 20) {
                parsableBitArray.skipBits(3);
            }
            if (bl) {
                if (n2 == 22) {
                    parsableBitArray.skipBits(16);
                }
                if (n2 == 17 || n2 == 19 || n2 == 20 || n2 == 23) {
                    parsableBitArray.skipBits(3);
                }
                parsableBitArray.skipBits(1);
            }
            return;
        }
        throw new UnsupportedOperationException();
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AacAudioObjectType {
    }

    public static final class Config {
        public final int channelCount;
        public final String codecs;
        public final int sampleRateHz;

        private Config(int n2, int n3, String string2) {
            this.sampleRateHz = n2;
            this.channelCount = n3;
            this.codecs = string2;
        }
    }
}

