/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.analytics;

import android.util.SparseArray;
import android.view.Surface;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.audio.AudioAttributes;
import com.google.android.exoplayer2.decoder.DecoderCounters;
import com.google.android.exoplayer2.decoder.DecoderReuseEvaluation;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.source.LoadEventInfo;
import com.google.android.exoplayer2.source.MediaLoadData;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.trackselection.TrackSelectionArray;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.MutableFlags;
import com.google.common.base.Objects;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;

public interface AnalyticsListener {
    public static final int EVENT_AUDIO_ATTRIBUTES_CHANGED = 1016;
    public static final int EVENT_AUDIO_DECODER_INITIALIZED = 1009;
    public static final int EVENT_AUDIO_DECODER_RELEASED = 1013;
    public static final int EVENT_AUDIO_DISABLED = 1014;
    public static final int EVENT_AUDIO_ENABLED = 1008;
    public static final int EVENT_AUDIO_INPUT_FORMAT_CHANGED = 1010;
    public static final int EVENT_AUDIO_POSITION_ADVANCING = 1011;
    public static final int EVENT_AUDIO_SESSION_ID = 1015;
    public static final int EVENT_AUDIO_SINK_ERROR = 1018;
    public static final int EVENT_AUDIO_UNDERRUN = 1012;
    public static final int EVENT_BANDWIDTH_ESTIMATE = 1006;
    public static final int EVENT_DOWNSTREAM_FORMAT_CHANGED = 1004;
    public static final int EVENT_DRM_KEYS_LOADED = 1031;
    public static final int EVENT_DRM_KEYS_REMOVED = 1034;
    public static final int EVENT_DRM_KEYS_RESTORED = 1033;
    public static final int EVENT_DRM_SESSION_ACQUIRED = 1030;
    public static final int EVENT_DRM_SESSION_MANAGER_ERROR = 1032;
    public static final int EVENT_DRM_SESSION_RELEASED = 1035;
    public static final int EVENT_DROPPED_VIDEO_FRAMES = 1023;
    public static final int EVENT_IS_LOADING_CHANGED = 4;
    public static final int EVENT_IS_PLAYING_CHANGED = 8;
    public static final int EVENT_LOAD_CANCELED = 1002;
    public static final int EVENT_LOAD_COMPLETED = 1001;
    public static final int EVENT_LOAD_ERROR = 1003;
    public static final int EVENT_LOAD_STARTED = 1000;
    public static final int EVENT_MEDIA_ITEM_TRANSITION = 1;
    public static final int EVENT_METADATA = 1007;
    public static final int EVENT_PLAYBACK_PARAMETERS_CHANGED = 13;
    public static final int EVENT_PLAYBACK_STATE_CHANGED = 5;
    public static final int EVENT_PLAYBACK_SUPPRESSION_REASON_CHANGED = 7;
    public static final int EVENT_PLAYER_ERROR = 11;
    public static final int EVENT_PLAYER_RELEASED = 1036;
    public static final int EVENT_PLAY_WHEN_READY_CHANGED = 6;
    public static final int EVENT_POSITION_DISCONTINUITY = 12;
    public static final int EVENT_RENDERED_FIRST_FRAME = 1027;
    public static final int EVENT_REPEAT_MODE_CHANGED = 9;
    public static final int EVENT_SHUFFLE_MODE_ENABLED_CHANGED = 10;
    public static final int EVENT_SKIP_SILENCE_ENABLED_CHANGED = 1017;
    public static final int EVENT_STATIC_METADATA_CHANGED = 3;
    public static final int EVENT_SURFACE_SIZE_CHANGED = 1029;
    public static final int EVENT_TIMELINE_CHANGED = 0;
    public static final int EVENT_TRACKS_CHANGED = 2;
    public static final int EVENT_UPSTREAM_DISCARDED = 1005;
    public static final int EVENT_VIDEO_DECODER_INITIALIZED = 1021;
    public static final int EVENT_VIDEO_DECODER_RELEASED = 1024;
    public static final int EVENT_VIDEO_DISABLED = 1025;
    public static final int EVENT_VIDEO_ENABLED = 1020;
    public static final int EVENT_VIDEO_FRAME_PROCESSING_OFFSET = 1026;
    public static final int EVENT_VIDEO_INPUT_FORMAT_CHANGED = 1022;
    public static final int EVENT_VIDEO_SIZE_CHANGED = 1028;
    public static final int EVENT_VOLUME_CHANGED = 1019;

    public void onAudioAttributesChanged(EventTime var1, AudioAttributes var2);

    public void onAudioDecoderInitialized(EventTime var1, String var2, long var3);

    public void onAudioDecoderReleased(EventTime var1, String var2);

    public void onAudioDisabled(EventTime var1, DecoderCounters var2);

    public void onAudioEnabled(EventTime var1, DecoderCounters var2);

    @Deprecated
    public void onAudioInputFormatChanged(EventTime var1, Format var2);

    public void onAudioInputFormatChanged(EventTime var1, Format var2, DecoderReuseEvaluation var3);

    public void onAudioPositionAdvancing(EventTime var1, long var2);

    public void onAudioSessionIdChanged(EventTime var1, int var2);

    public void onAudioSinkError(EventTime var1, Exception var2);

    public void onAudioUnderrun(EventTime var1, int var2, long var3, long var5);

    public void onBandwidthEstimate(EventTime var1, int var2, long var3, long var5);

    @Deprecated
    public void onDecoderDisabled(EventTime var1, int var2, DecoderCounters var3);

    @Deprecated
    public void onDecoderEnabled(EventTime var1, int var2, DecoderCounters var3);

    @Deprecated
    public void onDecoderInitialized(EventTime var1, int var2, String var3, long var4);

    @Deprecated
    public void onDecoderInputFormatChanged(EventTime var1, int var2, Format var3);

    public void onDownstreamFormatChanged(EventTime var1, MediaLoadData var2);

    public void onDrmKeysLoaded(EventTime var1);

    public void onDrmKeysRemoved(EventTime var1);

    public void onDrmKeysRestored(EventTime var1);

    public void onDrmSessionAcquired(EventTime var1);

    public void onDrmSessionManagerError(EventTime var1, Exception var2);

    public void onDrmSessionReleased(EventTime var1);

    public void onDroppedVideoFrames(EventTime var1, int var2, long var3);

    public void onEvents(Player var1, Events var2);

    public void onIsLoadingChanged(EventTime var1, boolean var2);

    public void onIsPlayingChanged(EventTime var1, boolean var2);

    public void onLoadCanceled(EventTime var1, LoadEventInfo var2, MediaLoadData var3);

    public void onLoadCompleted(EventTime var1, LoadEventInfo var2, MediaLoadData var3);

    public void onLoadError(EventTime var1, LoadEventInfo var2, MediaLoadData var3, IOException var4, boolean var5);

    public void onLoadStarted(EventTime var1, LoadEventInfo var2, MediaLoadData var3);

    @Deprecated
    public void onLoadingChanged(EventTime var1, boolean var2);

    public void onMediaItemTransition(EventTime var1, MediaItem var2, int var3);

    public void onMetadata(EventTime var1, Metadata var2);

    public void onPlayWhenReadyChanged(EventTime var1, boolean var2, int var3);

    public void onPlaybackParametersChanged(EventTime var1, PlaybackParameters var2);

    public void onPlaybackStateChanged(EventTime var1, int var2);

    public void onPlaybackSuppressionReasonChanged(EventTime var1, int var2);

    public void onPlayerError(EventTime var1, ExoPlaybackException var2);

    public void onPlayerReleased(EventTime var1);

    @Deprecated
    public void onPlayerStateChanged(EventTime var1, boolean var2, int var3);

    public void onPositionDiscontinuity(EventTime var1, int var2);

    public void onRenderedFirstFrame(EventTime var1, Surface var2);

    public void onRepeatModeChanged(EventTime var1, int var2);

    @Deprecated
    public void onSeekProcessed(EventTime var1);

    public void onSeekStarted(EventTime var1);

    public void onShuffleModeChanged(EventTime var1, boolean var2);

    public void onSkipSilenceEnabledChanged(EventTime var1, boolean var2);

    public void onStaticMetadataChanged(EventTime var1, List<Metadata> var2);

    public void onSurfaceSizeChanged(EventTime var1, int var2, int var3);

    public void onTimelineChanged(EventTime var1, int var2);

    public void onTracksChanged(EventTime var1, TrackGroupArray var2, TrackSelectionArray var3);

    public void onUpstreamDiscarded(EventTime var1, MediaLoadData var2);

    public void onVideoDecoderInitialized(EventTime var1, String var2, long var3);

    public void onVideoDecoderReleased(EventTime var1, String var2);

    public void onVideoDisabled(EventTime var1, DecoderCounters var2);

    public void onVideoEnabled(EventTime var1, DecoderCounters var2);

    public void onVideoFrameProcessingOffset(EventTime var1, long var2, int var4);

    @Deprecated
    public void onVideoInputFormatChanged(EventTime var1, Format var2);

    public void onVideoInputFormatChanged(EventTime var1, Format var2, DecoderReuseEvaluation var3);

    public void onVideoSizeChanged(EventTime var1, int var2, int var3, int var4, float var5);

    public void onVolumeChanged(EventTime var1, float var2);

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EventFlags {
    }

    public static final class EventTime {
        public final MediaSource.MediaPeriodId currentMediaPeriodId;
        public final long currentPlaybackPositionMs;
        public final Timeline currentTimeline;
        public final int currentWindowIndex;
        public final long eventPlaybackPositionMs;
        public final MediaSource.MediaPeriodId mediaPeriodId;
        public final long realtimeMs;
        public final Timeline timeline;
        public final long totalBufferedDurationMs;
        public final int windowIndex;

        public EventTime(long l2, Timeline timeline, int n2, MediaSource.MediaPeriodId mediaPeriodId, long l3, Timeline timeline2, int n3, MediaSource.MediaPeriodId mediaPeriodId2, long l4, long l5) {
            this.realtimeMs = l2;
            this.timeline = timeline;
            this.windowIndex = n2;
            this.mediaPeriodId = mediaPeriodId;
            this.eventPlaybackPositionMs = l3;
            this.currentTimeline = timeline2;
            this.currentWindowIndex = n3;
            this.currentMediaPeriodId = mediaPeriodId2;
            this.currentPlaybackPositionMs = l4;
            this.totalBufferedDurationMs = l5;
        }

        public boolean equals(Object object) {
            boolean bl = true;
            if (this == object) {
                return true;
            }
            if (object != null && this.getClass() == object.getClass()) {
                object = (EventTime)object;
                if (!(this.realtimeMs == ((EventTime)object).realtimeMs && this.windowIndex == ((EventTime)object).windowIndex && this.eventPlaybackPositionMs == ((EventTime)object).eventPlaybackPositionMs && this.currentWindowIndex == ((EventTime)object).currentWindowIndex && this.currentPlaybackPositionMs == ((EventTime)object).currentPlaybackPositionMs && this.totalBufferedDurationMs == ((EventTime)object).totalBufferedDurationMs && Objects.equal(this.timeline, ((EventTime)object).timeline) && Objects.equal((Object)this.mediaPeriodId, (Object)((EventTime)object).mediaPeriodId) && Objects.equal(this.currentTimeline, ((EventTime)object).currentTimeline) && Objects.equal((Object)this.currentMediaPeriodId, (Object)((EventTime)object).currentMediaPeriodId))) {
                    bl = false;
                }
                return bl;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(new Object[]{this.realtimeMs, this.timeline, this.windowIndex, this.mediaPeriodId, this.eventPlaybackPositionMs, this.currentTimeline, this.currentWindowIndex, this.currentMediaPeriodId, this.currentPlaybackPositionMs, this.totalBufferedDurationMs});
        }
    }

    public static final class Events
    extends MutableFlags {
        private final SparseArray<EventTime> eventTimes = new SparseArray(0);

        public boolean contains(int n2) {
            return super.contains(n2);
        }

        public boolean containsAny(int ... nArray) {
            return super.containsAny(nArray);
        }

        public int get(int n2) {
            return super.get(n2);
        }

        public EventTime getEventTime(int n2) {
            return Assertions.checkNotNull((EventTime)this.eventTimes.get(n2));
        }

        public void setEventTimes(SparseArray<EventTime> sparseArray) {
            this.eventTimes.clear();
            for (int i2 = 0; i2 < this.size(); ++i2) {
                int n2 = this.get(i2);
                this.eventTimes.append(n2, (Object)Assertions.checkNotNull((EventTime)sparseArray.get(n2)));
            }
        }
    }
}

