/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.os.Handler;
import com.google.android.exoplayer2._$;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.Util;

final class StreamVolumeManager {
    private static final String TAG = "StreamVolumeManager";
    private static final String VOLUME_CHANGED_ACTION = "android.media.VOLUME_CHANGED_ACTION";
    private static final int VOLUME_FLAGS = 1;
    private final Context applicationContext;
    private final AudioManager audioManager;
    private final Handler eventHandler;
    private final Listener listener;
    private boolean muted;
    private VolumeChangeReceiver receiver;
    private int streamType;
    private int volume;

    public StreamVolumeManager(Context context, Handler object, Listener listener2) {
        this.applicationContext = context.getApplicationContext();
        this.eventHandler = object;
        this.listener = listener2;
        this.audioManager = Assertions.checkStateNotNull((AudioManager)this.applicationContext.getSystemService("audio"));
        this.streamType = 3;
        this.volume = StreamVolumeManager.getVolumeFromManager(this.audioManager, this.streamType);
        this.muted = StreamVolumeManager.getMutedFromManager(this.audioManager, this.streamType);
        object = new VolumeChangeReceiver();
        context = new IntentFilter(VOLUME_CHANGED_ACTION);
        try {
            this.applicationContext.registerReceiver((BroadcastReceiver)object, (IntentFilter)context);
            this.receiver = object;
        }
        catch (RuntimeException runtimeException) {
            Log.w(TAG, "Error registering stream volume receiver", runtimeException);
        }
    }

    private static boolean getMutedFromManager(AudioManager audioManager, int n2) {
        if (Util.SDK_INT >= 23) {
            return audioManager.isStreamMute(n2);
        }
        boolean bl = StreamVolumeManager.getVolumeFromManager(audioManager, n2) == 0;
        return bl;
    }

    private static int getVolumeFromManager(AudioManager audioManager, int n2) {
        try {
            int n3 = audioManager.getStreamVolume(n2);
            return n3;
        }
        catch (RuntimeException runtimeException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Could not retrieve stream volume for stream type ");
            stringBuilder.append(n2);
            Log.w(TAG, stringBuilder.toString(), runtimeException);
            return audioManager.getStreamMaxVolume(n2);
        }
    }

    private void updateVolumeAndNotifyIfChanged() {
        int n2 = StreamVolumeManager.getVolumeFromManager(this.audioManager, this.streamType);
        boolean bl = StreamVolumeManager.getMutedFromManager(this.audioManager, this.streamType);
        if (this.volume != n2 || this.muted != bl) {
            this.volume = n2;
            this.muted = bl;
            this.listener.onStreamVolumeChanged(n2, bl);
        }
    }

    public void decreaseVolume() {
        if (this.volume <= this.getMinVolume()) {
            return;
        }
        this.audioManager.adjustStreamVolume(this.streamType, -1, 1);
        this.updateVolumeAndNotifyIfChanged();
    }

    public int getMaxVolume() {
        return this.audioManager.getStreamMaxVolume(this.streamType);
    }

    public int getMinVolume() {
        int n2 = Util.SDK_INT >= 28 ? this.audioManager.getStreamMinVolume(this.streamType) : 0;
        return n2;
    }

    public int getVolume() {
        return this.volume;
    }

    public void increaseVolume() {
        if (this.volume >= this.getMaxVolume()) {
            return;
        }
        this.audioManager.adjustStreamVolume(this.streamType, 1, 1);
        this.updateVolumeAndNotifyIfChanged();
    }

    public boolean isMuted() {
        return this.muted;
    }

    public void release() {
        VolumeChangeReceiver volumeChangeReceiver = this.receiver;
        if (volumeChangeReceiver != null) {
            try {
                this.applicationContext.unregisterReceiver((BroadcastReceiver)volumeChangeReceiver);
            }
            catch (RuntimeException runtimeException) {
                Log.w(TAG, "Error unregistering stream volume receiver", runtimeException);
            }
            this.receiver = null;
        }
    }

    public void setMuted(boolean bl) {
        if (Util.SDK_INT >= 23) {
            AudioManager audioManager = this.audioManager;
            int n2 = this.streamType;
            int n3 = bl ? -100 : 100;
            audioManager.adjustStreamVolume(n2, n3, 1);
        } else {
            this.audioManager.setStreamMute(this.streamType, bl);
        }
        this.updateVolumeAndNotifyIfChanged();
    }

    public void setStreamType(int n2) {
        if (this.streamType == n2) {
            return;
        }
        this.streamType = n2;
        this.updateVolumeAndNotifyIfChanged();
        this.listener.onStreamTypeChanged(n2);
    }

    public void setVolume(int n2) {
        if (n2 >= this.getMinVolume() && n2 <= this.getMaxVolume()) {
            this.audioManager.setStreamVolume(this.streamType, n2, 1);
            this.updateVolumeAndNotifyIfChanged();
        }
    }

    public static interface Listener {
        public void onStreamTypeChanged(int var1);

        public void onStreamVolumeChanged(int var1, boolean var2);
    }

    private final class VolumeChangeReceiver
    extends BroadcastReceiver {
        private VolumeChangeReceiver() {
        }

        static /* synthetic */ void lambda$onReceive$0(StreamVolumeManager streamVolumeManager) {
            streamVolumeManager.updateVolumeAndNotifyIfChanged();
        }

        public void onReceive(Context context, Intent intent) {
            StreamVolumeManager.this.eventHandler.post((Runnable)new _$.Lambda.StreamVolumeManager.VolumeChangeReceiver.GBSF2uV8cR7F4Lk01XPY3pSaLFQ(StreamVolumeManager.this));
        }
    }
}

