/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.AudioTrack;
import android.os.Handler;
import android.os.Looper;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.TextureView;
import com.google.android.exoplayer2.AudioBecomingNoisyManager;
import com.google.android.exoplayer2.AudioFocusManager;
import com.google.android.exoplayer2.BasePlayer;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.DefaultLivePlaybackSpeedControl;
import com.google.android.exoplayer2.DefaultLoadControl;
import com.google.android.exoplayer2.DefaultRenderersFactory;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.ExoPlayerImpl;
import com.google.android.exoplayer2.ExoTimeoutException;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.LivePlaybackSpeedControl;
import com.google.android.exoplayer2.LoadControl;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.PlayerMessage;
import com.google.android.exoplayer2.Renderer;
import com.google.android.exoplayer2.RenderersFactory;
import com.google.android.exoplayer2.SeekParameters;
import com.google.android.exoplayer2.StreamVolumeManager;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.WakeLockManager;
import com.google.android.exoplayer2.WifiLockManager;
import com.google.android.exoplayer2.analytics.AnalyticsCollector;
import com.google.android.exoplayer2.analytics.AnalyticsListener;
import com.google.android.exoplayer2.audio.AudioAttributes;
import com.google.android.exoplayer2.audio.AudioListener;
import com.google.android.exoplayer2.audio.AudioRendererEventListener;
import com.google.android.exoplayer2.audio.AuxEffectInfo;
import com.google.android.exoplayer2.decoder.DecoderCounters;
import com.google.android.exoplayer2.decoder.DecoderReuseEvaluation;
import com.google.android.exoplayer2.device.DeviceInfo;
import com.google.android.exoplayer2.device.DeviceListener;
import com.google.android.exoplayer2.extractor.DefaultExtractorsFactory;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.metadata.MetadataOutput;
import com.google.android.exoplayer2.source.DefaultMediaSourceFactory;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.MediaSourceFactory;
import com.google.android.exoplayer2.source.ShuffleOrder;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.text.Cue;
import com.google.android.exoplayer2.text.TextOutput;
import com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelectionArray;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.upstream.BandwidthMeter;
import com.google.android.exoplayer2.upstream.DefaultBandwidthMeter;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Clock;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.PriorityTaskManager;
import com.google.android.exoplayer2.util.Util;
import com.google.android.exoplayer2.video.VideoDecoderGLSurfaceView;
import com.google.android.exoplayer2.video.VideoDecoderOutputBufferRenderer;
import com.google.android.exoplayer2.video.VideoFrameMetadataListener;
import com.google.android.exoplayer2.video.VideoListener;
import com.google.android.exoplayer2.video.VideoRendererEventListener;
import com.google.android.exoplayer2.video.spherical.CameraMotionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeoutException;

public class SimpleExoPlayer
extends BasePlayer
implements ExoPlayer,
Player.AudioComponent,
Player.VideoComponent,
Player.TextComponent,
Player.MetadataComponent,
Player.DeviceComponent {
    public static final long DEFAULT_DETACH_SURFACE_TIMEOUT_MS = 2000L;
    private static final String TAG = "SimpleExoPlayer";
    private static final String WRONG_THREAD_ERROR_MESSAGE = "Player is accessed on the wrong thread. See https://exoplayer.dev/issues/player-accessed-on-wrong-thread";
    private final AnalyticsCollector analyticsCollector;
    private final Context applicationContext;
    private AudioAttributes audioAttributes;
    private final AudioBecomingNoisyManager audioBecomingNoisyManager;
    private DecoderCounters audioDecoderCounters;
    private final AudioFocusManager audioFocusManager;
    private Format audioFormat;
    private final CopyOnWriteArraySet<AudioListener> audioListeners;
    private int audioSessionId;
    private float audioVolume;
    private CameraMotionListener cameraMotionListener;
    private final ComponentListener componentListener;
    private List<Cue> currentCues;
    private final long detachSurfaceTimeoutMs;
    private DeviceInfo deviceInfo;
    private final CopyOnWriteArraySet<DeviceListener> deviceListeners;
    private boolean hasNotifiedFullWrongThreadWarning;
    private boolean isPriorityTaskManagerRegistered;
    private AudioTrack keepSessionIdAudioTrack;
    private final CopyOnWriteArraySet<MetadataOutput> metadataOutputs;
    private boolean ownsSurface;
    private final ExoPlayerImpl player;
    private boolean playerReleased;
    private PriorityTaskManager priorityTaskManager;
    protected final Renderer[] renderers;
    private boolean skipSilenceEnabled;
    private final StreamVolumeManager streamVolumeManager;
    private Surface surface;
    private int surfaceHeight;
    private SurfaceHolder surfaceHolder;
    private int surfaceWidth;
    private final CopyOnWriteArraySet<TextOutput> textOutputs;
    private TextureView textureView;
    private boolean throwsWhenUsingWrongThread;
    private DecoderCounters videoDecoderCounters;
    private Format videoFormat;
    private VideoFrameMetadataListener videoFrameMetadataListener;
    private final CopyOnWriteArraySet<VideoListener> videoListeners;
    private int videoScalingMode;
    private final WakeLockManager wakeLockManager;
    private final WifiLockManager wifiLockManager;

    @Deprecated
    protected SimpleExoPlayer(Context context, RenderersFactory renderersFactory, TrackSelector trackSelector, MediaSourceFactory mediaSourceFactory, LoadControl loadControl, BandwidthMeter bandwidthMeter, AnalyticsCollector analyticsCollector, boolean bl, Clock clock, Looper looper) {
        this(new Builder(context, renderersFactory).setTrackSelector(trackSelector).setMediaSourceFactory(mediaSourceFactory).setLoadControl(loadControl).setBandwidthMeter(bandwidthMeter).setAnalyticsCollector(analyticsCollector).setUseLazyPreparation(bl).setClock(clock).setLooper(looper));
    }

    protected SimpleExoPlayer(Builder builder) {
        this.applicationContext = builder.context.getApplicationContext();
        this.analyticsCollector = builder.analyticsCollector;
        this.priorityTaskManager = builder.priorityTaskManager;
        this.audioAttributes = builder.audioAttributes;
        this.videoScalingMode = builder.videoScalingMode;
        this.skipSilenceEnabled = builder.skipSilenceEnabled;
        this.detachSurfaceTimeoutMs = builder.detachSurfaceTimeoutMs;
        this.componentListener = new ComponentListener();
        this.videoListeners = new CopyOnWriteArraySet();
        this.audioListeners = new CopyOnWriteArraySet();
        this.textOutputs = new CopyOnWriteArraySet();
        this.metadataOutputs = new CopyOnWriteArraySet();
        this.deviceListeners = new CopyOnWriteArraySet();
        Handler handler = new Handler(builder.looper);
        Object object = builder.renderersFactory;
        Object object2 = this.componentListener;
        this.renderers = object.createRenderers(handler, (VideoRendererEventListener)object2, (AudioRendererEventListener)object2, (TextOutput)object2, (MetadataOutput)object2);
        this.audioVolume = 1.0f;
        this.audioSessionId = Util.SDK_INT < 21 ? this.initializeKeepSessionIdAudioTrack(0) : C.generateAudioSessionIdV21(this.applicationContext);
        this.currentCues = Collections.emptyList();
        this.throwsWhenUsingWrongThread = true;
        this.player = new ExoPlayerImpl(this.renderers, builder.trackSelector, builder.mediaSourceFactory, builder.loadControl, builder.bandwidthMeter, this.analyticsCollector, builder.useLazyPreparation, builder.seekParameters, builder.livePlaybackSpeedControl, builder.releaseTimeoutMs, builder.pauseAtEndOfMediaItems, builder.clock, builder.looper, (Player)((Object)this));
        this.player.addListener(this.componentListener);
        this.audioBecomingNoisyManager = new AudioBecomingNoisyManager(builder.context, handler, (AudioBecomingNoisyManager.EventListener)this.componentListener);
        this.audioBecomingNoisyManager.setEnabled(builder.handleAudioBecomingNoisy);
        this.audioFocusManager = new AudioFocusManager(builder.context, handler, this.componentListener);
        object = this.audioFocusManager;
        object2 = builder.handleAudioFocus ? this.audioAttributes : null;
        ((AudioFocusManager)object).setAudioAttributes((AudioAttributes)object2);
        this.streamVolumeManager = new StreamVolumeManager(builder.context, handler, this.componentListener);
        this.streamVolumeManager.setStreamType(Util.getStreamTypeForAudioUsage(this.audioAttributes.usage));
        this.wakeLockManager = new WakeLockManager(builder.context);
        object2 = this.wakeLockManager;
        boolean bl = builder.wakeMode != 0;
        object2.setEnabled(bl);
        this.wifiLockManager = new WifiLockManager(builder.context);
        object2 = this.wifiLockManager;
        bl = builder.wakeMode == 2;
        object2.setEnabled(bl);
        this.deviceInfo = SimpleExoPlayer.createDeviceInfo(this.streamVolumeManager);
        this.sendRendererMessage(1, 102, this.audioSessionId);
        this.sendRendererMessage(2, 102, this.audioSessionId);
        this.sendRendererMessage(1, 3, this.audioAttributes);
        this.sendRendererMessage(2, 4, this.videoScalingMode);
        this.sendRendererMessage(1, 101, this.skipSilenceEnabled);
    }

    static /* synthetic */ DecoderCounters access$2302(SimpleExoPlayer simpleExoPlayer, DecoderCounters decoderCounters) {
        simpleExoPlayer.videoDecoderCounters = decoderCounters;
        return decoderCounters;
    }

    static /* synthetic */ Format access$2502(SimpleExoPlayer simpleExoPlayer, Format format) {
        simpleExoPlayer.videoFormat = format;
        return format;
    }

    static /* synthetic */ DecoderCounters access$2802(SimpleExoPlayer simpleExoPlayer, DecoderCounters decoderCounters) {
        simpleExoPlayer.audioDecoderCounters = decoderCounters;
        return decoderCounters;
    }

    static /* synthetic */ Format access$2902(SimpleExoPlayer simpleExoPlayer, Format format) {
        simpleExoPlayer.audioFormat = format;
        return format;
    }

    static /* synthetic */ boolean access$3002(SimpleExoPlayer simpleExoPlayer, boolean bl) {
        simpleExoPlayer.skipSilenceEnabled = bl;
        return bl;
    }

    static /* synthetic */ List access$3202(SimpleExoPlayer simpleExoPlayer, List list) {
        simpleExoPlayer.currentCues = list;
        return list;
    }

    static /* synthetic */ DeviceInfo access$4202(SimpleExoPlayer simpleExoPlayer, DeviceInfo deviceInfo) {
        simpleExoPlayer.deviceInfo = deviceInfo;
        return deviceInfo;
    }

    static /* synthetic */ boolean access$4502(SimpleExoPlayer simpleExoPlayer, boolean bl) {
        simpleExoPlayer.isPriorityTaskManagerRegistered = bl;
        return bl;
    }

    private static DeviceInfo createDeviceInfo(StreamVolumeManager streamVolumeManager) {
        return new DeviceInfo(0, streamVolumeManager.getMinVolume(), streamVolumeManager.getMaxVolume());
    }

    private static int getPlayWhenReadyChangeReason(boolean bl, int n2) {
        int n3;
        int n4 = n3 = 1;
        if (bl) {
            n4 = n3;
            if (n2 != 1) {
                n4 = 2;
            }
        }
        return n4;
    }

    private int initializeKeepSessionIdAudioTrack(int n2) {
        AudioTrack audioTrack = this.keepSessionIdAudioTrack;
        if (audioTrack != null && audioTrack.getAudioSessionId() != n2) {
            this.keepSessionIdAudioTrack.release();
            this.keepSessionIdAudioTrack = null;
        }
        if (this.keepSessionIdAudioTrack == null) {
            this.keepSessionIdAudioTrack = new AudioTrack(3, 4000, 4, 2, 2, 0, n2);
        }
        return this.keepSessionIdAudioTrack.getAudioSessionId();
    }

    private void maybeNotifySurfaceSizeChanged(int n2, int n3) {
        if (n2 != this.surfaceWidth || n3 != this.surfaceHeight) {
            this.surfaceWidth = n2;
            this.surfaceHeight = n3;
            this.analyticsCollector.onSurfaceSizeChanged(n2, n3);
            Iterator<VideoListener> iterator2 = this.videoListeners.iterator();
            while (iterator2.hasNext()) {
                iterator2.next().onSurfaceSizeChanged(n2, n3);
            }
        }
    }

    private void notifySkipSilenceEnabledChanged() {
        this.analyticsCollector.onSkipSilenceEnabledChanged(this.skipSilenceEnabled);
        Iterator<AudioListener> iterator2 = this.audioListeners.iterator();
        while (iterator2.hasNext()) {
            iterator2.next().onSkipSilenceEnabledChanged(this.skipSilenceEnabled);
        }
    }

    private void removeSurfaceCallbacks() {
        TextureView textureView = this.textureView;
        if (textureView != null) {
            if (textureView.getSurfaceTextureListener() != this.componentListener) {
                Log.w(TAG, "SurfaceTextureListener already unset or replaced.");
            } else {
                this.textureView.setSurfaceTextureListener(null);
            }
            this.textureView = null;
        }
        if ((textureView = this.surfaceHolder) != null) {
            textureView.removeCallback((SurfaceHolder.Callback)this.componentListener);
            this.surfaceHolder = null;
        }
    }

    private void sendRendererMessage(int n2, int n3, Object object) {
        for (Renderer renderer : this.renderers) {
            if (renderer.getTrackType() != n2) continue;
            this.player.createMessage(renderer).setType(n3).setPayload(object).send();
        }
    }

    private void sendVolumeToRenderers() {
        this.sendRendererMessage(1, 2, Float.valueOf(this.audioVolume * this.audioFocusManager.getVolumeMultiplier()));
    }

    private void setVideoDecoderOutputBufferRenderer(VideoDecoderOutputBufferRenderer videoDecoderOutputBufferRenderer) {
        this.sendRendererMessage(2, 8, videoDecoderOutputBufferRenderer);
    }

    private void setVideoSurfaceInternal(Surface surface, boolean bl) {
        Object object = new ArrayList<PlayerMessage>();
        for (Renderer renderer : this.renderers) {
            if (renderer.getTrackType() != 2) continue;
            object.add(this.player.createMessage(renderer).setType(1).setPayload(surface).send());
        }
        Surface surface2 = this.surface;
        if (surface2 != null && surface2 != surface) {
            try {
                object = object.iterator();
                while (object.hasNext()) {
                    ((PlayerMessage)object.next()).blockUntilDelivered(this.detachSurfaceTimeoutMs);
                }
            }
            catch (TimeoutException timeoutException) {
                this.player.stop(false, ExoPlaybackException.createForRenderer(new ExoTimeoutException(3)));
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            if (this.ownsSurface) {
                this.surface.release();
            }
        }
        this.surface = surface;
        this.ownsSurface = bl;
    }

    private void updatePlayWhenReady(boolean bl, int n2, int n3) {
        int n4 = 0;
        bl = bl && n2 != -1;
        int n5 = n4;
        if (bl) {
            n5 = n4;
            if (n2 != 1) {
                n5 = 1;
            }
        }
        this.player.setPlayWhenReady(bl, n5, n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateWakeAndWifiLock() {
        int n2 = this.getPlaybackState();
        boolean bl = true;
        if (n2 != 1) {
            if (n2 != 2 && n2 != 3) {
                if (n2 != 4) throw new IllegalStateException();
            } else {
                boolean bl2 = this.experimentalIsSleepingForOffload();
                WakeLockManager wakeLockManager = this.wakeLockManager;
                if (!this.getPlayWhenReady() || bl2) {
                    bl = false;
                }
                wakeLockManager.setStayAwake(bl);
                this.wifiLockManager.setStayAwake(this.getPlayWhenReady());
                return;
            }
        }
        this.wakeLockManager.setStayAwake(false);
        this.wifiLockManager.setStayAwake(false);
    }

    private void verifyApplicationThread() {
        if (Looper.myLooper() != this.getApplicationLooper()) {
            if (!this.throwsWhenUsingWrongThread) {
                IllegalStateException illegalStateException = this.hasNotifiedFullWrongThreadWarning ? null : new IllegalStateException();
                Log.w(TAG, WRONG_THREAD_ERROR_MESSAGE, illegalStateException);
                this.hasNotifiedFullWrongThreadWarning = true;
            } else {
                throw new IllegalStateException(WRONG_THREAD_ERROR_MESSAGE);
            }
        }
    }

    public void addAnalyticsListener(AnalyticsListener analyticsListener) {
        Assertions.checkNotNull(analyticsListener);
        this.analyticsCollector.addListener(analyticsListener);
    }

    @Override
    public void addAudioListener(AudioListener audioListener) {
        Assertions.checkNotNull(audioListener);
        this.audioListeners.add(audioListener);
    }

    @Override
    public void addDeviceListener(DeviceListener deviceListener) {
        Assertions.checkNotNull(deviceListener);
        this.deviceListeners.add(deviceListener);
    }

    public void addListener(Player.EventListener eventListener) {
        Assertions.checkNotNull(eventListener);
        this.player.addListener(eventListener);
    }

    public void addMediaItem(int n2, MediaItem mediaItem) {
        this.verifyApplicationThread();
        this.player.addMediaItem(n2, mediaItem);
    }

    public void addMediaItem(MediaItem mediaItem) {
        this.verifyApplicationThread();
        this.player.addMediaItem(mediaItem);
    }

    public void addMediaItems(int n2, List<MediaItem> list) {
        this.verifyApplicationThread();
        this.player.addMediaItems(n2, list);
    }

    public void addMediaItems(List<MediaItem> list) {
        this.verifyApplicationThread();
        this.player.addMediaItems(list);
    }

    public void addMediaSource(int n2, MediaSource mediaSource) {
        this.verifyApplicationThread();
        this.player.addMediaSource(n2, mediaSource);
    }

    public void addMediaSource(MediaSource mediaSource) {
        this.verifyApplicationThread();
        this.player.addMediaSource(mediaSource);
    }

    public void addMediaSources(int n2, List<MediaSource> list) {
        this.verifyApplicationThread();
        this.player.addMediaSources(n2, list);
    }

    public void addMediaSources(List<MediaSource> list) {
        this.verifyApplicationThread();
        this.player.addMediaSources(list);
    }

    @Override
    public void addMetadataOutput(MetadataOutput metadataOutput) {
        Assertions.checkNotNull(metadataOutput);
        this.metadataOutputs.add(metadataOutput);
    }

    @Override
    public void addTextOutput(TextOutput textOutput) {
        Assertions.checkNotNull(textOutput);
        this.textOutputs.add(textOutput);
    }

    @Override
    public void addVideoListener(VideoListener videoListener) {
        Assertions.checkNotNull(videoListener);
        this.videoListeners.add(videoListener);
    }

    @Override
    public void clearAuxEffectInfo() {
        this.setAuxEffectInfo(new AuxEffectInfo(0, 0.0f));
    }

    @Override
    public void clearCameraMotionListener(CameraMotionListener cameraMotionListener) {
        this.verifyApplicationThread();
        if (this.cameraMotionListener != cameraMotionListener) {
            return;
        }
        this.sendRendererMessage(6, 7, null);
    }

    public void clearMediaItems() {
        this.verifyApplicationThread();
        this.player.clearMediaItems();
    }

    @Override
    public void clearVideoFrameMetadataListener(VideoFrameMetadataListener videoFrameMetadataListener) {
        this.verifyApplicationThread();
        if (this.videoFrameMetadataListener != videoFrameMetadataListener) {
            return;
        }
        this.sendRendererMessage(2, 6, null);
    }

    @Override
    public void clearVideoSurface() {
        this.verifyApplicationThread();
        this.removeSurfaceCallbacks();
        this.setVideoSurfaceInternal(null, false);
        this.maybeNotifySurfaceSizeChanged(0, 0);
    }

    @Override
    public void clearVideoSurface(Surface surface) {
        this.verifyApplicationThread();
        if (surface != null && surface == this.surface) {
            this.clearVideoSurface();
        }
    }

    @Override
    public void clearVideoSurfaceHolder(SurfaceHolder surfaceHolder) {
        this.verifyApplicationThread();
        if (surfaceHolder != null && surfaceHolder == this.surfaceHolder) {
            this.setVideoSurfaceHolder(null);
        }
    }

    @Override
    public void clearVideoSurfaceView(SurfaceView object) {
        this.verifyApplicationThread();
        boolean bl = object instanceof VideoDecoderGLSurfaceView;
        Object var3_3 = null;
        if (bl) {
            if (object.getHolder() == this.surfaceHolder) {
                this.setVideoDecoderOutputBufferRenderer(null);
                this.surfaceHolder = null;
            }
        } else {
            object = object == null ? var3_3 : object.getHolder();
            this.clearVideoSurfaceHolder((SurfaceHolder)object);
        }
    }

    @Override
    public void clearVideoTextureView(TextureView textureView) {
        this.verifyApplicationThread();
        if (textureView != null && textureView == this.textureView) {
            this.setVideoTextureView(null);
        }
    }

    public PlayerMessage createMessage(PlayerMessage.Target target) {
        this.verifyApplicationThread();
        return this.player.createMessage(target);
    }

    @Override
    public void decreaseDeviceVolume() {
        this.verifyApplicationThread();
        this.streamVolumeManager.decreaseVolume();
    }

    public boolean experimentalIsSleepingForOffload() {
        this.verifyApplicationThread();
        return this.player.experimentalIsSleepingForOffload();
    }

    public void experimentalSetOffloadSchedulingEnabled(boolean bl) {
        this.verifyApplicationThread();
        this.player.experimentalSetOffloadSchedulingEnabled(bl);
    }

    public AnalyticsCollector getAnalyticsCollector() {
        return this.analyticsCollector;
    }

    public Looper getApplicationLooper() {
        return this.player.getApplicationLooper();
    }

    @Override
    public AudioAttributes getAudioAttributes() {
        return this.audioAttributes;
    }

    public Player.AudioComponent getAudioComponent() {
        return this;
    }

    public DecoderCounters getAudioDecoderCounters() {
        return this.audioDecoderCounters;
    }

    public Format getAudioFormat() {
        return this.audioFormat;
    }

    @Override
    public int getAudioSessionId() {
        return this.audioSessionId;
    }

    public long getBufferedPosition() {
        this.verifyApplicationThread();
        return this.player.getBufferedPosition();
    }

    public Clock getClock() {
        return this.player.getClock();
    }

    public long getContentBufferedPosition() {
        this.verifyApplicationThread();
        return this.player.getContentBufferedPosition();
    }

    public long getContentPosition() {
        this.verifyApplicationThread();
        return this.player.getContentPosition();
    }

    public int getCurrentAdGroupIndex() {
        this.verifyApplicationThread();
        return this.player.getCurrentAdGroupIndex();
    }

    public int getCurrentAdIndexInAdGroup() {
        this.verifyApplicationThread();
        return this.player.getCurrentAdIndexInAdGroup();
    }

    @Override
    public List<Cue> getCurrentCues() {
        this.verifyApplicationThread();
        return this.currentCues;
    }

    public int getCurrentPeriodIndex() {
        this.verifyApplicationThread();
        return this.player.getCurrentPeriodIndex();
    }

    public long getCurrentPosition() {
        this.verifyApplicationThread();
        return this.player.getCurrentPosition();
    }

    public List<Metadata> getCurrentStaticMetadata() {
        this.verifyApplicationThread();
        return this.player.getCurrentStaticMetadata();
    }

    public Timeline getCurrentTimeline() {
        this.verifyApplicationThread();
        return this.player.getCurrentTimeline();
    }

    public TrackGroupArray getCurrentTrackGroups() {
        this.verifyApplicationThread();
        return this.player.getCurrentTrackGroups();
    }

    public TrackSelectionArray getCurrentTrackSelections() {
        this.verifyApplicationThread();
        return this.player.getCurrentTrackSelections();
    }

    public int getCurrentWindowIndex() {
        this.verifyApplicationThread();
        return this.player.getCurrentWindowIndex();
    }

    public Player.DeviceComponent getDeviceComponent() {
        return this;
    }

    @Override
    public DeviceInfo getDeviceInfo() {
        this.verifyApplicationThread();
        return this.deviceInfo;
    }

    @Override
    public int getDeviceVolume() {
        this.verifyApplicationThread();
        return this.streamVolumeManager.getVolume();
    }

    public long getDuration() {
        this.verifyApplicationThread();
        return this.player.getDuration();
    }

    public Player.MetadataComponent getMetadataComponent() {
        return this;
    }

    public boolean getPauseAtEndOfMediaItems() {
        this.verifyApplicationThread();
        return this.player.getPauseAtEndOfMediaItems();
    }

    public boolean getPlayWhenReady() {
        this.verifyApplicationThread();
        return this.player.getPlayWhenReady();
    }

    @Deprecated
    public ExoPlaybackException getPlaybackError() {
        return this.getPlayerError();
    }

    public Looper getPlaybackLooper() {
        return this.player.getPlaybackLooper();
    }

    public PlaybackParameters getPlaybackParameters() {
        this.verifyApplicationThread();
        return this.player.getPlaybackParameters();
    }

    public int getPlaybackState() {
        this.verifyApplicationThread();
        return this.player.getPlaybackState();
    }

    public int getPlaybackSuppressionReason() {
        this.verifyApplicationThread();
        return this.player.getPlaybackSuppressionReason();
    }

    public ExoPlaybackException getPlayerError() {
        this.verifyApplicationThread();
        return this.player.getPlayerError();
    }

    public int getRendererCount() {
        this.verifyApplicationThread();
        return this.player.getRendererCount();
    }

    public int getRendererType(int n2) {
        this.verifyApplicationThread();
        return this.player.getRendererType(n2);
    }

    public int getRepeatMode() {
        this.verifyApplicationThread();
        return this.player.getRepeatMode();
    }

    public SeekParameters getSeekParameters() {
        this.verifyApplicationThread();
        return this.player.getSeekParameters();
    }

    public boolean getShuffleModeEnabled() {
        this.verifyApplicationThread();
        return this.player.getShuffleModeEnabled();
    }

    @Override
    public boolean getSkipSilenceEnabled() {
        return this.skipSilenceEnabled;
    }

    public Player.TextComponent getTextComponent() {
        return this;
    }

    public long getTotalBufferedDuration() {
        this.verifyApplicationThread();
        return this.player.getTotalBufferedDuration();
    }

    public TrackSelector getTrackSelector() {
        this.verifyApplicationThread();
        return this.player.getTrackSelector();
    }

    public Player.VideoComponent getVideoComponent() {
        return this;
    }

    public DecoderCounters getVideoDecoderCounters() {
        return this.videoDecoderCounters;
    }

    public Format getVideoFormat() {
        return this.videoFormat;
    }

    @Override
    public int getVideoScalingMode() {
        return this.videoScalingMode;
    }

    @Override
    public float getVolume() {
        return this.audioVolume;
    }

    @Override
    public void increaseDeviceVolume() {
        this.verifyApplicationThread();
        this.streamVolumeManager.increaseVolume();
    }

    @Override
    public boolean isDeviceMuted() {
        this.verifyApplicationThread();
        return this.streamVolumeManager.isMuted();
    }

    public boolean isLoading() {
        this.verifyApplicationThread();
        return this.player.isLoading();
    }

    public boolean isPlayingAd() {
        this.verifyApplicationThread();
        return this.player.isPlayingAd();
    }

    public void moveMediaItem(int n2, int n3) {
        this.verifyApplicationThread();
        this.player.moveMediaItem(n2, n3);
    }

    public void moveMediaItems(int n2, int n3, int n4) {
        this.verifyApplicationThread();
        this.player.moveMediaItems(n2, n3, n4);
    }

    public void prepare() {
        this.verifyApplicationThread();
        boolean bl = this.getPlayWhenReady();
        int n2 = this.audioFocusManager.updateAudioFocus(bl, 2);
        this.updatePlayWhenReady(bl, n2, SimpleExoPlayer.getPlayWhenReadyChangeReason(bl, n2));
        this.player.prepare();
    }

    @Deprecated
    public void prepare(MediaSource mediaSource) {
        this.prepare(mediaSource, true, true);
    }

    @Deprecated
    public void prepare(MediaSource object, boolean bl, boolean bl2) {
        this.verifyApplicationThread();
        object = Collections.singletonList(object);
        int n2 = bl ? 0 : -1;
        this.setMediaSources((List<MediaSource>)object, n2, -9223372036854775807L);
        this.prepare();
    }

    public void release() {
        AudioTrack audioTrack;
        this.verifyApplicationThread();
        if (Util.SDK_INT < 21 && (audioTrack = this.keepSessionIdAudioTrack) != null) {
            audioTrack.release();
            this.keepSessionIdAudioTrack = null;
        }
        this.audioBecomingNoisyManager.setEnabled(false);
        this.streamVolumeManager.release();
        this.wakeLockManager.setStayAwake(false);
        this.wifiLockManager.setStayAwake(false);
        this.audioFocusManager.release();
        this.player.release();
        this.analyticsCollector.release();
        this.removeSurfaceCallbacks();
        audioTrack = this.surface;
        if (audioTrack != null) {
            if (this.ownsSurface) {
                audioTrack.release();
            }
            this.surface = null;
        }
        if (this.isPriorityTaskManagerRegistered) {
            Assertions.checkNotNull(this.priorityTaskManager).remove(0);
            this.isPriorityTaskManagerRegistered = false;
        }
        this.currentCues = Collections.emptyList();
        this.playerReleased = true;
    }

    public void removeAnalyticsListener(AnalyticsListener analyticsListener) {
        this.analyticsCollector.removeListener(analyticsListener);
    }

    @Override
    public void removeAudioListener(AudioListener audioListener) {
        this.audioListeners.remove(audioListener);
    }

    @Override
    public void removeDeviceListener(DeviceListener deviceListener) {
        this.deviceListeners.remove(deviceListener);
    }

    public void removeListener(Player.EventListener eventListener) {
        this.player.removeListener(eventListener);
    }

    public void removeMediaItem(int n2) {
        this.verifyApplicationThread();
        this.player.removeMediaItem(n2);
    }

    public void removeMediaItems(int n2, int n3) {
        this.verifyApplicationThread();
        this.player.removeMediaItems(n2, n3);
    }

    @Override
    public void removeMetadataOutput(MetadataOutput metadataOutput) {
        this.metadataOutputs.remove(metadataOutput);
    }

    @Override
    public void removeTextOutput(TextOutput textOutput) {
        this.textOutputs.remove(textOutput);
    }

    @Override
    public void removeVideoListener(VideoListener videoListener) {
        this.videoListeners.remove(videoListener);
    }

    @Deprecated
    public void retry() {
        this.verifyApplicationThread();
        this.prepare();
    }

    public void seekTo(int n2, long l2) {
        this.verifyApplicationThread();
        this.analyticsCollector.notifySeekStarted();
        this.player.seekTo(n2, l2);
    }

    @Override
    public void setAudioAttributes(AudioAttributes audioAttributes, boolean bl) {
        Object object;
        this.verifyApplicationThread();
        if (this.playerReleased) {
            return;
        }
        if (!Util.areEqual(this.audioAttributes, audioAttributes)) {
            this.audioAttributes = audioAttributes;
            this.sendRendererMessage(1, 3, audioAttributes);
            this.streamVolumeManager.setStreamType(Util.getStreamTypeForAudioUsage(audioAttributes.usage));
            this.analyticsCollector.onAudioAttributesChanged(audioAttributes);
            object = this.audioListeners.iterator();
            while (object.hasNext()) {
                ((AudioListener)object.next()).onAudioAttributesChanged(audioAttributes);
            }
        }
        object = this.audioFocusManager;
        if (!bl) {
            audioAttributes = null;
        }
        ((AudioFocusManager)object).setAudioAttributes(audioAttributes);
        bl = this.getPlayWhenReady();
        int n2 = this.audioFocusManager.updateAudioFocus(bl, this.getPlaybackState());
        this.updatePlayWhenReady(bl, n2, SimpleExoPlayer.getPlayWhenReadyChangeReason(bl, n2));
    }

    @Override
    public void setAudioSessionId(int n2) {
        int n3;
        this.verifyApplicationThread();
        if (this.audioSessionId == n2) {
            return;
        }
        if (n2 == 0) {
            n3 = Util.SDK_INT < 21 ? this.initializeKeepSessionIdAudioTrack(0) : C.generateAudioSessionIdV21(this.applicationContext);
        } else {
            n3 = n2;
            if (Util.SDK_INT < 21) {
                this.initializeKeepSessionIdAudioTrack(n2);
                n3 = n2;
            }
        }
        this.audioSessionId = n3;
        this.sendRendererMessage(1, 102, n3);
        this.sendRendererMessage(2, 102, n3);
        this.analyticsCollector.onAudioSessionIdChanged(n3);
        Iterator<AudioListener> iterator2 = this.audioListeners.iterator();
        while (iterator2.hasNext()) {
            iterator2.next().onAudioSessionIdChanged(n3);
        }
    }

    @Override
    public void setAuxEffectInfo(AuxEffectInfo auxEffectInfo) {
        this.verifyApplicationThread();
        this.sendRendererMessage(1, 5, auxEffectInfo);
    }

    @Override
    public void setCameraMotionListener(CameraMotionListener cameraMotionListener) {
        this.verifyApplicationThread();
        this.cameraMotionListener = cameraMotionListener;
        this.sendRendererMessage(6, 7, cameraMotionListener);
    }

    @Override
    public void setDeviceMuted(boolean bl) {
        this.verifyApplicationThread();
        this.streamVolumeManager.setMuted(bl);
    }

    @Override
    public void setDeviceVolume(int n2) {
        this.verifyApplicationThread();
        this.streamVolumeManager.setVolume(n2);
    }

    public void setForegroundMode(boolean bl) {
        this.verifyApplicationThread();
        this.player.setForegroundMode(bl);
    }

    public void setHandleAudioBecomingNoisy(boolean bl) {
        this.verifyApplicationThread();
        if (this.playerReleased) {
            return;
        }
        this.audioBecomingNoisyManager.setEnabled(bl);
    }

    @Deprecated
    public void setHandleWakeLock(boolean bl) {
        this.setWakeMode(bl ? 1 : 0);
    }

    public void setMediaItem(MediaItem mediaItem) {
        this.verifyApplicationThread();
        this.analyticsCollector.resetForNewPlaylist();
        this.player.setMediaItem(mediaItem);
    }

    public void setMediaItem(MediaItem mediaItem, long l2) {
        this.verifyApplicationThread();
        this.analyticsCollector.resetForNewPlaylist();
        this.player.setMediaItem(mediaItem, l2);
    }

    public void setMediaItem(MediaItem mediaItem, boolean bl) {
        this.verifyApplicationThread();
        this.analyticsCollector.resetForNewPlaylist();
        this.player.setMediaItem(mediaItem, bl);
    }

    public void setMediaItems(List<MediaItem> list) {
        this.verifyApplicationThread();
        this.analyticsCollector.resetForNewPlaylist();
        this.player.setMediaItems(list);
    }

    public void setMediaItems(List<MediaItem> list, int n2, long l2) {
        this.verifyApplicationThread();
        this.analyticsCollector.resetForNewPlaylist();
        this.player.setMediaItems(list, n2, l2);
    }

    public void setMediaItems(List<MediaItem> list, boolean bl) {
        this.verifyApplicationThread();
        this.analyticsCollector.resetForNewPlaylist();
        this.player.setMediaItems(list, bl);
    }

    public void setMediaSource(MediaSource mediaSource) {
        this.verifyApplicationThread();
        this.analyticsCollector.resetForNewPlaylist();
        this.player.setMediaSource(mediaSource);
    }

    public void setMediaSource(MediaSource mediaSource, long l2) {
        this.verifyApplicationThread();
        this.analyticsCollector.resetForNewPlaylist();
        this.player.setMediaSource(mediaSource, l2);
    }

    public void setMediaSource(MediaSource mediaSource, boolean bl) {
        this.verifyApplicationThread();
        this.analyticsCollector.resetForNewPlaylist();
        this.player.setMediaSource(mediaSource, bl);
    }

    public void setMediaSources(List<MediaSource> list) {
        this.verifyApplicationThread();
        this.analyticsCollector.resetForNewPlaylist();
        this.player.setMediaSources(list);
    }

    public void setMediaSources(List<MediaSource> list, int n2, long l2) {
        this.verifyApplicationThread();
        this.analyticsCollector.resetForNewPlaylist();
        this.player.setMediaSources(list, n2, l2);
    }

    public void setMediaSources(List<MediaSource> list, boolean bl) {
        this.verifyApplicationThread();
        this.analyticsCollector.resetForNewPlaylist();
        this.player.setMediaSources(list, bl);
    }

    public void setPauseAtEndOfMediaItems(boolean bl) {
        this.verifyApplicationThread();
        this.player.setPauseAtEndOfMediaItems(bl);
    }

    public void setPlayWhenReady(boolean bl) {
        this.verifyApplicationThread();
        int n2 = this.audioFocusManager.updateAudioFocus(bl, this.getPlaybackState());
        this.updatePlayWhenReady(bl, n2, SimpleExoPlayer.getPlayWhenReadyChangeReason(bl, n2));
    }

    public void setPlaybackParameters(PlaybackParameters playbackParameters) {
        this.verifyApplicationThread();
        this.player.setPlaybackParameters(playbackParameters);
    }

    public void setPriorityTaskManager(PriorityTaskManager priorityTaskManager) {
        this.verifyApplicationThread();
        if (Util.areEqual(this.priorityTaskManager, priorityTaskManager)) {
            return;
        }
        if (this.isPriorityTaskManagerRegistered) {
            Assertions.checkNotNull(this.priorityTaskManager).remove(0);
        }
        if (priorityTaskManager != null && this.isLoading()) {
            priorityTaskManager.add(0);
            this.isPriorityTaskManagerRegistered = true;
        } else {
            this.isPriorityTaskManagerRegistered = false;
        }
        this.priorityTaskManager = priorityTaskManager;
    }

    public void setRepeatMode(int n2) {
        this.verifyApplicationThread();
        this.player.setRepeatMode(n2);
    }

    public void setSeekParameters(SeekParameters seekParameters) {
        this.verifyApplicationThread();
        this.player.setSeekParameters(seekParameters);
    }

    public void setShuffleModeEnabled(boolean bl) {
        this.verifyApplicationThread();
        this.player.setShuffleModeEnabled(bl);
    }

    public void setShuffleOrder(ShuffleOrder shuffleOrder) {
        this.verifyApplicationThread();
        this.player.setShuffleOrder(shuffleOrder);
    }

    @Override
    public void setSkipSilenceEnabled(boolean bl) {
        this.verifyApplicationThread();
        if (this.skipSilenceEnabled == bl) {
            return;
        }
        this.skipSilenceEnabled = bl;
        this.sendRendererMessage(1, 101, bl);
        this.notifySkipSilenceEnabledChanged();
    }

    public void setThrowsWhenUsingWrongThread(boolean bl) {
        this.throwsWhenUsingWrongThread = bl;
    }

    @Override
    public void setVideoFrameMetadataListener(VideoFrameMetadataListener videoFrameMetadataListener) {
        this.verifyApplicationThread();
        this.videoFrameMetadataListener = videoFrameMetadataListener;
        this.sendRendererMessage(2, 6, videoFrameMetadataListener);
    }

    @Override
    public void setVideoScalingMode(int n2) {
        this.verifyApplicationThread();
        this.videoScalingMode = n2;
        this.sendRendererMessage(2, 4, n2);
    }

    @Override
    public void setVideoSurface(Surface surface) {
        this.verifyApplicationThread();
        this.removeSurfaceCallbacks();
        if (surface != null) {
            this.setVideoDecoderOutputBufferRenderer(null);
        }
        int n2 = 0;
        this.setVideoSurfaceInternal(surface, false);
        if (surface != null) {
            n2 = -1;
        }
        this.maybeNotifySurfaceSizeChanged(n2, n2);
    }

    @Override
    public void setVideoSurfaceHolder(SurfaceHolder surfaceHolder) {
        this.verifyApplicationThread();
        this.removeSurfaceCallbacks();
        if (surfaceHolder != null) {
            this.setVideoDecoderOutputBufferRenderer(null);
        }
        this.surfaceHolder = surfaceHolder;
        if (surfaceHolder == null) {
            this.setVideoSurfaceInternal(null, false);
            this.maybeNotifySurfaceSizeChanged(0, 0);
        } else {
            surfaceHolder.addCallback((SurfaceHolder.Callback)this.componentListener);
            Surface surface = surfaceHolder.getSurface();
            if (surface != null && surface.isValid()) {
                this.setVideoSurfaceInternal(surface, false);
                surfaceHolder = surfaceHolder.getSurfaceFrame();
                this.maybeNotifySurfaceSizeChanged(surfaceHolder.width(), surfaceHolder.height());
            } else {
                this.setVideoSurfaceInternal(null, false);
                this.maybeNotifySurfaceSizeChanged(0, 0);
            }
        }
    }

    @Override
    public void setVideoSurfaceView(SurfaceView object) {
        this.verifyApplicationThread();
        if (object instanceof VideoDecoderGLSurfaceView) {
            VideoDecoderOutputBufferRenderer videoDecoderOutputBufferRenderer = ((VideoDecoderGLSurfaceView)object).getVideoDecoderOutputBufferRenderer();
            this.clearVideoSurface();
            this.surfaceHolder = object.getHolder();
            this.setVideoDecoderOutputBufferRenderer(videoDecoderOutputBufferRenderer);
        } else {
            object = object == null ? null : object.getHolder();
            this.setVideoSurfaceHolder((SurfaceHolder)object);
        }
    }

    @Override
    public void setVideoTextureView(TextureView textureView) {
        this.verifyApplicationThread();
        this.removeSurfaceCallbacks();
        if (textureView != null) {
            this.setVideoDecoderOutputBufferRenderer(null);
        }
        this.textureView = textureView;
        if (textureView == null) {
            this.setVideoSurfaceInternal(null, true);
            this.maybeNotifySurfaceSizeChanged(0, 0);
        } else {
            if (textureView.getSurfaceTextureListener() != null) {
                Log.w(TAG, "Replacing existing SurfaceTextureListener.");
            }
            textureView.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this.componentListener);
            SurfaceTexture surfaceTexture = textureView.isAvailable() ? textureView.getSurfaceTexture() : null;
            if (surfaceTexture == null) {
                this.setVideoSurfaceInternal(null, true);
                this.maybeNotifySurfaceSizeChanged(0, 0);
            } else {
                this.setVideoSurfaceInternal(new Surface(surfaceTexture), true);
                this.maybeNotifySurfaceSizeChanged(textureView.getWidth(), textureView.getHeight());
            }
        }
    }

    @Override
    public void setVolume(float f2) {
        this.verifyApplicationThread();
        f2 = Util.constrainValue(f2, 0.0f, 1.0f);
        if (this.audioVolume == f2) {
            return;
        }
        this.audioVolume = f2;
        this.sendVolumeToRenderers();
        this.analyticsCollector.onVolumeChanged(f2);
        Iterator<AudioListener> iterator2 = this.audioListeners.iterator();
        while (iterator2.hasNext()) {
            iterator2.next().onVolumeChanged(f2);
        }
    }

    public void setWakeMode(int n2) {
        this.verifyApplicationThread();
        if (n2 != 0) {
            if (n2 != 1) {
                if (n2 == 2) {
                    this.wakeLockManager.setEnabled(true);
                    this.wifiLockManager.setEnabled(true);
                }
            } else {
                this.wakeLockManager.setEnabled(true);
                this.wifiLockManager.setEnabled(false);
            }
        } else {
            this.wakeLockManager.setEnabled(false);
            this.wifiLockManager.setEnabled(false);
        }
    }

    public void stop(boolean bl) {
        this.verifyApplicationThread();
        this.audioFocusManager.updateAudioFocus(this.getPlayWhenReady(), 1);
        this.player.stop(bl);
        this.currentCues = Collections.emptyList();
    }

    public static final class Builder {
        private AnalyticsCollector analyticsCollector;
        private AudioAttributes audioAttributes;
        private BandwidthMeter bandwidthMeter;
        private boolean buildCalled;
        private Clock clock;
        private final Context context;
        private long detachSurfaceTimeoutMs;
        private boolean handleAudioBecomingNoisy;
        private boolean handleAudioFocus;
        private LivePlaybackSpeedControl livePlaybackSpeedControl;
        private LoadControl loadControl;
        private Looper looper;
        private MediaSourceFactory mediaSourceFactory;
        private boolean pauseAtEndOfMediaItems;
        private PriorityTaskManager priorityTaskManager;
        private long releaseTimeoutMs;
        private final RenderersFactory renderersFactory;
        private SeekParameters seekParameters;
        private boolean skipSilenceEnabled;
        private TrackSelector trackSelector;
        private boolean useLazyPreparation;
        private int videoScalingMode;
        private int wakeMode;

        public Builder(Context context) {
            this(context, new DefaultRenderersFactory(context), (ExtractorsFactory)new DefaultExtractorsFactory());
        }

        public Builder(Context context, RenderersFactory renderersFactory) {
            this(context, renderersFactory, (ExtractorsFactory)new DefaultExtractorsFactory());
        }

        public Builder(Context context, RenderersFactory renderersFactory, ExtractorsFactory extractorsFactory) {
            this(context, renderersFactory, (TrackSelector)new DefaultTrackSelector(context), (MediaSourceFactory)new DefaultMediaSourceFactory(context, extractorsFactory), (LoadControl)new DefaultLoadControl(), (BandwidthMeter)DefaultBandwidthMeter.getSingletonInstance((Context)context), new AnalyticsCollector(Clock.DEFAULT));
        }

        public Builder(Context context, RenderersFactory renderersFactory, TrackSelector trackSelector, MediaSourceFactory mediaSourceFactory, LoadControl loadControl, BandwidthMeter bandwidthMeter, AnalyticsCollector analyticsCollector) {
            this.context = context;
            this.renderersFactory = renderersFactory;
            this.trackSelector = trackSelector;
            this.mediaSourceFactory = mediaSourceFactory;
            this.loadControl = loadControl;
            this.bandwidthMeter = bandwidthMeter;
            this.analyticsCollector = analyticsCollector;
            this.looper = Util.getCurrentOrMainLooper();
            this.audioAttributes = AudioAttributes.DEFAULT;
            this.wakeMode = 0;
            this.videoScalingMode = 1;
            this.useLazyPreparation = true;
            this.seekParameters = SeekParameters.DEFAULT;
            this.livePlaybackSpeedControl = new DefaultLivePlaybackSpeedControl.Builder().build();
            this.clock = Clock.DEFAULT;
            this.releaseTimeoutMs = 500L;
            this.detachSurfaceTimeoutMs = 2000L;
        }

        public Builder(Context context, ExtractorsFactory extractorsFactory) {
            this(context, new DefaultRenderersFactory(context), extractorsFactory);
        }

        public SimpleExoPlayer build() {
            Assertions.checkState(this.buildCalled ^ true);
            this.buildCalled = true;
            return new SimpleExoPlayer(this);
        }

        public Builder setAnalyticsCollector(AnalyticsCollector analyticsCollector) {
            Assertions.checkState(this.buildCalled ^ true);
            this.analyticsCollector = analyticsCollector;
            return this;
        }

        public Builder setAudioAttributes(AudioAttributes audioAttributes, boolean bl) {
            Assertions.checkState(this.buildCalled ^ true);
            this.audioAttributes = audioAttributes;
            this.handleAudioFocus = bl;
            return this;
        }

        public Builder setBandwidthMeter(BandwidthMeter bandwidthMeter) {
            Assertions.checkState(this.buildCalled ^ true);
            this.bandwidthMeter = bandwidthMeter;
            return this;
        }

        public Builder setClock(Clock clock) {
            Assertions.checkState(this.buildCalled ^ true);
            this.clock = clock;
            return this;
        }

        public Builder setDetachSurfaceTimeoutMs(long l2) {
            Assertions.checkState(this.buildCalled ^ true);
            this.detachSurfaceTimeoutMs = l2;
            return this;
        }

        public Builder setHandleAudioBecomingNoisy(boolean bl) {
            Assertions.checkState(this.buildCalled ^ true);
            this.handleAudioBecomingNoisy = bl;
            return this;
        }

        public Builder setLivePlaybackSpeedControl(LivePlaybackSpeedControl livePlaybackSpeedControl) {
            Assertions.checkState(this.buildCalled ^ true);
            this.livePlaybackSpeedControl = livePlaybackSpeedControl;
            return this;
        }

        public Builder setLoadControl(LoadControl loadControl) {
            Assertions.checkState(this.buildCalled ^ true);
            this.loadControl = loadControl;
            return this;
        }

        public Builder setLooper(Looper looper) {
            Assertions.checkState(this.buildCalled ^ true);
            this.looper = looper;
            return this;
        }

        public Builder setMediaSourceFactory(MediaSourceFactory mediaSourceFactory) {
            Assertions.checkState(this.buildCalled ^ true);
            this.mediaSourceFactory = mediaSourceFactory;
            return this;
        }

        public Builder setPauseAtEndOfMediaItems(boolean bl) {
            Assertions.checkState(this.buildCalled ^ true);
            this.pauseAtEndOfMediaItems = bl;
            return this;
        }

        public Builder setPriorityTaskManager(PriorityTaskManager priorityTaskManager) {
            Assertions.checkState(this.buildCalled ^ true);
            this.priorityTaskManager = priorityTaskManager;
            return this;
        }

        public Builder setReleaseTimeoutMs(long l2) {
            Assertions.checkState(this.buildCalled ^ true);
            this.releaseTimeoutMs = l2;
            return this;
        }

        public Builder setSeekParameters(SeekParameters seekParameters) {
            Assertions.checkState(this.buildCalled ^ true);
            this.seekParameters = seekParameters;
            return this;
        }

        public Builder setSkipSilenceEnabled(boolean bl) {
            Assertions.checkState(this.buildCalled ^ true);
            this.skipSilenceEnabled = bl;
            return this;
        }

        public Builder setTrackSelector(TrackSelector trackSelector) {
            Assertions.checkState(this.buildCalled ^ true);
            this.trackSelector = trackSelector;
            return this;
        }

        public Builder setUseLazyPreparation(boolean bl) {
            Assertions.checkState(this.buildCalled ^ true);
            this.useLazyPreparation = bl;
            return this;
        }

        public Builder setVideoScalingMode(int n2) {
            Assertions.checkState(this.buildCalled ^ true);
            this.videoScalingMode = n2;
            return this;
        }

        public Builder setWakeMode(int n2) {
            Assertions.checkState(this.buildCalled ^ true);
            this.wakeMode = n2;
            return this;
        }
    }

    private final class ComponentListener
    implements VideoRendererEventListener,
    AudioRendererEventListener,
    TextOutput,
    MetadataOutput,
    SurfaceHolder.Callback,
    TextureView.SurfaceTextureListener,
    AudioFocusManager.PlayerControl,
    AudioBecomingNoisyManager.EventListener,
    StreamVolumeManager.Listener,
    Player.EventListener {
        private ComponentListener() {
        }

        @Override
        public void executePlayerCommand(int n2) {
            boolean bl = SimpleExoPlayer.this.getPlayWhenReady();
            SimpleExoPlayer.this.updatePlayWhenReady(bl, n2, SimpleExoPlayer.getPlayWhenReadyChangeReason(bl, n2));
        }

        public void onAudioBecomingNoisy() {
            SimpleExoPlayer.this.updatePlayWhenReady(false, -1, 3);
        }

        @Override
        public void onAudioDecoderInitialized(String string2, long l2, long l3) {
            SimpleExoPlayer.this.analyticsCollector.onAudioDecoderInitialized(string2, l2, l3);
        }

        @Override
        public void onAudioDecoderReleased(String string2) {
            SimpleExoPlayer.this.analyticsCollector.onAudioDecoderReleased(string2);
        }

        @Override
        public void onAudioDisabled(DecoderCounters decoderCounters) {
            SimpleExoPlayer.this.analyticsCollector.onAudioDisabled(decoderCounters);
            SimpleExoPlayer.access$2902(SimpleExoPlayer.this, null);
            SimpleExoPlayer.access$2802(SimpleExoPlayer.this, null);
        }

        @Override
        public void onAudioEnabled(DecoderCounters decoderCounters) {
            SimpleExoPlayer.access$2802(SimpleExoPlayer.this, decoderCounters);
            SimpleExoPlayer.this.analyticsCollector.onAudioEnabled(decoderCounters);
        }

        @Override
        @Deprecated
        public /* synthetic */ void onAudioInputFormatChanged(Format format) {
            AudioRendererEventListener._CC.$default$onAudioInputFormatChanged((AudioRendererEventListener)this, (Format)format);
        }

        @Override
        public void onAudioInputFormatChanged(Format format, DecoderReuseEvaluation decoderReuseEvaluation) {
            SimpleExoPlayer.access$2902(SimpleExoPlayer.this, format);
            SimpleExoPlayer.this.analyticsCollector.onAudioInputFormatChanged(format, decoderReuseEvaluation);
        }

        @Override
        public void onAudioPositionAdvancing(long l2) {
            SimpleExoPlayer.this.analyticsCollector.onAudioPositionAdvancing(l2);
        }

        @Override
        public void onAudioSinkError(Exception exception) {
            SimpleExoPlayer.this.analyticsCollector.onAudioSinkError(exception);
        }

        @Override
        public void onAudioUnderrun(int n2, long l2, long l3) {
            SimpleExoPlayer.this.analyticsCollector.onAudioUnderrun(n2, l2, l3);
        }

        public void onCues(List<Cue> list) {
            SimpleExoPlayer.access$3202(SimpleExoPlayer.this, list);
            Iterator iterator2 = SimpleExoPlayer.this.textOutputs.iterator();
            while (iterator2.hasNext()) {
                ((TextOutput)iterator2.next()).onCues(list);
            }
        }

        @Override
        public void onDroppedFrames(int n2, long l2) {
            SimpleExoPlayer.this.analyticsCollector.onDroppedFrames(n2, l2);
        }

        @Override
        public /* synthetic */ void onEvents(Player player, Player.Events events) {
            Player.EventListener._CC.$default$onEvents((Player.EventListener)this, (Player)player, (Player.Events)events);
        }

        @Override
        public /* synthetic */ void onExperimentalOffloadSchedulingEnabledChanged(boolean bl) {
            Player.EventListener._CC.$default$onExperimentalOffloadSchedulingEnabledChanged((Player.EventListener)this, (boolean)bl);
        }

        @Override
        public void onExperimentalSleepingForOffloadChanged(boolean bl) {
            SimpleExoPlayer.this.updateWakeAndWifiLock();
        }

        @Override
        public void onIsLoadingChanged(boolean bl) {
            if (SimpleExoPlayer.this.priorityTaskManager != null) {
                if (bl && !SimpleExoPlayer.this.isPriorityTaskManagerRegistered) {
                    SimpleExoPlayer.this.priorityTaskManager.add(0);
                    SimpleExoPlayer.access$4502(SimpleExoPlayer.this, true);
                } else if (!bl && SimpleExoPlayer.this.isPriorityTaskManagerRegistered) {
                    SimpleExoPlayer.this.priorityTaskManager.remove(0);
                    SimpleExoPlayer.access$4502(SimpleExoPlayer.this, false);
                }
            }
        }

        @Override
        public /* synthetic */ void onIsPlayingChanged(boolean bl) {
            Player.EventListener._CC.$default$onIsPlayingChanged((Player.EventListener)this, (boolean)bl);
        }

        @Override
        @Deprecated
        public /* synthetic */ void onLoadingChanged(boolean bl) {
            Player.EventListener._CC.$default$onLoadingChanged((Player.EventListener)this, (boolean)bl);
        }

        @Override
        public /* synthetic */ void onMediaItemTransition(MediaItem mediaItem, int n2) {
            Player.EventListener._CC.$default$onMediaItemTransition((Player.EventListener)this, (MediaItem)mediaItem, (int)n2);
        }

        @Override
        public void onMetadata(Metadata metadata) {
            SimpleExoPlayer.this.analyticsCollector.onMetadata(metadata);
            Iterator iterator2 = SimpleExoPlayer.this.metadataOutputs.iterator();
            while (iterator2.hasNext()) {
                ((MetadataOutput)iterator2.next()).onMetadata(metadata);
            }
        }

        @Override
        public void onPlayWhenReadyChanged(boolean bl, int n2) {
            SimpleExoPlayer.this.updateWakeAndWifiLock();
        }

        @Override
        public /* synthetic */ void onPlaybackParametersChanged(PlaybackParameters playbackParameters) {
            Player.EventListener._CC.$default$onPlaybackParametersChanged((Player.EventListener)this, (PlaybackParameters)playbackParameters);
        }

        @Override
        public void onPlaybackStateChanged(int n2) {
            SimpleExoPlayer.this.updateWakeAndWifiLock();
        }

        @Override
        public /* synthetic */ void onPlaybackSuppressionReasonChanged(int n2) {
            Player.EventListener._CC.$default$onPlaybackSuppressionReasonChanged((Player.EventListener)this, (int)n2);
        }

        @Override
        public /* synthetic */ void onPlayerError(ExoPlaybackException exoPlaybackException) {
            Player.EventListener._CC.$default$onPlayerError((Player.EventListener)this, (ExoPlaybackException)exoPlaybackException);
        }

        @Override
        @Deprecated
        public /* synthetic */ void onPlayerStateChanged(boolean bl, int n2) {
            Player.EventListener._CC.$default$onPlayerStateChanged((Player.EventListener)this, (boolean)bl, (int)n2);
        }

        @Override
        public /* synthetic */ void onPositionDiscontinuity(int n2) {
            Player.EventListener._CC.$default$onPositionDiscontinuity((Player.EventListener)this, (int)n2);
        }

        @Override
        public void onRenderedFirstFrame(Surface object) {
            SimpleExoPlayer.this.analyticsCollector.onRenderedFirstFrame((Surface)object);
            if (SimpleExoPlayer.this.surface == object) {
                object = SimpleExoPlayer.this.videoListeners.iterator();
                while (object.hasNext()) {
                    ((VideoListener)object.next()).onRenderedFirstFrame();
                }
            }
        }

        @Override
        public /* synthetic */ void onRepeatModeChanged(int n2) {
            Player.EventListener._CC.$default$onRepeatModeChanged((Player.EventListener)this, (int)n2);
        }

        @Override
        @Deprecated
        public /* synthetic */ void onSeekProcessed() {
            Player.EventListener._CC.$default$onSeekProcessed((Player.EventListener)this);
        }

        @Override
        public /* synthetic */ void onShuffleModeEnabledChanged(boolean bl) {
            Player.EventListener._CC.$default$onShuffleModeEnabledChanged((Player.EventListener)this, (boolean)bl);
        }

        @Override
        public void onSkipSilenceEnabledChanged(boolean bl) {
            if (SimpleExoPlayer.this.skipSilenceEnabled == bl) {
                return;
            }
            SimpleExoPlayer.access$3002(SimpleExoPlayer.this, bl);
            SimpleExoPlayer.this.notifySkipSilenceEnabledChanged();
        }

        @Override
        public /* synthetic */ void onStaticMetadataChanged(List<Metadata> list) {
            Player.EventListener._CC.$default$onStaticMetadataChanged((Player.EventListener)this, list);
        }

        @Override
        public void onStreamTypeChanged(int n2) {
            DeviceInfo deviceInfo = SimpleExoPlayer.createDeviceInfo(SimpleExoPlayer.this.streamVolumeManager);
            if (!deviceInfo.equals(SimpleExoPlayer.this.deviceInfo)) {
                SimpleExoPlayer.access$4202(SimpleExoPlayer.this, deviceInfo);
                Iterator iterator2 = SimpleExoPlayer.this.deviceListeners.iterator();
                while (iterator2.hasNext()) {
                    ((DeviceListener)iterator2.next()).onDeviceInfoChanged(deviceInfo);
                }
            }
        }

        @Override
        public void onStreamVolumeChanged(int n2, boolean bl) {
            Iterator iterator2 = SimpleExoPlayer.this.deviceListeners.iterator();
            while (iterator2.hasNext()) {
                ((DeviceListener)iterator2.next()).onDeviceVolumeChanged(n2, bl);
            }
        }

        public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n2, int n3) {
            SimpleExoPlayer.this.setVideoSurfaceInternal(new Surface(surfaceTexture), true);
            SimpleExoPlayer.this.maybeNotifySurfaceSizeChanged(n2, n3);
        }

        public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
            SimpleExoPlayer.this.setVideoSurfaceInternal(null, true);
            SimpleExoPlayer.this.maybeNotifySurfaceSizeChanged(0, 0);
            return true;
        }

        public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n2, int n3) {
            SimpleExoPlayer.this.maybeNotifySurfaceSizeChanged(n2, n3);
        }

        public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        }

        @Override
        public /* synthetic */ void onTimelineChanged(Timeline timeline, int n2) {
            Player.EventListener._CC.$default$onTimelineChanged((Player.EventListener)this, (Timeline)timeline, (int)n2);
        }

        @Override
        @Deprecated
        public /* synthetic */ void onTimelineChanged(Timeline timeline, Object object, int n2) {
            Player.EventListener._CC.$default$onTimelineChanged((Player.EventListener)this, (Timeline)timeline, (Object)object, (int)n2);
        }

        @Override
        public /* synthetic */ void onTracksChanged(TrackGroupArray trackGroupArray, TrackSelectionArray trackSelectionArray) {
            Player.EventListener._CC.$default$onTracksChanged((Player.EventListener)this, (TrackGroupArray)trackGroupArray, (TrackSelectionArray)trackSelectionArray);
        }

        @Override
        public void onVideoDecoderInitialized(String string2, long l2, long l3) {
            SimpleExoPlayer.this.analyticsCollector.onVideoDecoderInitialized(string2, l2, l3);
        }

        @Override
        public void onVideoDecoderReleased(String string2) {
            SimpleExoPlayer.this.analyticsCollector.onVideoDecoderReleased(string2);
        }

        @Override
        public void onVideoDisabled(DecoderCounters decoderCounters) {
            SimpleExoPlayer.this.analyticsCollector.onVideoDisabled(decoderCounters);
            SimpleExoPlayer.access$2502(SimpleExoPlayer.this, null);
            SimpleExoPlayer.access$2302(SimpleExoPlayer.this, null);
        }

        @Override
        public void onVideoEnabled(DecoderCounters decoderCounters) {
            SimpleExoPlayer.access$2302(SimpleExoPlayer.this, decoderCounters);
            SimpleExoPlayer.this.analyticsCollector.onVideoEnabled(decoderCounters);
        }

        @Override
        public void onVideoFrameProcessingOffset(long l2, int n2) {
            SimpleExoPlayer.this.analyticsCollector.onVideoFrameProcessingOffset(l2, n2);
        }

        @Override
        @Deprecated
        public /* synthetic */ void onVideoInputFormatChanged(Format format) {
            VideoRendererEventListener._CC.$default$onVideoInputFormatChanged((VideoRendererEventListener)this, (Format)format);
        }

        @Override
        public void onVideoInputFormatChanged(Format format, DecoderReuseEvaluation decoderReuseEvaluation) {
            SimpleExoPlayer.access$2502(SimpleExoPlayer.this, format);
            SimpleExoPlayer.this.analyticsCollector.onVideoInputFormatChanged(format, decoderReuseEvaluation);
        }

        @Override
        public void onVideoSizeChanged(int n2, int n3, int n4, float f2) {
            SimpleExoPlayer.this.analyticsCollector.onVideoSizeChanged(n2, n3, n4, f2);
            Iterator iterator2 = SimpleExoPlayer.this.videoListeners.iterator();
            while (iterator2.hasNext()) {
                ((VideoListener)iterator2.next()).onVideoSizeChanged(n2, n3, n4, f2);
            }
        }

        @Override
        public void setVolumeMultiplier(float f2) {
            SimpleExoPlayer.this.sendVolumeToRenderers();
        }

        public void surfaceChanged(SurfaceHolder surfaceHolder, int n2, int n3, int n4) {
            SimpleExoPlayer.this.maybeNotifySurfaceSizeChanged(n3, n4);
        }

        public void surfaceCreated(SurfaceHolder surfaceHolder) {
            SimpleExoPlayer.this.setVideoSurfaceInternal(surfaceHolder.getSurface(), false);
        }

        public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
            SimpleExoPlayer.this.setVideoSurfaceInternal(null, false);
            SimpleExoPlayer.this.maybeNotifySurfaceSizeChanged(0, 0);
        }
    }
}

