/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2;

import android.os.Handler;
import android.os.Looper;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.IllegalSeekPositionException;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Clock;
import java.util.concurrent.TimeoutException;

public final class PlayerMessage {
    private final Clock clock;
    private boolean deleteAfterDelivery;
    private boolean isCanceled;
    private boolean isDelivered;
    private boolean isProcessed;
    private boolean isSent;
    private Looper looper;
    private Object payload;
    private long positionMs;
    private final Sender sender;
    private final Target target;
    private final Timeline timeline;
    private int type;
    private int windowIndex;

    public PlayerMessage(Sender sender, Target target, Timeline timeline, int n2, Clock clock, Looper looper) {
        this.sender = sender;
        this.target = target;
        this.timeline = timeline;
        this.looper = looper;
        this.clock = clock;
        this.windowIndex = n2;
        this.positionMs = -9223372036854775807L;
        this.deleteAfterDelivery = true;
    }

    public boolean blockUntilDelivered() throws InterruptedException {
        synchronized (this) {
            Assertions.checkState(this.isSent);
            boolean bl = this.looper.getThread() != Thread.currentThread();
            try {
                Assertions.checkState(bl);
                while (!this.isProcessed) {
                    this.wait();
                }
                bl = this.isDelivered;
                return bl;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean blockUntilDelivered(long l2) throws InterruptedException, TimeoutException {
        synchronized (this) {
            Assertions.checkState(this.isSent);
            boolean bl = this.looper.getThread() != Thread.currentThread();
            Assertions.checkState(bl);
            long l3 = this.clock.elapsedRealtime();
            long l4 = l2;
            while (!this.isProcessed && l4 > 0L) {
                this.wait(l4);
                l4 = l3 + l2 - this.clock.elapsedRealtime();
            }
            if (this.isProcessed) {
                return this.isDelivered;
            }
            TimeoutException timeoutException = new TimeoutException("Message delivery timed out.");
            throw timeoutException;
        }
    }

    public PlayerMessage cancel() {
        synchronized (this) {
            Assertions.checkState(this.isSent);
            this.isCanceled = true;
            this.markAsProcessed(false);
            return this;
        }
    }

    public boolean getDeleteAfterDelivery() {
        return this.deleteAfterDelivery;
    }

    public Looper getLooper() {
        return this.looper;
    }

    public Object getPayload() {
        return this.payload;
    }

    public long getPositionMs() {
        return this.positionMs;
    }

    public Target getTarget() {
        return this.target;
    }

    public Timeline getTimeline() {
        return this.timeline;
    }

    public int getType() {
        return this.type;
    }

    public int getWindowIndex() {
        return this.windowIndex;
    }

    public boolean isCanceled() {
        synchronized (this) {
            boolean bl = this.isCanceled;
            return bl;
        }
    }

    public void markAsProcessed(boolean bl) {
        synchronized (this) {
            this.isDelivered = bl | this.isDelivered;
            this.isProcessed = true;
            this.notifyAll();
            return;
        }
    }

    public PlayerMessage send() {
        Assertions.checkState(this.isSent ^ true);
        if (this.positionMs == -9223372036854775807L) {
            Assertions.checkArgument(this.deleteAfterDelivery);
        }
        this.isSent = true;
        this.sender.sendMessage(this);
        return this;
    }

    public PlayerMessage setDeleteAfterDelivery(boolean bl) {
        Assertions.checkState(this.isSent ^ true);
        this.deleteAfterDelivery = bl;
        return this;
    }

    @Deprecated
    public PlayerMessage setHandler(Handler handler) {
        return this.setLooper(handler.getLooper());
    }

    public PlayerMessage setLooper(Looper looper) {
        Assertions.checkState(this.isSent ^ true);
        this.looper = looper;
        return this;
    }

    public PlayerMessage setPayload(Object object) {
        Assertions.checkState(this.isSent ^ true);
        this.payload = object;
        return this;
    }

    public PlayerMessage setPosition(int n2, long l2) {
        boolean bl = this.isSent;
        boolean bl2 = true;
        Assertions.checkState(bl ^ true);
        if (l2 == -9223372036854775807L) {
            bl2 = false;
        }
        Assertions.checkArgument(bl2);
        if (n2 >= 0 && (this.timeline.isEmpty() || n2 < this.timeline.getWindowCount())) {
            this.windowIndex = n2;
            this.positionMs = l2;
            return this;
        }
        throw new IllegalSeekPositionException(this.timeline, n2, l2);
    }

    public PlayerMessage setPosition(long l2) {
        Assertions.checkState(this.isSent ^ true);
        this.positionMs = l2;
        return this;
    }

    public PlayerMessage setType(int n2) {
        Assertions.checkState(this.isSent ^ true);
        this.type = n2;
        return this;
    }

    public static interface Sender {
        public void sendMessage(PlayerMessage var1);
    }

    public static interface Target {
        public void handleMessage(int var1, Object var2) throws ExoPlaybackException;
    }
}

