/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.util.Pair;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.DefaultMediaClock;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.LivePlaybackSpeedControl;
import com.google.android.exoplayer2.LoadControl;
import com.google.android.exoplayer2.MediaPeriodHolder;
import com.google.android.exoplayer2.MediaPeriodInfo;
import com.google.android.exoplayer2.MediaPeriodQueue;
import com.google.android.exoplayer2.MediaSourceList;
import com.google.android.exoplayer2.PlaybackInfo;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.PlayerMessage;
import com.google.android.exoplayer2.PlaylistTimeline;
import com.google.android.exoplayer2.Renderer;
import com.google.android.exoplayer2.RendererCapabilities;
import com.google.android.exoplayer2.RendererConfiguration;
import com.google.android.exoplayer2.SeekParameters;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2._$;
import com.google.android.exoplayer2._$$Lambda$WCNOc30RWlKfWWqwDTxwdaoGH_w;
import com.google.android.exoplayer2.analytics.AnalyticsCollector;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.source.MediaPeriod;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.SampleStream;
import com.google.android.exoplayer2.source.ShuffleOrder;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.text.TextRenderer;
import com.google.android.exoplayer2.trackselection.ExoTrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelectorResult;
import com.google.android.exoplayer2.upstream.BandwidthMeter;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Clock;
import com.google.android.exoplayer2.util.HandlerWrapper;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.TraceUtil;
import com.google.android.exoplayer2.util.Util;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

final class ExoPlayerImplInternal
implements Handler.Callback,
MediaPeriod.Callback,
TrackSelector.InvalidationListener,
MediaSourceList.MediaSourceListInfoRefreshListener,
DefaultMediaClock.PlaybackParametersListener,
PlayerMessage.Sender {
    private static final int ACTIVE_INTERVAL_MS = 10;
    private static final int IDLE_INTERVAL_MS = 1000;
    private static final long MIN_RENDERER_SLEEP_DURATION_MS = 2000L;
    private static final int MSG_ADD_MEDIA_SOURCES = 18;
    private static final int MSG_ATTEMPT_ERROR_RECOVERY = 25;
    private static final int MSG_DO_SOME_WORK = 2;
    private static final int MSG_MOVE_MEDIA_SOURCES = 19;
    private static final int MSG_PERIOD_PREPARED = 8;
    private static final int MSG_PLAYBACK_PARAMETERS_CHANGED_INTERNAL = 16;
    private static final int MSG_PLAYLIST_UPDATE_REQUESTED = 22;
    private static final int MSG_PREPARE = 0;
    private static final int MSG_RELEASE = 7;
    private static final int MSG_REMOVE_MEDIA_SOURCES = 20;
    private static final int MSG_SEEK_TO = 3;
    private static final int MSG_SEND_MESSAGE = 14;
    private static final int MSG_SEND_MESSAGE_TO_TARGET_THREAD = 15;
    private static final int MSG_SET_FOREGROUND_MODE = 13;
    private static final int MSG_SET_MEDIA_SOURCES = 17;
    private static final int MSG_SET_OFFLOAD_SCHEDULING_ENABLED = 24;
    private static final int MSG_SET_PAUSE_AT_END_OF_WINDOW = 23;
    private static final int MSG_SET_PLAYBACK_PARAMETERS = 4;
    private static final int MSG_SET_PLAY_WHEN_READY = 1;
    private static final int MSG_SET_REPEAT_MODE = 11;
    private static final int MSG_SET_SEEK_PARAMETERS = 5;
    private static final int MSG_SET_SHUFFLE_ENABLED = 12;
    private static final int MSG_SET_SHUFFLE_ORDER = 21;
    private static final int MSG_SOURCE_CONTINUE_LOADING_REQUESTED = 9;
    private static final int MSG_STOP = 6;
    private static final int MSG_TRACK_SELECTION_INVALIDATED = 10;
    private static final String TAG = "ExoPlayerImplInternal";
    private final long backBufferDurationUs;
    private final BandwidthMeter bandwidthMeter;
    private final Clock clock;
    private boolean deliverPendingMessageAtStartPositionRequired;
    private final TrackSelectorResult emptyTrackSelectorResult;
    private int enabledRendererCount;
    private boolean foregroundMode;
    private final HandlerWrapper handler;
    private final HandlerThread internalPlaybackThread;
    private boolean isRebuffering;
    private final LivePlaybackSpeedControl livePlaybackSpeedControl;
    private final LoadControl loadControl;
    private final DefaultMediaClock mediaClock;
    private final MediaSourceList mediaSourceList;
    private int nextPendingMessageIndexHint;
    private boolean offloadSchedulingEnabled;
    private boolean pauseAtEndOfWindow;
    private SeekPosition pendingInitialSeekPosition;
    private final ArrayList<PendingMessageInfo> pendingMessages;
    private boolean pendingPauseAtEndOfPeriod;
    private ExoPlaybackException pendingRecoverableError;
    private final Timeline.Period period;
    private PlaybackInfo playbackInfo;
    private PlaybackInfoUpdate playbackInfoUpdate;
    private final PlaybackInfoUpdateListener playbackInfoUpdateListener;
    private final Looper playbackLooper;
    private final MediaPeriodQueue queue;
    private final long releaseTimeoutMs;
    private boolean released;
    private final RendererCapabilities[] rendererCapabilities;
    private long rendererPositionUs;
    private final Renderer[] renderers;
    private int repeatMode;
    private boolean requestForRendererSleep;
    private final boolean retainBackBufferFromKeyframe;
    private SeekParameters seekParameters;
    private long setForegroundModeTimeoutMs;
    private boolean shouldContinueLoading;
    private boolean shuffleModeEnabled;
    private final TrackSelector trackSelector;
    private final Timeline.Window window;

    public ExoPlayerImplInternal(Renderer[] handler, TrackSelector trackSelector, TrackSelectorResult trackSelectorResult, LoadControl loadControl, BandwidthMeter bandwidthMeter, int n2, boolean bl, AnalyticsCollector analyticsCollector, SeekParameters seekParameters, LivePlaybackSpeedControl livePlaybackSpeedControl, long l2, boolean bl2, Looper looper, Clock clock, PlaybackInfoUpdateListener playbackInfoUpdateListener) {
        this.playbackInfoUpdateListener = playbackInfoUpdateListener;
        this.renderers = handler;
        this.trackSelector = trackSelector;
        this.emptyTrackSelectorResult = trackSelectorResult;
        this.loadControl = loadControl;
        this.bandwidthMeter = bandwidthMeter;
        this.repeatMode = n2;
        this.shuffleModeEnabled = bl;
        this.seekParameters = seekParameters;
        this.livePlaybackSpeedControl = livePlaybackSpeedControl;
        this.releaseTimeoutMs = l2;
        this.setForegroundModeTimeoutMs = l2;
        this.pauseAtEndOfWindow = bl2;
        this.clock = clock;
        this.backBufferDurationUs = loadControl.getBackBufferDurationUs();
        this.retainBackBufferFromKeyframe = loadControl.retainBackBufferFromKeyframe();
        this.playbackInfo = PlaybackInfo.createDummy((TrackSelectorResult)trackSelectorResult);
        this.playbackInfoUpdate = new PlaybackInfoUpdate(this.playbackInfo);
        this.rendererCapabilities = new RendererCapabilities[((Renderer[])handler).length];
        for (n2 = 0; n2 < ((Renderer[])handler).length; ++n2) {
            handler[n2].setIndex(n2);
            this.rendererCapabilities[n2] = handler[n2].getCapabilities();
        }
        this.mediaClock = new DefaultMediaClock((DefaultMediaClock.PlaybackParametersListener)this, clock);
        this.pendingMessages = new ArrayList();
        this.window = new Timeline.Window();
        this.period = new Timeline.Period();
        trackSelector.init((TrackSelector.InvalidationListener)this, bandwidthMeter);
        this.deliverPendingMessageAtStartPositionRequired = true;
        handler = new Handler(looper);
        this.queue = new MediaPeriodQueue(analyticsCollector, handler);
        this.mediaSourceList = new MediaSourceList((MediaSourceList.MediaSourceListInfoRefreshListener)this, analyticsCollector, handler);
        this.internalPlaybackThread = new HandlerThread("ExoPlayer:Playback", -16);
        this.internalPlaybackThread.start();
        this.playbackLooper = this.internalPlaybackThread.getLooper();
        this.handler = clock.createHandler(this.playbackLooper, (Handler.Callback)this);
    }

    static /* synthetic */ boolean access$602(ExoPlayerImplInternal exoPlayerImplInternal, boolean bl) {
        exoPlayerImplInternal.requestForRendererSleep = bl;
        return bl;
    }

    private void addMediaItemsInternal(MediaSourceListUpdateMessage mediaSourceListUpdateMessage, int n2) throws ExoPlaybackException {
        this.playbackInfoUpdate.incrementPendingOperationAcks(1);
        MediaSourceList mediaSourceList = this.mediaSourceList;
        int n3 = n2;
        if (n2 == -1) {
            n3 = mediaSourceList.getSize();
        }
        this.handleMediaSourceListInfoRefreshed(mediaSourceList.addMediaSources(n3, mediaSourceListUpdateMessage.mediaSourceHolders, mediaSourceListUpdateMessage.shuffleOrder));
    }

    private void attemptErrorRecovery(ExoPlaybackException exoPlaybackException) throws ExoPlaybackException {
        boolean bl = exoPlaybackException.isRecoverable && exoPlaybackException.type == 1;
        Assertions.checkArgument(bl);
        try {
            this.seekToCurrentPosition(true);
            return;
        }
        catch (Exception exception) {
            exoPlaybackException.addSuppressed(exception);
            throw exoPlaybackException;
        }
    }

    private void deliverMessage(PlayerMessage playerMessage) throws ExoPlaybackException {
        if (playerMessage.isCanceled()) {
            return;
        }
        try {
            playerMessage.getTarget().handleMessage(playerMessage.getType(), playerMessage.getPayload());
            return;
        }
        finally {
            playerMessage.markAsProcessed(true);
        }
    }

    private void disableRenderer(Renderer renderer) throws ExoPlaybackException {
        if (!ExoPlayerImplInternal.isRendererEnabled(renderer)) {
            return;
        }
        this.mediaClock.onRendererDisabled(renderer);
        this.ensureStopped(renderer);
        renderer.disable();
        --this.enabledRendererCount;
    }

    private void doSomeWork() throws ExoPlaybackException, IOException {
        long l2 = this.clock.uptimeMillis();
        this.updatePeriods();
        if (this.playbackInfo.playbackState != 1 && this.playbackInfo.playbackState != 4) {
            boolean bl;
            int n2;
            Object object;
            boolean bl2;
            int n3;
            long l3;
            MediaPeriodHolder mediaPeriodHolder = this.queue.getPlayingPeriod();
            if (mediaPeriodHolder == null) {
                this.scheduleNextWork(l2, 10L);
                return;
            }
            TraceUtil.beginSection((String)"doSomeWork");
            this.updatePlaybackPositions();
            if (mediaPeriodHolder.prepared) {
                l3 = SystemClock.elapsedRealtime();
                mediaPeriodHolder.mediaPeriod.discardBuffer(this.playbackInfo.positionUs - this.backBufferDurationUs, this.retainBackBufferFromKeyframe);
                int n4 = 0;
                n3 = 1;
                bl2 = true;
                while (true) {
                    object = this.renderers;
                    n2 = n3;
                    bl = bl2;
                    if (n4 < ((Renderer[])object).length) {
                        if (ExoPlayerImplInternal.isRendererEnabled((Renderer)(object = object[n4]))) {
                            object.render(this.rendererPositionUs, l3 * 1000L);
                            n3 = n3 != 0 && object.isEnded() ? 1 : 0;
                            n2 = mediaPeriodHolder.sampleStreams[n4] != object.getStream() ? 1 : 0;
                            boolean bl3 = n2 == 0 && object.hasReadStreamToEnd();
                            n2 = !(n2 != 0 || bl3 || object.isReady() || object.isEnded()) ? 0 : 1;
                            bl2 = bl2 && n2 != 0;
                            if (n2 == 0) {
                                object.maybeThrowStreamError();
                            }
                        }
                        ++n4;
                        continue;
                    }
                    break;
                }
            } else {
                mediaPeriodHolder.mediaPeriod.maybeThrowPrepareError();
                n2 = 1;
                bl = true;
            }
            l3 = mediaPeriodHolder.info.durationUs;
            n3 = n2 != 0 && mediaPeriodHolder.prepared && (l3 == -9223372036854775807L || l3 <= this.playbackInfo.positionUs) ? 1 : 0;
            if (n3 != 0 && this.pendingPauseAtEndOfPeriod) {
                this.pendingPauseAtEndOfPeriod = false;
                this.setPlayWhenReadyInternal(false, this.playbackInfo.playbackSuppressionReason, false, 5);
            }
            if (n3 != 0 && mediaPeriodHolder.info.isFinal) {
                this.setState(4);
                this.stopRenderers();
            } else if (this.playbackInfo.playbackState == 2 && this.shouldTransitionToReadyState(bl)) {
                this.setState(3);
                this.pendingRecoverableError = null;
                if (this.shouldPlayWhenReady()) {
                    this.startRenderers();
                }
            } else if (this.playbackInfo.playbackState == 3 && !(this.enabledRendererCount != 0 ? bl : this.isTimelineReady())) {
                this.isRebuffering = this.shouldPlayWhenReady();
                this.setState(2);
                if (this.isRebuffering) {
                    this.notifyTrackSelectionRebuffer();
                    this.livePlaybackSpeedControl.notifyRebuffer();
                }
                this.stopRenderers();
            }
            if (this.playbackInfo.playbackState == 2) {
                for (n3 = 0; n3 < ((Renderer[])(object = this.renderers)).length; ++n3) {
                    if (!ExoPlayerImplInternal.isRendererEnabled((Renderer)object[n3]) || this.renderers[n3].getStream() != mediaPeriodHolder.sampleStreams[n3]) continue;
                    this.renderers[n3].maybeThrowStreamError();
                }
                if (!this.playbackInfo.isLoading && this.playbackInfo.totalBufferedDurationUs < 500000L && this.isLoadingPossible()) {
                    throw new IllegalStateException("Playback stuck buffering and not loading");
                }
            }
            if (this.offloadSchedulingEnabled != this.playbackInfo.offloadSchedulingEnabled) {
                this.playbackInfo = this.playbackInfo.copyWithOffloadSchedulingEnabled(this.offloadSchedulingEnabled);
            }
            if (this.shouldPlayWhenReady() && this.playbackInfo.playbackState == 3 || this.playbackInfo.playbackState == 2) {
                bl2 = this.maybeScheduleWakeup(l2, 10L) ^ true;
            } else {
                if (this.enabledRendererCount != 0 && this.playbackInfo.playbackState != 4) {
                    this.scheduleNextWork(l2, 1000L);
                } else {
                    this.handler.removeMessages(2);
                }
                bl2 = false;
            }
            if (this.playbackInfo.sleepingForOffload != bl2) {
                this.playbackInfo = this.playbackInfo.copyWithSleepingForOffload(bl2);
            }
            this.requestForRendererSleep = false;
            TraceUtil.endSection();
            return;
        }
        this.handler.removeMessages(2);
    }

    private void enableRenderer(int n2, boolean bl) throws ExoPlaybackException {
        Renderer renderer = this.renderers[n2];
        if (ExoPlayerImplInternal.isRendererEnabled(renderer)) {
            return;
        }
        MediaPeriodHolder mediaPeriodHolder = this.queue.getReadingPeriod();
        boolean bl2 = mediaPeriodHolder == this.queue.getPlayingPeriod();
        Format[] formatArray = mediaPeriodHolder.getTrackSelectorResult();
        RendererConfiguration rendererConfiguration = formatArray.rendererConfigurations[n2];
        formatArray = ExoPlayerImplInternal.getFormats(formatArray.selections[n2]);
        boolean bl3 = this.shouldPlayWhenReady() && this.playbackInfo.playbackState == 3;
        bl = !bl && bl3;
        ++this.enabledRendererCount;
        renderer.enable(rendererConfiguration, formatArray, mediaPeriodHolder.sampleStreams[n2], this.rendererPositionUs, bl, bl2, mediaPeriodHolder.getStartPositionRendererTime(), mediaPeriodHolder.getRendererOffset());
        renderer.handleMessage(103, new Renderer.WakeupListener(){

            @Override
            public void onSleep(long l2) {
                if (l2 >= 2000L) {
                    ExoPlayerImplInternal.access$602(ExoPlayerImplInternal.this, true);
                }
            }

            @Override
            public void onWakeup() {
                ExoPlayerImplInternal.this.handler.sendEmptyMessage(2);
            }
        });
        this.mediaClock.onRendererEnabled(renderer);
        if (bl3) {
            renderer.start();
        }
    }

    private void enableRenderers() throws ExoPlaybackException {
        this.enableRenderers(new boolean[this.renderers.length]);
    }

    private void enableRenderers(boolean[] blArray) throws ExoPlaybackException {
        MediaPeriodHolder mediaPeriodHolder = this.queue.getReadingPeriod();
        TrackSelectorResult trackSelectorResult = mediaPeriodHolder.getTrackSelectorResult();
        int n2 = 0;
        int n3 = 0;
        while (true) {
            if (n3 >= this.renderers.length) break;
            if (!trackSelectorResult.isRendererEnabled(n3)) {
                this.renderers[n3].reset();
            }
            ++n3;
        }
        for (int i2 = n2; i2 < this.renderers.length; ++i2) {
            if (!trackSelectorResult.isRendererEnabled(i2)) continue;
            this.enableRenderer(i2, blArray[i2]);
        }
        mediaPeriodHolder.allRenderersEnabled = true;
    }

    private void ensureStopped(Renderer renderer) throws ExoPlaybackException {
        if (renderer.getState() == 2) {
            renderer.stop();
        }
    }

    private ImmutableList<Metadata> extractMetadataFromTrackSelectionArray(ExoTrackSelection[] object) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        int n2 = ((ExoTrackSelection[])object).length;
        boolean bl = false;
        for (int i2 = 0; i2 < n2; ++i2) {
            ExoTrackSelection exoTrackSelection = object[i2];
            boolean bl2 = bl;
            if (exoTrackSelection != null) {
                exoTrackSelection = exoTrackSelection.getFormat(0);
                if (exoTrackSelection.metadata == null) {
                    builder.add(new Metadata(new Metadata.Entry[0]));
                    bl2 = bl;
                } else {
                    builder.add(exoTrackSelection.metadata);
                    bl2 = true;
                }
            }
            bl = bl2;
        }
        object = bl ? builder.build() : ImmutableList.of();
        return object;
    }

    private long getCurrentLiveOffsetUs() {
        return this.getLiveOffsetUs(this.playbackInfo.timeline, this.playbackInfo.periodId.periodUid, this.playbackInfo.positionUs);
    }

    private static Format[] getFormats(ExoTrackSelection exoTrackSelection) {
        int n2 = exoTrackSelection != null ? exoTrackSelection.length() : 0;
        Format[] formatArray = new Format[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            formatArray[i2] = exoTrackSelection.getFormat(i2);
        }
        return formatArray;
    }

    private long getLiveOffsetUs(Timeline timeline, Object object, long l2) {
        timeline.getWindow(timeline.getPeriodByUid((Object)object, (Timeline.Period)this.period).windowIndex, this.window);
        if (this.window.windowStartTimeMs != -9223372036854775807L && this.window.isLive() && this.window.isDynamic) {
            return C.msToUs(this.window.getCurrentUnixTimeMs() - this.window.windowStartTimeMs) - (l2 + this.period.getPositionInWindowUs());
        }
        return -9223372036854775807L;
    }

    private long getMaxRendererReadPositionUs() {
        Renderer[] rendererArray;
        MediaPeriodHolder mediaPeriodHolder = this.queue.getReadingPeriod();
        if (mediaPeriodHolder == null) {
            return 0L;
        }
        long l2 = mediaPeriodHolder.getRendererOffset();
        if (!mediaPeriodHolder.prepared) {
            return l2;
        }
        for (int i2 = 0; i2 < (rendererArray = this.renderers).length; ++i2) {
            long l3 = l2;
            if (ExoPlayerImplInternal.isRendererEnabled(rendererArray[i2])) {
                if (this.renderers[i2].getStream() != mediaPeriodHolder.sampleStreams[i2]) {
                    l3 = l2;
                } else {
                    l3 = this.renderers[i2].getReadingPositionUs();
                    if (l3 == Long.MIN_VALUE) {
                        return Long.MIN_VALUE;
                    }
                    l3 = Math.max(l3, l2);
                }
            }
            l2 = l3;
        }
        return l2;
    }

    private Pair<MediaSource.MediaPeriodId, Long> getPlaceholderFirstMediaPeriodPosition(Timeline timeline) {
        boolean bl = timeline.isEmpty();
        long l2 = 0L;
        if (bl) {
            return Pair.create((Object)((Object)PlaybackInfo.getDummyPeriodForEmptyTimeline()), (Object)0L);
        }
        int n2 = timeline.getFirstWindowIndex(this.shuffleModeEnabled);
        Pair pair = timeline.getPeriodPosition(this.window, this.period, n2, -9223372036854775807L);
        MediaSource.MediaPeriodId mediaPeriodId = this.queue.resolveMediaPeriodIdForAds(timeline, pair.first, 0L);
        long l3 = (Long)pair.second;
        if (mediaPeriodId.isAd()) {
            timeline.getPeriodByUid(mediaPeriodId.periodUid, this.period);
            l3 = l2;
            if (mediaPeriodId.adIndexInAdGroup == this.period.getFirstAdIndexToPlay(mediaPeriodId.adGroupIndex)) {
                l3 = this.period.getAdResumePositionUs();
            }
        }
        return Pair.create((Object)((Object)mediaPeriodId), (Object)l3);
    }

    private long getTotalBufferedDurationUs() {
        return this.getTotalBufferedDurationUs(this.playbackInfo.bufferedPositionUs);
    }

    private long getTotalBufferedDurationUs(long l2) {
        MediaPeriodHolder mediaPeriodHolder = this.queue.getLoadingPeriod();
        if (mediaPeriodHolder == null) {
            return 0L;
        }
        return Math.max(0L, l2 - mediaPeriodHolder.toPeriodTime(this.rendererPositionUs));
    }

    private void handleContinueLoadingRequested(MediaPeriod mediaPeriod) {
        if (!this.queue.isLoading(mediaPeriod)) {
            return;
        }
        this.queue.reevaluateBuffer(this.rendererPositionUs);
        this.maybeContinueLoading();
    }

    private void handleLoadingMediaPeriodChanged(boolean bl) {
        MediaPeriodHolder mediaPeriodHolder = this.queue.getLoadingPeriod();
        MediaSource.MediaPeriodId mediaPeriodId = mediaPeriodHolder == null ? this.playbackInfo.periodId : mediaPeriodHolder.info.id;
        boolean bl2 = this.playbackInfo.loadingMediaPeriodId.equals((Object)mediaPeriodId) ^ true;
        if (bl2) {
            this.playbackInfo = this.playbackInfo.copyWithLoadingMediaPeriodId(mediaPeriodId);
        }
        mediaPeriodId = this.playbackInfo;
        long l2 = mediaPeriodHolder == null ? ((PlaybackInfo)mediaPeriodId).positionUs : mediaPeriodHolder.getBufferedPositionUs();
        ((PlaybackInfo)mediaPeriodId).bufferedPositionUs = l2;
        this.playbackInfo.totalBufferedDurationUs = this.getTotalBufferedDurationUs();
        if ((bl2 || bl) && mediaPeriodHolder != null && mediaPeriodHolder.prepared) {
            this.updateLoadControlTrackSelection(mediaPeriodHolder.getTrackGroups(), mediaPeriodHolder.getTrackSelectorResult());
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleMediaSourceListInfoRefreshed(Timeline var1_1) throws ExoPlaybackException {
        block16: {
            var2_2 = ExoPlayerImplInternal.resolvePositionForPlaylistChange(var1_1, this.playbackInfo, this.pendingInitialSeekPosition, this.queue, this.repeatMode, this.shuffleModeEnabled, this.window, this.period);
            var3_3 = var2_2.periodId;
            var4_4 = var2_2.requestedContentPositionUs;
            var6_5 = var2_2.forceBufferingState;
            var7_6 = var2_2.periodPositionUs;
            var9_7 = !this.playbackInfo.periodId.equals((Object)var3_3) || var7_6 != this.playbackInfo.positionUs;
            var10_8 = -9223372036854775807L;
            try {
                if (var2_2.endPlayback) {
                    if (this.playbackInfo.playbackState != 1) {
                        this.setState(4);
                    }
                    this.resetInternal(false, false, false, true);
                }
                if (!var9_7) {
                    var12_9 = this.queue;
                    var13_13 = this.rendererPositionUs;
                    var15_14 = this.getMaxRendererReadPositionUs();
                    var17_15 = var7_6;
                }
                ** GOTO lbl28
            }
            catch (Throwable var12_11) {
                // empty catch block
                break block16;
            }
            try {
                block17: {
                    if (!var12_9.updateQueuedPeriods(var1_1, var13_13, var15_14)) {
                        this.seekToCurrentPosition(false);
                        var17_15 = var7_6;
                    }
                    break block17;
lbl28:
                    // 1 sources

                    var17_15 = var7_6;
                    if (!var1_1.isEmpty()) {
                        for (var12_9 = this.queue.getPlayingPeriod(); var12_9 != null; var12_9 = var12_9.getNext()) {
                            if (!var12_9.info.id.equals((Object)var3_3)) continue;
                            var12_9.info = this.queue.getUpdatedMediaPeriodInfo(var1_1, var12_9.info);
                        }
                        var17_15 = this.seekToPeriodPosition(var3_3, var7_6, var6_5);
                    }
                }
                var12_9 = this.playbackInfo.timeline;
                var19_16 = this.playbackInfo.periodId;
                var7_6 = var10_8;
                if (var2_2.setTargetLiveOffset) {
                    var7_6 = var17_15;
                }
                this.updateLivePlaybackSpeedControl(var1_1, var3_3, (Timeline)var12_9, var19_16, var7_6);
                if (var9_7 || var4_4 != this.playbackInfo.requestedContentPositionUs) {
                    this.playbackInfo = this.handlePositionDiscontinuity(var3_3, var17_15, var4_4);
                }
                this.resetPendingPauseAtEndOfPeriod();
                this.resolvePendingMessagePositions(var1_1, this.playbackInfo.timeline);
            }
            catch (Throwable var12_10) {
                break block16;
            }
            this.playbackInfo = this.playbackInfo.copyWithTimeline(var1_1);
            if (!var1_1.isEmpty()) {
                this.pendingInitialSeekPosition = null;
            }
            this.handleLoadingMediaPeriodChanged(false);
            return;
        }
        var19_17 = this.playbackInfo.timeline;
        var20_18 = this.playbackInfo.periodId;
        if (var2_2.setTargetLiveOffset) {
            var10_8 = var7_6;
        }
        this.updateLivePlaybackSpeedControl(var1_1, var3_3, var19_17, var20_18, var10_8);
        if (var9_7 || var4_4 != this.playbackInfo.requestedContentPositionUs) {
            this.playbackInfo = this.handlePositionDiscontinuity(var3_3, var7_6, var4_4);
        }
        this.resetPendingPauseAtEndOfPeriod();
        this.resolvePendingMessagePositions(var1_1, this.playbackInfo.timeline);
        this.playbackInfo = this.playbackInfo.copyWithTimeline(var1_1);
        if (!var1_1.isEmpty()) {
            this.pendingInitialSeekPosition = null;
        }
        this.handleLoadingMediaPeriodChanged(false);
        throw var12_12;
    }

    private void handlePeriodPrepared(MediaPeriod mediaPeriod) throws ExoPlaybackException {
        if (!this.queue.isLoading(mediaPeriod)) {
            return;
        }
        mediaPeriod = this.queue.getLoadingPeriod();
        mediaPeriod.handlePrepared(this.mediaClock.getPlaybackParameters().speed, this.playbackInfo.timeline);
        this.updateLoadControlTrackSelection(mediaPeriod.getTrackGroups(), mediaPeriod.getTrackSelectorResult());
        if (mediaPeriod == this.queue.getPlayingPeriod()) {
            this.resetRendererPosition(((MediaPeriodHolder)mediaPeriod).info.startPositionUs);
            this.enableRenderers();
            this.playbackInfo = this.handlePositionDiscontinuity(this.playbackInfo.periodId, ((MediaPeriodHolder)mediaPeriod).info.startPositionUs, this.playbackInfo.requestedContentPositionUs);
        }
        this.maybeContinueLoading();
    }

    private void handlePlaybackParameters(PlaybackParameters playbackParameters, float f2, boolean bl, boolean bl2) throws ExoPlaybackException {
        if (bl) {
            if (bl2) {
                this.playbackInfoUpdate.incrementPendingOperationAcks(1);
            }
            this.playbackInfo = this.playbackInfo.copyWithPlaybackParameters(playbackParameters);
        }
        this.updateTrackSelectionPlaybackSpeed(playbackParameters.speed);
        for (Renderer renderer : this.renderers) {
            if (renderer == null) continue;
            renderer.setPlaybackSpeed(f2, playbackParameters.speed);
        }
    }

    private void handlePlaybackParameters(PlaybackParameters playbackParameters, boolean bl) throws ExoPlaybackException {
        this.handlePlaybackParameters(playbackParameters, playbackParameters.speed, true, bl);
    }

    private PlaybackInfo handlePositionDiscontinuity(MediaSource.MediaPeriodId mediaPeriodId, long l2, long l3) {
        boolean bl = this.deliverPendingMessageAtStartPositionRequired || l2 != this.playbackInfo.positionUs || !mediaPeriodId.equals((Object)this.playbackInfo.periodId);
        this.deliverPendingMessageAtStartPositionRequired = bl;
        this.resetPendingPauseAtEndOfPeriod();
        Object object = this.playbackInfo.trackGroups;
        TrackSelectorResult trackSelectorResult = this.playbackInfo.trackSelectorResult;
        ImmutableList<Object> immutableList = this.playbackInfo.staticMetadata;
        if (this.mediaSourceList.isPrepared()) {
            object = this.queue.getPlayingPeriod();
            immutableList = object == null ? TrackGroupArray.EMPTY : object.getTrackGroups();
            trackSelectorResult = object == null ? this.emptyTrackSelectorResult : object.getTrackSelectorResult();
            ImmutableList<Metadata> immutableList2 = this.extractMetadataFromTrackSelectionArray(trackSelectorResult.selections);
            if (object != null && object.info.requestedContentPositionUs != l3) {
                object.info = object.info.copyWithRequestedContentPositionUs(l3);
            }
            object = immutableList;
            immutableList = immutableList2;
        } else if (!mediaPeriodId.equals((Object)this.playbackInfo.periodId)) {
            object = TrackGroupArray.EMPTY;
            trackSelectorResult = this.emptyTrackSelectorResult;
            immutableList = ImmutableList.of();
        }
        return this.playbackInfo.copyWithNewPosition(mediaPeriodId, l2, l3, this.getTotalBufferedDurationUs(), object, trackSelectorResult, immutableList);
    }

    private boolean hasReadingPeriodFinishedReading() {
        Object object;
        MediaPeriodHolder mediaPeriodHolder = this.queue.getReadingPeriod();
        if (!mediaPeriodHolder.prepared) {
            return false;
        }
        for (int i2 = 0; i2 < ((Renderer[])(object = this.renderers)).length; ++i2) {
            object = object[i2];
            SampleStream sampleStream = mediaPeriodHolder.sampleStreams[i2];
            if (object.getStream() == sampleStream && (sampleStream == null || object.hasReadStreamToEnd())) {
                continue;
            }
            return false;
        }
        return true;
    }

    private boolean isLoadingPossible() {
        MediaPeriodHolder mediaPeriodHolder = this.queue.getLoadingPeriod();
        if (mediaPeriodHolder == null) {
            return false;
        }
        return mediaPeriodHolder.getNextLoadPositionUs() != Long.MIN_VALUE;
    }

    private static boolean isRendererEnabled(Renderer renderer) {
        boolean bl = renderer.getState() != 0;
        return bl;
    }

    private boolean isTimelineReady() {
        MediaPeriodHolder mediaPeriodHolder = this.queue.getPlayingPeriod();
        long l2 = mediaPeriodHolder.info.durationUs;
        boolean bl = mediaPeriodHolder.prepared && (l2 == -9223372036854775807L || this.playbackInfo.positionUs < l2 || !this.shouldPlayWhenReady());
        return bl;
    }

    private void maybeContinueLoading() {
        this.shouldContinueLoading = this.shouldContinueLoading();
        if (this.shouldContinueLoading) {
            this.queue.getLoadingPeriod().continueLoading(this.rendererPositionUs);
        }
        this.updateIsLoading();
    }

    private void maybeNotifyPlaybackInfoChanged() {
        this.playbackInfoUpdate.setPlaybackInfo(this.playbackInfo);
        if (this.playbackInfoUpdate.hasPendingChange) {
            this.playbackInfoUpdateListener.onPlaybackInfoUpdate(this.playbackInfoUpdate);
            this.playbackInfoUpdate = new PlaybackInfoUpdate(this.playbackInfo);
        }
    }

    private boolean maybeScheduleWakeup(long l2, long l3) {
        if (this.offloadSchedulingEnabled && this.requestForRendererSleep) {
            return false;
        }
        this.scheduleNextWork(l2, l3);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private void maybeTriggerPendingMessages(long var1_1, long var3_2) throws ExoPlaybackException {
        block13: {
            block15: {
                block14: {
                    if (this.pendingMessages.isEmpty() || this.playbackInfo.periodId.isAd()) break block13;
                    var5_3 = var1_1;
                    if (this.deliverPendingMessageAtStartPositionRequired) {
                        var5_3 = var1_1 - 1L;
                        this.deliverPendingMessageAtStartPositionRequired = false;
                    }
                    var7_4 = this.playbackInfo.timeline.getIndexOfPeriod(this.playbackInfo.periodId.periodUid);
                    var9_6 = var8_5 = Math.min(this.nextPendingMessageIndexHint, this.pendingMessages.size());
                    var1_1 = var5_3;
                    if (var8_5 <= 0) break block14;
                    var10_7 = this.pendingMessages.get(var8_5 - 1);
                    var9_6 = var8_5;
                    ** GOTO lbl17
                }
                block2: while (true) {
                    var10_7 = null;
                    var5_3 = var1_1;
                    while (var10_7 != null && (var10_7.resolvedPeriodIndex > var7_4 || var10_7.resolvedPeriodIndex == var7_4 && var10_7.resolvedPeriodTimeUs > var5_3)) {
                        var9_6 = var8_5 = var9_6 - 1;
                        var1_1 = var5_3;
                        if (var8_5 <= 0) continue block2;
                        var10_7 = this.pendingMessages.get(var8_5 - 1);
                        var9_6 = var8_5;
                    }
                    break;
                }
                var8_5 = var9_6;
                var1_1 = var5_3;
                if (var9_6 >= this.pendingMessages.size()) break block15;
                var10_7 = this.pendingMessages.get(var9_6);
                ** GOTO lbl34
            }
            block4: while (true) {
                var10_7 = null;
                var5_3 = var1_1;
                var9_6 = var8_5;
lbl34:
                // 2 sources

                while (true) {
                    var8_5 = var9_6;
                    var11_9 = var10_7;
                    if (var10_7 == null) break block4;
                    var8_5 = var9_6;
                    var11_9 = var10_7;
                    if (var10_7.resolvedPeriodUid == null) break block4;
                    if (var10_7.resolvedPeriodIndex >= var7_4) {
                        var8_5 = var9_6;
                        var11_9 = var10_7;
                        if (var10_7.resolvedPeriodIndex != var7_4) break block4;
                        var8_5 = var9_6;
                        var11_9 = var10_7;
                        if (var10_7.resolvedPeriodTimeUs > var5_3) break block4;
                    }
                    var8_5 = ++var9_6;
                    var1_1 = var5_3;
                    if (var9_6 >= this.pendingMessages.size()) continue block4;
                    var10_7 = this.pendingMessages.get(var9_6);
                }
                break;
            }
            while (var11_9 != null && var11_9.resolvedPeriodUid != null && var11_9.resolvedPeriodIndex == var7_4 && var11_9.resolvedPeriodTimeUs > var5_3 && var11_9.resolvedPeriodTimeUs <= var3_2) {
                block12: {
                    try {
                        this.sendMessageToTarget(var11_9.message);
                        if (!var11_9.message.getDeleteAfterDelivery() && !var11_9.message.isCanceled()) {
                            ++var8_5;
                            break block12;
                        }
                        this.pendingMessages.remove(var8_5);
                    }
                    catch (Throwable var10_8) {
                        if (var11_9.message.getDeleteAfterDelivery() || var11_9.message.isCanceled()) {
                            this.pendingMessages.remove(var8_5);
                        }
                        throw var10_8;
                    }
                }
                if (var8_5 < this.pendingMessages.size()) {
                    var11_9 = this.pendingMessages.get(var8_5);
                    continue;
                }
                var11_9 = null;
            }
            this.nextPendingMessageIndexHint = var8_5;
        }
    }

    private void maybeUpdateLoadingPeriod() throws ExoPlaybackException {
        MediaPeriodInfo mediaPeriodInfo;
        this.queue.reevaluateBuffer(this.rendererPositionUs);
        if (this.queue.shouldLoadNextMediaPeriod() && (mediaPeriodInfo = this.queue.getNextMediaPeriodInfo(this.rendererPositionUs, this.playbackInfo)) != null) {
            MediaPeriodHolder mediaPeriodHolder = this.queue.enqueueNextMediaPeriodHolder(this.rendererCapabilities, this.trackSelector, this.loadControl.getAllocator(), this.mediaSourceList, mediaPeriodInfo, this.emptyTrackSelectorResult);
            mediaPeriodHolder.mediaPeriod.prepare(this, mediaPeriodInfo.startPositionUs);
            if (this.queue.getPlayingPeriod() == mediaPeriodHolder) {
                this.resetRendererPosition(mediaPeriodHolder.getStartPositionRendererTime());
            }
            this.handleLoadingMediaPeriodChanged(false);
        }
        if (this.shouldContinueLoading) {
            this.shouldContinueLoading = this.isLoadingPossible();
            this.updateIsLoading();
        } else {
            this.maybeContinueLoading();
        }
    }

    private void maybeUpdatePlayingPeriod() throws ExoPlaybackException {
        int n2 = 0;
        while (this.shouldAdvancePlayingPeriod()) {
            if (n2 != 0) {
                this.maybeNotifyPlaybackInfoChanged();
            }
            MediaPeriodHolder mediaPeriodHolder = this.queue.getPlayingPeriod();
            MediaPeriodHolder mediaPeriodHolder2 = this.queue.advancePlayingPeriod();
            this.playbackInfo = this.handlePositionDiscontinuity(mediaPeriodHolder2.info.id, mediaPeriodHolder2.info.startPositionUs, mediaPeriodHolder2.info.requestedContentPositionUs);
            n2 = mediaPeriodHolder.info.isLastInTimelinePeriod ? 0 : 3;
            this.playbackInfoUpdate.setPositionDiscontinuity(n2);
            this.updateLivePlaybackSpeedControl(this.playbackInfo.timeline, mediaPeriodHolder2.info.id, this.playbackInfo.timeline, mediaPeriodHolder.info.id, -9223372036854775807L);
            this.resetPendingPauseAtEndOfPeriod();
            this.updatePlaybackPositions();
            n2 = 1;
        }
    }

    private void maybeUpdateReadingPeriod() {
        block12: {
            int n2;
            Object object;
            MediaPeriodHolder mediaPeriodHolder;
            block11: {
                mediaPeriodHolder = this.queue.getReadingPeriod();
                if (mediaPeriodHolder == null) {
                    return;
                }
                object = mediaPeriodHolder.getNext();
                int n3 = 0;
                if (object != null && !this.pendingPauseAtEndOfPeriod) {
                    if (!this.hasReadingPeriodFinishedReading()) {
                        return;
                    }
                    if (!mediaPeriodHolder.getNext().prepared && this.rendererPositionUs < mediaPeriodHolder.getNext().getStartPositionRendererTime()) {
                        return;
                    }
                    TrackSelectorResult trackSelectorResult = mediaPeriodHolder.getTrackSelectorResult();
                    MediaPeriodHolder mediaPeriodHolder2 = this.queue.advanceReadingPeriod();
                    object = mediaPeriodHolder2.getTrackSelectorResult();
                    if (mediaPeriodHolder2.prepared && mediaPeriodHolder2.mediaPeriod.readDiscontinuity() != -9223372036854775807L) {
                        this.setAllRendererStreamsFinal(mediaPeriodHolder2.getStartPositionRendererTime());
                        return;
                    }
                    for (int i2 = 0; i2 < this.renderers.length; ++i2) {
                        boolean bl = trackSelectorResult.isRendererEnabled(i2);
                        boolean bl2 = ((TrackSelectorResult)object).isRendererEnabled(i2);
                        if (!bl || this.renderers[i2].isCurrentStreamFinal()) continue;
                        n3 = this.rendererCapabilities[i2].getTrackType() == 7 ? 1 : 0;
                        RendererConfiguration rendererConfiguration = trackSelectorResult.rendererConfigurations[i2];
                        mediaPeriodHolder = ((TrackSelectorResult)object).rendererConfigurations[i2];
                        if (bl2 && mediaPeriodHolder.equals((Object)rendererConfiguration) && n3 == 0) continue;
                        this.setCurrentStreamFinal(this.renderers[i2], mediaPeriodHolder2.getStartPositionRendererTime());
                    }
                    return;
                }
                n2 = n3;
                if (mediaPeriodHolder.info.isFinal) break block11;
                if (!this.pendingPauseAtEndOfPeriod) break block12;
                n2 = n3;
            }
            while (n2 < ((Renderer[])(object = this.renderers)).length) {
                Renderer renderer = object[n2];
                object = mediaPeriodHolder.sampleStreams[n2];
                if (object != null && renderer.getStream() == object && renderer.hasReadStreamToEnd()) {
                    long l2 = mediaPeriodHolder.info.durationUs != -9223372036854775807L && mediaPeriodHolder.info.durationUs != Long.MIN_VALUE ? mediaPeriodHolder.getRendererOffset() + mediaPeriodHolder.info.durationUs : -9223372036854775807L;
                    this.setCurrentStreamFinal(renderer, l2);
                }
                ++n2;
            }
        }
    }

    private void maybeUpdateReadingRenderers() throws ExoPlaybackException {
        MediaPeriodHolder mediaPeriodHolder = this.queue.getReadingPeriod();
        if (mediaPeriodHolder != null && this.queue.getPlayingPeriod() != mediaPeriodHolder && !mediaPeriodHolder.allRenderersEnabled && this.replaceStreamsOrDisableRendererForTransition()) {
            this.enableRenderers();
        }
    }

    private void mediaSourceListUpdateRequestedInternal() throws ExoPlaybackException {
        this.handleMediaSourceListInfoRefreshed(this.mediaSourceList.createTimeline());
    }

    private void moveMediaItemsInternal(MoveMediaItemsMessage moveMediaItemsMessage) throws ExoPlaybackException {
        this.playbackInfoUpdate.incrementPendingOperationAcks(1);
        this.handleMediaSourceListInfoRefreshed(this.mediaSourceList.moveMediaSourceRange(moveMediaItemsMessage.fromIndex, moveMediaItemsMessage.toIndex, moveMediaItemsMessage.newFromIndex, moveMediaItemsMessage.shuffleOrder));
    }

    private void notifyTrackSelectionDiscontinuity() {
        for (MediaPeriodHolder mediaPeriodHolder = this.queue.getPlayingPeriod(); mediaPeriodHolder != null; mediaPeriodHolder = mediaPeriodHolder.getNext()) {
            for (ExoTrackSelection exoTrackSelection : mediaPeriodHolder.getTrackSelectorResult().selections) {
                if (exoTrackSelection == null) continue;
                exoTrackSelection.onDiscontinuity();
            }
        }
    }

    private void notifyTrackSelectionPlayWhenReadyChanged(boolean bl) {
        for (MediaPeriodHolder mediaPeriodHolder = this.queue.getPlayingPeriod(); mediaPeriodHolder != null; mediaPeriodHolder = mediaPeriodHolder.getNext()) {
            for (ExoTrackSelection exoTrackSelection : mediaPeriodHolder.getTrackSelectorResult().selections) {
                if (exoTrackSelection == null) continue;
                exoTrackSelection.onPlayWhenReadyChanged(bl);
            }
        }
    }

    private void notifyTrackSelectionRebuffer() {
        for (MediaPeriodHolder mediaPeriodHolder = this.queue.getPlayingPeriod(); mediaPeriodHolder != null; mediaPeriodHolder = mediaPeriodHolder.getNext()) {
            for (ExoTrackSelection exoTrackSelection : mediaPeriodHolder.getTrackSelectorResult().selections) {
                if (exoTrackSelection == null) continue;
                exoTrackSelection.onRebuffer();
            }
        }
    }

    private void prepareInternal() {
        this.playbackInfoUpdate.incrementPendingOperationAcks(1);
        this.resetInternal(false, false, false, true);
        this.loadControl.onPrepared();
        int n2 = this.playbackInfo.timeline.isEmpty() ? 4 : 2;
        this.setState(n2);
        this.mediaSourceList.prepare(this.bandwidthMeter.getTransferListener());
        this.handler.sendEmptyMessage(2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void releaseInternal() {
        this.resetInternal(true, false, true, false);
        this.loadControl.onReleased();
        this.setState(1);
        this.internalPlaybackThread.quit();
        synchronized (this) {
            this.released = true;
            this.notifyAll();
            return;
        }
    }

    private void removeMediaItemsInternal(int n2, int n3, ShuffleOrder shuffleOrder) throws ExoPlaybackException {
        this.playbackInfoUpdate.incrementPendingOperationAcks(1);
        this.handleMediaSourceListInfoRefreshed(this.mediaSourceList.removeMediaSourceRange(n2, n3, shuffleOrder));
    }

    private boolean replaceStreamsOrDisableRendererForTransition() throws ExoPlaybackException {
        Object object;
        MediaPeriodHolder mediaPeriodHolder = this.queue.getReadingPeriod();
        TrackSelectorResult trackSelectorResult = mediaPeriodHolder.getTrackSelectorResult();
        boolean bl = false;
        for (int i2 = 0; i2 < ((Renderer[])(object = this.renderers)).length; ++i2) {
            if (!ExoPlayerImplInternal.isRendererEnabled((Renderer)(object = object[i2]))) continue;
            boolean bl2 = object.getStream() != mediaPeriodHolder.sampleStreams[i2];
            if (trackSelectorResult.isRendererEnabled(i2) && !bl2) continue;
            if (!object.isCurrentStreamFinal()) {
                object.replaceStream(ExoPlayerImplInternal.getFormats(trackSelectorResult.selections[i2]), mediaPeriodHolder.sampleStreams[i2], mediaPeriodHolder.getStartPositionRendererTime(), mediaPeriodHolder.getRendererOffset());
                continue;
            }
            if (object.isEnded()) {
                this.disableRenderer((Renderer)object);
                continue;
            }
            bl = true;
        }
        return bl ^ true;
    }

    private void reselectTracksInternal() throws ExoPlaybackException {
        float f2 = this.mediaClock.getPlaybackParameters().speed;
        Object object = this.queue.getReadingPeriod();
        int n2 = 1;
        for (MediaPeriodHolder mediaPeriodHolder = this.queue.getPlayingPeriod(); mediaPeriodHolder != null && mediaPeriodHolder.prepared; mediaPeriodHolder = mediaPeriodHolder.getNext()) {
            Object object2 = mediaPeriodHolder.selectTracks(f2, this.playbackInfo.timeline);
            boolean bl = ((TrackSelectorResult)object2).isEquivalent(mediaPeriodHolder.getTrackSelectorResult());
            int n3 = 0;
            if (!bl) {
                if (n2 != 0) {
                    Object object3;
                    mediaPeriodHolder = this.queue.getPlayingPeriod();
                    bl = this.queue.removeAfter(mediaPeriodHolder);
                    object = new boolean[this.renderers.length];
                    long l2 = mediaPeriodHolder.applyTrackSelection((TrackSelectorResult)object2, this.playbackInfo.positionUs, bl, (boolean[])object);
                    this.playbackInfo = this.handlePositionDiscontinuity(this.playbackInfo.periodId, l2, this.playbackInfo.requestedContentPositionUs);
                    if (this.playbackInfo.playbackState != 4 && l2 != this.playbackInfo.positionUs) {
                        this.playbackInfoUpdate.setPositionDiscontinuity(4);
                        this.resetRendererPosition(l2);
                    }
                    object2 = new boolean[this.renderers.length];
                    for (n2 = n3; n2 < ((Renderer[])(object3 = this.renderers)).length; ++n2) {
                        Renderer renderer = object3[n2];
                        object2[n2] = ExoPlayerImplInternal.isRendererEnabled(renderer);
                        object3 = mediaPeriodHolder.sampleStreams[n2];
                        if (object2[n2] == false) continue;
                        if (object3 != renderer.getStream()) {
                            this.disableRenderer(renderer);
                            continue;
                        }
                        if (object[n2] == false) continue;
                        renderer.resetPosition(this.rendererPositionUs);
                    }
                    this.enableRenderers((boolean[])object2);
                } else {
                    this.queue.removeAfter(mediaPeriodHolder);
                    if (mediaPeriodHolder.prepared) {
                        mediaPeriodHolder.applyTrackSelection((TrackSelectorResult)object2, Math.max(mediaPeriodHolder.info.startPositionUs, mediaPeriodHolder.toPeriodTime(this.rendererPositionUs)), false);
                    }
                }
                this.handleLoadingMediaPeriodChanged(true);
                if (this.playbackInfo.playbackState != 4) {
                    this.maybeContinueLoading();
                    this.updatePlaybackPositions();
                    this.handler.sendEmptyMessage(2);
                }
                return;
            }
            if (mediaPeriodHolder != object) continue;
            n2 = 0;
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private void resetInternal(boolean var1_1, boolean var2_2, boolean var3_3, boolean var4_4) {
        this.handler.removeMessages(2);
        this.isRebuffering = false;
        this.mediaClock.stop();
        this.rendererPositionUs = 0L;
        for (Renderer[] var8_9 : this.renderers) {
            try {
                this.disableRenderer((Renderer)var8_9 /* !! */ );
                continue;
            }
            catch (RuntimeException var8_10) {
            }
            catch (ExoPlaybackException var8_11) {
                // empty catch block
            }
            Log.e("ExoPlayerImplInternal", "Disable failed.", (Throwable)var8_9 /* !! */ );
        }
        if (var1_1) {
            for (Object var5_5 : this.renderers) {
                try {
                    var5_5.reset();
                }
                catch (RuntimeException var5_6) {
                    Log.e("ExoPlayerImplInternal", "Reset failed.", var5_6);
                }
            }
        }
        this.enabledRendererCount = 0;
        var8_9 /* !! */  = this.playbackInfo.periodId;
        var9_12 = this.playbackInfo.positionUs;
        var11_13 = ExoPlayerImplInternal.shouldUseRequestedContentPosition(this.playbackInfo, this.period, this.window) != false ? this.playbackInfo.requestedContentPositionUs : this.playbackInfo.positionUs;
        if (!var2_2) ** GOTO lbl39
        this.pendingInitialSeekPosition = null;
        var5_5 = this.getPlaceholderFirstMediaPeriodPosition(this.playbackInfo.timeline);
        var8_9 /* !! */  = (MediaSource.MediaPeriodId)var5_5.first;
        var11_13 = (Long)var5_5.second;
        if (!var8_9 /* !! */ .equals((Object)this.playbackInfo.periodId)) {
            var7_8 = 1;
            var9_12 = -9223372036854775807L;
            var13_14 = var11_13;
        } else {
            var9_12 = var11_13;
            var11_13 = -9223372036854775807L;
lbl39:
            // 2 sources

            var7_8 = 0;
            var13_14 = var9_12;
            var9_12 = var11_13;
        }
        this.queue.clear();
        this.shouldContinueLoading = false;
        var15_15 = this.playbackInfo.timeline;
        var6_7 = this.playbackInfo.playbackState;
        var5_5 = var4_4 != false ? null : this.playbackInfo.playbackError;
        var16_16 = var7_8 != 0 ? TrackGroupArray.EMPTY : this.playbackInfo.trackGroups;
        var17_17 = var7_8 != 0 ? this.emptyTrackSelectorResult : this.playbackInfo.trackSelectorResult;
        var18_18 /* !! */  = var7_8 != 0 ? ImmutableList.of() : this.playbackInfo.staticMetadata;
        this.playbackInfo = new PlaybackInfo(var15_15, (MediaSource.MediaPeriodId)var8_9 /* !! */ , var9_12, var6_7, (ExoPlaybackException)var5_5, false, var16_16, var17_17, var18_18 /* !! */ , (MediaSource.MediaPeriodId)var8_9 /* !! */ , this.playbackInfo.playWhenReady, this.playbackInfo.playbackSuppressionReason, this.playbackInfo.playbackParameters, var13_14, 0L, var13_14, this.offloadSchedulingEnabled, false);
        if (var3_3) {
            this.mediaSourceList.release();
        }
        this.pendingRecoverableError = null;
    }

    private void resetPendingPauseAtEndOfPeriod() {
        MediaPeriodHolder mediaPeriodHolder = this.queue.getPlayingPeriod();
        boolean bl = mediaPeriodHolder != null && mediaPeriodHolder.info.isLastInTimelineWindow && this.pauseAtEndOfWindow;
        this.pendingPauseAtEndOfPeriod = bl;
    }

    private void resetRendererPosition(long l2) throws ExoPlaybackException {
        MediaPeriodHolder object2 = this.queue.getPlayingPeriod();
        if (object2 != null) {
            l2 = object2.toRendererTime(l2);
        }
        this.rendererPositionUs = l2;
        this.mediaClock.resetPosition(this.rendererPositionUs);
        for (Renderer renderer : this.renderers) {
            if (!ExoPlayerImplInternal.isRendererEnabled(renderer)) continue;
            renderer.resetPosition(this.rendererPositionUs);
        }
        this.notifyTrackSelectionDiscontinuity();
    }

    private static void resolvePendingMessageEndOfStreamPosition(Timeline object, PendingMessageInfo pendingMessageInfo, Timeline.Window window, Timeline.Period period) {
        int n2 = object.getWindow((int)object.getPeriodByUid((Object)pendingMessageInfo.resolvedPeriodUid, (Timeline.Period)period).windowIndex, (Timeline.Window)window).lastPeriodIndex;
        object = object.getPeriod((int)n2, (Timeline.Period)period, (boolean)true).uid;
        long l2 = period.durationUs != -9223372036854775807L ? period.durationUs - 1L : Long.MAX_VALUE;
        pendingMessageInfo.setResolvedPosition(n2, l2, object);
    }

    private static boolean resolvePendingMessagePosition(PendingMessageInfo pendingMessageInfo, Timeline timeline, Timeline pair, int n2, boolean bl, Timeline.Window window, Timeline.Period period) {
        if (pendingMessageInfo.resolvedPeriodUid == null) {
            long l2 = pendingMessageInfo.message.getPositionMs() == Long.MIN_VALUE ? -9223372036854775807L : C.msToUs(pendingMessageInfo.message.getPositionMs());
            pair = ExoPlayerImplInternal.resolveSeekPosition(timeline, new SeekPosition(pendingMessageInfo.message.getTimeline(), pendingMessageInfo.message.getWindowIndex(), l2), false, n2, bl, window, period);
            if (pair == null) {
                return false;
            }
            pendingMessageInfo.setResolvedPosition(timeline.getIndexOfPeriod(pair.first), (Long)pair.second, pair.first);
            if (pendingMessageInfo.message.getPositionMs() == Long.MIN_VALUE) {
                ExoPlayerImplInternal.resolvePendingMessageEndOfStreamPosition(timeline, pendingMessageInfo, window, period);
            }
            return true;
        }
        n2 = timeline.getIndexOfPeriod(pendingMessageInfo.resolvedPeriodUid);
        if (n2 == -1) {
            return false;
        }
        if (pendingMessageInfo.message.getPositionMs() == Long.MIN_VALUE) {
            ExoPlayerImplInternal.resolvePendingMessageEndOfStreamPosition(timeline, pendingMessageInfo, window, period);
            return true;
        }
        pendingMessageInfo.resolvedPeriodIndex = n2;
        pair.getPeriodByUid(pendingMessageInfo.resolvedPeriodUid, period);
        if (pair.getWindow((int)period.windowIndex, (Timeline.Window)window).isPlaceholder) {
            long l3 = pendingMessageInfo.resolvedPeriodTimeUs;
            long l4 = period.getPositionInWindowUs();
            pair = timeline.getPeriodPosition(window, period, timeline.getPeriodByUid((Object)pendingMessageInfo.resolvedPeriodUid, (Timeline.Period)period).windowIndex, l3 + l4);
            pendingMessageInfo.setResolvedPosition(timeline.getIndexOfPeriod(pair.first), (Long)pair.second, pair.first);
        }
        return true;
    }

    private void resolvePendingMessagePositions(Timeline timeline, Timeline timeline2) {
        if (timeline.isEmpty() && timeline2.isEmpty()) {
            return;
        }
        for (int i2 = this.pendingMessages.size() - 1; i2 >= 0; --i2) {
            if (ExoPlayerImplInternal.resolvePendingMessagePosition(this.pendingMessages.get(i2), timeline, timeline2, this.repeatMode, this.shuffleModeEnabled, this.window, this.period)) continue;
            this.pendingMessages.get((int)i2).message.markAsProcessed(false);
            this.pendingMessages.remove(i2);
        }
        Collections.sort(this.pendingMessages);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static PositionUpdateForPlaylistChange resolvePositionForPlaylistChange(Timeline timeline, PlaybackInfo playbackInfo, SeekPosition object, MediaPeriodQueue object2, int n2, boolean bl, Timeline.Window window, Timeline.Period period) {
        void var2_17;
        void var2_14;
        void var3_18;
        long l2;
        boolean bl2;
        boolean bl3;
        int n3;
        boolean bl4;
        long l3;
        boolean bl5;
        Pair pair;
        void var7_23;
        MediaSource.MediaPeriodId mediaPeriodId;
        block17: {
            Object object3;
            block21: {
                block19: {
                    block22: {
                        block23: {
                            block20: {
                                block18: {
                                    block16: {
                                        if (timeline.isEmpty()) {
                                            return new PositionUpdateForPlaylistChange(PlaybackInfo.getDummyPeriodForEmptyTimeline(), 0L, -9223372036854775807L, false, true, false);
                                        }
                                        mediaPeriodId = playbackInfo.periodId;
                                        object3 = mediaPeriodId.periodUid;
                                        bl5 = ExoPlayerImplInternal.shouldUseRequestedContentPosition(playbackInfo, (Timeline.Period)var7_23, (Timeline.Window)pair);
                                        l3 = bl5 ? playbackInfo.requestedContentPositionUs : playbackInfo.positionUs;
                                        bl4 = false;
                                        if (object == null) break block16;
                                        Pair<Object, Long> pair2 = ExoPlayerImplInternal.resolveSeekPosition(timeline, (SeekPosition)object, true, n3, bl3, (Timeline.Window)pair, (Timeline.Period)var7_23);
                                        if (pair2 == null) {
                                            n3 = timeline.getFirstWindowIndex(bl3);
                                            bl2 = true;
                                            bl5 = false;
                                            bl3 = false;
                                            Object object4 = object3;
                                        } else {
                                            if (((SeekPosition)object).windowPositionUs == -9223372036854775807L) {
                                                n3 = timeline.getPeriodByUid((Object)pair2.first, (Timeline.Period)var7_23).windowIndex;
                                                bl3 = false;
                                                Object object5 = object3;
                                            } else {
                                                Object object6 = pair2.first;
                                                l3 = (Long)pair2.second;
                                                n3 = -1;
                                                bl3 = true;
                                            }
                                            bl5 = playbackInfo.playbackState == 4;
                                            bl2 = false;
                                        }
                                        boolean bl6 = bl3;
                                        bl3 = bl5;
                                        bl5 = bl2;
                                        bl2 = bl6;
                                        break block17;
                                    }
                                    if (!playbackInfo.timeline.isEmpty()) break block18;
                                    n3 = timeline.getFirstWindowIndex(bl3);
                                    break block19;
                                }
                                if (timeline.getIndexOfPeriod(object3) != -1) break block20;
                                Object object7 = ExoPlayerImplInternal.resolveSubsequentPeriod((Timeline.Window)pair, (Timeline.Period)var7_23, n3, bl3, object3, playbackInfo.timeline, timeline);
                                if (object7 == null) {
                                    n3 = timeline.getFirstWindowIndex(bl3);
                                    bl3 = true;
                                } else {
                                    n3 = timeline.getPeriodByUid((Object)object7, (Timeline.Period)var7_23).windowIndex;
                                    bl3 = false;
                                }
                                bl5 = bl3;
                                break block21;
                            }
                            if (!bl5) break block22;
                            if (l3 != -9223372036854775807L) break block23;
                            n3 = timeline.getPeriodByUid((Object)object3, (Timeline.Period)var7_23).windowIndex;
                            break block19;
                        }
                        playbackInfo.timeline.getPeriodByUid(mediaPeriodId.periodUid, (Timeline.Period)var7_23);
                        l2 = var7_23.getPositionInWindowUs();
                        object3 = timeline.getPeriodPosition((Timeline.Window)pair, (Timeline.Period)var7_23, timeline.getPeriodByUid((Object)object3, (Timeline.Period)var7_23).windowIndex, l3 + l2);
                        Object object8 = ((Pair)object3).first;
                        l3 = (Long)((Pair)object3).second;
                        n3 = -1;
                        bl3 = false;
                        bl5 = false;
                        bl2 = true;
                        break block17;
                    }
                    n3 = -1;
                }
                bl5 = false;
            }
            bl3 = false;
            bl2 = false;
            Object object9 = object3;
        }
        if (n3 != -1) {
            pair = timeline.getPeriodPosition((Timeline.Window)pair, (Timeline.Period)var7_23, n3, -9223372036854775807L);
            Object object10 = pair.first;
            l3 = (Long)pair.second;
            l2 = -9223372036854775807L;
        } else {
            l2 = l3;
        }
        MediaSource.MediaPeriodId mediaPeriodId2 = var3_18.resolveMediaPeriodIdForAds(timeline, (Object)var2_14, l3);
        n3 = mediaPeriodId2.nextAdGroupIndex != -1 && (mediaPeriodId.nextAdGroupIndex == -1 || mediaPeriodId2.adGroupIndex < mediaPeriodId.nextAdGroupIndex) ? 0 : 1;
        boolean bl7 = bl4;
        if (mediaPeriodId.periodUid.equals(var2_14)) {
            bl7 = bl4;
            if (!mediaPeriodId.isAd()) {
                bl7 = bl4;
                if (!mediaPeriodId2.isAd()) {
                    bl7 = bl4;
                    if (n3 != 0) {
                        bl7 = true;
                    }
                }
            }
        }
        MediaSource.MediaPeriodId mediaPeriodId3 = mediaPeriodId2;
        if (bl7) {
            MediaSource.MediaPeriodId mediaPeriodId4 = mediaPeriodId;
        }
        if (!var2_17.isAd()) return new PositionUpdateForPlaylistChange((MediaSource.MediaPeriodId)var2_17, l3, l2, bl3, bl5, bl2);
        if (var2_17.equals((Object)mediaPeriodId)) {
            l3 = playbackInfo.positionUs;
            return new PositionUpdateForPlaylistChange((MediaSource.MediaPeriodId)var2_17, l3, l2, bl3, bl5, bl2);
        }
        timeline.getPeriodByUid(var2_17.periodUid, (Timeline.Period)var7_23);
        if (var2_17.adIndexInAdGroup == var7_23.getFirstAdIndexToPlay(var2_17.adGroupIndex)) {
            l3 = var7_23.getAdResumePositionUs();
            return new PositionUpdateForPlaylistChange((MediaSource.MediaPeriodId)var2_17, l3, l2, bl3, bl5, bl2);
        }
        l3 = 0L;
        return new PositionUpdateForPlaylistChange((MediaSource.MediaPeriodId)var2_17, l3, l2, bl3, bl5, bl2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Pair<Object, Long> resolveSeekPosition(Timeline timeline, SeekPosition object, boolean bl, int n2, boolean bl2, Timeline.Window window, Timeline.Period period) {
        Pair pair;
        Timeline timeline2 = ((SeekPosition)object).timeline;
        if (timeline.isEmpty()) {
            return null;
        }
        if (timeline2.isEmpty()) {
            timeline2 = timeline;
        }
        try {
            pair = timeline2.getPeriodPosition(window, period, ((SeekPosition)object).windowIndex, ((SeekPosition)object).windowPositionUs);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
        if (timeline.equals((Object)timeline2)) {
            return pair;
        }
        if (timeline.getIndexOfPeriod(pair.first) != -1) {
            timeline2.getPeriodByUid(pair.first, period);
            Pair pair2 = pair;
            if (!timeline2.getWindow((int)period.windowIndex, (Timeline.Window)window).isPlaceholder) return pair2;
            return timeline.getPeriodPosition(window, period, timeline.getPeriodByUid((Object)pair.first, (Timeline.Period)period).windowIndex, ((SeekPosition)object).windowPositionUs);
        }
        if (!bl) return null;
        object = ExoPlayerImplInternal.resolveSubsequentPeriod(window, period, n2, bl2, pair.first, timeline2, timeline);
        if (object == null) return null;
        return timeline.getPeriodPosition(window, period, timeline.getPeriodByUid((Object)object, (Timeline.Period)period).windowIndex, -9223372036854775807L);
    }

    static Object resolveSubsequentPeriod(Timeline.Window object, Timeline.Period period, int n2, boolean bl, Object object2, Timeline timeline, Timeline timeline2) {
        int n3 = timeline.getIndexOfPeriod(object2);
        int n4 = timeline.getPeriodCount();
        int n5 = -1;
        for (int i2 = 0; i2 < n4 && n5 == -1 && (n3 = timeline.getNextPeriodIndex(n3, period, object, n2, bl)) != -1; ++i2) {
            n5 = timeline2.getIndexOfPeriod(timeline.getUidOfPeriod(n3));
        }
        object = n5 == -1 ? null : timeline2.getUidOfPeriod(n5);
        return object;
    }

    private void scheduleNextWork(long l2, long l3) {
        this.handler.removeMessages(2);
        this.handler.sendEmptyMessageAtTime(2, l2 + l3);
    }

    private void seekToCurrentPosition(boolean bl) throws ExoPlaybackException {
        MediaSource.MediaPeriodId mediaPeriodId = this.queue.getPlayingPeriod().info.id;
        long l2 = this.seekToPeriodPosition(mediaPeriodId, this.playbackInfo.positionUs, true, false);
        if (l2 != this.playbackInfo.positionUs) {
            this.playbackInfo = this.handlePositionDiscontinuity(mediaPeriodId, l2, this.playbackInfo.requestedContentPositionUs);
            if (bl) {
                this.playbackInfoUpdate.setPositionDiscontinuity(4);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void seekToInternal(SeekPosition seekPosition) throws ExoPlaybackException {
        void var1_4;
        long l2;
        boolean bl;
        long l3;
        Object object;
        block19: {
            long l4;
            block18: {
                this.playbackInfoUpdate.incrementPendingOperationAcks(1);
                Pair<Object, Long> pair = ExoPlayerImplInternal.resolveSeekPosition(this.playbackInfo.timeline, seekPosition, true, this.repeatMode, this.shuffleModeEnabled, this.window, this.period);
                boolean bl2 = false;
                if (pair == null) {
                    Pair<MediaSource.MediaPeriodId, Long> pair2 = this.getPlaceholderFirstMediaPeriodPosition(this.playbackInfo.timeline);
                    object = (MediaSource.MediaPeriodId)((Object)pair2.first);
                    l3 = (Long)pair2.second;
                    bl = this.playbackInfo.timeline.isEmpty() ^ true;
                    l2 = -9223372036854775807L;
                } else {
                    object = pair.first;
                    l3 = (Long)pair.second;
                    l4 = seekPosition.windowPositionUs == -9223372036854775807L ? -9223372036854775807L : l3;
                    if ((object = this.queue.resolveMediaPeriodIdForAds(this.playbackInfo.timeline, object, l3)).isAd()) {
                        this.playbackInfo.timeline.getPeriodByUid(((MediaSource.MediaPeriodId)((Object)object)).periodUid, this.period);
                        l3 = this.period.getFirstAdIndexToPlay(((MediaSource.MediaPeriodId)((Object)object)).adGroupIndex) == ((MediaSource.MediaPeriodId)((Object)object)).adIndexInAdGroup ? this.period.getAdResumePositionUs() : 0L;
                        bl = true;
                        l2 = l4;
                    } else {
                        bl = seekPosition.windowPositionUs == -9223372036854775807L;
                        l2 = l4;
                    }
                }
                try {
                    block22: {
                        block21: {
                            block20: {
                                if (!this.playbackInfo.timeline.isEmpty()) break block20;
                                this.pendingInitialSeekPosition = seekPosition;
                                break block21;
                            }
                            if (pair != null) break block22;
                            if (this.playbackInfo.playbackState != 1) {
                                this.setState(4);
                            }
                            this.resetInternal(false, true, false, true);
                        }
                        l4 = l3;
                        break block18;
                    }
                    if (object.equals((Object)this.playbackInfo.periodId)) {
                        seekPosition = this.queue.getPlayingPeriod();
                        l4 = seekPosition != null && ((MediaPeriodHolder)seekPosition).prepared && l3 != 0L ? ((MediaPeriodHolder)seekPosition).mediaPeriod.getAdjustedSeekPositionUs(l3, this.seekParameters) : l3;
                        if (C.usToMs(l4) == C.usToMs(this.playbackInfo.positionUs) && (this.playbackInfo.playbackState == 2 || this.playbackInfo.playbackState == 3)) {
                            l4 = this.playbackInfo.positionUs;
                            this.playbackInfo = this.handlePositionDiscontinuity((MediaSource.MediaPeriodId)((Object)object), l4, l2);
                            if (bl) {
                                this.playbackInfoUpdate.setPositionDiscontinuity(2);
                            }
                            return;
                        }
                    } else {
                        l4 = l3;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                    break block19;
                }
                {
                    boolean bl3 = this.playbackInfo.playbackState == 4;
                    l4 = this.seekToPeriodPosition((MediaSource.MediaPeriodId)((Object)object), l4, bl3);
                    if (l3 != l4) {
                        bl2 = true;
                    }
                    bl |= bl2;
                }
                try {
                    this.updateLivePlaybackSpeedControl(this.playbackInfo.timeline, (MediaSource.MediaPeriodId)((Object)object), this.playbackInfo.timeline, this.playbackInfo.periodId, l2);
                }
                catch (Throwable throwable) {
                    l3 = l4;
                    break block19;
                }
            }
            this.playbackInfo = this.handlePositionDiscontinuity((MediaSource.MediaPeriodId)((Object)object), l4, l2);
            if (bl) {
                this.playbackInfoUpdate.setPositionDiscontinuity(2);
            }
            return;
        }
        this.playbackInfo = this.handlePositionDiscontinuity((MediaSource.MediaPeriodId)((Object)object), l3, l2);
        if (bl) {
            this.playbackInfoUpdate.setPositionDiscontinuity(2);
        }
        throw var1_4;
    }

    private long seekToPeriodPosition(MediaSource.MediaPeriodId mediaPeriodId, long l2, boolean bl) throws ExoPlaybackException {
        boolean bl2 = this.queue.getPlayingPeriod() != this.queue.getReadingPeriod();
        return this.seekToPeriodPosition(mediaPeriodId, l2, bl2, bl);
    }

    private long seekToPeriodPosition(MediaSource.MediaPeriodId rendererArray, long l2, boolean bl, boolean bl2) throws ExoPlaybackException {
        MediaPeriodHolder mediaPeriodHolder;
        MediaPeriodHolder mediaPeriodHolder2;
        this.stopRenderers();
        this.isRebuffering = false;
        if (bl2 || this.playbackInfo.playbackState == 3) {
            this.setState(2);
        }
        for (mediaPeriodHolder2 = mediaPeriodHolder = this.queue.getPlayingPeriod(); mediaPeriodHolder2 != null && !rendererArray.equals((Object)mediaPeriodHolder2.info.id); mediaPeriodHolder2 = mediaPeriodHolder2.getNext()) {
        }
        if (bl || mediaPeriodHolder != mediaPeriodHolder2 || mediaPeriodHolder2 != null && mediaPeriodHolder2.toRendererTime(l2) < 0L) {
            rendererArray = this.renderers;
            int n2 = rendererArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.disableRenderer(rendererArray[i2]);
            }
            if (mediaPeriodHolder2 != null) {
                while (this.queue.getPlayingPeriod() != mediaPeriodHolder2) {
                    this.queue.advancePlayingPeriod();
                }
                this.queue.removeAfter(mediaPeriodHolder2);
                mediaPeriodHolder2.setRendererOffset(0L);
                this.enableRenderers();
            }
        }
        if (mediaPeriodHolder2 != null) {
            this.queue.removeAfter(mediaPeriodHolder2);
            if (!mediaPeriodHolder2.prepared) {
                mediaPeriodHolder2.info = mediaPeriodHolder2.info.copyWithStartPositionUs(l2);
            } else {
                long l3 = l2;
                if (mediaPeriodHolder2.info.durationUs != -9223372036854775807L) {
                    l3 = l2;
                    if (l2 >= mediaPeriodHolder2.info.durationUs) {
                        l3 = Math.max(0L, mediaPeriodHolder2.info.durationUs - 1L);
                    }
                }
                l2 = l3;
                if (mediaPeriodHolder2.hasEnabledTracks) {
                    l2 = mediaPeriodHolder2.mediaPeriod.seekToUs(l3);
                    mediaPeriodHolder2.mediaPeriod.discardBuffer(l2 - this.backBufferDurationUs, this.retainBackBufferFromKeyframe);
                }
            }
            this.resetRendererPosition(l2);
            this.maybeContinueLoading();
        } else {
            this.queue.clear();
            this.resetRendererPosition(l2);
        }
        this.handleLoadingMediaPeriodChanged(false);
        this.handler.sendEmptyMessage(2);
        return l2;
    }

    private void sendMessageInternal(PlayerMessage playerMessage) throws ExoPlaybackException {
        if (playerMessage.getPositionMs() == -9223372036854775807L) {
            this.sendMessageToTarget(playerMessage);
        } else if (this.playbackInfo.timeline.isEmpty()) {
            this.pendingMessages.add(new PendingMessageInfo(playerMessage));
        } else {
            PendingMessageInfo pendingMessageInfo = new PendingMessageInfo(playerMessage);
            if (ExoPlayerImplInternal.resolvePendingMessagePosition(pendingMessageInfo, this.playbackInfo.timeline, this.playbackInfo.timeline, this.repeatMode, this.shuffleModeEnabled, this.window, this.period)) {
                this.pendingMessages.add(pendingMessageInfo);
                Collections.sort(this.pendingMessages);
            } else {
                playerMessage.markAsProcessed(false);
            }
        }
    }

    private void sendMessageToTarget(PlayerMessage playerMessage) throws ExoPlaybackException {
        if (playerMessage.getLooper() == this.playbackLooper) {
            this.deliverMessage(playerMessage);
            if (this.playbackInfo.playbackState == 3 || this.playbackInfo.playbackState == 2) {
                this.handler.sendEmptyMessage(2);
            }
        } else {
            this.handler.obtainMessage(15, (Object)playerMessage).sendToTarget();
        }
    }

    private void sendMessageToTargetThread(PlayerMessage playerMessage) {
        Looper looper = playerMessage.getLooper();
        if (!looper.getThread().isAlive()) {
            Log.w("TAG", "Trying to send message on a dead thread.");
            playerMessage.markAsProcessed(false);
            return;
        }
        this.clock.createHandler(looper, null).post((Runnable)new _$.Lambda.ExoPlayerImplInternal.g6dv66qY5BQbNAG_Gwu0Lamb0zs(this, playerMessage));
    }

    private void setAllRendererStreamsFinal(long l2) {
        for (Renderer renderer : this.renderers) {
            if (renderer.getStream() == null) continue;
            this.setCurrentStreamFinal(renderer, l2);
        }
    }

    private void setCurrentStreamFinal(Renderer renderer, long l2) {
        renderer.setCurrentStreamFinal();
        if (renderer instanceof TextRenderer) {
            ((TextRenderer)renderer).setFinalStreamEndPositionUs(l2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setForegroundModeInternal(boolean bl, AtomicBoolean atomicBoolean) {
        if (this.foregroundMode != bl) {
            this.foregroundMode = bl;
            if (!bl) {
                for (Renderer renderer : this.renderers) {
                    if (ExoPlayerImplInternal.isRendererEnabled(renderer)) continue;
                    renderer.reset();
                }
            }
        }
        if (atomicBoolean == null) return;
        synchronized (this) {
            atomicBoolean.set(true);
            this.notifyAll();
            return;
        }
    }

    private void setMediaItemsInternal(MediaSourceListUpdateMessage mediaSourceListUpdateMessage) throws ExoPlaybackException {
        this.playbackInfoUpdate.incrementPendingOperationAcks(1);
        if (mediaSourceListUpdateMessage.windowIndex != -1) {
            this.pendingInitialSeekPosition = new SeekPosition((Timeline)new PlaylistTimeline((Collection)mediaSourceListUpdateMessage.mediaSourceHolders, mediaSourceListUpdateMessage.shuffleOrder), mediaSourceListUpdateMessage.windowIndex, mediaSourceListUpdateMessage.positionUs);
        }
        this.handleMediaSourceListInfoRefreshed(this.mediaSourceList.setMediaSources(mediaSourceListUpdateMessage.mediaSourceHolders, mediaSourceListUpdateMessage.shuffleOrder));
    }

    private void setOffloadSchedulingEnabledInternal(boolean bl) {
        if (bl == this.offloadSchedulingEnabled) {
            return;
        }
        this.offloadSchedulingEnabled = bl;
        int n2 = this.playbackInfo.playbackState;
        if (!bl && n2 != 4 && n2 != 1) {
            this.handler.sendEmptyMessage(2);
        } else {
            this.playbackInfo = this.playbackInfo.copyWithOffloadSchedulingEnabled(bl);
        }
    }

    private void setPauseAtEndOfWindowInternal(boolean bl) throws ExoPlaybackException {
        this.pauseAtEndOfWindow = bl;
        this.resetPendingPauseAtEndOfPeriod();
        if (this.pendingPauseAtEndOfPeriod && this.queue.getReadingPeriod() != this.queue.getPlayingPeriod()) {
            this.seekToCurrentPosition(true);
            this.handleLoadingMediaPeriodChanged(false);
        }
    }

    private void setPlayWhenReadyInternal(boolean bl, int n2, boolean bl2, int n3) throws ExoPlaybackException {
        this.playbackInfoUpdate.incrementPendingOperationAcks(bl2 ? 1 : 0);
        this.playbackInfoUpdate.setPlayWhenReadyChangeReason(n3);
        this.playbackInfo = this.playbackInfo.copyWithPlayWhenReady(bl, n2);
        this.isRebuffering = false;
        this.notifyTrackSelectionPlayWhenReadyChanged(bl);
        if (!this.shouldPlayWhenReady()) {
            this.stopRenderers();
            this.updatePlaybackPositions();
        } else if (this.playbackInfo.playbackState == 3) {
            this.startRenderers();
            this.handler.sendEmptyMessage(2);
        } else if (this.playbackInfo.playbackState == 2) {
            this.handler.sendEmptyMessage(2);
        }
    }

    private void setPlaybackParametersInternal(PlaybackParameters playbackParameters) throws ExoPlaybackException {
        this.mediaClock.setPlaybackParameters(playbackParameters);
        this.handlePlaybackParameters(this.mediaClock.getPlaybackParameters(), true);
    }

    private void setRepeatModeInternal(int n2) throws ExoPlaybackException {
        this.repeatMode = n2;
        if (!this.queue.updateRepeatMode(this.playbackInfo.timeline, n2)) {
            this.seekToCurrentPosition(true);
        }
        this.handleLoadingMediaPeriodChanged(false);
    }

    private void setSeekParametersInternal(SeekParameters seekParameters) {
        this.seekParameters = seekParameters;
    }

    private void setShuffleModeEnabledInternal(boolean bl) throws ExoPlaybackException {
        this.shuffleModeEnabled = bl;
        if (!this.queue.updateShuffleModeEnabled(this.playbackInfo.timeline, bl)) {
            this.seekToCurrentPosition(true);
        }
        this.handleLoadingMediaPeriodChanged(false);
    }

    private void setShuffleOrderInternal(ShuffleOrder shuffleOrder) throws ExoPlaybackException {
        this.playbackInfoUpdate.incrementPendingOperationAcks(1);
        this.handleMediaSourceListInfoRefreshed(this.mediaSourceList.setShuffleOrder(shuffleOrder));
    }

    private void setState(int n2) {
        if (this.playbackInfo.playbackState != n2) {
            this.playbackInfo = this.playbackInfo.copyWithPlaybackState(n2);
        }
    }

    private boolean shouldAdvancePlayingPeriod() {
        boolean bl = this.shouldPlayWhenReady();
        boolean bl2 = false;
        if (!bl) {
            return false;
        }
        if (this.pendingPauseAtEndOfPeriod) {
            return false;
        }
        MediaPeriodHolder mediaPeriodHolder = this.queue.getPlayingPeriod();
        if (mediaPeriodHolder == null) {
            return false;
        }
        mediaPeriodHolder = mediaPeriodHolder.getNext();
        bl = bl2;
        if (mediaPeriodHolder != null) {
            bl = bl2;
            if (this.rendererPositionUs >= mediaPeriodHolder.getStartPositionRendererTime()) {
                bl = bl2;
                if (mediaPeriodHolder.allRenderersEnabled) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    private boolean shouldContinueLoading() {
        if (!this.isLoadingPossible()) {
            return false;
        }
        MediaPeriodHolder mediaPeriodHolder = this.queue.getLoadingPeriod();
        long l2 = this.getTotalBufferedDurationUs(mediaPeriodHolder.getNextLoadPositionUs());
        long l3 = mediaPeriodHolder == this.queue.getPlayingPeriod() ? mediaPeriodHolder.toPeriodTime(this.rendererPositionUs) : mediaPeriodHolder.toPeriodTime(this.rendererPositionUs) - mediaPeriodHolder.info.startPositionUs;
        return this.loadControl.shouldContinueLoading(l3, l2, this.mediaClock.getPlaybackParameters().speed);
    }

    private boolean shouldPlayWhenReady() {
        boolean bl = this.playbackInfo.playWhenReady && this.playbackInfo.playbackSuppressionReason == 0;
        return bl;
    }

    private boolean shouldTransitionToReadyState(boolean bl) {
        block7: {
            block6: {
                if (this.enabledRendererCount == 0) {
                    return this.isTimelineReady();
                }
                boolean bl2 = false;
                if (!bl) {
                    return false;
                }
                if (!this.playbackInfo.isLoading) {
                    return true;
                }
                long l2 = this.shouldUseLivePlaybackSpeedControl(this.playbackInfo.timeline, this.queue.getPlayingPeriod().info.id) ? this.livePlaybackSpeedControl.getTargetLiveOffsetUs() : -9223372036854775807L;
                MediaPeriodHolder mediaPeriodHolder = this.queue.getLoadingPeriod();
                boolean bl3 = mediaPeriodHolder.isFullyBuffered() && mediaPeriodHolder.info.isFinal;
                boolean bl4 = mediaPeriodHolder.info.id.isAd() && !mediaPeriodHolder.prepared;
                if (bl3 || bl4) break block6;
                bl = bl2;
                if (!this.loadControl.shouldStartPlayback(this.getTotalBufferedDurationUs(), this.mediaClock.getPlaybackParameters().speed, this.isRebuffering, l2)) break block7;
            }
            bl = true;
        }
        return bl;
    }

    private boolean shouldUseLivePlaybackSpeedControl(Timeline timeline, MediaSource.MediaPeriodId mediaPeriodId) {
        boolean bl;
        boolean bl2 = mediaPeriodId.isAd();
        boolean bl3 = bl = false;
        if (!bl2) {
            if (timeline.isEmpty()) {
                bl3 = bl;
            } else {
                timeline.getWindow(timeline.getPeriodByUid((Object)mediaPeriodId.periodUid, (Timeline.Period)this.period).windowIndex, this.window);
                bl3 = bl;
                if (this.window.isLive()) {
                    bl3 = bl;
                    if (this.window.isDynamic) {
                        bl3 = bl;
                        if (this.window.windowStartTimeMs != -9223372036854775807L) {
                            bl3 = true;
                        }
                    }
                }
            }
        }
        return bl3;
    }

    private static boolean shouldUseRequestedContentPosition(PlaybackInfo playbackInfo, Timeline.Period period, Timeline.Window window) {
        MediaSource.MediaPeriodId mediaPeriodId = playbackInfo.periodId;
        playbackInfo = playbackInfo.timeline;
        boolean bl = mediaPeriodId.isAd() || playbackInfo.isEmpty() || playbackInfo.getWindow((int)playbackInfo.getPeriodByUid((Object)mediaPeriodId.periodUid, (Timeline.Period)period).windowIndex, (Timeline.Window)window).isPlaceholder;
        return bl;
    }

    private void startRenderers() throws ExoPlaybackException {
        this.isRebuffering = false;
        this.mediaClock.start();
        for (Renderer renderer : this.renderers) {
            if (!ExoPlayerImplInternal.isRendererEnabled(renderer)) continue;
            renderer.start();
        }
    }

    private void stopInternal(boolean bl, boolean bl2) {
        bl = bl || !this.foregroundMode;
        this.resetInternal(bl, false, true, false);
        this.playbackInfoUpdate.incrementPendingOperationAcks(bl2 ? 1 : 0);
        this.loadControl.onStopped();
        this.setState(1);
    }

    private void stopRenderers() throws ExoPlaybackException {
        this.mediaClock.stop();
        for (Renderer renderer : this.renderers) {
            if (!ExoPlayerImplInternal.isRendererEnabled(renderer)) continue;
            this.ensureStopped(renderer);
        }
    }

    private void updateIsLoading() {
        MediaPeriodHolder mediaPeriodHolder = this.queue.getLoadingPeriod();
        boolean bl = this.shouldContinueLoading || mediaPeriodHolder != null && mediaPeriodHolder.mediaPeriod.isLoading();
        if (bl != this.playbackInfo.isLoading) {
            this.playbackInfo = this.playbackInfo.copyWithIsLoading(bl);
        }
    }

    private void updateLivePlaybackSpeedControl(Timeline object, MediaSource.MediaPeriodId object2, Timeline timeline, MediaSource.MediaPeriodId mediaPeriodId, long l2) {
        if (!object.isEmpty() && this.shouldUseLivePlaybackSpeedControl((Timeline)object, (MediaSource.MediaPeriodId)((Object)object2))) {
            object.getWindow(object.getPeriodByUid((Object)object2.periodUid, (Timeline.Period)this.period).windowIndex, this.window);
            this.livePlaybackSpeedControl.setLiveConfiguration(Util.castNonNull(this.window.liveConfiguration));
            if (l2 != -9223372036854775807L) {
                this.livePlaybackSpeedControl.setTargetLiveOffsetOverrideUs(this.getLiveOffsetUs((Timeline)object, object2.periodUid, l2));
            } else {
                object2 = this.window.uid;
                object = null;
                if (!timeline.isEmpty()) {
                    object = timeline.getWindow((int)timeline.getPeriodByUid((Object)mediaPeriodId.periodUid, (Timeline.Period)this.period).windowIndex, (Timeline.Window)this.window).uid;
                }
                if (!Util.areEqual(object, object2)) {
                    this.livePlaybackSpeedControl.setTargetLiveOffsetOverrideUs(-9223372036854775807L);
                }
            }
            return;
        }
        if (this.mediaClock.getPlaybackParameters().speed != this.playbackInfo.playbackParameters.speed) {
            this.mediaClock.setPlaybackParameters(this.playbackInfo.playbackParameters);
        }
    }

    private void updateLoadControlTrackSelection(TrackGroupArray trackGroupArray, TrackSelectorResult trackSelectorResult) {
        this.loadControl.onTracksSelected(this.renderers, trackGroupArray, trackSelectorResult.selections);
    }

    private void updatePeriods() throws ExoPlaybackException, IOException {
        if (!this.playbackInfo.timeline.isEmpty() && this.mediaSourceList.isPrepared()) {
            this.maybeUpdateLoadingPeriod();
            this.maybeUpdateReadingPeriod();
            this.maybeUpdateReadingRenderers();
            this.maybeUpdatePlayingPeriod();
        }
    }

    private void updatePlaybackPositions() throws ExoPlaybackException {
        float f2;
        MediaPeriodHolder mediaPeriodHolder = this.queue.getPlayingPeriod();
        if (mediaPeriodHolder == null) {
            return;
        }
        long l2 = mediaPeriodHolder.prepared ? mediaPeriodHolder.mediaPeriod.readDiscontinuity() : -9223372036854775807L;
        if (l2 != -9223372036854775807L) {
            this.resetRendererPosition(l2);
            if (l2 != this.playbackInfo.positionUs) {
                this.playbackInfo = this.handlePositionDiscontinuity(this.playbackInfo.periodId, l2, this.playbackInfo.requestedContentPositionUs);
                this.playbackInfoUpdate.setPositionDiscontinuity(4);
            }
        } else {
            DefaultMediaClock defaultMediaClock = this.mediaClock;
            boolean bl = mediaPeriodHolder != this.queue.getReadingPeriod();
            this.rendererPositionUs = defaultMediaClock.syncAndGetPositionUs(bl);
            l2 = mediaPeriodHolder.toPeriodTime(this.rendererPositionUs);
            this.maybeTriggerPendingMessages(this.playbackInfo.positionUs, l2);
            this.playbackInfo.positionUs = l2;
        }
        mediaPeriodHolder = this.queue.getLoadingPeriod();
        this.playbackInfo.bufferedPositionUs = mediaPeriodHolder.getBufferedPositionUs();
        this.playbackInfo.totalBufferedDurationUs = this.getTotalBufferedDurationUs();
        if (this.playbackInfo.playWhenReady && this.playbackInfo.playbackState == 3 && this.shouldUseLivePlaybackSpeedControl(this.playbackInfo.timeline, this.playbackInfo.periodId) && this.playbackInfo.playbackParameters.speed == 1.0f && this.mediaClock.getPlaybackParameters().speed != (f2 = this.livePlaybackSpeedControl.getAdjustedPlaybackSpeed(this.getCurrentLiveOffsetUs(), this.getTotalBufferedDurationUs()))) {
            this.mediaClock.setPlaybackParameters(this.playbackInfo.playbackParameters.withSpeed(f2));
            this.handlePlaybackParameters(this.playbackInfo.playbackParameters, this.mediaClock.getPlaybackParameters().speed, false, false);
        }
    }

    private void updateTrackSelectionPlaybackSpeed(float f2) {
        for (MediaPeriodHolder mediaPeriodHolder = this.queue.getPlayingPeriod(); mediaPeriodHolder != null; mediaPeriodHolder = mediaPeriodHolder.getNext()) {
            for (ExoTrackSelection exoTrackSelection : mediaPeriodHolder.getTrackSelectorResult().selections) {
                if (exoTrackSelection == null) continue;
                exoTrackSelection.onPlaybackSpeed(f2);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void waitUninterruptibly(Supplier<Boolean> supplier, long l2) {
        synchronized (this) {
            long l3 = this.clock.elapsedRealtime();
            boolean bl = false;
            long l4 = l2;
            while (true) {
                boolean bl2 = supplier.get();
                if (bl2 || l4 <= 0L) break;
                try {
                    this.wait(l4);
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                }
                l4 = l3 + l2 - this.clock.elapsedRealtime();
                continue;
                break;
            }
            if (!bl) return;
            Thread.currentThread().interrupt();
            return;
        }
    }

    public void addMediaSources(int n2, List<MediaSourceList.MediaSourceHolder> list, ShuffleOrder shuffleOrder) {
        this.handler.obtainMessage(18, n2, 0, (Object)new MediaSourceListUpdateMessage(list, shuffleOrder, -1, -9223372036854775807L)).sendToTarget();
    }

    public void experimentalSetForegroundModeTimeoutMs(long l2) {
        this.setForegroundModeTimeoutMs = l2;
    }

    public void experimentalSetOffloadSchedulingEnabled(boolean bl) {
        this.handler.obtainMessage(24, bl ? 1 : 0, 0).sendToTarget();
    }

    public Looper getPlaybackLooper() {
        return this.playbackLooper;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean handleMessage(Message object) {
        try {
            switch (((Message)object).what) {
                default: {
                    return false;
                }
                case 25: {
                    this.attemptErrorRecovery((ExoPlaybackException)((Message)object).obj);
                    break;
                }
                case 24: {
                    boolean bl = ((Message)object).arg1 == 1;
                    this.setOffloadSchedulingEnabledInternal(bl);
                    break;
                }
                case 23: {
                    boolean bl = ((Message)object).arg1 != 0;
                    this.setPauseAtEndOfWindowInternal(bl);
                    break;
                }
                case 22: {
                    this.mediaSourceListUpdateRequestedInternal();
                    break;
                }
                case 21: {
                    this.setShuffleOrderInternal((ShuffleOrder)((Message)object).obj);
                    break;
                }
                case 20: {
                    this.removeMediaItemsInternal(((Message)object).arg1, ((Message)object).arg2, (ShuffleOrder)((Message)object).obj);
                    break;
                }
                case 19: {
                    this.moveMediaItemsInternal((MoveMediaItemsMessage)((Message)object).obj);
                    break;
                }
                case 18: {
                    this.addMediaItemsInternal((MediaSourceListUpdateMessage)((Message)object).obj, ((Message)object).arg1);
                    break;
                }
                case 17: {
                    this.setMediaItemsInternal((MediaSourceListUpdateMessage)((Message)object).obj);
                    break;
                }
                case 16: {
                    this.handlePlaybackParameters((PlaybackParameters)((Message)object).obj, false);
                    break;
                }
                case 15: {
                    this.sendMessageToTargetThread((PlayerMessage)((Message)object).obj);
                    break;
                }
                case 14: {
                    this.sendMessageInternal((PlayerMessage)((Message)object).obj);
                    break;
                }
                case 13: {
                    boolean bl = ((Message)object).arg1 != 0;
                    this.setForegroundModeInternal(bl, (AtomicBoolean)((Message)object).obj);
                    break;
                }
                case 12: {
                    boolean bl = ((Message)object).arg1 != 0;
                    this.setShuffleModeEnabledInternal(bl);
                    break;
                }
                case 11: {
                    this.setRepeatModeInternal(((Message)object).arg1);
                    break;
                }
                case 10: {
                    this.reselectTracksInternal();
                    break;
                }
                case 9: {
                    this.handleContinueLoadingRequested((MediaPeriod)((Message)object).obj);
                    break;
                }
                case 8: {
                    this.handlePeriodPrepared((MediaPeriod)((Message)object).obj);
                    break;
                }
                case 7: {
                    this.releaseInternal();
                    return true;
                }
                case 6: {
                    this.stopInternal(false, true);
                    break;
                }
                case 5: {
                    this.setSeekParametersInternal((SeekParameters)((Message)object).obj);
                    break;
                }
                case 4: {
                    this.setPlaybackParametersInternal((PlaybackParameters)((Message)object).obj);
                    break;
                }
                case 3: {
                    this.seekToInternal((SeekPosition)((Message)object).obj);
                    break;
                }
                case 2: {
                    this.doSomeWork();
                    break;
                }
                case 1: {
                    boolean bl = ((Message)object).arg1 != 0;
                    this.setPlayWhenReadyInternal(bl, ((Message)object).arg2, true, 1);
                    break;
                }
                case 0: {
                    this.prepareInternal();
                }
            }
            this.maybeNotifyPlaybackInfoChanged();
            return true;
        }
        catch (RuntimeException runtimeException) {
            ExoPlaybackException exoPlaybackException = ExoPlaybackException.createForUnexpected(runtimeException);
            Log.e(TAG, "Playback error", exoPlaybackException);
            this.stopInternal(true, false);
            this.playbackInfo = this.playbackInfo.copyWithPlaybackError(exoPlaybackException);
            this.maybeNotifyPlaybackInfoChanged();
            return true;
        }
        catch (IOException iOException) {
            ExoPlaybackException exoPlaybackException = ExoPlaybackException.createForSource(iOException);
            MediaPeriodHolder mediaPeriodHolder = this.queue.getPlayingPeriod();
            ExoPlaybackException exoPlaybackException2 = exoPlaybackException;
            if (mediaPeriodHolder != null) {
                exoPlaybackException2 = exoPlaybackException.copyWithMediaPeriodId(mediaPeriodHolder.info.id);
            }
            Log.e(TAG, "Playback error", exoPlaybackException2);
            this.stopInternal(false, false);
            this.playbackInfo = this.playbackInfo.copyWithPlaybackError(exoPlaybackException2);
            this.maybeNotifyPlaybackInfoChanged();
            return true;
        }
        catch (ExoPlaybackException exoPlaybackException) {
            object = exoPlaybackException;
            if (exoPlaybackException.type == 1) {
                MediaPeriodHolder mediaPeriodHolder = this.queue.getReadingPeriod();
                object = exoPlaybackException;
                if (mediaPeriodHolder != null) {
                    object = exoPlaybackException.copyWithMediaPeriodId(mediaPeriodHolder.info.id);
                }
            }
            if (((ExoPlaybackException)object).isRecoverable && this.pendingRecoverableError == null) {
                Log.w(TAG, "Recoverable playback error", (Throwable)object);
                this.pendingRecoverableError = object;
                object = this.handler.obtainMessage(25, object);
                object.getTarget().sendMessageAtFrontOfQueue((Message)object);
            } else {
                ExoPlaybackException exoPlaybackException3 = this.pendingRecoverableError;
                if (exoPlaybackException3 != null) {
                    ((Throwable)object).addSuppressed(exoPlaybackException3);
                    this.pendingRecoverableError = null;
                }
                Log.e(TAG, "Playback error", (Throwable)object);
                this.stopInternal(true, false);
                this.playbackInfo = this.playbackInfo.copyWithPlaybackError((ExoPlaybackException)object);
            }
            this.maybeNotifyPlaybackInfoChanged();
        }
        return true;
    }

    public /* synthetic */ Boolean lambda$release$0$ExoPlayerImplInternal() {
        return this.released;
    }

    public /* synthetic */ void lambda$sendMessageToTargetThread$1$ExoPlayerImplInternal(PlayerMessage playerMessage) {
        try {
            this.deliverMessage(playerMessage);
            return;
        }
        catch (ExoPlaybackException exoPlaybackException) {
            Log.e(TAG, "Unexpected error delivering message on external thread.", exoPlaybackException);
            throw new RuntimeException(exoPlaybackException);
        }
    }

    public void moveMediaSources(int n2, int n3, int n4, ShuffleOrder object) {
        object = new MoveMediaItemsMessage(n2, n3, n4, (ShuffleOrder)object);
        this.handler.obtainMessage(19, object).sendToTarget();
    }

    @Override
    public void onContinueLoadingRequested(MediaPeriod mediaPeriod) {
        this.handler.obtainMessage(9, (Object)mediaPeriod).sendToTarget();
    }

    public void onPlaybackParametersChanged(PlaybackParameters playbackParameters) {
        this.handler.obtainMessage(16, (Object)playbackParameters).sendToTarget();
    }

    public void onPlaylistUpdateRequested() {
        this.handler.sendEmptyMessage(22);
    }

    @Override
    public void onPrepared(MediaPeriod mediaPeriod) {
        this.handler.obtainMessage(8, (Object)mediaPeriod).sendToTarget();
    }

    public void onTrackSelectionsInvalidated() {
        this.handler.sendEmptyMessage(10);
    }

    public void prepare() {
        this.handler.obtainMessage(0).sendToTarget();
    }

    public boolean release() {
        synchronized (this) {
            if (!this.released) {
                if (!this.internalPlaybackThread.isAlive()) {
                } else {
                    this.handler.sendEmptyMessage(7);
                    _$.Lambda.ExoPlayerImplInternal.aFDQAhe8WjwID2XRaXNBFAVaeIk aFDQAhe8WjwID2XRaXNBFAVaeIk2 = new _$.Lambda.ExoPlayerImplInternal.aFDQAhe8WjwID2XRaXNBFAVaeIk(this);
                    this.waitUninterruptibly((Supplier<Boolean>)aFDQAhe8WjwID2XRaXNBFAVaeIk2, this.releaseTimeoutMs);
                    boolean bl = this.released;
                    return bl;
                }
            }
            return true;
        }
    }

    public void removeMediaSources(int n2, int n3, ShuffleOrder shuffleOrder) {
        this.handler.obtainMessage(20, n2, n3, (Object)shuffleOrder).sendToTarget();
    }

    public void seekTo(Timeline timeline, int n2, long l2) {
        this.handler.obtainMessage(3, (Object)new SeekPosition(timeline, n2, l2)).sendToTarget();
    }

    @Override
    public void sendMessage(PlayerMessage playerMessage) {
        synchronized (this) {
            if (!this.released && this.internalPlaybackThread.isAlive()) {
                this.handler.obtainMessage(14, (Object)playerMessage).sendToTarget();
                return;
            }
            Log.w(TAG, "Ignoring messages sent after release.");
            playerMessage.markAsProcessed(false);
            return;
        }
    }

    public boolean setForegroundMode(boolean bl) {
        synchronized (this) {
            if (!this.released) {
                if (!this.internalPlaybackThread.isAlive()) {
                } else {
                    if (bl) {
                        this.handler.obtainMessage(13, 1, 0).sendToTarget();
                        return true;
                    }
                    AtomicBoolean atomicBoolean = new AtomicBoolean();
                    this.handler.obtainMessage(13, 0, 0, (Object)atomicBoolean).sendToTarget();
                    _$$Lambda$WCNOc30RWlKfWWqwDTxwdaoGH_w _$$Lambda$WCNOc30RWlKfWWqwDTxwdaoGH_w = new _$$Lambda$WCNOc30RWlKfWWqwDTxwdaoGH_w(atomicBoolean);
                    this.waitUninterruptibly(_$$Lambda$WCNOc30RWlKfWWqwDTxwdaoGH_w, this.setForegroundModeTimeoutMs);
                    bl = atomicBoolean.get();
                    return bl;
                }
            }
            return true;
        }
    }

    public void setMediaSources(List<MediaSourceList.MediaSourceHolder> list, int n2, long l2, ShuffleOrder shuffleOrder) {
        this.handler.obtainMessage(17, (Object)new MediaSourceListUpdateMessage(list, shuffleOrder, n2, l2)).sendToTarget();
    }

    public void setPauseAtEndOfWindow(boolean bl) {
        this.handler.obtainMessage(23, bl ? 1 : 0, 0).sendToTarget();
    }

    public void setPlayWhenReady(boolean bl, int n2) {
        this.handler.obtainMessage(1, bl ? 1 : 0, n2).sendToTarget();
    }

    public void setPlaybackParameters(PlaybackParameters playbackParameters) {
        this.handler.obtainMessage(4, (Object)playbackParameters).sendToTarget();
    }

    public void setRepeatMode(int n2) {
        this.handler.obtainMessage(11, n2, 0).sendToTarget();
    }

    public void setSeekParameters(SeekParameters seekParameters) {
        this.handler.obtainMessage(5, (Object)seekParameters).sendToTarget();
    }

    public void setShuffleModeEnabled(boolean bl) {
        this.handler.obtainMessage(12, bl ? 1 : 0, 0).sendToTarget();
    }

    public void setShuffleOrder(ShuffleOrder shuffleOrder) {
        this.handler.obtainMessage(21, (Object)shuffleOrder).sendToTarget();
    }

    public void stop() {
        this.handler.obtainMessage(6).sendToTarget();
    }

    private static final class MediaSourceListUpdateMessage {
        private final List<MediaSourceList.MediaSourceHolder> mediaSourceHolders;
        private final long positionUs;
        private final ShuffleOrder shuffleOrder;
        private final int windowIndex;

        private MediaSourceListUpdateMessage(List<MediaSourceList.MediaSourceHolder> list, ShuffleOrder shuffleOrder, int n2, long l2) {
            this.mediaSourceHolders = list;
            this.shuffleOrder = shuffleOrder;
            this.windowIndex = n2;
            this.positionUs = l2;
        }
    }

    private static class MoveMediaItemsMessage {
        public final int fromIndex;
        public final int newFromIndex;
        public final ShuffleOrder shuffleOrder;
        public final int toIndex;

        public MoveMediaItemsMessage(int n2, int n3, int n4, ShuffleOrder shuffleOrder) {
            this.fromIndex = n2;
            this.toIndex = n3;
            this.newFromIndex = n4;
            this.shuffleOrder = shuffleOrder;
        }
    }

    private static final class PendingMessageInfo
    implements Comparable<PendingMessageInfo> {
        public final PlayerMessage message;
        public int resolvedPeriodIndex;
        public long resolvedPeriodTimeUs;
        public Object resolvedPeriodUid;

        public PendingMessageInfo(PlayerMessage playerMessage) {
            this.message = playerMessage;
        }

        @Override
        public int compareTo(PendingMessageInfo pendingMessageInfo) {
            int n2;
            Object object = this.resolvedPeriodUid;
            int n3 = 1;
            int n4 = object == null ? 1 : 0;
            if (n4 != (n2 = pendingMessageInfo.resolvedPeriodUid == null)) {
                n4 = n3;
                if (this.resolvedPeriodUid != null) {
                    n4 = -1;
                }
                return n4;
            }
            if (this.resolvedPeriodUid == null) {
                return 0;
            }
            n4 = this.resolvedPeriodIndex - pendingMessageInfo.resolvedPeriodIndex;
            if (n4 != 0) {
                return n4;
            }
            return Util.compareLong(this.resolvedPeriodTimeUs, pendingMessageInfo.resolvedPeriodTimeUs);
        }

        public void setResolvedPosition(int n2, long l2, Object object) {
            this.resolvedPeriodIndex = n2;
            this.resolvedPeriodTimeUs = l2;
            this.resolvedPeriodUid = object;
        }
    }

    public static final class PlaybackInfoUpdate {
        public int discontinuityReason;
        private boolean hasPendingChange;
        public boolean hasPlayWhenReadyChangeReason;
        public int operationAcks;
        public int playWhenReadyChangeReason;
        public PlaybackInfo playbackInfo;
        public boolean positionDiscontinuity;

        public PlaybackInfoUpdate(PlaybackInfo playbackInfo) {
            this.playbackInfo = playbackInfo;
        }

        public void incrementPendingOperationAcks(int n2) {
            boolean bl = this.hasPendingChange;
            boolean bl2 = n2 > 0;
            this.hasPendingChange = bl | bl2;
            this.operationAcks += n2;
        }

        public void setPlayWhenReadyChangeReason(int n2) {
            this.hasPendingChange = true;
            this.hasPlayWhenReadyChangeReason = true;
            this.playWhenReadyChangeReason = n2;
        }

        public void setPlaybackInfo(PlaybackInfo playbackInfo) {
            boolean bl = this.hasPendingChange;
            boolean bl2 = this.playbackInfo != playbackInfo;
            this.hasPendingChange = bl | bl2;
            this.playbackInfo = playbackInfo;
        }

        public void setPositionDiscontinuity(int n2) {
            boolean bl = this.positionDiscontinuity;
            boolean bl2 = true;
            if (bl && this.discontinuityReason != 4) {
                if (n2 != 4) {
                    bl2 = false;
                }
                Assertions.checkArgument(bl2);
                return;
            }
            this.hasPendingChange = true;
            this.positionDiscontinuity = true;
            this.discontinuityReason = n2;
        }
    }

    public static interface PlaybackInfoUpdateListener {
        public void onPlaybackInfoUpdate(PlaybackInfoUpdate var1);
    }

    private static final class PositionUpdateForPlaylistChange {
        public final boolean endPlayback;
        public final boolean forceBufferingState;
        public final MediaSource.MediaPeriodId periodId;
        public final long periodPositionUs;
        public final long requestedContentPositionUs;
        public final boolean setTargetLiveOffset;

        public PositionUpdateForPlaylistChange(MediaSource.MediaPeriodId mediaPeriodId, long l2, long l3, boolean bl, boolean bl2, boolean bl3) {
            this.periodId = mediaPeriodId;
            this.periodPositionUs = l2;
            this.requestedContentPositionUs = l3;
            this.forceBufferingState = bl;
            this.endPlayback = bl2;
            this.setTargetLiveOffset = bl3;
        }
    }

    private static final class SeekPosition {
        public final Timeline timeline;
        public final int windowIndex;
        public final long windowPositionUs;

        public SeekPosition(Timeline timeline, int n2, long l2) {
            this.timeline = timeline;
            this.windowIndex = n2;
            this.windowPositionUs = l2;
        }
    }
}

