/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2;

import android.os.Handler;
import android.os.Looper;
import android.util.Pair;
import com.google.android.exoplayer2.BasePlayer;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.ExoPlayerImplInternal;
import com.google.android.exoplayer2.ExoPlayerLibraryInfo;
import com.google.android.exoplayer2.ExoTimeoutException;
import com.google.android.exoplayer2.IllegalSeekPositionException;
import com.google.android.exoplayer2.LivePlaybackSpeedControl;
import com.google.android.exoplayer2.LoadControl;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.MediaSourceInfoHolder;
import com.google.android.exoplayer2.MediaSourceList;
import com.google.android.exoplayer2.PlaybackInfo;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.PlayerMessage;
import com.google.android.exoplayer2.PlaylistTimeline;
import com.google.android.exoplayer2.Renderer;
import com.google.android.exoplayer2.RendererConfiguration;
import com.google.android.exoplayer2.SeekParameters;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2._$;
import com.google.android.exoplayer2._$$Lambda$ExoPlayerImpl$DwHo3cPyQejUhkqC0MASbmmErYM;
import com.google.android.exoplayer2._$$Lambda$ExoPlayerImpl$tbxoDd63J_d2elNmBCgHBU94Y9Q;
import com.google.android.exoplayer2._$$Lambda$IvHsGgCxoxdxsyZUtt2N2KRx2jA;
import com.google.android.exoplayer2._$$Lambda$Y25dpL_yMnUiNhc4TOMUnLpZGCU;
import com.google.android.exoplayer2.analytics.AnalyticsCollector;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.MediaSourceFactory;
import com.google.android.exoplayer2.source.ShuffleOrder;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.trackselection.ExoTrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelectionArray;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelectorResult;
import com.google.android.exoplayer2.upstream.BandwidthMeter;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Clock;
import com.google.android.exoplayer2.util.HandlerWrapper;
import com.google.android.exoplayer2.util.ListenerSet;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.Util;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class ExoPlayerImpl
extends BasePlayer
implements ExoPlayer {
    private static final String TAG = "ExoPlayerImpl";
    private final AnalyticsCollector analyticsCollector;
    private final Looper applicationLooper;
    private final BandwidthMeter bandwidthMeter;
    private final Clock clock;
    final TrackSelectorResult emptyTrackSelectorResult;
    private boolean foregroundMode;
    private boolean hasPendingDiscontinuity;
    private final ExoPlayerImplInternal internalPlayer;
    private final ListenerSet<Player.EventListener, Player.Events> listeners;
    private int maskingPeriodIndex;
    private int maskingWindowIndex;
    private long maskingWindowPositionMs;
    private final MediaSourceFactory mediaSourceFactory;
    private final List<MediaSourceHolderSnapshot> mediaSourceHolderSnapshots;
    private boolean pauseAtEndOfMediaItems;
    private int pendingDiscontinuityReason;
    private int pendingOperationAcks;
    private int pendingPlayWhenReadyChangeReason;
    private final Timeline.Period period;
    private PlaybackInfo playbackInfo;
    private final HandlerWrapper playbackInfoUpdateHandler;
    private final ExoPlayerImplInternal.PlaybackInfoUpdateListener playbackInfoUpdateListener;
    private final Renderer[] renderers;
    private int repeatMode;
    private SeekParameters seekParameters;
    private boolean shuffleModeEnabled;
    private ShuffleOrder shuffleOrder;
    private final TrackSelector trackSelector;
    private final boolean useLazyPreparation;

    public ExoPlayerImpl(Renderer[] rendererArray, TrackSelector trackSelector, MediaSourceFactory object, LoadControl loadControl, BandwidthMeter bandwidthMeter, AnalyticsCollector analyticsCollector, boolean bl, SeekParameters seekParameters, LivePlaybackSpeedControl livePlaybackSpeedControl, long l2, boolean bl2, Clock clock, Looper looper, Player player) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Init ");
        stringBuilder.append(Integer.toHexString(System.identityHashCode((Object)this)));
        stringBuilder.append(" [");
        stringBuilder.append("ExoPlayerLib/2.13.3");
        stringBuilder.append("] [");
        stringBuilder.append(Util.DEVICE_DEBUG_INFO);
        stringBuilder.append("]");
        Log.i(TAG, stringBuilder.toString());
        boolean bl3 = rendererArray.length > 0;
        Assertions.checkState(bl3);
        this.renderers = Assertions.checkNotNull(rendererArray);
        this.trackSelector = Assertions.checkNotNull(trackSelector);
        this.mediaSourceFactory = object;
        this.bandwidthMeter = bandwidthMeter;
        this.analyticsCollector = analyticsCollector;
        this.useLazyPreparation = bl;
        this.seekParameters = seekParameters;
        this.pauseAtEndOfMediaItems = bl2;
        this.applicationLooper = looper;
        this.clock = clock;
        this.repeatMode = 0;
        object = player != null ? player : this;
        this.listeners = new ListenerSet(looper, clock, _$$Lambda$Y25dpL_yMnUiNhc4TOMUnLpZGCU.INSTANCE, new _$.Lambda.ExoPlayerImpl.M1tdaLlAUPJUvzD_hsod_P0qbdk((Player)object));
        this.mediaSourceHolderSnapshots = new ArrayList<MediaSourceHolderSnapshot>();
        this.shuffleOrder = new ShuffleOrder.DefaultShuffleOrder(0);
        this.emptyTrackSelectorResult = new TrackSelectorResult(new RendererConfiguration[rendererArray.length], new ExoTrackSelection[rendererArray.length], null);
        this.period = new Timeline.Period();
        this.maskingWindowIndex = -1;
        this.playbackInfoUpdateHandler = clock.createHandler(looper, null);
        this.playbackInfoUpdateListener = new _$.Lambda.ExoPlayerImpl.JP2tKdyDgPDo0qQLjajOiOBV3jA(this);
        this.playbackInfo = PlaybackInfo.createDummy((TrackSelectorResult)this.emptyTrackSelectorResult);
        if (analyticsCollector != null) {
            analyticsCollector.setPlayer((Player)object, looper);
            this.addListener(analyticsCollector);
            bandwidthMeter.addEventListener(new Handler(looper), analyticsCollector);
        }
        this.internalPlayer = new ExoPlayerImplInternal(rendererArray, trackSelector, this.emptyTrackSelectorResult, loadControl, bandwidthMeter, this.repeatMode, this.shuffleModeEnabled, analyticsCollector, seekParameters, livePlaybackSpeedControl, l2, bl2, looper, clock, this.playbackInfoUpdateListener);
    }

    private List<MediaSourceList.MediaSourceHolder> addMediaSourceHolders(int n2, List<MediaSource> list) {
        ArrayList<MediaSourceList.MediaSourceHolder> arrayList = new ArrayList<MediaSourceList.MediaSourceHolder>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            MediaSourceList.MediaSourceHolder mediaSourceHolder = new MediaSourceList.MediaSourceHolder(list.get(i2), this.useLazyPreparation);
            arrayList.add(mediaSourceHolder);
            this.mediaSourceHolderSnapshots.add(i2 + n2, new MediaSourceHolderSnapshot(mediaSourceHolder.uid, mediaSourceHolder.mediaSource.getTimeline()));
        }
        this.shuffleOrder = this.shuffleOrder.cloneAndInsert(n2, arrayList.size());
        return arrayList;
    }

    private Timeline createMaskingTimeline() {
        return new PlaylistTimeline(this.mediaSourceHolderSnapshots, this.shuffleOrder);
    }

    private List<MediaSource> createMediaSources(List<MediaItem> list) {
        ArrayList<MediaSource> arrayList = new ArrayList<MediaSource>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            arrayList.add(this.mediaSourceFactory.createMediaSource(list.get(i2)));
        }
        return arrayList;
    }

    private Pair<Boolean, Integer> evaluateMediaItemTransitionReason(PlaybackInfo playbackInfo, PlaybackInfo object, boolean bl, int n2, boolean bl2) {
        int n3;
        Boolean bl3;
        Integer n4;
        Timeline timeline;
        block6: {
            block10: {
                block8: {
                    int n5;
                    block9: {
                        block7: {
                            Object object2 = ((PlaybackInfo)object).timeline;
                            timeline = playbackInfo.timeline;
                            boolean bl4 = timeline.isEmpty();
                            n4 = -1;
                            bl3 = false;
                            if (bl4 && object2.isEmpty()) {
                                return new Pair((Object)bl3, (Object)n4);
                            }
                            bl4 = timeline.isEmpty();
                            boolean bl5 = object2.isEmpty();
                            n5 = 3;
                            if (bl4 != bl5) {
                                return new Pair((Object)true, (Object)3);
                            }
                            object = object2.getWindow((int)object2.getPeriodByUid((Object)((PlaybackInfo)object).periodId.periodUid, (Timeline.Period)this.period).windowIndex, (Timeline.Window)this.window).uid;
                            object2 = timeline.getWindow((int)timeline.getPeriodByUid((Object)playbackInfo.periodId.periodUid, (Timeline.Period)this.period).windowIndex, (Timeline.Window)this.window).uid;
                            n3 = this.window.firstPeriodIndex;
                            if (object.equals(object2)) break block6;
                            if (!bl || n2 != 0) break block7;
                            n2 = 1;
                            break block8;
                        }
                        if (!bl || n2 != 1) break block9;
                        n2 = 2;
                        break block8;
                    }
                    if (!bl2) break block10;
                    n2 = n5;
                }
                return new Pair((Object)true, (Object)n2);
            }
            throw new IllegalStateException();
        }
        if (bl && n2 == 0 && timeline.getIndexOfPeriod(playbackInfo.periodId.periodUid) == n3) {
            return new Pair((Object)true, (Object)0);
        }
        return new Pair((Object)bl3, (Object)n4);
    }

    private int getCurrentWindowIndexInternal() {
        if (this.playbackInfo.timeline.isEmpty()) {
            return this.maskingWindowIndex;
        }
        return this.playbackInfo.timeline.getPeriodByUid((Object)this.playbackInfo.periodId.periodUid, (Timeline.Period)this.period).windowIndex;
    }

    private Pair<Object, Long> getPeriodPositionAfterTimelineChanged(Timeline object, Timeline timeline) {
        long l2 = this.getContentPosition();
        boolean bl = object.isEmpty();
        int n2 = -1;
        if (!bl && !timeline.isEmpty()) {
            int n3 = this.getCurrentWindowIndex();
            Pair pair = object.getPeriodPosition(this.window, this.period, n3, C.msToUs(l2));
            Object object2 = Util.castNonNull(pair).first;
            if (timeline.getIndexOfPeriod(object2) != -1) {
                return pair;
            }
            if ((object = ExoPlayerImplInternal.resolveSubsequentPeriod(this.window, this.period, this.repeatMode, this.shuffleModeEnabled, object2, object, timeline)) != null) {
                timeline.getPeriodByUid(object, this.period);
                return this.getPeriodPositionOrMaskWindowPosition(timeline, this.period.windowIndex, timeline.getWindow(this.period.windowIndex, this.window).getDefaultPositionMs());
            }
            return this.getPeriodPositionOrMaskWindowPosition(timeline, -1, -9223372036854775807L);
        }
        boolean bl2 = !object.isEmpty() && timeline.isEmpty();
        if (!bl2) {
            n2 = this.getCurrentWindowIndexInternal();
        }
        if (bl2) {
            l2 = -9223372036854775807L;
        }
        return this.getPeriodPositionOrMaskWindowPosition(timeline, n2, l2);
    }

    private Pair<Object, Long> getPeriodPositionOrMaskWindowPosition(Timeline timeline, int n2, long l2) {
        int n3;
        block6: {
            block5: {
                if (timeline.isEmpty()) {
                    this.maskingWindowIndex = n2;
                    long l3 = l2;
                    if (l2 == -9223372036854775807L) {
                        l3 = 0L;
                    }
                    this.maskingWindowPositionMs = l3;
                    this.maskingPeriodIndex = 0;
                    return null;
                }
                if (n2 == -1) break block5;
                n3 = n2;
                if (n2 < timeline.getWindowCount()) break block6;
            }
            n3 = timeline.getFirstWindowIndex(this.shuffleModeEnabled);
            l2 = timeline.getWindow(n3, this.window).getDefaultPositionMs();
        }
        return timeline.getPeriodPosition(this.window, this.period, n3, C.msToUs(l2));
    }

    private void handlePlaybackInfo(ExoPlayerImplInternal.PlaybackInfoUpdate playbackInfoUpdate) {
        this.pendingOperationAcks -= playbackInfoUpdate.operationAcks;
        boolean bl = playbackInfoUpdate.positionDiscontinuity;
        boolean bl2 = true;
        if (bl) {
            this.hasPendingDiscontinuity = true;
            this.pendingDiscontinuityReason = playbackInfoUpdate.discontinuityReason;
        }
        if (playbackInfoUpdate.hasPlayWhenReadyChangeReason) {
            this.pendingPlayWhenReadyChangeReason = playbackInfoUpdate.playWhenReadyChangeReason;
        }
        if (this.pendingOperationAcks == 0) {
            Object object = playbackInfoUpdate.playbackInfo.timeline;
            if (!this.playbackInfo.timeline.isEmpty() && object.isEmpty()) {
                this.maskingWindowIndex = -1;
                this.maskingWindowPositionMs = 0L;
                this.maskingPeriodIndex = 0;
            }
            if (!object.isEmpty()) {
                if ((object = ((PlaylistTimeline)object).getChildTimelines()).size() != this.mediaSourceHolderSnapshots.size()) {
                    bl2 = false;
                }
                Assertions.checkState(bl2);
                for (int i2 = 0; i2 < object.size(); ++i2) {
                    MediaSourceHolderSnapshot.access$002(this.mediaSourceHolderSnapshots.get(i2), (Timeline)object.get(i2));
                }
            }
            bl2 = this.hasPendingDiscontinuity;
            this.hasPendingDiscontinuity = false;
            this.updatePlaybackInfo(playbackInfoUpdate.playbackInfo, bl2, this.pendingDiscontinuityReason, 1, this.pendingPlayWhenReadyChangeReason, false);
        }
    }

    private static boolean isPlaying(PlaybackInfo playbackInfo) {
        boolean bl = playbackInfo.playbackState == 3 && playbackInfo.playWhenReady && playbackInfo.playbackSuppressionReason == 0;
        return bl;
    }

    static /* synthetic */ void lambda$new$0(Player player, Player.EventListener eventListener, Player.Events events) {
        eventListener.onEvents(player, events);
    }

    static /* synthetic */ void lambda$release$5(Player.EventListener eventListener) {
        eventListener.onPlayerError(ExoPlaybackException.createForRenderer(new ExoTimeoutException(1)));
    }

    static /* synthetic */ void lambda$setRepeatMode$3(int n2, Player.EventListener eventListener) {
        eventListener.onRepeatModeChanged(n2);
    }

    static /* synthetic */ void lambda$setShuffleModeEnabled$4(boolean bl, Player.EventListener eventListener) {
        eventListener.onShuffleModeEnabledChanged(bl);
    }

    static /* synthetic */ void lambda$updatePlaybackInfo$10(PlaybackInfo playbackInfo, TrackSelectionArray trackSelectionArray, Player.EventListener eventListener) {
        eventListener.onTracksChanged(playbackInfo.trackGroups, trackSelectionArray);
    }

    static /* synthetic */ void lambda$updatePlaybackInfo$11(PlaybackInfo playbackInfo, Player.EventListener eventListener) {
        eventListener.onStaticMetadataChanged(playbackInfo.staticMetadata);
    }

    static /* synthetic */ void lambda$updatePlaybackInfo$12(PlaybackInfo playbackInfo, Player.EventListener eventListener) {
        eventListener.onIsLoadingChanged(playbackInfo.isLoading);
    }

    static /* synthetic */ void lambda$updatePlaybackInfo$13(PlaybackInfo playbackInfo, Player.EventListener eventListener) {
        eventListener.onPlayerStateChanged(playbackInfo.playWhenReady, playbackInfo.playbackState);
    }

    static /* synthetic */ void lambda$updatePlaybackInfo$14(PlaybackInfo playbackInfo, Player.EventListener eventListener) {
        eventListener.onPlaybackStateChanged(playbackInfo.playbackState);
    }

    static /* synthetic */ void lambda$updatePlaybackInfo$15(PlaybackInfo playbackInfo, int n2, Player.EventListener eventListener) {
        eventListener.onPlayWhenReadyChanged(playbackInfo.playWhenReady, n2);
    }

    static /* synthetic */ void lambda$updatePlaybackInfo$16(PlaybackInfo playbackInfo, Player.EventListener eventListener) {
        eventListener.onPlaybackSuppressionReasonChanged(playbackInfo.playbackSuppressionReason);
    }

    static /* synthetic */ void lambda$updatePlaybackInfo$17(PlaybackInfo playbackInfo, Player.EventListener eventListener) {
        eventListener.onIsPlayingChanged(ExoPlayerImpl.isPlaying(playbackInfo));
    }

    static /* synthetic */ void lambda$updatePlaybackInfo$18(PlaybackInfo playbackInfo, Player.EventListener eventListener) {
        eventListener.onPlaybackParametersChanged(playbackInfo.playbackParameters);
    }

    static /* synthetic */ void lambda$updatePlaybackInfo$19(PlaybackInfo playbackInfo, Player.EventListener eventListener) {
        eventListener.onExperimentalOffloadSchedulingEnabledChanged(playbackInfo.offloadSchedulingEnabled);
    }

    static /* synthetic */ void lambda$updatePlaybackInfo$20(PlaybackInfo playbackInfo, Player.EventListener eventListener) {
        eventListener.onExperimentalSleepingForOffloadChanged(playbackInfo.sleepingForOffload);
    }

    static /* synthetic */ void lambda$updatePlaybackInfo$6(PlaybackInfo playbackInfo, int n2, Player.EventListener eventListener) {
        eventListener.onTimelineChanged(playbackInfo.timeline, n2);
    }

    static /* synthetic */ void lambda$updatePlaybackInfo$7(int n2, Player.EventListener eventListener) {
        eventListener.onPositionDiscontinuity(n2);
    }

    static /* synthetic */ void lambda$updatePlaybackInfo$8(MediaItem mediaItem, int n2, Player.EventListener eventListener) {
        eventListener.onMediaItemTransition(mediaItem, n2);
    }

    static /* synthetic */ void lambda$updatePlaybackInfo$9(PlaybackInfo playbackInfo, Player.EventListener eventListener) {
        eventListener.onPlayerError(playbackInfo.playbackError);
    }

    private PlaybackInfo maskTimelineAndPosition(PlaybackInfo object, Timeline object2, Pair<Object, Long> object3) {
        block8: {
            long l2;
            MediaSource.MediaPeriodId mediaPeriodId;
            int n2;
            PlaybackInfo playbackInfo;
            block5: {
                long l3;
                long l4;
                block6: {
                    block7: {
                        boolean bl = object2.isEmpty() || object3 != null;
                        Assertions.checkArgument(bl);
                        Timeline timeline = ((PlaybackInfo)object).timeline;
                        playbackInfo = object.copyWithTimeline(object2);
                        if (object2.isEmpty()) {
                            object = PlaybackInfo.getDummyPeriodForEmptyTimeline();
                            object = playbackInfo.copyWithNewPosition((MediaSource.MediaPeriodId)((Object)object), C.msToUs(this.maskingWindowPositionMs), C.msToUs(this.maskingWindowPositionMs), 0L, TrackGroupArray.EMPTY, this.emptyTrackSelectorResult, ImmutableList.of()).copyWithLoadingMediaPeriodId((MediaSource.MediaPeriodId)((Object)object));
                            ((PlaybackInfo)object).bufferedPositionUs = ((PlaybackInfo)object).positionUs;
                            return object;
                        }
                        object = playbackInfo.periodId.periodUid;
                        n2 = object.equals(Util.castNonNull(object3).first) ^ 1;
                        mediaPeriodId = n2 != 0 ? new MediaSource.MediaPeriodId(object3.first) : playbackInfo.periodId;
                        l2 = (Long)object3.second;
                        l3 = l4 = C.msToUs(this.getContentPosition());
                        if (!timeline.isEmpty()) {
                            l3 = l4 - timeline.getPeriodByUid(object, this.period).getPositionInWindowUs();
                        }
                        if (n2 != 0 || l2 < l3) break block5;
                        if (l2 != l3) break block6;
                        n2 = object2.getIndexOfPeriod(playbackInfo.loadingMediaPeriodId.periodUid);
                        if (n2 == -1) break block7;
                        object = playbackInfo;
                        if (object2.getPeriod((int)n2, (Timeline.Period)this.period).windowIndex == object2.getPeriodByUid((Object)mediaPeriodId.periodUid, (Timeline.Period)this.period).windowIndex) break block8;
                    }
                    object2.getPeriodByUid(mediaPeriodId.periodUid, this.period);
                    l3 = mediaPeriodId.isAd() ? this.period.getAdDurationUs(mediaPeriodId.adGroupIndex, mediaPeriodId.adIndexInAdGroup) : this.period.durationUs;
                    object = playbackInfo.copyWithNewPosition(mediaPeriodId, playbackInfo.positionUs, playbackInfo.positionUs, l3 - playbackInfo.positionUs, playbackInfo.trackGroups, playbackInfo.trackSelectorResult, playbackInfo.staticMetadata).copyWithLoadingMediaPeriodId(mediaPeriodId);
                    ((PlaybackInfo)object).bufferedPositionUs = l3;
                    break block8;
                }
                Assertions.checkState(mediaPeriodId.isAd() ^ true);
                l4 = Math.max(0L, playbackInfo.totalBufferedDurationUs - (l2 - l3));
                l3 = playbackInfo.bufferedPositionUs;
                if (playbackInfo.loadingMediaPeriodId.equals((Object)playbackInfo.periodId)) {
                    l3 = l2 + l4;
                }
                object = playbackInfo.copyWithNewPosition(mediaPeriodId, l2, l2, l4, playbackInfo.trackGroups, playbackInfo.trackSelectorResult, playbackInfo.staticMetadata);
                ((PlaybackInfo)object).bufferedPositionUs = l3;
                break block8;
            }
            Assertions.checkState(mediaPeriodId.isAd() ^ true);
            object = n2 != 0 ? TrackGroupArray.EMPTY : playbackInfo.trackGroups;
            object2 = n2 != 0 ? this.emptyTrackSelectorResult : playbackInfo.trackSelectorResult;
            object3 = n2 != 0 ? ImmutableList.of() : playbackInfo.staticMetadata;
            object = playbackInfo.copyWithNewPosition(mediaPeriodId, l2, l2, 0L, (TrackGroupArray)object, (TrackSelectorResult)object2, object3).copyWithLoadingMediaPeriodId(mediaPeriodId);
            ((PlaybackInfo)object).bufferedPositionUs = l2;
        }
        return object;
    }

    private long periodPositionUsToWindowPositionMs(MediaSource.MediaPeriodId mediaPeriodId, long l2) {
        l2 = C.usToMs(l2);
        this.playbackInfo.timeline.getPeriodByUid(mediaPeriodId.periodUid, this.period);
        return l2 + this.period.getPositionInWindowMs();
    }

    private PlaybackInfo removeMediaItemsInternal(int n2, int n3) {
        boolean bl = false;
        boolean bl2 = n2 >= 0 && n3 >= n2 && n3 <= this.mediaSourceHolderSnapshots.size();
        Assertions.checkArgument(bl2);
        int n4 = this.getCurrentWindowIndex();
        Timeline timeline = this.getCurrentTimeline();
        int n5 = this.mediaSourceHolderSnapshots.size();
        ++this.pendingOperationAcks;
        this.removeMediaSourceHolders(n2, n3);
        Timeline timeline2 = this.createMaskingTimeline();
        timeline2 = this.maskTimelineAndPosition(this.playbackInfo, timeline2, this.getPeriodPositionAfterTimelineChanged(timeline, timeline2));
        boolean bl3 = bl;
        if (timeline2.playbackState != 1) {
            bl3 = bl;
            if (timeline2.playbackState != 4) {
                bl3 = bl;
                if (n2 < n3) {
                    bl3 = bl;
                    if (n3 == n5) {
                        bl3 = bl;
                        if (n4 >= timeline2.timeline.getWindowCount()) {
                            bl3 = true;
                        }
                    }
                }
            }
        }
        timeline = timeline2;
        if (bl3) {
            timeline = timeline2.copyWithPlaybackState(4);
        }
        this.internalPlayer.removeMediaSources(n2, n3, this.shuffleOrder);
        return timeline;
    }

    private void removeMediaSourceHolders(int n2, int n3) {
        for (int i2 = n3 - 1; i2 >= n2; --i2) {
            this.mediaSourceHolderSnapshots.remove(i2);
        }
        this.shuffleOrder = this.shuffleOrder.cloneAndRemove(n2, n3);
    }

    /*
     * Unable to fully structure code
     */
    private void setMediaSourcesInternal(List<MediaSource> var1_1, int var2_2, long var3_3, boolean var5_4) {
        block6: {
            var6_5 = this.getCurrentWindowIndexInternal();
            var7_6 = this.getCurrentPosition();
            ++this.pendingOperationAcks;
            if (!this.mediaSourceHolderSnapshots.isEmpty()) {
                this.removeMediaSourceHolders(0, this.mediaSourceHolderSnapshots.size());
            }
            var1_1 = this.addMediaSourceHolders(0, var1_1);
            var9_7 = this.createMaskingTimeline();
            if (!var9_7.isEmpty() && var2_2 >= var9_7.getWindowCount()) {
                throw new IllegalSeekPositionException(var9_7, var2_2, var3_3);
            }
            if (!var5_4) break block6;
            var2_2 = var9_7.getFirstWindowIndex(this.shuffleModeEnabled);
            var3_3 = -9223372036854775807L;
            ** GOTO lbl-1000
        }
        if (var2_2 == -1) {
            var3_3 = var7_6;
        } else lbl-1000:
        // 2 sources

        {
            var6_5 = var2_2;
        }
        var10_8 = this.maskTimelineAndPosition(this.playbackInfo, var9_7, this.getPeriodPositionOrMaskWindowPosition(var9_7, var6_5, var3_3));
        var2_2 = var11_9 = var10_8.playbackState;
        if (var6_5 != -1) {
            var2_2 = var11_9;
            if (var10_8.playbackState != 1) {
                var2_2 = !var9_7.isEmpty() && var6_5 < var9_7.getWindowCount() ? 2 : 4;
            }
        }
        var10_8 = var10_8.copyWithPlaybackState(var2_2);
        this.internalPlayer.setMediaSources(var1_1, var6_5, C.msToUs(var3_3), this.shuffleOrder);
        this.updatePlaybackInfo(var10_8, false, 4, 0, 1, false);
    }

    private void updatePlaybackInfo(PlaybackInfo playbackInfo, boolean bl, int n2, int n3, int n4, boolean bl2) {
        PlaybackInfo playbackInfo2 = this.playbackInfo;
        this.playbackInfo = playbackInfo;
        MediaItem mediaItem = this.evaluateMediaItemTransitionReason(playbackInfo, playbackInfo2, bl, n2, playbackInfo2.timeline.equals((Object)playbackInfo.timeline) ^ true);
        boolean bl3 = (Boolean)mediaItem.first;
        int n5 = (Integer)mediaItem.second;
        if (!playbackInfo2.timeline.equals((Object)playbackInfo.timeline)) {
            this.listeners.queueEvent(0, (ListenerSet.Event<Player.EventListener>)new _$.Lambda.ExoPlayerImpl.Rsz3_djzrfONV5NQsPf2U0_Oc_U(playbackInfo, n3));
        }
        if (bl) {
            this.listeners.queueEvent(12, (ListenerSet.Event<Player.EventListener>)new _$.Lambda.ExoPlayerImpl.ggx54Bdp_yzeftpxPbgsKIg0T_k(n2));
        }
        if (bl3) {
            if (!playbackInfo.timeline.isEmpty()) {
                n2 = playbackInfo.timeline.getPeriodByUid((Object)playbackInfo.periodId.periodUid, (Timeline.Period)this.period).windowIndex;
                mediaItem = playbackInfo.timeline.getWindow((int)n2, (Timeline.Window)this.window).mediaItem;
            } else {
                mediaItem = null;
            }
            this.listeners.queueEvent(1, (ListenerSet.Event<Player.EventListener>)new _$.Lambda.ExoPlayerImpl.DPfsYjtVpc2LbTZ1ZiMKWJqQ3xw(mediaItem, n5));
        }
        if (playbackInfo2.playbackError != playbackInfo.playbackError && playbackInfo.playbackError != null) {
            this.listeners.queueEvent(11, (ListenerSet.Event<Player.EventListener>)new _$.Lambda.ExoPlayerImpl.7sQYjfI6gTfVEIXqlXObYmJn2vs(playbackInfo));
        }
        if (playbackInfo2.trackSelectorResult != playbackInfo.trackSelectorResult) {
            this.trackSelector.onSelectionActivated(playbackInfo.trackSelectorResult.info);
            mediaItem = new TrackSelectionArray((TrackSelection[])playbackInfo.trackSelectorResult.selections);
            this.listeners.queueEvent(2, (ListenerSet.Event<Player.EventListener>)new _$.Lambda.ExoPlayerImpl.MWPfkRxfsX1T_haneG3bm1rUlk0(playbackInfo, (TrackSelectionArray)mediaItem));
        }
        if (!playbackInfo2.staticMetadata.equals(playbackInfo.staticMetadata)) {
            this.listeners.queueEvent(3, (ListenerSet.Event<Player.EventListener>)new _$.Lambda.ExoPlayerImpl.MMT3X5PIWIvnqyDiXcHBD9t0srE(playbackInfo));
        }
        if (playbackInfo2.isLoading != playbackInfo.isLoading) {
            this.listeners.queueEvent(4, (ListenerSet.Event<Player.EventListener>)new _$.Lambda.ExoPlayerImpl.tnkjWsBTPFSO1eDTaYW2jrCtvCs(playbackInfo));
        }
        if (playbackInfo2.playbackState != playbackInfo.playbackState || playbackInfo2.playWhenReady != playbackInfo.playWhenReady) {
            this.listeners.queueEvent(-1, new _$$Lambda$ExoPlayerImpl$DwHo3cPyQejUhkqC0MASbmmErYM(playbackInfo));
        }
        if (playbackInfo2.playbackState != playbackInfo.playbackState) {
            this.listeners.queueEvent(5, (ListenerSet.Event<Player.EventListener>)new _$.Lambda.ExoPlayerImpl.3ZSjpnxjcwRMnBSrB8LfP9YjCgg(playbackInfo));
        }
        if (playbackInfo2.playWhenReady != playbackInfo.playWhenReady) {
            this.listeners.queueEvent(6, (ListenerSet.Event<Player.EventListener>)new _$.Lambda.ExoPlayerImpl.TMFMGU2gqeJmHrS1Fmi2GGbSL0w(playbackInfo, n4));
        }
        if (playbackInfo2.playbackSuppressionReason != playbackInfo.playbackSuppressionReason) {
            this.listeners.queueEvent(7, (ListenerSet.Event<Player.EventListener>)new _$.Lambda.ExoPlayerImpl.WfE0OgNLJ_vQjUEnmMsYu99I7Jw(playbackInfo));
        }
        if (ExoPlayerImpl.isPlaying(playbackInfo2) != ExoPlayerImpl.isPlaying(playbackInfo)) {
            this.listeners.queueEvent(8, (ListenerSet.Event<Player.EventListener>)new _$.Lambda.ExoPlayerImpl.Uw_kOuMm_rx__rRMC5eTKSPSGGA(playbackInfo));
        }
        if (!playbackInfo2.playbackParameters.equals((Object)playbackInfo.playbackParameters)) {
            this.listeners.queueEvent(13, (ListenerSet.Event<Player.EventListener>)new _$.Lambda.ExoPlayerImpl.C6zU65w6ZdRSSe1AHen_aZSNfX4(playbackInfo));
        }
        if (bl2) {
            this.listeners.queueEvent(-1, (ListenerSet.Event<Player.EventListener>)_$$Lambda$IvHsGgCxoxdxsyZUtt2N2KRx2jA.INSTANCE);
        }
        if (playbackInfo2.offloadSchedulingEnabled != playbackInfo.offloadSchedulingEnabled) {
            this.listeners.queueEvent(-1, new _$$Lambda$ExoPlayerImpl$tbxoDd63J_d2elNmBCgHBU94Y9Q(playbackInfo));
        }
        if (playbackInfo2.sleepingForOffload != playbackInfo.sleepingForOffload) {
            this.listeners.queueEvent(-1, (ListenerSet.Event<Player.EventListener>)new _$.Lambda.ExoPlayerImpl.dhC0uq3ETvazi4YYOGHdFy04Qm0(playbackInfo));
        }
        this.listeners.flushEvents();
    }

    public void addListener(Player.EventListener eventListener) {
        this.listeners.add(eventListener);
    }

    public void addMediaItems(int n2, List<MediaItem> list) {
        this.addMediaSources(n2, this.createMediaSources(list));
    }

    public void addMediaItems(List<MediaItem> list) {
        this.addMediaItems(this.mediaSourceHolderSnapshots.size(), list);
    }

    public void addMediaSource(int n2, MediaSource mediaSource) {
        this.addMediaSources(n2, Collections.singletonList(mediaSource));
    }

    public void addMediaSource(MediaSource mediaSource) {
        this.addMediaSources(Collections.singletonList(mediaSource));
    }

    public void addMediaSources(int n2, List<MediaSource> list) {
        boolean bl = n2 >= 0;
        Assertions.checkArgument(bl);
        Timeline timeline = this.getCurrentTimeline();
        ++this.pendingOperationAcks;
        list = this.addMediaSourceHolders(n2, list);
        Timeline timeline2 = this.createMaskingTimeline();
        timeline = this.maskTimelineAndPosition(this.playbackInfo, timeline2, this.getPeriodPositionAfterTimelineChanged(timeline, timeline2));
        this.internalPlayer.addMediaSources(n2, list, this.shuffleOrder);
        this.updatePlaybackInfo((PlaybackInfo)timeline, false, 4, 0, 1, false);
    }

    public void addMediaSources(List<MediaSource> list) {
        this.addMediaSources(this.mediaSourceHolderSnapshots.size(), list);
    }

    public void clearMediaItems() {
        this.removeMediaItems(0, this.mediaSourceHolderSnapshots.size());
    }

    public PlayerMessage createMessage(PlayerMessage.Target target) {
        return new PlayerMessage(this.internalPlayer, target, this.playbackInfo.timeline, this.getCurrentWindowIndex(), this.clock, this.internalPlayer.getPlaybackLooper());
    }

    public boolean experimentalIsSleepingForOffload() {
        return this.playbackInfo.sleepingForOffload;
    }

    public void experimentalSetForegroundModeTimeoutMs(long l2) {
        this.internalPlayer.experimentalSetForegroundModeTimeoutMs(l2);
    }

    public void experimentalSetOffloadSchedulingEnabled(boolean bl) {
        this.internalPlayer.experimentalSetOffloadSchedulingEnabled(bl);
    }

    public Looper getApplicationLooper() {
        return this.applicationLooper;
    }

    public Player.AudioComponent getAudioComponent() {
        return null;
    }

    public long getBufferedPosition() {
        if (this.isPlayingAd()) {
            long l2 = this.playbackInfo.loadingMediaPeriodId.equals((Object)this.playbackInfo.periodId) ? C.usToMs(this.playbackInfo.bufferedPositionUs) : this.getDuration();
            return l2;
        }
        return this.getContentBufferedPosition();
    }

    public Clock getClock() {
        return this.clock;
    }

    public long getContentBufferedPosition() {
        long l2;
        block2: {
            Timeline.Period period;
            if (this.playbackInfo.timeline.isEmpty()) {
                return this.maskingWindowPositionMs;
            }
            if (this.playbackInfo.loadingMediaPeriodId.windowSequenceNumber != this.playbackInfo.periodId.windowSequenceNumber) {
                return this.playbackInfo.timeline.getWindow(this.getCurrentWindowIndex(), this.window).getDurationMs();
            }
            l2 = this.playbackInfo.bufferedPositionUs;
            if (!this.playbackInfo.loadingMediaPeriodId.isAd() || (l2 = (period = this.playbackInfo.timeline.getPeriodByUid(this.playbackInfo.loadingMediaPeriodId.periodUid, this.period)).getAdGroupTimeUs(this.playbackInfo.loadingMediaPeriodId.adGroupIndex)) != Long.MIN_VALUE) break block2;
            l2 = period.durationUs;
        }
        return this.periodPositionUsToWindowPositionMs(this.playbackInfo.loadingMediaPeriodId, l2);
    }

    public long getContentPosition() {
        if (this.isPlayingAd()) {
            this.playbackInfo.timeline.getPeriodByUid(this.playbackInfo.periodId.periodUid, this.period);
            long l2 = this.playbackInfo.requestedContentPositionUs == -9223372036854775807L ? this.playbackInfo.timeline.getWindow(this.getCurrentWindowIndex(), this.window).getDefaultPositionMs() : this.period.getPositionInWindowMs() + C.usToMs(this.playbackInfo.requestedContentPositionUs);
            return l2;
        }
        return this.getCurrentPosition();
    }

    public int getCurrentAdGroupIndex() {
        int n2 = this.isPlayingAd() ? this.playbackInfo.periodId.adGroupIndex : -1;
        return n2;
    }

    public int getCurrentAdIndexInAdGroup() {
        int n2 = this.isPlayingAd() ? this.playbackInfo.periodId.adIndexInAdGroup : -1;
        return n2;
    }

    public int getCurrentPeriodIndex() {
        if (this.playbackInfo.timeline.isEmpty()) {
            return this.maskingPeriodIndex;
        }
        return this.playbackInfo.timeline.getIndexOfPeriod(this.playbackInfo.periodId.periodUid);
    }

    public long getCurrentPosition() {
        if (this.playbackInfo.timeline.isEmpty()) {
            return this.maskingWindowPositionMs;
        }
        if (this.playbackInfo.periodId.isAd()) {
            return C.usToMs(this.playbackInfo.positionUs);
        }
        return this.periodPositionUsToWindowPositionMs(this.playbackInfo.periodId, this.playbackInfo.positionUs);
    }

    public List<Metadata> getCurrentStaticMetadata() {
        return this.playbackInfo.staticMetadata;
    }

    public Timeline getCurrentTimeline() {
        return this.playbackInfo.timeline;
    }

    public TrackGroupArray getCurrentTrackGroups() {
        return this.playbackInfo.trackGroups;
    }

    public TrackSelectionArray getCurrentTrackSelections() {
        return new TrackSelectionArray((TrackSelection[])this.playbackInfo.trackSelectorResult.selections);
    }

    public int getCurrentWindowIndex() {
        int n2;
        int n3 = n2 = this.getCurrentWindowIndexInternal();
        if (n2 == -1) {
            n3 = 0;
        }
        return n3;
    }

    public Player.DeviceComponent getDeviceComponent() {
        return null;
    }

    public long getDuration() {
        if (this.isPlayingAd()) {
            MediaSource.MediaPeriodId mediaPeriodId = this.playbackInfo.periodId;
            this.playbackInfo.timeline.getPeriodByUid(mediaPeriodId.periodUid, this.period);
            return C.usToMs(this.period.getAdDurationUs(mediaPeriodId.adGroupIndex, mediaPeriodId.adIndexInAdGroup));
        }
        return this.getContentDuration();
    }

    public Player.MetadataComponent getMetadataComponent() {
        return null;
    }

    public boolean getPauseAtEndOfMediaItems() {
        return this.pauseAtEndOfMediaItems;
    }

    public boolean getPlayWhenReady() {
        return this.playbackInfo.playWhenReady;
    }

    @Deprecated
    public ExoPlaybackException getPlaybackError() {
        return this.getPlayerError();
    }

    public Looper getPlaybackLooper() {
        return this.internalPlayer.getPlaybackLooper();
    }

    public PlaybackParameters getPlaybackParameters() {
        return this.playbackInfo.playbackParameters;
    }

    public int getPlaybackState() {
        return this.playbackInfo.playbackState;
    }

    public int getPlaybackSuppressionReason() {
        return this.playbackInfo.playbackSuppressionReason;
    }

    public ExoPlaybackException getPlayerError() {
        return this.playbackInfo.playbackError;
    }

    public int getRendererCount() {
        return this.renderers.length;
    }

    public int getRendererType(int n2) {
        return this.renderers[n2].getTrackType();
    }

    public int getRepeatMode() {
        return this.repeatMode;
    }

    public SeekParameters getSeekParameters() {
        return this.seekParameters;
    }

    public boolean getShuffleModeEnabled() {
        return this.shuffleModeEnabled;
    }

    public Player.TextComponent getTextComponent() {
        return null;
    }

    public long getTotalBufferedDuration() {
        return C.usToMs(this.playbackInfo.totalBufferedDurationUs);
    }

    public TrackSelector getTrackSelector() {
        return this.trackSelector;
    }

    public Player.VideoComponent getVideoComponent() {
        return null;
    }

    public boolean isLoading() {
        return this.playbackInfo.isLoading;
    }

    public boolean isPlayingAd() {
        return this.playbackInfo.periodId.isAd();
    }

    public /* synthetic */ void lambda$new$1$ExoPlayerImpl(ExoPlayerImplInternal.PlaybackInfoUpdate playbackInfoUpdate) {
        this.handlePlaybackInfo(playbackInfoUpdate);
    }

    public /* synthetic */ void lambda$new$2$ExoPlayerImpl(ExoPlayerImplInternal.PlaybackInfoUpdate playbackInfoUpdate) {
        this.playbackInfoUpdateHandler.post((Runnable)new _$.Lambda.ExoPlayerImpl.xL_pNUtK4Xd_OJz6IZrFDS_CYOg(this, playbackInfoUpdate));
    }

    public void moveMediaItems(int n2, int n3, int n4) {
        boolean bl = n2 >= 0 && n2 <= n3 && n3 <= this.mediaSourceHolderSnapshots.size() && n4 >= 0;
        Assertions.checkArgument(bl);
        Timeline timeline = this.getCurrentTimeline();
        ++this.pendingOperationAcks;
        n4 = Math.min(n4, this.mediaSourceHolderSnapshots.size() - (n3 - n2));
        Util.moveItems(this.mediaSourceHolderSnapshots, n2, n3, n4);
        Timeline timeline2 = this.createMaskingTimeline();
        timeline2 = this.maskTimelineAndPosition(this.playbackInfo, timeline2, this.getPeriodPositionAfterTimelineChanged(timeline, timeline2));
        this.internalPlayer.moveMediaSources(n2, n3, n4, this.shuffleOrder);
        this.updatePlaybackInfo((PlaybackInfo)timeline2, false, 4, 0, 1, false);
    }

    public void prepare() {
        if (this.playbackInfo.playbackState != 1) {
            return;
        }
        PlaybackInfo playbackInfo = this.playbackInfo.copyWithPlaybackError(null);
        int n2 = playbackInfo.timeline.isEmpty() ? 4 : 2;
        playbackInfo = playbackInfo.copyWithPlaybackState(n2);
        ++this.pendingOperationAcks;
        this.internalPlayer.prepare();
        this.updatePlaybackInfo(playbackInfo, false, 4, 1, 1, false);
    }

    @Deprecated
    public void prepare(MediaSource mediaSource) {
        this.setMediaSource(mediaSource);
        this.prepare();
    }

    @Deprecated
    public void prepare(MediaSource mediaSource, boolean bl, boolean bl2) {
        this.setMediaSource(mediaSource, bl);
        this.prepare();
    }

    public void release() {
        Object object = new StringBuilder();
        ((StringBuilder)object).append("Release ");
        ((StringBuilder)object).append(Integer.toHexString(System.identityHashCode((Object)this)));
        ((StringBuilder)object).append(" [");
        ((StringBuilder)object).append("ExoPlayerLib/2.13.3");
        ((StringBuilder)object).append("] [");
        ((StringBuilder)object).append(Util.DEVICE_DEBUG_INFO);
        ((StringBuilder)object).append("] [");
        ((StringBuilder)object).append(ExoPlayerLibraryInfo.registeredModules());
        ((StringBuilder)object).append("]");
        Log.i(TAG, ((StringBuilder)object).toString());
        if (!this.internalPlayer.release()) {
            this.listeners.sendEvent(11, (ListenerSet.Event<Player.EventListener>)_$.Lambda.ExoPlayerImpl.KOvTAObvT_F_h8dMHR1N2O8QgrE.INSTANCE);
        }
        this.listeners.release();
        this.playbackInfoUpdateHandler.removeCallbacksAndMessages(null);
        object = this.analyticsCollector;
        if (object != null) {
            this.bandwidthMeter.removeEventListener((BandwidthMeter.EventListener)object);
        }
        this.playbackInfo = this.playbackInfo.copyWithPlaybackState(1);
        object = this.playbackInfo;
        this.playbackInfo = object.copyWithLoadingMediaPeriodId(((PlaybackInfo)object).periodId);
        object = this.playbackInfo;
        ((PlaybackInfo)object).bufferedPositionUs = ((PlaybackInfo)object).positionUs;
        this.playbackInfo.totalBufferedDurationUs = 0L;
    }

    public void removeListener(Player.EventListener eventListener) {
        this.listeners.remove(eventListener);
    }

    public void removeMediaItems(int n2, int n3) {
        this.updatePlaybackInfo(this.removeMediaItemsInternal(n2, n3), false, 4, 0, 1, false);
    }

    @Deprecated
    public void retry() {
        this.prepare();
    }

    public void seekTo(int n2, long l2) {
        Object object = this.playbackInfo.timeline;
        if (n2 >= 0 && (object.isEmpty() || n2 < object.getWindowCount())) {
            int n3 = this.pendingOperationAcks;
            int n4 = 1;
            this.pendingOperationAcks = n3 + 1;
            if (this.isPlayingAd()) {
                Log.w(TAG, "seekTo ignored because an ad is playing");
                object = new ExoPlayerImplInternal.PlaybackInfoUpdate(this.playbackInfo);
                ((ExoPlayerImplInternal.PlaybackInfoUpdate)object).incrementPendingOperationAcks(1);
                this.playbackInfoUpdateListener.onPlaybackInfoUpdate((ExoPlayerImplInternal.PlaybackInfoUpdate)object);
                return;
            }
            if (this.getPlaybackState() != 1) {
                n4 = 2;
            }
            PlaybackInfo playbackInfo = this.maskTimelineAndPosition(this.playbackInfo.copyWithPlaybackState(n4), (Timeline)object, this.getPeriodPositionOrMaskWindowPosition((Timeline)object, n2, l2));
            this.internalPlayer.seekTo((Timeline)object, n2, C.msToUs(l2));
            this.updatePlaybackInfo(playbackInfo, true, 1, 0, 1, true);
            return;
        }
        throw new IllegalSeekPositionException((Timeline)object, n2, l2);
    }

    public void setForegroundMode(boolean bl) {
        if (this.foregroundMode != bl) {
            this.foregroundMode = bl;
            if (!this.internalPlayer.setForegroundMode(bl)) {
                this.stop(false, ExoPlaybackException.createForRenderer(new ExoTimeoutException(2)));
            }
        }
    }

    public void setMediaItems(List<MediaItem> list, int n2, long l2) {
        this.setMediaSources(this.createMediaSources(list), n2, l2);
    }

    public void setMediaItems(List<MediaItem> list, boolean bl) {
        this.setMediaSources(this.createMediaSources(list), bl);
    }

    public void setMediaSource(MediaSource mediaSource) {
        this.setMediaSources(Collections.singletonList(mediaSource));
    }

    public void setMediaSource(MediaSource mediaSource, long l2) {
        this.setMediaSources(Collections.singletonList(mediaSource), 0, l2);
    }

    public void setMediaSource(MediaSource mediaSource, boolean bl) {
        this.setMediaSources(Collections.singletonList(mediaSource), bl);
    }

    public void setMediaSources(List<MediaSource> list) {
        this.setMediaSources(list, true);
    }

    public void setMediaSources(List<MediaSource> list, int n2, long l2) {
        this.setMediaSourcesInternal(list, n2, l2, false);
    }

    public void setMediaSources(List<MediaSource> list, boolean bl) {
        this.setMediaSourcesInternal(list, -1, -9223372036854775807L, bl);
    }

    public void setPauseAtEndOfMediaItems(boolean bl) {
        if (this.pauseAtEndOfMediaItems == bl) {
            return;
        }
        this.pauseAtEndOfMediaItems = bl;
        this.internalPlayer.setPauseAtEndOfWindow(bl);
    }

    public void setPlayWhenReady(boolean bl) {
        this.setPlayWhenReady(bl, 0, 1);
    }

    public void setPlayWhenReady(boolean bl, int n2, int n3) {
        if (this.playbackInfo.playWhenReady == bl && this.playbackInfo.playbackSuppressionReason == n2) {
            return;
        }
        ++this.pendingOperationAcks;
        PlaybackInfo playbackInfo = this.playbackInfo.copyWithPlayWhenReady(bl, n2);
        this.internalPlayer.setPlayWhenReady(bl, n2);
        this.updatePlaybackInfo(playbackInfo, false, 4, 0, n3, false);
    }

    public void setPlaybackParameters(PlaybackParameters playbackParameters) {
        PlaybackParameters playbackParameters2 = playbackParameters;
        if (playbackParameters == null) {
            playbackParameters2 = PlaybackParameters.DEFAULT;
        }
        if (this.playbackInfo.playbackParameters.equals((Object)playbackParameters2)) {
            return;
        }
        playbackParameters = this.playbackInfo.copyWithPlaybackParameters(playbackParameters2);
        ++this.pendingOperationAcks;
        this.internalPlayer.setPlaybackParameters(playbackParameters2);
        this.updatePlaybackInfo((PlaybackInfo)playbackParameters, false, 4, 0, 1, false);
    }

    public void setRepeatMode(int n2) {
        if (this.repeatMode != n2) {
            this.repeatMode = n2;
            this.internalPlayer.setRepeatMode(n2);
            this.listeners.sendEvent(9, (ListenerSet.Event<Player.EventListener>)new _$.Lambda.ExoPlayerImpl.VV8mgR6tPAf8Q3yzu6EecWP3NG0(n2));
        }
    }

    public void setSeekParameters(SeekParameters seekParameters) {
        SeekParameters seekParameters2 = seekParameters;
        if (seekParameters == null) {
            seekParameters2 = SeekParameters.DEFAULT;
        }
        if (!this.seekParameters.equals((Object)seekParameters2)) {
            this.seekParameters = seekParameters2;
            this.internalPlayer.setSeekParameters(seekParameters2);
        }
    }

    public void setShuffleModeEnabled(boolean bl) {
        if (this.shuffleModeEnabled != bl) {
            this.shuffleModeEnabled = bl;
            this.internalPlayer.setShuffleModeEnabled(bl);
            this.listeners.sendEvent(10, (ListenerSet.Event<Player.EventListener>)new _$.Lambda.ExoPlayerImpl.dAYYl_I0JufiocYEHBCHCLewhC4(bl));
        }
    }

    public void setShuffleOrder(ShuffleOrder shuffleOrder) {
        Timeline timeline = this.createMaskingTimeline();
        timeline = this.maskTimelineAndPosition(this.playbackInfo, timeline, this.getPeriodPositionOrMaskWindowPosition(timeline, this.getCurrentWindowIndex(), this.getCurrentPosition()));
        ++this.pendingOperationAcks;
        this.shuffleOrder = shuffleOrder;
        this.internalPlayer.setShuffleOrder(shuffleOrder);
        this.updatePlaybackInfo((PlaybackInfo)timeline, false, 4, 0, 1, false);
    }

    public void stop(boolean bl) {
        this.stop(bl, null);
    }

    public void stop(boolean bl, ExoPlaybackException exoPlaybackException) {
        PlaybackInfo playbackInfo;
        PlaybackInfo playbackInfo2;
        if (bl) {
            playbackInfo2 = this.removeMediaItemsInternal(0, this.mediaSourceHolderSnapshots.size()).copyWithPlaybackError(null);
        } else {
            playbackInfo2 = this.playbackInfo;
            playbackInfo2 = playbackInfo2.copyWithLoadingMediaPeriodId(playbackInfo2.periodId);
            playbackInfo2.bufferedPositionUs = playbackInfo2.positionUs;
            playbackInfo2.totalBufferedDurationUs = 0L;
        }
        playbackInfo2 = playbackInfo = playbackInfo2.copyWithPlaybackState(1);
        if (exoPlaybackException != null) {
            playbackInfo2 = playbackInfo.copyWithPlaybackError(exoPlaybackException);
        }
        ++this.pendingOperationAcks;
        this.internalPlayer.stop();
        this.updatePlaybackInfo(playbackInfo2, false, 4, 0, 1, false);
    }

    private static final class MediaSourceHolderSnapshot
    implements MediaSourceInfoHolder {
        private Timeline timeline;
        private final Object uid;

        public MediaSourceHolderSnapshot(Object object, Timeline timeline) {
            this.uid = object;
            this.timeline = timeline;
        }

        static /* synthetic */ Timeline access$002(MediaSourceHolderSnapshot mediaSourceHolderSnapshot, Timeline timeline) {
            mediaSourceHolderSnapshot.timeline = timeline;
            return timeline;
        }

        public Timeline getTimeline() {
            return this.timeline;
        }

        public Object getUid() {
            return this.uid;
        }
    }
}

