/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2;

import android.os.SystemClock;
import android.text.TextUtils;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.source.MediaPeriodId;
import com.google.android.exoplayer2.util.Assertions;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class ExoPlaybackException
extends Exception {
    public static final int TYPE_REMOTE = 3;
    public static final int TYPE_RENDERER = 1;
    public static final int TYPE_SOURCE = 0;
    public static final int TYPE_UNEXPECTED = 2;
    private final Throwable cause;
    final boolean isRecoverable;
    public final MediaPeriodId mediaPeriodId;
    public final Format rendererFormat;
    public final int rendererFormatSupport;
    public final int rendererIndex;
    public final String rendererName;
    public final long timestampMs;
    public final int type;

    private ExoPlaybackException(int n2, String string2) {
        this(n2, null, string2, null, -1, null, 4, false);
    }

    private ExoPlaybackException(int n2, Throwable throwable) {
        this(n2, throwable, null, null, -1, null, 4, false);
    }

    private ExoPlaybackException(int n2, Throwable throwable, String string2, String string3, int n3, Format format, int n4, boolean bl) {
        this(ExoPlaybackException.deriveMessage(n2, string2, string3, n3, format, n4), throwable, n2, string3, n3, format, n4, null, SystemClock.elapsedRealtime(), bl);
    }

    private ExoPlaybackException(String string2, Throwable throwable, int n2, String string3, int n3, Format format, int n4, MediaPeriodId mediaPeriodId, long l2, boolean bl) {
        super(string2, throwable);
        this.type = n2;
        this.cause = throwable;
        this.rendererName = string3;
        this.rendererIndex = n3;
        this.rendererFormat = format;
        this.rendererFormatSupport = n4;
        this.mediaPeriodId = mediaPeriodId;
        this.timestampMs = l2;
        this.isRecoverable = bl;
    }

    public static ExoPlaybackException createForRemote(String string2) {
        return new ExoPlaybackException(3, string2);
    }

    public static ExoPlaybackException createForRenderer(Exception exception) {
        return new ExoPlaybackException(1, exception, null, null, -1, null, 4, false);
    }

    public static ExoPlaybackException createForRenderer(Throwable throwable, String string2, int n2, Format format, int n3) {
        return ExoPlaybackException.createForRenderer(throwable, string2, n2, format, n3, false);
    }

    public static ExoPlaybackException createForRenderer(Throwable throwable, String string2, int n2, Format format, int n3, boolean bl) {
        if (format == null) {
            n3 = 4;
        }
        return new ExoPlaybackException(1, throwable, null, string2, n2, format, n3, bl);
    }

    public static ExoPlaybackException createForSource(IOException iOException) {
        return new ExoPlaybackException(0, (Throwable)iOException);
    }

    public static ExoPlaybackException createForUnexpected(RuntimeException runtimeException) {
        return new ExoPlaybackException(2, (Throwable)runtimeException);
    }

    private static String deriveMessage(int n2, String string2, String string3, int n3, Format object, int n4) {
        if (n2 != 0) {
            if (n2 != 1) {
                string3 = n2 != 3 ? "Unexpected runtime error" : "Remote error";
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(string3);
                stringBuilder.append(" error, index=");
                stringBuilder.append(n3);
                stringBuilder.append(", format=");
                stringBuilder.append(object);
                stringBuilder.append(", format_supported=");
                stringBuilder.append(C.getFormatSupportString(n4));
                string3 = stringBuilder.toString();
            }
        } else {
            string3 = "Source error";
        }
        object = string3;
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            object = new StringBuilder();
            ((StringBuilder)object).append(string3);
            ((StringBuilder)object).append(": ");
            ((StringBuilder)object).append(string2);
            object = ((StringBuilder)object).toString();
        }
        return object;
    }

    ExoPlaybackException copyWithMediaPeriodId(MediaPeriodId mediaPeriodId) {
        return new ExoPlaybackException(this.getMessage(), this.cause, this.type, this.rendererName, this.rendererIndex, this.rendererFormat, this.rendererFormatSupport, mediaPeriodId, this.timestampMs, this.isRecoverable);
    }

    public Exception getRendererException() {
        int n2 = this.type;
        boolean bl = true;
        if (n2 != 1) {
            bl = false;
        }
        Assertions.checkState(bl);
        return (Exception)Assertions.checkNotNull(this.cause);
    }

    public IOException getSourceException() {
        boolean bl = this.type == 0;
        Assertions.checkState(bl);
        return (IOException)Assertions.checkNotNull(this.cause);
    }

    public RuntimeException getUnexpectedException() {
        boolean bl = this.type == 2;
        Assertions.checkState(bl);
        return (RuntimeException)Assertions.checkNotNull(this.cause);
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Type {
    }
}

