/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.google.android.exoplayer2.Renderer;
import com.google.android.exoplayer2.RenderersFactory;
import com.google.android.exoplayer2.audio.AudioCapabilities;
import com.google.android.exoplayer2.audio.AudioProcessor;
import com.google.android.exoplayer2.audio.AudioRendererEventListener;
import com.google.android.exoplayer2.audio.AudioSink;
import com.google.android.exoplayer2.audio.DefaultAudioSink;
import com.google.android.exoplayer2.audio.MediaCodecAudioRenderer;
import com.google.android.exoplayer2.mediacodec.MediaCodecSelector;
import com.google.android.exoplayer2.metadata.MetadataOutput;
import com.google.android.exoplayer2.metadata.MetadataRenderer;
import com.google.android.exoplayer2.text.TextOutput;
import com.google.android.exoplayer2.text.TextRenderer;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.video.MediaCodecVideoRenderer;
import com.google.android.exoplayer2.video.VideoRendererEventListener;
import com.google.android.exoplayer2.video.spherical.CameraMotionRenderer;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;

public class DefaultRenderersFactory
implements RenderersFactory {
    public static final long DEFAULT_ALLOWED_VIDEO_JOINING_TIME_MS = 5000L;
    public static final int EXTENSION_RENDERER_MODE_OFF = 0;
    public static final int EXTENSION_RENDERER_MODE_ON = 1;
    public static final int EXTENSION_RENDERER_MODE_PREFER = 2;
    public static final int MAX_DROPPED_VIDEO_FRAME_COUNT_TO_NOTIFY = 50;
    private static final String TAG = "DefaultRenderersFactory";
    private long allowedVideoJoiningTimeMs;
    private final Context context;
    private boolean enableAsyncQueueing;
    private boolean enableAudioTrackPlaybackParams;
    private boolean enableDecoderFallback;
    private boolean enableFloatOutput;
    private boolean enableOffload;
    private boolean enableSynchronizeCodecInteractionsWithQueueing;
    private int extensionRendererMode;
    private boolean forceAsyncQueueingSynchronizationWorkaround;
    private MediaCodecSelector mediaCodecSelector;

    public DefaultRenderersFactory(Context context) {
        this.context = context;
        this.extensionRendererMode = 0;
        this.allowedVideoJoiningTimeMs = 5000L;
        this.mediaCodecSelector = MediaCodecSelector.DEFAULT;
    }

    @Deprecated
    public DefaultRenderersFactory(Context context, int n2) {
        this(context, n2, 5000L);
    }

    @Deprecated
    public DefaultRenderersFactory(Context context, int n2, long l2) {
        this.context = context;
        this.extensionRendererMode = n2;
        this.allowedVideoJoiningTimeMs = l2;
        this.mediaCodecSelector = MediaCodecSelector.DEFAULT;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void buildAudioRenderers(Context object, int n2, MediaCodecSelector mediaCodecSelector, boolean bl, AudioSink audioSink, Handler handler, AudioRendererEventListener audioRendererEventListener, ArrayList<Renderer> arrayList) {
        int n3;
        void var8_21;
        void var5_18;
        void var7_20;
        void var6_19;
        block18: {
            int n4;
            block17: {
                int n5;
                void var4_17;
                void var3_16;
                MediaCodecAudioRenderer mediaCodecAudioRenderer = new MediaCodecAudioRenderer(object, (MediaCodecSelector)var3_16, (boolean)var4_17, (Handler)var6_19, (AudioRendererEventListener)var7_20, (AudioSink)var5_18);
                mediaCodecAudioRenderer.experimentalSetAsynchronousBufferQueueingEnabled(this.enableAsyncQueueing);
                mediaCodecAudioRenderer.experimentalSetForceAsyncQueueingSynchronizationWorkaround(this.forceAsyncQueueingSynchronizationWorkaround);
                mediaCodecAudioRenderer.experimentalSetSynchronizeCodecInteractionsWithQueueingEnabled(this.enableSynchronizeCodecInteractionsWithQueueing);
                var8_21.add(mediaCodecAudioRenderer);
                if (n3 == 0) {
                    return;
                }
                n4 = n5 = var8_21.size();
                if (n3 == 2) {
                    n4 = n5 - 1;
                }
                try {
                    Renderer renderer;
                    try {
                        renderer = (Renderer)Class.forName("com.google.android.exoplayer2.ext.opus.LibopusAudioRenderer").getConstructor(Handler.class, AudioRendererEventListener.class, AudioSink.class).newInstance(var6_19, var7_20, var5_18);
                        n3 = n4 + 1;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        n3 = n4;
                        break block17;
                    }
                    try {}
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    var8_21.add(n4, renderer);
                    Log.i(TAG, "Loaded LibopusAudioRenderer.");
                }
                catch (Exception exception) {
                    throw new RuntimeException("Error instantiating Opus extension", exception);
                }
            }
            try {
                Renderer renderer;
                try {
                    renderer = (Renderer)Class.forName("com.google.android.exoplayer2.ext.flac.LibflacAudioRenderer").getConstructor(Handler.class, AudioRendererEventListener.class, AudioSink.class).newInstance(var6_19, var7_20, var5_18);
                    n4 = n3 + 1;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                    break block18;
                }
                try {}
                catch (ClassNotFoundException classNotFoundException) {
                    n3 = n4;
                }
                var8_21.add(n3, renderer);
                Log.i(TAG, "Loaded LibflacAudioRenderer.");
                n3 = n4;
            }
            catch (Exception exception) {
                throw new RuntimeException("Error instantiating FLAC extension", exception);
            }
        }
        try {
            var8_21.add(n3, (Renderer)Class.forName("com.google.android.exoplayer2.ext.ffmpeg.FfmpegAudioRenderer").getConstructor(Handler.class, AudioRendererEventListener.class, AudioSink.class).newInstance(var6_19, var7_20, var5_18));
            Log.i(TAG, "Loaded FfmpegAudioRenderer.");
            return;
        }
        catch (Exception exception) {
            throw new RuntimeException("Error instantiating FFmpeg extension", exception);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return;
        }
    }

    protected AudioSink buildAudioSink(Context context, boolean bl, boolean bl2, boolean bl3) {
        return new DefaultAudioSink(AudioCapabilities.getCapabilities((Context)context), new DefaultAudioSink.DefaultAudioProcessorChain(new AudioProcessor[0]), bl, bl2, bl3);
    }

    protected void buildCameraMotionRenderers(Context context, int n2, ArrayList<Renderer> arrayList) {
        arrayList.add((Renderer)new CameraMotionRenderer());
    }

    protected void buildMetadataRenderers(Context context, MetadataOutput metadataOutput, Looper looper, int n2, ArrayList<Renderer> arrayList) {
        arrayList.add((Renderer)new MetadataRenderer(metadataOutput, looper));
    }

    protected void buildMiscellaneousRenderers(Context context, Handler handler, int n2, ArrayList<Renderer> arrayList) {
    }

    protected void buildTextRenderers(Context context, TextOutput textOutput, Looper looper, int n2, ArrayList<Renderer> arrayList) {
        arrayList.add((Renderer)new TextRenderer(textOutput, looper));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void buildVideoRenderers(Context object, int n2, MediaCodecSelector mediaCodecSelector, boolean bl, Handler handler, VideoRendererEventListener videoRendererEventListener, long l2, ArrayList<Renderer> arrayList) {
        int n3;
        void var9_16;
        void var6_14;
        void var5_13;
        void var7_15;
        block11: {
            int n4;
            void var4_12;
            void var3_11;
            MediaCodecVideoRenderer mediaCodecVideoRenderer = new MediaCodecVideoRenderer(object, (MediaCodecSelector)var3_11, (long)var7_15, (boolean)var4_12, (Handler)var5_13, (VideoRendererEventListener)var6_14, 50);
            mediaCodecVideoRenderer.experimentalSetAsynchronousBufferQueueingEnabled(this.enableAsyncQueueing);
            mediaCodecVideoRenderer.experimentalSetForceAsyncQueueingSynchronizationWorkaround(this.forceAsyncQueueingSynchronizationWorkaround);
            mediaCodecVideoRenderer.experimentalSetSynchronizeCodecInteractionsWithQueueingEnabled(this.enableSynchronizeCodecInteractionsWithQueueing);
            var9_16.add(mediaCodecVideoRenderer);
            if (n3 == 0) {
                return;
            }
            int n5 = n4 = var9_16.size();
            if (n3 == 2) {
                n5 = n4 - 1;
            }
            try {
                Renderer renderer;
                try {
                    renderer = (Renderer)Class.forName("com.google.android.exoplayer2.ext.vp9.LibvpxVideoRenderer").getConstructor(Long.TYPE, Handler.class, VideoRendererEventListener.class, Integer.TYPE).newInstance((long)var7_15, var5_13, var6_14, 50);
                    n3 = n5 + 1;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    n3 = n5;
                    break block11;
                }
                try {}
                catch (ClassNotFoundException classNotFoundException) {
                }
                var9_16.add(n5, renderer);
                Log.i(TAG, "Loaded LibvpxVideoRenderer.");
            }
            catch (Exception exception) {
                throw new RuntimeException("Error instantiating VP9 extension", exception);
            }
        }
        try {
            var9_16.add(n3, (Renderer)Class.forName("com.google.android.exoplayer2.ext.av1.Libgav1VideoRenderer").getConstructor(Long.TYPE, Handler.class, VideoRendererEventListener.class, Integer.TYPE).newInstance((long)var7_15, var5_13, var6_14, 50));
            Log.i(TAG, "Loaded Libgav1VideoRenderer.");
            return;
        }
        catch (Exception exception) {
            throw new RuntimeException("Error instantiating AV1 extension", exception);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return;
        }
    }

    public Renderer[] createRenderers(Handler handler, VideoRendererEventListener object, AudioRendererEventListener audioRendererEventListener, TextOutput textOutput, MetadataOutput metadataOutput) {
        ArrayList<Renderer> arrayList = new ArrayList<Renderer>();
        this.buildVideoRenderers(this.context, this.extensionRendererMode, this.mediaCodecSelector, this.enableDecoderFallback, handler, (VideoRendererEventListener)object, this.allowedVideoJoiningTimeMs, arrayList);
        object = this.buildAudioSink(this.context, this.enableFloatOutput, this.enableAudioTrackPlaybackParams, this.enableOffload);
        if (object != null) {
            this.buildAudioRenderers(this.context, this.extensionRendererMode, this.mediaCodecSelector, this.enableDecoderFallback, (AudioSink)object, handler, audioRendererEventListener, arrayList);
        }
        this.buildTextRenderers(this.context, textOutput, handler.getLooper(), this.extensionRendererMode, arrayList);
        this.buildMetadataRenderers(this.context, metadataOutput, handler.getLooper(), this.extensionRendererMode, arrayList);
        this.buildCameraMotionRenderers(this.context, this.extensionRendererMode, arrayList);
        this.buildMiscellaneousRenderers(this.context, handler, this.extensionRendererMode, arrayList);
        return arrayList.toArray(new Renderer[0]);
    }

    public DefaultRenderersFactory experimentalSetAsynchronousBufferQueueingEnabled(boolean bl) {
        this.enableAsyncQueueing = bl;
        return this;
    }

    public DefaultRenderersFactory experimentalSetForceAsyncQueueingSynchronizationWorkaround(boolean bl) {
        this.forceAsyncQueueingSynchronizationWorkaround = bl;
        return this;
    }

    public DefaultRenderersFactory experimentalSetSynchronizeCodecInteractionsWithQueueingEnabled(boolean bl) {
        this.enableSynchronizeCodecInteractionsWithQueueing = bl;
        return this;
    }

    public DefaultRenderersFactory setAllowedVideoJoiningTimeMs(long l2) {
        this.allowedVideoJoiningTimeMs = l2;
        return this;
    }

    public DefaultRenderersFactory setEnableAudioFloatOutput(boolean bl) {
        this.enableFloatOutput = bl;
        return this;
    }

    public DefaultRenderersFactory setEnableAudioOffload(boolean bl) {
        this.enableOffload = bl;
        return this;
    }

    public DefaultRenderersFactory setEnableAudioTrackPlaybackParams(boolean bl) {
        this.enableAudioTrackPlaybackParams = bl;
        return this;
    }

    public DefaultRenderersFactory setEnableDecoderFallback(boolean bl) {
        this.enableDecoderFallback = bl;
        return this;
    }

    public DefaultRenderersFactory setExtensionRendererMode(int n2) {
        this.extensionRendererMode = n2;
        return this;
    }

    public DefaultRenderersFactory setMediaCodecSelector(MediaCodecSelector mediaCodecSelector) {
        this.mediaCodecSelector = mediaCodecSelector;
        return this;
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ExtensionRendererMode {
    }
}

