/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2;

import android.content.Context;
import android.media.AudioFocusRequest;
import android.media.AudioManager;
import android.os.Handler;
import com.google.android.exoplayer2._$;
import com.google.android.exoplayer2.audio.AudioAttributes;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.Util;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

final class AudioFocusManager {
    private static final int AUDIO_FOCUS_STATE_HAVE_FOCUS = 1;
    private static final int AUDIO_FOCUS_STATE_LOSS_TRANSIENT = 2;
    private static final int AUDIO_FOCUS_STATE_LOSS_TRANSIENT_DUCK = 3;
    private static final int AUDIO_FOCUS_STATE_NO_FOCUS = 0;
    public static final int PLAYER_COMMAND_DO_NOT_PLAY = -1;
    public static final int PLAYER_COMMAND_PLAY_WHEN_READY = 1;
    public static final int PLAYER_COMMAND_WAIT_FOR_CALLBACK = 0;
    private static final String TAG = "AudioFocusManager";
    private static final float VOLUME_MULTIPLIER_DEFAULT = 1.0f;
    private static final float VOLUME_MULTIPLIER_DUCK = 0.2f;
    private AudioAttributes audioAttributes;
    private AudioFocusRequest audioFocusRequest;
    private int audioFocusState;
    private final AudioManager audioManager;
    private int focusGain;
    private final AudioFocusListener focusListener;
    private PlayerControl playerControl;
    private boolean rebuildAudioFocusRequest;
    private float volumeMultiplier = 1.0f;

    public AudioFocusManager(Context context, Handler handler, PlayerControl playerControl) {
        this.audioManager = Assertions.checkNotNull((AudioManager)context.getApplicationContext().getSystemService("audio"));
        this.playerControl = playerControl;
        this.focusListener = new AudioFocusListener(handler);
        this.audioFocusState = 0;
    }

    private void abandonAudioFocus() {
        if (this.audioFocusState == 0) {
            return;
        }
        if (Util.SDK_INT >= 26) {
            this.abandonAudioFocusV26();
        } else {
            this.abandonAudioFocusDefault();
        }
        this.setAudioFocusState(0);
    }

    private void abandonAudioFocusDefault() {
        this.audioManager.abandonAudioFocus((AudioManager.OnAudioFocusChangeListener)this.focusListener);
    }

    private void abandonAudioFocusV26() {
        AudioFocusRequest audioFocusRequest = this.audioFocusRequest;
        if (audioFocusRequest != null) {
            this.audioManager.abandonAudioFocusRequest(audioFocusRequest);
        }
    }

    private static int convertAudioAttributesToFocusGain(AudioAttributes audioAttributes) {
        if (audioAttributes == null) {
            return 0;
        }
        switch (audioAttributes.usage) {
            default: {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Unidentified audio usage: ");
                stringBuilder.append(audioAttributes.usage);
                Log.w(TAG, stringBuilder.toString());
                return 0;
            }
            case 16: {
                if (Util.SDK_INT >= 19) {
                    return 4;
                }
                return 2;
            }
            case 11: {
                if (audioAttributes.contentType == 1) {
                    return 2;
                }
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                return 3;
            }
            case 3: {
                return 0;
            }
            case 2: 
            case 4: {
                return 2;
            }
            case 1: 
            case 14: {
                return 1;
            }
            case 0: 
        }
        Log.w(TAG, "Specify a proper usage in the audio attributes for audio focus handling. Using AUDIOFOCUS_GAIN by default.");
        return 1;
    }

    private void executePlayerCommand(int n2) {
        PlayerControl playerControl = this.playerControl;
        if (playerControl != null) {
            playerControl.executePlayerCommand(n2);
        }
    }

    private void handlePlatformAudioFocusChange(int n2) {
        if (n2 != -3 && n2 != -2) {
            if (n2 != -1) {
                if (n2 != 1) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Unknown focus change type: ");
                    stringBuilder.append(n2);
                    Log.w(TAG, stringBuilder.toString());
                    return;
                }
                this.setAudioFocusState(1);
                this.executePlayerCommand(1);
                return;
            }
            this.executePlayerCommand(-1);
            this.abandonAudioFocus();
            return;
        }
        if (n2 != -2 && !this.willPauseWhenDucked()) {
            this.setAudioFocusState(3);
        } else {
            this.executePlayerCommand(0);
            this.setAudioFocusState(2);
        }
    }

    private int requestAudioFocus() {
        if (this.audioFocusState == 1) {
            return 1;
        }
        int n2 = Util.SDK_INT >= 26 ? this.requestAudioFocusV26() : this.requestAudioFocusDefault();
        if (n2 == 1) {
            this.setAudioFocusState(1);
            return 1;
        }
        this.setAudioFocusState(0);
        return -1;
    }

    private int requestAudioFocusDefault() {
        return this.audioManager.requestAudioFocus((AudioManager.OnAudioFocusChangeListener)this.focusListener, Util.getStreamTypeForAudioUsage(Assertions.checkNotNull(this.audioAttributes).usage), this.focusGain);
    }

    private int requestAudioFocusV26() {
        if (this.audioFocusRequest == null || this.rebuildAudioFocusRequest) {
            AudioFocusRequest audioFocusRequest = this.audioFocusRequest;
            audioFocusRequest = audioFocusRequest == null ? new AudioFocusRequest.Builder(this.focusGain) : new AudioFocusRequest.Builder(audioFocusRequest);
            boolean bl = this.willPauseWhenDucked();
            this.audioFocusRequest = audioFocusRequest.setAudioAttributes(Assertions.checkNotNull(this.audioAttributes).getAudioAttributesV21()).setWillPauseWhenDucked(bl).setOnAudioFocusChangeListener((AudioManager.OnAudioFocusChangeListener)this.focusListener).build();
            this.rebuildAudioFocusRequest = false;
        }
        return this.audioManager.requestAudioFocus(this.audioFocusRequest);
    }

    private void setAudioFocusState(int n2) {
        if (this.audioFocusState == n2) {
            return;
        }
        this.audioFocusState = n2;
        float f2 = n2 == 3 ? 0.2f : 1.0f;
        if (this.volumeMultiplier == f2) {
            return;
        }
        this.volumeMultiplier = f2;
        PlayerControl playerControl = this.playerControl;
        if (playerControl != null) {
            playerControl.setVolumeMultiplier(f2);
        }
    }

    private boolean shouldAbandonAudioFocus(int n2) {
        boolean bl;
        boolean bl2 = bl = true;
        if (n2 != 1) {
            bl2 = this.focusGain != 1 ? bl : false;
        }
        return bl2;
    }

    private boolean willPauseWhenDucked() {
        AudioAttributes audioAttributes = this.audioAttributes;
        boolean bl = true;
        if (audioAttributes == null || audioAttributes.contentType != 1) {
            bl = false;
        }
        return bl;
    }

    AudioManager.OnAudioFocusChangeListener getFocusListener() {
        return this.focusListener;
    }

    public float getVolumeMultiplier() {
        return this.volumeMultiplier;
    }

    public void release() {
        this.playerControl = null;
        this.abandonAudioFocus();
    }

    public void setAudioAttributes(AudioAttributes audioAttributes) {
        if (!Util.areEqual(this.audioAttributes, audioAttributes)) {
            boolean bl;
            this.audioAttributes = audioAttributes;
            int n2 = this.focusGain = AudioFocusManager.convertAudioAttributesToFocusGain(audioAttributes);
            boolean bl2 = bl = true;
            if (n2 != 1) {
                bl2 = n2 == 0 ? bl : false;
            }
            Assertions.checkArgument(bl2, "Automatic handling of audio focus is only available for USAGE_MEDIA and USAGE_GAME.");
        }
    }

    public int updateAudioFocus(boolean bl, int n2) {
        boolean bl2 = this.shouldAbandonAudioFocus(n2);
        n2 = -1;
        if (bl2) {
            this.abandonAudioFocus();
            if (bl) {
                n2 = 1;
            }
            return n2;
        }
        if (bl) {
            n2 = this.requestAudioFocus();
        }
        return n2;
    }

    private class AudioFocusListener
    implements AudioManager.OnAudioFocusChangeListener {
        private final Handler eventHandler;

        public AudioFocusListener(Handler handler) {
            this.eventHandler = handler;
        }

        public /* synthetic */ void lambda$onAudioFocusChange$0$AudioFocusManager$AudioFocusListener(int n2) {
            AudioFocusManager.this.handlePlatformAudioFocusChange(n2);
        }

        public void onAudioFocusChange(int n2) {
            this.eventHandler.post((Runnable)new _$.Lambda.AudioFocusManager.AudioFocusListener.0cUcJWkg6g98frTzEcyFa9y2DmA(this, n2));
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PlayerCommand {
    }

    public static interface PlayerControl {
        public void executePlayerCommand(int var1);

        public void setVolumeMultiplier(float var1);
    }
}

