/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.share.widget;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import com.facebook.AccessToken;
import com.facebook.CallbackManager;
import com.facebook.FacebookCallback;
import com.facebook.appevents.InternalAppEventsLogger;
import com.facebook.internal.AppCall;
import com.facebook.internal.CallbackManagerImpl;
import com.facebook.internal.DialogFeature;
import com.facebook.internal.DialogPresenter;
import com.facebook.internal.FacebookDialogBase;
import com.facebook.internal.FragmentWrapper;
import com.facebook.internal.NativeAppCallAttachmentStore;
import com.facebook.internal.Utility;
import com.facebook.share.Sharer;
import com.facebook.share.internal.CameraEffectFeature;
import com.facebook.share.internal.LegacyNativeDialogParameters;
import com.facebook.share.internal.NativeDialogParameters;
import com.facebook.share.internal.OpenGraphActionDialogFeature;
import com.facebook.share.internal.ShareContentValidation;
import com.facebook.share.internal.ShareDialogFeature;
import com.facebook.share.internal.ShareFeedContent;
import com.facebook.share.internal.ShareInternalUtility;
import com.facebook.share.internal.ShareStoryFeature;
import com.facebook.share.internal.WebDialogParameters;
import com.facebook.share.model.ShareCameraEffectContent;
import com.facebook.share.model.ShareContent;
import com.facebook.share.model.ShareLinkContent;
import com.facebook.share.model.ShareMediaContent;
import com.facebook.share.model.ShareOpenGraphContent;
import com.facebook.share.model.SharePhoto;
import com.facebook.share.model.SharePhotoContent;
import com.facebook.share.model.ShareStoryContent;
import com.facebook.share.model.ShareVideoContent;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public final class ShareDialog
extends FacebookDialogBase<ShareContent, Sharer.Result>
implements Sharer {
    private static final int DEFAULT_REQUEST_CODE;
    private static final String FEED_DIALOG = "feed";
    private static final String TAG;
    private static final String WEB_OG_SHARE_DIALOG = "share_open_graph";
    public static final String WEB_SHARE_DIALOG = "share";
    private boolean isAutomaticMode = true;
    private boolean shouldFailOnDataError = false;

    static {
        TAG = ShareDialog.class.getSimpleName();
        DEFAULT_REQUEST_CODE = CallbackManagerImpl.RequestCodeOffset.Share.toRequestCode();
    }

    public ShareDialog(Activity activity) {
        super(activity, DEFAULT_REQUEST_CODE);
        ShareInternalUtility.registerStaticShareCallback((int)DEFAULT_REQUEST_CODE);
    }

    ShareDialog(Activity activity, int n2) {
        super(activity, n2);
        ShareInternalUtility.registerStaticShareCallback((int)n2);
    }

    public ShareDialog(Fragment fragment) {
        this(new FragmentWrapper(fragment));
    }

    ShareDialog(Fragment fragment, int n2) {
        this(new FragmentWrapper(fragment), n2);
    }

    public ShareDialog(androidx.fragment.app.Fragment fragment) {
        this(new FragmentWrapper(fragment));
    }

    ShareDialog(androidx.fragment.app.Fragment fragment, int n2) {
        this(new FragmentWrapper(fragment), n2);
    }

    private ShareDialog(FragmentWrapper fragmentWrapper) {
        super(fragmentWrapper, DEFAULT_REQUEST_CODE);
        ShareInternalUtility.registerStaticShareCallback((int)DEFAULT_REQUEST_CODE);
    }

    private ShareDialog(FragmentWrapper fragmentWrapper, int n2) {
        super(fragmentWrapper, n2);
        ShareInternalUtility.registerStaticShareCallback((int)n2);
    }

    public static boolean canShow(Class<? extends ShareContent> clazz) {
        boolean bl = ShareDialog.canShowWebTypeCheck(clazz) || ShareDialog.canShowNative(clazz);
        return bl;
    }

    private static boolean canShowNative(Class<? extends ShareContent> dialogFeature) {
        boolean bl = (dialogFeature = ShareDialog.getFeature(dialogFeature)) != null && DialogPresenter.canPresentNativeDialogWithFeature(dialogFeature);
        return bl;
    }

    private static boolean canShowWebCheck(ShareContent shareContent) {
        if (!ShareDialog.canShowWebTypeCheck(shareContent.getClass())) {
            return false;
        }
        if (shareContent instanceof ShareOpenGraphContent) {
            shareContent = (ShareOpenGraphContent)shareContent;
            try {
                ShareInternalUtility.toJSONObjectForWeb((ShareOpenGraphContent)shareContent);
            }
            catch (Exception exception) {
                Utility.logd((String)TAG, (String)"canShow returned false because the content of the Opem Graph object can't be shared via the web dialog", (Throwable)exception);
                return false;
            }
        }
        return true;
    }

    private static boolean canShowWebTypeCheck(Class<? extends ShareContent> clazz) {
        boolean bl = ShareLinkContent.class.isAssignableFrom(clazz) || ShareOpenGraphContent.class.isAssignableFrom(clazz) || SharePhotoContent.class.isAssignableFrom(clazz) && AccessToken.isCurrentAccessTokenActive();
        return bl;
    }

    private static DialogFeature getFeature(Class<? extends ShareContent> clazz) {
        if (ShareLinkContent.class.isAssignableFrom(clazz)) {
            return ShareDialogFeature.SHARE_DIALOG;
        }
        if (SharePhotoContent.class.isAssignableFrom(clazz)) {
            return ShareDialogFeature.PHOTOS;
        }
        if (ShareVideoContent.class.isAssignableFrom(clazz)) {
            return ShareDialogFeature.VIDEO;
        }
        if (ShareOpenGraphContent.class.isAssignableFrom(clazz)) {
            return OpenGraphActionDialogFeature.OG_ACTION_DIALOG;
        }
        if (ShareMediaContent.class.isAssignableFrom(clazz)) {
            return ShareDialogFeature.MULTIMEDIA;
        }
        if (ShareCameraEffectContent.class.isAssignableFrom(clazz)) {
            return CameraEffectFeature.SHARE_CAMERA_EFFECT;
        }
        if (ShareStoryContent.class.isAssignableFrom(clazz)) {
            return ShareStoryFeature.SHARE_STORY_ASSET;
        }
        return null;
    }

    private void logDialogShare(Context context, ShareContent object, Mode object2) {
        if (this.isAutomaticMode) {
            object2 = Mode.AUTOMATIC;
        }
        int n2 = 1.$SwitchMap$com$facebook$share$widget$ShareDialog$Mode[object2.ordinal()];
        String string2 = "unknown";
        object2 = n2 != 1 ? (n2 != 2 ? (n2 != 3 ? "unknown" : "native") : "web") : "automatic";
        DialogFeature dialogFeature = ShareDialog.getFeature(object.getClass());
        if (dialogFeature == ShareDialogFeature.SHARE_DIALOG) {
            object = "status";
        } else if (dialogFeature == ShareDialogFeature.PHOTOS) {
            object = "photo";
        } else if (dialogFeature == ShareDialogFeature.VIDEO) {
            object = "video";
        } else {
            object = string2;
            if (dialogFeature == OpenGraphActionDialogFeature.OG_ACTION_DIALOG) {
                object = "open_graph";
            }
        }
        string2 = new InternalAppEventsLogger(context);
        context = new Bundle();
        context.putString("fb_share_dialog_show", (String)object2);
        context.putString("fb_share_dialog_content_type", (String)object);
        string2.logEventImplicitly("fb_share_dialog_show", (Bundle)context);
    }

    public static void show(Activity activity, ShareContent shareContent) {
        new ShareDialog(activity).show(shareContent);
    }

    public static void show(Fragment fragment, ShareContent shareContent) {
        ShareDialog.show(new FragmentWrapper(fragment), shareContent);
    }

    public static void show(androidx.fragment.app.Fragment fragment, ShareContent shareContent) {
        ShareDialog.show(new FragmentWrapper(fragment), shareContent);
    }

    private static void show(FragmentWrapper fragmentWrapper, ShareContent shareContent) {
        new ShareDialog(fragmentWrapper).show(shareContent);
    }

    public boolean canShow(ShareContent shareContent, Mode mode) {
        Object object = mode;
        if (mode == Mode.AUTOMATIC) {
            object = BASE_AUTOMATIC_MODE;
        }
        return this.canShowImpl(shareContent, object);
    }

    protected AppCall createBaseAppCall() {
        return new AppCall(this.getRequestCode());
    }

    protected List<FacebookDialogBase.ModeHandler> getOrderedModeHandlers() {
        ArrayList<FacebookDialogBase.ModeHandler> arrayList = new ArrayList<FacebookDialogBase.ModeHandler>();
        arrayList.add(new NativeHandler());
        arrayList.add(new FeedHandler());
        arrayList.add(new WebShareHandler());
        arrayList.add(new CameraEffectHandler());
        arrayList.add(new ShareStoryHandler());
        return arrayList;
    }

    public boolean getShouldFailOnDataError() {
        return this.shouldFailOnDataError;
    }

    protected void registerCallbackImpl(CallbackManagerImpl callbackManagerImpl, FacebookCallback<Sharer.Result> facebookCallback) {
        ShareInternalUtility.registerSharerCallback((int)this.getRequestCode(), (CallbackManager)callbackManagerImpl, facebookCallback);
    }

    public void setShouldFailOnDataError(boolean bl) {
        this.shouldFailOnDataError = bl;
    }

    public void show(ShareContent shareContent, Mode object) {
        boolean bl = object == Mode.AUTOMATIC;
        this.isAutomaticMode = bl;
        if (this.isAutomaticMode) {
            object = BASE_AUTOMATIC_MODE;
        }
        this.showImpl(shareContent, object);
    }

    private class CameraEffectHandler
    extends FacebookDialogBase.ModeHandler {
        private CameraEffectHandler() {
            super((FacebookDialogBase)ShareDialog.this);
        }

        public boolean canShow(ShareContent shareContent, boolean bl) {
            bl = shareContent instanceof ShareCameraEffectContent && ShareDialog.canShowNative(shareContent.getClass());
            return bl;
        }

        public AppCall createAppCall(final ShareContent shareContent) {
            ShareContentValidation.validateForNativeShare(shareContent);
            final AppCall appCall = ShareDialog.this.createBaseAppCall();
            DialogPresenter.setupAppCallForNativeDialog(appCall, new DialogPresenter.ParameterProvider(ShareDialog.this.getShouldFailOnDataError()){
                final /* synthetic */ boolean val$shouldFailOnDataError;
                {
                    this.val$shouldFailOnDataError = bl;
                }

                @Override
                public Bundle getLegacyParameters() {
                    return LegacyNativeDialogParameters.create((UUID)appCall.getCallId(), (ShareContent)shareContent, (boolean)this.val$shouldFailOnDataError);
                }

                @Override
                public Bundle getParameters() {
                    return NativeDialogParameters.create((UUID)appCall.getCallId(), (ShareContent)shareContent, (boolean)this.val$shouldFailOnDataError);
                }
            }, ShareDialog.getFeature(shareContent.getClass()));
            return appCall;
        }

        public Object getMode() {
            return Mode.NATIVE;
        }
    }

    private class FeedHandler
    extends FacebookDialogBase.ModeHandler {
        private FeedHandler() {
            super((FacebookDialogBase)ShareDialog.this);
        }

        public boolean canShow(ShareContent shareContent, boolean bl) {
            bl = shareContent instanceof ShareLinkContent || shareContent instanceof ShareFeedContent;
            return bl;
        }

        public AppCall createAppCall(ShareContent shareContent) {
            ShareDialog shareDialog = ShareDialog.this;
            shareDialog.logDialogShare((Context)shareDialog.getActivityContext(), shareContent, Mode.FEED);
            shareDialog = ShareDialog.this.createBaseAppCall();
            if (shareContent instanceof ShareLinkContent) {
                shareContent = (ShareLinkContent)shareContent;
                ShareContentValidation.validateForWebShare(shareContent);
                shareContent = WebDialogParameters.createForFeed((ShareLinkContent)shareContent);
            } else {
                shareContent = WebDialogParameters.createForFeed((ShareFeedContent)((ShareFeedContent)shareContent));
            }
            DialogPresenter.setupAppCallForWebDialog((AppCall)shareDialog, ShareDialog.FEED_DIALOG, (Bundle)shareContent);
            return shareDialog;
        }

        public Object getMode() {
            return Mode.FEED;
        }
    }

    public static enum Mode {
        AUTOMATIC,
        NATIVE,
        WEB,
        FEED;

    }

    private class NativeHandler
    extends FacebookDialogBase.ModeHandler {
        private NativeHandler() {
            super((FacebookDialogBase)ShareDialog.this);
        }

        public boolean canShow(ShareContent shareContent, boolean bl) {
            boolean bl2;
            boolean bl3 = bl2 = false;
            if (shareContent != null) {
                bl3 = bl2;
                if (!(shareContent instanceof ShareCameraEffectContent)) {
                    if (shareContent instanceof ShareStoryContent) {
                        bl3 = bl2;
                    } else {
                        if (!bl) {
                            bl3 = shareContent.getShareHashtag() != null ? DialogPresenter.canPresentNativeDialogWithFeature((DialogFeature)ShareDialogFeature.HASHTAG) : true;
                            bl = bl3;
                            if (shareContent instanceof ShareLinkContent) {
                                bl = bl3;
                                if (!Utility.isNullOrEmpty((String)((ShareLinkContent)shareContent).getQuote())) {
                                    bl = bl3 & DialogPresenter.canPresentNativeDialogWithFeature((DialogFeature)ShareDialogFeature.LINK_SHARE_QUOTES);
                                }
                            }
                        } else {
                            bl = true;
                        }
                        bl3 = bl2;
                        if (bl) {
                            bl3 = bl2;
                            if (ShareDialog.canShowNative(shareContent.getClass())) {
                                bl3 = true;
                            }
                        }
                    }
                }
            }
            return bl3;
        }

        public AppCall createAppCall(ShareContent shareContent) {
            ShareDialog shareDialog = ShareDialog.this;
            shareDialog.logDialogShare((Context)shareDialog.getActivityContext(), shareContent, Mode.NATIVE);
            ShareContentValidation.validateForNativeShare(shareContent);
            shareDialog = ShareDialog.this.createBaseAppCall();
            DialogPresenter.setupAppCallForNativeDialog((AppCall)shareDialog, new DialogPresenter.ParameterProvider((AppCall)shareDialog, shareContent, ShareDialog.this.getShouldFailOnDataError()){
                final /* synthetic */ AppCall val$appCall;
                final /* synthetic */ ShareContent val$content;
                final /* synthetic */ boolean val$shouldFailOnDataError;
                {
                    this.val$appCall = appCall;
                    this.val$content = shareContent;
                    this.val$shouldFailOnDataError = bl;
                }

                @Override
                public Bundle getLegacyParameters() {
                    return LegacyNativeDialogParameters.create((UUID)this.val$appCall.getCallId(), (ShareContent)this.val$content, (boolean)this.val$shouldFailOnDataError);
                }

                @Override
                public Bundle getParameters() {
                    return NativeDialogParameters.create((UUID)this.val$appCall.getCallId(), (ShareContent)this.val$content, (boolean)this.val$shouldFailOnDataError);
                }
            }, ShareDialog.getFeature(shareContent.getClass()));
            return shareDialog;
        }

        public Object getMode() {
            return Mode.NATIVE;
        }
    }

    private class ShareStoryHandler
    extends FacebookDialogBase.ModeHandler {
        private ShareStoryHandler() {
            super((FacebookDialogBase)ShareDialog.this);
        }

        public boolean canShow(ShareContent shareContent, boolean bl) {
            bl = shareContent instanceof ShareStoryContent && ShareDialog.canShowNative(shareContent.getClass());
            return bl;
        }

        public AppCall createAppCall(final ShareContent shareContent) {
            ShareContentValidation.validateForStoryShare(shareContent);
            final AppCall appCall = ShareDialog.this.createBaseAppCall();
            DialogPresenter.setupAppCallForNativeDialog(appCall, new DialogPresenter.ParameterProvider(ShareDialog.this.getShouldFailOnDataError()){
                final /* synthetic */ boolean val$shouldFailOnDataError;
                {
                    this.val$shouldFailOnDataError = bl;
                }

                @Override
                public Bundle getLegacyParameters() {
                    return LegacyNativeDialogParameters.create((UUID)appCall.getCallId(), (ShareContent)shareContent, (boolean)this.val$shouldFailOnDataError);
                }

                @Override
                public Bundle getParameters() {
                    return NativeDialogParameters.create((UUID)appCall.getCallId(), (ShareContent)shareContent, (boolean)this.val$shouldFailOnDataError);
                }
            }, ShareDialog.getFeature(shareContent.getClass()));
            return appCall;
        }

        public Object getMode() {
            return Mode.NATIVE;
        }
    }

    private class WebShareHandler
    extends FacebookDialogBase.ModeHandler {
        private WebShareHandler() {
            super((FacebookDialogBase)ShareDialog.this);
        }

        private SharePhotoContent createAndMapAttachments(SharePhotoContent sharePhotoContent, UUID uUID) {
            SharePhotoContent.Builder builder = new SharePhotoContent.Builder().readFrom(sharePhotoContent);
            ArrayList<SharePhoto> arrayList = new ArrayList<SharePhoto>();
            ArrayList<Bitmap> arrayList2 = new ArrayList<Bitmap>();
            for (int i2 = 0; i2 < sharePhotoContent.getPhotos().size(); ++i2) {
                SharePhoto sharePhoto = (SharePhoto)((Object)sharePhotoContent.getPhotos().get(i2));
                Bitmap bitmap = sharePhoto.getBitmap();
                SharePhoto sharePhoto2 = sharePhoto;
                if (bitmap != null) {
                    bitmap = NativeAppCallAttachmentStore.createAttachment((UUID)uUID, (Bitmap)bitmap);
                    sharePhoto2 = new SharePhoto.Builder().readFrom(sharePhoto).setImageUrl(Uri.parse((String)bitmap.getAttachmentUrl())).setBitmap(null).build();
                    arrayList2.add(bitmap);
                }
                arrayList.add(sharePhoto2);
            }
            builder.setPhotos(arrayList);
            NativeAppCallAttachmentStore.addAttachments(arrayList2);
            return builder.build();
        }

        private String getActionName(ShareContent shareContent) {
            if (!(shareContent instanceof ShareLinkContent) && !(shareContent instanceof SharePhotoContent)) {
                if (shareContent instanceof ShareOpenGraphContent) {
                    return ShareDialog.WEB_OG_SHARE_DIALOG;
                }
                return null;
            }
            return ShareDialog.WEB_SHARE_DIALOG;
        }

        public boolean canShow(ShareContent shareContent, boolean bl) {
            bl = shareContent != null && ShareDialog.canShowWebCheck(shareContent);
            return bl;
        }

        public AppCall createAppCall(ShareContent shareContent) {
            ShareDialog shareDialog = ShareDialog.this;
            shareDialog.logDialogShare((Context)shareDialog.getActivityContext(), shareContent, Mode.WEB);
            AppCall appCall = ShareDialog.this.createBaseAppCall();
            ShareContentValidation.validateForWebShare(shareContent);
            shareDialog = shareContent instanceof ShareLinkContent ? WebDialogParameters.create((ShareLinkContent)((ShareLinkContent)shareContent)) : (shareContent instanceof SharePhotoContent ? WebDialogParameters.create((SharePhotoContent)this.createAndMapAttachments((SharePhotoContent)shareContent, appCall.getCallId())) : WebDialogParameters.create((ShareOpenGraphContent)((ShareOpenGraphContent)shareContent)));
            DialogPresenter.setupAppCallForWebDialog(appCall, this.getActionName(shareContent), (Bundle)shareDialog);
            return appCall;
        }

        public Object getMode() {
            return Mode.WEB;
        }
    }
}

