/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.share.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.facebook.share.model.ShareContent;
import com.facebook.share.model.ShareModel;
import com.facebook.share.model.SharePhoto;
import com.facebook.share.model.ShareVideo;

public final class ShareVideoContent
extends ShareContent<ShareVideoContent, Builder>
implements ShareModel {
    public static final Parcelable.Creator<ShareVideoContent> CREATOR = new Parcelable.Creator<ShareVideoContent>(){

        public ShareVideoContent createFromParcel(Parcel parcel) {
            return new ShareVideoContent(parcel);
        }

        public ShareVideoContent[] newArray(int n2) {
            return new ShareVideoContent[n2];
        }
    };
    private final String contentDescription;
    private final String contentTitle;
    private final SharePhoto previewPhoto;
    private final ShareVideo video;

    ShareVideoContent(Parcel parcel) {
        super(parcel);
        this.contentDescription = parcel.readString();
        this.contentTitle = parcel.readString();
        SharePhoto.Builder builder = new SharePhoto.Builder().readFrom(parcel);
        this.previewPhoto = builder.getImageUrl() == null && builder.getBitmap() == null ? null : builder.build();
        this.video = new ShareVideo.Builder().readFrom(parcel).build();
    }

    private ShareVideoContent(Builder builder) {
        super((ShareContent.Builder)builder);
        this.contentDescription = builder.contentDescription;
        this.contentTitle = builder.contentTitle;
        this.previewPhoto = builder.previewPhoto;
        this.video = builder.video;
    }

    public int describeContents() {
        return 0;
    }

    public String getContentDescription() {
        return this.contentDescription;
    }

    public String getContentTitle() {
        return this.contentTitle;
    }

    public SharePhoto getPreviewPhoto() {
        return this.previewPhoto;
    }

    public ShareVideo getVideo() {
        return this.video;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        super.writeToParcel(parcel, n2);
        parcel.writeString(this.contentDescription);
        parcel.writeString(this.contentTitle);
        parcel.writeParcelable((Parcelable)this.previewPhoto, 0);
        parcel.writeParcelable((Parcelable)this.video, 0);
    }

    public static final class Builder
    extends ShareContent.Builder<ShareVideoContent, Builder> {
        private String contentDescription;
        private String contentTitle;
        private SharePhoto previewPhoto;
        private ShareVideo video;

        public ShareVideoContent build() {
            return new ShareVideoContent(this);
        }

        public Builder readFrom(ShareVideoContent shareVideoContent) {
            if (shareVideoContent == null) {
                return this;
            }
            return ((Builder)super.readFrom((ShareContent)shareVideoContent)).setContentDescription(shareVideoContent.getContentDescription()).setContentTitle(shareVideoContent.getContentTitle()).setPreviewPhoto(shareVideoContent.getPreviewPhoto()).setVideo(shareVideoContent.getVideo());
        }

        public Builder setContentDescription(String string2) {
            this.contentDescription = string2;
            return this;
        }

        public Builder setContentTitle(String string2) {
            this.contentTitle = string2;
            return this;
        }

        public Builder setPreviewPhoto(SharePhoto sharePhoto) {
            sharePhoto = sharePhoto == null ? null : new SharePhoto.Builder().readFrom(sharePhoto).build();
            this.previewPhoto = sharePhoto;
            return this;
        }

        public Builder setVideo(ShareVideo shareVideo) {
            if (shareVideo == null) {
                return this;
            }
            this.video = new ShareVideo.Builder().readFrom(shareVideo).build();
            return this;
        }
    }
}

